/*
 * Decompiled with CFR 0.152.
 */
package viz.process;

import java.io.PrintStream;
import viz.DensiTree;
import viz.Node;
import viz.process.BranchScorer;
import viz.process.CladeBranchInfo;

public class BranchLengthOptimiser {
    DensiTree m_dt;
    BranchScorer scorer;
    static final int MAX_ATTEMPTS = 500;
    static final float RANGE = 100.0f;

    public BranchLengthOptimiser(DensiTree dt) {
        this.m_dt = dt;
    }

    public void optimiseScore(Node tree) {
        long start = System.currentTimeMillis();
        float[] heights = new float[this.m_dt.m_sLabels.size() * 2 - 1];
        Node[] nodes = new Node[this.m_dt.m_sLabels.size() * 2 - 1];
        this.collectNodes(tree, nodes, heights, tree.m_fPosY);
        this.scorer = new BranchScorer(this.m_dt, nodes);
        double startscore = this.scorer.score(heights);
        this.initialiseTree(heights, nodes);
        long start2 = System.currentTimeMillis();
        this.optimiseTree(heights, nodes, this.scorer);
        int i = 0;
        while (i < nodes.length - 1) {
            nodes[i].m_fLength = heights[i] - heights[nodes[i].getParent().getNr()];
            ++i;
        }
        long end = System.currentTimeMillis();
        System.err.println("\n\n\n" + (double)(end - start) / 1000.0 + " seconds optimising " + (double)(start2 - start) / 1000.0 + " seconds initialising");
        double endscore = this.scorer.score(heights);
        System.err.println("Start score: " + startscore + " End score: " + endscore + "\n\n\n");
        if (this.m_dt.m_sOptFile != null) {
            try {
                PrintStream out = new PrintStream(this.m_dt.m_sOptFile);
                out.println(tree.toString(this.m_dt.m_sLabels, false));
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }

    void optimiseTree(float[] heights, Node[] nodes, BranchScorer scorer) {
        boolean bProgress = true;
        int i = 0;
        while (i < 500 && bProgress) {
            bProgress = false;
            int k = nodes.length / 2 + 1;
            while (k < nodes.length) {
                float bestHeight;
                float maxHeight;
                Node node = nodes[k];
                int iCladeLeft = node.m_left.m_iClade;
                int iCladeRight = node.m_right.m_iClade;
                float leftHeight = heights[node.m_left.m_iLabel];
                float rightHeight = heights[node.m_right.m_iLabel];
                float minHeight = Math.min(leftHeight, rightHeight);
                if (node.isRoot()) {
                    CladeBranchInfo infoLeft = scorer.m_cladeBranchInfo.get(iCladeLeft);
                    CladeBranchInfo infoRight = scorer.m_cladeBranchInfo.get(iCladeRight);
                    maxHeight = Math.min(leftHeight - infoLeft.getMaxLength(), rightHeight - infoRight.getMaxLength());
                } else {
                    maxHeight = heights[node.getParent().getNr()];
                }
                heights[k] = bestHeight = heights[node.getNr()];
                double bestScore = scorer.score(heights);
                int j = 1;
                while ((float)j < 100.0f) {
                    float height;
                    heights[k] = height = (float)j * (maxHeight - minHeight) / 100.0f + minHeight;
                    double score = scorer.score(heights);
                    if (score < bestScore) {
                        bProgress = true;
                        bestScore = score;
                        bestHeight = height;
                    }
                    ++j;
                }
                heights[k] = bestHeight;
                ++k;
            }
            System.err.print(".");
            ++i;
        }
    }

    private void initialiseTree(float[] heights, Node[] nodes) {
        int k = this.m_dt.m_sLabels.size();
        while (k < nodes.length) {
            Node node = nodes[k];
            CladeBranchInfo infoLeft = this.scorer.m_cladeBranchInfo.get(node.m_left.m_iClade);
            CladeBranchInfo infoRight = this.scorer.m_cladeBranchInfo.get(node.m_right.m_iClade);
            float leftHeight = heights[node.m_left.m_iLabel];
            float rightHeight = heights[node.m_right.m_iLabel];
            float minHeight = Math.min(leftHeight, rightHeight);
            float maxHeight = Math.min(leftHeight - infoLeft.getMaxLength(), rightHeight - infoRight.getMaxLength());
            float bestHeight = Math.min(minHeight, heights[node.m_iLabel]);
            float bestScore = infoLeft.score(bestHeight, leftHeight) + infoRight.score(bestHeight, rightHeight);
            int j = 2;
            while ((float)j < 100.0f) {
                float height = (float)j * (maxHeight - minHeight) / 100.0f + minHeight;
                float score = infoLeft.score(height, leftHeight) + infoRight.score(height, rightHeight);
                if (score < bestScore) {
                    bestScore = score;
                    bestHeight = height;
                }
                ++j;
            }
            heights[k] = bestHeight;
            if (!node.isRoot()) {
                node.m_fLength = bestHeight - heights[node.getParent().m_iLabel];
            }
            node.m_left.m_fLength = leftHeight - bestHeight;
            node.m_right.m_fLength = rightHeight - bestHeight;
            ++k;
        }
    }

    private void collectNodes(Node node, Node[] nodes, float[] heights, float height) {
        nodes[node.m_iLabel] = node;
        heights[node.m_iLabel] = height;
        if (!node.isLeaf()) {
            this.collectNodes(node.m_left, nodes, heights, height + node.m_left.m_fLength);
            this.collectNodes(node.m_right, nodes, heights, height + node.m_right.m_fLength);
        }
    }
}

