/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.Beauti;
import beast.app.util.Utils;
import beast.core.util.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GuessPatternDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static String TRAIT_FILE_HELP_MESSAGE = "This option allows trait values (such as species, tip dates and sample locations) to be specified  using a file which links each taxon with a trait value.  The file must contain one row per taxon, with each row containing the taxon name and the trait value separated by a TAB (not a space!) character.\n\nFor instance, a file specifying the ages of three taxa named taxonA, taxonB and taxonC should contain the following:\n\ntaxonA 0.0\ntaxonB 0.1\ntaxonC 0.2\n\nwhere the gap between each taxon name and the numeric value representing the age must be a TAB.";
    public String trait = null;
    Component m_parent;
    JPanel guessPanel;
    ButtonGroup group;
    JRadioButton useEverything = new JRadioButton("use everything");
    JRadioButton isSplitOnChar = new JRadioButton("split on character");
    JRadioButton useRegexp = new JRadioButton("use regular expression");
    JRadioButton readFromFile = new JRadioButton("read from file");
    int m_location = 0;
    int m_splitlocation = 0;
    String m_sDelimiter = ".";
    JTextField textRegExp;
    JComboBox<String> combo;
    JComboBox<String> combo_1;
    String pattern;
    private JTextField txtFile;
    private JTextField textSplitChar;
    private JTextField textSplitChar2;
    private JTextField textAddValue;
    private JTextField textUnlessLessThan;
    private JTextField textThenAdd;
    JCheckBox chckbxAddFixedValue;
    JCheckBox chckbxUnlessLessThan;
    JLabel lblThenAdd;
    JLabel lblAndTakeGroups;
    JButton btnBrowse;
    private JSeparator separator_2;
    private JSeparator separator_3;
    private JSeparator separator_4;
    private JSeparator separator_5;

    public String getTrait() {
        return this.trait;
    }

    public String getPattern() {
        return this.pattern;
    }

    public GuessPatternDialog(Component component, String string) {
        this.m_parent = component;
        this.pattern = string;
        this.guessPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 20, 0, 0, 20, 0, 0, 20, 0, 29, 0, 0, 0, 0};
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, 0.0, 1.0, 0.0};
        this.guessPanel.setLayout(gridBagLayout);
        this.group = new ButtonGroup();
        this.group.add(this.useEverything);
        this.group.add(this.isSplitOnChar);
        this.group.add(this.useRegexp);
        this.group.add(this.readFromFile);
        this.group.setSelected(this.useEverything.getModel(), true);
        this.useEverything.addActionListener(actionEvent -> this.updateFields());
        this.useEverything.setName(this.useEverything.getText());
        this.isSplitOnChar.addActionListener(actionEvent -> this.updateFields());
        this.isSplitOnChar.setName(this.isSplitOnChar.getText());
        this.useRegexp.addActionListener(actionEvent -> this.updateFields());
        this.useRegexp.setName(this.useRegexp.getText());
        this.readFromFile.addActionListener(actionEvent -> this.updateFields());
        this.readFromFile.setName(this.readFromFile.getText());
        this.createDelimiterBox(this.useEverything);
        this.createSplitBox(this.isSplitOnChar);
        this.createRegExtpBox(this.useRegexp);
        this.textRegExp = new JTextField();
        this.textRegExp.setText(string);
        this.textRegExp.setColumns(10);
        this.textRegExp.setToolTipText("Enter regular expression to match taxa");
        int n = this.textRegExp.getFont().getSize();
        this.textRegExp.setMaximumSize(new Dimension(1024 * n / 13, 25 * n / 13));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.guessPanel.add((Component)this.textRegExp, gridBagConstraints);
        this.textRegExp.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GuessPatternDialog.this.useRegexp.setSelected(true);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GuessPatternDialog.this.useRegexp.setSelected(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GuessPatternDialog.this.useRegexp.setSelected(true);
            }
        });
        this.separator_4 = new JSeparator();
        this.separator_4.setPreferredSize(new Dimension(5, 1));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 5;
        gridBagConstraints2.insets = new Insets(5, 0, 15, 5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.fill = 2;
        this.guessPanel.add((Component)this.separator_4, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 10;
        this.guessPanel.add((Component)this.readFromFile, gridBagConstraints3);
        this.btnBrowse = new JButton("Browse");
        this.btnBrowse.addActionListener(actionEvent -> {
            File file = Utils.getLoadFile("Load trait from file", new File(Beauti.g_sDir), "Select trait file", "dat", "txt");
            if (file != null) {
                this.txtFile.setText(file.getPath());
                this.readFromFile.setSelected(true);
                this.updateFields();
            }
        });
        this.txtFile = new JTextField();
        this.txtFile.setText("File");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 10;
        this.guessPanel.add((Component)this.txtFile, gridBagConstraints4);
        this.txtFile.setColumns(10);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 3;
        gridBagConstraints5.gridy = 10;
        this.guessPanel.add((Component)this.btnBrowse, gridBagConstraints5);
        JButton jButton = new JButton("?");
        jButton.setToolTipText("Show format of trait file");
        jButton.addActionListener(actionEvent -> {
            JOptionPane jOptionPane = new JOptionPane(){

                @Override
                public int getMaxCharactersPerLineCount() {
                    return 70;
                }
            };
            jOptionPane.setMessage(TRAIT_FILE_HELP_MESSAGE);
            jOptionPane.setMessageType(1);
            JDialog jDialog = jOptionPane.createDialog(this, "Message");
            jDialog.setModal(true);
            jDialog.setVisible(true);
        });
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridx = 4;
        gridBagConstraints6.gridy = 10;
        this.guessPanel.add((Component)jButton, gridBagConstraints6);
        this.chckbxAddFixedValue = new JCheckBox("Add fixed value");
        this.chckbxAddFixedValue.setName("Add fixed value");
        this.chckbxAddFixedValue.addActionListener(actionEvent -> this.updateFields());
        this.separator_5 = new JSeparator();
        this.separator_5.setPreferredSize(new Dimension(5, 1));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridwidth = 5;
        gridBagConstraints7.insets = new Insets(5, 0, 15, 5);
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 12;
        gridBagConstraints7.fill = 2;
        this.guessPanel.add((Component)this.separator_5, gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 13;
        this.guessPanel.add((Component)this.chckbxAddFixedValue, gridBagConstraints8);
        this.textAddValue = new JTextField("1900");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridwidth = 2;
        gridBagConstraints9.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.gridx = 1;
        gridBagConstraints9.gridy = 13;
        this.guessPanel.add((Component)this.textAddValue, gridBagConstraints9);
        this.textAddValue.setColumns(10);
        this.chckbxUnlessLessThan = new JCheckBox("Unless less than...");
        this.chckbxUnlessLessThan.setName("Unless less than");
        this.chckbxUnlessLessThan.addActionListener(actionEvent -> this.updateFields());
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 17;
        gridBagConstraints10.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 14;
        this.guessPanel.add((Component)this.chckbxUnlessLessThan, gridBagConstraints10);
        this.textUnlessLessThan = new JTextField("13");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridwidth = 2;
        gridBagConstraints11.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 14;
        this.guessPanel.add((Component)this.textUnlessLessThan, gridBagConstraints11);
        this.textUnlessLessThan.setColumns(10);
        this.lblThenAdd = new JLabel("...then add");
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.anchor = 13;
        gridBagConstraints12.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 15;
        this.guessPanel.add((Component)this.lblThenAdd, gridBagConstraints12);
        this.textThenAdd = new JTextField("2000");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridwidth = 2;
        gridBagConstraints13.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 15;
        this.guessPanel.add((Component)this.textThenAdd, gridBagConstraints13);
        this.textThenAdd.setColumns(10);
        this.chckbxAddFixedValue.setVisible(false);
        this.textAddValue.setVisible(false);
        this.chckbxUnlessLessThan.setVisible(false);
        this.lblThenAdd.setVisible(false);
        this.chckbxUnlessLessThan.setVisible(false);
        this.textUnlessLessThan.setVisible(false);
        this.textThenAdd.setVisible(false);
    }

    public void allowAddingValues() {
        this.chckbxAddFixedValue.setVisible(true);
        this.textAddValue.setVisible(true);
        this.chckbxUnlessLessThan.setVisible(true);
        this.lblThenAdd.setVisible(true);
        this.chckbxUnlessLessThan.setVisible(true);
        this.textUnlessLessThan.setVisible(true);
        this.textThenAdd.setVisible(true);
    }

    protected void updateFields() {
        if (this.chckbxAddFixedValue.isSelected()) {
            this.textAddValue.setEnabled(true);
            this.chckbxUnlessLessThan.setEnabled(true);
            this.lblThenAdd.setEnabled(true);
            if (this.chckbxUnlessLessThan.isSelected()) {
                this.textUnlessLessThan.setEnabled(true);
                this.textThenAdd.setEnabled(true);
            } else {
                this.textUnlessLessThan.setEnabled(false);
                this.textThenAdd.setEnabled(false);
            }
        } else {
            this.textAddValue.setEnabled(false);
            this.chckbxUnlessLessThan.setEnabled(false);
            this.lblThenAdd.setEnabled(false);
            this.textUnlessLessThan.setEnabled(false);
            this.textThenAdd.setEnabled(false);
        }
        this.txtFile.setEnabled(false);
        this.textSplitChar.setEnabled(false);
        this.textSplitChar2.setEnabled(false);
        this.textRegExp.setEnabled(false);
        this.combo.setEnabled(false);
        this.combo_1.setEnabled(false);
        this.lblAndTakeGroups.setEnabled(false);
        this.btnBrowse.setEnabled(false);
        if (this.useEverything.isSelected()) {
            this.textSplitChar.setEnabled(true);
            this.combo.setEnabled(true);
        }
        if (this.isSplitOnChar.isSelected()) {
            this.textSplitChar2.setEnabled(true);
            this.combo_1.setEnabled(true);
            this.lblAndTakeGroups.setEnabled(true);
        }
        if (this.useRegexp.isSelected()) {
            this.textRegExp.setEnabled(true);
        }
        if (this.readFromFile.isSelected()) {
            this.btnBrowse.setEnabled(true);
            this.txtFile.setEnabled(true);
        }
    }

    private void createDelimiterBox(JRadioButton jRadioButton) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.guessPanel.add((Component)jRadioButton, gridBagConstraints);
        this.combo = new JComboBox<String>(new String[]{"after first", "after last", "before first", "before last"});
        this.combo.setName("delimiterCombo");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        this.guessPanel.add(this.combo, gridBagConstraints2);
        this.combo.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.m_location = jComboBox.getSelectedIndex();
            this.useEverything.setSelected(true);
            this.updateFields();
        });
    }

    private void createSplitBox(JRadioButton jRadioButton) {
        this.textSplitChar = new JTextField("_");
        this.textSplitChar.setName("SplitChar");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.guessPanel.add((Component)this.textSplitChar, gridBagConstraints);
        this.textSplitChar.setColumns(2);
        this.separator_2 = new JSeparator();
        this.separator_2.setPreferredSize(new Dimension(5, 1));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 5;
        gridBagConstraints2.insets = new Insets(5, 0, 15, 5);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        this.guessPanel.add((Component)this.separator_2, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 4;
        this.guessPanel.add((Component)jRadioButton, gridBagConstraints3);
    }

    public void createRegExtpBox(JRadioButton jRadioButton) {
        this.textSplitChar2 = new JTextField("_");
        this.textSplitChar2.setName("SplitChar2");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.guessPanel.add((Component)this.textSplitChar2, gridBagConstraints);
        this.textSplitChar2.setColumns(2);
        this.lblAndTakeGroups = new JLabel("and take group(s):");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 4;
        this.guessPanel.add((Component)this.lblAndTakeGroups, gridBagConstraints2);
        this.combo_1 = new JComboBox<String>(new String[]{"1", "2", "3", "4", "1-2", "2-3", "3-4", "1-3", "2-4"});
        this.combo_1.setName("splitCombo");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.gridy = 4;
        this.guessPanel.add(this.combo_1, gridBagConstraints3);
        this.combo_1.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.m_splitlocation = jComboBox.getSelectedIndex();
            this.isSplitOnChar.setSelected(true);
            this.updateFields();
        });
        this.separator_3 = new JSeparator();
        this.separator_3.setPreferredSize(new Dimension(5, 1));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 5;
        gridBagConstraints4.insets = new Insets(5, 0, 15, 5);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 5;
        gridBagConstraints4.fill = 2;
        this.guessPanel.add((Component)this.separator_3, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 7;
        this.guessPanel.add((Component)jRadioButton, gridBagConstraints5);
    }

    public Status showDialog(String string) {
        Object object;
        JOptionPane jOptionPane = new JOptionPane(this.guessPanel, -1, 2, null, new String[]{"Cancel", "OK"}, "OK");
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        JDialog jDialog = jOptionPane.createDialog(this.m_parent, string);
        jDialog.setName("GuessTaxonSets");
        jDialog.pack();
        this.updateFields();
        jDialog.setVisible(true);
        if (jOptionPane.getValue() == null || !jOptionPane.getValue().equals("OK")) {
            return Status.canceled;
        }
        if (this.useEverything.getModel() == this.group.getSelection()) {
            object = this.normalise(this.textSplitChar.getText());
            switch (this.m_location) {
                case 0: {
                    this.pattern = "^[^" + (String)object + "]+" + (String)object + "(.*)$";
                    break;
                }
                case 1: {
                    this.pattern = "^.*" + (String)object + "(.*)$";
                    break;
                }
                case 2: {
                    this.pattern = "^([^" + (String)object + "]+)" + (String)object + ".*$";
                    break;
                }
                case 3: {
                    this.pattern = "^(.*)" + (String)object + ".*$";
                }
            }
        }
        if (this.isSplitOnChar.getModel() == this.group.getSelection()) {
            object = this.normalise(this.textSplitChar2.getText());
            switch (this.m_splitlocation) {
                case 0: {
                    this.pattern = "^([^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 1: {
                    this.pattern = "^[^" + (String)object + "]+" + (String)object + "([^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 2: {
                    this.pattern = "^[^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+" + (String)object + "([^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 3: {
                    this.pattern = "^[^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+" + (String)object + "([^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 4: {
                    this.pattern = "^([^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 5: {
                    this.pattern = "^[^" + (String)object + "]+" + (String)object + "([^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 6: {
                    this.pattern = "^[^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+" + (String)object + "([^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 7: {
                    this.pattern = "^([^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+)" + ".*$";
                    break;
                }
                case 8: {
                    this.pattern = "^[^" + (String)object + "]+" + (String)object + "([^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+" + (String)object + "[^" + (String)object + "]+)" + ".*$";
                }
            }
        }
        if (this.useRegexp.getModel() == this.group.getSelection()) {
            this.pattern = this.textRegExp.getText();
        }
        if (this.readFromFile.getModel() == this.group.getSelection()) {
            try {
                object = new BufferedReader(new FileReader(this.txtFile.getText()));
                StringBuffer stringBuffer = new StringBuffer();
                while (((BufferedReader)object).ready()) {
                    String string2 = ((BufferedReader)object).readLine();
                    if ((string2 = string2.replaceFirst("\t", "=") + ",").indexOf("=") <= 0 || string2.matches("^\\s+=.*$")) continue;
                    stringBuffer.append(string2);
                }
                ((BufferedReader)object).close();
                this.trait = stringBuffer.toString().trim();
                while (this.trait.endsWith(",")) {
                    this.trait = this.trait.substring(0, this.trait.length() - 1).trim();
                }
                if (this.trait.trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.m_parent, "Could not find trait information in the file. Perhaps this is not a tab-delimited but space file?");
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.m_parent, "Loading trait from file failed:" + exception.getMessage());
                return Status.canceled;
            }
            return Status.trait;
        }
        try {
            this.pattern.matches(this.pattern);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            JOptionPane.showMessageDialog(this, "This is not a valid regular expression");
            return Status.canceled;
        }
        if (jOptionPane.getValue() != null && jOptionPane.getValue().equals("OK")) {
            Log.warning.println("Pattern = " + this.pattern);
            return Status.pattern;
        }
        return Status.canceled;
    }

    private String normalise(String string) {
        if (string.length() == 0) {
            return ".";
        }
        return String.format("\\0%o", string.charAt(0));
    }

    public String match(String string) {
        Pattern pattern = Pattern.compile(this.pattern);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            if (this.chckbxAddFixedValue.isSelected()) {
                try {
                    Double d = Double.parseDouble(string2);
                    Double d2 = Double.parseDouble(this.textAddValue.getText());
                    if (this.chckbxUnlessLessThan.isSelected()) {
                        Double d3 = Double.parseDouble(this.textUnlessLessThan.getText());
                        Double d4 = Double.parseDouble(this.textThenAdd.getText());
                        d = d < d3 ? Double.valueOf(d + d4) : Double.valueOf(d + d2);
                    } else {
                        d = d + d2;
                    }
                    return d + "";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string2;
        }
        return null;
    }

    public static enum Status {
        canceled,
        pattern,
        trait;

    }
}

