/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.PartitionContext;
import beast.app.draw.BEASTObjectInputEditor;
import beast.app.draw.InputEditor;
import beast.app.util.Utils;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.Parameter;
import beast.core.util.Log;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.math.distributions.ParametricDistribution;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class ParameterInputEditor
extends BEASTObjectInputEditor {
    boolean isParametricDistributionParameter = false;
    private static final long serialVersionUID = 1L;
    public JCheckBox m_isEstimatedBox;

    public ParameterInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return Parameter.Base.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        super.init(input, bEASTInterface, n, expandOption, bl);
        this.m_beastObject = bEASTInterface;
    }

    @Override
    protected void initEntry() {
        if (this.m_input.get() != null) {
            if (this.itemNr < 0) {
                Parameter.Base base = (Parameter.Base)this.m_input.get();
                String string = "";
                for (Object t : base.valuesInput.get()) {
                    string = string + t + " ";
                }
                this.m_entry.setText(string);
            } else {
                Parameter.Base base = (Parameter.Base)((List)this.m_input.get()).get(this.itemNr);
                String string = "";
                for (Object t : base.valuesInput.get()) {
                    string = string + t + " ";
                }
                this.m_entry.setText(string);
            }
        }
    }

    @Override
    protected void processEntry() {
        try {
            String string = this.m_entry.getText();
            Parameter.Base base = (Parameter.Base)this.m_input.get();
            String string2 = "";
            for (Object t : base.valuesInput.get()) {
                string2 = string2 + t + " ";
            }
            int n = base.getDimension();
            base.valuesInput.setValue(string, base);
            base.initAndValidate();
            int n2 = base.getDimension();
            if (n != n2) {
                base.setDimension(n);
                base.valuesInput.setValue(string2, base);
                base.initAndValidate();
                throw new IllegalArgumentException("Entry caused change in dimension");
            }
            this.validateInput();
        }
        catch (Exception exception) {
            this.m_validateLabel.setVisible(true);
            this.m_validateLabel.setToolTipText("<html><p>Parsing error: " + exception.getMessage() + ". Value was left at " + this.m_input.get() + ".</p></html>");
            this.m_validateLabel.m_circleColor = Color.orange;
            this.repaint();
        }
    }

    @Override
    protected void addComboBox(JComponent jComponent, Input<?> input, BEASTInterface bEASTInterface) {
        Box box = Box.createHorizontalBox();
        Parameter.Base base = null;
        base = this.itemNr >= 0 ? (Parameter.Base)((List)input.get()).get(this.itemNr) : (Parameter.Base)input.get();
        if (base == null) {
            super.addComboBox(jComponent, input, bEASTInterface);
        } else {
            boolean bl;
            this.setUpEntry();
            box.add(this.m_entry);
            if (this.doc.allowLinking && ((bl = this.doc.isLinked(this.m_input)) || this.doc.suggestedLinks((BEASTInterface)this.m_input.get()).size() > 0)) {
                Iterator<BEASTInterface> iterator = new JButton(Utils.getIcon("beast/app/beauti/" + (bl ? "link.png" : "unlink.png")));
                ((JComponent)((Object)iterator)).setBorder(BorderFactory.createEmptyBorder());
                ((JComponent)((Object)iterator)).setToolTipText("link/unlink this parameter with another compatible parameter");
                ((AbstractButton)((Object)iterator)).addActionListener(actionEvent -> {
                    if (this.doc.isLinked(this.m_input)) {
                        try {
                            BEASTInterface bEASTInterface = this.doc.getUnlinkCandidate(this.m_input, this.m_beastObject);
                            this.m_input.setValue(bEASTInterface, this.m_beastObject);
                            this.doc.deLink(this.m_input);
                        }
                        catch (RuntimeException runtimeException) {
                            runtimeException.printStackTrace();
                            JOptionPane.showMessageDialog(this, "Could not unlink: " + runtimeException.getMessage());
                        }
                    } else {
                        List<BEASTInterface> list = this.doc.suggestedLinks((BEASTInterface)this.m_input.get());
                        JComboBox<BEASTInterface> jComboBox = new JComboBox<BEASTInterface>(list.toArray(new BEASTInterface[0]));
                        JOptionPane.showMessageDialog(null, jComboBox, "select parameter to link with", 3);
                        BEASTInterface bEASTInterface = (BEASTInterface)jComboBox.getSelectedItem();
                        if (bEASTInterface != null) {
                            try {
                                this.m_input.setValue(bEASTInterface, this.m_beastObject);
                                this.doc.addLink(this.m_input);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    this.refreshPanel();
                });
                box.add((Component)((Object)iterator));
            }
            box.add(Box.createHorizontalGlue());
            this.m_isEstimatedBox = new JCheckBox(this.doc.beautiConfig.getInputLabel(base, base.isEstimatedInput.getName()));
            this.m_isEstimatedBox.setName(input.getName() + ".isEstimated");
            if (input.get() != null) {
                this.m_isEstimatedBox.setSelected((Boolean)base.isEstimatedInput.get());
            }
            this.m_isEstimatedBox.setToolTipText(base.isEstimatedInput.getHTMLTipText());
            bl = false;
            for (Object object : base.getOutputs()) {
                if (!(object instanceof BranchRateModel.Base)) continue;
                bl |= ((BranchRateModel.Base)object).meanRateInput.get() == base;
            }
            this.m_isEstimatedBox.setEnabled(!bl || !this.getDoc().autoSetClockRate);
            this.m_isEstimatedBox.addActionListener(actionEvent -> {
                try {
                    Parameter.Base base = (Parameter.Base)this.m_input.get();
                    base.isEstimatedInput.setValue(this.m_isEstimatedBox.isSelected(), base);
                    if (this.isParametricDistributionParameter) {
                        Object object;
                        String string = base.getID();
                        if (string.startsWith("RealParameter")) {
                            object = null;
                            for (BEASTInterface object2 : base.getOutputs()) {
                                if (!(object2 instanceof ParametricDistribution)) continue;
                                object = (ParametricDistribution)object2;
                                break;
                            }
                            Object object3 = null;
                            for (BEASTInterface bEASTInterface : ((BEASTObject)object).getOutputs()) {
                                if (!(bEASTInterface instanceof Distribution)) continue;
                                object3 = (Distribution)bEASTInterface;
                                break;
                            }
                            string = "parameter.hyper" + object.getClass().getSimpleName() + "-" + this.m_input.getName() + "-" + ((BEASTObject)object3).getID();
                            this.doc.pluginmap.remove(base.getID());
                            base.setID(string);
                            this.doc.addPlugin(base);
                        }
                        object = new PartitionContext(string.substring("parameter.".length()));
                        Log.warning.println(object + " " + string);
                        this.doc.beautiConfig.hyperPriorTemplate.createSubNet((PartitionContext)object, true);
                    }
                    this.refreshPanel();
                }
                catch (Exception exception) {
                    Log.err.println("ParameterInputEditor " + exception.getMessage());
                }
            });
            box.add(this.m_isEstimatedBox);
            this.m_isEstimatedBox.setVisible(this.doc.isExpertMode());
            this.m_isEstimatedBox.setToolTipText("Estimate value of this parameter in the MCMC chain");
            if (this.itemNr < 0) {
                for (BEASTInterface bEASTInterface2 : ((BEASTInterface)this.m_input.get()).getOutputs()) {
                    if (!(bEASTInterface2 instanceof ParametricDistribution)) continue;
                    this.m_isEstimatedBox.setVisible(true);
                    this.isParametricDistributionParameter = true;
                    break;
                }
                for (BEASTInterface bEASTInterface3 : ((BEASTInterface)this.m_input.get()).getOutputs()) {
                    if (!(bEASTInterface3 instanceof Operator)) continue;
                    this.m_isEstimatedBox.setVisible(true);
                    break;
                }
            } else {
                for (BEASTInterface bEASTInterface4 : ((BEASTInterface)((List)this.m_input.get()).get(this.itemNr)).getOutputs()) {
                    if (!(bEASTInterface4 instanceof Operator)) continue;
                    this.m_isEstimatedBox.setVisible(true);
                    break;
                }
            }
            jComponent.add(box);
        }
    }

    @Override
    protected void addValidationLabel() {
        super.addValidationLabel();
        if (this.m_editBEASTObjectButton != null) {
            this.m_editBEASTObjectButton.setVisible(this.m_isEstimatedBox.isVisible());
        }
    }

    @Override
    void refresh() {
        Parameter.Base base = (Parameter.Base)this.m_input.get();
        String string = "";
        for (Object t : base.valuesInput.get()) {
            string = string + t + " ";
        }
        this.m_entry.setText(string);
        this.m_isEstimatedBox.setSelected((Boolean)base.isEstimatedInput.get());
        this.repaint();
    }
}

