/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.draw.Document;
import beast.app.draw.Shape;
import beast.app.draw.TrackPoint;
import beast.core.util.Log;
import java.util.ArrayList;
import java.util.List;

public class Selection {
    public List<TrackPoint> m_tracker = null;
    List<Integer> m_Selection = new ArrayList<Integer>(1);
    Document m_doc = null;

    public void setDocument(Document document) {
        this.m_doc = document;
    }

    public boolean isSingleSelection() {
        return this.m_Selection.size() == 1;
    }

    boolean hasSelection() {
        return this.m_Selection.size() > 0;
    }

    public int getSingleSelection() {
        return this.m_Selection.get(0);
    }

    Shape getSingleSelectionShape() {
        return this.m_doc.m_objects.get(this.getSingleSelection());
    }

    void setSingleSelection(int n) {
        this.m_Selection.removeAll(this.m_Selection);
        this.m_Selection.add(new Integer(n));
        if (n >= 0) {
            this.m_tracker = this.m_doc.m_objects.get(n).getTracker();
        }
    }

    boolean contains(int n) {
        for (int i = 0; i < this.m_Selection.size(); ++i) {
            if (n != this.m_Selection.get(i)) continue;
            return true;
        }
        return false;
    }

    void addToSelection(int n) {
        if (this.contains(n)) {
            return;
        }
        this.m_Selection.add(new Integer(n));
        List<TrackPoint> list = this.m_doc.m_objects.get(n).getTracker();
        if (this.m_tracker == null) {
            this.m_tracker = new ArrayList<TrackPoint>();
        }
        this.m_tracker.addAll(list);
    }

    void toggleSelection(int n) {
        int n2;
        if (!this.contains(n)) {
            this.addToSelection(n);
        } else {
            this.m_tracker.removeAll(this.m_tracker);
            for (n2 = 0; n2 < this.m_Selection.size(); ++n2) {
                if (n == this.m_Selection.get(n2)) {
                    this.m_Selection.remove(n2);
                    --n2;
                    continue;
                }
                List<TrackPoint> list = this.m_doc.m_objects.get(this.m_Selection.get(n2)).getTracker();
                this.m_tracker.addAll(list);
            }
        }
        for (n2 = 0; n2 < this.m_Selection.size(); ++n2) {
            Log.warning.print(this.m_Selection.get(n2) + " ");
        }
        Log.warning.println();
    }

    public void clear() {
        this.m_Selection.removeAll(this.m_Selection);
        this.m_tracker = null;
    }

    boolean intersects(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.m_Selection.size(); ++n3) {
            int n4 = this.m_Selection.get(n3);
            if (!this.m_doc.m_objects.get(n4).intersects(n, n2)) continue;
            return true;
        }
        if (this.m_tracker != null) {
            for (n3 = 0; n3 < this.m_tracker.size(); ++n3) {
                TrackPoint trackPoint = this.m_tracker.get(n3);
                if (n <= trackPoint.m_nX - 5 || n >= trackPoint.m_nX + 5 || n2 <= trackPoint.m_nY - 5 || n2 >= trackPoint.m_nY + 5) continue;
                return true;
            }
        }
        return false;
    }

    void offset(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.m_tracker.size(); ++n3) {
            TrackPoint trackPoint = this.m_tracker.get(n3);
            trackPoint.m_nX += n;
            trackPoint.m_nY += n2;
        }
        for (n3 = 0; n3 < this.m_Selection.size(); ++n3) {
            int n4 = this.m_Selection.get(n3);
            Shape shape = this.m_doc.m_objects.get(n4);
            shape.offset(n, n2);
        }
    }

    public void refreshTracker() {
        if (this.m_tracker == null) {
            this.m_tracker = new ArrayList<TrackPoint>();
        }
        this.m_tracker.removeAll(this.m_tracker);
        for (int i = 0; i < this.m_Selection.size(); ++i) {
            int n = this.m_Selection.get(i);
            List<TrackPoint> list = this.m_doc.m_objects.get(n).getTracker();
            this.m_tracker.addAll(list);
        }
    }

    void setSelection(int[] nArray) {
        this.m_Selection.removeAll(this.m_Selection);
        for (int i = 0; i < nArray.length; ++i) {
            this.m_Selection.add(new Integer(i));
        }
    }
}

