/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.Description;
import beast.core.parameter.Parameter;
import beast.core.util.Log;
import java.io.PrintStream;

@Description(value="A Boolean-valued parameter represents a value (or array of values if the dimension is larger than one) in the state space that can be changed by operators.")
public class BooleanParameter
extends Parameter.Base<Boolean> {
    public BooleanParameter() {
        this.m_fUpper = true;
    }

    public BooleanParameter(Boolean[] booleanArray) {
        super(booleanArray);
        this.m_fUpper = true;
    }

    public BooleanParameter(String string) {
        this.init(string, 1);
        this.m_fUpper = true;
    }

    @Override
    Boolean getMax() {
        return true;
    }

    @Override
    Boolean getMin() {
        return false;
    }

    @Override
    public Boolean getValue() {
        return ((Boolean[])this.values)[0];
    }

    @Override
    public double getArrayValue() {
        return ((Boolean[])this.values)[0] != false ? 1 : 0;
    }

    @Override
    public double getArrayValue(int n) {
        return ((Boolean[])this.values)[n] != false ? 1 : 0;
    }

    @Override
    public void log(int n, PrintStream printStream) {
        BooleanParameter booleanParameter = (BooleanParameter)this.getCurrent();
        int n2 = booleanParameter.getDimension();
        for (int i = 0; i < n2; ++i) {
            printStream.print(((Boolean)booleanParameter.getValue(i) != false ? (char)'1' : '0') + "\t");
        }
    }

    @Override
    public int scale(double d) {
        Log.warning.println("Attempt to scale Boolean parameter " + this.getID() + "  has no effect");
        return 0;
    }

    @Override
    void fromXML(int n, String string, String string2, String[] stringArray) {
        this.values = new Boolean[n];
        for (int i = 0; i < stringArray.length; ++i) {
            ((Boolean[])this.values)[i] = Boolean.parseBoolean(stringArray[i]);
        }
    }
}

