/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.evolution.operators.TreeOperator;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;

@Description(value="Implements the unweighted Wilson-Balding branch swapping move. This move is similar to one proposed by WILSON and BALDING 1998  and involves removing a subtree and re-attaching it on a new parent branch. See <a href='http://www.genetics.org/cgi/content/full/161/3/1307/F1'>picture</a>.")
public class WilsonBalding
extends TreeOperator {
    @Override
    public void initAndValidate() {
    }

    @Override
    public double proposal() {
        Node node;
        Node node2;
        Node node3;
        Tree tree = (Tree)this.treeInput.get(this);
        int n = tree.getNodeCount();
        while ((node3 = tree.getNode(Randomizer.nextInt(n))).isRoot()) {
        }
        Node node4 = node3.getParent();
        while ((node2 = (node = tree.getNode(Randomizer.nextInt(n))).getParent()) != null && node2.getHeight() <= node3.getHeight() || node3.getNr() == node.getNr()) {
        }
        if (node.isRoot() || node4.isRoot()) {
            return Double.NEGATIVE_INFINITY;
        }
        assert (node2 != null);
        int n2 = node4.getNr();
        int n3 = node2.getNr();
        if (n3 == n2 || node.getNr() == n2 || n3 == node3.getNr()) {
            return Double.NEGATIVE_INFINITY;
        }
        Node node5 = this.getOtherChild(node4, node3);
        Node node6 = node4.getParent();
        double d = Math.max(node3.getHeight(), node.getHeight());
        double d2 = node2.getHeight() - d;
        double d3 = d + Randomizer.nextDouble() * d2;
        double d4 = Math.max(node3.getHeight(), node5.getHeight());
        double d5 = node6.getHeight() - d4;
        double d6 = d2 / Math.abs(d5);
        if (d5 == 0.0 || d2 == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        Node node7 = node4.getParent();
        this.replace(node7, node4, node5);
        this.replace(node4, node5, node);
        this.replace(node2, node, node4);
        if (((Boolean)this.markCladesInput.get()).booleanValue()) {
            Node node8 = node7;
            Node node9 = node4;
            while (node8 != node9) {
                if (node8.getHeight() < node9.getHeight()) {
                    assert (!node8.isRoot());
                    node8 = node8.getParent();
                    node8.makeDirty(2);
                    continue;
                }
                assert (!node9.isRoot());
                node9 = node9.getParent();
                node9.makeDirty(2);
            }
        }
        node4.setHeight(d3);
        return Math.log(d6);
    }
}

