/*
 * Decompiled with CFR 0.152.
 */
package beast.math.statistic;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.parameter.Parameter;
import beast.math.statistic.RPNexpressionCalculator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Description(value="RPN calculator to evaluate simple expressions of parameters (Reverse Polish notation is a mathematical notation wherein every operator follows its operands)")
public class RPNcalculator
extends CalculationNode
implements Loggable,
Function {
    public final Input<String> strExpressionInput = new Input("expression", "Expressions needed for the calculations", Input.Validate.REQUIRED);
    public final Input<List<Parameter<?>>> parametersInput = new Input("parameter", "Parameters needed for the calculations", new ArrayList());
    private RPNexpressionCalculator[] expressions;
    private List<String> names;
    private Map<String, Object[]> variables;
    RPNexpressionCalculator.GetVariable[] vars;
    int dim;

    @Override
    public void initAndValidate() {
        this.names = new ArrayList<String>();
        this.dim = this.parametersInput.get().get(0).getDimension();
        for (Parameter<?> parameter : this.parametersInput.get()) {
            int n = parameter.getDimension();
            if (n != this.dim && this.dim != 1 && n != 1) {
                throw new IllegalArgumentException("error: all parameters have to have same length or be of dimension 1.");
            }
            if (n > this.dim) {
                this.dim = n;
            }
            this.expressions = new RPNexpressionCalculator[this.dim];
            this.names.add(parameter.toString());
            for (int i = 0; i < n; ++i) {
                this.variables = new HashMap<String, Object[]>();
                this.variables.put(parameter.getID(), parameter.getValues());
            }
        }
        this.vars = new RPNexpressionCalculator.GetVariable[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            final int n = i;
            this.vars[i] = new RPNexpressionCalculator.GetVariable(){

                @Override
                public double get(String string) {
                    Object[] objectArray = (Object[])RPNcalculator.this.variables.get(string);
                    if (objectArray == null) {
                        String string2 = "";
                        for (Parameter<?> parameter : RPNcalculator.this.parametersInput.get()) {
                            string2 = string2 + parameter.getID() + ", ";
                        }
                        if (RPNcalculator.this.parametersInput.get().size() > 0) {
                            string2 = string2.substring(0, string2.length() - 2);
                        }
                        throw new RuntimeException("Something went wront with the RPNCalculator with id=" + RPNcalculator.this.getID() + ".\n" + "There might be a typo on the expression.\n" + "It should only contain these: " + string2 + "\n" + "but contains " + string);
                    }
                    if (objectArray[0] instanceof Boolean) {
                        return (Boolean)objectArray[objectArray.length > 1 ? n : 0] != false ? 1.0 : 0.0;
                    }
                    if (objectArray[0] instanceof Integer) {
                        return ((Integer)objectArray[objectArray.length > 1 ? n : 0]).intValue();
                    }
                    return (Double)objectArray[objectArray.length > 1 ? n : 0];
                }
            };
        }
        for (int i = 0; i < this.dim; ++i) {
            this.expressions[i] = new RPNexpressionCalculator(this.strExpressionInput.get());
            String string = this.expressions[i].validate();
            if (string == null) continue;
            throw new RuntimeException("Error in expression: " + string);
        }
    }

    private void updateValues() {
        for (Parameter<?> parameter : this.parametersInput.get()) {
            for (int i = 0; i < parameter.getDimension(); ++i) {
                this.variables.put(parameter.getID(), parameter.getValues());
            }
        }
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double getArrayValue() {
        return this.getStatisticValue(0);
    }

    @Override
    public double getArrayValue(int n) {
        return this.getStatisticValue(n);
    }

    public double getStatisticValue(int n) {
        this.updateValues();
        return this.expressions[n].evaluate(this.vars[n]);
    }

    @Override
    public void init(PrintStream printStream) {
        if (this.dim == 1) {
            printStream.print(this.getID() + "\t");
        } else {
            for (int i = 0; i < this.dim; ++i) {
                printStream.print(this.getID() + "_" + i + "\t");
            }
        }
    }

    @Override
    public void log(int n, PrintStream printStream) {
        for (int i = 0; i < this.dim; ++i) {
            printStream.print(this.getStatisticValue(i) + "\t");
        }
    }

    @Override
    public void close(PrintStream printStream) {
    }

    public List<String> getArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter<?> parameter : this.parametersInput.get()) {
            arrayList.add(parameter.getID());
        }
        return arrayList;
    }
}

