/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.util.FrequencySet;
import java.util.ArrayList;
import java.util.List;

public class CredibleSet<T> {
    public List<T> credibleSetList = new ArrayList<T>();
    final double credSetProbability;
    public int sumFrequency = 0;
    public int targetIndex = -1;
    public double targetProb = 0.0;
    public double targetCum = 1.0;

    public CredibleSet(double d) {
        this.credSetProbability = d;
    }

    public void setCredibleSetList(T t, FrequencySet<T> frequencySet) {
        int n = frequencySet.getSumFrequency();
        for (int i = 0; i < frequencySet.size(); ++i) {
            int n2 = frequencySet.getFrequency(i);
            double d = (double)n2 / (double)n;
            this.sumFrequency += n2;
            double d2 = (double)this.sumFrequency / (double)n;
            T t2 = frequencySet.get(i);
            this.credibleSetList.add(t2);
            if (t != null && t2.equals(t)) {
                this.targetIndex = i + 1;
                this.targetProb = d;
                this.targetCum = d2;
            }
            if (d2 >= this.credSetProbability) break;
        }
    }

    public int getFrequency(int n, FrequencySet<T> frequencySet) {
        return frequencySet.getFrequency(this.credibleSetList.get(n));
    }
}

