/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.ZipfDistribution;

public class ZipfDistributionImpl
extends AbstractIntegerDistribution
implements ZipfDistribution,
Serializable {
    private static final long serialVersionUID = -140627372283420404L;
    private int numberOfElements;
    private double exponent;

    public ZipfDistributionImpl(int n, double d) throws IllegalArgumentException {
        this.setNumberOfElementsInternal(n);
        this.setExponentInternal(d);
    }

    @Override
    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    @Override
    @Deprecated
    public void setNumberOfElements(int n) {
        this.setNumberOfElementsInternal(n);
    }

    private void setNumberOfElementsInternal(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw MathRuntimeException.createIllegalArgumentException("invalid number of elements {0} (must be positive)", n);
        }
        this.numberOfElements = n;
    }

    @Override
    public double getExponent() {
        return this.exponent;
    }

    @Override
    @Deprecated
    public void setExponent(double d) {
        this.setExponentInternal(d);
    }

    private void setExponentInternal(double d) throws IllegalArgumentException {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("invalid exponent {0} (must be positive)", d);
        }
        this.exponent = d;
    }

    @Override
    public double probability(int n) {
        if (n <= 0 || n > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / Math.pow(n, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    @Override
    public double cumulativeProbability(int n) {
        if (n <= 0) {
            return 0.0;
        }
        if (n >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(n, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    @Override
    protected int getDomainLowerBound(double d) {
        return 0;
    }

    @Override
    protected int getDomainUpperBound(double d) {
        return this.numberOfElements;
    }

    private double generalizedHarmonic(int n, double d) {
        double d2 = 0.0;
        for (int i = n; i > 0; --i) {
            d2 += 1.0 / Math.pow(i, d);
        }
        return d2;
    }
}

