/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.audio.ui;

import blue.automation.AutomationManager;
import blue.mixer.Channel;
import blue.score.layers.audio.core.AudioLayer;
import blue.ui.components.IconFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.openide.util.NbBundle;

public class AudioHeaderLayerPanel
extends JPanel
implements PropertyChangeListener {
    private static AudioLayerPanelMenu OTHER_MENU = null;
    private final AudioLayer audioLayer;
    private static final Border border = BorderFactory.createBevelBorder(0);
    private static final Border selectionBorder = BorderFactory.createBevelBorder(0, Color.GREEN, Color.GREEN.darker());
    private final Channel channel;
    private JButton automationButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JToggleButton muteToggleButton;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton otherMenuButton;
    private JToggleButton soloToggleButton;

    public AudioHeaderLayerPanel(AudioLayer layer, Channel channel) {
        this.initComponents();
        this.setBorder(border);
        this.audioLayer = layer;
        this.channel = channel;
        this.nameLabel.setText(this.audioLayer.getName());
        this.muteToggleButton.setSelected(this.audioLayer.isMuted());
        this.soloToggleButton.setSelected(this.audioLayer.isSolo());
        this.muteToggleButton.putClientProperty("BlueToggleButton.selectColorOverride", Color.ORANGE.darker());
        this.soloToggleButton.putClientProperty("BlueToggleButton.selectColorOverride", Color.GREEN.darker());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.muteToggleButton = new JToggleButton();
        this.soloToggleButton = new JToggleButton();
        this.automationButton = new JButton();
        this.otherMenuButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(17, 17));
        this.jPanel1.setLayout(new CardLayout());
        this.nameLabel.setText(NbBundle.getMessage(AudioHeaderLayerPanel.class, (String)"AudioHeaderLayerPanel.nameLabel.text"));
        this.nameLabel.setMinimumSize(new Dimension(0, 15));
        this.jPanel1.add((Component)this.nameLabel, "label");
        this.nameText.setText(NbBundle.getMessage(AudioHeaderLayerPanel.class, (String)"AudioHeaderLayerPanel.nameText.text"));
        this.nameText.setMinimumSize(new Dimension(0, 15));
        this.nameText.setPreferredSize(new Dimension(115, 17));
        this.nameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioHeaderLayerPanel.this.nameTextActionPerformed(evt);
            }
        });
        this.nameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                AudioHeaderLayerPanel.this.nameTextFocusLost(evt);
            }
        });
        this.nameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                AudioHeaderLayerPanel.this.nameTextKeyPressed(evt);
            }
        });
        this.jPanel1.add((Component)this.nameText, "textField");
        this.jPanel2.add(this.jPanel1);
        this.muteToggleButton.setFont(new Font("Dialog", 1, 10));
        this.muteToggleButton.setText(NbBundle.getMessage(AudioHeaderLayerPanel.class, (String)"AudioHeaderLayerPanel.muteToggleButton.text"));
        this.muteToggleButton.setFocusPainted(false);
        this.muteToggleButton.setFocusable(false);
        this.muteToggleButton.setMargin(new Insets(0, 3, 0, 3));
        this.muteToggleButton.setMaximumSize(new Dimension(19, 19));
        this.muteToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioHeaderLayerPanel.this.muteToggleButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.muteToggleButton);
        this.soloToggleButton.setFont(new Font("Dialog", 1, 10));
        this.soloToggleButton.setText(NbBundle.getMessage(AudioHeaderLayerPanel.class, (String)"AudioHeaderLayerPanel.soloToggleButton.text"));
        this.soloToggleButton.setFocusPainted(false);
        this.soloToggleButton.setFocusable(false);
        this.soloToggleButton.setMargin(new Insets(0, 3, 0, 3));
        this.soloToggleButton.setMaximumSize(new Dimension(19, 19));
        this.soloToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioHeaderLayerPanel.this.soloToggleButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.soloToggleButton);
        this.automationButton.setFont(new Font("Dialog", 1, 10));
        this.automationButton.setText(NbBundle.getMessage(AudioHeaderLayerPanel.class, (String)"AudioHeaderLayerPanel.automationButton.text"));
        this.automationButton.setToolTipText(NbBundle.getMessage(AudioHeaderLayerPanel.class, (String)"AudioHeaderLayerPanel.automationButton.toolTipText"));
        this.automationButton.setFocusPainted(false);
        this.automationButton.setFocusable(false);
        this.automationButton.setMargin(new Insets(5, 0, 4, 0));
        this.automationButton.setMaximumSize(new Dimension(19, 19));
        this.automationButton.setPreferredSize(new Dimension(16, 17));
        this.automationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioHeaderLayerPanel.this.automationButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.automationButton);
        this.otherMenuButton.setFont(new Font("Dialog", 1, 10));
        this.otherMenuButton.setIcon(IconFactory.getDownArrowIcon());
        this.otherMenuButton.setToolTipText(NbBundle.getMessage(AudioHeaderLayerPanel.class, (String)"AudioHeaderLayerPanel.otherMenuButton.toolTipText"));
        this.otherMenuButton.setFocusPainted(false);
        this.otherMenuButton.setFocusable(false);
        this.otherMenuButton.setMargin(new Insets(5, 0, 4, 0));
        this.otherMenuButton.setMaximumSize(new Dimension(19, 19));
        this.otherMenuButton.setPreferredSize(new Dimension(16, 17));
        this.otherMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioHeaderLayerPanel.this.otherMenuButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.otherMenuButton);
        this.add((Component)this.jPanel2, "North");
    }

    private void nameTextActionPerformed(ActionEvent evt) {
        if (this.audioLayer == null) {
            return;
        }
        this.audioLayer.setName(this.nameText.getText());
        this.nameLabel.setText(this.audioLayer.getName());
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
    }

    private void nameTextFocusLost(FocusEvent evt) {
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
    }

    private void nameTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
        }
    }

    private void muteToggleButtonActionPerformed(ActionEvent evt) {
        this.audioLayer.setMuted(this.muteToggleButton.isSelected());
    }

    private void soloToggleButtonActionPerformed(ActionEvent evt) {
        this.audioLayer.setSolo(this.soloToggleButton.isSelected());
    }

    private void otherMenuButtonActionPerformed(ActionEvent evt) {
        if (OTHER_MENU == null) {
            OTHER_MENU = new AudioLayerPanelMenu();
        }
        OTHER_MENU.setAudioLayer(this.audioLayer);
        OTHER_MENU.show(this.otherMenuButton, 0, this.otherMenuButton.getHeight());
    }

    private void automationButtonActionPerformed(ActionEvent evt) {
        JPopupMenu menu = new JPopupMenu();
        JMenu channelMenu = AutomationManager.getInstance().buildChannelMenu(this.channel, this.audioLayer.getAutomationParameters());
        menu.add(channelMenu);
        menu.show(this.automationButton, 0, this.automationButton.getHeight());
    }

    public void editName() {
        if (this.audioLayer == null) {
            return;
        }
        this.nameText.setText(this.audioLayer.getName());
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "textField");
        this.nameText.requestFocusInWindow();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.audioLayer != null) {
            this.audioLayer.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.audioLayer != null) {
            this.audioLayer.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setSelected(boolean val) {
        this.setBorder(val ? selectionBorder : border);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.audioLayer) {
            String propName;
            switch (propName = evt.getPropertyName()) {
                case "heightIndex": {
                    this.revalidate();
                    break;
                }
                case "name": {
                    this.nameText.setText(this.audioLayer.getName());
                    this.nameLabel.setText(this.audioLayer.getName());
                }
            }
        }
    }

    static class AudioLayerPanelMenu
    extends JPopupMenu {
        AudioLayer audioLayer = null;
        JMenuItem[] heightItems = new JMenuItem[9];

        public AudioLayerPanelMenu() {
            JMenu layerHeightMenu = new JMenu("Layer Height");
            ActionListener al = ae -> {
                if (this.audioLayer == null) {
                    return;
                }
                int heightIndex = Integer.parseInt(ae.getActionCommand()) - 1;
                this.audioLayer.setHeightIndex(heightIndex);
            };
            for (int i = 0; i < this.heightItems.length; ++i) {
                this.heightItems[i] = new JMenuItem(Integer.toString(i + 1));
                this.heightItems[i].addActionListener(al);
                layerHeightMenu.add(this.heightItems[i]);
            }
            this.add(layerHeightMenu);
        }

        public void setAudioLayer(AudioLayer sLayer) {
            this.audioLayer = sLayer;
            this.setupHeightMenu();
        }

        private void setupHeightMenu() {
            if (this.audioLayer == null) {
                return;
            }
            int index = this.audioLayer.getHeightIndex();
            for (int i = 0; i < this.heightItems.length; ++i) {
                this.heightItems[i].setEnabled(i != index);
            }
        }
    }
}

