/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure.soundObject;

import blue.BlueSystem;
import blue.CompileData;
import blue.clojure.BlueClojureEngine;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObject;
import blue.score.ScoreObjectEvent;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.OnLoadProcessable;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;

public class ClojureObject
extends AbstractSoundObject
implements OnLoadProcessable {
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    private String clojureCode;
    private boolean onLoadProcessable = false;

    public ClojureObject() {
        this.setName("(clojure-object)");
        this.clojureCode = ";use symbol blueDuration for duration from blue\n";
        this.clojureCode = this.clojureCode + "(def score \"i1 0 2 3 4 5\")";
        this.timeBehavior = 0;
    }

    public ClojureObject(ClojureObject co) {
        super((AbstractSoundObject)co);
        this.npc = new NoteProcessorChain(co.npc);
        this.timeBehavior = co.timeBehavior;
        this.repeatPoint = co.repeatPoint;
        this.clojureCode = co.clojureCode;
        this.onLoadProcessable = co.onLoadProcessable;
    }

    public String getClojureCode() {
        return this.clojureCode;
    }

    public void setClojureCode(String code) {
        this.clojureCode = code;
    }

    private Throwable getRootCauseException(ScriptException se) {
        ScriptException root = se;
        Throwable e = se;
        while (e != null) {
            if (!((e = e.getCause()) instanceof ScriptException)) continue;
            root = e;
        }
        return root.getCause();
    }

    protected final NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        NoteList nl;
        String tempScore = null;
        File currentDirFile = BlueSystem.getCurrentProjectDirectory();
        HashMap<String, Object> initObjects = new HashMap<String, Object>();
        initObjects.put("score", "");
        initObjects.put("blueDuration", this.getSubjectiveDuration());
        initObjects.put("blueProjectDir", currentDirFile);
        try {
            tempScore = BlueClojureEngine.getInstance().processScript(this.clojureCode, initObjects, "score");
        }
        catch (ScriptException scriptEx) {
            String msg = "Clojure Error:\n" + this.getRootCauseException(scriptEx).toString();
            throw new SoundObjectException((SoundObject)this, msg);
        }
        try {
            nl = ScoreUtilities.getNotes((String)tempScore);
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain((NoteList)nl, (NoteProcessorChain)this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior((NoteList)nl, (int)this.getTimeBehavior(), (double)this.getSubjectiveDuration(), (double)this.getRepeatPoint());
        ScoreUtilities.setScoreStart((NoteList)nl, (double)this.startTime);
        return nl;
    }

    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        return this.generateNotes(startTime, endTime);
    }

    public double getObjectiveDuration() {
        return this.subjectiveDuration;
    }

    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent((ScoreObject)this, 4);
        this.fireScoreObjectEvent(event);
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        ClojureObject clojureObj = new ClojureObject();
        SoundObjectUtilities.initBasicFromXML((Element)data, (SoundObject)clojureObj);
        clojureObj.setClojureCode(data.getTextString("clojureCode"));
        String olpString = data.getAttributeValue("onLoadProcessable");
        if (olpString != null) {
            clojureObj.setOnLoadProcessable(Boolean.valueOf(olpString));
        }
        return clojureObj;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML((SoundObject)this);
        retVal.addElement("clojureCode").setText(this.getClojureCode());
        retVal.setAttribute("onLoadProcessable", Boolean.toString(this.onLoadProcessable));
        return retVal;
    }

    public void setNoteProcessorChain(NoteProcessorChain chain) {
        this.npc = chain;
    }

    public void setOnLoadProcessable(boolean onLoadProcessable) {
        this.onLoadProcessable = onLoadProcessable;
    }

    public boolean isOnLoadProcessable() {
        return this.onLoadProcessable;
    }

    public void processOnLoad() throws SoundObjectException {
        if (this.onLoadProcessable) {
            this.generateNotes(0.0, -1.0);
        }
    }

    public ClojureObject deepCopy() {
        return new ClojureObject(this);
    }
}

