/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.ceciliaModule;

import blue.soundObject.ceciliaModule.CGraphPoint;
import blue.soundObject.ceciliaModule.CeciliaObject;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CGraph
extends CeciliaObject {
    public static int REL_LINEAR = 0;
    public static int REL_LOGARITHMIC = 1;
    public static int REL_RAW = 2;
    double min = 0.0;
    double max = 100.0;
    String unit = "x";
    int rel = REL_LINEAR;
    int gen = -1;
    int size = -1;
    ArrayList<CGraphPoint> points = new ArrayList();
    String color = "";

    public CGraph() {
    }

    public CGraph(CGraph cgraph) {
        this.min = cgraph.min;
        this.max = cgraph.max;
        this.unit = cgraph.unit;
        this.rel = cgraph.rel;
        this.gen = cgraph.gen;
        this.size = cgraph.size;
        this.color = cgraph.color;
        for (CGraphPoint pt : cgraph.points) {
            this.points.add(new CGraphPoint(pt));
        }
    }

    @Override
    public String processText(String ceciliaText) {
        return null;
    }

    @Override
    public void initialize(String[] tokens) {
        this.setObjectName(tokens[1]);
        boolean setInitValue = false;
        double initValue = Double.NaN;
        block32: for (int i = 2; i < tokens.length; i += 2) {
            switch (tokens[i]) {
                case "-label": {
                    this.setLabel(tokens[i + 1]);
                    continue block32;
                }
                case "-min": {
                    this.setMin(Double.parseDouble(tokens[i + 1]));
                    continue block32;
                }
                case "-max": {
                    this.setMax(Double.parseDouble(tokens[i + 1]));
                    continue block32;
                }
                case "-rel": {
                    switch (tokens[i + 1]) {
                        case "lin": {
                            this.setRel(REL_LINEAR);
                            continue block32;
                        }
                        case "log": {
                            this.setRel(REL_LOGARITHMIC);
                            continue block32;
                        }
                        case "raw": {
                            this.setRel(REL_RAW);
                            continue block32;
                        }
                    }
                    continue block32;
                }
                case "-unit": {
                    this.setUnit(tokens[i + 1]);
                    continue block32;
                }
                case "-gen": {
                    this.setGen(Integer.parseInt(tokens[i + 1]));
                    continue block32;
                }
                case "-size": {
                    this.setSize(Integer.parseInt(tokens[i + 1]));
                    continue block32;
                }
                case "-init": {
                    initValue = Double.parseDouble(tokens[i + 1]);
                    setInitValue = true;
                    continue block32;
                }
                case "-func": {
                    this.parseFuncString(tokens[i + 1]);
                    setInitValue = false;
                    continue block32;
                }
            }
        }
        if (setInitValue) {
            CGraphPoint point1 = new CGraphPoint();
            CGraphPoint point2 = new CGraphPoint();
            point1.time = 0.0;
            point2.time = 1.0;
            double range = this.getMax() - this.getMin();
            if (Double.isNaN(initValue)) {
                point1.value = 0.0;
                point2.value = 0.0;
            } else {
                point1.value = (initValue - this.getMin()) / range;
                point2.value = (initValue - this.getMin()) / range;
            }
            this.points.add(point1);
            this.points.add(point2);
        }
    }

    private void parseFuncString(String funcString) {
        StringTokenizer st = new StringTokenizer(funcString);
        double time = 0.0;
        double val = 0.0;
        boolean type = false;
        this.points.clear();
        while (st.hasMoreTokens()) {
            if (!type) {
                time = Double.parseDouble(st.nextToken());
                type = true;
                continue;
            }
            val = Double.parseDouble(st.nextToken());
            CGraphPoint point = new CGraphPoint();
            point.time = time;
            point.value = val;
            this.points.add(point);
            type = false;
        }
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public int getRel() {
        return this.rel;
    }

    public int getSize() {
        return this.size;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setMax(double f) {
        this.max = f;
    }

    public void setMin(double f) {
        this.min = f;
    }

    public void setRel(int i) {
        this.rel = i;
    }

    public void setSize(int i) {
        this.size = i;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public int getGen() {
        return this.gen;
    }

    public void setGen(int i) {
        this.gen = i;
    }

    public ArrayList<CGraphPoint> getPoints() {
        return this.points;
    }

    public void setPoints(ArrayList<CGraphPoint> points) {
        this.points = points;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public static CeciliaObject loadFromXML(Element data) {
        CGraph cgraph = new CGraph();
        CeciliaObject.initBasicFromXML(data, cgraph);
        cgraph.setMin(Double.parseDouble(data.getTextString("min")));
        cgraph.setMax(Double.parseDouble(data.getTextString("max")));
        cgraph.setUnit(data.getTextString("unit"));
        cgraph.setRel(Integer.parseInt(data.getTextString("rel")));
        cgraph.setGen(Integer.parseInt(data.getTextString("gen")));
        cgraph.setSize(Integer.parseInt(data.getTextString("size")));
        String color = data.getTextString("color");
        cgraph.setColor(color == null ? "" : color);
        Elements pointNodes = data.getElements("cgraphPoint");
        while (pointNodes.hasMoreElements()) {
            CGraphPoint cgp = CGraphPoint.loadFromXML(pointNodes.next());
            cgraph.points.add(cgp);
        }
        return cgraph;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = CeciliaObject.getBasicXML(this);
        retVal.addElement("min").setText(Double.toString(this.getMin()));
        retVal.addElement("max").setText(Double.toString(this.getMax()));
        retVal.addElement("unit").setText(this.getUnit());
        retVal.addElement("rel").setText(Integer.toString(this.getRel()));
        retVal.addElement("gen").setText(Integer.toString(this.getGen()));
        retVal.addElement("size").setText(Integer.toString(this.getSize()));
        retVal.addElement("color").setText(this.getColor());
        for (CGraphPoint cgp : this.points) {
            retVal.addElement(cgp.saveAsXML());
        }
        return retVal;
    }

    public void replaceValues(CGraph cgraph) {
        System.out.println("Cgraph :" + this + " : " + cgraph);
        ArrayList<CGraphPoint> pointsCopy = new ArrayList<CGraphPoint>();
        for (CGraphPoint pt : cgraph.getPoints()) {
            pointsCopy.add(new CGraphPoint(pt));
        }
        this.setPoints(pointsCopy);
    }
}

