/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class LabelledPanel
extends JComponent {
    ArrayList<ActionListener> listeners = new ArrayList();
    JComponent dockItem = null;
    JLabel label;

    public LabelledPanel() {
        this("", null);
    }

    public LabelledPanel(String name, JComponent dockItem) {
        this.setLayout(new BorderLayout());
        this.label = new JLabel(name);
        this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(3, 3, 3, 3)));
        this.add((Component)this.label, "North");
        if (this.dockItem != null) {
            this.remove(dockItem);
        }
        this.dockItem = dockItem;
        if (dockItem != null) {
            this.add((Component)dockItem, "Center");
        }
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    LabelledPanel.this.fireActionPerformed();
                }
            }
        });
    }

    @Override
    public void setName(String name) {
        this.label.setText(name);
    }

    @Override
    public String getName() {
        return this.label.getText();
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void fireActionPerformed() {
        ActionEvent ae = new ActionEvent(this, 1001, "clicked");
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(ae);
        }
    }

    public static void main(String[] args) {
        LabelledPanel panel = new LabelledPanel("Test Panel", new JPanel());
        GUI.showComponentAsStandalone((Component)panel, (String)"Title Bar Panel Test", (boolean)true);
    }
}

