/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import blue.BlueSystem;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.table.AbstractTableModel;

class PropertyEditTableModel
extends AbstractTableModel {
    private static String PROPERTY = null;
    private static String VALUE = null;
    Object obj;
    PropertyDescriptor[] props = null;

    public PropertyEditTableModel() {
        if (PROPERTY == null) {
            PROPERTY = BlueSystem.getString((String)"propertyEditor.property");
        }
        if (VALUE == null) {
            VALUE = BlueSystem.getString((String)"propertyEditor.value");
        }
    }

    public void setObject(Object obj) {
        this.obj = obj;
        if (obj == null) {
            this.props = null;
        } else {
            try {
                BeanInfo info = Introspector.getBeanInfo(obj.getClass());
                this.props = info.getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int i) {
        if (i == 0) {
            return "Property";
        }
        return "Value";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.obj == null) {
            return null;
        }
        PropertyDescriptor temp = this.props[row];
        Object retVal = null;
        if (column == 0) {
            retVal = temp.getName();
        } else {
            try {
                retVal = temp.getReadMethod().invoke((Object)temp, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    @Override
    public int getRowCount() {
        if (this.props == null) {
            return 0;
        }
        return this.props.length;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 1;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        return this.getValueAt(0, 1).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.obj == null) {
            return;
        }
        if (col == 1) {
            try {
                Object[] args = new Object[]{value};
                PropertyDescriptor temp = this.props[row];
                temp.getWriteMethod().invoke((Object)temp, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        this.fireTableCellUpdated(row, col);
    }
}

