/*
 * Decompiled with CFR 0.152.
 */
package blue.components;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JSlider;

public class ValueSlider
extends JSlider {
    private double min;
    private double max;
    private int resolution;

    public ValueSlider() {
        this.initialize(100);
    }

    public ValueSlider(int resolution) {
        this.initialize(resolution);
    }

    private void initialize(int resolution) {
        this.resolution = resolution;
        super.setMinimum(0);
        super.setMaximum(resolution);
        this.setBorder(null);
        this.setOrientation(0);
        this.setMajorTickSpacing(10);
        this.setMinorTickSpacing(1);
        this.setPaintTicks(false);
        this.setPaintLabels(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.setPreferredSize(new Dimension(100, 16));
    }

    public void set(double min, double max, double value) {
        this.min = min;
        this.max = max;
        this.setValue(value);
    }

    public void setMinimum(double min) {
        this.min = min;
    }

    public void setMaximum(double max) {
        this.max = max;
    }

    public void setValue(double value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        int ival = this.doubleToInt(this.min, this.max, value, this.resolution);
        super.setValue(ival);
    }

    public double getFloat() {
        double value = this.intToFloat(this.resolution, this.getValue(), this.min, this.max);
        return value;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
        super.setMaximum(resolution);
    }

    private int doubleToInt(double min, double max, double val, int resolution) {
        double distance = max - min;
        int ival = (int)((val - min) / distance * (double)resolution);
        return ival;
    }

    private double intToFloat(int resolution, int ival, double min, double max) {
        double distance = max - min;
        double val = (double)ival * distance / (double)resolution + min;
        return val;
    }

    public static void main(String[] args) {
        System.out.println("----------------------------------------");
        System.out.println("TEST: ValueSlider: Starting...\n");
        ValueSlider slider = new ValueSlider(10000);
        slider.set(0.0, 80.0, 40.0);
        slider.addChangeListener(e -> System.out.println(slider.getFloat()));
        JFrame frame = new JFrame();
        frame.getContentPane().add(slider);
        frame.pack();
        frame.setLocation(10, 10);
        frame.setTitle("TEST: ValueSlider");
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        System.out.println("TEST: ValueSlider: Completed!");
        System.out.println("----------------------------------------");
    }
}

