/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.score.ScoreObject;
import blue.soundObject.External;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObjectException;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;

public class ExternalEditor
extends ScoreObjectEditor {
    External external;
    JLabel editorLabel = new JLabel();
    MimeTypeEditorComponent score1EditPane = new MimeTypeEditorComponent("text/plain");
    JPanel commandPanel = new JPanel();
    JLabel commandLabel = new JLabel(BlueSystem.getString((String)"programOptions.commandLine") + " ");
    JButton testButton = new JButton(BlueSystem.getString((String)"common.test"));
    JTextField commandText = new JTextField();
    UndoManager undo = new UndoRedo.Manager();
    private boolean isUpdating = false;

    public ExternalEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.editorLabel.setText(BlueSystem.getString((String)"externalObject.title"));
        this.editorLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.setLayout(new BorderLayout());
        this.score1EditPane.getJEditorPane().setEditable(true);
        this.score1EditPane.setUndoManager(this.undo);
        this.score1EditPane.getDocument().addUndoableEditListener(this.undo);
        this.score1EditPane.addPropertyChangeListener(evt -> {
            if (this.isUpdating) {
                return;
            }
            if (evt.getPropertyName().equals("syntaxType")) {
                String type = (String)evt.getNewValue();
                this.external.setSyntaxType(type);
            }
        });
        this.score1EditPane.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (ExternalEditor.this.external != null) {
                    ExternalEditor.this.external.setText(ExternalEditor.this.score1EditPane.getText());
                }
            }
        });
        this.commandText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (ExternalEditor.this.external != null) {
                    ExternalEditor.this.external.setCommandLine(ExternalEditor.this.commandText.getText());
                }
            }
        });
        this.commandPanel.setLayout(new BorderLayout());
        this.commandPanel.add((Component)this.commandLabel, "West");
        this.commandPanel.add((Component)this.commandText, "Center");
        this.commandPanel.add((Component)this.testButton, "East");
        this.commandPanel.add((Component)this.editorLabel, "North");
        this.commandPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.add((Component)this.commandPanel, "North");
        this.add((Component)this.score1EditPane, "Center");
        this.testButton.addActionListener(e -> this.testSoundObject());
        this.initActions();
        this.undo.setLimit(1000);
    }

    private void initActions() {
        InputMap inputMap = this.score1EditPane.getInputMap();
        ActionMap actions = this.score1EditPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()), "testSoundObject");
        actions.put("testSoundObject", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalEditor.this.testSoundObject();
            }
        });
    }

    @Override
    public final void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            this.external = null;
            return;
        }
        if (!sObj.getClass().getName().equals("blue.soundObject.External")) {
            this.external = null;
            return;
        }
        this.isUpdating = true;
        this.external = (External)sObj;
        this.score1EditPane.setText(this.external.getText());
        this.commandText.setText(this.external.getCommandLine());
        this.undo.discardAllEdits();
        this.isUpdating = false;
    }

    public final void testSoundObject() {
        if (this.external == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.external.generateNotes(0.0, -1.0);
        }
        catch (SoundObjectException e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }
}

