/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.score.ScoreObject;
import blue.soundObject.JavaScriptObject;
import blue.soundObject.NoteList;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.util.NbBundle;

public class JavaScriptObjectEditor
extends ScoreObjectEditor {
    JavaScriptObject sObj;
    MimeTypeEditorComponent codeEditor = new MimeTypeEditorComponent("text/javascript");
    UndoManager undo = new UndoRedo.Manager();
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JCheckBox processOnLoadCheckBox;
    private JButton testButton;

    public JavaScriptObjectEditor() {
        this.initComponents();
        this.initActions();
        this.add((Component)this.codeEditor, "Center");
        this.codeEditor.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (JavaScriptObjectEditor.this.sObj != null) {
                    JavaScriptObjectEditor.this.sObj.setText(JavaScriptObjectEditor.this.codeEditor.getText());
                }
            }
        });
        this.codeEditor.setUndoManager(this.undo);
        this.codeEditor.getDocument().addUndoableEditListener(this.undo);
        this.undo.setLimit(1000);
    }

    private void initActions() {
        InputMap inputMap = this.codeEditor.getJEditorPane().getInputMap();
        ActionMap actions = this.codeEditor.getJEditorPane().getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(84, BlueSystem.getMenuShortcutKey()), "testSoundObject");
        actions.put("testSoundObject", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaScriptObjectEditor.this.testSoundObject();
            }
        });
    }

    @Override
    public final void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            this.sObj = null;
            this.codeEditor.setText("null soundObject");
            this.codeEditor.getJEditorPane().setEnabled(false);
            this.processOnLoadCheckBox.setEnabled(false);
            return;
        }
        if (!(sObj instanceof JavaScriptObject)) {
            this.sObj = null;
            this.codeEditor.setText("[ERROR] GenericEditor::editSoundObject - not instance of GenericEditable");
            this.codeEditor.getJEditorPane().setEnabled(false);
            this.processOnLoadCheckBox.setEnabled(false);
            return;
        }
        this.sObj = (JavaScriptObject)sObj;
        this.codeEditor.setText(this.sObj.getText());
        this.codeEditor.getJEditorPane().setEnabled(true);
        this.codeEditor.getJEditorPane().setCaretPosition(0);
        this.processOnLoadCheckBox.setSelected(this.sObj.isOnLoadProcessable());
        this.processOnLoadCheckBox.setEnabled(true);
        this.undo.discardAllEdits();
    }

    public final void testSoundObject() {
        if (this.sObj == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.sObj.generateForCSD(null, 0.0, -1.0);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.processOnLoadCheckBox = new JCheckBox();
        this.testButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JavaScriptObjectEditor.class, (String)"JavaScriptObjectEditor.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.processOnLoadCheckBox, (String)NbBundle.getMessage(JavaScriptObjectEditor.class, (String)"JavaScriptObjectEditor.processOnLoadCheckBox.text"));
        this.processOnLoadCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptObjectEditor.this.processOnLoadCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.jPanel1.add((Component)this.processOnLoadCheckBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.testButton, (String)BlueSystem.getString((String)"common.test"));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptObjectEditor.this.testButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.testButton, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void processOnLoadCheckBoxActionPerformed(ActionEvent evt) {
        if (this.sObj != null) {
            this.sObj.setOnLoadProcessable(this.processOnLoadCheckBox.isSelected());
        }
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        this.testSoundObject();
    }
}

