/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.scanned;

import blue.BlueSystem;
import blue.tools.scanned.MatrixMouseListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class MatrixGridEditor
extends JComponent {
    boolean[] matrix = null;
    MatrixMouseListener mml = new MatrixMouseListener(this);
    private static final Color ON_COLOR = new Color(198, 226, 255);
    public static int gridHeight = 20;
    public JLabel locationLabel = null;

    public MatrixGridEditor() {
        this.addMouseListener(this.mml);
        this.addMouseMotionListener(this.mml);
    }

    public void setLocationLabel(JLabel locationLabel) {
        this.locationLabel = locationLabel;
    }

    public static void increaseGridSize() {
        ++gridHeight;
    }

    public static void decreaseGridSize() {
        if (gridHeight > 1) {
            --gridHeight;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        int totalWidth;
        super.paintComponent(g);
        if (this.matrix == null) {
            return;
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int numOfMasses = MatrixGridEditor.numberOfMasses(this.matrix.length);
        int totalHeight = totalWidth = numOfMasses * gridHeight;
        g.setColor(ON_COLOR);
        for (i = 0; i < this.matrix.length; ++i) {
            if (!this.matrix[i]) continue;
            int x1 = i % numOfMasses * gridHeight;
            int y1 = i / numOfMasses * gridHeight;
            g.fillRect(x1, y1, gridHeight, gridHeight);
        }
        g.setColor(Color.darkGray);
        for (i = 0; i < numOfMasses; ++i) {
            g.drawLine(0, i * gridHeight, totalWidth, i * gridHeight);
        }
        for (i = 0; i < numOfMasses; ++i) {
            g.setColor(Color.darkGray);
            g.drawLine(i * gridHeight, 0, i * gridHeight, totalHeight);
        }
    }

    public void setMatrix(boolean[] matrix) {
        this.matrix = matrix;
        this.redoSize();
        this.mml.setMatrix(matrix);
    }

    public void loadMatrix(File matrixFile) {
        ArrayList<String> temp = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(matrixFile));){
            String line;
            while ((line = br.readLine()) != null) {
                temp.add(line.trim());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"scanned.errorImportingMatrix") + " " + matrixFile.getAbsolutePath(), BlueSystem.getString((String)"message.error"), -1);
            System.err.println(BlueSystem.getString((String)"scanned.errorImportingMatrix") + " " + matrixFile.getAbsolutePath());
            return;
        }
        System.out.println(BlueSystem.getString((String)"scanned.size") + " " + temp.size());
        System.out.println(BlueSystem.getString((String)"scanned.numMasses") + " " + MatrixGridEditor.numberOfMasses(temp.size()));
        int numOfMasses = MatrixGridEditor.numberOfMasses(temp.size());
        if (numOfMasses == temp.size()) {
            JOptionPane.showMessageDialog(null, BlueSystem.getString((String)"scanned.errorImportingMatrix") + " " + matrixFile.getAbsolutePath(), BlueSystem.getString((String)"message.error"), -1);
            System.err.println(BlueSystem.getString((String)"scanned.errorImportingMatrix") + " " + matrixFile.getAbsolutePath());
            return;
        }
        boolean[] matrix = new boolean[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            matrix[i] = !temp.get(i).equals("0");
        }
        this.matrix = matrix;
        this.redoSize();
        this.mml.setMatrix(matrix);
    }

    public void redoSize() {
        if (this.matrix != null) {
            int numOfMasses = MatrixGridEditor.numberOfMasses(this.matrix.length);
            Dimension dim = new Dimension(numOfMasses * gridHeight, numOfMasses * gridHeight);
            this.setSize(dim);
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
            this.setMinimumSize(dim);
            this.revalidate();
            this.repaint();
        }
    }

    public static final int numberOfMasses(int arrayLength) {
        int i;
        for (i = 0; i * i != arrayLength && i < arrayLength; ++i) {
        }
        return i;
    }

    public static void main(String[] args) {
    }
}

