/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.blueLive;

import blue.blueLive.LiveObject;
import blue.blueLive.LiveObjectBins;
import blue.blueLive.LiveObjectSet;
import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.soundObject.SoundObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class LiveObjectsTableModel
implements TableModel,
ScoreObjectListener,
PropertyChangeListener {
    LiveObjectBins bins = null;
    Vector tableListeners = null;

    public void setLiveObjectBins(LiveObjectBins bins) {
        LiveObject lObj;
        int j;
        int i;
        if (this.bins != null) {
            for (i = 0; i < this.bins.getColumnCount(); ++i) {
                for (j = 0; j < this.bins.getRowCount(); ++j) {
                    lObj = this.bins.getLiveObject(i, j);
                    if (lObj == null || lObj.getSoundObject() == null) continue;
                    lObj.getSoundObject().removeScoreObjectListener((ScoreObjectListener)this);
                }
            }
            bins.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.bins = bins;
        for (i = 0; i < bins.getColumnCount(); ++i) {
            for (j = 0; j < bins.getRowCount(); ++j) {
                lObj = bins.getLiveObject(i, j);
                if (lObj == null || lObj.getSoundObject() == null) continue;
                lObj.getSoundObject().addScoreObjectListener((ScoreObjectListener)this);
            }
        }
        this.fireTableDataChanged(new TableModelEvent(this, -1));
        bins.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public int getRowCount() {
        if (this.bins == null) {
            return 0;
        }
        return this.bins.getRowCount();
    }

    @Override
    public int getColumnCount() {
        if (this.bins == null) {
            return 0;
        }
        return this.bins.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return Integer.toString(columnIndex + 1);
    }

    public Class getColumnClass(int columnIndex) {
        return LiveObject.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.bins == null || rowIndex < 0 || columnIndex < 0) {
            return null;
        }
        return this.bins.getLiveObject(columnIndex, rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.bins.getRowCount() && columnIndex >= 0 && columnIndex < this.bins.getColumnCount()) {
            LiveObject oldLiveObj = this.bins.getLiveObject(columnIndex, rowIndex);
            LiveObject newObj = (LiveObject)aValue;
            if (oldLiveObj != null && oldLiveObj.getSoundObject() != null) {
                oldLiveObj.getSoundObject().removeScoreObjectListener((ScoreObjectListener)this);
            }
            this.bins.setLiveObject(columnIndex, rowIndex, newObj);
            if (newObj != null && newObj.getSoundObject() != null) {
                newObj.getSoundObject().addScoreObjectListener((ScoreObjectListener)this);
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.tableListeners == null) {
            this.tableListeners = new Vector();
        }
        this.tableListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.tableListeners == null) {
            return;
        }
        this.tableListeners.remove(l);
    }

    private void fireTableDataChanged() {
        this.fireTableDataChanged(new TableModelEvent(this));
    }

    private void fireTableDataChanged(TableModelEvent tme) {
        if (this.tableListeners == null) {
            return;
        }
        for (TableModelListener listener : this.tableListeners) {
            listener.tableChanged(tme);
        }
    }

    public void insertRow(int index) {
        this.bins.insertRow(index);
        this.fireTableDataChanged();
    }

    public void removeRow(int index) {
        this.bins.removeRow(index);
        this.fireTableDataChanged();
    }

    public void insertColumn(int index) {
        this.bins.insertColumn(index);
        this.fireTableDataChanged(new TableModelEvent(this, -1));
    }

    public void removeColumn(int index) {
        this.bins.removeColumn(index);
        this.fireTableDataChanged(new TableModelEvent(this, -1));
    }

    public void scoreObjectChanged(ScoreObjectEvent event) {
        LiveObject lObj;
        if (event.getPropertyChanged() == 0 && (lObj = this.getLiveObjectForSoundObject((SoundObject)event.getScoreObject())) != null) {
            int row = this.bins.getRowForObject(lObj);
            int column = this.bins.getColumnForObject(lObj);
            this.fireTableDataChanged(new TableModelEvent(this, row, row, column, 0));
        }
    }

    protected LiveObject getLiveObjectForSoundObject(SoundObject sObj) {
        if (this.bins == null) {
            return null;
        }
        for (int i = 0; i < this.bins.getColumnCount(); ++i) {
            for (int j = 0; j < this.bins.getRowCount(); ++j) {
                LiveObject lObj = this.bins.getLiveObject(i, j);
                if (lObj == null || lObj.getSoundObject() != sObj) continue;
                return lObj;
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("enableStatedChanged".equals(evt.getPropertyName())) {
            this.fireTableDataChanged();
        }
    }

    public void setEnabled(LiveObjectSet lObjSet) {
        if (this.bins == null || lObjSet == null) {
            return;
        }
        for (int i = 0; i < this.bins.getColumnCount(); ++i) {
            for (int j = 0; j < this.bins.getRowCount(); ++j) {
                LiveObject lObj = this.bins.getLiveObject(i, j);
                if (lObj == null) continue;
                lObj.setEnabled(lObjSet.contains((Object)lObj));
            }
        }
        this.fireTableDataChanged();
    }
}

