/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.BlueSystem;
import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.mixer.Effect;
import blue.ui.core.mixer.EffectCategory;
import blue.ui.core.mixer.EffectEditor;
import blue.ui.core.mixer.EffectTreeDragSource;
import blue.ui.core.mixer.EffectTreeDropTarget;
import blue.ui.core.mixer.EffectsLibrary;
import blue.ui.core.mixer.EffectsUtil;
import blue.ui.utilities.UiUtilities;
import blue.utility.GUI;
import electric.xml.Element;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class EffectsLibraryDialog
extends JDialog
implements WindowSettingsSavable {
    Object bufferedObject = null;
    EffectGroupPopup groupPopup = new EffectGroupPopup();
    EffectPopup effectPopup = new EffectPopup();
    EffectEditor effectEditor = new EffectEditor();
    private JTree libraryTree;
    private JSplitPane splitPane;
    private JScrollPane treeScroll;

    public EffectsLibraryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.splitPane.setRightComponent(this.effectEditor);
        EffectsLibrary library = EffectsLibrary.getInstance();
        this.libraryTree.setModel(library);
        library.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                EffectsLibraryDialog.this.effectEditor.setEffect(null);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.libraryTree.setSelectionModel(selectionModel);
        this.libraryTree.setEditable(true);
        new EffectTreeDragSource(this.libraryTree, 2);
        new EffectTreeDropTarget(this.libraryTree);
        this.libraryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UiUtilities.isRightMouseButton((MouseEvent)e) && EffectsLibraryDialog.this.libraryTree.getSelectionPath() != null) {
                    TreePath path = EffectsLibraryDialog.this.libraryTree.getSelectionPath();
                    Object selectedItem = path.getLastPathComponent();
                    if (selectedItem instanceof EffectCategory) {
                        EffectsLibraryDialog.this.groupPopup.show((Component)e.getSource(), e.getX(), e.getY());
                    } else if (selectedItem instanceof Effect) {
                        EffectsLibraryDialog.this.effectPopup.show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Effect effect = EffectsLibraryDialog.this.getSelectedEffect();
                    EffectsLibraryDialog.this.effectEditor.setEffect(effect);
                }
            }
        });
        GUI.centerOnScreen((Component)this);
        this.setTitle("Effects Library");
        this.setSize(800, 600);
        WindowSettingManager.getInstance().registerWindow("EffectsLibraryDialog", this);
    }

    private EffectCategory getSelectedCategory() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof EffectCategory)) {
            return null;
        }
        return (EffectCategory)obj;
    }

    private Effect getSelectedEffect() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof Effect)) {
            return null;
        }
        return (Effect)obj;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.treeScroll = new JScrollPane();
        this.libraryTree = new JTree();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EffectsLibraryDialog.this.formWindowClosing(evt);
            }
        });
        this.splitPane.setDividerLocation(200);
        this.splitPane.setLastDividerLocation(200);
        this.treeScroll.setViewportView(this.libraryTree);
        this.splitPane.setLeftComponent(this.treeScroll);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.splitPane, -1, 593, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.splitPane, -1, 414, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        EffectsLibrary.getInstance().save();
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        EffectsLibraryDialog library = new EffectsLibraryDialog(null, true);
        library.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        library.setVisible(true);
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }

    private class EffectPopup
    extends JPopupMenu {
        public EffectPopup() {
            AbstractAction removeEffect = new AbstractAction("Remove Effect"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Effect effect = EffectsLibraryDialog.this.getSelectedEffect();
                    if (effect == null) {
                        return;
                    }
                    EffectsLibrary.getInstance().removeEffect(effect);
                }
            };
            AbstractAction cutAction = new AbstractAction(BlueSystem.getString((String)"common.cut")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Effect effect = EffectsLibraryDialog.this.getSelectedEffect();
                    if (effect == null) {
                        return;
                    }
                    EffectsLibraryDialog.this.bufferedObject = new Effect(effect);
                    EffectsLibrary.getInstance().removeEffect(effect);
                }
            };
            AbstractAction copyAction = new AbstractAction(BlueSystem.getString((String)"common.copy")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Effect effect = EffectsLibraryDialog.this.getSelectedEffect();
                    if (effect == null) {
                        return;
                    }
                    EffectsLibraryDialog.this.bufferedObject = new Effect(effect);
                }
            };
            AbstractAction exportAction = new AbstractAction("Export to File"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Effect effect = EffectsLibraryDialog.this.getSelectedEffect();
                    if (effect == null) {
                        return;
                    }
                    EffectsUtil.exportEffect(effect);
                }
            };
            this.add(cutAction);
            this.add(copyAction);
            this.addSeparator();
            this.add(removeEffect);
            this.addSeparator();
            this.add(exportAction);
        }
    }

    private class EffectGroupPopup
    extends JPopupMenu {
        public EffectGroupPopup() {
            AbstractAction addGroup = new AbstractAction(BlueSystem.getString((String)"codeRepository.addGroup")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EffectCategory cat = EffectsLibraryDialog.this.getSelectedCategory();
                    if (cat == null) {
                        return;
                    }
                    EffectsLibrary.getInstance().addCategory(cat, new EffectCategory());
                }
            };
            final AbstractAction removeGroup = new AbstractAction(BlueSystem.getString((String)"codeRepository.removeGroup")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EffectCategory cat = EffectsLibraryDialog.this.getSelectedCategory();
                    if (cat == null) {
                        return;
                    }
                    EffectsLibrary.getInstance().removeEffectCategory(cat);
                }
            };
            AbstractAction addEffect = new AbstractAction("Add Effect"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EffectCategory cat = EffectsLibraryDialog.this.getSelectedCategory();
                    if (cat == null) {
                        return;
                    }
                    EffectsLibrary.getInstance().addEffect(cat, new Effect());
                }
            };
            AbstractAction cutAction = new AbstractAction(BlueSystem.getString((String)"common.cut")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    EffectCategory cat = EffectsLibraryDialog.this.getSelectedCategory();
                    if (cat == null) {
                        return;
                    }
                    EffectsLibraryDialog.this.bufferedObject = new EffectCategory(cat);
                    EffectsLibrary.getInstance().removeEffectCategory(cat);
                }
            };
            AbstractAction copyAction = new AbstractAction(BlueSystem.getString((String)"common.copy")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    EffectCategory cat = EffectsLibraryDialog.this.getSelectedCategory();
                    if (cat == null) {
                        return;
                    }
                    EffectsLibraryDialog.this.bufferedObject = new EffectCategory(cat);
                    EffectsLibrary.getInstance().removeEffectCategory(cat);
                }
            };
            final AbstractAction pasteAction = new AbstractAction(BlueSystem.getString((String)"common.paste")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    EffectCategory cat = EffectsLibraryDialog.this.getSelectedCategory();
                    if (cat == null) {
                        return;
                    }
                    if (EffectsLibraryDialog.this.bufferedObject != null) {
                        if (EffectsLibraryDialog.this.bufferedObject instanceof EffectCategory) {
                            EffectCategory category = new EffectCategory((EffectCategory)EffectsLibraryDialog.this.bufferedObject);
                            EffectsLibrary.getInstance().addCategory(cat, category);
                        } else if (EffectsLibraryDialog.this.bufferedObject instanceof Effect) {
                            Effect effect = new Effect((Effect)EffectsLibraryDialog.this.bufferedObject);
                            EffectsLibrary.getInstance().addEffect(cat, effect);
                        }
                    }
                }
            };
            AbstractAction importAction = new AbstractAction("Import from File"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EffectCategory cat = EffectsLibraryDialog.this.getSelectedCategory();
                    if (cat == null) {
                        return;
                    }
                    Effect effect = EffectsUtil.importEffect();
                    if (effect != null) {
                        EffectsLibrary.getInstance().addEffect(cat, effect);
                    }
                }
            };
            this.add(addGroup);
            this.add(removeGroup);
            this.addSeparator();
            this.add(addEffect);
            this.addSeparator();
            this.add(cutAction);
            this.add(copyAction);
            this.add(pasteAction);
            this.addSeparator();
            this.add(importAction);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    TreePath path = EffectsLibraryDialog.this.libraryTree.getSelectionPath();
                    removeGroup.setEnabled(path.getPathCount() != 1);
                    pasteAction.setEnabled(EffectsLibraryDialog.this.bufferedObject != null);
                }
            });
        }
    }
}

