/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.BlueSystem;
import blue.mixer.Channel;
import blue.mixer.Effect;
import blue.mixer.EffectsChain;
import blue.mixer.Send;
import blue.ui.core.mixer.AddEffectEditorDialog;
import blue.ui.core.mixer.ChannelOutComboBoxModel;
import blue.ui.core.mixer.EffectCategory;
import blue.ui.core.mixer.EffectEditorDialog;
import blue.ui.core.mixer.EffectEditorManager;
import blue.ui.core.mixer.EffectsLibrary;
import blue.ui.core.mixer.EffectsUtil;
import blue.ui.core.mixer.SendEditorManager;
import blue.ui.core.mixer.SubChannelOutComboBoxModel;
import blue.util.ObservableListListener;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.windows.WindowManager;

public class EffectsPopup
extends JPopupMenu
implements ChangeListener {
    private static EffectsPopup popup = null;
    private EffectEditorDialog effectDialog = null;
    private AddEffectEditorDialog addEffectDialog = null;
    Action addInsert;
    Action addNewEffect = new AddNewEffectAction();
    Action addSend = new AddNewSendAction();
    Action removeItem;
    Action openEditor = new OpenEditorAction();
    Action editEffect = new EditEffectAction();
    Action enableDisableEffect = new EnableDisableEffectAction();
    Action cutAction;
    Action copyAction;
    Action pasteAction;
    JMenu effectsMenu = new JMenu("Add Effect");
    private EffectsChain chain;
    private int selectedIndex;
    Action pushUp = new PushUpAction();
    Action pushDown = new PushDownAction();
    Action importToLibrary = new ImportToLibraryAction();
    Effect bufferedEffect = null;
    Action importAction;
    Action exportAction;
    private ComboBoxModel model;
    private ListSelectionModel listSelectionModel;

    private EffectsPopup() {
        this.addInsert = new AbstractAction("Add Insert"){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        };
        this.removeItem = new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object obj;
                if (EffectsPopup.this.selectedIndex >= 0 && EffectsPopup.this.chain != null && (obj = EffectsPopup.this.chain.removeElementAt(EffectsPopup.this.selectedIndex)) instanceof Effect) {
                    Effect effect = (Effect)obj;
                    EffectEditorManager.getInstance().removeEffect(effect);
                }
            }
        };
        this.cutAction = new AbstractAction(BlueSystem.getString((String)"common.cut")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object obj;
                if (EffectsPopup.this.selectedIndex >= 0 && EffectsPopup.this.chain != null && (obj = EffectsPopup.this.chain.removeElementAt(EffectsPopup.this.selectedIndex)) instanceof Effect) {
                    EffectsPopup.this.bufferedEffect = new Effect((Effect)obj);
                    EffectEditorManager.getInstance().removeEffect((Effect)obj);
                }
            }
        };
        this.copyAction = new AbstractAction(BlueSystem.getString((String)"common.copy")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object obj;
                if (EffectsPopup.this.selectedIndex >= 0 && EffectsPopup.this.chain != null && (obj = EffectsPopup.this.chain.getElementAt(EffectsPopup.this.selectedIndex)) instanceof Effect) {
                    EffectsPopup.this.bufferedEffect = new Effect((Effect)obj);
                }
            }
        };
        this.pasteAction = new AbstractAction(BlueSystem.getString((String)"common.paste")){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (EffectsPopup.this.chain != null && EffectsPopup.this.bufferedEffect != null) {
                    Effect clone = new Effect(EffectsPopup.this.bufferedEffect);
                    clone.clearParameters();
                    EffectsPopup.this.chain.addEffect(clone);
                }
            }
        };
        this.importAction = new AbstractAction("Import from File"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EffectsPopup.this.chain == null) {
                    return;
                }
                Effect effect = EffectsUtil.importEffect();
                if (effect != null) {
                    EffectsPopup.this.chain.addEffect(effect);
                }
            }
        };
        this.exportAction = new AbstractAction("Export to File"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj;
                if (EffectsPopup.this.selectedIndex >= 0 && EffectsPopup.this.chain != null && (obj = EffectsPopup.this.chain.getElementAt(EffectsPopup.this.selectedIndex)) instanceof Effect) {
                    EffectsUtil.exportEffect((Effect)obj);
                }
            }
        };
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean itemSelected = EffectsPopup.this.selectedIndex >= 0;
                EffectsPopup.this.removeItem.setEnabled(itemSelected);
                EffectsPopup.this.openEditor.setEnabled(itemSelected);
                EffectsPopup.this.pushUp.setEnabled(EffectsPopup.this.selectedIndex > 0);
                EffectsPopup.this.pushDown.setEnabled(EffectsPopup.this.selectedIndex < EffectsPopup.this.chain.size() - 1);
                EffectsPopup.this.pasteAction.setEnabled(EffectsPopup.this.bufferedEffect != null);
                EffectsPopup.this.enableDisableEffect.setEnabled(itemSelected);
                boolean isEffect = false;
                if (itemSelected) {
                    Object obj = EffectsPopup.this.chain.getElementAt(EffectsPopup.this.selectedIndex);
                    if (obj instanceof Effect) {
                        Effect effect = (Effect)obj;
                        if (effect.isEnabled()) {
                            EffectsPopup.this.enableDisableEffect.putValue("Name", "Disable Effect");
                        } else {
                            EffectsPopup.this.enableDisableEffect.putValue("Name", "Enable Effect");
                        }
                        EffectsPopup.this.openEditor.putValue("Name", "Open Editor for Effect");
                        isEffect = true;
                    } else {
                        Send send = (Send)obj;
                        if (send.isEnabled()) {
                            EffectsPopup.this.enableDisableEffect.putValue("Name", "Disable Send");
                        } else {
                            EffectsPopup.this.enableDisableEffect.putValue("Name", "Enable Send");
                        }
                        EffectsPopup.this.openEditor.putValue("Name", "Open Editor for Send");
                    }
                }
                EffectsPopup.this.editEffect.setEnabled(isEffect && itemSelected);
                EffectsPopup.this.importToLibrary.setEnabled(isEffect && itemSelected);
                EffectsPopup.this.cutAction.setEnabled(isEffect && itemSelected);
                EffectsPopup.this.copyAction.setEnabled(isEffect && itemSelected);
                EffectsPopup.this.exportAction.setEnabled(isEffect && itemSelected);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        EffectsLibrary.getInstance().addChangeListener(this);
        this.reinitialize();
    }

    public void setEffectsChain(EffectsChain chain, int selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.chain = chain;
    }

    public void setMaster(boolean isMaster) {
        this.addSend.setEnabled(!isMaster);
    }

    public void setComboBoxModel(ComboBoxModel model) {
        this.model = model;
    }

    public static EffectsPopup getInstance() {
        if (popup == null) {
            popup = new EffectsPopup();
        }
        return popup;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.reinitialize();
    }

    private void reinitialize() {
        this.removeAll();
        this.effectsMenu.removeAll();
        EffectsLibrary library = EffectsLibrary.getInstance();
        this.populateMenu(library.getRootEffectCategory(), this.effectsMenu);
        this.add(this.addNewEffect);
        this.add(this.effectsMenu);
        this.addSeparator();
        this.add(this.addSend);
        this.addSeparator();
        this.add(this.pushUp);
        this.add(this.pushDown);
        this.addSeparator();
        this.add(this.openEditor);
        this.add(this.editEffect);
        this.add(this.enableDisableEffect);
        this.addSeparator();
        this.add(this.cutAction);
        this.add(this.copyAction);
        this.add(this.pasteAction);
        this.addSeparator();
        this.add(this.importToLibrary);
        this.addSeparator();
        this.add(this.removeItem);
        this.addSeparator();
        this.add(this.importAction);
        this.add(this.exportAction);
    }

    private void populateMenu(EffectCategory category, JMenu menu) {
        JMenu currentMenu = menu;
        ArrayList categories = category.getSubCategories();
        ArrayList effects = category.getEffects();
        for (int i = 0; i < categories.size(); ++i) {
            EffectCategory cat = (EffectCategory)categories.get(i);
            JMenu catMenu = new JMenu(cat.getCategoryName());
            menu.add(catMenu);
            this.populateMenu(cat, catMenu);
        }
        int counter = 0;
        for (int i = 0; i < effects.size(); ++i) {
            Effect effect = (Effect)effects.get(i);
            AddEffectAction action = new AddEffectAction(effect);
            if (counter < 10) {
                currentMenu.add(action);
                ++counter;
                continue;
            }
            JMenu tempMenu = new JMenu(BlueSystem.getString((String)"menu.more"));
            currentMenu.add(tempMenu);
            currentMenu = tempMenu;
            currentMenu.add(action);
            counter = 1;
        }
    }

    void setListSelectionModel(ListSelectionModel selectionModel) {
        this.listSelectionModel = selectionModel;
    }

    class AddNewSendAction
    extends AbstractAction {
        public AddNewSendAction() {
            this.putValue("Name", "Add New Send");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EffectsPopup.this.chain != null) {
                Send send = new Send();
                EffectsPopup.this.chain.addSend(send);
                ObservableListListener<Channel> temp = null;
                if (EffectsPopup.this.model instanceof ChannelOutComboBoxModel) {
                    temp = ((ChannelOutComboBoxModel)EffectsPopup.this.model).getCopy();
                } else if (EffectsPopup.this.model instanceof SubChannelOutComboBoxModel) {
                    temp = ((SubChannelOutComboBoxModel)EffectsPopup.this.model).getCopy();
                }
                Frame root = WindowManager.getDefault().getMainWindow();
                SendEditorManager.getInstance().openSendEditor(root, send, (ComboBoxModel)temp);
            }
        }
    }

    class AddNewEffectAction
    extends AbstractAction {
        public AddNewEffectAction() {
            this.putValue("Name", "Add New Effect");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EffectsPopup.this.chain != null) {
                if (EffectsPopup.this.addEffectDialog == null) {
                    Frame root = WindowManager.getDefault().getMainWindow();
                    EffectsPopup.this.addEffectDialog = new AddEffectEditorDialog(root);
                }
                EffectsPopup.this.addEffectDialog.setEffect(null);
                boolean val = EffectsPopup.this.addEffectDialog.ask();
                if (val) {
                    Effect effect = EffectsPopup.this.addEffectDialog.getEffect();
                    EffectsPopup.this.chain.addEffect(effect);
                }
            }
        }
    }

    class EnableDisableEffectAction
    extends AbstractAction {
        public EnableDisableEffectAction() {
            this.putValue("Name", "Disable Effect");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EffectsPopup.this.chain != null && EffectsPopup.this.selectedIndex >= 0) {
                Object obj = EffectsPopup.this.chain.getElementAt(EffectsPopup.this.selectedIndex);
                if (obj instanceof Effect) {
                    Effect effect;
                    effect.setEnabled(!(effect = (Effect)obj).isEnabled());
                } else if (obj instanceof Send) {
                    Send send;
                    send.setEnabled(!(send = (Send)obj).isEnabled());
                }
            }
        }
    }

    class EditEffectAction
    extends AbstractAction {
        public EditEffectAction() {
            this.putValue("Name", "Edit Effect");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj;
            if (EffectsPopup.this.chain != null && EffectsPopup.this.selectedIndex >= 0 && (obj = EffectsPopup.this.chain.getElementAt(EffectsPopup.this.selectedIndex)) instanceof Effect) {
                Effect effect = (Effect)obj;
                if (EffectsPopup.this.effectDialog == null) {
                    Frame root = WindowManager.getDefault().getMainWindow();
                    EffectsPopup.this.effectDialog = new EffectEditorDialog(root, true);
                }
                EffectsPopup.this.effectDialog.setEffect(effect);
                EffectsPopup.this.effectDialog.show();
                EffectEditorManager.getInstance().updateEffectInterface(effect);
            }
        }
    }

    class OpenEditorAction
    extends AbstractAction {
        public OpenEditorAction() {
            this.putValue("Name", "Open Interface for Effect");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EffectsPopup.this.chain != null && EffectsPopup.this.selectedIndex >= 0) {
                Object obj = EffectsPopup.this.chain.getElementAt(EffectsPopup.this.selectedIndex);
                Frame root = WindowManager.getDefault().getMainWindow();
                if (obj instanceof Effect) {
                    Effect effect = (Effect)obj;
                    EffectEditorManager.getInstance().openEffectEditor(root, effect);
                } else if (obj instanceof Send) {
                    Send send = (Send)obj;
                    ObservableListListener<Channel> temp = null;
                    if (EffectsPopup.this.model instanceof ChannelOutComboBoxModel) {
                        temp = ((ChannelOutComboBoxModel)EffectsPopup.this.model).getCopy();
                    } else if (EffectsPopup.this.model instanceof SubChannelOutComboBoxModel) {
                        temp = ((SubChannelOutComboBoxModel)EffectsPopup.this.model).getCopy();
                    }
                    SendEditorManager.getInstance().openSendEditor(root, send, (ComboBoxModel)temp);
                }
            }
        }
    }

    class ImportToLibraryAction
    extends AbstractAction {
        public ImportToLibraryAction() {
            this.putValue("Name", "Import to Effects Library");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj;
            if (EffectsPopup.this.chain != null && EffectsPopup.this.selectedIndex >= 0 && (obj = EffectsPopup.this.chain.getElementAt(EffectsPopup.this.selectedIndex)) instanceof Effect) {
                Effect effect = (Effect)obj;
                Effect copy = new Effect(effect);
                EffectsLibrary library = EffectsLibrary.getInstance();
                library.importEffect(copy);
            }
        }
    }

    class PushDownAction
    extends AbstractAction {
        public PushDownAction() {
            this.putValue("Name", "Push Down");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EffectsPopup.this.chain != null && EffectsPopup.this.selectedIndex < EffectsPopup.this.chain.size() - 1) {
                EffectsPopup.this.chain.pushDown(EffectsPopup.this.selectedIndex);
                if (EffectsPopup.this.listSelectionModel != null) {
                    EffectsPopup.this.listSelectionModel.setSelectionInterval(EffectsPopup.this.listSelectionModel.getMinSelectionIndex() + 1, EffectsPopup.this.listSelectionModel.getMaxSelectionIndex() + 1);
                }
            }
        }
    }

    class PushUpAction
    extends AbstractAction {
        public PushUpAction() {
            this.putValue("Name", "Push Up");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EffectsPopup.this.chain != null && EffectsPopup.this.selectedIndex > 0) {
                EffectsPopup.this.chain.pushUp(EffectsPopup.this.selectedIndex);
                if (EffectsPopup.this.listSelectionModel != null) {
                    EffectsPopup.this.listSelectionModel.setSelectionInterval(EffectsPopup.this.listSelectionModel.getMinSelectionIndex() - 1, EffectsPopup.this.listSelectionModel.getMaxSelectionIndex() - 1);
                }
            }
        }
    }

    class AddEffectAction
    extends AbstractAction {
        private Effect effect;

        public AddEffectAction(Effect effect) {
            this.effect = effect;
            this.putValue("Name", effect.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EffectsPopup.this.chain != null) {
                Effect copy = new Effect(this.effect);
                copy.clearParameters();
                copy.setEnabled(true);
                EffectsPopup.this.chain.addEffect(copy);
            }
        }
    }
}

