/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.mixer.Send;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SubChannelOutComboBoxModel
implements ComboBoxModel,
ObservableListListener<Channel> {
    ChannelList channels = null;
    String selectedItem = null;
    Vector listeners = null;
    private Channel channel;
    private Vector copies = null;

    public void setData(ChannelList subChannels, Channel c) {
        if (this.channels != null) {
            this.channels.removeListener((ObservableListListener)this);
        }
        this.channels = subChannels;
        this.channel = c;
        this.channels.addListener((ObservableListListener)this);
    }

    public void clearListeners() {
        this.channels.removeListener((ObservableListListener)this);
        this.channels = null;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        int index;
        this.selectedItem = "Master".equals(anItem) ? "Master" : ((index = this.channels.indexByName(anItem)) < 0 ? "Master" : (String)anItem);
        ListDataEvent lde = new ListDataEvent(this, 0, -1, -1);
        this.fireListEvent(lde);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        return this.getReducedList().size();
    }

    @Override
    public Object getElementAt(int index) {
        ArrayList choices = this.getReducedList();
        return choices.get(index);
    }

    private ArrayList getReducedList() {
        if (this.channels == null) {
            return null;
        }
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add("Master");
        for (int i = 0; i < this.channels.size(); ++i) {
            Channel c = (Channel)this.channels.get(i);
            if (c == this.channel || !this.isPossibleOut(c, this.channel.getName())) continue;
            retVal.add(c.getName());
        }
        return retVal;
    }

    private Channel getChannelByName(String name) {
        for (int i = 0; i < this.channels.size(); ++i) {
            Channel c = (Channel)this.channels.get(i);
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    private boolean isPossibleOut(Channel c, String name) {
        if (c.getName().equals(name)) {
            return false;
        }
        Send[] sends = c.getSends();
        for (int i = 0; i < sends.length; ++i) {
            Channel next;
            if (sends[i].getSendChannel().equals(name)) {
                return false;
            }
            String sendChannelName = sends[i].getSendChannel();
            if (sendChannelName.equals("Master") || this.isPossibleOut(next = this.getChannelByName(sendChannelName), name)) continue;
            return false;
        }
        String outChannel = c.getOutChannel();
        if (outChannel.equals(name)) {
            return false;
        }
        if (outChannel.equals("Master")) {
            return true;
        }
        Channel next = this.getChannelByName(outChannel);
        return this.isPossibleOut(next, name);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private void fireListEvent(ListDataEvent lde) {
        if (this.listeners == null) {
            return;
        }
        for (ListDataListener listener : this.listeners) {
            switch (lde.getType()) {
                case 1: {
                    listener.intervalAdded(lde);
                    break;
                }
                case 2: {
                    listener.intervalRemoved(lde);
                    break;
                }
                case 0: {
                    listener.contentsChanged(lde);
                }
            }
        }
    }

    public void reconcile(String oldName, String newName) {
        Object selected = this.getSelectedItem();
        if (selected == null || selected.toString().equals(oldName)) {
            this.setSelectedItem(newName);
        }
        if (this.copies != null) {
            for (int i = 0; i < this.copies.size(); ++i) {
                ((SubChannelOutComboBoxModel)this.copies.get(i)).reconcile(oldName, newName);
            }
        }
    }

    public ChannelList getChannels() {
        return this.channels;
    }

    public SubChannelOutComboBoxModel getCopy() {
        SubChannelOutComboBoxModel copy = new SubChannelOutComboBoxModel();
        copy.setData(this.channels, this.channel);
        if (this.copies == null) {
            this.copies = new Vector();
        }
        this.copies.add(copy);
        return copy;
    }

    public void listChanged(ObservableListEvent<Channel> listEvent) {
        switch (listEvent.getType()) {
            case 0: {
                this.intervalAdded(listEvent);
                break;
            }
            case 1: {
                this.intervalRemoved(listEvent);
                break;
            }
            case 2: {
                this.contentsChanged();
            }
        }
    }

    public void intervalAdded(ObservableListEvent<Channel> e) {
        ListDataEvent lde = new ListDataEvent(this, 0, -1, -1);
        this.fireListEvent(lde);
        if (this.copies != null) {
            for (int i = 0; i < this.copies.size(); ++i) {
                ((SubChannelOutComboBoxModel)this.copies.get(i)).intervalAdded(e);
            }
        }
    }

    public void intervalRemoved(ObservableListEvent<Channel> e) {
        if (this.channels.indexByName((Object)this.selectedItem) < 0) {
            this.setSelectedItem("Master");
        }
        if (this.copies != null) {
            for (int i = 0; i < this.copies.size(); ++i) {
                ((SubChannelOutComboBoxModel)this.copies.get(i)).intervalRemoved(e);
            }
        }
    }

    public void contentsChanged() {
    }
}

