/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor;

import blue.BlueSystem;
import blue.orchestra.BlueX7;
import blue.orchestra.Instrument;
import blue.orchestra.editor.InstrumentEditor;
import blue.ui.core.orchestra.editor.blueX7.AlgorithmCommonPanel;
import blue.ui.core.orchestra.editor.blueX7.BlueX7ImportDialog;
import blue.ui.core.orchestra.editor.blueX7.CsoundCodePanel;
import blue.ui.core.orchestra.editor.blueX7.EnvelopeGeneratorPanel;
import blue.ui.core.orchestra.editor.blueX7.LFOPanel;
import blue.ui.core.orchestra.editor.blueX7.OperatorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class BlueX7Editor
extends InstrumentEditor {
    AlgorithmCommonPanel common = new AlgorithmCommonPanel();
    LFOPanel lfo = new LFOPanel();
    OperatorPanel[] operators = new OperatorPanel[6];
    EnvelopeGeneratorPanel PEG = new EnvelopeGeneratorPanel("Envelope Generator", "Rate ", "Pitch ");
    CsoundCodePanel csoundCodePanel = new CsoundCodePanel();
    JButton importButton = new JButton(BlueSystem.getString((String)"common.import"));
    BlueX7 blueX7;
    ChangeListener modPitchListener = e -> {
        if (this.isUpdatingData) {
            return;
        }
        int val = ((JSlider)e.getSource()).getValue();
        for (int i = 0; i < this.operators.length; ++i) {
            this.operators[i].modulation.pitch.setValue(val);
        }
    };
    ActionListener syncListener = e -> {
        if (this.isUpdatingData) {
            return;
        }
        int val = ((JComboBox)e.getSource()).getSelectedIndex();
        for (int i = 0; i < this.operators.length; ++i) {
            this.operators[i].oscilator.syncCombo.setSelectedIndex(val);
        }
    };
    boolean isUpdatingData = false;

    public BlueX7Editor() {
        this.importButton.addActionListener(e -> this.importFromSysex());
        JTabbedPane operatorPanel = new JTabbedPane();
        for (int i = 0; i < 6; ++i) {
            this.operators[i] = new OperatorPanel();
            operatorPanel.add("Op " + (i + 1), this.operators[i]);
            this.operators[i].modulation.pitch.addChangeListener(this.modPitchListener);
            this.operators[i].oscilator.syncCombo.addActionListener(this.syncListener);
        }
        this.PEG.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        operatorPanel.add("PEG", this.PEG);
        JPanel top = new JPanel(new GridLayout(1, 2));
        top.add(this.common);
        top.add(this.lfo);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)top, "North");
        mainPanel.add((Component)operatorPanel, "Center");
        JLabel title = new JLabel("blueX7");
        title.setFont(new Font("Monospaced", 1, 30));
        Box box = Box.createHorizontalBox();
        box.add(title);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.importButton);
        box.add(Box.createGlue());
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(box, "North");
        JTabbedPane tabs = new JTabbedPane();
        JPanel csoundPanel = new JPanel();
        JScrollPane mainScroll = new JScrollPane();
        mainScroll.getViewport().add(mainPanel);
        csoundPanel.setLayout(new BorderLayout());
        csoundPanel.add((Component)this.csoundCodePanel, "Center");
        tabs.add(BlueSystem.getString((String)"instrument.instrument"), mainScroll);
        tabs.add("Csound", csoundPanel);
        this.add(tabs, "Center");
    }

    private void importFromSysex() {
        if (this.blueX7 == null) {
            System.err.println("[ERROR] BlueX7Editor::importFromSysex() - null blueX7");
            return;
        }
        BlueX7ImportDialog.importFromDX7File(this.blueX7);
        this.editInstrument((Instrument)this.blueX7);
    }

    public void editInstrument(Instrument instr) {
        if (instr == null || !(instr instanceof BlueX7)) {
            this.blueX7 = null;
            System.err.println("[ERROR] BlueX7Editor::editInstrument - not instance of blueX7");
            return;
        }
        this.isUpdatingData = true;
        BlueX7 blueX7 = (BlueX7)instr;
        this.common.editBlueX7(blueX7);
        this.lfo.editBlueX7(blueX7);
        this.csoundCodePanel.editBlueX7(blueX7);
        for (int i = 0; i < this.operators.length; ++i) {
            this.operators[i].editOperator(blueX7.operators[i]);
        }
        this.PEG.setPoints(blueX7.peg);
        this.blueX7 = blueX7;
        this.isUpdatingData = false;
    }
}

