/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import blue.noteProcessor.TempoMapper;
import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.services.render.RenderTimeManager;
import blue.services.render.RenderTimeManagerListener;
import blue.settings.PlaybackSettings;
import blue.soundObject.PolyObject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jdesktop.core.animation.timing.TimingSource;
import org.jdesktop.swing.animation.timing.sources.SwingTimerTimingSource;

public class RenderTimeManagerImpl
implements RenderTimeManager {
    private static RenderTimeManagerImpl renderManager;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private ArrayList<RenderTimeManagerListener> renderListeners = new ArrayList();
    protected double renderStart = -1.0;
    private double timePointer = 0.0;
    private int timeAdjustCounter = 0;
    private double timeAdjust = Double.NEGATIVE_INFINITY;
    private TempoMapper tempoMapper;
    private PolyObject polyObject;
    TimingSource ts = null;
    BlueProject currentRenderingProject = null;

    public void initiateRender(double renderStart) {
        this.setRenderStart(renderStart);
        for (RenderTimeManagerListener listener : this.renderListeners) {
            listener.renderInitiated();
        }
        if (this.ts != null) {
            this.ts.dispose();
            this.ts = null;
        }
        int fps = PlaybackSettings.getInstance().getPlaybackFPS();
        this.ts = new SwingTimerTimingSource((long)((int)(1000.0f / (float)fps)), TimeUnit.MILLISECONDS);
        long initialTime = System.nanoTime();
        this.ts.addTickListener((source, nanoTime) -> {
            if (this.timeAdjust != Double.NEGATIVE_INFINITY) {
                double elapsedTime = (float)(nanoTime - initialTime) / 1.0E9f;
                double adjustedTime = elapsedTime - this.timeAdjust;
                this.setTimePointer(elapsedTime);
                if (this.tempoMapper != null) {
                    double renderStartSeconds = this.tempoMapper.beatsToSeconds(this.getRenderStartTime());
                    adjustedTime = this.tempoMapper.secondsToBeats(adjustedTime + renderStartSeconds);
                    adjustedTime -= this.getRenderStartTime();
                }
                for (RenderTimeManagerListener listener : this.renderListeners) {
                    listener.renderTimeUpdated(adjustedTime);
                }
            }
        });
        this.ts.init();
        this.currentRenderingProject = BlueProjectManager.getInstance().getCurrentProject();
    }

    public void updateTimePointer(double timePointer) {
        if (this.timeAdjustCounter == 0) {
            double timeP = this.timePointer >= 0.0 ? this.timePointer : 0.0;
            this.timeAdjust = timeP - timePointer;
        }
        ++this.timeAdjustCounter;
        if (this.timeAdjustCounter == 10) {
            this.timeAdjustCounter = 0;
        }
    }

    public void endRender() {
        this.setRenderStart(-1.0);
        this.setTimePointer(-1.0);
        this.timeAdjust = Double.NEGATIVE_INFINITY;
        this.polyObject = null;
        for (RenderTimeManagerListener listener : this.renderListeners) {
            listener.renderEnded();
        }
        if (this.ts != null) {
            this.ts.dispose();
            this.ts = null;
        }
        this.timeAdjustCounter = 0;
        this.currentRenderingProject = null;
    }

    private void setRenderStart(double renderStart) {
        double oldVal = this.renderStart;
        this.renderStart = renderStart;
        this.listeners.firePropertyChange("renderStart", new Double(oldVal), new Double(renderStart));
    }

    private void setTimePointer(double timePointer) {
        double newVal;
        double oldTime = this.timePointer;
        this.timePointer = newVal = timePointer;
    }

    public double getRenderStartTime() {
        return this.renderStart;
    }

    public double getRenderTime() {
        return this.timePointer - this.timeAdjust;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.removePropertyChangeListener(pcl);
    }

    public void setTempoMapper(TempoMapper tempoMapper) {
        this.tempoMapper = tempoMapper;
    }

    public TempoMapper getTempoMapper() {
        return this.tempoMapper;
    }

    public void addRenderTimeManagerListener(RenderTimeManagerListener listener) {
        this.renderListeners.add(listener);
    }

    public void removeRenderTimeManagerListener(RenderTimeManagerListener listener) {
        this.renderListeners.remove(listener);
    }

    public boolean isCurrentProjectRendering() {
        return this.currentRenderingProject == BlueProjectManager.getInstance().getCurrentProject();
    }
}

