/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.BlueData;
import blue.SoundLayer;
import blue.projects.BlueProjectManager;
import blue.score.ScoreObject;
import blue.soundObject.Instance;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.object.actions.AlignRightAction;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class AddToSoundObjectLibraryAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> scoreObjects;
    private final Collection<? extends SoundObject> soundObjects;
    private final ScorePath scorePath;
    private final Point p;

    public AddToSoundObjectLibraryAction() {
        this(Utilities.actionsGlobalContext());
    }

    public AddToSoundObjectLibraryAction(Lookup lookup) {
        super(NbBundle.getMessage(AlignRightAction.class, (String)"CTL_AddToSoundObjectLibraryAction"));
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
        this.soundObjects = lookup.lookupAll(SoundObject.class);
        this.p = (Point)lookup.lookup(Point.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SoundObject sObj = this.soundObjects.iterator().next().deepCopy();
        if (sObj instanceof Instance) {
            return;
        }
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        Instance i = new Instance(sObj);
        i.setStartTime(sObj.getStartTime());
        i.setSubjectiveDuration(sObj.getSubjectiveDuration());
        data.getSoundObjectLibrary().addSoundObject(sObj);
        SoundLayer layer = (SoundLayer)this.scorePath.getGlobalLayerForY(this.p.y);
        layer.remove((ScoreObject)this.soundObjects.iterator().next());
        layer.add((SoundObject)i);
    }

    @Override
    public boolean isEnabled() {
        return this.scoreObjects.size() == this.soundObjects.size() && this.soundObjects.size() == 1 && !(this.soundObjects.iterator().next() instanceof Instance);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AddToSoundObjectLibraryAction(actionContext);
    }
}

