/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.BlueSystem;
import blue.gui.InfoDialog;
import blue.udo.UserDefinedOpcode;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.ui.utilities.SimpleDocumentListener;
import blue.undo.TabWatchingUndoableEditGenerator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;
import org.openide.util.NbBundle;

public class UDOEditor
extends JPanel {
    private boolean isUpdating = false;
    UserDefinedOpcode udo = null;
    UndoManager undo = new UndoRedo.Manager();
    MimeTypeEditorComponent codeBody = new MimeTypeEditorComponent("text/x-csound-orc");
    MimeTypeEditorComponent comments = new MimeTypeEditorComponent("text/plain");
    private JTextField inTypes;
    private JLabel inTypesLabel;
    private JTabbedPane jTabbedPane1;
    private JTextField outTypes;
    private JLabel outTypesLabel;
    private JButton testOpcodeButton;

    public UDOEditor() {
        this.initComponents();
        SimpleDocumentListener dl = new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                UDOEditor.this.updateValue(e.getDocument());
            }
        };
        this.jTabbedPane1.insertTab("Code", null, (Component)this.codeBody, null, 0);
        this.jTabbedPane1.insertTab("Comments", null, (Component)this.comments, null, 1);
        this.jTabbedPane1.setSelectedIndex(0);
        this.outTypes.getDocument().addDocumentListener((DocumentListener)dl);
        this.inTypes.getDocument().addDocumentListener((DocumentListener)dl);
        this.codeBody.getDocument().addDocumentListener((DocumentListener)dl);
        this.comments.getDocument().addDocumentListener((DocumentListener)dl);
        this.testOpcodeButton.addActionListener(e -> this.testOpcode());
        this.jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.editUserDefinedOpcode(null);
        new TabWatchingUndoableEditGenerator(this.jTabbedPane1, this.undo);
        this.outTypes.getDocument().addUndoableEditListener(this.undo);
        this.inTypes.getDocument().addUndoableEditListener(this.undo);
        this.codeBody.getDocument().addUndoableEditListener(this.undo);
        this.comments.getDocument().addUndoableEditListener(this.undo);
        AbstractAction undoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UDOEditor.this.undo.canUndo()) {
                    UDOEditor.this.undo.undo();
                }
            }
        };
        AbstractAction redoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UDOEditor.this.undo.canRedo()) {
                    UDOEditor.this.undo.redo();
                }
            }
        };
        this.outTypes.getDocument().addDocumentListener((DocumentListener)dl);
        this.inTypes.getDocument().addDocumentListener((DocumentListener)dl);
        this.codeBody.getDocument().addDocumentListener((DocumentListener)dl);
        this.comments.getDocument().addDocumentListener((DocumentListener)dl);
        this.setUndoActions(this.outTypes, undoAction, redoAction);
        this.setUndoActions(this.inTypes, undoAction, redoAction);
        this.codeBody.setUndoManager(this.undo);
        this.undo.setLimit(1000);
    }

    private void setUndoActions(JComponent field, Action undoAction, Action redoAction) {
        KeyStroke undoKeyStroke = KeyStroke.getKeyStroke(90, BlueSystem.getMenuShortcutKey());
        KeyStroke redoKeyStroke = KeyStroke.getKeyStroke(90, BlueSystem.getMenuShortcutKey() | 0x40);
        field.getInputMap().put(undoKeyStroke, "undo");
        field.getInputMap().put(redoKeyStroke, "redo");
        field.getActionMap().put("undo", undoAction);
        field.getActionMap().put("redo", redoAction);
    }

    protected void testOpcode() {
        if (this.udo != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), this.udo.generateCode(), "User-Defined Opcode");
        }
    }

    protected void updateValue(Document document) {
        if (this.udo == null || this.isUpdating) {
            return;
        }
        if (document == this.outTypes.getDocument()) {
            this.udo.outTypes = this.outTypes.getText();
        } else if (document == this.inTypes.getDocument()) {
            this.udo.inTypes = this.inTypes.getText();
        } else if (document == this.codeBody.getDocument()) {
            this.udo.codeBody = this.codeBody.getText();
        } else if (document == this.comments.getDocument()) {
            this.udo.comments = this.comments.getText();
        }
    }

    public void editUserDefinedOpcode(UserDefinedOpcode udo) {
        this.isUpdating = true;
        this.udo = udo;
        this.setFields(udo);
        this.isUpdating = false;
        this.undo.discardAllEdits();
    }

    private void setFields(UserDefinedOpcode udo) {
        if (udo == null) {
            this.outTypes.setText("");
            this.inTypes.setText("");
            this.codeBody.setText("");
            this.comments.setText("");
            this.outTypes.setEnabled(false);
            this.inTypes.setEnabled(false);
            this.codeBody.getJEditorPane().setEnabled(false);
            this.comments.getJEditorPane().setEnabled(false);
        } else {
            this.outTypes.setText(udo.outTypes);
            this.inTypes.setText(udo.inTypes);
            this.codeBody.setText(udo.codeBody);
            this.comments.setText(udo.comments);
            this.outTypes.setEnabled(true);
            this.inTypes.setEnabled(true);
            this.codeBody.getJEditorPane().setEnabled(true);
            this.comments.getJEditorPane().setEnabled(true);
        }
        this.codeBody.getJEditorPane().setCaretPosition(0);
        this.comments.getJEditorPane().setCaretPosition(0);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.outTypesLabel = new JLabel();
        this.outTypes = new JTextField();
        this.inTypesLabel = new JLabel();
        this.inTypes = new JTextField();
        this.testOpcodeButton = new JButton();
        this.outTypesLabel.setText(NbBundle.getMessage(UDOEditor.class, (String)"UDOEditor.outTypesLabel.text"));
        this.outTypes.setText(NbBundle.getMessage(UDOEditor.class, (String)"UDOEditor.outTypes.text"));
        this.inTypesLabel.setText(NbBundle.getMessage(UDOEditor.class, (String)"UDOEditor.inTypesLabel.text"));
        this.inTypes.setText(NbBundle.getMessage(UDOEditor.class, (String)"UDOEditor.inTypes.text"));
        this.testOpcodeButton.setText(NbBundle.getMessage(UDOEditor.class, (String)"UDOEditor.testOpcodeButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 610, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.outTypesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outTypes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inTypesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inTypes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testOpcodeButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testOpcodeButton).addComponent(this.outTypes, -2, -1, -2).addComponent(this.inTypesLabel).addComponent(this.outTypesLabel).addComponent(this.inTypes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 263, Short.MAX_VALUE)));
    }
}

