/*
 * Decompiled with CFR 0.152.
 */
package blue.osc;

import blue.osc.OSCAction;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCServer;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class OSCManager
implements OSCListener {
    private static OSCManager instance = null;
    private ArrayList<OSCAction> oscActions = new ArrayList();
    private OSCServer server = null;
    final Preferences prefs = NbPreferences.forModule(OSCManager.class);

    private OSCManager() {
        this.prefs.addPreferenceChangeListener(evt -> {
            if (this.server != null) {
                this.stop();
                this.start();
            }
        });
    }

    public static OSCManager getInstance() {
        if (instance == null) {
            instance = new OSCManager();
        }
        return instance;
    }

    public void start() {
        int inputPort = this.prefs.getInt("serverPort", 8000);
        try {
            this.server = OSCServer.newUsing((String)"udp", (int)inputPort, (boolean)false);
            this.server.addOSCListener((OSCListener)this);
            this.server.start();
        }
        catch (IOException ex) {
            Logger.getLogger(OSCManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (IOException ex) {
                Logger.getLogger(OSCManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.server.dispose();
            this.server = null;
        }
    }

    public void registerOSCAction(OSCAction action) {
        this.oscActions.add(action);
    }

    public void deregisterOSCAction(OSCAction action) {
        this.oscActions.remove(action);
    }

    public void messageReceived(OSCMessage oscm, SocketAddress sa, long l) {
        String port = oscm.getName();
        for (OSCAction action : this.oscActions) {
            if (!port.startsWith(action.getOscPath())) continue;
            action.actionPerformed(oscm);
            break;
        }
    }
}

