/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.TabContainer;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.TabDisplayerFactory;
import org.netbeans.core.windows.view.ui.tabcontrol.AbstractTabbedImpl;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.openide.windows.TopComponent;

public final class TabbedImpl
extends AbstractTabbedImpl {
    private final TabContainer container;
    private final Controller controller;
    private final DefaultTabDataModel tabModel;
    private ComponentConverter componentConverter = ComponentConverter.DEFAULT;

    public TabbedImpl(WinsysInfoForTabbedContainer winsysInfo, int orientation) {
        this.tabModel = new DefaultTabDataModel();
        TabDisplayer displayer = TabDisplayerFactory.getDefault().createTabDisplayer((TabDataModel)this.tabModel, orientation);
        this.controller = new Controller(displayer);
        this.container = new TabContainer(this, displayer, orientation);
        this.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedImpl.this.fireStateChanged();
            }
        });
    }

    protected final TabDataModel getTabModel() {
        return this.tabModel;
    }

    protected final SingleSelectionModel getSelectionModel() {
        return this.controller.getSelectionModel();
    }

    protected void requestAttention(int tabIndex) {
    }

    protected void cancelRequestAttention(int tabIndex) {
    }

    protected void setAttentionHighlight(int tabIndex, boolean highlight) {
    }

    protected int dropIndexOfPoint(Point location) {
        location = SwingUtilities.convertPoint(this.getComponent(), location, this.getTabDisplayer());
        return this.getTabDisplayer().dropIndexOfPoint(location);
    }

    protected ComponentConverter getComponentConverter() {
        return this.componentConverter;
    }

    protected Shape getDropIndication(TopComponent draggedTC, Point location) {
        location = SwingUtilities.convertPoint(this.getComponent(), location, this.getTabDisplayer());
        Path2D.Double res = new Path2D.Double();
        Rectangle tabRect = this.getTabDisplayer().dropIndication(draggedTC, location);
        if (null != tabRect) {
            tabRect = SwingUtilities.convertRectangle(this.getTabDisplayer(), tabRect, this.container);
            res.append(tabRect, false);
        }
        res.append(this.container.getContentArea(), false);
        return res;
    }

    public void addActionListener(ActionListener al) {
        this.controller.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.controller.removeActionListener(al);
    }

    public int getTabCount() {
        return this.getTabModel().size();
    }

    public int indexOf(Component comp) {
        int max = this.getTabModel().size();
        TabDataModel mdl = this.getTabModel();
        for (int i = 0; i < max; ++i) {
            if (this.getComponentConverter().getComponent(mdl.getTab(i)) != comp) continue;
            return i;
        }
        return -1;
    }

    public void setTitleAt(int index, String title) {
        this.getTabModel().setText(index, title);
    }

    public void setIconAt(int index, Icon icon) {
        this.getTabModel().setIcon(index, icon);
    }

    public void setToolTipTextAt(int index, String toolTip) {
        this.tabModel.setToolTipTextAt(index, toolTip);
    }

    public void setActive(boolean active) {
    }

    public int tabForCoordinate(Point p) {
        p = SwingUtilities.convertPoint(this.getComponent(), p, this.getTabDisplayer());
        TabData td = this.getTabDisplayer().getTabAt(p);
        if (null == td) {
            return -1;
        }
        return this.tabModel.indexOf(td);
    }

    public Image createImageOfTab(int tabIndex) {
        return null;
    }

    public Component getComponent() {
        return this.container;
    }

    public Rectangle getTabBounds(int tabIndex) {
        Rectangle res = this.getTabDisplayer().getTabBounds(tabIndex);
        if (null != res) {
            res = SwingUtilities.convertRectangle(this.getTabDisplayer(), res, this.container);
        }
        return res;
    }

    public Rectangle getTabsArea() {
        Rectangle res = this.container.getTabDisplayer().getTabsArea();
        res = SwingUtilities.convertRectangle(this.getTabDisplayer(), res, this.container);
        return res;
    }

    public boolean isTransparent() {
        return false;
    }

    public void setTransparent(boolean transparent) {
    }

    public void makeBusy(TopComponent tc, boolean busy) {
        int tabIndex = this.indexOf((Component)tc);
        BusyTabsSupport.getDefault().makeTabBusy((Tabbed)this, tabIndex, busy);
    }

    private TabDisplayer getTabDisplayer() {
        return this.container.getTabDisplayer();
    }
}

