/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.CompileData;
import blue.SoundLayerException;
import blue.SoundLayerListener;
import blue.automation.ParameterIdList;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObject;
import blue.score.layers.AutomatableLayer;
import blue.score.layers.ScoreObjectLayer;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.utility.ObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Vector;

public final class SoundLayer
extends ArrayList<SoundObject>
implements ScoreObjectLayer<SoundObject>,
AutomatableLayer {
    private transient Vector<PropertyChangeListener> propListeners = null;
    private transient Vector<SoundLayerListener> layerListeners = null;
    private static Comparator sObjComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            double bStart;
            SoundObject a = (SoundObject)arg0;
            SoundObject b = (SoundObject)arg1;
            double aStart = a.getStartTime();
            if (aStart > (bStart = b.getStartTime())) {
                return 1;
            }
            if (aStart < bStart) {
                return -1;
            }
            return 0;
        }
    };
    private ParameterIdList automationParameters;
    private String name = "";
    private boolean muted = false;
    private boolean solo = false;
    private NoteProcessorChain npc;
    private int heightIndex = 0;

    public SoundLayer() {
        this.automationParameters = new ParameterIdList();
        this.npc = new NoteProcessorChain();
    }

    public SoundLayer(SoundLayer sLayer) {
        this.name = sLayer.name;
        this.muted = sLayer.muted;
        this.solo = sLayer.solo;
        this.npc = new NoteProcessorChain(sLayer.npc);
        this.heightIndex = sLayer.heightIndex;
        this.automationParameters = new ParameterIdList(sLayer.automationParameters);
        for (SoundObject sObj : sLayer) {
            this.add(sObj.deepCopy());
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isSolo() {
        return this.solo;
    }

    public void setSolo(boolean solo) {
        this.solo = solo;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        String string = this.name = name == null ? "" : name;
        if (!this.name.equals(oldName)) {
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, "name", oldName, name));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ParameterIdList getAutomationParameters() {
        return this.automationParameters;
    }

    @Override
    public boolean add(SoundObject sObj) {
        super.add(sObj);
        this.fireSoundObjectAdded(sObj);
        return true;
    }

    @Override
    public boolean remove(ScoreObject sObj) {
        if (super.remove(sObj)) {
            this.fireSoundObjectRemoved((SoundObject)sObj);
            return true;
        }
        return false;
    }

    public double getMaxTime() {
        return ScoreUtilities.getMaxTime(this);
    }

    public static SoundLayer loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        Element npcNode;
        SoundLayer sLayer = new SoundLayer();
        sLayer.setName(data.getAttributeValue("name"));
        sLayer.setMuted(Boolean.valueOf(data.getAttributeValue("muted")));
        sLayer.setSolo(Boolean.valueOf(data.getAttributeValue("solo")));
        String heightIndexStr = data.getAttributeValue("heightIndex");
        if (heightIndexStr != null) {
            sLayer.setHeightIndex(Integer.parseInt(heightIndexStr));
        }
        if ((npcNode = data.getElement("noteProcessorChain")) != null) {
            sLayer.setNoteProcessorChain(NoteProcessorChain.loadFromXML(npcNode));
        }
        Elements sObjects = data.getElements("soundObject");
        while (sObjects.hasMoreElements()) {
            Object obj = ObjectUtilities.loadFromXML(sObjects.next(), objRefMap);
            sLayer.add((SoundObject)obj);
        }
        Elements parameters = data.getElements("parameterId");
        while (parameters.hasMoreElements()) {
            String id = parameters.next().getTextString();
            sLayer.automationParameters.addParameterId(id);
        }
        return sLayer;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = new Element("soundLayer");
        retVal.setAttribute("name", this.getName());
        retVal.setAttribute("muted", Boolean.toString(this.isMuted()));
        retVal.setAttribute("solo", Boolean.toString(this.isSolo()));
        retVal.setAttribute("heightIndex", Integer.toString(this.getHeightIndex()));
        retVal.addElement(this.npc.saveAsXML());
        for (SoundObject sObj : this) {
            retVal.addElement(sObj.saveAsXML(objRefMap));
        }
        for (String id : this.automationParameters) {
            retVal.addElement("parameterId").setText(id);
        }
        return retVal;
    }

    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    public void setNoteProcessorChain(NoteProcessorChain npc) {
        this.npc = npc;
    }

    @Override
    public int getHeightIndex() {
        return this.heightIndex;
    }

    @Override
    public void setHeightIndex(int heightIndex) {
        if (this.heightIndex == heightIndex) {
            return;
        }
        int oldHeight = this.heightIndex;
        this.heightIndex = heightIndex;
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "heightIndex", new Integer(oldHeight), new Integer(heightIndex));
        this.firePropertyChangeEvent(pce);
    }

    public int getSoundLayerHeight() {
        return (this.heightIndex + 1) * 22;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent pce) {
        if (this.propListeners == null) {
            return;
        }
        for (PropertyChangeListener listener : new Vector<PropertyChangeListener>(this.propListeners)) {
            listener.propertyChange(pce);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            this.propListeners = new Vector();
        }
        if (this.propListeners.contains(pcl)) {
            return;
        }
        this.propListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.propListeners == null) {
            return;
        }
        this.propListeners.remove(pcl);
    }

    public void addSoundLayerListener(SoundLayerListener listener) {
        if (this.layerListeners == null) {
            this.layerListeners = new Vector();
        }
        this.layerListeners.add(listener);
    }

    public void removeSoundLayerListener(SoundLayerListener listener) {
        if (this.layerListeners != null) {
            this.layerListeners.remove(listener);
        }
    }

    private void fireSoundObjectAdded(SoundObject sObj) {
        if (this.layerListeners != null) {
            for (SoundLayerListener listener : new Vector<SoundLayerListener>(this.layerListeners)) {
                listener.soundObjectAdded(this, sObj);
            }
        }
    }

    private void fireSoundObjectRemoved(SoundObject sObj) {
        if (this.layerListeners != null) {
            for (SoundLayerListener listener : new Vector<SoundLayerListener>(this.layerListeners)) {
                listener.soundObjectRemoved(this, sObj);
            }
        }
    }

    public void clearListeners() {
        if (this.propListeners != null) {
            this.propListeners.clear();
            this.propListeners = null;
        }
        if (this.layerListeners != null) {
            this.layerListeners.clear();
            this.layerListeners = null;
        }
    }

    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundLayerException {
        NoteList notes = new NoteList();
        Collections.sort(this, sObjComparator);
        for (SoundObject sObj : this) {
            try {
                double adjustedStart;
                double sObjDur;
                double sObjStart = sObj.getStartTime();
                double sObjEnd = sObjStart + (sObjDur = sObj.getSubjectiveDuration());
                if (!(sObjEnd > startTime)) continue;
                if (endTime <= startTime) {
                    adjustedStart = startTime - sObjStart;
                    if (adjustedStart < 0.0) {
                        adjustedStart = 0.0;
                    }
                    notes.merge(sObj.generateForCSD(compileData, adjustedStart, -1.0));
                    continue;
                }
                if (!(sObjStart < endTime)) continue;
                adjustedStart = startTime - sObjStart;
                double adjustedEnd = endTime - sObjStart;
                if (adjustedStart < 0.0) {
                    adjustedStart = 0.0;
                }
                if (adjustedEnd >= sObjDur) {
                    adjustedEnd = -1.0;
                }
                notes.merge(sObj.generateForCSD(compileData, adjustedStart, adjustedEnd));
            }
            catch (Exception e) {
                throw new SoundLayerException(this, "Error in SoundLayer: " + this.getName(), e);
            }
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(notes, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundLayerException(this, "Error in SoundLayer: " + this.getName(), e);
        }
        return notes;
    }

    @Override
    public int getLayerHeight() {
        return 22 * (this.heightIndex + 1);
    }

    @Override
    public boolean accepts(ScoreObject object) {
        return object instanceof SoundObject;
    }

    @Override
    public boolean contains(ScoreObject object) {
        if (!this.accepts(object)) {
            return false;
        }
        return super.contains(object);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void clearScoreObjects() {
        this.clear();
    }

    @Override
    public SoundLayer deepCopy() {
        return new SoundLayer(this);
    }
}

