/*
 * Decompiled with CFR 0.152.
 */
package blue.blueLive;

import blue.soundObject.SoundObject;
import blue.utility.ObjectUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.rmi.dgc.VMID;
import java.util.Map;

public class LiveObject {
    private SoundObject sObj = null;
    private int midiTrigger = -1;
    private int keyTrigger = -1;
    private boolean enabled = false;
    private String uniqueId;

    public LiveObject() {
        this.uniqueId = Integer.toString(new VMID().hashCode());
    }

    public LiveObject(SoundObject sObj) {
        this();
        this.sObj = sObj;
    }

    public LiveObject(LiveObject liveObj) {
        this.uniqueId = liveObj.uniqueId;
        this.midiTrigger = liveObj.midiTrigger;
        this.keyTrigger = liveObj.keyTrigger;
        this.enabled = liveObj.enabled;
        if (liveObj.sObj != null) {
            this.sObj = liveObj.sObj.deepCopy();
        }
    }

    public SoundObject getSoundObject() {
        return this.sObj;
    }

    public void setSObj(SoundObject sObj) {
        this.sObj = sObj;
    }

    public int getMidiTrigger() {
        return this.midiTrigger;
    }

    public void setMidiTrigger(int midiTrigger) {
        this.midiTrigger = midiTrigger;
    }

    public int getKeyTrigger() {
        return this.keyTrigger;
    }

    public void setKeyTrigger(int keyTrigger) {
        this.keyTrigger = keyTrigger;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = new Element("liveObject");
        retVal.setAttribute("uniqueId", this.uniqueId);
        retVal.addElement(XMLUtilities.writeInt("keyTrigger", this.keyTrigger));
        retVal.addElement(XMLUtilities.writeInt("midiTrigger", this.midiTrigger));
        retVal.addElement(XMLUtilities.writeBoolean("enabled", this.enabled));
        retVal.addElement(this.sObj.saveAsXML(objRefMap));
        return retVal;
    }

    public static LiveObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        LiveObject liveObj = new LiveObject();
        String val = data.getAttributeValue("uniqueId");
        if (val != null && val.length() > 0) {
            liveObj.uniqueId = val;
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String name;
            Element node = nodes.next();
            switch (name = node.getName()) {
                case "keyTrigger": {
                    liveObj.setKeyTrigger(XMLUtilities.readInt(node));
                    break;
                }
                case "midiTrigger": {
                    liveObj.setMidiTrigger(XMLUtilities.readInt(node));
                    break;
                }
                case "soundObject": {
                    liveObj.setSObj((SoundObject)ObjectUtilities.loadFromXML(node, objRefMap));
                    break;
                }
                case "enabled": {
                    liveObj.setEnabled(XMLUtilities.readBoolean(node));
                }
            }
        }
        return liveObj;
    }
}

