/*
 * Decompiled with CFR 0.152.
 */
package blue.mixer;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.components.lines.Line;
import blue.components.lines.LinePoint;
import blue.mixer.EffectsChain;
import blue.mixer.Send;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Channel
implements Comparable<Channel>,
ParameterListener {
    public static final String MASTER = "Master";
    public static final String NAME = "name";
    public static final String LEVEL = "level";
    public static final String SOLO = "solo";
    public static final String MUTED = "muted";
    public static final String OUT_CHANNEL = "outChannel";
    private transient List<PropertyChangeListener> listeners;
    private EffectsChain preEffects;
    private EffectsChain postEffects;
    private String outChannel = "Master";
    private String name = "Channel";
    private boolean muted = false;
    private boolean solo = false;
    private double level = 0.0;
    Parameter levelParameter;
    private String association = null;
    private transient boolean updatingLine = false;

    public Channel() {
        this.preEffects = new EffectsChain();
        this.postEffects = new EffectsChain();
        this.levelParameter = new Parameter();
        this.levelParameter.setName("Volume");
        this.levelParameter.setLabel("dB");
        this.levelParameter.setMin(-96.0, false);
        this.levelParameter.setMax(12.0, false);
        this.levelParameter.setValue(0.0);
        this.levelParameter.setResolution(new BigDecimal(-1.0));
        this.levelParameter.addParameterListener(this);
    }

    public Channel(Channel channel) {
        this.preEffects = new EffectsChain(channel.preEffects);
        this.postEffects = new EffectsChain(channel.postEffects);
        this.outChannel = channel.outChannel;
        this.name = channel.name;
        this.muted = channel.muted;
        this.solo = channel.solo;
        this.level = channel.level;
        this.levelParameter = new Parameter(channel.levelParameter);
        this.levelParameter.addParameterListener(this);
        this.association = channel.association;
    }

    public static Channel loadFromXML(Element data) throws Exception {
        Channel channel = new Channel();
        String associationVal = data.getAttributeValue("association");
        if (associationVal != null && !"null".equals(associationVal)) {
            channel.setAssociation(data.getAttributeValue("association"));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "name": {
                    channel.setName(node.getTextString());
                    break;
                }
                case "outChannel": {
                    channel.setOutChannel(node.getTextString());
                    break;
                }
                case "level": {
                    channel.setLevel(XMLUtilities.readDouble(node));
                    break;
                }
                case "muted": {
                    channel.setMuted(XMLUtilities.readBoolean(node));
                    break;
                }
                case "solo": {
                    channel.setSolo(XMLUtilities.readBoolean(node));
                    break;
                }
                case "effectsChain": {
                    if (node.getAttributeValue("bin").equals("pre")) {
                        channel.setPreEffects(EffectsChain.loadFromXML(node));
                        break;
                    }
                    channel.setPostEffects(EffectsChain.loadFromXML(node));
                    break;
                }
                case "parameter": {
                    channel.levelParameter.removeParameterListener(channel);
                    channel.levelParameter = Parameter.loadFromXML(node);
                    channel.levelParameter.addParameterListener(channel);
                }
            }
        }
        if (!channel.levelParameter.isAutomationEnabled()) {
            channel.levelParameter.setValue(channel.getLevel());
        }
        return channel;
    }

    public Element saveAsXML() {
        Element retVal = new Element("channel");
        if (this.association != null) {
            retVal.setAttribute("association", this.association);
        }
        retVal.addElement(new Element(NAME).setText(this.name));
        retVal.addElement(new Element(OUT_CHANNEL).setText(this.outChannel));
        retVal.addElement(XMLUtilities.writeDouble(LEVEL, this.level));
        retVal.addElement(XMLUtilities.writeBoolean(MUTED, this.muted));
        retVal.addElement(XMLUtilities.writeBoolean(SOLO, this.solo));
        Element preEffectsNode = this.preEffects.saveAsXML();
        preEffectsNode.setAttribute("bin", "pre");
        retVal.addElement(preEffectsNode);
        Element postEffectsNode = this.postEffects.saveAsXML();
        postEffectsNode.setAttribute("bin", "post");
        retVal.addElement(postEffectsNode);
        retVal.addElement(this.levelParameter.saveAsXML());
        return retVal;
    }

    public String getAssociation() {
        return this.association;
    }

    public void setAssociation(String association) {
        this.association = association;
    }

    public EffectsChain getPreEffects() {
        return this.preEffects;
    }

    public void setPreEffects(EffectsChain chain) {
        this.preEffects = chain;
    }

    public EffectsChain getPostEffects() {
        return this.postEffects;
    }

    public void setPostEffects(EffectsChain chain) {
        this.postEffects = chain;
    }

    public String getOutChannel() {
        return this.outChannel;
    }

    public void setOutChannel(String outChannel) {
        String oldVal = this.outChannel;
        this.outChannel = outChannel;
        this.firePropertyChange(OUT_CHANNEL, oldVal, outChannel);
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        boolean oldVal = this.muted;
        this.muted = muted;
        this.firePropertyChange(MUTED, oldVal, muted);
    }

    public boolean isSolo() {
        return this.solo;
    }

    public void setSolo(boolean solo) {
        boolean oldVal = this.solo;
        this.solo = solo;
        this.firePropertyChange(SOLO, oldVal, solo);
    }

    public double getLevel() {
        return this.level;
    }

    public void setLevel(double level) {
        if (this.levelParameter.isAutomationEnabled()) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            if (time < 0.0) {
                return;
            }
            this.updatingLine = true;
            LinePoint found = null;
            Line line = this.levelParameter.getLine();
            for (int i = 0; i < line.size(); ++i) {
                LinePoint point = line.getLinePoint(i);
                if (point.getX() != time) continue;
                found = point;
                break;
            }
            if (found != null) {
                found.setLocation(found.getX(), level);
            } else {
                LinePoint lp = new LinePoint();
                lp.setLocation(time, level);
                line.insertLinePoint(lp);
            }
            this.updatingLine = false;
        } else {
            this.levelParameter.setValue(level);
        }
        double oldVal = this.level;
        this.level = level;
        this.firePropertyChange(LEVEL, new Double(oldVal), new Double(level));
    }

    public Parameter getLevelParameter() {
        return this.levelParameter;
    }

    public void setLevelParameter(Parameter param) {
        this.levelParameter = param;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldVal = this.name;
        this.name = name;
        this.firePropertyChange(NAME, oldVal, name);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            this.listeners = new Vector<PropertyChangeListener>();
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(pcl);
    }

    public void firePropertyChange(String propertyName, double oldVal, double newVal) {
        this.firePropertyChange(propertyName, new Double(oldVal), new Double(newVal));
    }

    public void firePropertyChange(String propertyName, boolean oldVal, boolean newVal) {
        this.firePropertyChange(propertyName, (Object)oldVal, (Object)newVal);
    }

    public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        PropertyChangeEvent pce = new PropertyChangeEvent(this, propertyName, oldVal, newVal);
        for (PropertyChangeListener pcl : this.listeners) {
            pcl.propertyChange(pce);
        }
    }

    @Override
    public int compareTo(Channel chanB) {
        try {
            int a = Integer.parseInt(this.getName());
            int b = Integer.parseInt(chanB.getName());
            return a - b;
        }
        catch (NumberFormatException nfe) {
            return this.getName().compareToIgnoreCase(chanB.getName());
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public void lineDataChanged(Parameter param) {
        if (!this.updatingLine) {
            double time = ParameterTimeManagerFactory.getInstance().getTime();
            double level = this.levelParameter.getLine().getValue(time);
            double oldVal = this.level;
            this.level = level;
            this.firePropertyChange(LEVEL, new Double(oldVal), new Double(level));
        }
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    public Send[] getPreFaderSends() {
        return this.preEffects.getSends();
    }

    public Send[] getPostFaderSends() {
        return this.postEffects.getSends();
    }

    public Send[] getSends() {
        Object obj;
        int i;
        ArrayList<Send> temp = new ArrayList<Send>();
        for (i = 0; i < this.preEffects.size(); ++i) {
            obj = this.preEffects.getElementAt(i);
            if (!(obj instanceof Send)) continue;
            temp.add((Send)obj);
        }
        for (i = 0; i < this.postEffects.size(); ++i) {
            obj = this.postEffects.getElementAt(i);
            if (!(obj instanceof Send)) continue;
            temp.add((Send)obj);
        }
        Send[] sends = temp.toArray(new Send[temp.size()]);
        return sends;
    }
}

