/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import java.util.StringTokenizer;
import org.apache.commons.lang3.text.StrBuilder;

public class TempoMapper {
    BeatTempoPair[] timeMap;

    private TempoMapper() {
    }

    public static TempoMapper createTempoMapper(String timeWarpString) {
        TempoMapper tm = new TempoMapper();
        StringTokenizer st = new StringTokenizer(timeWarpString);
        if (st.countTokens() % 2 != 0) {
            return null;
        }
        tm.timeMap = new BeatTempoPair[st.countTokens() / 2];
        int index = 0;
        BeatTempoPair[] tMap = tm.timeMap;
        while (st.hasMoreTokens()) {
            try {
                String time = st.nextToken();
                String tempo = st.nextToken();
                BeatTempoPair temp = new BeatTempoPair();
                temp.beat = Double.parseDouble(time);
                temp.tempo = Double.parseDouble(tempo);
                if (temp.beat < 0.0 || temp.tempo <= 0.0) {
                    return null;
                }
                tMap[index] = temp;
                if (index > 0) {
                    double factor1 = 60.0 / tMap[index - 1].tempo;
                    double factor2 = 60.0 / tMap[index].tempo;
                    double deltaBeat = tMap[index].beat - tMap[index - 1].beat;
                    double acceleration = 0.0;
                    if (deltaBeat >= 0.0) {
                        acceleration = (factor2 - factor1) / (tMap[index].beat - tMap[index - 1].beat);
                    }
                    tMap[index].accumulatedTime = tMap[index].beat == tMap[index - 1].beat ? tMap[index - 1].accumulatedTime : tMap[index - 1].accumulatedTime + TempoMapper.getAreaUnderCurve(factor1, deltaBeat, acceleration);
                }
                ++index;
            }
            catch (Exception e) {
                return null;
            }
        }
        return tm;
    }

    public double beatsToSeconds(double beat) {
        if (beat == 0.0) {
            return 0.0;
        }
        for (int i = 0; i < this.timeMap.length - 1; ++i) {
            if (!(beat >= this.timeMap[i].beat) || !(beat < this.timeMap[i + 1].beat)) continue;
            double factor1 = 60.0 / this.timeMap[i].tempo;
            double factor2 = 60.0 / this.timeMap[i + 1].tempo;
            double deltaBeat = beat - this.timeMap[i].beat;
            double acceleration = deltaBeat == 0.0 ? 0.0 : (factor2 - factor1) / (this.timeMap[i + 1].beat - this.timeMap[i].beat);
            double t = TempoMapper.getAreaUnderCurve(factor1, deltaBeat, acceleration);
            return this.timeMap[i].accumulatedTime + t;
        }
        BeatTempoPair lastTempoPair = this.timeMap[this.timeMap.length - 1];
        double factor1 = 60.0 / lastTempoPair.tempo;
        double deltaBeat = beat - lastTempoPair.beat;
        double t = factor1 * deltaBeat + lastTempoPair.accumulatedTime;
        return t;
    }

    private static double getAreaUnderCurve(double factor1, double deltaBeat, double acceleration) {
        return factor1 * deltaBeat + 0.5 * acceleration * Math.pow(deltaBeat, 2.0);
    }

    public double secondsToBeats(double seconds) {
        if (seconds == 0.0) {
            return 0.0;
        }
        if (this.timeMap.length == 1) {
            double factor = this.timeMap[0].tempo / 60.0;
            return seconds * factor;
        }
        for (int i = 0; i < this.timeMap.length - 1; ++i) {
            double x;
            if (!(seconds < this.timeMap[i + 1].accumulatedTime)) continue;
            double beat0 = this.timeMap[i].beat;
            double beat1 = this.timeMap[i + 1].beat;
            double time0 = this.timeMap[i].accumulatedTime;
            double btime0 = 60.0 / this.timeMap[i].tempo;
            double btime1 = 60.0 / this.timeMap[i + 1].tempo;
            if (btime0 == btime1) {
                double elapsedTime = seconds - time0;
                x = elapsedTime / btime0;
            } else {
                double a = 0.5 * (btime1 - btime0) / (beat1 - beat0);
                double b = btime0;
                double c = time0 - seconds;
                x = (Math.sqrt(b * b - 4.0 * a * c) - b) / (2.0 * a);
            }
            return x + beat0;
        }
        BeatTempoPair last = this.timeMap[this.timeMap.length - 1];
        double beat = last.beat;
        double factor = last.tempo / 60.0;
        return (seconds - last.accumulatedTime) * factor + beat;
    }

    public String toString() {
        StrBuilder buffer = new StrBuilder();
        buffer.append("[TempoMapper]").append("\n");
        for (int i = 0; i < this.timeMap.length; ++i) {
            BeatTempoPair pair = this.timeMap[i];
            buffer.append(pair.beat).append(" : ").append(pair.tempo).append("\n");
        }
        return buffer.toString();
    }

    private static class BeatTempoPair {
        public double beat = 0.0;
        public double tempo = 60.0;
        public double accumulatedTime = 0.0;

        private BeatTempoPair() {
        }
    }
}

