/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.components.lines.Line;
import blue.components.lines.LineList;
import blue.components.lines.LinePoint;
import blue.noteProcessor.NoteProcessorChain;
import blue.orchestra.GenericInstrument;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.NumberUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractLineObject
extends AbstractSoundObject {
    private static String LINE_OBJECT_CACHE = "abstractLineObject.lineObjectCache";
    protected LineList lines = new LineList();

    public AbstractLineObject() {
    }

    public AbstractLineObject(AbstractLineObject alo) {
        super(alo);
        this.lines = new LineList(alo.lines);
    }

    public LineList getLines() {
        return this.lines;
    }

    public void setLines(LineList lines) {
        this.lines = lines;
    }

    public NoteList generateNotes(Integer[] instrLineArray, double renderStart, double renderEnd) throws SoundObjectException {
        NoteList notes = new NoteList();
        double newDur = this.subjectiveDuration;
        if (renderEnd > 0.0 && renderEnd < this.subjectiveDuration) {
            newDur = renderEnd;
        }
        newDur -= renderStart;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < instrLineArray.length; i += 2) {
            Integer instrNum = instrLineArray[i];
            Integer lineNum = instrLineArray[i + 1];
            buffer.append("i").append(instrNum).append(" ");
            buffer.append(renderStart).append(" ").append(newDur).append(" ");
            buffer.append(renderStart / this.subjectiveDuration).append(" ");
            if (renderEnd > 0.0) {
                buffer.append(renderEnd / this.subjectiveDuration).append(" ");
            } else {
                buffer.append(" 1 ");
            }
            buffer.append(lineNum);
            try {
                notes.add(Note.createNote(buffer.toString()));
            }
            catch (NoteParseException e) {
                throw new SoundObjectException((SoundObject)this, (Throwable)e);
            }
            buffer.delete(0, buffer.length());
        }
        ScoreUtilities.setScoreStart(notes, this.startTime);
        return notes;
    }

    protected String createTable(Line line) {
        StringBuilder buffer = new StringBuilder();
        int genSize = this.getGenSize();
        buffer.append(" 0 ");
        buffer.append(genSize);
        buffer.append(" -7 ");
        double lastTime = 0.0;
        boolean firstPoint = true;
        for (int i = 0; i < line.size(); ++i) {
            LinePoint point = line.getLinePoint(i);
            double newTime = point.getX() * (double)genSize;
            double dur = Math.max(newTime - lastTime, 0.0);
            double yVal = point.getY();
            if (firstPoint) {
                firstPoint = false;
            } else {
                buffer.append(" ");
                buffer.append(NumberUtilities.formatDouble(dur));
            }
            buffer.append(" ");
            buffer.append(NumberUtilities.formatDouble(yVal));
            lastTime = newTime;
        }
        return buffer.toString();
    }

    protected int getGenSize() {
        return 16384;
    }

    protected abstract String generateLineInstrument(Line var1);

    public void generateFTables(CompileData compileData, HashMap ftableNumMap) {
        StringBuilder buffer = new StringBuilder();
        HashMap obj = compileData.getCompilationVariable(LINE_OBJECT_CACHE);
        if (obj == null) {
            HashMap map = new HashMap();
            compileData.setCompilationVariable(LINE_OBJECT_CACHE, map);
            obj = map;
        }
        HashMap stringTables = obj;
        Iterator iter = this.lines.iterator();
        while (iter.hasNext()) {
            int tableNum;
            Line line = (Line)iter.next();
            String table = this.createTable(line);
            if (stringTables.containsKey(table)) {
                tableNum = (Integer)stringTables.get(table);
            } else {
                tableNum = compileData.getOpenFTableNumber();
                stringTables.put(table, new Integer(tableNum));
                buffer.append("f").append(tableNum);
                buffer.append(table).append("\n");
            }
            ftableNumMap.put(line.getUniqueID(), new Integer(tableNum));
        }
        compileData.appendTables(buffer.toString());
    }

    public void generateInstruments(CompileData compileData, Integer[] instrLineArray, HashMap ftableNumMap) {
        int i = 0;
        Iterator iter = this.lines.iterator();
        while (iter.hasNext()) {
            Line line = (Line)iter.next();
            String lineName = line.isZak() ? "zak" + line.getChannel() : line.getVarName();
            String lineId = line.getUniqueID();
            String key = "AbstractLineObject." + lineName;
            Object val = compileData.getCompilationVariable(key);
            int instrNum = -1;
            Integer lineNum = (Integer)ftableNumMap.get(lineId);
            if (val == null) {
                String instrText = this.generateLineInstrument(line);
                GenericInstrument instr = new GenericInstrument();
                instr.setText(instrText);
                instrNum = compileData.addInstrument(instr);
                compileData.setCompilationVariable(key, new Integer(instrNum));
            } else {
                instrNum = (Integer)val;
            }
            instrLineArray[i++] = new Integer(instrNum);
            instrLineArray[i++] = lineNum;
        }
    }

    @Override
    public double getObjectiveDuration() {
        return this.getSubjectiveDuration();
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return null;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
    }

    @Override
    public int getTimeBehavior() {
        return -1;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
    }

    @Override
    public double getRepeatPoint() {
        return -1.0;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            Line line = (Line)iterator.next();
            retVal.addElement(line.saveAsXML());
        }
        return retVal;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) {
        Integer[] instrLineArray = new Integer[this.lines.size() * 2];
        HashMap ftableNumMap = new HashMap();
        this.generateFTables(compileData, ftableNumMap);
        this.generateInstruments(compileData, instrLineArray, ftableNumMap);
        try {
            return this.generateNotes(instrLineArray, startTime, endTime);
        }
        catch (SoundObjectException ex) {
            throw new RuntimeException(ex);
        }
    }
}

