/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObjectEvent;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.GenericViewable;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import java.util.Map;

public class GenericScore
extends AbstractSoundObject
implements GenericViewable {
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    private String score;

    public GenericScore() {
        this.setName("GenericScore");
        this.score = "i1 0 2 3 4 5";
        this.timeBehavior = 0;
    }

    public GenericScore(GenericScore score) {
        super(score);
        this.timeBehavior = score.timeBehavior;
        this.score = score.score;
        this.npc = new NoteProcessorChain(score.npc);
        this.repeatPoint = score.repeatPoint;
    }

    public String getText() {
        return this.score;
    }

    public void setText(String text) {
        this.score = text;
    }

    @Override
    public double getObjectiveDuration() {
        NoteList notes = null;
        try {
            notes = ScoreUtilities.getNotes(this.score);
        }
        catch (NoteParseException e) {
            e.printStackTrace();
        }
        if (notes == null) {
            return 0.0;
        }
        return ScoreUtilities.getTotalDuration(notes);
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    public final NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        NoteList nl;
        try {
            nl = ScoreUtilities.getNotes(this.score);
        }
        catch (NoteParseException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.startTime);
        return nl;
    }

    public static GenericScore transformSoundObject(SoundObject sObj) throws SoundObjectException {
        GenericScore buffer = new GenericScore();
        buffer.setStartTime(sObj.getStartTime());
        buffer.setSubjectiveDuration(sObj.getSubjectiveDuration());
        buffer.setName("GEN: " + sObj.getName());
        sObj.setStartTime(0.0);
        buffer.setText(sObj.generateForCSD(null, 0.0, -1.0).toString());
        return buffer;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain noteProcessorChain) {
        this.npc = noteProcessorChain;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        GenericScore genScore = new GenericScore();
        SoundObjectUtilities.initBasicFromXML(data, genScore);
        String tempScore = data.getElement("score").getTextString();
        if (tempScore == null) {
            genScore.setText("");
        } else {
            genScore.setText(tempScore);
        }
        return genScore;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("score").setText(this.getText());
        return retVal;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        NoteList nl = this.generateNotes(startTime, endTime);
        return nl;
    }

    @Override
    public GenericScore deepCopy() {
        return new GenericScore(this);
    }
}

