/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObjectEvent;
import blue.soundObject.AbstractSoundObject;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.soundObject.jmask.Field;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class JMask
extends AbstractSoundObject {
    private NoteProcessorChain npc = new NoteProcessorChain();
    private Field field = new Field();
    private int timeBehavior;
    double repeatPoint = -1.0;
    boolean seedUsed = false;
    long seed = 0L;

    public JMask() {
        this.setName("JMask");
        this.timeBehavior = 0;
    }

    public JMask(JMask jmask) {
        super(jmask);
        this.npc = new NoteProcessorChain(jmask.npc);
        this.field = new Field(jmask.field);
        this.timeBehavior = jmask.timeBehavior;
        this.repeatPoint = jmask.repeatPoint;
        this.seedUsed = jmask.seedUsed;
        this.seed = jmask.seed;
    }

    public NoteList generateNotes(double renderStart, double renderEnd) throws SoundObjectException {
        Field temp = new Field(this.field);
        Random rnd = this.seedUsed ? new Random(this.seed) : new Random();
        NoteList nl = temp.generateNotes(this.getSubjectiveDuration(), rnd);
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.startTime);
        return nl;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public double getObjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    public static SoundObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        JMask jmask = new JMask();
        SoundObjectUtilities.initBasicFromXML(data, jmask);
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "field": {
                    jmask.setField(Field.loadFromXML(node));
                    break;
                }
                case "seed": {
                    jmask.setSeed(Long.parseLong(node.getTextString()));
                    break;
                }
                case "seedUsed": {
                    jmask.setSeedUsed(Boolean.parseBoolean(node.getTextString()));
                }
            }
        }
        return jmask;
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement("seedUsed").setText(Boolean.toString(this.seedUsed));
        retVal.addElement("seed").setText(Long.toString(this.seed));
        retVal.addElement(this.field.saveAsXML());
        return retVal;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain chain) {
        this.npc = chain;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireScoreObjectEvent(event);
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean isSeedUsed() {
        return this.seedUsed;
    }

    public void setSeedUsed(boolean seedUsed) {
        this.seedUsed = seedUsed;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        NoteList nl = this.generateNotes(startTime, endTime);
        return nl;
    }

    @Override
    public JMask deepCopy() {
        return new JMask(this);
    }
}

