/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.CompileData;
import blue.SoundLayer;
import blue.SoundLayerException;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreObject;
import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.score.TimeState;
import blue.score.layers.AutomatableLayerGroup;
import blue.score.layers.Layer;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.ScoreObjectLayerGroup;
import blue.soundObject.Comment;
import blue.soundObject.GenericViewable;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.OnLoadProcessable;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.soundObject.SoundObjectUtilities;
import blue.utility.ScoreUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PolyObject
extends ArrayList<SoundLayer>
implements SoundObject,
ScoreObjectLayerGroup<SoundLayer>,
AutomatableLayerGroup,
GenericViewable {
    private transient Vector<LayerGroupListener> layerGroupListeners = null;
    public static final int DISPLAY_TIME = 0;
    public static final int DISPLAY_NUMBER = 1;
    protected double subjectiveDuration = 2.0;
    protected double startTime = 0.0;
    protected String name = "";
    protected Color backgroundColor = Color.DARK_GRAY;
    transient Vector<ScoreObjectListener> soundObjectListeners = null;
    private NoteProcessorChain npc = new NoteProcessorChain();
    private int timeBehavior;
    double repeatPoint = -1.0;
    private int defaultHeightIndex = 0;
    private TimeState timeState = new TimeState();

    public PolyObject() {
        this.setName("polyObject");
        this.timeBehavior = 0;
        this.setBackgroundColor(new Color(102, 102, 153));
    }

    public PolyObject(boolean isRoot) {
        this.setName("SoundObject Layer Group");
        this.timeBehavior = 2;
        this.setBackgroundColor(new Color(102, 102, 153));
    }

    public PolyObject(PolyObject pObj) {
        super(pObj.size());
        this.name = pObj.name;
        this.startTime = pObj.startTime;
        this.subjectiveDuration = pObj.subjectiveDuration;
        this.timeBehavior = pObj.timeBehavior;
        this.repeatPoint = pObj.repeatPoint;
        this.npc = new NoteProcessorChain(pObj.npc);
        this.timeState = new TimeState(pObj.timeState);
        this.defaultHeightIndex = pObj.defaultHeightIndex;
        this.backgroundColor = pObj.backgroundColor;
        for (SoundLayer sLayer : pObj) {
            this.add(sLayer.deepCopy());
        }
    }

    public final List<SoundObject> getSoundObjects(boolean grabMutedSoundObjects) {
        ArrayList<SoundObject> sObjects = new ArrayList<SoundObject>();
        for (SoundLayer sLayer : this) {
            if (!grabMutedSoundObjects && sLayer.isMuted()) continue;
            sObjects.addAll(sLayer);
        }
        return sObjects;
    }

    public final void addSoundObject(int layerIndex, SoundObject sObj) {
        SoundLayer temp = (SoundLayer)this.get(layerIndex);
        temp.add(sObj);
    }

    public final int removeSoundObject(SoundObject sObj) {
        for (int i = 0; i < this.size(); ++i) {
            SoundLayer tempLayer = (SoundLayer)this.get(i);
            if (!tempLayer.contains(sObj)) continue;
            tempLayer.remove(sObj);
            return i;
        }
        return -1;
    }

    @Override
    public double getObjectiveDuration() {
        double totalDuration;
        try {
            totalDuration = ScoreUtilities.getTotalDuration(this.generateForCSD(null, -1.0, -1.0, false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return totalDuration;
    }

    @Override
    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    @Override
    public void setNoteProcessorChain(NoteProcessorChain npc) {
        this.npc = npc;
    }

    public TimeState getTimeState() {
        return this.timeState;
    }

    public void setTimeState(TimeState timeState) {
        this.timeState = timeState;
    }

    public final void normalizeSoundObjects() {
        SoundObject temp;
        int i;
        List<SoundObject> sObjects = this.getSoundObjects(true);
        int size = sObjects.size();
        if (size == 0) {
            return;
        }
        double min = sObjects.get(0).getStartTime();
        for (i = 1; i < size; ++i) {
            temp = sObjects.get(i);
            if (!(temp.getStartTime() < min)) continue;
            min = temp.getStartTime();
        }
        for (i = 0; i < size; ++i) {
            temp = sObjects.get(i);
            temp.setStartTime(temp.getStartTime() - min);
        }
        this.setSubjectiveDuration(ScoreUtilities.getMaxTime(sObjects));
    }

    public final double getMaxTime() {
        double max = 0.0;
        for (SoundLayer tempSLayer : this) {
            double temp = tempSLayer.getMaxTime();
            if (!(temp > max)) continue;
            max = temp;
        }
        return max;
    }

    @Override
    public boolean hasSoloLayers() {
        for (SoundLayer layer : this) {
            if (!layer.isSolo()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime) throws SoundObjectException {
        boolean soloFound = false;
        for (SoundLayer soundLayer : this) {
            if (!soundLayer.isSolo()) continue;
            soloFound = true;
            break;
        }
        return this.generateForCSD(compileData, startTime, endTime, soloFound);
    }

    @Override
    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime, boolean processWithSolo) throws SoundObjectException {
        NoteList noteList = new NoteList();
        if (processWithSolo) {
            for (SoundLayer soundLayer : this) {
                if (!soundLayer.isSolo() || soundLayer.isMuted()) continue;
                try {
                    noteList.merge(soundLayer.generateForCSD(compileData, startTime, endTime));
                }
                catch (SoundLayerException ex) {
                    throw new SoundObjectException((SoundObject)this, (Throwable)ex);
                }
            }
        } else {
            for (SoundLayer soundLayer : this) {
                if (soundLayer.isMuted()) continue;
                try {
                    noteList.merge(soundLayer.generateForCSD(compileData, startTime, endTime));
                }
                catch (SoundLayerException ex) {
                    throw new SoundObjectException((SoundObject)this, (Throwable)ex);
                }
            }
        }
        noteList = this.processNotes(compileData, noteList, startTime, endTime);
        return noteList;
    }

    private NoteList processNotes(CompileData compileData, NoteList nl, double start, double endTime) throws SoundObjectException {
        Note tempNote;
        int i;
        NoteList buffer;
        NoteList retVal = null;
        try {
            ScoreUtilities.applyNoteProcessorChain(nl, this.npc);
        }
        catch (NoteProcessorException e) {
            throw new SoundObjectException((SoundObject)this, (Throwable)e);
        }
        ScoreUtilities.applyTimeBehavior(nl, this.getTimeBehavior(), this.getSubjectiveDuration(), this.getRepeatPoint());
        ScoreUtilities.setScoreStart(nl, this.startTime);
        if (start == 0.0) {
            retVal = nl;
        } else {
            ScoreUtilities.setScoreStart(nl, -start);
            buffer = new NoteList();
            for (i = 0; i < nl.size(); ++i) {
                tempNote = (Note)nl.get(i);
                if (!(tempNote.getStartTime() >= 0.0)) continue;
                buffer.add(tempNote);
            }
            retVal = buffer;
        }
        if (endTime > start) {
            buffer = new NoteList();
            for (i = 0; i < retVal.size(); ++i) {
                tempNote = (Note)retVal.get(i);
                if (!(tempNote.getStartTime() <= endTime)) continue;
                buffer.add(tempNote);
            }
            retVal = buffer;
        }
        return retVal;
    }

    @Override
    public int getTimeBehavior() {
        return this.timeBehavior;
    }

    @Override
    public void setTimeBehavior(int timeBehavior) {
        this.timeBehavior = timeBehavior;
    }

    @Override
    public double getRepeatPoint() {
        return this.repeatPoint;
    }

    @Override
    public void setRepeatPoint(double repeatPoint) {
        this.repeatPoint = repeatPoint;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 4);
        this.fireSoundObjectEvent(event);
    }

    public int getSoundLayerIndex(SoundObject sObj) {
        for (int i = 0; i < this.size(); ++i) {
            SoundLayer tempLayer = (SoundLayer)this.get(i);
            if (!tempLayer.contains(sObj)) continue;
            return i;
        }
        return -1;
    }

    public static PolyObject loadFromXML(Element data, Map<String, Object> objRefMap) throws Exception {
        PolyObject pObj = new PolyObject();
        SoundObjectUtilities.initBasicFromXML(data, pObj);
        Elements nodes = data.getElements();
        int heightIndex = -1;
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "heightIndex": {
                    int index = Integer.parseInt(node.getTextString());
                    String val = node.getAttributeValue("version");
                    if (val == null || val.length() == 0) {
                        index = --index < 0 ? 0 : index;
                    }
                    heightIndex = index;
                    break;
                }
                case "defaultHeightIndex": {
                    int index = Integer.parseInt(node.getTextString());
                    pObj.setDefaultHeightIndex(index);
                    break;
                }
                case "soundLayer": {
                    pObj.add(SoundLayer.loadFromXML(node, objRefMap));
                    break;
                }
                case "timeState": {
                    pObj.timeState = TimeState.loadFromXML(node);
                }
            }
        }
        if (heightIndex >= 0) {
            for (int i = 0; i < pObj.size(); ++i) {
                SoundLayer layer = (SoundLayer)pObj.get(i);
                layer.setHeightIndex(heightIndex);
            }
            pObj.setDefaultHeightIndex(heightIndex);
        }
        return pObj;
    }

    private static boolean isTimeStateValueFound(String nodeName) {
        return nodeName.equals("pixelSecond") || nodeName.equals("snapEnabled") || nodeName.equals("snapValue") || nodeName.equals("timeDisplay") || nodeName.equals("timeUnit");
    }

    @Override
    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element retVal = SoundObjectUtilities.getBasicXML(this);
        retVal.addElement(XMLUtilities.writeInt("defaultHeightIndex", this.defaultHeightIndex));
        if (this.timeState != null) {
            retVal.addElement(this.timeState.saveAsXML());
        }
        for (SoundLayer sLayer : this) {
            retVal.addElement(sLayer.saveAsXML(objRefMap));
        }
        return retVal;
    }

    public int getLayerNum(SoundLayer layer) {
        return this.indexOf(layer);
    }

    public int getLayerNumForY(int y) {
        int runningY = 0;
        for (int i = 0; i < this.size(); ++i) {
            SoundLayer layer = (SoundLayer)this.get(i);
            if ((runningY += layer.getSoundLayerHeight()) <= y) continue;
            return i;
        }
        return this.size() - 1;
    }

    public int getYForLayerNum(int layerNum) {
        int runningY = 0;
        int max = layerNum;
        int lastIndex = this.size() - 1;
        if (max > lastIndex) {
            max = lastIndex;
        }
        for (int i = 0; i < max; ++i) {
            SoundLayer layer = (SoundLayer)this.get(i);
            runningY += layer.getSoundLayerHeight();
        }
        return runningY;
    }

    public int getSoundLayerHeight(int layerNum) {
        return ((SoundLayer)this.get(layerNum)).getSoundLayerHeight();
    }

    public int getTotalHeight() {
        int runningHeight = 0;
        for (SoundLayer layer : this) {
            runningHeight += layer.getSoundLayerHeight();
        }
        return runningHeight;
    }

    @Override
    public SoundLayer newLayerAt(int index) {
        SoundLayer sLayer = new SoundLayer();
        sLayer.setHeightIndex(this.getDefaultHeightIndex());
        int insertIndex = index;
        if (index < 0 || index >= this.size()) {
            insertIndex = this.size();
            this.add(sLayer);
        } else {
            this.add(index, sLayer);
        }
        ArrayList<Layer> layers = new ArrayList<Layer>();
        layers.add(sLayer);
        LayerGroupDataEvent lde = new LayerGroupDataEvent(this, 0, insertIndex, insertIndex, layers);
        this.fireLayerGroupDataEvent(lde);
        return sLayer;
    }

    @Override
    public void removeLayers(int startIndex, int endIndex) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (int i = endIndex; i >= startIndex; --i) {
            SoundLayer sLayer = (SoundLayer)this.get(i);
            sLayer.clearListeners();
            this.remove(i);
            layers.add(sLayer);
        }
        LayerGroupDataEvent lde = new LayerGroupDataEvent(this, 1, startIndex, endIndex, layers);
        this.fireLayerGroupDataEvent(lde);
    }

    @Override
    public void pushUpLayers(int startIndex, int endIndex) {
        SoundLayer a = (SoundLayer)this.remove(startIndex - 1);
        this.add(endIndex, a);
        LayerGroupDataEvent lde = new LayerGroupDataEvent(this, 2, startIndex - 1, endIndex);
        this.fireLayerGroupDataEvent(lde);
    }

    @Override
    public void pushDownLayers(int startIndex, int endIndex) {
        SoundLayer a = (SoundLayer)this.remove(endIndex + 1);
        this.add(startIndex, a);
        LayerGroupDataEvent lde = new LayerGroupDataEvent(this, 2, -startIndex, -(endIndex + 1));
        this.fireLayerGroupDataEvent(lde);
    }

    @Override
    public void addLayerGroupListener(LayerGroupListener l) {
        if (this.layerGroupListeners == null) {
            this.layerGroupListeners = new Vector();
        }
        this.layerGroupListeners.add(l);
    }

    @Override
    public void removeLayerGroupListener(LayerGroupListener l) {
        if (this.layerGroupListeners != null) {
            this.layerGroupListeners.remove(l);
        }
    }

    private void fireLayerGroupDataEvent(LayerGroupDataEvent lde) {
        if (this.layerGroupListeners == null) {
            return;
        }
        for (LayerGroupListener listener : this.layerGroupListeners) {
            listener.layerGroupChanged(lde);
        }
    }

    public int getDefaultHeightIndex() {
        return this.defaultHeightIndex;
    }

    public void setDefaultHeightIndex(int defaultHeightIndex) {
        this.defaultHeightIndex = defaultHeightIndex;
    }

    public boolean isScoreGenerationEmpty() {
        List<SoundObject> sObjects = this.getSoundObjects(false);
        for (SoundObject element : sObjects) {
            if (element instanceof Comment) continue;
            if (element instanceof PolyObject) {
                PolyObject pObj = (PolyObject)element;
                if (pObj.isScoreGenerationEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isAdjustedTimeCalculateable() {
        List<SoundObject> sObjects = this.getSoundObjects(false);
        for (SoundObject element : sObjects) {
            PolyObject pObj;
            if (element.getTimeBehavior() == 2) {
                return false;
            }
            if (!(element instanceof PolyObject) || (pObj = (PolyObject)element).isAdjustedTimeCalculateable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onLoadComplete() {
        for (SoundLayer sLayer : this) {
            for (int j = 0; j < sLayer.size(); ++j) {
                OnLoadProcessable olp;
                SoundObject sObj = (SoundObject)sLayer.get(j);
                if (sObj instanceof PolyObject) {
                    ((PolyObject)sObj).onLoadComplete();
                    continue;
                }
                if (!(sObj instanceof OnLoadProcessable) || !(olp = (OnLoadProcessable)((Object)sObj)).isOnLoadProcessable()) continue;
                try {
                    olp.processOnLoad();
                    continue;
                }
                catch (SoundObjectException soe) {
                    throw new RuntimeException(new SoundObjectException(this, "Error during on load processing:", soe));
                }
            }
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 0);
        this.fireSoundObjectEvent(event);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setStartTime(double startTime) {
        this.startTime = startTime;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 1);
        this.fireSoundObjectEvent(event);
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public void setSubjectiveDuration(double subjectiveDuration) {
        this.subjectiveDuration = subjectiveDuration;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 2);
        this.fireSoundObjectEvent(event);
    }

    @Override
    public double getSubjectiveDuration() {
        return this.subjectiveDuration;
    }

    @Override
    public double getMaxResizeRightDiff() {
        return Double.MAX_VALUE;
    }

    @Override
    public double getMaxResizeLeftDiff() {
        return -this.getStartTime();
    }

    @Override
    public void resizeLeft(double newStartTime) {
        double diff = this.startTime - newStartTime;
        this.setStartTime(newStartTime);
        this.setSubjectiveDuration(this.subjectiveDuration + diff);
    }

    @Override
    public void resizeRight(double newEndTime) {
        this.setSubjectiveDuration(newEndTime - this.startTime);
    }

    @Override
    public void addScoreObjectListener(ScoreObjectListener listener) {
        if (this.soundObjectListeners == null) {
            this.soundObjectListeners = new Vector();
        }
        this.soundObjectListeners.add(listener);
    }

    @Override
    public void removeScoreObjectListener(ScoreObjectListener listener) {
        if (this.soundObjectListeners == null) {
            return;
        }
        this.soundObjectListeners.remove(listener);
    }

    public void fireSoundObjectEvent(ScoreObjectEvent sObjEvent) {
        if (this.soundObjectListeners == null) {
            return;
        }
        for (ScoreObjectListener listener : this.soundObjectListeners) {
            listener.scoreObjectChanged(sObjEvent);
        }
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        ScoreObjectEvent event = new ScoreObjectEvent(this, 3);
        this.fireSoundObjectEvent(event);
    }

    @Override
    public int getLayerNumForScoreObject(ScoreObject scoreObj) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((SoundLayer)this.get(i)).contains(scoreObj)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public PolyObject deepCopy() {
        return new PolyObject(this);
    }

    @Override
    public PolyObject deepCopyLG() {
        return new PolyObject(this);
    }
}

