/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject;

import blue.score.ScoreGenerationException;
import blue.soundObject.SoundObject;
import blue.utility.ObjectUtilities;
import java.text.MessageFormat;

public class SoundObjectException
extends ScoreGenerationException {
    private SoundObject soundObject;
    private String message;
    private Throwable cause;
    private static final MessageFormat lineMessageFormat = new MessageFormat("Line {0}: {1}");
    private static final MessageFormat mainMessageFormat = new MessageFormat("There was an score generation error in the soundObject:\n\nType: {0}Name: {1}\nStart Time: {2}");

    public SoundObjectException(SoundObject sObj, Throwable cause) {
        this(sObj, null, cause);
    }

    public SoundObjectException(SoundObject sObj, String message) {
        this(sObj, message, null);
    }

    public SoundObjectException(SoundObject sObj, String message, Throwable cause) {
        this.soundObject = sObj;
        this.cause = cause;
        this.message = message;
    }

    @Override
    public String getMessage() {
        Object[] mainArgs = new Object[]{ObjectUtilities.getShortClassName(this.soundObject), this.soundObject.getName(), new Double(this.soundObject.getStartTime())};
        String retVal = mainMessageFormat.format(mainArgs);
        if (this.message != null) {
            retVal = retVal + "\n\nDetails:\n" + this.message;
        }
        if (this.cause != null) {
            retVal = retVal + "\n\nCause:\n" + this.cause.getMessage();
        }
        return retVal;
    }

    public SoundObject getSoundObject() {
        return this.soundObject;
    }
}

