/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.Maskable;
import blue.soundObject.jmask.Quantizable;
import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.TablePoint;
import blue.utility.MathUtils;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Oscillator
implements Generator,
Maskable,
Quantizable,
Accumulatable {
    public static final int SINE = 0;
    public static final int COSINE = 1;
    public static final int SAW_UP = 2;
    public static final int SAW_DOWN = 3;
    public static final int SQUARE = 4;
    public static final int TRIANGLE = 5;
    public static final int POW_UP = 6;
    public static final int POW_DOWN = 7;
    private static final double PI2 = Math.PI * 2;
    public static final String[] FUNCTIONS = new String[]{"Sine", "Cosine", "Saw (Increasing)", "Saw (Decreasing)", "Square", "Triangle", "Power Function (Increasing)", "Power Function (Decreasing)"};
    private int oscillatorType = 0;
    double phaseInit = 0.0;
    private double frequency = 1.0;
    private Table freqTable;
    private boolean freqTableEnabled = false;
    double exponent = 1.0;

    public Oscillator() {
        this.freqTable = new Table();
        this.freqTable.setMin(0.001, false);
        this.freqTable.setMax(10.0, false);
        TablePoint point1 = this.freqTable.points.get(0);
        TablePoint point2 = this.freqTable.points.get(1);
        point1.setValue(1.0);
        point2.setValue(1.0);
    }

    public Oscillator(Oscillator osc) {
        this.oscillatorType = osc.oscillatorType;
        this.phaseInit = osc.phaseInit;
        this.frequency = osc.frequency;
        this.freqTable = new Table(osc.freqTable);
        this.freqTableEnabled = osc.freqTableEnabled;
        this.exponent = osc.exponent;
    }

    public static Generator loadFromXML(Element data) {
        Oscillator retVal = new Oscillator();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "oscillatorType": {
                    retVal.oscillatorType = Integer.parseInt(node.getTextString());
                    break;
                }
                case "phaseInit": {
                    retVal.phaseInit = Double.parseDouble(node.getTextString());
                    break;
                }
                case "frequency": {
                    retVal.setFrequency(Double.parseDouble(node.getTextString()));
                    break;
                }
                case "freqTableEnabled": {
                    retVal.setFreqTableEnabled(Boolean.valueOf(node.getTextString()));
                    break;
                }
                case "table": {
                    retVal.setFreqTable(Table.loadFromXML(node));
                    break;
                }
                case "exponent": {
                    retVal.exponent = Double.parseDouble(node.getTextString());
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("generator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeInt("oscillatorType", this.oscillatorType));
        retVal.addElement(XMLUtilities.writeDouble("phaseInit", this.phaseInit));
        retVal.addElement(XMLUtilities.writeDouble("frequency", this.getFrequency()));
        retVal.addElement(XMLUtilities.writeBoolean("freqTableEnabled", this.isFreqTableEnabled()));
        retVal.addElement(this.getFreqTable().saveAsXML());
        retVal.addElement(XMLUtilities.writeDouble("exponent", this.exponent));
        return retVal;
    }

    public double getExponent() {
        return this.exponent;
    }

    public void setExponent(double exponent) {
        this.exponent = exponent;
    }

    public int getOscillatorType() {
        return this.oscillatorType;
    }

    public void setOscillatorType(int oscillatorType) {
        this.oscillatorType = oscillatorType;
    }

    @Override
    public void initialize(double duration) {
    }

    @Override
    public double getValue(double time, Random rnd) {
        double retVal = 0.0;
        double phase = this.getPhase(time);
        switch (this.oscillatorType) {
            case 0: {
                retVal = this.sin(phase);
                break;
            }
            case 1: {
                retVal = this.cos(phase);
                break;
            }
            case 2: {
                retVal = this.sawup(phase);
                break;
            }
            case 3: {
                retVal = this.sawdown(phase);
                break;
            }
            case 4: {
                retVal = this.square(phase);
                break;
            }
            case 5: {
                retVal = this.triangle(phase);
                break;
            }
            case 6: {
                retVal = this.powerup(phase);
                break;
            }
            case 7: {
                retVal = this.powerdown(phase);
            }
        }
        return retVal;
    }

    private double getPhase(double time) {
        double retVal = 0.0;
        retVal = !this.freqTableEnabled ? this.phaseInit + time * this.frequency : this.phaseInit + this.freqTable.getphs(time);
        return retVal;
    }

    public double getPhaseInit() {
        return this.phaseInit;
    }

    public void setPhaseInit(double phaseInit) {
        this.phaseInit = phaseInit;
    }

    private double sin(double phpt) {
        return Math.sin(Math.PI * 2 * phpt) * 0.5 + 0.5;
    }

    private double cos(double phpt) {
        return Math.cos(Math.PI * 2 * phpt) * 0.5 + 0.5;
    }

    private double sawup(double phpt) {
        System.err.println("Phase: " + phpt + " Value: " + MathUtils.remainder(phpt, 1.0));
        return Math.abs(MathUtils.remainder(phpt, 1.0));
    }

    private double sawdown(double phpt) {
        return 1.0 - Math.abs(MathUtils.remainder(phpt, 1.0));
    }

    private double square(double phpt) {
        double x = Math.abs(MathUtils.remainder(phpt, 1.0));
        return x < 0.5 ? 1.0 : 0.0;
    }

    private double triangle(double phpt) {
        double x = Math.abs(MathUtils.remainder(phpt, 1.0));
        return x < 0.5 ? 2.0 * x : 2.0 * (1.0 - x);
    }

    private double powerup(double phpt) {
        return Math.pow(Math.abs(MathUtils.remainder(phpt, 1.0)), Math.pow(2.0, this.exponent));
    }

    private double powerdown(double phpt) {
        return Math.pow(1.0 - Math.abs(MathUtils.remainder(phpt, 1.0)), Math.pow(2.0, this.exponent));
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public Table getFreqTable() {
        return this.freqTable;
    }

    public void setFreqTable(Table freqTable) {
        this.freqTable = freqTable;
    }

    public boolean isFreqTableEnabled() {
        return this.freqTableEnabled;
    }

    public void setFreqTableEnabled(boolean freqTableEnabled) {
        this.freqTableEnabled = freqTableEnabled;
    }

    @Override
    public Oscillator deepCopy() {
        return new Oscillator(this);
    }
}

