/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask.probability;

import blue.soundObject.jmask.Table;
import blue.soundObject.jmask.probability.ProbabilityGenerator;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Random;

public class Weibull
implements ProbabilityGenerator {
    private double s;
    private double t;
    private boolean sTableEnabled = false;
    private boolean tTableEnabled = false;
    private Table sTable;
    private Table tTable;

    public Weibull() {
        this.s = 0.5;
        this.t = 2.0;
        this.sTable = new Table();
        this.tTable = new Table();
        this.tTable.setMax(4.0, false);
        this.tTable.setMin(0.001, false);
        this.sTable.getPoint(0).setValue(0.5);
        this.sTable.getPoint(1).setValue(0.5);
        this.tTable.getPoint(0).setValue(2.0);
        this.tTable.getPoint(1).setValue(2.0);
    }

    public Weibull(Weibull wb) {
        this.s = wb.s;
        this.t = wb.t;
        this.sTableEnabled = wb.sTableEnabled;
        this.tTableEnabled = wb.tTableEnabled;
        this.sTable = new Table(wb.sTable);
        this.tTable = new Table(wb.tTable);
    }

    public static ProbabilityGenerator loadFromXML(Element data) {
        Weibull retVal = new Weibull();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            block7 : switch (nodeName = node.getName()) {
                case "s": {
                    retVal.s = XMLUtilities.readDouble(node);
                    break;
                }
                case "t": {
                    retVal.t = XMLUtilities.readDouble(node);
                    break;
                }
                case "sTableEnabled": {
                    retVal.sTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "tTableEnabled": {
                    retVal.tTableEnabled = XMLUtilities.readBoolean(node);
                    break;
                }
                case "table": {
                    String tableId;
                    switch (tableId = node.getAttributeValue("tableId")) {
                        case "sTable": {
                            retVal.sTable = Table.loadFromXML(node);
                            break block7;
                        }
                        case "tTable": {
                            retVal.tTable = Table.loadFromXML(node);
                        }
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("probabilityGenerator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement(XMLUtilities.writeDouble("s", this.s));
        retVal.addElement(XMLUtilities.writeDouble("t", this.t));
        retVal.addElement(XMLUtilities.writeBoolean("sTableEnabled", this.sTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("tTableEnabled", this.tTableEnabled));
        Element sTableNode = this.sTable.saveAsXML();
        sTableNode.setAttribute("tableId", "sTable");
        Element tTableNode = this.tTable.saveAsXML();
        tTableNode.setAttribute("tableId", "tTable");
        retVal.addElement(sTableNode);
        retVal.addElement(tTableNode);
        return retVal;
    }

    @Override
    public String getName() {
        return "Weibull";
    }

    @Override
    public double getValue(double time, Random rnd) {
        double x;
        double a;
        double e;
        double localS = this.sTableEnabled ? this.sTable.getValue(time) : this.s;
        double localT = this.tTableEnabled ? this.tTable.getValue(time) : this.t;
        while ((e = localS * Math.pow(Math.log(a = 1.0 / (1.0 - (x = rnd.nextDouble()))), 1.0 / localT)) > 1.0) {
        }
        return e;
    }

    public double getS() {
        return this.s;
    }

    public void setS(double s) {
        this.s = s;
    }

    public double getT() {
        return this.t;
    }

    public void setT(double t) {
        this.t = t;
    }

    public boolean isSTableEnabled() {
        return this.sTableEnabled;
    }

    public void setSTableEnabled(boolean sTableEnabled) {
        this.sTableEnabled = sTableEnabled;
    }

    public boolean isTTableEnabled() {
        return this.tTableEnabled;
    }

    public void setTTableEnabled(boolean tTableEnabled) {
        this.tTableEnabled = tTableEnabled;
    }

    public Table getSTable() {
        return this.sTable;
    }

    public void setSTable(Table sTable) {
        this.sTable = sTable;
    }

    public Table getTTable() {
        return this.tTable;
    }

    public void setTTable(Table tTable) {
        this.tTable = tTable;
    }

    @Override
    public Weibull deepCopy() {
        return new Weibull(this);
    }
}

