/*
 * Decompiled with CFR 0.152.
 */
package blue.udo;

import blue.udo.UserDefinedOpcode;
import blue.utility.ListUtil;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;

public class UDOCategory {
    private String categoryName = "New UDO Category";
    private ArrayList<UDOCategory> subCategories = new ArrayList();
    private ArrayList<UserDefinedOpcode> udos = new ArrayList();
    private boolean isRoot = false;

    public UDOCategory() {
    }

    public UDOCategory(UDOCategory cat) {
        this.categoryName = cat.categoryName;
        this.isRoot = cat.isRoot;
        for (UDOCategory udoCat : cat.subCategories) {
            this.subCategories.add(new UDOCategory(udoCat));
        }
        for (UserDefinedOpcode udo : cat.udos) {
            this.udos.add(new UserDefinedOpcode(udo));
        }
    }

    public String toString() {
        return this.getCategoryName();
    }

    public boolean removeUDO(UserDefinedOpcode udo) {
        int index = ListUtil.indexOfByRef(this.udos, udo);
        if (index >= 0) {
            this.udos.remove(index);
            return true;
        }
        for (UDOCategory category : this.subCategories) {
            if (!category.removeUDO(udo)) continue;
            return true;
        }
        return false;
    }

    public boolean removeUDOCategory(UDOCategory category) {
        int index = ListUtil.indexOfByRef(this.subCategories, category);
        if (index >= 0) {
            this.subCategories.remove(index);
            return true;
        }
        for (UDOCategory tempCategory : this.subCategories) {
            if (!tempCategory.removeUDOCategory(category)) continue;
            return true;
        }
        return false;
    }

    public void addUDOCategory(UDOCategory category) {
        this.subCategories.add(category);
    }

    public void addUDO(int insertIndex, UserDefinedOpcode udo) {
        this.udos.add(insertIndex, udo);
    }

    public void addUDO(UserDefinedOpcode udo) {
        this.udos.add(udo);
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public ArrayList<UserDefinedOpcode> getUserDefinedOpcodes() {
        return this.udos;
    }

    public ArrayList<UserDefinedOpcode> getAllUserDefinedOpcodes() {
        ArrayList<UserDefinedOpcode> retVal = new ArrayList<UserDefinedOpcode>();
        for (UDOCategory cat : this.subCategories) {
            retVal.addAll(cat.getAllUserDefinedOpcodes());
        }
        retVal.addAll(this.udos);
        return retVal;
    }

    public void setUserDefinedOpcodes(ArrayList instruments) {
        this.udos = instruments;
    }

    public ArrayList<UDOCategory> getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(ArrayList subCategories) {
        this.subCategories = subCategories;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public static UDOCategory loadFromXML(Element data) throws Exception {
        UDOCategory udoCat = new UDOCategory();
        udoCat.setCategoryName(data.getAttributeValue("categoryName"));
        udoCat.setRoot(Boolean.valueOf(data.getAttributeValue("isRoot")));
        Elements subCatNodes = data.getElements("udoCategory");
        while (subCatNodes.hasMoreElements()) {
            udoCat.addUDOCategory(UDOCategory.loadFromXML(subCatNodes.next()));
        }
        Elements udoNodes = data.getElements("udo");
        while (udoNodes.hasMoreElements()) {
            udoCat.addUDO(UserDefinedOpcode.loadFromXML(udoNodes.next()));
        }
        return udoCat;
    }

    public Element saveAsXML() {
        Element retVal = new Element("udoCategory");
        retVal.setAttribute("categoryName", this.getCategoryName());
        retVal.setAttribute("isRoot", Boolean.toString(this.isRoot()));
        for (UDOCategory tempCat : this.subCategories) {
            retVal.addElement(tempCat.saveAsXML());
        }
        for (UserDefinedOpcode udo : this.udos) {
            retVal.addElement(udo.saveAsXML());
        }
        return retVal;
    }
}

