/*
 * Decompiled with CFR 0.152.
 */
package blue.udo;

import electric.xml.Element;
import electric.xml.Elements;

public class UserDefinedOpcode {
    public String opcodeName = "newOpcode";
    public transient String commentText = null;
    public String outTypes = "";
    public String inTypes = "";
    public String codeBody = "";
    public String comments = "";

    public UserDefinedOpcode() {
    }

    public UserDefinedOpcode(UserDefinedOpcode udo) {
        this.opcodeName = udo.opcodeName;
        this.outTypes = udo.outTypes;
        this.inTypes = udo.inTypes;
        this.codeBody = udo.codeBody;
        this.comments = udo.comments;
    }

    public static UserDefinedOpcode loadFromXML(Element data) {
        UserDefinedOpcode retVal = new UserDefinedOpcode();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String val = node.getTextString();
            if (val == null) {
                val = "";
            }
            switch (node.getName()) {
                case "opcodeName": {
                    retVal.opcodeName = val;
                    break;
                }
                case "outTypes": {
                    retVal.outTypes = val;
                    break;
                }
                case "inTypes": {
                    retVal.inTypes = val;
                    break;
                }
                case "codeBody": {
                    retVal.codeBody = val;
                    break;
                }
                case "comments": {
                    retVal.comments = val;
                }
            }
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("udo");
        retVal.addElement("opcodeName").setText(this.opcodeName);
        retVal.addElement("outTypes").setText(this.outTypes);
        retVal.addElement("inTypes").setText(this.inTypes);
        retVal.addElement("codeBody").setText(this.codeBody);
        retVal.addElement("comments").setText(this.comments);
        return retVal;
    }

    public String generateCode() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\topcode ").append(this.opcodeName);
        buffer.append(",").append(this.outTypes);
        buffer.append(",").append(this.inTypes);
        if (this.commentText != null) {
            buffer.append(" ; ").append(this.commentText);
        }
        buffer.append("\n");
        buffer.append("\n").append(this.codeBody).append("\n\n");
        buffer.append("\tendop");
        return buffer.toString();
    }

    public String toString() {
        return this.opcodeName;
    }

    public String getOpcodeName() {
        return this.opcodeName;
    }

    public void setOpcodeName(String opcodeName) {
        this.opcodeName = opcodeName;
    }

    public static void main(String[] args) {
        UserDefinedOpcode udo = new UserDefinedOpcode();
        udo.opcodeName = "getFrequency";
        udo.outTypes = "i";
        udo.inTypes = "i";
        udo.codeBody = "ipch\t xin\niout\t= (ipch < 15 ? cpspch(ipch) : ipch)\n\txout iout\t";
        System.out.println(udo.toString());
    }

    public boolean isEquivalent(UserDefinedOpcode udo) {
        if (udo == null) {
            return false;
        }
        return this.inTypes.equals(udo.inTypes) && this.outTypes.equals(udo.outTypes) && this.codeBody.equals(udo.codeBody);
    }
}

