;
; "TimeSphere"
; by Steven Yi
;
; "TimeSphere" is inspired by the idea that time is not infinite but bounded, like a sphere,
; and that there are inifinite possible projections through time within this sphere. (I don't
; remember the exact origin of this thought, but I believe I may have derived it from 
; Stephen Hawking's idea of a closed universe in "Brief History of Time".) 
; 
; I've always found the world to be filled with many strata of time. Things move together, 
; alone, and somewhere in between, moving from one time flow to another.  The idea of
; a sphere of time in which the world moves was an inspiration for this work, and not 
; interpreted literally. While composing this piece, I was very aware of the the interplay 
; between rational development and the exploration of where intuition guided me.  
; 
; Completed: July 27th, 2013
;
; Generated by blue 2.4.3 (http://blue.kunstmusik.com)
;

<CsoundSynthesizer>

<CsInstruments>
sr=44100
ksmps=16
nchnls=2
0dbfs=1


ga_bluemix_1_0	init	0
ga_bluemix_1_1	init	0
ga_bluemix_4_0	init	0
ga_bluemix_4_1	init	0
ga_bluemix_5_0	init	0
ga_bluemix_5_1	init	0
ga_bluemix_7_0	init	0
ga_bluemix_7_1	init	0
ga_bluemix_8_0	init	0
ga_bluemix_8_1	init	0
ga_bluemix_9_0	init	0
ga_bluemix_9_1	init	0
ga_bluemix_10_0	init	0
ga_bluemix_10_1	init	0
ga_bluesub_Master_0	init	0
ga_bluesub_Master_1	init	0


gk_blue_auto0 init 0
gk_blue_auto1 init 0.0500000007
gk_blue_auto2 init 1400
gk_blue_auto3 init 0.2383197844
gk_blue_auto4 init 0
gk_blue_auto5 init 1
gk_blue_auto6 init 2
gk_blue_auto7 init 0.1068684459
gk_blue_auto8 init 2.0667357445
gk_blue_auto9 init 0.9579092264
gk_blue_auto10 init 0
gk_blue_auto11 init 0
gk_blue_auto12 init 0.0834720507
gk_blue_auto13 init 0.0901802629
gk_blue_auto14 init 0
gk_blue_auto15 init 1
gk_blue_auto16 init 1
gk_blue_auto17 init 0.200000003
gk_blue_auto18 init 0
gk_blue_auto19 init 0.6469643116
gk_blue_auto20 init 0.7199677825
gk_blue_auto21 init 0.625629127
gk_blue_auto22 init 0.200000003
gk_blue_auto23 init 0
gk_blue_auto24 init 0.7760154009
gk_blue_auto25 init 0.7210380435
gk_blue_auto26 init 0
gk_blue_auto27 init 9
gk_blue_auto28 init 0.0500000007
gk_blue_auto29 init 0.25
gk_blue_auto30 init 0.666266799
gk_blue_auto31 init 0
gk_blue_auto32 init 1
gk_blue_auto33 init 9.5811004639
gk_blue_auto34 init 1
gk_blue_auto35 init 0
gk_blue_auto36 init 0
gk_blue_auto37 init 0
gk_blue_auto38 init 1
gk_blue_auto39 init 6
gk_blue_auto40 init 4
gk_blue_auto41 init 0
gk_blue_auto42 init 0.099999994
gk_blue_auto43 init 10.2049884796
gk_blue_auto44 init 0.0145723308
gk_blue_auto45 init 0.028768532
gk_blue_auto46 init 1
gk_blue_auto47 init 2
gk_blue_auto48 init 3
gk_blue_auto49 init 4
gk_blue_auto50 init 6
gk_blue_auto51 init 8
gk_blue_auto52 init 1
gk_blue_auto53 init 1
gk_blue_auto54 init 0.6999999881
gk_blue_auto55 init 0.5
gk_blue_auto56 init 0.3000000119
gk_blue_auto57 init 0.1000000015
gk_blue_auto58 init 1
gk_blue_auto59 init 1
gk_blue_auto60 init 1
gk_blue_auto61 init 1
gk_blue_auto62 init 1
gk_blue_auto63 init 0
gk_blue_auto64 init 0.7033399343
gk_blue_auto65 init 0.6287568808
gk_blue_auto66 init 0.3631770909
gk_blue_auto67 init 0.409876883
gk_blue_auto68 init 0.2884566486
gk_blue_auto69 init 0.6587585807
gk_blue_auto70 init 0.1461223066
gk_blue_auto71 init 0.4080914557
gk_blue_auto72 init 0.896673739
gk_blue_auto73 init 0.099999994
gk_blue_auto74 init 446.5081787109
gk_blue_auto75 init 0.0145723308
gk_blue_auto76 init 0.0440731309
gk_blue_auto77 init 0.8999999762
gk_blue_auto78 init 0.3931129277
gk_blue_auto79 init 0.3984398246
gk_blue_auto80 init 0.1461223066
gk_blue_auto81 init 0.694748044
gk_blue_auto82 init 0.896673739
gk_blue_auto83 init 0.0199999996
gk_blue_auto84 init 0.0299999993
gk_blue_auto85 init 2
gk_blue_auto86 init 0.1120000035
gk_blue_auto87 init 0.5016866922
gk_blue_auto88 init 0.8999999762
gk_blue_auto89 init 1
gk_blue_auto90 init 0.2979246378
gk_blue_auto91 init 0.2079724371
gk_blue_auto92 init 0.0199999996
gk_blue_auto93 init 0.0500000007
gk_blue_auto94 init 87.6385192871
gk_blue_auto95 init 127.5178756714
gk_blue_auto96 init 130.5656433105
gk_blue_auto97 init 924.2854003906
gk_blue_auto98 init 3676.7016601562
gk_blue_auto99 init 2286.6469726562
gk_blue_auto100 init 1
gk_blue_auto101 init 1
gk_blue_auto102 init 1
gk_blue_auto103 init 1
gk_blue_auto104 init 2
gk_blue_auto105 init 3
gk_blue_auto106 init 0.3367043436
gk_blue_auto107 init 0.2187798321
gk_blue_auto108 init 0.1479236335
gk_blue_auto109 init 0.1000000015
gk_blue_auto110 init 0
gk_blue_auto111 init 0
gk_blue_auto112 init 0
gk_blue_auto113 init 0.4616867006
gk_blue_auto114 init 0.9409708977
gk_blue_auto115 init 0
gk_blue_auto116 init 3
gk_blue_auto117 init 2
gk_blue_auto118 init 0
gk_blue_auto119 init 0.0500000007
gk_blue_auto120 init 3000
gk_blue_auto121 init 0.2383197844
gk_blue_auto122 init 0
gk_blue_auto123 init 1
gk_blue_auto124 init 2
gk_blue_auto125 init 0.1000000015
gk_blue_auto126 init 2.0667357445
gk_blue_auto127 init 0.9579092264
gk_blue_auto128 init 0
gk_blue_auto129 init 0.0834720507
gk_blue_auto130 init 0.0901802629
gk_blue_auto131 init 0
gk_blue_auto132 init 1
gk_blue_auto133 init 1
gk_blue_auto134 init 0.2709082961
gk_blue_auto135 init 0.0190405566
gk_blue_auto136 init 0.1992811561
gk_blue_auto137 init 0.9434980154
gk_blue_auto138 init 0.625629127
gk_blue_auto139 init 0.200000003
gk_blue_auto140 init 0.0500000007
gk_blue_auto141 init 0.6000000238
gk_blue_auto142 init 0.7210380435
gk_blue_auto143 init 0
gk_blue_auto144 init 1
gk_blue_auto145 init 0.0500000007
gk_blue_auto146 init 0.25
gk_blue_auto147 init 0.5
gk_blue_auto148 init 1
gk_blue_auto149 init 9.5811004639
gk_blue_auto150 init 1
gk_blue_auto151 init 0
gk_blue_auto152 init 2
gk_blue_auto153 init 0
gk_blue_auto154 init 1
gk_blue_auto155 init 1
gk_blue_auto156 init 0
gk_blue_auto157 init 0
gk_blue_auto158 init 0.1000000015
gk_blue_auto159 init 1000
gk_blue_auto160 init 0.3000000119
gk_blue_auto161 init -0.0001
gk_blue_auto162 init 1.5
gk_blue_auto163 init 2
gk_blue_auto164 init 0.0729637966
gk_blue_auto165 init 0.6188243032
gk_blue_auto166 init 0.0373032838
gk_blue_auto167 init 0
gk_blue_auto168 init 0.0834720507
gk_blue_auto169 init 0.0901802629
gk_blue_auto170 init 0
gk_blue_auto171 init 1
gk_blue_auto172 init 1
gk_blue_auto173 init 0.1000000015
gk_blue_auto174 init 0.0313186944
gk_blue_auto175 init 0.7685651779
gk_blue_auto176 init 0.353800565
gk_blue_auto177 init 0.9346968532
gk_blue_auto178 init 0.4365006387
gk_blue_auto179 init 0.2048960626
gk_blue_auto180 init 0.4863046706
gk_blue_auto181 init 0.8999999762
gk_blue_auto182 init 0
gk_blue_auto183 init 7
gk_blue_auto184 init 0.0087949233
gk_blue_auto185 init 0.1559868008
gk_blue_auto186 init 0.2330836505
gk_blue_auto187 init 0
gk_blue_auto188 init 9.5811004639
gk_blue_auto189 init 1
gk_blue_auto190 init 2
gk_blue_auto191 init 4
gk_blue_auto192 init 4
gk_blue_auto193 init 2
gk_blue_auto194 init 1
gk_blue_auto195 init 0
gk_blue_auto196 init 8000
gk_blue_auto197 init 0.8500000238
gk_blue_auto198 init 0.3000000119
gk_blue_auto199 init -2
gk_blue_auto200 init 0
gk_blue_auto201 init 0
gk_blue_auto202 init 0
gk_blue_auto203 init -6.1999998093
gk_blue_auto204 init 0
gk_blue_auto205 init 0
gk_blue_auto206 init 0
gk_blue_auto207 init 0
gk_blue_auto208 init 0
gk_blue_auto209 init 4950
gk_blue_auto210 init 0.8000000119
gk_blue_auto211 init 0.8999999762
gk_blue_auto212 init -6


gi_sine	ftgen 0, 0, 65536, 10, 1

 
;Horner and Ayers French Horn tables
gi_horn_seed = .5
gi_horn_cutoff	ftgen 0, 0, 16, -2, 40, 40, 80, 160, 320, 640, 1280, 2560, 5120, 10240, 10240	;LP Filter Cutoff Lookup table
gi_horn_wt	ftgen 0, 0, 2048, -17, 0, 0, 85, 1, 114, 2, 153, 3, 204, 4, 272, 5, 364, 6, 486, 7	; horn wavetables
gi_horn0	ftgen 0, 0, 5, -9, 1, 0.0, 0	; zero amp sine wave
gi_horn1	ftgen 0, 0, 4096, -9, 2, 6.236, 0, 3, 12.827, 0
gi_horn2	ftgen 0, 0, 4096, -9, 4, 21.591, 0, 5, 11.401, 0, 6, 3.570, 0, 7, 2.833, 0
gi_horn3	ftgen 0, 0, 4096, -9, 8, 3.070, 0, 9, 1.053, 0, 10, 0.773, 0, 11, 1.349, 0, 12, 0.819, 0, 13, 0.369, 0, 14, 0.362, 0, 15, 0.165, 0, 16, 0.124, 0, 18, 0.026, 0, 19, 0.042, 0
gi_horn4	ftgen 0, 0, 4096, -9, 2, 3.236, 0, 3, 6.827, 0
gi_horn5	ftgen 0, 0, 4096, -9, 4, 5.591, 0, 5, 2.401, 0, 6, 1.870, 0, 7, 0.733, 0
gi_horn6	ftgen 0, 0, 4096, -9, 8, 0.970, 0, 9, 0.553, 0, 10, 0.373, 0, 11, 0.549, 0, 12, 0.319, 0, 13, 0.119, 0, 14, 0.092, 0, 15, 0.045, 0, 16, 0.034, 0
gi_horn7	ftgen 0, 0, 4096, -9, 2, 5.019, 0, 3, 4.281, 0
gi_horn8	ftgen 0, 0, 4096, -9, 4, 2.091, 0, 5, 1.001, 0, 6, 0.670, 0, 7, 0.233, 0
gi_horn9	ftgen 0, 0, 4096, -9, 8, 0.200, 0, 9, 0.103, 0, 10, 0.073, 0, 11, 0.089, 0, 12, 0.059, 0, 13, 0.029, 0
gi_horn10	ftgen 0, 0, 4096, -9, 2, 4.712, 0, 3, 1.847, 0
gi_horn11	ftgen 0, 0, 4096, -9, 4, 0.591, 0, 5, 0.401, 0, 6, 0.270, 0, 7, 0.113, 0
gi_horn12	ftgen 0, 0, 4096, -9, 8, 0.060, 0, 9, 0.053, 0, 10, 0.023, 0
gi_horn13	ftgen 0, 0, 4096, -9, 2, 1.512, 0, 3, 0.247, 0
gi_horn14	ftgen 0, 0, 4096, -9, 4, 0.121, 0, 5, 0.101, 0, 6, 0.030, 0, 7, 0.053, 0
gi_horn15	ftgen 0, 0, 4096, -9, 8, 0.030, 0
gi_horn16	ftgen 0, 0, 4096, -9, 2, 0.412, 0, 3, 0.087, 0
gi_horn17	ftgen 0, 0, 4096, -9, 4, 0.071, 0, 5, 0.021, 0
gi_horn18	ftgen 0, 0, 4096, -9, 2, 0.309, 0, 3, 0.067, 0
gi_horn19	ftgen 0, 0, 4096, -9, 4, 0.031, 0
gi_horn20	ftgen 0, 0, 4096, -9, 2, 0.161, 0, 3, 0.047, 0
; instrument wavetable numbers
gi_horn_instrwt	ftgen 0, 0, 64, -2, gi_horn1, gi_horn2, gi_horn3, 52.476, gi_horn4, gi_horn5, gi_horn6, 18.006, \
			gi_horn7, gi_horn8, gi_horn9, 11.274, gi_horn10, gi_horn11, gi_horn12, 6.955, \ 
			gi_horn13, gi_horn14, gi_horn15, 2.260, gi_horn16, gi_horn17, gi_horn0, 1.171, \
			gi_horn18, gi_horn19, gi_horn0, 1.106, gi_horn20, gi_horn0, gi_horn0, 1.019	

gi_horn_stop_cutoff	ftgen 0, 0, 16, -2, 40, 40, 80, 160, 320, 640, 1280, 2560, 5120, 10240, 10240	; filter cutoff table
gi_horn_stop_wt	ftgen 0, 0, 16384, -17, 0, 0, 272, 1, 363, 2, 484, 3	; stopped horn wavetables
gi_horn_stop0	ftgen 0, 0, 5, -9, 1, 0.0, 0	; zero-amp sine wave
gi_horn_stop1	ftgen 0, 0, 4097, -9, 2, 0.961, 0, 3, 0.052, 0
gi_horn_stop2	ftgen 0, 0, 4097, -9, 4, 0.079, 0, 5, 0.137, 0, 6, 0.185, 0, 7, 0.109, 0
gi_horn_stop3	ftgen 0, 0, 4097, -9, 8, 0.226, 0, 9, 0.107, 0, 10, 0.155, 0, 11, 0.140, 0, 12, 0.428, 0, 13, 0.180, 0, 14, 0.070, 0, 15, 0.112, 0, 16, 0.335, 0, 17, 0.183, 0, 18, 0.073, 0, 19, 0.172, 0, 20, 0.117, 0, 21, 0.089, 0, 22, 0.193, 0, 23, 0.119, 0, 24, 0.080, 0, 25, 0.036, 0, 26, 0.143, 0, 27, 0.036, 0, 28, 0.044, 0, 29, 0.040, 0, 30, 0.052, 0, 31, 0.086, 0, 32, 0.067, 0, 33, 0.097, 0, 34, 0.046, 0, 36, 0.030, 0, 37, 0.025, 0, 38, 0.048, 0, 39, 0.021, 0, 40, 0.025
gi_horn_stop4	ftgen 0, 0, 4097, -9, 2, 0.162, 0, 3, 0.068, 0
gi_horn_stop5	ftgen 0, 0, 4097, -9, 4, 0.116, 0, 5, 0.138, 0, 6, 0.050, 0, 7, 0.089, 0
gi_horn_stop6	ftgen 0, 0, 4097, -9, 8, 0.156, 0, 9, 0.381, 0, 10, 0.191, 0, 11, 0.126, 0, 12, 0.162, 0, 13, 0.073, 0, 15, 0.157, 0, 16, 0.074, 0, 17, 0.087, 0, 18, 0.151, 0, 19, 0.093, 0, 20, 0.031, 0, 21, 0.030, 0, 22, 0.051, 0, 23, 0.058, 0, 24, 0.051, 0, 25, 0.077, 0, 26, 0.033, 0, 27, 0.021, 0, 28, 0.039, 0
gi_horn_stop7	ftgen 0, 0, 4097, -9, 2, 0.164, 0, 3, 0.164, 0
gi_horn_stop8	ftgen 0, 0, 4097, -9, 4, 0.401, 0, 5, 0.141, 0, 6, 0.293, 0, 7, 0.203, 0
gi_horn_stop9	ftgen 0, 0, 4097, -9, 8, 0.170, 0, 9, 0.306, 0, 10, 0.170, 0, 11, 0.103, 0, 12, 0.131, 0, 13, 0.134, 0, 14, 0.047, 0, 15, 0.182, 0, 16, 0.049, 0, 17, 0.088, 0, 18, 0.088, 0, 19, 0.064, 0, 20, 0.024, 0, 21, 0.064, 0, 22, 0.022
gi_horn_stop10	ftgen 0, 0, 4097, -9, 2, 0.193, 0, 3, 0.542, 0
gi_horn_stop11	ftgen 0, 0, 4097, -9, 4, 0.125, 0, 5, 0.958, 0, 6, 0.154, 0, 7, 0.364, 0
gi_horn_stop12	ftgen 0, 0, 4097, -9, 8, 0.444, 0, 9, 0.170, 0, 10, 0.090, 0, 11, 0.077, 0, 12, 0.026, 0, 13, 0.073, 0
; instrument wavetable numbers
gi_horn_stop_instrwt	ftgen 0, 0, 64, -2, gi_horn_stop1, gi_horn_stop2, gi_horn_stop3, 3.172, gi_horn_stop4, gi_horn_stop5, gi_horn_stop6, 1.947, \
			gi_horn_stop7, gi_horn_stop8, gi_horn_stop9, 2.221, gi_horn_stop10, gi_horn_stop11, gi_horn_stop12, 2.811


	opcode tie_status,i,0

itie tival

if (itie == 0 && p3 < 0) ithen
    ; this is an initial note within a group of tied notes
    itiestatus = 0
       
elseif (p3 < 0 && itie == 1) ithen
    ; this is a middle note within a group of tied notes 
    itiestatus = 1

elseif (p3 > 0 && itie == 1) ithen
    ; this is an end note out of a group of tied notes
    itiestatus = 2

elseif (p3 > 0 && itie == 0) ithen
    ; this note is a standalone note
    itiestatus = -1

endif  

	xout	itiestatus



	endop
	opcode getFrequency,i,i

ipch 	xin

if (ipch < 15) then
	iout cps2pch ipch, 12
else
	iout = ipch
endif

	xout	iout


	endop
	opcode tekno_lpf4,a,aKK

asig, kfco, krez xin

idistortiontab chnget "lpf4.disttab"

if(idistortiontab == 0) then

idistortiontab	ftgen 0, 0, 65537, 8, 1, 8193, .99, 8192, .96, 8192, .9, 4096, -.8, 8192, -.8, 4096, -.9, 8192, -.96, 8192, -.99, 8192, -1
chnset idistortiontab, "lpf4.disttab"

endif


krez = krez * 4.999 + .001

ifqcadj  =      .149659863*sr
;iband = 0

; Resonant Lowpass Filter (4 Pole)
kcl    =        ifqcadj/kfco
krez2  =        krez/(1+exp(kfco/11000))
//krez2l =        2.0/(1+exp(kfco/11000))
ka1l   =        kcl/krez2 - 1 ;-(1+krez2*iband)
kasql  =        kcl*kcl
kbl    =        1+ka1l+kasql

ka = (ka1l+2*kasql)/kbl
kb = -kasql/kbl

asig   nlfilt   asig/kbl, ka, kb, 0, 0, 1
asig2  nlfilt   asig/kbl, ka, kb, 0, 0, 1

arez   =       (asig2-asig)*.5

aclip  tablei  arez, idistortiontab, 1, .5
aout   =       (aclip * .5) + asig


xout asig2

	endop
	opcode yiMultiLpf,a,aKKKK

aout, kfilterType, kcutoff, kresonance, kdistortion xin

itie tival

if (kfilterType == 0) then

	aout	moogladder		aout, kcutoff, kresonance, itie

elseif (kfilterType == 1) then

	aout	moogvcf		aout, kcutoff, kresonance, 0, itie

elseif (kfilterType == 2) then

	aout	lpf18		aout, kcutoff, kresonance, kdistortion, itie

elseif (kfilterType == 3) then

	aout	butterlp		aout, kcutoff, itie

elseif (kfilterType == 4) then

	aout	tekno_lpf4		aout, kcutoff, kresonance

elseif (kfilterType == 5) then

	aout	moogvcf2		aout, kcutoff, kresonance, 0, itie

endif



xout aout

	endop
	opcode chorus,aa,aaK

ain1, ain2, kwet xin

setksmps 1

; CHORUS

isin		ftgentmp	0, 0, 65536, 10, 1

ilevl		=		0.3		; Output level
idelay		=		0.01		; Delay in ms
idpth		=		0.002		; Depth in ms
imax		=		0.25		; Maximum LFO rate
imin		=		0.5		; Minimum LFO rate
iwave		=		isin		; LFO waveform

ain             =               ain1 + ain2 * .5
ain             =               ain * ilevl

i01             =               rnd(imax)
i02             =               rnd(imax)
i03             =               rnd(imax)
i04             =               rnd(imax)
i05             =               rnd(imax)
i06             =               rnd(imax)
i07             =               rnd(imax)
i08             =               rnd(imax)
i09             =               rnd(imax)
i10             =               rnd(imax)
i11             =               rnd(imax)
i12             =               rnd(imax)

alfo01          oscil           idpth, i01 + imin, iwave
alfo02          oscil           idpth, i02 + imin, iwave, .08
alfo03          oscil           idpth, i03 + imin, iwave, .17
alfo04          oscil           idpth, i04 + imin, iwave, .25
alfo05          oscil           idpth, i05 + imin, iwave, .33
alfo06          oscil           idpth, i06 + imin, iwave, .42
alfo07          oscil           idpth, i07 + imin, iwave, .50
alfo08          oscil           idpth, i08 + imin, iwave, .58
alfo09          oscil           idpth, i09 + imin, iwave, .67
alfo10          oscil           idpth, i10 + imin, iwave, .75
alfo11          oscil           idpth, i11 + imin, iwave, .83
alfo12          oscil           idpth, i12 + imin, iwave, .92

atemp           delayr          idelay + idpth +.1
a01             deltapi         idelay + alfo01
a02             deltapi         idelay + alfo02
a03             deltapi         idelay + alfo03
a04             deltapi         idelay + alfo04
a05             deltapi         idelay + alfo05
a06             deltapi         idelay + alfo06
a07             deltapi         idelay + alfo07
a08             deltapi         idelay + alfo08
a09             deltapi         idelay + alfo09
a10             deltapi         idelay + alfo10
a11             deltapi         idelay + alfo11
a12             deltapi         idelay + alfo12
                delayw          ain

achorusl        sum		a01, a02, a03, a04, a05, a06
achorusr        sum             a07, a08, a09, a10, a11, a12

aout1		=		ain1 * (1-kwet) + achorusl * kwet
aout2		=		ain2 * (1-kwet) + achorusr * kwet

xout	aout1, aout2

	endop
	opcode ADSD,k,iiiiK

 imax,iatt,idec,isus,ktrig    xin 

 ktime init 0
 kv init 0
 iper = 1/kr

 itie tival

 if (ktrig == 1) then
   ktime = ktime + iper
   if ktime < iatt then
     kt  = iatt / 4
     kv = imax
   else 
     kt = idec / 4
     kv = isus
   endif
 else
   kv = 0
   kt = idec / 4
   ktime = 0
 endif

 kenv  portk  kv, kt, -itie
            xout  kenv



	endop
	opcode yi_env_orch,k,ioooooo

ienvType, iattack, idecay, isus, irel, iOldAmp, iNewAmp	xin

kenvtype init ienvType
itie	tival
ktie 	init itie
idur = abs(p3)
imindur = iattack + idecay

if(idur < imindur) then
  idur = imindur
  p3 = idur
endif

iEndAmp = iNewAmp / iOldAmp

if (kenvtype == 0) then
	;kenv	madsr	iattack, idecay, isus, irel
	kenv	linsegr	0, iattack, 1, idecay, isus, irel, 0
elseif (kenvtype == 1) then	
        idur2 = idur - .02
	kenv 	linseg	0, idur2 * .5, 1, .02, 1, idur2 * .5, 0
	kenv logcurve kenv, 1.5

elseif (kenvtype == 2) then	
	kenv	linseg 	0, idur - .1, 1, .1, 0	

elseif (kenvtype == 3) then

    if (ktie == 0 && p3 < 0) then
        ; this is an initial note within a group of tied notes
        kenv	linseg	0, .2, 1,  .2, 1
       
    elseif (p3 > 0 && ktie == 1) then
        ; this is an end note out of a group of tied notes
	kenv linsegr	1, .01, 1, irel, 0
 
    elseif (p3 > 0 && ktie == 0) then
        ; this is a stand alone note
	kenv	madsr	iattack, idecay, isus, irel
    else
        ; this is a middle note within a group of tied notes (p3 < 0 && itie == 1)
        kenv = 1
    endif  

endif

	xout 	kenv


	endop
	opcode yi_env_midi,k,iiiii

itype, iattack, idecay, isustain, irelease xin
setksmps 1
ktype init itype

if (ktype == 0) then

kout transegr 0, iattack, 0, 1, idecay, -2, isustain, irelease, -2, 0

else

krel release

kout ADSD 1, iattack, idecay, isustain, 1 - krel
xtratim idecay + .05

endif

	xout kout


	endop
	opcode yi_tie_amp,k,i

itie 	tie_status
ktie	init itie
idur 	init abs(p3)

iampval xin

if(itie < 1) then
	iamp  	= ampdbfs(iampval)
	kamp	init iamp
else
	iamp1 	= iamp 
	iamp	= ampdbfs(iampval)
endif

if(ktie >= 1) then
	kamp 	linseg iamp1, idur, iamp
endif

	xout kamp

	endop
	opcode yi_instr_gen,kkkk,iiiiiK

ienvType, iattack, idecay, isustain, irelease, kspace xin

ipcount pcount
kpcount init ipcount

idur 	= abs(p3)

iampval 	init 0

if (ipcount == 5) then
    ipch        getFrequency p4
    kpchline    init ipch
    iampval     init p5
    kspaceOut   = kspace

else

    ipch        getFrequency p4
    ipch2       getFrequency p5
    iampval     init p6
    ienvType    init p8
    kspaceOut   init (p7 * .5) + .5

endif

if (kpcount == 5) then ; MIDI-Style Note

    kenv yi_env_midi ienvType, iattack, idecay, isustain, irelease

else ; SYi Orch Note

    kpchline    line ipch, idur, ipch2
    kenv        yi_env_orch ienvType, iattack, idecay, isustain, irelease

endif

kamp 	yi_tie_amp iampval

	xout kpchline, kamp, kenv, kspaceOut

	endop
	opcode lfo2,k,kko

kcps, ktype, iskip xin

iSineTable	chnget	"lfo2_sine"

if (iSineTable == 0) then
	iSineTable	ftgen 	0, 0, 65536, 10, 1 ; sine wave
	chnset	iSineTable, "lfo2_sine"
endif

kout init 0

if (ktype == 0) then ;SINE
	kout 	oscil3 1, kcps, iSineTable, iskip * -1

elseif (ktype == 1) then ;TRIANGLE
	aout	vco2 1, kcps, 12, iskip
	kout downsamp aout

elseif (ktype == 2) then ;SQUARE (BI-POLAR)
	aout	vco2 1, kcps, 10, iskip
	kout downsamp aout

elseif (ktype == 3) then ;SQUARE (UNI-POLAR)
	aout	vco2 1, kcps, 10, iskip
	kout downsamp aout
	kout = (kout + 1) / 2

elseif (ktype == 4) then ;SAW TOOTH (UP)
	aout	vco2 1, kcps, 0, iskip
	kout downsamp aout


elseif (ktype == 5) then ;SAW TOOTH (DOWN)
	aout	vco2 1, kcps, 0, iskip
	kout downsamp aout
	kout = kout * -1

endif

xout kout

	endop
	opcode distortion,a,a

ain xin

idistortiontab chnget "lpf4.disttab"

if(idistortiontab == 0) then

idistortiontab	ftgen 0, 0, 65537, 8, 1, 8193, .99, 8192, .96, 8192, .9, 4096, -.8, 8192, -.8, 4096, -.9, 8192, -.96, 8192, -.99, 8192, -1
chnset idistortiontab, "lpf4.disttab"

endif

aclip  tablei  ain, idistortiontab, 1, .5
aout   =       (aclip * .5) + ain

xout aout

	endop
	opcode tokbox,a,akk

ain, kvoice, kformi xin

itables chnget "tokbox.tables"
iformamp0 chnget "tokbox.formamp0"
iformamp1 chnget "tokbox.formamp1"
iformamp2 chnget "tokbox.formamp2"


if(itables == 0) then

; Formants 0="ee", 1="i", 2="e", 3="ae", 4="ah", 5="aw", 6="u^", 7="oo", 8="u", 9="er"

	; Male Formants Spoken
imale0	ftgen 0, 0, 16, -2, 270, 390, 530, 660, 730, 570, 440, 300, 640, 490
imale1	ftgen 0, 0, 16, -2, 2290, 1990, 1840, 1720, 1090, 840, 1020, 870, 1190, 1350
imale2	ftgen 0, 0, 16, -2, 3010, 2550, 2480, 2410, 2440, 2410, 2240, 2240, 2390, 1690

	; Male Formants Sung
imalesung0	ftgen 0, 0, 16, -2, 300, 375, 530, 620, 700, 610, 400, 350, 500, 400
imalesung1	ftgen 0, 0, 16, -2, 1950, 1810, 1500, 1490, 1200, 1000, 720, 640, 1200, 1150
imalesung2	ftgen 0, 0, 16, -2, 2750, 2500, 2500, 2250, 2600, 2600, 2500, 2550, 2675, 2500



	; Female Formants Spoken
ifemale0	ftgen 0, 0, 16, -2, 310, 430, 610, 860, 850, 590, 470, 370, 760, 500
ifemale1	ftgen 0, 0, 16, -2, 2790, 2480, 2330, 2050, 1220, 920, 1160, 950, 1400, 1640
ifemale2	ftgen 0, 0, 16, -2, 3310, 3070, 2990, 2850, 2810, 2710, 2680, 2670, 2780, 1960

	; Female Formants Sung
ifemalesung0	ftgen 0, 0, 16, -2, 400, 475, 550, 600, 700, 625, 425, 400, 550, 450
ifemalesung1	ftgen 0, 0, 16, -2, 2250, 2100, 1750, 1650, 1300, 1240, 900, 800, 1300, 1350
ifemalesung2	ftgen 0, 0, 16, -2, 3300, 3450, 3250, 3000, 3250, 3250, 3375, 3250, 3250, 3050



	; Child Formants Spoken
ichild0	ftgen 0, 0, 16, -2, 370, 530, 690, 1010, 1030, 680, 560, 430, 850, 560
ichild1	ftgen 0, 0, 16, -2, 3200, 2730, 2610, 2320, 1370, 1060, 1410, 1170, 1590, 1820
ichild2	ftgen 0, 0, 16, -2, 3730, 3600, 3570, 3320, 3170, 3180, 3310, 3260, 3360, 2160

; Formant Amplitudes
iformamp0	ftgen 0, 0, 16, -2, -4, -3, -2, -1, -1, -.001, -1, -3, -1, -5
iformamp1	ftgen 0, 0, 16, -2, -24, -23, -17, -12, -5, -7, -12, -19, -10, -15
iformamp2	ftgen 0, 0, 16, -2, -28, -27, -24, -22, -28, -34, -34, -43, -27, -20


itables		ftgen 0, 0, 16, -2, imale0, imale1, imale2, imalesung0, imalesung1, imalesung2, \
				    ifemale0, ifemale1, ifemale2, ifemalesung0, ifemalesung1, ifemalesung2, \
				    ichild0, ichild1, ichild2, 0
chnset itables, "tokbox.tables"

chnset iformamp0, "tokbox.formamp0"
chnset iformamp1, "tokbox.formamp1"
chnset iformamp2, "tokbox.formamp2"

endif

ibw = 8
kvoiceindex = kvoice * 3
iptime = .5

kfmtab1 tablekt kvoiceindex, itables
kfmtab2 tablekt kvoiceindex + 1, itables
kfmtab3 tablekt kvoiceindex + 2, itables
	
;kformi   oscil   1, 1/idur, ixtab        ; Read the formant index table

kform1   tablekt   kformi, kfmtab1         ; Read the first formant frequency
kdb1     table   kformi, iformamp0          ; Read the first formant dB's
kamp1    =       dbfsamp(kdb1)          ; Convert from decibels to amplitude
kform2   tablekt   kformi, kfmtab2         ; Read the second formant frequency
kdb2     table   kformi, iformamp1          ; Read the second formant dB's
kamp2    =       dbfsamp(kdb2)          ; Convert dB to amp
kform3   tablekt   kformi, kfmtab3         ; Read the third formant frequency
kdb3     table   kformi, iformamp2          ; Read the third formnat dB's
kamp3    =       dbfsamp(kdb3)          ; Convert dB to amp

kfrm1p   port    kform1, iptime, 300     ; Portamento to the next formant
kamp1p   port    kamp1,  iptime, .15     ; Portamento to the next amplitude
kfrm2p   port    kform2, iptime, 2000    ; Repeat for second
kamp2p   port    kamp2,  iptime, .15
kfrm3p   port    kform3, iptime, 4000    ; and again for the third
kamp3p   port    kamp3,  iptime, .15

;adist    =       tanh(ain/4000)*8000
adist = ain
aform1   butterbp adist, kfrm1p, kfrm1p/ibw  ; Compute the three resonances
aform2   butterbp adist, kfrm2p, kfrm2p/ibw
aform3   butterbp adist, kfrm3p, kfrm3p/ibw

aout     =       (aform1*kamp1p+aform2*kamp2p+aform3*kamp3p)/5  ; Scale and sum

xout aout

	endop
	opcode yi_max_delay,i,0

ipcount pcount

if(ipcount == 5) then ; MIDI Style Note
	ipch getFrequency p4 
	ipch2 = ipch 

else
	ipch getFrequency p4 
	ipch2 getFrequency p5
endif

imaxdel = (1/ipch > 1/ipch2) ? 1/ipch : 1/ipch2

xout imaxdel

	endop
	opcode mode2,a,aKKKKKo

ain, kfreq, kfreqmultiplier, kq, kampmultiplier, kqmultiplier, icounter xin

;kcurrentfreq = kfreq * (icounter + 1)

itie tival

aout mode ain, kfreq, kq, itie
;printk 1, kcurrentfreq
if (icounter < 128) then

kfreqnext = kfreq + (kfreq * kfreqmultiplier)

if (kfreqnext < (sr * .3) && icounter < 128) then

aout2 mode2 ain * kampmultiplier, kfreqnext, kfreqmultiplier, kq * kqmultiplier, kampmultiplier, kqmultiplier, icounter + 1
aout sum aout, aout2

endif

endif

xout aout



	endop
	opcode stickslip,a,K

kfreq xin

kdamp = 2 / sr 		; damping of model/srate
kmu_static = 5		; static friction coeff.
kmu_dynamic = 5 	; dynamic friction coeff.
kv_crit = 5		; critical velocity where static friction kicks in/srate
kqt1 = 0		; last state
kqt2 = 0		; last state
kv = 1 	/sr		; external slidevelocity in m/s / srate
kfn = 30	/sr		; external; normal force/srate
ktmp = 0
;
;    /** Set stick-slip model parameters (all in S.I. units).
;        @param k_damp damping of spring system
;        @param dummy not used
;        @param mu_static static friction coeff
;        @param mu_dynamic dynamic friction coeff
;        @param v_crit critical velocity for transition from dyn. to static friction
;    */
;;    public void setStickSlipParameters(float k_damp,float dummy,float mu_static,float mu_dynamic,float v_crit) {
;;        this.k_damp = k_damp/srate;
;;        this.mu_static = mu_static;
;;        this.mu_dynamic = mu_dynamic;
;;        this.v_crit = v_crit/srate;
;;    }
;    
;    /** Set normal force magnitude.
;        @param val normal force in Newton
;    */
;;    public void setNormalForce(float val) {
;;        fn = val/srate;
;;    }

    /** Set velocity.
        @param v velocity in m/s
    */
;    public void setSpeed(float v) {
;        this.v = v/srate;
;    }

aout = 0
kcounter = 0
kfactor = 1 - kdamp
loopStart:

ktmp = kv - kqt1 + kqt2
ksign = (ktmp >= 0) ? 1 : -1
if (abs(ktmp) > kv_crit) then
  kf_mu_sign = kfn * kmu_dynamic * ksign
else
  kf_mu_sign = kfn * kmu_static * ksign
endif

kval = kfactor * kqt1 * kf_mu_sign

vaset	 .3, kcounter, aout

kqt2 = kqt1
kqt1 = kval

;kcounter = kcounter + 1

loop_lt kcounter, 1, ksmps, loopStart
    
    /** Compute the next buffer.
        q(t+1) = (1-k_damp)q(t)+fn mu[(v - (q(t)-q(t-1)))] * sign(v - (q(t)-q(t-1))
     */
;    public void computeBuffer() {
;        float factor = (1-k_damp);
;        int bufsz = getBufferSize();
;        for(int k=0;k<bufsz;k++) {
;            float f_mu_sign;
;            float tmp = v - qt_1 + qt_2;
;            int signOf = (tmp >= 0 ? 1 : -1);
;            if((float)(Math.abs(tmp)) > v_crit) {
;                f_mu_sign = fn * mu_dynamic * signOf;
;            } else {
;                f_mu_sign = fn * mu_static * signOf;
;            }
;            buf[k] = factor * qt_1 + f_mu_sign;
;            qt_2 = qt_1;
;            qt_1 = buf[k];
;        }
;    }






xout aout


	endop
	opcode stk_bowtable,a,aKK


;offset default 0.0
;kslope default 0.1

ain, koffset, kslope xin

kndx = 0
aout = 0

loopStart:

ktemp vaget kndx, ain
ksample = ktemp + koffset
ksample = ksample * kslope
ksample = abs(ksample) + 0.75
ksample pow ksample, -4.0

if(ksample > 1.0) then
  ksample = 1.0
endif

vaset ksample, kndx, aout

loop_lt kndx, 1, ksmps, loopStart



xout aout

	endop
	opcode stk_bow,a,iK

setksmps 1

iamp, kfreq xin

ibetaratio = 0.127236

kslope = .5
koffset = 0.000

; Delay = length - approximate filter delay.
kbase_delay = (1000 / kfreq)  


if (kbase_delay <= 0.0) then
    kbase_delay = 0.3
endif

kbridge_delay = kbase_delay * ibetaratio
kneck_delay = kbase_delay * (1.0 - ibetaratio)

imax_vel = 0.03 + (0.2 * iamp)
aenv linsegr 0, .02, 1, .005, 0.9, .01, 0

abridge_delay init 0
aneck_delay init 0

abow_vel = aenv * imax_vel

astring_filter tone abridge_delay * .95, 1000
abridge_reflection = -astring_filter
anut_reflection = -aneck_delay

astring_velocity = abridge_reflection + anut_reflection
adeltav = abow_vel - astring_velocity
anew_vel_temp stk_bowtable adeltav, koffset, kslope
anew_vel = anew_vel_temp * adeltav
;anew_vel = adeltav

aneck_delay vdelay3 abridge_reflection + anew_vel, kneck_delay, 4095
abridge_delay vdelay3 anut_reflection + anew_vel, kbridge_delay, 4095

xout abridge_delay

	endop
	opcode multiOscil,a,KKK

kwaveform, kpch, kpulsewidth xin

aout = 0
kcount = 0

itie tival


if (kwaveform == 7) then
	aout 	noise 1, 0
	kcount = 1
endif

if (kwaveform == 0 || kwaveform == 3 || kwaveform == 4 || kwaveform == 6) then
	aout 	vco2 	1, kpch, (itie == 0 ? 12 : 1)

	kcount = 1
endif

if (kwaveform == 1 || kwaveform == 3 || kwaveform == 6) then
	atemp 	vco2 	1, kpch, itie
	aout = aout + atemp
	kcount = kcount + 1
endif

if (kwaveform == 2 || kwaveform == 4 || kwaveform == 5 || kwaveform == 6) then
	atemp 	vco2 	1, kpch, (itie == 0 ? 2 : 1), kpulsewidth
	aout = aout + atemp
	kcount = kcount + 1
endif

aout = aout / kcount

xout aout

	endop
	opcode simpleMultiFilter,a,aKKK

ain, ktype, kfreq, kbandwidth xin

ktypeAdj = ktype - 1

iskip 	tival 

if (ktypeAdj < 0) then
	aout = ain
elseif (ktypeAdj == 0) then
	aout butterlp ain, kfreq, iskip
elseif (ktypeAdj == 1) then
	aout butterhp ain, kfreq, iskip
elseif (ktypeAdj == 2) then
	aout butterbp ain, kfreq, kbandwidth, iskip
endif

xout aout

	endop
	opcode blueEffect0,aa,aa

ain1,ain2	xin
denorm	 ain1, ain2

aout1, aout2  reverbsc ain1, ain2, gk_blue_auto210, gk_blue_auto209

aout1 = (ain1 * gk_blue_auto211) + (aout1 * (1 - gk_blue_auto211))
aout2 = (ain2 * gk_blue_auto211) + (aout2 * (1 - gk_blue_auto211))


xout	aout1,aout2


	endop
	opcode blueEffect1,aa,aa

ain1,ain2	xin

aout1 dcblock ain1
aout2 dcblock ain2

xout	aout1,aout2


	endop


	instr 1	;Alpha v2
ipcount pcount
kpcount init ipcount

idur 	= abs(p3)
iskip 	tival

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen i(gk_blue_auto0), i(gk_blue_auto1), i(gk_blue_auto3), i(gk_blue_auto25), i(gk_blue_auto22), gk_blue_auto24 

iamprel = i(gk_blue_auto22)
ivcfrel = i(gk_blue_auto33)

iminrelease = (iamprel < ivcfrel) ? iamprel : ivcfrel


if (gk_blue_auto31 == 0) then
	kcutoff = 1
elseif (gk_blue_auto31 == 1 && kpcount == 5) then

	if (gk_blue_auto33 == 10) then
		kcutoff linseg 0, i(gk_blue_auto28), 1, i(gk_blue_auto29), i(gk_blue_auto34), iminrelease, i(gk_blue_auto34)
	else
		kcutoff linsegr 0, i(gk_blue_auto28), 1, i(gk_blue_auto29), i(gk_blue_auto34), iminrelease, 0
	endif
else
	kcutoff = kenv
endif

kcutoff logcurve kcutoff, 1.5

kcutoffMin = gk_blue_auto2 * (1 - gk_blue_auto30)
kcutoffRange = gk_blue_auto2 - kcutoffMin

kcutoff = kcutoffMin + (kcutoff * kcutoffRange)

if (gk_blue_auto10 != 0) then

klfo 	lfo2	gk_blue_auto8, gk_blue_auto10 - 1, iskip

kenv = kenv + (kenv * (klfo * gk_blue_auto12) * .25)
kpchline = kpchline * (1 + (klfo * gk_blue_auto9) * .0625)
kcutoff = kcutoff + (kcutoff * (klfo * gk_blue_auto13) * .25)

endif

iwaveform1	= (iskip == 0) ? i(gk_blue_auto37) * 2 : iskip
iwaveform2 	= (iskip == 0) ? i(gk_blue_auto38) * 2 : iskip
iwaveform3 	= (iskip == 0) ? i(gk_blue_auto39) * 2 : iskip

kamp1		= gk_blue_auto16
kamp2		= gk_blue_auto17
kamp3		= gk_blue_auto18
kampnoise	= gk_blue_auto14

kdetune1	= gk_blue_auto4 * kpchline
kdetune2	= gk_blue_auto5 * kpchline
kdetune3        = gk_blue_auto6 * kpchline

/* SOUND GENERATION CODE */
a1	vco2	1, kpchline + kdetune1, iwaveform1, gk_blue_auto19
a2	vco2	1, kpchline + kdetune2, iwaveform2, gk_blue_auto20
a3	vco2	1, kpchline + kdetune3, iwaveform3, gk_blue_auto21

if (gk_blue_auto15 == 0) then
	anoise 	noise	 1, 0
else
	anoise 	pinkish 1
endif

anoise  butterhp anoise, kpchline

aout	= (a1 * kamp1) + (a2 * kamp2) + (a3 * kamp3) + (anoise * kampnoise)

aout	= aout / (kamp1 + kamp2 + kamp3 + kampnoise)

aout	yiMultiLpf	aout, gk_blue_auto35,  kcutoff, gk_blue_auto23, gk_blue_auto7

aout	balance 	aout, a1, 10, iskip

;aout	dcblock aout

aout	= aout * kamp * kenv 

; PANNING

aLeft, aRight 	pan2 aout, kspace

ga_bluemix_1_0 = ga_bluemix_1_0 +  aLeft
ga_bluemix_1_1 = ga_bluemix_1_1 +  aRight

	endin

	instr 4	;Reson 6 - Orch
imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen 0, i(gk_blue_auto42), i(gk_blue_auto44), i(gk_blue_auto72), i(gk_blue_auto70), gk_blue_auto71 


;INSERT SOUND GENERATION CODE HERE

iskip 	tival

kQ    = gk_blue_auto43
imaxdel yi_max_delay


adel init 0

aexc1	vco2 1, kpchline, iskip
aexc = aexc1 + adel
;	anoise 	pinkish 1
;aexc = aexc1 + adel + anoise
;aexc = adel + anoise

aout = 0

if (gk_blue_auto58 == 1) then
	aout0 reson aexc * gk_blue_auto52, kpchline * gk_blue_auto46, kQ * gk_blue_auto64, 0, iskip
	aout sum aout, aout0
endif

if (gk_blue_auto59 == 1) then
	aout1 reson aexc  * gk_blue_auto53, kpchline * gk_blue_auto47, kQ * gk_blue_auto65, 0, iskip
	aout sum aout, aout1
endif

if (gk_blue_auto60 == 1) then
	aout2 reson aexc  * gk_blue_auto54, kpchline * gk_blue_auto48, kQ * gk_blue_auto66, 0, iskip
	aout sum aout, aout2
endif

if (gk_blue_auto61 == 1) then
	aout3 reson aexc  * gk_blue_auto55, kpchline * gk_blue_auto49, kQ * gk_blue_auto67, 0, iskip
	aout sum aout, aout3
endif

if (gk_blue_auto62 == 1) then
	aout4 reson aexc  * gk_blue_auto56, kpchline * gk_blue_auto50, kQ * gk_blue_auto68, 0, iskip
	aout sum aout, aout4
endif

if (gk_blue_auto63 == 1) then
	aout5 reson aexc  * gk_blue_auto57, kpchline * gk_blue_auto51, kQ * gk_blue_auto69, 0, iskip
	aout sum aout, aout5
endif

aout	balance aout, aexc1, 10, iskip

aout 	dcblock2	 aout, 128, iskip


adel vdelay3 aout * gk_blue_auto45, 1000/kpchline, imaxdel * 1000, iskip
adel = -adel

aout = aout * kenv * kamp


;END SOUND GENERATION CODE

aLeft, aRight 	pan2 aout, kspace

ga_bluemix_4_0 = ga_bluemix_4_0 +  aLeft
ga_bluemix_4_1 = ga_bluemix_4_1 +  aRight

	endin

	instr 5	;Re:Mode
ipcount pcount
kpcount init ipcount

idur 	= abs(p3)
iskip 	tival

kQ    = gk_blue_auto74

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen 0, i(gk_blue_auto73), i(gk_blue_auto75), i(gk_blue_auto82), i(gk_blue_auto80), gk_blue_auto81 


;ktmp linsegr 0, .1, 0, i(kQ) / ipch, 0

;afeedback init 0

;
;if (kpcount == 5) then
;
;kenv yi_envelope 0, i(gk_blue_auto73), i(gk_blue_auto75), i(gk_blue_auto82), i(gk_blue_auto80)
;
;else
;
;kenv yiEnvelope ienvType, i(gk_blue_auto73), i(gk_blue_auto75), i(gk_blue_auto82), i(gk_blue_auto80)
;;kenv yiEnvelope ienvType, .05, .05, .95, .1
;
;endif

imaxdel yi_max_delay

;INSERT SOUND GENERATION CODE HERE

adel init 0

;aexc1	vco2 kenv* .001, kpchline
;anoise 	pinkish 1
;anoise butterlp anoise, 8000
;knoiseenv linsegr 0, .005, iamp * .05, .1, 0
;aexc = knoiseenv * anoise ;+ adel ;+ aexc1

;aexc = aexc1 + adel + anoise
;aexc = adel + anoise


;inummodes = <modeOn0> + <modeOn1> + <modeOn2> + <modeOn3> + <modeOn4> + <modeOn5>

;aexc2 	mpulse 1 / inummodes, 0

aexc 	mpulse 1, 0

;aexc = aexc + afeedback

;aexc stk_bow iamp *.7, kpchline

;aexc2   stickslip kpchline
;aexc = aexc2 ;+ aexc

;aexc =  aexc2 + aexc ;+ adel ;+ aexc + adel
;aexc = aexc2 + adel ;+ aexc1

;aexc wgbow .05, kpchline, 3, 0.127236, 0, 0, gi_sine


;aout = 0

kfreqmultiplier = gk_blue_auto77

aout mode2 aexc, kpchline, kfreqmultiplier, kQ, gk_blue_auto78, gk_blue_auto79

;aout = aout 

aout 	dcblock2	 aout,128, iskip


;adel vdelay3 aout * gk_blue_auto76, 1000/kpchline, imaxdel * 1000
;adel = -adel

aout = aout * kamp ;* kenv

;afeedback vdelay3 aout * .00025, 1000/kpchline, 4000

aout limit aout, -.5, .5

;END SOUND GENERATION CODE

aLeft, aRight 	pan2 aout, kspace

ga_bluemix_5_0 = ga_bluemix_5_0 +  aLeft
ga_bluemix_5_1 = ga_bluemix_5_1 +  aRight

	endin

	instr 7	;French Horn (Horner and Ayers)
ipcount pcount
kpcount init ipcount

idur 	= abs(p3)
iskip 	tival 
itie 	tie_status
ktie	init itie

ipch 	getFrequency p4


iHornType = i(gk_blue_auto85)

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen 0, i(gk_blue_auto83), i(gk_blue_auto84), i(gk_blue_auto88), i(gk_blue_auto86), gk_blue_auto87 


; INSERT SOUND GENERATING CODE HERE 

ifcut	= 2560		; LP FILTER CUTOFF FREQUENCY


kenv2	=		kenv * kenv 			; WAVETABLE ENVELOPES
kenv3	=		kenv2 * kenv
kenv4	=		kenv3 * kenv

if(iskip == 0) then

if (iHornType == 1) then
	irange	table	ipch, gi_horn_stop_wt
else
	irange	table	ipch, gi_horn_wt
endif

istartIndex = irange * 4

iwt1	=	gi_sine					; WAVETABLE NUMBERS
iwt2	table	istartIndex, gi_horn_instrwt
iwt3	table	istartIndex+1, gi_horn_instrwt
iwt4	table	istartIndex+2, gi_horn_instrwt
inorm	table	istartIndex+3, gi_horn_instrwt		; NORMALIZATION FACTOR

endif

iiwt1 			=			iwt1
iiwt2 			=			iwt2
iiwt3 			=			iwt3
iiwt4 			=			iwt4

iphase	= (iskip == 1) ? -1 : gi_horn_seed				; SAME PHASE FOR ALL TABLES
giseed	= frac(gi_horn_seed*105.947)


awt1	oscil3	kenv, kpchline, iiwt1, iphase ; WAVETABLE LOOKUP
awt2	oscil3	kenv2, kpchline, iiwt2, iphase
awt3	oscil3	kenv3, kpchline, iiwt3, iphase
awt4	oscil3	kenv4, kpchline, iiwt4, iphase
aout	=		(awt1+awt2+awt3+awt4)*kamp/inorm

afilt	tone	aout, ifcut, iskip			; LP FILTER...
asig	balance	afilt, aout, 10, iskip			; ... TO CONTROL BRIGHTNESS


if (gk_blue_auto85 == 2) then
	afilt     atone   asig, 1200, iskip                                ; insert a high-pass filter to
	asig      balance afilt, .5 * asig, 10, iskip                           ; simulate horn straight mute
endif

aport	oscil3	1, .05, gi_sine, iskip * -1
aport	=	(aport * 0.02) + 1
aout	=	asig * aport
;aout = asig	


;aout 	dcblock2	 aout, 128, iskip	

;aout limit aout, -.5, .5


;END SOUND GENERATION CODE

aLeft, aRight 	pan2 aout, kspace

ga_bluemix_7_0 = ga_bluemix_7_0 +  aLeft
ga_bluemix_7_1 = ga_bluemix_7_1 +  aRight

	endin

	instr 8	;b64 v2

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen 0, i(gk_blue_auto92), i(gk_blue_auto93), i(gk_blue_auto114), i(gk_blue_auto109), gk_blue_auto113 


; SOUND GENERATION CODE

aout1 	multiOscil gk_blue_auto115, kpchline * gk_blue_auto103, gk_blue_auto106
aout2 	multiOscil gk_blue_auto116, kpchline * gk_blue_auto104, gk_blue_auto107
aout3 	multiOscil gk_blue_auto117, kpchline * gk_blue_auto105, gk_blue_auto108

aout1 	simpleMultiFilter	aout1 * gk_blue_auto89, gk_blue_auto100, gk_blue_auto97, gk_blue_auto94
aout2 	simpleMultiFilter	aout2 * gk_blue_auto90, gk_blue_auto101, gk_blue_auto98, gk_blue_auto95
aout3 	simpleMultiFilter	aout3 * gk_blue_auto91, gk_blue_auto102, gk_blue_auto99, gk_blue_auto96

aout = 0

if (gk_blue_auto110 == 1) then
	atemp = aout1 * aout3
	aout = atemp
else
	aout = aout1
endif

if (gk_blue_auto111 == 1) then
	atemp = aout2 * aout1
	aout = aout + atemp
else
	aout = aout + aout2
endif


if (gk_blue_auto112 == 1) then
	atemp = aout3 * aout2
	aout = aout + atemp
else
	aout = aout + aout3
endif

aout	dcblock aout

aout = aout * kamp * kenv / (gk_blue_auto89 + gk_blue_auto90 + gk_blue_auto91)

; END SOUND GENERATION CODE

aLeft, aRight	pan2	aout, kspace

ga_bluemix_8_0 = ga_bluemix_8_0 +  aout
ga_bluemix_8_1 = ga_bluemix_8_1 +  aout

	endin

	instr 9	;Alpha v2
ipcount pcount
kpcount init ipcount
;
idur 	= abs(p3)
iskip 	tival

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen i(gk_blue_auto118), i(gk_blue_auto119), i(gk_blue_auto121), i(gk_blue_auto142), i(gk_blue_auto139), gk_blue_auto141 

iamprel = i(gk_blue_auto139)
ivcfrel = i(gk_blue_auto149)

iminrelease = (iamprel < ivcfrel) ? iamprel : ivcfrel


if (gk_blue_auto148 == 0) then
	kcutoff = 1
elseif (gk_blue_auto148 == 1 && kpcount == 5) then

	if (gk_blue_auto149 == 10) then
		kcutoff linseg 0, i(gk_blue_auto145), 1, i(gk_blue_auto146), i(gk_blue_auto150), iminrelease, i(gk_blue_auto150)
	else
		kcutoff linsegr 0, i(gk_blue_auto145), 1, i(gk_blue_auto146), i(gk_blue_auto150), iminrelease, 0
	endif
else
	kcutoff = kenv
endif

kcutoff logcurve kcutoff, 1.5

kcutoffMin = gk_blue_auto120 * (1 - gk_blue_auto147)
kcutoffRange = gk_blue_auto120 - kcutoffMin

kcutoff = kcutoffMin + (kcutoff * kcutoffRange)

if (gk_blue_auto128 != 0) then

klfo 	lfo2	gk_blue_auto126, gk_blue_auto128 - 1, iskip

kenv = kenv + (kenv * (klfo * gk_blue_auto129) * .25)
kpchline = kpchline * (1 + (klfo * gk_blue_auto127) * .0625)
kcutoff = kcutoff + (kcutoff * (klfo * gk_blue_auto130) * .25)

endif

iwaveform1	= (iskip == 0) ? i(gk_blue_auto153) * 2 : iskip
iwaveform2 	= (iskip == 0) ? i(gk_blue_auto154) * 2 : iskip
iwaveform3 	= (iskip == 0) ? i(gk_blue_auto155) * 2 : iskip

kamp1		= gk_blue_auto133
kamp2		= gk_blue_auto134
kamp3		= gk_blue_auto135
kampnoise	= gk_blue_auto131

kdetune1	= gk_blue_auto122 * kpchline
kdetune2	= gk_blue_auto123 * kpchline
kdetune3        = gk_blue_auto124 * kpchline

/* SOUND GENERATION CODE */
a1	vco2	1, kpchline + kdetune1, iwaveform1, gk_blue_auto136
a2	vco2	1, kpchline + kdetune2, iwaveform2, gk_blue_auto137
a3	vco2	1, kpchline + kdetune3, iwaveform3, gk_blue_auto138

if (gk_blue_auto132 == 0) then
	anoise 	noise	 1, 0
else
	anoise 	pinkish 1
endif

anoise  butterhp anoise, kpchline

aout	= (a1 * kamp1) + (a2 * kamp2) + (a3 * kamp3) + (anoise * kampnoise)

aout	= aout / (kamp1 + kamp2 + kamp3 + kampnoise)

aout	yiMultiLpf	aout, gk_blue_auto151,  kcutoff, gk_blue_auto140, gk_blue_auto125

aout	balance 	aout, a1, 10, iskip

;aout	dcblock aout

aout	= aout * kamp * kenv 

; PANNING

aLeft, aRight 	pan2 aout, kspace

ga_bluemix_9_0 = ga_bluemix_9_0 +  aLeft
ga_bluemix_9_1 = ga_bluemix_9_1 +  aRight

	endin

	instr 10	;Alpha v2
ipcount pcount
kpcount init ipcount
;
idur 	= abs(p3)
iskip 	tival

imaxpfield = p8 // dummy statement to get Csound to assume up to max pfields of 8
kpchline, kamp, kenv, kspace yi_instr_gen i(gk_blue_auto157), i(gk_blue_auto158), i(gk_blue_auto160), i(gk_blue_auto181), i(gk_blue_auto178), gk_blue_auto180 

iamprel = i(gk_blue_auto178)
ivcfrel = i(gk_blue_auto188)

iminrelease = (iamprel < ivcfrel) ? iamprel : ivcfrel


if (gk_blue_auto187 == 0) then
	kcutoff = 1
elseif (gk_blue_auto187 == 1 && kpcount == 5) then

	if (gk_blue_auto188 == 10) then
		kcutoff linseg 0, i(gk_blue_auto184), 1, i(gk_blue_auto185), i(gk_blue_auto189), iminrelease, i(gk_blue_auto189)
	else
		kcutoff linsegr 0, i(gk_blue_auto184), 1, i(gk_blue_auto185), i(gk_blue_auto189), iminrelease, 0
	endif
else
	kcutoff = kenv
endif

kcutoff logcurve kcutoff, 1.5

kcutoffMin = gk_blue_auto159 * (1 - gk_blue_auto186)
kcutoffRange = gk_blue_auto159 - kcutoffMin

kcutoff = kcutoffMin + (kcutoff * kcutoffRange)

if (gk_blue_auto167 != 0) then

klfo 	lfo2	gk_blue_auto165, gk_blue_auto167 - 1, iskip

kenv = kenv + (kenv * (klfo * gk_blue_auto168) * .25)
kpchline = kpchline * (1 + (klfo * gk_blue_auto166) * .0625)
kcutoff = kcutoff + (kcutoff * (klfo * gk_blue_auto169) * .25)

endif

iwaveform1	= (iskip == 0) ? i(gk_blue_auto192) * 2 : iskip
iwaveform2 	= (iskip == 0) ? i(gk_blue_auto193) * 2 : iskip
iwaveform3 	= (iskip == 0) ? i(gk_blue_auto194) * 2 : iskip

kamp1		= gk_blue_auto172
kamp2		= gk_blue_auto173
kamp3		= gk_blue_auto174
kampnoise	= gk_blue_auto170

kdetune1	= gk_blue_auto161 * kpchline
kdetune2	= gk_blue_auto162 * kpchline
kdetune3        = gk_blue_auto163 * kpchline

/* SOUND GENERATION CODE */
a1	vco2	1, kpchline + kdetune1, iwaveform1, gk_blue_auto175
a2	vco2	1, kpchline + kdetune2, iwaveform2, gk_blue_auto176
a3	vco2	1, kpchline + kdetune3, iwaveform3, gk_blue_auto177

if (gk_blue_auto171 == 0) then
	anoise 	noise	 1, 0
else
	anoise 	pinkish 1
endif

anoise  butterhp anoise, kpchline

aout	= (a1 * kamp1) + (a2 * kamp2) + (a3 * kamp3) + (anoise * kampnoise)

aout	= aout / (kamp1 + kamp2 + kamp3 + kampnoise)

aout	yiMultiLpf	aout, gk_blue_auto190,  kcutoff, gk_blue_auto179, gk_blue_auto164

aout	balance 	aout, a1, 10, iskip

;aout	dcblock aout

aout	= aout * kamp * kenv 

; PANNING

aLeft, aRight 	pan2 aout, kspace

ga_bluemix_10_0 = ga_bluemix_10_0 +  aLeft
ga_bluemix_10_1 = ga_bluemix_10_1 +  aRight

	endin

	instr 11	;untitled
aLeft = ga_bluemix_1_0
 aRight = ga_bluemix_1_1

;aout	moogladder		aout, gk_blue_auto2, gk_blue_auto23


if (gk_blue_auto26 == 1) then
    aLeft tokbox aLeft, gk_blue_auto36, gk_blue_auto27
    aRight tokbox aRight, gk_blue_auto36, gk_blue_auto27
endif


; CHORUS

;if (<chorusEnabled> == 1) then
	aLeft, aRight 	chorus aLeft, aRight, gk_blue_auto41
;endif

aLeft dcblock aLeft
aRight dcblock aRight


; OUTPUT

ga_bluemix_1_0 =  aLeft
ga_bluemix_1_1 =  aRight

	endin

	instr 12	;untitled
aLeft = ga_bluemix_9_0
 aRight = ga_bluemix_9_1

;aout	moogladder		aout, gk_blue_auto120, gk_blue_auto140


if (gk_blue_auto143 == 1) then
    aLeft tokbox aLeft, gk_blue_auto152, gk_blue_auto144
    aRight tokbox aRight, gk_blue_auto152, gk_blue_auto144
endif


; CHORUS

;if (<chorusEnabled> == 1) then
	aLeft, aRight 	chorus aLeft, aRight, gk_blue_auto156
;endif

aLeft dcblock aLeft
aRight dcblock aRight


; OUTPUT

ga_bluemix_9_0 =  aLeft
ga_bluemix_9_1 =  aRight

	endin

	instr 13	;untitled
aLeft = ga_bluemix_10_0
 aRight = ga_bluemix_10_1

;aout	moogladder		aout, gk_blue_auto159, gk_blue_auto179


if (gk_blue_auto182 == 1) then
    aLeft tokbox aLeft, gk_blue_auto191, gk_blue_auto183
    aRight tokbox aRight, gk_blue_auto191, gk_blue_auto183
endif


; CHORUS

;if (<chorusEnabled> == 1) then
	aLeft, aRight 	chorus aLeft, aRight, gk_blue_auto195
;endif

aLeft dcblock aLeft
aRight dcblock aRight


; OUTPUT

ga_bluemix_10_0 =  aLeft
ga_bluemix_10_1 =  aRight

	endin

	instr 14	;Blue Mixer Instrument
ktempdb = ampdb(gk_blue_auto199)
ga_bluemix_1_0 = ga_bluemix_1_0 * ktempdb
ga_bluemix_1_1 = ga_bluemix_1_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_1_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_1_1
ktempdb = ampdb(gk_blue_auto202)
ga_bluemix_4_0 = ga_bluemix_4_0 * ktempdb
ga_bluemix_4_1 = ga_bluemix_4_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_4_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_4_1
ktempdb = ampdb(gk_blue_auto203)
ga_bluemix_5_0 = ga_bluemix_5_0 * ktempdb
ga_bluemix_5_1 = ga_bluemix_5_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_5_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_5_1
ktempdb = ampdb(gk_blue_auto205)
ga_bluemix_7_0 = ga_bluemix_7_0 * ktempdb
ga_bluemix_7_1 = ga_bluemix_7_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_7_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_7_1
ktempdb = ampdb(gk_blue_auto206)
ga_bluemix_8_0 = ga_bluemix_8_0 * ktempdb
ga_bluemix_8_1 = ga_bluemix_8_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_8_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_8_1
ktempdb = ampdb(gk_blue_auto207)
ga_bluemix_9_0 = ga_bluemix_9_0 * ktempdb
ga_bluemix_9_1 = ga_bluemix_9_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_9_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_9_1
ktempdb = ampdb(gk_blue_auto208)
ga_bluemix_10_0 = ga_bluemix_10_0 * ktempdb
ga_bluemix_10_1 = ga_bluemix_10_1 * ktempdb
ga_bluesub_Master_0	sum	ga_bluesub_Master_0, ga_bluemix_10_0
ga_bluesub_Master_1	sum	ga_bluesub_Master_1, ga_bluemix_10_1
ga_bluesub_Master_0, ga_bluesub_Master_1	blueEffect0	ga_bluesub_Master_0, ga_bluesub_Master_1
ga_bluesub_Master_0, ga_bluesub_Master_1	blueEffect1	ga_bluesub_Master_0, ga_bluesub_Master_1
ktempdb = ampdb(gk_blue_auto212)
ga_bluesub_Master_0 = ga_bluesub_Master_0 * ktempdb
ga_bluesub_Master_1 = ga_bluesub_Master_1 * ktempdb
outc ga_bluesub_Master_0, ga_bluesub_Master_1
ga_bluemix_1_0 = 0
ga_bluemix_1_1 = 0
ga_bluemix_4_0 = 0
ga_bluemix_4_1 = 0
ga_bluemix_5_0 = 0
ga_bluemix_5_1 = 0
ga_bluemix_7_0 = 0
ga_bluemix_7_1 = 0
ga_bluemix_8_0 = 0
ga_bluemix_8_1 = 0
ga_bluemix_9_0 = 0
ga_bluemix_9_1 = 0
ga_bluemix_10_0 = 0
ga_bluemix_10_1 = 0
ga_bluesub_Master_0 = 0
ga_bluesub_Master_1 = 0

	endin


</CsInstruments>

<CsScore>




 







i9.00	117.626465	1.2149461508	9.06	9.06	-13.0	0.4	0
i9.00	118.84272	1.2107254267	9.08	9.08	-13.0	0.4	0
i9.00	120.058975	1.2071806192	9.1	9.1	-13.0	0.4	0
i9.00	121.27523	12.1547660828	10.0	10.0	-13.0	0.4	0
i9.00	137.7736	1.0276173353	10.0	10.0	-16.0	0.4	0
i9.00	138.8036	1.0229016542	10.02	10.02	-16.0	0.4	0
i9.00	139.83359	1.0212757587	10.04	10.04	-16.0	0.4	0
i9.00	140.86359	4.1160516739	10.06	10.06	-16.0	0.4	0
i9.00	147.3208	1.40523839	9.04	9.04	-18.0	0.4	0
i9.00	148.72887	1.4029428959	9.06	9.06	-18.0	0.4	0
i9.00	150.13695	1.4042037725	9.08	9.08	-18.0	0.4	0
i9.00	151.54503	5.6267957687	9.1	9.1	-18.0	0.4	0
i9.00	159.58221	1.0446186066	9.08	9.08	-18.0	0.4	0
i9.00	160.63379	4.1995358467	9.1	9.1	-18.0	0.4	0
i9.00	115.14037	0.9355968237	9.02	9.02	-15.0	0.5	0
i9.00	116.07815	0.9283931255	9.04	9.04	-15.0	0.5	0
i9.00	117.01593	0.9280147552	9.06	9.06	-15.0	0.5	0
i9.00	117.953705	5.6199259758	9.08	9.08	-15.0	0.5	0
i9.00	127.61527	1.494582057	10.01	10.01	-17.0	0.5	0
i9.00	129.11195	8.9782180786	10.03	10.03	-17.0	0.5	0
i9.00	142.59872	0.696944356	10.01	10.01	-17.0	0.5	0
i9.00	143.29942	0.6964718103	10.03	10.03	-17.0	0.5	0
i9.00	144.00012	0.6999985576	10.05	10.05	-17.0	0.5	0
i9.00	144.70082	0.6912061572	10.07	10.07	-17.0	0.5	0
i9.00	145.40152	2.7936081886	10.09	10.09	-17.0	0.5	0
i9.00	152.31207	0.7477706671	9.1	9.1	-18.0	0.5	0
i9.00	153.06514	7.5280642509	10.0	10.0	-18.0	0.5	0
i9.00	115.33708	0.7009580731	9.08	9.08	-15.0	0.6	0
i9.00	116.04423	0.7047533393	9.1	9.1	-15.0	0.6	0
i9.00	116.75137	0.7017692924	10.0	10.0	-15.0	0.6	0
i9.00	117.45852	0.6986297965	10.02	10.02	-15.0	0.6	0
i9.00	118.16566	4.2406864166	10.04	10.04	-15.0	0.6	0
i9.00	124.915375	1.2495298386	9.02	9.02	-18.0	0.6	0
i9.00	126.166275	4.9968061447	9.04	9.04	-18.0	0.6	0
i9.00	134.03188	0.7875052094	9.1	9.1	-17.0	0.6	0
i9.00	134.81982	0.7869405746	10.0	10.0	-17.0	0.6	0
i9.00	135.60779	0.78589046	10.02	10.02	-17.0	0.6	0
i9.00	136.39575	0.7853080034	10.04	10.04	-17.0	0.6	0
i9.00	137.18372	4.7230186462	10.06	10.06	-17.0	0.6	0
i9.00	146.4935	0.7510792613	10.03	10.03	-17.0	0.6	0
i9.00	147.24983	4.5341506004	10.05	10.05	-17.0	0.6	0
i9.00	155.94345	1.1563794613	9.1	9.1	-17.0	0.6	0
i9.00	157.10345	4.6319665909	10.0	10.0	-17.0	0.6	0
i9.00	230.83339	50.5	9.09	9.09	-24.0	0.4	1
i9.00	230.83339	50.4610137939	9.11	9.11	-24.0	0.5	1
i9.00	230.83339	50.1384849548	10.01	10.01	-24.0	0.6	1
i9.00	282.1666	0.0510768555	9.07	9.07	-18.1396328858	0.4	0
i9.00	282.26874	0.0510768555	9.07	9.07	-18.1396328858	0.4	0
i9.00	282.3709	0.0510768555	9.07	9.07	-18.1396328858	0.4	0
i9.00	287.3213	0.0518867411	9.07	9.07	-17.5612606497	0.4	0
i9.00	287.42508	0.0518867411	9.07	9.07	-17.5612606497	0.4	0
i9.00	287.52884	0.0518867411	9.07	9.07	-17.5612606497	0.4	0
i9.00	292.44904	0.0513439588	9.07	9.07	-18.3428100643	0.4	0
i9.00	292.55173	0.0513439588	9.07	9.07	-18.3428100643	0.4	0
i9.00	292.65442	0.0513439588	9.07	9.07	-18.3428100643	0.4	0
i9.00	297.92432	0.0525028631	9.07	9.07	-17.4948175799	0.4	0
i9.00	298.0293	0.0525028631	9.07	9.07	-17.4948175799	0.4	0
i9.00	298.1343	0.0525028631	9.07	9.07	-17.4948175799	0.4	0
i9.00	303.365	0.052699659	9.07	9.07	-17.3948823606	0.4	0
i9.00	303.4704	0.052699659	9.07	9.07	-17.3948823606	0.4	0
i9.00	303.5758	0.052699659	9.07	9.07	-17.3948823606	0.4	0
i9.00	308.99557	0.0531529374	9.07	9.07	-18.2352297682	0.4	0
i9.00	309.1019	0.0531529374	9.07	9.07	-18.2352297682	0.4	0
i9.00	309.2082	0.0531529374	9.07	9.07	-18.2352297682	0.4	0
i9.00	314.23007	0.0527243502	9.07	9.07	-17.5823213747	0.4	0
i9.00	314.3355	0.0527243502	9.07	9.07	-17.5823213747	0.4	0
i9.00	314.44098	0.0527243502	9.07	9.07	-17.5823213747	0.4	0
i9.00	321.05203	0.0547155216	9.07	9.07	-17.4226776825	0.4	0
i9.00	321.16144	0.0547155216	9.07	9.07	-17.4226776825	0.4	0
i9.00	321.27087	0.0547155216	9.07	9.07	-17.4226776825	0.4	0
i9.00	325.6244	0.0531849973	9.07	9.07	-18.1384831999	0.4	0
i9.00	325.73074	0.0531849973	9.07	9.07	-18.1384831999	0.4	0
i9.00	325.83713	0.0531849973	9.07	9.07	-18.1384831999	0.4	0
i9.00	328.4154	0.0502403043	9.07	9.07	-17.6769397733	0.4	0
i9.00	328.51587	0.0502403043	9.07	9.07	-17.6769397733	0.4	0
i9.00	328.61636	0.0502403043	9.07	9.07	-17.6769397733	0.4	0
i9.00	344.08566	1.013132453	11.0	11.0	-13.0	0.4	0
i9.00	345.1065	1.0142920017	10.1	10.1	-13.0	0.4	0
i9.00	346.12735	1.0129060745	10.08	10.08	-13.0	0.4	0
i9.00	347.14816	10.2009458542	10.06	10.06	-13.0	0.4	0
i9.00	359.18948	1.0669660568	10.06	10.06	-18.0	0.4	0
i9.00	360.25925	1.0633404255	10.04	10.04	-18.0	0.4	0
i9.00	361.32904	1.0683711767	10.02	10.02	-18.0	0.4	0
i9.00	362.3988	1.0643161535	10.0	10.0	-18.0	0.4	0
i9.00	363.46857	1.0613783598	9.1	9.1	-18.0	0.4	0
i9.00	364.53833	4.2780966759	9.08	9.08	-18.0	0.4	0
i9.00	371.75076	1.3571867943	10.04	10.04	-16.0	0.4	0
i9.00	373.11206	1.3539770842	10.02	10.02	-16.0	0.4	0
i9.00	374.47336	1.3540494442	10.0	10.0	-16.0	0.4	0
i9.00	375.83466	1.3576174974	9.1	9.1	-16.0	0.4	0
i9.00	377.19595	1.3565969467	9.08	9.08	-16.0	0.4	0
i9.00	378.55725	5.4371156693	9.06	9.06	-16.0	0.4	0
i9.00	386.25937	0.8358668089	10.11	10.11	-17.0	0.4	0
i9.00	387.1031	0.8436030746	10.09	10.09	-17.0	0.4	0
i9.00	387.94678	0.836730063	10.07	10.07	-17.0	0.4	0
i9.00	388.79047	0.8356844783	10.05	10.05	-17.0	0.4	0
i9.00	389.63416	3.3657808304	10.03	10.03	-17.0	0.4	0
i9.00	343.3121	1.0625946522	10.02	10.02	-13.0	0.5	0
i9.00	344.3789	1.0598931313	10.0	10.0	-13.0	0.5	0
i9.00	345.4457	1.0606002808	9.1	9.1	-13.0	0.5	0
i9.00	346.5125	1.0617426634	9.08	9.08	-13.0	0.5	0
i9.00	347.57928	6.3933887482	9.06	9.06	-13.0	0.5	0
i9.00	355.9405	1.0643212795	11.01	11.01	-16.0	0.5	0
i9.00	357.01312	1.0683813095	10.11	10.11	-16.0	0.5	0
i9.00	358.08575	1.0655367374	10.09	10.09	-16.0	0.5	0
i9.00	359.15836	10.7247409821	10.07	10.07	-16.0	0.5	0
i9.00	373.56638	1.3378596306	10.02	10.02	-16.0	0.5	0
i9.00	374.909	1.3348479271	10.0	10.0	-16.0	0.5	0
i9.00	376.2516	1.336979866	9.1	9.1	-16.0	0.5	0
i9.00	377.5942	8.0493469238	9.08	9.08	-16.0	0.5	0
i9.00	345.2229	1.1627506018	10.07	10.07	-14.0	0.6	0
i9.00	346.39133	1.163505435	10.05	10.05	-14.0	0.6	0
i9.00	347.55975	1.1599884033	10.03	10.03	-14.0	0.6	0
i9.00	348.72818	4.6724796295	10.01	10.01	-14.0	0.6	0
i9.00	357.51306	1.0732376575	10.01	10.01	-17.0	0.6	0
i9.00	358.588	4.2924580574	9.11	9.11	-17.0	0.6	0
i9.00	366.34317	1.1904476881	10.05	10.05	-17.0	0.6	0
i9.00	367.53738	1.1936831474	10.03	10.03	-17.0	0.6	0
i9.00	368.73157	1.1936036348	10.01	10.01	-17.0	0.6	0
i9.00	369.92575	1.1851727962	9.11	9.11	-17.0	0.6	0
i9.00	371.11993	4.7686004639	9.09	9.09	-17.0	0.6	0
i9.00	378.32642	0.9723891616	10.07	10.07	-16.0	0.6	0
i9.00	379.3003	0.9684365988	10.05	10.05	-16.0	0.6	0
i9.00	380.2742	0.9655044675	10.03	10.03	-16.0	0.6	0
i9.00	381.24808	0.9711332321	10.01	10.01	-16.0	0.6	0
i9.00	382.22195	0.9727026224	9.11	9.11	-16.0	0.6	0
i9.00	383.19586	3.8865585327	9.09	9.09	-16.0	0.6	0
i8.01	51.33334	0.2496397942	10.04	10.04	-11.9694344744	-0.2	0
i8.01	51.58298	0.0998559147	10.03	10.03	-11.9694344744	-0.2	0
i8.01	55.67707	0.2496397942	10.03	10.03	-11.9694344744	-0.2	0
i8.01	55.926712	0.0998559147	10.04	10.04	-11.9694344744	-0.2	0
i8.01	56.560734	0.2446796298	10.04	10.04	-12.0117511421	-0.2	0
i8.01	56.805416	0.0978718475	10.03	10.03	-12.0117511421	-0.2	0
i8.01	60.81816	0.2446796298	10.03	10.03	-12.0117511421	-0.2	0
i8.01	61.06284	0.0978718475	10.04	10.04	-12.0117511421	-0.2	0
i8.01	62.023556	0.2526999116	10.04	10.04	-11.3069146219	-0.2	0
i8.01	62.276253	0.1010799557	10.03	10.03	-11.3069146219	-0.2	0
i8.01	66.42053	0.2526999116	10.03	10.03	-11.3069146219	-0.2	0
i8.01	66.67323	0.1010799557	10.04	10.04	-11.3069146219	-0.2	0
i8.01	67.49661	0.2528271079	10.04	10.04	-12.0127695377	-0.2	0
i8.01	67.749435	0.1011308357	10.03	10.03	-12.0127695377	-0.2	0
i8.01	71.8958	0.2528271079	10.03	10.03	-12.0127695377	-0.2	0
i8.01	72.14863	0.1011308357	10.04	10.04	-12.0127695377	-0.2	0
i8.01	72.90361	0.2520859241	10.04	10.04	-11.5321323776	-0.2	0
i8.01	73.1557	0.1008343697	10.03	10.03	-11.5321323776	-0.2	0
i8.01	77.2899	0.2520859241	10.03	10.03	-11.5321323776	-0.2	0
i8.01	77.54199	0.1008343697	10.04	10.04	-11.5321323776	-0.2	0
i8.01	77.96017	0.2485219985	10.04	10.04	-11.5294612769	-0.2	0
i8.01	78.208694	0.0994088054	10.03	10.03	-11.5294612769	-0.2	0
i8.01	82.284454	0.2485219985	10.03	10.03	-11.5294612769	-0.2	0
i8.01	82.532974	0.0994088054	10.04	10.04	-11.5294612769	-0.2	0
i8.01	84.7816	0.2604816258	10.04	10.04	-12.0949559878	-0.2	0
i8.01	85.04208	0.1041926444	10.03	10.03	-12.0949559878	-0.2	0
i8.01	89.31398	0.2604816258	10.03	10.03	-12.0949559878	-0.2	0
i8.01	89.57446	0.1041926444	10.04	10.04	-12.0949559878	-0.2	0
i8.01	88.82028	0.2487497777	10.04	10.04	-11.6358894195	-0.2	0
i8.01	89.06903	0.0994999185	10.03	10.03	-11.6358894195	-0.2	0
i8.01	93.14853	0.2487497777	10.03	10.03	-11.6358894195	-0.2	0
i8.01	93.39728	0.0994999185	10.04	10.04	-11.6358894195	-0.2	0
i8.01	92.34964	0.2384814471	10.04	10.04	-11.6843936435	-0.2	0
i8.01	92.58812	0.0953925774	10.03	10.03	-11.6843936435	-0.2	0
i8.01	96.49922	0.2384814471	10.03	10.03	-11.6843936435	-0.2	0
i8.01	96.7377	0.0953925774	10.04	10.04	-11.6843936435	-0.2	0
i8.01	99.31185	0.2493701279	10.04	10.04	-11.5990838062	-0.2	0
i8.01	99.56122	0.0997480527	10.03	10.03	-11.5990838062	-0.2	0
i8.01	103.650894	0.2493701279	10.03	10.03	-11.5990838062	-0.2	0
i8.01	103.90026	0.0997480527	10.04	10.04	-11.5990838062	-0.2	0
i8.01	123.999985	0.043569304	10.07	10.07	-11.6636524588	-0.2	0
i8.01	124.08712	0.043569304	10.08	10.08	-11.6636524588	-0.2	0
i8.01	129.66696	0.0450257361	10.07	10.07	-11.5585402013	-0.2	0
i8.01	129.75702	0.0450257361	10.08	10.08	-11.5585402013	-0.2	0
i8.01	135.27373	0.0440502614	10.07	10.07	-11.480164425	-0.2	0
i8.01	135.36182	0.0440502614	10.08	10.08	-11.480164425	-0.2	0
i8.01	141.53304	0.0457567908	10.07	10.07	-11.2493638156	-0.2	0
i8.01	141.62454	0.0457567908	10.08	10.08	-11.2493638156	-0.2	0
i8.01	147.40216	0.0454094447	10.07	10.07	-11.1392116973	-0.2	0
i8.01	147.49298	0.0454094447	10.08	10.08	-11.1392116973	-0.2	0
i8.01	152.56757	0.0441856347	10.07	10.07	-12.3052108601	-0.2	0
i8.01	152.65594	0.0441856347	10.08	10.08	-12.3052108601	-0.2	0
i8.01	158.5594	0.0446402133	10.07	10.07	-11.6603519901	-0.2	0
i8.01	158.64868	0.0446402133	10.08	10.08	-11.6603519901	-0.2	0
i8.01	164.77765	0.0451514348	10.07	10.07	-11.3922296053	-0.2	0
i8.01	164.86797	0.0451514348	10.08	10.08	-11.3922296053	-0.2	0
i8.01	170.3654	0.0448598117	10.07	10.07	-11.8269993571	-0.2	0
i8.01	170.45512	0.0448598117	10.08	10.08	-11.8269993571	-0.2	0
i8.00	0.99999994	0.2523423135	10.00	10.00	-10.9950728915	-0.25	0
i8.00	1.2523422	0.2523423135	9.00	9.00	-10.9950728915	-0.25	0
i8.00	1.5046846	0.2523423135	10.00	10.00	-10.9950728915	-0.25	0
i8.00	2.7663963	0.2523423135	9.00	9.00	-10.9950728915	-0.25	0
i8.00	3.0187385	0.2523423135	10.00	10.00	-10.9950728915	-0.25	0
i8.00	3.271081	0.2523423135	9.00	9.00	-10.9950728915	-0.25	0
i8.00	6.9800534	0.2480924726	10.00	10.00	-12.2277431791	-0.25	0
i8.00	7.2281456	0.2480924726	9.00	9.00	-12.2277431791	-0.25	0
i8.00	7.4762383	0.2480924726	10.00	10.00	-12.2277431791	-0.25	0
i8.00	8.716701	0.2480924726	9.00	9.00	-12.2277431791	-0.25	0
i8.00	8.964792	0.2480924726	10.00	10.00	-12.2277431791	-0.25	0
i8.00	9.212885	0.2480924726	9.00	9.00	-12.2277431791	-0.25	0
i8.00	13.805617	0.2678869963	10.00	10.00	-12.1107899594	-0.25	0
i8.00	14.0735035	0.2678869963	9.00	9.00	-12.1107899594	-0.25	0
i8.00	14.341391	0.2678869963	10.00	10.00	-12.1107899594	-0.25	0
i8.00	15.680826	0.2678869963	9.00	9.00	-12.1107899594	-0.25	0
i8.00	15.948713	0.2678869963	10.00	10.00	-12.1107899594	-0.25	0
i8.00	16.216599	0.2678869963	9.00	9.00	-12.1107899594	-0.25	0
i8.00	19.788664	0.2560067475	10.00	10.00	-11.6104586234	-0.25	0
i8.00	20.044672	0.2560067475	9.00	9.00	-11.6104586234	-0.25	0
i8.00	20.300678	0.2560067475	10.00	10.00	-11.6104586234	-0.25	0
i8.00	21.580713	0.2560067475	9.00	9.00	-11.6104586234	-0.25	0
i8.00	21.83672	0.2560067475	10.00	10.00	-11.6104586234	-0.25	0
i8.00	22.092726	0.2560067475	9.00	9.00	-11.6104586234	-0.25	0
i8.00	25.352886	0.2488913536	10.00	10.00	-11.1903828607	-0.25	0
i8.00	25.601778	0.2488913536	9.00	9.00	-11.1903828607	-0.25	0
i8.00	25.85067	0.2488913536	10.00	10.00	-11.1903828607	-0.25	0
i8.00	27.095127	0.2488913536	9.00	9.00	-11.1903828607	-0.25	0
i8.00	27.344017	0.2488913536	10.00	10.00	-11.1903828607	-0.25	0
i8.00	27.592909	0.2488913536	9.00	9.00	-11.1903828607	-0.25	0
i8.00	32.54818	0.2593997419	10.00	10.00	-12.4197055821	-0.25	0
i8.00	32.80758	0.2593997419	9.00	9.00	-12.4197055821	-0.25	0
i8.00	33.06698	0.2593997419	10.00	10.00	-12.4197055821	-0.25	0
i8.00	34.36398	0.2593997419	9.00	9.00	-12.4197055821	-0.25	0
i8.00	34.62338	0.2593997419	10.00	10.00	-12.4197055821	-0.25	0
i8.00	34.882774	0.2593997419	9.00	9.00	-12.4197055821	-0.25	0
i8.00	36.86086	0.2449542284	10.00	10.00	-11.5677608908	-0.25	0
i8.00	37.105812	0.2449542284	9.00	9.00	-11.5677608908	-0.25	0
i8.00	37.35077	0.2449542284	10.00	10.00	-11.5677608908	-0.25	0
i8.00	38.57554	0.2449542284	9.00	9.00	-11.5677608908	-0.25	0
i8.00	38.82049	0.2449542284	10.00	10.00	-11.5677608908	-0.25	0
i8.00	39.065445	0.2449542284	9.00	9.00	-11.5677608908	-0.25	0
i8.00	44.043217	0.2534987032	10.00	10.00	-11.642964042	-0.25	0
i8.00	44.29672	0.2534987032	9.00	9.00	-11.642964042	-0.25	0
i8.00	44.550217	0.2534987032	10.00	10.00	-11.642964042	-0.25	0
i8.00	45.817707	0.2534987032	9.00	9.00	-11.642964042	-0.25	0
i8.00	46.071205	0.2534987032	10.00	10.00	-11.642964042	-0.25	0
i8.00	46.324703	0.2534987032	9.00	9.00	-11.642964042	-0.25	0
i8.00	52.8234	0.2671155035	10.00	10.00	-11.4437586698	-0.25	0
i8.00	53.090515	0.2671155035	9.00	9.00	-11.4437586698	-0.25	0
i8.00	53.35763	0.2671155035	10.00	10.00	-11.4437586698	-0.25	0
i8.00	54.693203	0.2671155035	9.00	9.00	-11.4437586698	-0.25	0
i8.00	54.96032	0.2671155035	10.00	10.00	-11.4437586698	-0.25	0
i8.00	55.227436	0.2671155035	9.00	9.00	-11.4437586698	-0.25	0
i8.00	58.027374	0.2597744465	10.00	10.00	-11.5552431329	-0.25	0
i8.00	58.287148	0.2597744465	9.00	9.00	-11.5552431329	-0.25	0
i8.00	58.54692	0.2597744465	10.00	10.00	-11.5552431329	-0.25	0
i8.00	59.84579	0.2597744465	9.00	9.00	-11.5552431329	-0.25	0
i8.00	60.105568	0.2597744465	10.00	10.00	-11.5552431329	-0.25	0
i8.00	60.36534	0.2597744465	9.00	9.00	-11.5552431329	-0.25	0
i8.00	62.54887	0.2518979013	10.00	10.00	-11.718197272	-0.25	0
i8.00	62.800766	0.2518979013	9.00	9.00	-11.718197272	-0.25	0
i8.00	63.052666	0.2518979013	10.00	10.00	-11.718197272	-0.25	0
i8.00	64.31216	0.2518979013	9.00	9.00	-11.718197272	-0.25	0
i8.00	64.56405	0.2518979013	10.00	10.00	-11.718197272	-0.25	0
i8.00	64.81595	0.2518979013	9.00	9.00	-11.718197272	-0.25	0
i8.00	74.138	0.2724939883	10.00	10.00	-11.6335800281	-0.25	0
i8.00	74.41049	0.2724939883	9.00	9.00	-11.6335800281	-0.25	0
i8.00	74.68298	0.2724939883	10.00	10.00	-11.6335800281	-0.25	0
i8.00	76.045456	0.2724939883	9.00	9.00	-11.6335800281	-0.25	0
i8.00	76.31795	0.2724939883	10.00	10.00	-11.6335800281	-0.25	0
i8.00	76.59045	0.2724939883	9.00	9.00	-11.6335800281	-0.25	0
i8.00	74.30333	0.2489658445	10.00	10.00	-11.7234028423	-0.25	0
i8.00	74.5523	0.2489658445	9.00	9.00	-11.7234028423	-0.25	0
i8.00	74.80126	0.2489658445	10.00	10.00	-11.7234028423	-0.25	0
i8.00	76.04609	0.2489658445	9.00	9.00	-11.7234028423	-0.25	0
i8.00	76.29506	0.2489658445	10.00	10.00	-11.7234028423	-0.25	0
i8.00	76.54403	0.2489658445	9.00	9.00	-11.7234028423	-0.25	0
i8.00	82.87848	0.2573072314	10.00	10.00	-11.9469271882	-0.25	0
i8.00	83.13578	0.2573072314	9.00	9.00	-11.9469271882	-0.25	0
i8.00	83.39309	0.2573072314	10.00	10.00	-11.9469271882	-0.25	0
i8.00	84.67963	0.2573072314	9.00	9.00	-11.9469271882	-0.25	0
i8.00	84.93693	0.2573072314	10.00	10.00	-11.9469271882	-0.25	0
i8.00	85.19424	0.2573072314	9.00	9.00	-11.9469271882	-0.25	0
i8.00	90.56148	0.2612711787	10.00	10.00	-11.636628575	-0.25	0
i8.00	90.822754	0.2612711787	9.00	9.00	-11.636628575	-0.25	0
i8.00	91.08402	0.2612711787	10.00	10.00	-11.636628575	-0.25	0
i8.00	92.39038	0.2612711787	9.00	9.00	-11.636628575	-0.25	0
i8.00	92.65165	0.2612711787	10.00	10.00	-11.636628575	-0.25	0
i8.00	92.912926	0.2612711787	9.00	9.00	-11.636628575	-0.25	0
i8.00	96.02256	0.258390218	10.00	10.00	-12.1089811948	-0.25	0
i8.00	96.28095	0.258390218	9.00	9.00	-12.1089811948	-0.25	0
i8.00	96.53934	0.258390218	10.00	10.00	-12.1089811948	-0.25	0
i8.00	97.83129	0.258390218	9.00	9.00	-12.1089811948	-0.25	0
i8.00	98.089676	0.258390218	10.00	10.00	-12.1089811948	-0.25	0
i8.00	98.34807	0.258390218	9.00	9.00	-12.1089811948	-0.25	0
i8.00	100.95298	0.2547025979	10.00	10.00	-12.0732044257	-0.25	0
i8.00	101.20768	0.2547025979	9.00	9.00	-12.0732044257	-0.25	0
i8.00	101.46237	0.2547025979	10.00	10.00	-12.0732044257	-0.25	0
i8.00	102.735886	0.2547025979	9.00	9.00	-12.0732044257	-0.25	0
i8.00	102.99059	0.2547025979	10.00	10.00	-12.0732044257	-0.25	0
i8.00	103.24529	0.2547025979	9.00	9.00	-12.0732044257	-0.25	0
i8.00	150.50003	0.2423087806	9.00	9.00	-11.5519282979	-0.25	0
i8.00	150.74234	0.2423087806	10.00	10.00	-11.5519282979	-0.25	0
i8.00	155.51239	0.2475416511	9.00	9.00	-11.9429019292	-0.25	0
i8.00	155.75993	0.2475416511	10.00	10.00	-11.9429019292	-0.25	0
i8.00	160.44508	0.2429509759	9.00	9.00	-11.5344653564	-0.25	0
i8.00	160.68803	0.2429509759	10.00	10.00	-11.5344653564	-0.25	0
i8.00	165.30249	0.2417255789	9.00	9.00	-11.7078836887	-0.25	0
i8.00	165.54422	0.2417255789	10.00	10.00	-11.7078836887	-0.25	0
i8.00	170.45508	0.2450383306	9.00	9.00	-11.8282766644	-0.25	0
i8.00	170.70012	0.2450383306	10.00	10.00	-11.8282766644	-0.25	0
i8.00	175.37294	0.244059965	9.00	9.00	-12.1362225031	-0.25	0
i8.00	175.617	0.244059965	10.00	10.00	-12.1362225031	-0.25	0
i8.00	181.32164	0.2519999444	9.00	9.00	-12.1326649816	-0.25	0
i8.00	181.57364	0.2519999444	10.00	10.00	-12.1326649816	-0.25	0
i8.00	184.41437	0.236557126	9.00	9.00	-11.690626591	-0.25	0
i8.00	184.65094	0.236557126	10.00	10.00	-11.690626591	-0.25	0
i8.00	190.79286	0.246991694	9.00	9.00	-11.3936145806	-0.25	0
i8.00	191.03986	0.246991694	10.00	10.00	-11.3936145806	-0.25	0
i8.00	194.93494	0.2417907119	9.00	9.00	-11.2462624154	-0.25	0
i8.00	195.17673	0.2417907119	10.00	10.00	-11.2462624154	-0.25	0
i8.00	200.95584	0.2473572493	9.00	9.00	-11.9322485496	-0.25	0
i8.00	201.20319	0.2473572493	10.00	10.00	-11.9322485496	-0.25	0
i8.00	204.67331	0.2411453128	9.00	9.00	-11.7674683734	-0.25	0
i8.00	204.91444	0.2411453128	10.00	10.00	-11.7674683734	-0.25	0
i8.00	211.86957	0.2506912947	9.00	9.00	-11.9123227368	-0.25	0
i8.00	212.12027	0.2506912947	10.00	10.00	-11.9123227368	-0.25	0
i8.00	216.19269	0.2471969426	9.00	9.00	-11.838042635	-0.25	0
i8.00	216.4399	0.2471969426	10.00	10.00	-11.838042635	-0.25	0
i8.00	222.61986	0.2518085837	9.00	9.00	-11.5512422679	-0.25	0
i8.00	222.87167	0.2518085837	10.00	10.00	-11.5512422679	-0.25	0
i8.00	225.22977	0.2430632412	9.00	9.00	-11.3663952491	-0.25	0
i8.00	225.47284	0.2430632412	10.00	10.00	-11.3663952491	-0.25	0
i8.00	231.22197	0.2462826669	9.00	9.00	-11.1856977521	-0.25	0
i8.00	231.46826	0.2462826669	10.00	10.00	-11.1856977521	-0.25	0
i8.00	233.3505	0.2378422916	9.00	9.00	-11.2243198467	-0.25	0
i8.00	233.58832	0.2378422916	10.00	10.00	-11.2243198467	-0.25	0
i8.00	241.51611	0.2471803427	9.00	9.00	-11.5847163124	-0.25	0
i8.00	241.76329	0.2471803427	10.00	10.00	-11.5847163124	-0.25	0
i8.00	240.40005	0.2311809659	9.00	9.00	-11.8691784786	-0.25	0
i8.00	240.63123	0.2311809659	10.00	10.00	-11.8691784786	-0.25	0
i8.00	252.50026	0.2498832047	9.00	9.00	-11.451957391	-0.25	0
i8.00	252.75015	0.2498832047	10.00	10.00	-11.451957391	-0.25	0
i8.03	58.500008	0.0408607833	10.06	10.06	-11.7851489935	-0.1	0
i8.03	58.58173	0.0408607833	10.06	10.06	-11.7851489935	-0.1	0
i8.03	58.663452	0.0408607833	10.06	10.06	-11.7851489935	-0.1	0
i8.03	63.52852	0.042422194	10.06	10.06	-11.3870561503	-0.1	0
i8.03	63.61336	0.042422194	10.06	10.06	-11.3870561503	-0.1	0
i8.03	63.698204	0.042422194	10.06	10.06	-11.3870561503	-0.1	0
i8.03	68.396866	0.0409639254	10.06	10.06	-11.6877729127	-0.1	0
i8.03	68.47879	0.0409639254	10.06	10.06	-11.6877729127	-0.1	0
i8.03	68.56072	0.0409639254	10.06	10.06	-11.6877729127	-0.1	0
i8.03	73.029755	0.040311873	10.06	10.06	-11.7326607582	-0.1	0
i8.03	73.110374	0.040311873	10.06	10.06	-11.7326607582	-0.1	0
i8.03	73.191	0.040311873	10.06	10.06	-11.7326607582	-0.1	0
i8.03	78.96716	0.042874299	10.06	10.06	-12.0092584991	-0.1	0
i8.03	79.05291	0.042874299	10.06	10.06	-12.0092584991	-0.1	0
i8.03	79.13866	0.042874299	10.06	10.06	-12.0092584991	-0.1	0
i8.03	83.99497	0.0423679091	10.06	10.06	-11.93463502	-0.1	0
i8.03	84.07971	0.0423679091	10.06	10.06	-11.93463502	-0.1	0
i8.03	84.164444	0.0423679091	10.06	10.06	-11.93463502	-0.1	0
i8.03	87.50465	0.0400252342	10.06	10.06	-11.9624175949	-0.1	0
i8.03	87.584694	0.0400252342	10.06	10.06	-11.9624175949	-0.1	0
i8.03	87.66475	0.0400252342	10.06	10.06	-11.9624175949	-0.1	0
i8.03	93.42241	0.0415362306	10.06	10.06	-12.2138995559	-0.1	0
i8.03	93.505486	0.0415362306	10.06	10.06	-12.2138995559	-0.1	0
i8.03	93.58856	0.0415362306	10.06	10.06	-12.2138995559	-0.1	0
i8.03	98.20289	0.0413027816	10.06	10.06	-11.6047919077	-0.1	0
i8.03	98.28549	0.0413027816	10.06	10.06	-11.6047919077	-0.1	0
i8.03	98.3681	0.0413027816	10.06	10.06	-11.6047919077	-0.1	0
i8.03	104.785934	0.0428144783	10.06	10.06	-11.4962469076	-0.1	0
i8.03	104.87157	0.0428144783	10.06	10.06	-11.4962469076	-0.1	0
i8.03	104.95719	0.0428144783	10.06	10.06	-11.4962469076	-0.1	0
i8.03	116.99999	0.0417431109	10.06	10.06	-11.3744982591	-0.1	0
i8.03	117.08348	0.0417431109	10.06	10.06	-11.3744982591	-0.1	0
i8.03	117.16696	0.0417431109	10.06	10.06	-11.3744982591	-0.1	0
i8.03	121.703896	0.0405439027	10.06	10.06	-11.4591878575	-0.1	0
i8.03	121.78498	0.0405439027	10.06	10.06	-11.4591878575	-0.1	0
i8.03	121.86607	0.0405439027	10.06	10.06	-11.4591878575	-0.1	0
i8.03	126.59954	0.0419731587	10.06	10.06	-11.4912195568	-0.1	0
i8.03	126.68349	0.0419731587	10.06	10.06	-11.4912195568	-0.1	0
i8.03	126.76743	0.0419731587	10.06	10.06	-11.4912195568	-0.1	0
i8.03	131.65514	0.0424336419	10.06	10.06	-11.6545885622	-0.1	0
i8.03	131.74	0.0424336419	10.06	10.06	-11.6545885622	-0.1	0
i8.03	131.82487	0.0424336419	10.06	10.06	-11.6545885622	-0.1	0
i8.03	137.66032	0.0445933118	10.06	10.06	-11.6403170978	-0.1	0
i8.03	137.74951	0.0445933118	10.06	10.06	-11.6403170978	-0.1	0
i8.03	137.83868	0.0445933118	10.06	10.06	-11.6403170978	-0.1	0
i8.03	141.9688	0.0425183848	10.06	10.06	-12.116101371	-0.1	0
i8.03	142.05383	0.0425183848	10.06	10.06	-12.116101371	-0.1	0
i8.03	142.13887	0.0425183848	10.06	10.06	-12.116101371	-0.1	0
i8.03	148.20773	0.0442398228	10.06	10.06	-11.5606259249	-0.1	0
i8.03	148.29622	0.0442398228	10.06	10.06	-11.5606259249	-0.1	0
i8.03	148.3847	0.0442398228	10.06	10.06	-11.5606259249	-0.1	0
i8.03	154.64737	0.0454469286	10.06	10.06	-11.6676550267	-0.1	0
i8.03	154.73828	0.0454469286	10.06	10.06	-11.6676550267	-0.1	0
i8.03	154.82916	0.0454469286	10.06	10.06	-11.6676550267	-0.1	0
i8.03	156.71329	0.0415978581	10.06	10.06	-11.9769774333	-0.1	0
i8.03	156.79648	0.0415978581	10.06	10.06	-11.9769774333	-0.1	0
i8.03	156.87967	0.0415978581	10.06	10.06	-11.9769774333	-0.1	0
i8.03	163.28378	0.0432432704	10.06	10.06	-12.0746719214	-0.1	0
i8.03	163.37027	0.0432432704	10.06	10.06	-12.0746719214	-0.1	0
i8.03	163.45676	0.0432432704	10.06	10.06	-12.0746719214	-0.1	0
i8.03	367.33328	0.045029074	10.06	10.06	-12.1064423026	-0.1	0
i8.03	367.42334	0.045029074	10.06	10.06	-12.1064423026	-0.1	0
i8.03	367.5134	0.045029074	10.06	10.06	-12.1064423026	-0.1	0
i8.03	372.58923	0.0445525385	10.06	10.06	-12.0098862665	-0.1	0
i8.03	372.67834	0.0445525385	10.06	10.06	-12.0098862665	-0.1	0
i8.03	372.76746	0.0445525385	10.06	10.06	-12.0098862665	-0.1	0
i8.03	377.61603	0.0438130759	10.06	10.06	-10.9623459458	-0.1	0
i8.03	377.70364	0.0438130759	10.06	10.06	-10.9623459458	-0.1	0
i8.03	377.79126	0.0438130759	10.06	10.06	-10.9623459458	-0.1	0
i8.03	383.74677	0.0469652042	10.06	10.06	-12.2420192782	-0.1	0
i8.03	383.8407	0.0469652042	10.06	10.06	-12.2420192782	-0.1	0
i8.03	383.93463	0.0469652042	10.06	10.06	-12.2420192782	-0.1	0
i8.03	389.0286	0.0459134802	10.06	10.06	-11.8034921861	-0.1	0
i8.03	389.12042	0.0459134802	10.06	10.06	-11.8034921861	-0.1	0
i8.03	389.21225	0.0459134802	10.06	10.06	-11.8034921861	-0.1	0
i8.03	393.98093	0.0449510179	10.06	10.06	-11.5056462058	-0.1	0
i8.03	394.07083	0.0449510179	10.06	10.06	-11.5056462058	-0.1	0
i8.03	394.16074	0.0449510179	10.06	10.06	-11.5056462058	-0.1	0
i8.03	400.28992	0.046379745	10.06	10.06	-11.7982499196	-0.1	0
i8.03	400.3827	0.046379745	10.06	10.06	-11.7982499196	-0.1	0
i8.03	400.47543	0.046379745	10.06	10.06	-11.7982499196	-0.1	0
i8.03	403.35092	0.0432855822	10.06	10.06	-11.2842377993	-0.1	0
i8.03	403.4375	0.0432855822	10.06	10.06	-11.2842377993	-0.1	0
i8.03	403.52405	0.0432855822	10.06	10.06	-11.2842377993	-0.1	0
i8.03	410.074	0.0452044755	10.06	10.06	-11.5649910988	-0.1	0
i8.03	410.1644	0.0452044755	10.06	10.06	-11.5649910988	-0.1	0
i8.03	410.25482	0.0452044755	10.06	10.06	-11.5649910988	-0.1	0
i8.03	413.61578	0.0435014926	10.06	10.06	-11.5021439001	-0.1	0
i8.03	413.7028	0.0435014926	10.06	10.06	-11.5021439001	-0.1	0
i8.03	413.7898	0.0435014926	10.06	10.06	-11.5021439001	-0.1	0
i8.03	277.33328	0.0433474183	10.06	10.06	-11.4496802223	-0.1	0
i8.03	277.41998	0.0433474183	10.06	10.06	-11.4496802223	-0.1	0
i8.03	277.50668	0.0433474183	10.06	10.06	-11.4496802223	-0.1	0
i8.03	282.45395	0.0434823856	10.06	10.06	-11.4580468473	-0.1	0
i8.03	282.5409	0.0434823856	10.06	10.06	-11.4580468473	-0.1	0
i8.03	282.62787	0.0434823856	10.06	10.06	-11.4580468473	-0.1	0
i8.03	287.50183	0.0431063324	10.06	10.06	-11.9057124753	-0.1	0
i8.03	287.58804	0.0431063324	10.06	10.06	-11.9057124753	-0.1	0
i8.03	287.67426	0.0431063324	10.06	10.06	-11.9057124753	-0.1	0
i8.03	292.41348	0.0427196957	10.06	10.06	-11.1389324872	-0.1	0
i8.03	292.49893	0.0427196957	10.06	10.06	-11.1389324872	-0.1	0
i8.03	292.58435	0.0427196957	10.06	10.06	-11.1389324872	-0.1	0
i8.03	297.23364	0.0424258597	10.06	10.06	-11.9119283776	-0.1	0
i8.03	297.3185	0.0424258597	10.06	10.06	-11.9119283776	-0.1	0
i8.03	297.40335	0.0424258597	10.06	10.06	-11.9119283776	-0.1	0
i8.03	302.2318	0.0426109135	10.06	10.06	-11.6370366949	-0.1	0
i8.03	302.31702	0.0426109135	10.06	10.06	-11.6370366949	-0.1	0
i8.03	302.40225	0.0426109135	10.06	10.06	-11.6370366949	-0.1	0
i8.03	307.944	0.0437242389	10.06	10.06	-11.4154394946	-0.1	0
i8.03	308.03143	0.0437242389	10.06	10.06	-11.4154394946	-0.1	0
i8.03	308.1189	0.0437242389	10.06	10.06	-11.4154394946	-0.1	0
i8.03	313.30124	0.0439237095	10.06	10.06	-11.7857540595	-0.1	0
i8.03	313.38907	0.0439237095	10.06	10.06	-11.7857540595	-0.1	0
i8.03	313.47693	0.0439237095	10.06	10.06	-11.7857540595	-0.1	0
i8.03	319.55896	0.0450069793	10.06	10.06	-11.5225565129	-0.1	0
i8.03	319.64896	0.0450069793	10.06	10.06	-11.5225565129	-0.1	0
i8.03	319.73898	0.0450069793	10.06	10.06	-11.5225565129	-0.1	0
i8.03	323.61508	0.0436424911	10.06	10.06	-11.7166555251	-0.1	0
i8.03	323.70236	0.0436424911	10.06	10.06	-11.7166555251	-0.1	0
i8.03	323.78964	0.0436424911	10.06	10.06	-11.7166555251	-0.1	0
i8.35	2.1485026	-1.3648965359	8.000047	8.000047	-20.0	-0.25	3
i8.35	3.5857208	-1.3663998842	8.000047	8.004080	-19.642645	-0.25	3
i8.35	5.0229387	-1.4034456015	8.004080	8.007909	-19.453576	-0.25	3
i8.35	6.460157	-1.4197862148	8.007909	8.008706	-19.264958	-0.25	3
i8.35	7.897368	-1.4365597963	8.008706	8.011686	-19.073289	-0.25	3
i8.35	9.334586	-1.3698292971	8.011686	8.015322	-18.856575	-0.25	3
i8.35	10.771804	-1.4365717173	8.015322	8.016664	-18.589572	-0.25	3
i8.35	12.209022	-1.3909691572	8.016664	8.022667	-18.4582	-0.25	3
i8.35	13.64624	-1.4024760723	8.022667	8.020689	-18.259631	-0.25	3
i8.35	15.083451	-1.3751305342	8.020689	8.022632	-18.197945	-0.25	3
i8.35	16.52067	-1.4330633879	8.022632	8.029237	-17.871623	-0.25	3
i8.35	17.957888	-1.4239829779	8.029237	8.027771	-17.618145	-0.25	3
i8.35	19.395105	-1.4102421999	8.027771	8.033130	-17.44891	-0.25	3
i8.35	20.832323	-1.4205918312	8.033130	8.035639	-17.114178	-0.25	3
i8.35	22.269543	-1.3648592234	8.035639	8.033644	-16.769005	-0.25	3
i8.35	23.706753	-1.375675559	8.033644	8.035742	-16.750072	-0.25	3
i8.35	25.14397	-1.4097019434	8.035742	8.038705	-16.78072	-0.25	3
i8.35	26.581188	-1.37966609	8.038705	8.043521	-16.537446	-0.25	3
i8.35	28.018408	-1.4186505079	8.043521	8.046413	-16.303396	-0.25	3
i8.35	29.455626	-1.3940331936	8.046413	8.049529	-16.05603	-0.25	3
i8.35	30.892838	-1.4337668419	8.049529	8.044025	-15.977602	-0.25	3
i8.35	32.33005	-1.3885617256	8.044025	8.044133	-15.657821	-0.25	3
i8.35	33.767273	-1.3966177702	8.044133	8.048394	-15.405889	-0.25	3
i8.35	35.20449	-1.3995217085	8.048394	8.044467	-15.668755	-0.25	3
i8.35	36.64171	-1.4249609709	8.044467	8.043633	-14.970094	-0.25	3
i8.35	38.078926	-1.397803545	8.043633	8.039122	-14.818325	-0.25	3
i8.35	39.516136	-1.4362735748	8.039122	8.036082	-14.937464	-0.25	3
i8.35	40.953358	-1.3888010979	8.036082	8.033227	-14.955426	-0.25	3
i8.35	42.390575	-1.3857861757	8.033227	8.032486	-14.829491	-0.25	3
i8.35	43.82779	-1.3866665363	8.032486	8.030596	-14.735691	-0.25	3
i8.35	45.26501	-1.4299688339	8.030596	8.029509	-14.864579	-0.25	3
i8.35	46.70222	-1.4354053736	8.029509	8.029435	-14.959785	-0.25	3
i8.35	48.13944	-1.4251307249	8.029435	8.029704	-15.044956	-0.25	3
i8.35	49.576656	-1.3888171911	8.029704	8.029466	-15.133896	-0.25	3
i8.35	51.013874	-1.3773852587	8.029466	8.029479	-15.258065	-0.25	3
i8.35	52.45109	-1.4021086693	8.029479	8.029601	-15.162647	-0.25	3
i8.35	53.888313	-1.4337278605	8.029601	8.029483	-15.074052	-0.25	3
i8.35	55.32552	-1.4065954685	8.029483	8.029463	-15.050291	-0.25	3
i8.35	56.76274	-1.3770037889	8.029463	8.029428	-15.094491	-0.25	3
i8.35	58.19996	-1.3715285063	8.029428	8.029412	-14.946438	-0.25	3
i8.35	59.637173	-1.4300589561	8.029412	8.029663	-15.735107	-0.25	3
i8.35	61.074398	-1.3785586357	8.029663	8.029559	-18.924213	-0.25	3
i8.35	62.511604	-1.4158097506	8.029559	8.029580	-22.592032	-0.25	3
i8.35	63.948822	-1.4326306581	8.029580	8.029579	-25.935251	-0.25	3
i8.35	65.38604	-1.4015120268	8.029579	8.029567	-29.36543	-0.25	3
i8.35	66.82326	-1.4133269787	8.029567	8.029571	-32.907041	-0.25	3
i8.35	68.26048	-1.4175851345	8.029571	8.029639	-36.169092	-0.25	3
i8.35	69.6977	-1.3971955776	8.029639	8.029629	-39.708577	-0.25	3
i8.35	71.1349	-1.3900071383	8.029629	8.029419	-43.1774	-0.25	3
i8.35	72.57213	1.4172502756	8.029419	8.029666	-46.544898	-0.25	3
i8.36	1.6404672	-1.3818261623	8.000058	8.000058	-20.0	-0.2	3
i8.36	3.0878482	-1.3887381554	8.000058	8.003970	-19.712963	-0.2	3
i8.36	4.5352216	-1.4350217581	8.003970	8.005115	-19.516932	-0.2	3
i8.36	5.982603	-1.4245218039	8.005115	8.008588	-19.33733	-0.2	3
i8.36	7.429977	-1.4022842646	8.008588	8.010662	-19.114588	-0.2	3
i8.36	8.8773575	-1.4030483961	8.010662	8.014255	-18.893088	-0.2	3
i8.36	10.324732	-1.3843021393	8.014255	8.016440	-18.713604	-0.2	3
i8.36	11.772113	-1.4341036081	8.016440	8.016648	-18.558307	-0.2	3
i8.36	13.219486	-1.3996329308	8.016648	8.022551	-18.368657	-0.2	3
i8.36	14.666867	-1.3774286509	8.022551	8.025604	-18.201127	-0.2	3
i8.36	16.11424	-1.4259393215	8.025604	8.024458	-17.938768	-0.2	3
i8.36	17.561623	-1.4449646473	8.024458	8.026326	-17.769692	-0.2	3
i8.36	19.008995	-1.4118108749	8.026326	8.027222	-17.58587	-0.2	3
i8.36	20.456377	-1.3976807594	8.027222	8.036012	-17.470001	-0.2	3
i8.36	21.903751	-1.4294081926	8.036012	8.035785	-17.086628	-0.2	3
i8.36	23.351131	-1.4360648394	8.035785	8.039440	-17.179942	-0.2	3
i8.36	24.798504	-1.4273502827	8.039440	8.039500	-16.743532	-0.2	3
i8.36	26.245886	-1.4449528456	8.039500	8.042376	-16.716251	-0.2	3
i8.36	27.69326	-1.3784277439	8.042376	8.044987	-16.407229	-0.2	3
i8.36	29.14064	-1.3943516016	8.044987	8.044835	-16.273468	-0.2	3
i8.36	30.588024	-1.3901962042	8.044835	8.053705	-16.141103	-0.2	3
i8.36	32.035393	-1.4139933586	8.053705	8.051093	-16.158613	-0.2	3
i8.36	33.482777	-1.3821066618	8.051093	8.055592	-15.47132	-0.2	3
i8.36	34.93015	-1.3959664106	8.055592	8.053405	-15.514447	-0.2	3
i8.36	36.37753	-1.4209764004	8.053405	8.055510	-15.136074	-0.2	3
i8.36	37.824905	-1.4160994291	8.055510	8.058799	-15.087113	-0.2	3
i8.36	39.272285	-1.3878878355	8.058799	8.060020	-15.008786	-0.2	3
i8.36	40.719658	-1.4013391733	8.060020	8.065698	-15.364521	-0.2	3
i8.36	42.16704	-1.4010847807	8.065698	8.065749	-14.94737	-0.2	3
i8.36	43.614414	-1.4445849657	8.065749	8.067677	-14.926602	-0.2	3
i8.36	45.061794	-1.3759204149	8.067677	8.069538	-15.039291	-0.2	3
i8.36	46.50917	-1.4236408472	8.069538	8.069551	-15.138914	-0.2	3
i8.36	47.95655	-1.3873354197	8.069551	8.069650	-15.21608	-0.2	3
i8.36	49.403923	-1.3839001656	8.069650	8.069753	-15.038896	-0.2	3
i8.36	50.851307	-1.4112645388	8.069753	8.069500	-14.606893	-0.2	3
i8.36	52.29868	-1.4471940994	8.069500	8.069673	-14.928631	-0.2	3
i8.36	53.74606	-1.4421510696	8.069673	8.069404	-15.401124	-0.2	3
i8.36	55.193436	-1.4336999655	8.069404	8.069541	-14.687739	-0.2	3
i8.36	56.640816	-1.4413274527	8.069541	8.069598	-15.4257	-0.2	3
i8.36	58.08819	-1.3775795698	8.069598	8.069598	-14.932602	-0.2	3
i8.36	59.53557	-1.3795284033	8.069598	8.069663	-15.509818	-0.2	3
i8.36	60.98294	-1.4134500027	8.069663	8.069603	-18.669931	-0.2	3
i8.36	62.430325	-1.3989175558	8.069603	8.069596	-22.198666	-0.2	3
i8.36	63.877697	-1.4049098492	8.069596	8.069690	-25.551294	-0.2	3
i8.36	65.32508	-1.4345942736	8.069690	8.069370	-29.34015	-0.2	3
i8.36	66.77245	-1.3903862238	8.069370	8.069522	-32.736686	-0.2	3
i8.36	68.21983	-1.4000637531	8.069522	8.069549	-36.303188	-0.2	3
i8.36	69.667206	-1.4339880943	8.069549	8.069539	-39.601231	-0.2	3
i8.36	71.114586	-1.4091038704	8.069539	8.069540	-43.092802	-0.2	3
i8.36	72.56196	1.396982789	8.069540	8.069426	-46.537522	-0.2	3
i8.37	3.0300467	-1.3955361843	8.000059	8.000059	-20.0	-0.15	3
i8.37	4.449633	-1.3647705317	8.000059	8.006075	-19.5165	-0.15	3
i8.37	5.8692193	-1.4095793962	8.006075	8.007063	-19.264336	-0.15	3
i8.37	7.288806	-1.3632147312	8.007063	8.011110	-19.082043	-0.15	3
i8.37	8.708392	-1.393150568	8.011110	8.014016	-18.965974	-0.15	3
i8.37	10.127978	-1.3788474798	8.014016	8.016440	-18.723589	-0.15	3
i8.37	11.5475645	-1.3858984709	8.016440	8.015442	-18.660691	-0.15	3
i8.37	12.967151	-1.4062480927	8.015442	8.021139	-18.390477	-0.15	3
i8.37	14.386738	-1.4007692337	8.021139	8.021322	-18.260277	-0.15	3
i8.37	15.806323	-1.3621900082	8.021322	8.026485	-18.012725	-0.15	3
i8.37	17.225903	-1.3639899492	8.026485	8.028691	-17.833467	-0.15	3
i8.37	18.64549	-1.3927598	8.028691	8.025944	-17.645887	-0.15	3
i8.37	20.065077	-1.3596174717	8.025944	8.030521	-17.394323	-0.15	3
i8.37	21.484661	-1.3559464216	8.030521	8.039006	-17.273073	-0.15	3
i8.37	22.904247	-1.3993982077	8.039006	8.033480	-17.058485	-0.15	3
i8.37	24.323835	-1.3770433664	8.033480	8.033107	-16.686896	-0.15	3
i8.37	25.743422	-1.3515039682	8.033107	8.041353	-16.728097	-0.15	3
i8.37	27.163008	-1.3653082848	8.041353	8.045402	-16.284666	-0.15	3
i8.37	28.582594	-1.4030170441	8.045402	8.046068	-16.289585	-0.15	3
i8.37	30.00218	-1.3959982395	8.046068	8.047913	-15.860406	-0.15	3
i8.37	31.421766	-1.3695551157	8.047913	8.043213	-15.837762	-0.15	3
i8.37	32.84135	-1.404122591	8.043213	8.049629	-15.423817	-0.15	3
i8.37	34.260937	-1.3823293447	8.049629	8.045939	-15.708065	-0.15	3
i8.37	35.680523	-1.4004936218	8.045939	8.046919	-15.112756	-0.15	3
i8.37	37.100113	-1.3484145403	8.046919	8.041060	-14.975234	-0.15	3
i8.37	38.5197	-1.3966823816	8.041060	8.040955	-14.852396	-0.15	3
i8.37	39.939278	-1.3616534472	8.040955	8.036104	-14.901179	-0.15	3
i8.37	41.358864	-1.4117408991	8.036104	8.033772	-15.207508	-0.15	3
i8.37	42.77845	-1.3687217236	8.033772	8.032945	-14.880333	-0.15	3
i8.37	44.198036	-1.4138160944	8.032945	8.030165	-15.129844	-0.15	3
i8.37	45.617622	-1.3544809818	8.030165	8.029466	-14.959125	-0.15	3
i8.37	47.03721	-1.4175294638	8.029466	8.029499	-15.150623	-0.15	3
i8.37	48.4568	-1.3745239973	8.029499	8.029715	-14.807783	-0.15	3
i8.37	49.876385	-1.3976092339	8.029715	8.029523	-15.252069	-0.15	3
i8.37	51.295967	-1.4027152061	8.029523	8.029362	-15.188382	-0.15	3
i8.37	52.715553	-1.4168919325	8.029362	8.029589	-14.772744	-0.15	3
i8.37	54.13514	-1.4088698626	8.029589	8.029429	-14.798528	-0.15	3
i8.37	55.554726	-1.3799159527	8.029429	8.029469	-14.949029	-0.15	3
i8.37	56.97431	-1.3553186655	8.029469	8.029640	-14.893929	-0.15	3
i8.37	58.3939	-1.3800195456	8.029640	8.029573	-14.741276	-0.15	3
i8.37	59.813484	-1.3684277534	8.029573	8.029500	-15.860637	-0.15	3
i8.37	61.23307	-1.3613975048	8.029500	8.029647	-19.606363	-0.15	3
i8.37	62.65265	-1.4117587805	8.029647	8.029436	-22.868556	-0.15	3
i8.37	64.07224	-1.4143569469	8.029436	8.029571	-26.030646	-0.15	3
i8.37	65.49183	-1.4145640135	8.029571	8.029704	-29.477031	-0.15	3
i8.37	66.911415	-1.3530234098	8.029704	8.029621	-32.935792	-0.15	3
i8.37	68.331	-1.3709276915	8.029621	8.029458	-36.436779	-0.15	3
i8.37	69.75059	-1.416442275	8.029458	8.029437	-39.815949	-0.15	3
i8.37	71.17017	-1.402749896	8.029437	8.029511	-43.202781	-0.15	3
i8.37	72.58976	1.4071369171	8.029511	8.029539	-46.585399	-0.15	3
i8.38	1.9521805	-1.3932433128	8.000053	8.000053	-20.0	-0.1	3
i8.38	3.3933265	-1.3978661299	8.000053	8.004399	-19.675196	-0.1	3
i8.38	4.834465	-1.4296522141	8.004399	8.006151	-19.47184	-0.1	3
i8.38	6.2756114	-1.4224274158	8.006151	8.008165	-19.240279	-0.1	3
i8.38	7.7167573	-1.3821940422	8.008165	8.012732	-19.059566	-0.1	3
i8.38	9.157896	-1.3898437023	8.012732	8.014441	-18.905067	-0.1	3
i8.38	10.599042	-1.4268094301	8.014441	8.013958	-18.686474	-0.1	3
i8.38	12.04018	-1.3748010397	8.013958	8.019146	-18.466943	-0.1	3
i8.38	13.481327	-1.3692679405	8.019146	8.021136	-18.08688	-0.1	3
i8.38	14.922473	-1.3959349394	8.021136	8.022016	-18.115303	-0.1	3
i8.38	16.363611	-1.4351993799	8.022016	8.027312	-17.921639	-0.1	3
i8.38	17.804758	-1.3875683546	8.027312	8.032111	-17.482737	-0.1	3
i8.38	19.245897	-1.398974061	8.032111	8.029353	-17.494014	-0.1	3
i8.38	20.687042	-1.383466959	8.029353	8.035173	-17.401081	-0.1	3
i8.38	22.12819	-1.3722447157	8.035173	8.032526	-17.170577	-0.1	3
i8.38	23.569328	-1.4126199484	8.032526	8.036425	-17.033743	-0.1	3
i8.38	25.010473	-1.3888989687	8.036425	8.041969	-16.840971	-0.1	3
i8.38	26.45162	-1.3810744286	8.041969	8.043805	-16.447337	-0.1	3
i8.38	27.89276	-1.3939188719	8.043805	8.047001	-16.426383	-0.1	3
i8.38	29.333904	-1.4238536358	8.047001	8.053378	-16.168229	-0.1	3
i8.38	30.775042	-1.3955847025	8.053378	8.047944	-15.875834	-0.1	3
i8.38	32.216187	-1.4360847473	8.047944	8.053353	-15.498206	-0.1	3
i8.38	33.657333	-1.4045423269	8.053353	8.045360	-15.259292	-0.1	3
i8.38	35.098473	-1.4055219889	8.045360	8.046529	-15.074192	-0.1	3
i8.38	36.53962	-1.4274107218	8.046529	8.041965	-15.022161	-0.1	3
i8.38	37.980766	-1.4028277397	8.041965	8.036653	-15.34755	-0.1	3
i8.38	39.4219	-1.3975046873	8.036653	8.036968	-14.981114	-0.1	3
i8.38	40.86305	-1.3782755136	8.036968	8.036515	-14.88285	-0.1	3
i8.38	42.304188	-1.405610919	8.036515	8.032466	-15.15905	-0.1	3
i8.38	43.745335	-1.4070372581	8.032466	8.030780	-15.21456	-0.1	3
i8.38	45.18648	-1.4161733389	8.030780	8.029585	-14.797361	-0.1	3
i8.38	46.62762	-1.4302114248	8.029585	8.029599	-15.074586	-0.1	3
i8.38	48.068764	-1.3942213058	8.029599	8.029532	-15.142024	-0.1	3
i8.38	49.509903	-1.3998850584	8.029532	8.029672	-15.241835	-0.1	3
i8.38	50.95105	-1.4140331745	8.029672	8.029478	-14.905287	-0.1	3
i8.38	52.392197	-1.4321180582	8.029478	8.029550	-14.817747	-0.1	3
i8.38	53.833336	-1.4268444777	8.029550	8.029504	-14.873477	-0.1	3
i8.38	55.274483	-1.4395076036	8.029504	8.029337	-15.059717	-0.1	3
i8.38	56.715626	-1.4116655588	8.029337	8.029587	-15.486134	-0.1	3
i8.38	58.156765	-1.4319158792	8.029587	8.029528	-15.580801	-0.1	3
i8.38	59.59791	-1.4159319401	8.029528	8.029581	-15.473819	-0.1	3
i8.38	61.039055	-1.3906316757	8.029581	8.029595	-18.842144	-0.1	3
i8.38	62.480198	-1.387578249	8.029595	8.029466	-22.43612	-0.1	3
i8.38	63.921345	-1.3863531351	8.029466	8.029729	-25.797588	-0.1	3
i8.38	65.36248	-1.3803796768	8.029729	8.029740	-29.250208	-0.1	3
i8.38	66.803635	-1.3685863018	8.029740	8.029575	-32.779779	-0.1	3
i8.38	68.244774	-1.4395236969	8.029575	8.029475	-36.259752	-0.1	3
i8.38	69.68591	-1.4404187202	8.029475	8.029629	-39.61165	-0.1	3
i8.38	71.12706	-1.3727302551	8.029629	8.029512	-43.090631	-0.1	3
i8.38	72.56819	1.3751803637	8.029512	8.029667	-46.537474	-0.1	3
i8.39	2.4696634	-1.3755738735	8.000043	8.000043	-20.0	-0.05	3
i8.39	3.9004567	-1.4145777225	8.000043	8.004776	-19.604619	-0.05	3
i8.39	5.33125	-1.3895630836	8.004776	8.007855	-19.353733	-0.05	3
i8.39	6.762043	-1.3813545704	8.007855	8.009265	-19.218626	-0.05	3
i8.39	8.192837	-1.4182024002	8.009265	8.011803	-19.018264	-0.05	3
i8.39	9.623637	-1.3959348202	8.011803	8.015710	-18.726259	-0.05	3
i8.39	11.054431	-1.4031662941	8.015710	8.016830	-18.577337	-0.05	3
i8.39	12.485224	-1.4294615984	8.016830	8.020496	-18.428477	-0.05	3
i8.39	13.916018	-1.4036991596	8.020496	8.019870	-18.316015	-0.05	3
i8.39	15.34681	-1.3766795397	8.019870	8.023388	-18.122688	-0.05	3
i8.39	16.777605	-1.4292669296	8.023388	8.023537	-17.801315	-0.05	3
i8.39	18.208397	-1.426422596	8.023537	8.030500	-17.540635	-0.05	3
i8.39	19.63919	-1.3771965504	8.030500	8.026304	-17.354241	-0.05	3
i8.39	21.069984	-1.3907754421	8.026304	8.035059	-17.35726	-0.05	3
i8.39	22.500778	-1.4124839306	8.035059	8.032658	-17.064063	-0.05	3
i8.39	23.93157	-1.4206371307	8.032658	8.038945	-17.005525	-0.05	3
i8.39	25.362364	-1.3822942972	8.038945	8.042707	-16.576618	-0.05	3
i8.39	26.793156	-1.3770747185	8.042707	8.044805	-16.579397	-0.05	3
i8.39	28.223951	-1.4076254368	8.044805	8.046262	-16.227992	-0.05	3
i8.39	29.654743	-1.3651914597	8.046262	8.051801	-16.252916	-0.05	3
i8.39	31.085537	-1.4118382931	8.051801	8.046969	-15.961656	-0.05	3
i8.39	32.516327	-1.3722327948	8.046969	8.058108	-15.838676	-0.05	3
i8.39	33.94712	-1.4071160555	8.058108	8.058919	-15.526609	-0.05	3
i8.39	35.37792	-1.4139353037	8.058919	8.052588	-15.335749	-0.05	3
i8.39	36.80871	-1.4272729158	8.052588	8.060671	-15.207004	-0.05	3
i8.39	38.239502	-1.4167507887	8.060671	8.060355	-15.034788	-0.05	3
i8.39	39.6703	-1.4238525629	8.060355	8.064865	-14.908198	-0.05	3
i8.39	41.10109	-1.3877578974	8.064865	8.063029	-15.131787	-0.05	3
i8.39	42.531883	-1.4107190371	8.063029	8.066322	-14.927262	-0.05	3
i8.39	43.962677	-1.4291034937	8.066322	8.068022	-14.962844	-0.05	3
i8.39	45.39347	-1.3621042967	8.068022	8.069670	-15.019063	-0.05	3
i8.39	46.824265	-1.4279074669	8.069670	8.069524	-14.881884	-0.05	3
i8.39	48.255054	-1.3944664001	8.069524	8.069651	-15.122432	-0.05	3
i8.39	49.68585	-1.412928462	8.069651	8.069630	-14.681532	-0.05	3
i8.39	51.116646	-1.4296380281	8.069630	8.069543	-15.291457	-0.05	3
i8.39	52.547443	-1.3898621798	8.069543	8.069516	-14.769649	-0.05	3
i8.39	53.978237	-1.3725692034	8.069516	8.069481	-15.093448	-0.05	3
i8.39	55.40903	-1.4113433361	8.069481	8.069588	-15.08983	-0.05	3
i8.39	56.839825	-1.4302912951	8.069588	8.069499	-14.946338	-0.05	3
i8.39	58.27062	-1.4108375311	8.069499	8.069555	-14.930119	-0.05	3
i8.39	59.701412	-1.3767603636	8.069555	8.069480	-15.777799	-0.05	3
i8.39	61.132202	-1.384996295	8.069480	8.069707	-19.187951	-0.05	3
i8.39	62.562996	-1.3760929108	8.069707	8.069607	-22.314119	-0.05	3
i8.39	63.993793	-1.3970825672	8.069607	8.069601	-26.052311	-0.05	3
i8.39	65.42458	-1.4067648649	8.069601	8.069441	-29.630251	-0.05	3
i8.39	66.85538	-1.4031348228	8.069441	8.069570	-32.780781	-0.05	3
i8.39	68.28616	-1.3587425947	8.069570	8.069622	-36.355813	-0.05	3
i8.39	69.716965	-1.3950530291	8.069622	8.069578	-39.7036	-0.05	3
i8.39	71.14776	-1.387571454	8.069578	8.069670	-43.099087	-0.05	3
i8.39	72.578545	1.396707058	8.069670	8.069566	-46.559693	-0.05	3
i8.40	3.8233297	-1.4001615047	8.000040	8.000040	-20.0	0.0	3
i8.40	5.2270513	-1.3488118649	8.000040	8.006209	-19.425999	0.0	3
i8.40	6.6307726	-1.3969774246	8.006209	8.010399	-19.223922	0.0	3
i8.40	8.034493	-1.3992631435	8.010399	8.012718	-19.035023	0.0	3
i8.40	9.438209	-1.361831069	8.012718	8.014313	-18.954528	0.0	3
i8.40	10.841929	-1.3578233719	8.014313	8.018118	-18.594643	0.0	3
i8.40	12.245651	-1.3464047909	8.018118	8.017183	-18.362151	0.0	3
i8.40	13.649372	-1.3411716223	8.017183	8.027036	-18.327524	0.0	3
i8.40	15.053094	-1.3584614992	8.027036	8.027111	-18.128628	0.0	3
i8.40	16.456814	-1.3823990822	8.027111	8.029076	-17.843495	0.0	3
i8.40	17.860529	-1.3828097582	8.029076	8.029581	-17.729225	0.0	3
i8.40	19.26425	-1.3439445496	8.029581	8.034595	-17.455171	0.0	3
i8.40	20.667973	-1.3370372057	8.034595	8.035671	-17.260339	0.0	3
i8.40	22.071693	-1.3671822548	8.035671	8.038576	-17.229744	0.0	3
i8.40	23.475414	-1.3664865494	8.038576	8.040847	-17.072298	0.0	3
i8.40	24.879137	-1.3694032431	8.040847	8.043547	-16.84388	0.0	3
i8.40	26.28285	-1.3328807354	8.043547	8.045177	-16.739252	0.0	3
i8.40	27.686571	-1.3351948261	8.045177	8.041618	-16.193285	0.0	3
i8.40	29.090294	-1.3896909952	8.041618	8.050382	-16.140125	0.0	3
i8.40	30.494017	-1.3440614939	8.050382	8.052020	-16.054697	0.0	3
i8.40	31.897738	-1.347454071	8.052020	8.053914	-16.02228	0.0	3
i8.40	33.30146	-1.3707319498	8.053914	8.059247	-15.379173	0.0	3
i8.40	34.70518	-1.3674174547	8.059247	8.050599	-15.337486	0.0	3
i8.40	36.108894	-1.3640115261	8.050599	8.060328	-14.929484	0.0	3
i8.40	37.512615	-1.3893665075	8.060328	8.058770	-15.211508	0.0	3
i8.40	38.916336	-1.3433173895	8.058770	8.061003	-15.087751	0.0	3
i8.40	40.320057	-1.3733016253	8.061003	8.061871	-14.682148	0.0	3
i8.40	41.72378	-1.3658094406	8.061871	8.064264	-14.799268	0.0	3
i8.40	43.127502	-1.361687541	8.064264	8.066879	-14.982495	0.0	3
i8.40	44.531216	-1.3425177336	8.066879	8.069431	-15.430516	0.0	3
i8.40	45.934937	-1.3812918663	8.069431	8.069672	-14.779398	0.0	3
i8.40	47.338657	-1.4002478123	8.069672	8.069523	-15.132395	0.0	3
i8.40	48.74238	-1.3581197262	8.069523	8.069464	-15.098849	0.0	3
i8.40	50.146103	-1.3344055414	8.069464	8.069624	-15.4442	0.0	3
i8.40	51.549824	-1.339232564	8.069624	8.069688	-14.973288	0.0	3
i8.40	52.953537	-1.3591463566	8.069688	8.069630	-14.960229	0.0	3
i8.40	54.357258	-1.3802134991	8.069630	8.069503	-15.176735	0.0	3
i8.40	55.76098	-1.382360816	8.069503	8.069534	-15.062826	0.0	3
i8.40	57.1647	-1.3505342007	8.069534	8.069442	-14.970891	0.0	3
i8.40	58.56842	-1.3888716698	8.069442	8.069600	-14.795329	0.0	3
i8.40	59.972145	-1.3483277559	8.069600	8.069585	-16.213789	0.0	3
i8.40	61.375854	-1.3843336105	8.069585	8.069547	-19.66137	0.0	3
i8.40	62.77958	-1.3361998796	8.069547	8.069520	-22.884472	0.0	3
i8.40	64.1833	-1.3489032984	8.069520	8.069545	-26.33545	0.0	3
i8.40	65.58702	-1.3446797132	8.069545	8.069592	-29.774441	0.0	3
i8.40	66.99074	-1.3759365082	8.069592	8.069670	-33.271609	0.0	3
i8.40	68.39446	-1.351829648	8.069670	8.069571	-36.624693	0.0	3
i8.40	69.79817	-1.366946578	8.069571	8.069643	-39.876504	0.0	3
i8.40	71.2019	-1.363966465	8.069643	8.069573	-43.221362	0.0	3
i8.40	72.60562	1.3456479311	8.069573	8.069479	-46.646276	0.0	3
i8.41	3.23018	-1.3695466518	8.000053	8.000053	-20.0	0.05	3
i8.41	4.6457653	-1.3747116327	8.000053	8.006937	-19.52266	0.05	3
i8.41	6.061351	-1.406520009	8.006937	8.008798	-19.333325	0.05	3
i8.41	7.4769287	-1.3948055506	8.008798	8.011258	-19.116673	0.05	3
i8.41	8.892514	-1.3902939558	8.011258	8.013102	-18.877792	0.05	3
i8.41	10.3081	-1.3518037796	8.013102	8.015492	-18.726265	0.05	3
i8.41	11.723678	-1.3708723783	8.015492	8.018205	-18.525651	0.05	3
i8.41	13.139264	-1.3532884121	8.018205	8.015616	-18.282048	0.05	3
i8.41	14.554849	-1.4130986929	8.015616	8.026362	-18.165654	0.05	3
i8.41	15.9704275	-1.3446691036	8.026362	8.023303	-17.835946	0.05	3
i8.41	17.386011	-1.3952759504	8.023303	8.028783	-17.73766	0.05	3
i8.41	18.801598	-1.3747347593	8.028783	8.032474	-17.597748	0.05	3
i8.41	20.217176	-1.3455969095	8.032474	8.031947	-17.537547	0.05	3
i8.41	21.632763	-1.3967648745	8.031947	8.035890	-17.198787	0.05	3
i8.41	23.048346	-1.3718111515	8.035890	8.038647	-17.148473	0.05	3
i8.41	24.463932	-1.3727325201	8.038647	8.035009	-16.719182	0.05	3
i8.41	25.87951	-1.356132865	8.035009	8.042211	-16.400403	0.05	3
i8.41	27.295097	-1.3924868107	8.042211	8.046076	-16.414055	0.05	3
i8.41	28.71068	-1.4070836306	8.046076	8.055684	-16.225489	0.05	3
i8.41	30.126259	-1.4033799171	8.055684	8.050023	-16.318933	0.05	3
i8.41	31.541845	-1.4033609629	8.050023	8.053708	-15.903582	0.05	3
i8.41	32.95743	-1.4049090147	8.053708	8.048530	-15.839615	0.05	3
i8.41	34.37301	-1.3915208578	8.048530	8.045336	-15.277759	0.05	3
i8.41	35.788597	-1.350966692	8.045336	8.042724	-15.07074	0.05	3
i8.41	37.204178	-1.3451036215	8.042724	8.040283	-15.173077	0.05	3
i8.41	38.619762	-1.3924341202	8.040283	8.037584	-14.703861	0.05	3
i8.41	40.035343	-1.3537430763	8.037584	8.033951	-14.381012	0.05	3
i8.41	41.450928	-1.4109941721	8.033951	8.033352	-15.151683	0.05	3
i8.41	42.866516	-1.3844219446	8.033352	8.032410	-14.591067	0.05	3
i8.41	44.282093	-1.4087904692	8.032410	8.030648	-15.356842	0.05	3
i8.41	45.697678	-1.401679635	8.030648	8.029609	-15.074661	0.05	3
i8.41	47.113266	-1.355039835	8.029609	8.029529	-14.952461	0.05	3
i8.41	48.52884	-1.3958665133	8.029529	8.029557	-14.689568	0.05	3
i8.41	49.944427	-1.3831728697	8.029557	8.029573	-15.032547	0.05	3
i8.41	51.360012	-1.3912955523	8.029573	8.029550	-14.633958	0.05	3
i8.41	52.775597	-1.3434422016	8.029550	8.029516	-15.037218	0.05	3
i8.41	54.191177	-1.4039819241	8.029516	8.029460	-15.104056	0.05	3
i8.41	55.606762	-1.3964022398	8.029460	8.029470	-14.912477	0.05	3
i8.41	57.022346	-1.3809037209	8.029470	8.029685	-15.245379	0.05	3
i8.41	58.437923	-1.3906315565	8.029685	8.029640	-15.042465	0.05	3
i8.41	59.85351	-1.3827164173	8.029640	8.029573	-16.150273	0.05	3
i8.41	61.269096	-1.4127885103	8.029573	8.029590	-19.484967	0.05	3
i8.41	62.684677	-1.3576655388	8.029590	8.029494	-22.981522	0.05	3
i8.41	64.10026	-1.3648450375	8.029494	8.029599	-26.334407	0.05	3
i8.41	65.51584	-1.356316328	8.029599	8.029683	-29.586821	0.05	3
i8.41	66.931435	-1.364913702	8.029683	8.029619	-32.958053	0.05	3
i8.41	68.34701	-1.3511507511	8.029619	8.029505	-36.321313	0.05	3
i8.41	69.762596	-1.3887147903	8.029505	8.029491	-39.831952	0.05	3
i8.41	71.17818	-1.4121462107	8.029491	8.029702	-43.20084	0.05	3
i8.41	72.59376	1.3939057589	8.029702	8.029468	-46.611813	0.05	3
i8.42	2.9910011	-1.3586847782	8.000070	8.000070	-20.0	0.1	3
i8.42	4.411369	-1.397881031	8.000070	8.005645	-19.554112	0.1	3
i8.42	5.831729	-1.3581351042	8.005645	8.009095	-19.352283	0.1	3
i8.42	7.2520967	-1.3890602589	8.009095	8.008807	-19.173157	0.1	3
i8.42	8.672463	-1.4102156162	8.008807	8.012644	-18.955548	0.1	3
i8.42	10.092833	-1.3591327667	8.012644	8.018599	-18.714059	0.1	3
i8.42	11.5132	-1.3685631752	8.018599	8.019804	-18.528857	0.1	3
i8.42	12.933567	-1.4118131399	8.019804	8.022085	-18.324991	0.1	3
i8.42	14.353934	-1.4104593992	8.022085	8.022566	-18.035573	0.1	3
i8.42	15.774302	-1.3926390409	8.022566	8.030154	-18.010312	0.1	3
i8.42	17.19467	-1.4154340029	8.030154	8.028027	-17.622011	0.1	3
i8.42	18.615036	-1.3999381065	8.028027	8.026699	-17.563773	0.1	3
i8.42	20.035404	-1.3718861341	8.026699	8.032387	-17.334559	0.1	3
i8.42	21.455765	-1.3646271229	8.032387	8.029536	-17.351621	0.1	3
i8.42	22.876133	-1.3513636589	8.029536	8.033459	-16.986151	0.1	3
i8.42	24.2965	-1.3998192549	8.033459	8.042017	-16.717153	0.1	3
i8.42	25.716867	-1.3918476105	8.042017	8.041801	-16.558305	0.1	3
i8.42	27.137234	-1.4080145359	8.041801	8.043693	-16.127216	0.1	3
i8.42	28.557602	-1.3717046976	8.043693	8.044576	-16.16668	0.1	3
i8.42	29.977972	-1.369887948	8.044576	8.051463	-16.020608	0.1	3
i8.42	31.398336	-1.3920949697	8.051463	8.049744	-15.860943	0.1	3
i8.42	32.818707	-1.4194248915	8.049744	8.047569	-15.882099	0.1	3
i8.42	34.23907	-1.4153350592	8.047569	8.049920	-15.573645	0.1	3
i8.42	35.659443	-1.3866893053	8.049920	8.045072	-15.407921	0.1	3
i8.42	37.0798	-1.390158534	8.045072	8.049330	-14.78128	0.1	3
i8.42	38.500168	-1.374412179	8.049330	8.048615	-14.631154	0.1	3
i8.42	39.920536	-1.3970303535	8.048615	8.049335	-14.850165	0.1	3
i8.42	41.340904	-1.3829472065	8.049335	8.051433	-15.044713	0.1	3
i8.42	42.76127	-1.3961969614	8.051433	8.050046	-14.766808	0.1	3
i8.42	44.18164	-1.4015425444	8.050046	8.049090	-14.676292	0.1	3
i8.42	45.60201	-1.3510118723	8.049090	8.049657	-14.999135	0.1	3
i8.42	47.022373	-1.3734107018	8.049657	8.049742	-15.19311	0.1	3
i8.42	48.44274	-1.3920607567	8.049742	8.049398	-15.159472	0.1	3
i8.42	49.86311	-1.3550226688	8.049398	8.049757	-15.162819	0.1	3
i8.42	51.28347	-1.4162026644	8.049757	8.049682	-14.764992	0.1	3
i8.42	52.70384	-1.3942189217	8.049682	8.049602	-14.819691	0.1	3
i8.42	54.124207	-1.3667107821	8.049602	8.049596	-15.126489	0.1	3
i8.42	55.54457	-1.4079442024	8.049596	8.049465	-15.084842	0.1	3
i8.42	56.96494	-1.3655056953	8.049465	8.049516	-15.052364	0.1	3
i8.42	58.385307	-1.3505314589	8.049516	8.049485	-14.955237	0.1	3
i8.42	59.80567	-1.3900358677	8.049485	8.049472	-16.411949	0.1	3
i8.42	61.226044	-1.383105278	8.049472	8.049662	-19.074536	0.1	3
i8.42	62.64641	-1.3594368696	8.049662	8.049423	-22.628336	0.1	3
i8.42	64.06677	-1.3498324156	8.049423	8.049620	-25.960673	0.1	3
i8.42	65.487144	-1.4024630785	8.049620	8.049564	-29.63092	0.1	3
i8.42	66.90751	-1.3825782537	8.049564	8.049503	-33.039702	0.1	3
i8.42	68.32787	-1.3926515579	8.049503	8.049561	-36.376024	0.1	3
i8.42	69.74824	-1.3614176512	8.049561	8.049588	-39.718929	0.1	3
i8.42	71.1686	-1.3867280483	8.049588	8.049534	-43.217449	0.1	3
i8.42	72.588974	1.3723803759	8.049534	8.049529	-46.599089	0.1	3
i8.43	2.1378067	-1.3752762079	8.000050	8.000050	-20.0	0.15	3
i8.43	3.5752366	-1.4200478792	8.000050	8.004684	-19.644921	0.15	3
i8.43	5.0126667	-1.429805398	8.004684	8.006197	-19.45535	0.15	3
i8.43	6.450096	-1.383810997	8.006197	8.008765	-19.250876	0.15	3
i8.43	7.887526	-1.3838834763	8.008765	8.011398	-19.005171	0.15	3
i8.43	9.324964	-1.3685748577	8.011398	8.015700	-18.8807	0.15	3
i8.43	10.762393	-1.4203994274	8.015700	8.018534	-18.652289	0.15	3
i8.43	12.199823	-1.3943259716	8.018534	8.018936	-18.568649	0.15	3
i8.43	13.637253	-1.3796190023	8.018936	8.018488	-18.24728	0.15	3
i8.43	15.074682	-1.4342932701	8.018488	8.027599	-17.940584	0.15	3
i8.43	16.512112	-1.4294120073	8.027599	8.028940	-17.826959	0.15	3
i8.43	17.949543	-1.4102632999	8.028940	8.027684	-17.799914	0.15	3
i8.43	19.386972	-1.4112892151	8.027684	8.031469	-17.412608	0.15	3
i8.43	20.82441	-1.3753174543	8.031469	8.037950	-17.538727	0.15	3
i8.43	22.26184	-1.4291573763	8.037950	8.038728	-17.136947	0.15	3
i8.43	23.69927	-1.3926143646	8.038728	8.038297	-16.895358	0.15	3
i8.43	25.1367	-1.4233231544	8.038297	8.038861	-16.717399	0.15	3
i8.43	26.57413	-1.3980031013	8.038861	8.040894	-16.516485	0.15	3
i8.43	28.011559	-1.4343965054	8.040894	8.046578	-16.366864	0.15	3
i8.43	29.448988	-1.4082405567	8.046578	8.044827	-16.150713	0.15	3
i8.43	30.886417	-1.391996026	8.044827	8.039798	-15.873819	0.15	3
i8.43	32.323856	-1.4111891985	8.039798	8.048201	-15.542973	0.15	3
i8.43	33.761288	-1.4300531149	8.048201	8.048115	-15.531694	0.15	3
i8.43	35.198715	-1.3955744505	8.048115	8.050902	-15.368349	0.15	3
i8.43	36.636147	-1.4279319048	8.050902	8.049532	-15.026107	0.15	3
i8.43	38.073574	-1.3812606335	8.049532	8.051133	-15.567738	0.15	3
i8.43	39.511005	-1.3987300396	8.051133	8.051749	-15.0217	0.15	3
i8.43	40.948433	-1.4371654987	8.051749	8.049467	-14.853614	0.15	3
i8.43	42.385864	-1.4331516027	8.049467	8.048824	-14.817173	0.15	3
i8.43	43.823296	-1.3940075636	8.048824	8.050085	-15.037352	0.15	3
i8.43	45.26073	-1.3804879189	8.050085	8.049464	-15.036638	0.15	3
i8.43	46.698162	-1.4193640947	8.049464	8.049365	-15.032107	0.15	3
i8.43	48.13559	-1.4329221249	8.049365	8.049604	-15.201728	0.15	3
i8.43	49.57302	-1.3986821175	8.049604	8.049704	-14.964238	0.15	3
i8.43	51.010452	-1.4219819307	8.049704	8.049498	-14.980012	0.15	3
i8.43	52.44788	-1.3772325516	8.049498	8.049590	-15.031798	0.15	3
i8.43	53.88531	-1.4176200628	8.049590	8.049596	-14.981765	0.15	3
i8.43	55.32274	-1.4292228222	8.049596	8.049596	-15.140484	0.15	3
i8.43	56.760178	-1.4316945076	8.049596	8.049478	-14.962031	0.15	3
i8.43	58.19761	-1.4196679592	8.049478	8.049385	-14.969945	0.15	3
i8.43	59.635036	-1.3857941628	8.049385	8.049594	-15.551889	0.15	3
i8.43	61.072468	-1.3960909843	8.049594	8.049552	-19.029661	0.15	3
i8.43	62.5099	-1.425642252	8.049552	8.049620	-22.633673	0.15	3
i8.43	63.947323	-1.3747953176	8.049620	8.049383	-25.801443	0.15	3
i8.43	65.38476	-1.4136863947	8.049383	8.049757	-29.355871	0.15	3
i8.43	66.82219	-1.379298687	8.049757	8.049701	-32.83069	0.15	3
i8.43	68.25963	-1.3793280125	8.049701	8.049506	-36.281116	0.15	3
i8.43	69.69706	-1.3924802542	8.049506	8.049443	-39.670733	0.15	3
i8.43	71.13448	-1.420121789	8.049443	8.049690	-43.073953	0.15	3
i8.43	72.571915	1.4280878305	8.049690	8.049607	-46.553095	0.15	3
i8.44	3.2281065	-1.4138036966	8.000042	8.000042	-20.0	0.2	3
i8.44	4.6437283	-1.3952945471	8.000042	8.006754	-19.521445	0.2	3
i8.44	6.0593576	-1.3535895348	8.006754	8.008128	-19.358506	0.2	3
i8.44	7.47498	-1.3872692585	8.008128	8.012034	-19.143415	0.2	3
i8.44	8.890601	-1.3581469059	8.012034	8.014496	-18.919591	0.2	3
i8.44	10.306231	-1.4050078392	8.014496	8.015410	-18.648425	0.2	3
i8.44	11.721853	-1.4075777531	8.015410	8.019543	-18.541531	0.2	3
i8.44	13.137483	-1.3892562389	8.019543	8.019899	-18.327243	0.2	3
i8.44	14.553103	-1.348346591	8.019899	8.024930	-18.143624	0.2	3
i8.44	15.968725	-1.385735631	8.024930	8.027038	-17.951844	0.2	3
i8.44	17.384356	-1.3825415373	8.027038	8.027702	-18.0674	0.2	3
i8.44	18.799976	-1.4065986872	8.027702	8.027683	-17.636437	0.2	3
i8.44	20.2156	-1.3945271969	8.027683	8.031771	-17.497183	0.2	3
i8.44	21.63123	-1.3463956118	8.031771	8.035844	-17.104189	0.2	3
i8.44	23.04685	-1.4043962955	8.035844	8.031518	-17.083723	0.2	3
i8.44	24.46248	-1.371647954	8.031518	8.034682	-16.520518	0.2	3
i8.44	25.878101	-1.3508419991	8.034682	8.044728	-16.785004	0.2	3
i8.44	27.293724	-1.3479100466	8.044728	8.048542	-16.273252	0.2	3
i8.44	28.709352	-1.3778102398	8.048542	8.052753	-16.074226	0.2	3
i8.44	30.124975	-1.3576046228	8.052753	8.051014	-15.841482	0.2	3
i8.44	31.540602	-1.3733887672	8.051014	8.047456	-15.944636	0.2	3
i8.44	32.956226	-1.3764467239	8.047456	8.047157	-15.440312	0.2	3
i8.44	34.37185	-1.4090390205	8.047157	8.043909	-15.246055	0.2	3
i8.44	35.78748	-1.4107044935	8.043909	8.043437	-15.268832	0.2	3
i8.44	37.2031	-1.3518844843	8.043437	8.042951	-14.830496	0.2	3
i8.44	38.61872	-1.3586479425	8.042951	8.038248	-14.94252	0.2	3
i8.44	40.03435	-1.3478058577	8.038248	8.038083	-15.125423	0.2	3
i8.44	41.44997	-1.399058938	8.038083	8.033883	-15.116312	0.2	3
i8.44	42.8656	-1.3601607084	8.033883	8.032792	-15.418464	0.2	3
i8.44	44.281223	-1.4062590599	8.032792	8.030238	-14.992096	0.2	3
i8.44	45.696846	-1.3925791979	8.030238	8.029623	-15.285665	0.2	3
i8.44	47.112476	-1.3973065615	8.029623	8.029700	-15.040507	0.2	3
i8.44	48.528095	-1.3956569433	8.029700	8.029572	-14.847562	0.2	3
i8.44	49.943726	-1.3970022202	8.029572	8.029534	-14.557286	0.2	3
i8.44	51.35935	-1.3435031176	8.029534	8.029546	-15.261763	0.2	3
i8.44	52.77497	-1.3688020706	8.029546	8.029668	-15.287056	0.2	3
i8.44	54.190598	-1.3805068731	8.029668	8.029659	-14.810321	0.2	3
i8.44	55.606224	-1.4106274843	8.029659	8.029548	-14.618443	0.2	3
i8.44	57.021843	-1.3803412914	8.029548	8.029583	-14.817943	0.2	3
i8.44	58.43747	-1.3819004297	8.029583	8.029579	-15.223129	0.2	3
i8.44	59.853096	-1.3552167416	8.029579	8.029453	-15.934743	0.2	3
i8.44	61.268726	-1.3636711836	8.029453	8.029527	-19.82159	0.2	3
i8.44	62.684345	-1.3814431429	8.029527	8.029653	-22.937651	0.2	3
i8.44	64.09997	-1.3968458176	8.029653	8.029679	-26.250211	0.2	3
i8.44	65.5156	-1.3908904791	8.029679	8.029346	-29.554166	0.2	3
i8.44	66.93121	-1.3970743418	8.029346	8.029650	-33.180072	0.2	3
i8.44	68.34684	-1.3438146114	8.029650	8.029541	-36.29394	0.2	3
i8.44	69.762474	-1.3999502659	8.029541	8.029576	-39.775657	0.2	3
i8.44	71.17809	-1.4155138731	8.029576	8.029662	-43.18764	0.2	3
i8.44	72.59372	1.3908487558	8.029662	8.029742	-46.638715	0.2	3
i8.45	1.3746328	-1.4339841604	8.000050	8.000050	-20.0	0.25	3
i8.45	2.8273218	-1.3972448111	8.000050	8.002843	-19.728906	0.25	3
i8.45	4.2800174	-1.4053715467	8.002843	8.006056	-19.570601	0.25	3
i8.45	5.7327137	-1.4073066711	8.006056	8.007060	-19.404255	0.25	3
i8.45	7.18541	-1.3833631277	8.007060	8.010506	-19.132332	0.25	3
i8.45	8.638099	-1.3999843597	8.010506	8.015783	-18.952499	0.25	3
i8.45	10.090795	-1.3838700056	8.015783	8.016088	-18.808702	0.25	3
i8.45	11.543491	-1.3801201582	8.016088	8.019844	-18.426682	0.25	3
i8.45	12.996187	-1.4082405567	8.019844	8.019299	-18.436164	0.25	3
i8.45	14.448875	-1.4259531498	8.019299	8.020405	-18.182791	0.25	3
i8.45	15.901571	-1.4193938971	8.020405	8.025713	-18.01544	0.25	3
i8.45	17.354269	-1.4526588917	8.025713	8.031173	-17.87351	0.25	3
i8.45	18.806965	-1.4518158436	8.031173	8.028833	-17.497044	0.25	3
i8.45	20.259653	-1.3905097246	8.028833	8.032146	-17.495816	0.25	3
i8.45	21.712349	-1.4471011162	8.032146	8.032345	-17.010637	0.25	3
i8.45	23.165045	-1.4142522812	8.032345	8.033634	-16.92677	0.25	3
i8.45	24.617743	-1.4278311729	8.033634	8.039780	-16.966913	0.25	3
i8.45	26.07043	-1.4033273458	8.039780	8.046138	-16.413952	0.25	3
i8.45	27.523125	-1.4360123873	8.046138	8.045243	-16.339663	0.25	3
i8.45	28.975822	-1.4086867571	8.045243	8.050117	-16.153918	0.25	3
i8.45	30.428518	-1.4078269005	8.050117	8.044678	-15.784686	0.25	3
i8.45	31.881208	-1.4414784908	8.044678	8.056368	-15.695821	0.25	3
i8.45	33.3339	-1.438400507	8.056368	8.045076	-15.763668	0.25	3
i8.45	34.7866	-1.4345237017	8.045076	8.048533	-15.592873	0.25	3
i8.45	36.239296	-1.4252151251	8.048533	8.046110	-15.4271	0.25	3
i8.45	37.691986	-1.3917946815	8.046110	8.053552	-15.237741	0.25	3
i8.45	39.14468	-1.4449924231	8.053552	8.051019	-15.128772	0.25	3
i8.45	40.597378	-1.4074189663	8.051019	8.050322	-14.956595	0.25	3
i8.45	42.050076	-1.4463964701	8.050322	8.048951	-15.094965	0.25	3
i8.45	43.50276	-1.4160112143	8.048951	8.049917	-15.070273	0.25	3
i8.45	44.955456	-1.4156424999	8.049917	8.049569	-15.093266	0.25	3
i8.45	46.408154	-1.4510151148	8.049569	8.049571	-14.907593	0.25	3
i8.45	47.860847	-1.4464770555	8.049571	8.049743	-14.985856	0.25	3
i8.45	49.313538	-1.4519386292	8.049743	8.049396	-15.125889	0.25	3
i8.45	50.766235	-1.3873541355	8.049396	8.049539	-15.238411	0.25	3
i8.45	52.218933	-1.4070025682	8.049539	8.049494	-14.810834	0.25	3
i8.45	53.671627	-1.4050124884	8.049494	8.049569	-15.187933	0.25	3
i8.45	55.124317	-1.4273463488	8.049569	8.049527	-15.087959	0.25	3
i8.45	56.577015	-1.4017397165	8.049527	8.049512	-14.744121	0.25	3
i8.45	58.029705	-1.3811284304	8.049512	8.049713	-14.85516	0.25	3
i8.45	59.482407	-1.4055981636	8.049713	8.049376	-14.859568	0.25	3
i8.45	60.935093	-1.4502580166	8.049376	8.049566	-18.534152	0.25	3
i8.45	62.387787	-1.4342827797	8.049566	8.049451	-22.089747	0.25	3
i8.45	63.84049	-1.395006299	8.049451	8.049661	-25.786517	0.25	3
i8.45	65.29318	-1.4218736887	8.049661	8.049563	-28.974621	0.25	3
i8.45	66.745865	-1.4429181814	8.049563	8.049610	-32.393184	0.25	3
i8.45	68.19857	-1.3799253702	8.049610	8.049708	-36.119947	0.25	3
i8.45	69.65126	-1.4002438784	8.049708	8.049622	-39.604744	0.25	3
i8.45	71.10396	-1.4299272299	8.049622	8.049627	-42.996831	0.25	3
i8.45	72.55665	1.3846545219	8.049627	8.049480	-46.518336	0.25	3
i8.46	2.1795754	-1.401668787	8.000059	8.000059	-20.0	0.3	3
i8.46	3.616173	-1.3796648979	8.000059	8.004812	-19.638752	0.3	3
i8.46	5.052763	-1.3961865902	8.004812	8.006232	-19.415597	0.3	3
i8.46	6.489361	-1.374560833	8.006232	8.009963	-19.245755	0.3	3
i8.46	7.925958	-1.4330481291	8.009963	8.011552	-19.083428	0.3	3
i8.46	9.362549	-1.4004892111	8.011552	8.015663	-18.834195	0.3	3
i8.46	10.799147	-1.4186713696	8.015663	8.019150	-18.711521	0.3	3
i8.46	12.2357435	-1.3648486137	8.019150	8.020001	-18.507201	0.3	3
i8.46	13.672334	-1.3857218027	8.020001	8.025999	-18.344427	0.3	3
i8.46	15.108932	-1.431748867	8.025999	8.023718	-17.924798	0.3	3
i8.46	16.545528	-1.4164592028	8.023718	8.026041	-17.91004	0.3	3
i8.46	17.982126	-1.4222187996	8.026041	8.025692	-17.645223	0.3	3
i8.46	19.418716	-1.4199721813	8.025692	8.032609	-17.491042	0.3	3
i8.46	20.855314	-1.3832048178	8.032609	8.033411	-17.329468	0.3	3
i8.46	22.291912	-1.4291498661	8.033411	8.032291	-17.188548	0.3	3
i8.46	23.728502	-1.3854084015	8.032291	8.041619	-16.882073	0.3	3
i8.46	25.1651	-1.389973402	8.041619	8.043042	-16.62011	0.3	3
i8.46	26.601698	-1.3936313391	8.043042	8.045950	-16.248151	0.3	3
i8.46	28.038288	-1.4162591696	8.045950	8.041296	-16.277479	0.3	3
i8.46	29.474886	-1.418708086	8.041296	8.047743	-16.06817	0.3	3
i8.46	30.911484	-1.3664090633	8.047743	8.057568	-16.053811	0.3	3
i8.46	32.34808	-1.395496726	8.057568	8.052356	-15.781474	0.3	3
i8.46	33.78467	-1.3816218376	8.052356	8.057175	-15.478987	0.3	3
i8.46	35.221268	-1.3735481501	8.057175	8.055614	-15.23904	0.3	3
i8.46	36.657867	-1.3714587688	8.055614	8.059785	-14.966763	0.3	3
i8.46	38.094456	-1.3854328394	8.059785	8.062821	-15.027421	0.3	3
i8.46	39.531055	-1.4128553867	8.062821	8.062524	-14.793905	0.3	3
i8.46	40.96765	-1.435111165	8.062524	8.064942	-14.990713	0.3	3
i8.46	42.40425	-1.4166703224	8.064942	8.066064	-14.979901	0.3	3
i8.46	43.84084	-1.4078775644	8.066064	8.068258	-15.040771	0.3	3
i8.46	45.27744	-1.3708523512	8.068258	8.069525	-15.182452	0.3	3
i8.46	46.714035	-1.398640275	8.069525	8.069394	-15.076394	0.3	3
i8.46	48.150623	-1.395272851	8.069394	8.069680	-14.727087	0.3	3
i8.46	49.587223	-1.3686050177	8.069680	8.069495	-14.639982	0.3	3
i8.46	51.02382	-1.417534709	8.069495	8.069632	-15.300532	0.3	3
i8.46	52.46041	-1.4362487793	8.069632	8.069538	-14.79044	0.3	3
i8.46	53.897007	-1.3762959242	8.069538	8.069466	-15.042895	0.3	3
i8.46	55.333603	-1.4273401499	8.069466	8.069409	-15.065228	0.3	3
i8.46	56.7702	-1.3667504787	8.069409	8.069596	-14.661457	0.3	3
i8.46	58.206795	-1.4124288559	8.069596	8.069598	-14.980186	0.3	3
i8.46	59.64339	-1.4138541222	8.069598	8.069615	-15.570468	0.3	3
i8.46	61.079987	-1.3919842243	8.069615	8.069431	-18.963545	0.3	3
i8.46	62.51658	-1.3947963715	8.069431	8.069427	-22.411637	0.3	3
i8.46	63.95317	-1.3910317421	8.069427	8.069596	-25.865903	0.3	3
i8.46	65.38978	-1.3777500391	8.069596	8.069518	-29.330023	0.3	3
i8.46	66.82636	-1.3773106337	8.069518	8.069455	-32.708116	0.3	3
i8.46	68.26296	-1.4313752651	8.069455	8.069533	-36.233453	0.3	3
i8.46	69.699554	-1.4104830027	8.069533	8.069402	-39.698458	0.3	3
i8.46	71.13616	-1.3696724176	8.069402	8.069509	-43.163076	0.3	3
i8.46	72.57275	1.3964662552	8.069509	8.069442	-46.528044	0.3	3
i8.35	88.577545	-1.3457460403	8.097209	8.097209	-20.0	-0.25	3
i8.35	89.94879	-1.3663214445	8.097209	8.093750	-20.0	-0.25	3
i8.35	91.320045	-1.3523994684	8.093750	8.092292	-20.0	-0.25	3
i8.35	92.69131	-1.3517879248	8.092292	8.078902	-20.0	-0.25	3
i8.35	94.06256	-1.354549408	8.078902	8.082061	-20.0	-0.25	3
i8.35	95.43381	-1.3498946428	8.082061	8.078495	-20.0	-0.25	3
i8.35	96.80506	-1.3437207937	8.078495	8.078339	-20.0	-0.25	3
i8.35	98.176315	-1.354573369	8.078339	8.063304	-20.0	-0.25	3
i8.35	99.54758	-1.3611502647	8.063304	8.063108	-20.0	-0.25	3
i8.35	100.91882	-1.362760663	8.063108	8.055375	-20.0	-0.25	3
i8.35	102.29008	-1.3663173914	8.055375	8.051920	-20.0	-0.25	3
i8.35	103.66133	-1.3560248613	8.051920	8.044867	-20.0	-0.25	3
i8.35	105.032585	-1.3604590893	8.044867	8.040000	-20.0	-0.25	3
i8.35	106.40384	-1.3696171045	8.040000	8.040000	-20.0	-0.25	3
i8.35	107.77509	-1.356797576	8.040000	8.040000	-20.0	-0.25	3
i8.35	109.14635	-1.3553637266	8.040000	8.040000	-20.0	-0.25	3
i8.35	110.5176	-1.3693480492	8.040000	8.040000	-20.0	-0.25	3
i8.35	111.888855	-1.3503537178	8.040000	8.040000	-20.0	-0.25	3
i8.35	113.26011	-1.3537900448	8.040000	8.040000	-20.442844	-0.25	3
i8.35	114.63136	1.3589761257	8.040000	8.040000	-35.221422	-0.25	3
i8.36	89.22143	-1.3326513767	8.107579	8.107579	-20.0	-0.2	3
i8.36	90.56049	-1.3158321381	8.107579	8.094263	-20.0	-0.2	3
i8.36	91.89955	-1.3307281733	8.094263	8.099266	-20.0	-0.2	3
i8.36	93.23861	-1.3341934681	8.099266	8.082172	-20.0	-0.2	3
i8.36	94.57767	-1.3348932266	8.082172	8.070944	-20.0	-0.2	3
i8.36	95.916725	-1.3201428652	8.070944	8.064997	-20.0	-0.2	3
i8.36	97.25578	-1.3339409828	8.064997	8.058284	-20.0	-0.2	3
i8.36	98.59485	-1.3360625505	8.058284	8.053124	-20.0	-0.2	3
i8.36	99.93391	-1.3213350773	8.053124	8.046844	-20.0	-0.2	3
i8.36	101.272964	-1.3340767622	8.046844	8.037878	-20.0	-0.2	3
i8.36	102.61202	-1.3176517487	8.037878	8.031528	-20.0	-0.2	3
i8.36	103.95108	-1.3170832396	8.031528	8.024404	-20.0	-0.2	3
i8.36	105.290146	-1.3232449293	8.024404	8.020000	-20.0	-0.2	3
i8.36	106.6292	-1.3161205053	8.020000	8.020000	-20.0	-0.2	3
i8.36	107.96826	-1.3346576691	8.020000	8.020000	-20.0	-0.2	3
i8.36	109.30733	-1.3237746954	8.020000	8.020000	-20.0	-0.2	3
i8.36	110.64638	-1.3262677193	8.020000	8.020000	-20.0	-0.2	3
i8.36	111.98544	-1.3244847059	8.020000	8.020000	-20.0	-0.2	3
i8.36	113.3245	-1.3259940147	8.020000	8.020000	-21.136791	-0.2	3
i8.36	114.66356	1.3172857761	8.020000	8.020000	-35.568395	-0.2	3
i8.37	88.16799	-1.3669117689	8.106089	8.106089	-20.0	-0.15	3
i8.37	89.55972	-1.3726612329	8.106089	8.098904	-20.0	-0.15	3
i8.37	90.951454	-1.3892396688	8.098904	8.090027	-20.0	-0.15	3
i8.37	92.343185	-1.3725534678	8.090027	8.095846	-20.0	-0.15	3
i8.37	93.73492	-1.3826450109	8.095846	8.082037	-20.0	-0.15	3
i8.37	95.12665	-1.3822505474	8.082037	8.083866	-20.0	-0.15	3
i8.37	96.51838	-1.3714272976	8.083866	8.072657	-20.0	-0.15	3
i8.37	97.91011	-1.385165453	8.072657	8.067699	-20.0	-0.15	3
i8.37	99.30184	-1.3870427608	8.067699	8.061565	-20.0	-0.15	3
i8.37	100.69357	-1.3888781071	8.061565	8.058266	-20.0	-0.15	3
i8.37	102.085304	-1.3773546219	8.058266	8.049028	-20.0	-0.15	3
i8.37	103.477036	-1.376188159	8.049028	8.045524	-20.0	-0.15	3
i8.37	104.86877	-1.3847436905	8.045524	8.040000	-20.0	-0.15	3
i8.37	106.2605	-1.3718242645	8.040000	8.040000	-20.0	-0.15	3
i8.37	107.65223	-1.37728405	8.040000	8.040000	-20.0	-0.15	3
i8.37	109.04396	-1.3805873394	8.040000	8.040000	-20.0	-0.15	3
i8.37	110.43569	-1.3663802147	8.040000	8.040000	-20.0	-0.15	3
i8.37	111.82742	-1.3857730627	8.040000	8.040000	-20.0	-0.15	3
i8.37	113.219154	-1.3801417351	8.040000	8.040000	-20.001455	-0.15	3
i8.37	114.610886	1.382968545	8.040000	8.040000	-35.000728	-0.15	3
i8.38	88.606064	-1.3536041975	8.096917	8.096917	-20.0	-0.1	3
i8.38	89.97589	-1.3660485744	8.096917	8.106602	-20.0	-0.1	3
i8.38	91.34572	-1.3490086794	8.106602	8.089429	-20.0	-0.1	3
i8.38	92.715546	-1.3641490936	8.089429	8.079935	-20.0	-0.1	3
i8.38	94.08537	-1.3637390137	8.079935	8.070122	-20.0	-0.1	3
i8.38	95.4552	-1.3426636457	8.070122	8.065329	-20.0	-0.1	3
i8.38	96.82503	-1.3461936712	8.065329	8.062338	-20.0	-0.1	3
i8.38	98.194855	-1.3516725302	8.062338	8.060472	-20.0	-0.1	3
i8.38	99.56468	-1.3656209707	8.060472	8.044282	-20.0	-0.1	3
i8.38	100.93452	-1.3658130169	8.044282	8.038831	-20.0	-0.1	3
i8.38	102.304344	-1.3456362486	8.038831	8.032427	-20.0	-0.1	3
i8.38	103.67417	-1.3622826338	8.032427	8.025712	-20.0	-0.1	3
i8.38	105.044	-1.3541764021	8.025712	8.020000	-20.0	-0.1	3
i8.38	106.413826	-1.343953371	8.020000	8.020000	-20.0	-0.1	3
i8.38	107.78365	-1.3681586981	8.020000	8.020000	-20.0	-0.1	3
i8.38	109.15348	-1.356061697	8.020000	8.020000	-20.0	-0.1	3
i8.38	110.52331	-1.3586176634	8.020000	8.020000	-20.0	-0.1	3
i8.38	111.893135	-1.3466812372	8.020000	8.020000	-20.0	-0.1	3
i8.38	113.26296	-1.3525497913	8.020000	8.020000	-20.473585	-0.1	3
i8.38	114.63279	1.3438388109	8.020000	8.020000	-35.236793	-0.1	3
i8.39	88.830414	-1.3429857492	8.102889	8.102889	-20.0	-0.05	3
i8.39	90.189026	-1.3391128778	8.102889	8.085482	-20.0	-0.05	3
i8.39	91.54764	-1.3490679264	8.085482	8.083322	-20.0	-0.05	3
i8.39	92.90624	-1.3584239483	8.083322	8.073010	-20.0	-0.05	3
i8.39	94.264854	-1.3446292877	8.073010	8.073954	-20.0	-0.05	3
i8.39	95.62347	-1.3577004671	8.073954	8.058946	-20.0	-0.05	3
i8.39	96.98208	-1.3445410728	8.058946	8.049575	-20.0	-0.05	3
i8.39	98.34069	-1.3569585085	8.049575	8.042490	-20.0	-0.05	3
i8.39	99.699295	-1.3462011814	8.042490	8.033987	-20.0	-0.05	3
i8.39	101.05791	-1.3546760082	8.033987	8.024875	-20.0	-0.05	3
i8.39	102.41652	-1.3376605511	8.024875	8.015314	-20.0	-0.05	3
i8.39	103.77513	-1.3387867212	8.015314	8.006716	-20.0	-0.05	3
i8.39	105.133736	-1.3350614309	8.006716	8.000000	-20.0	-0.05	3
i8.39	106.49235	-1.3437956572	8.000000	8.000000	-20.0	-0.05	3
i8.39	107.85096	-1.3416256905	8.000000	8.000000	-20.0	-0.05	3
i8.39	109.209564	-1.3476704359	8.000000	8.000000	-20.0	-0.05	3
i8.39	110.56818	-1.3510409594	8.000000	8.000000	-20.0	-0.05	3
i8.39	111.92679	-1.3350063562	8.000000	8.000000	-20.0	-0.05	3
i8.39	113.2854	-1.3347988129	8.000000	8.000000	-20.715378	-0.05	3
i8.39	114.64401	1.3441026211	8.000000	8.000000	-35.357689	-0.05	3
i8.40	88.57467	-1.3476970196	8.103482	8.103482	-20.0	0.0	3
i8.40	89.94607	-1.3680756092	8.103482	8.096877	-20.0	0.0	3
i8.40	91.31747	-1.349337101	8.096877	8.083097	-20.0	0.0	3
i8.40	92.688866	-1.3651325703	8.083097	8.074611	-20.0	0.0	3
i8.40	94.06026	-1.3618559837	8.074611	8.068895	-20.0	0.0	3
i8.40	95.431656	-1.357845068	8.068895	8.060447	-20.0	0.0	3
i8.40	96.803055	-1.3672654629	8.060447	8.052387	-20.0	0.0	3
i8.40	98.17445	-1.3593045473	8.052387	8.038169	-20.0	0.0	3
i8.40	99.54585	-1.3578768969	8.038169	8.033591	-20.0	0.0	3
i8.40	100.917244	-1.3560254574	8.033591	8.025105	-20.0	0.0	3
i8.40	102.28864	-1.3657137156	8.025105	8.015743	-20.0	0.0	3
i8.40	103.66004	-1.3456448317	8.015743	8.007459	-20.0	0.0	3
i8.40	105.03143	-1.3503371477	8.007459	8.000000	-20.0	0.0	3
i8.40	106.40283	-1.3627603054	8.000000	8.000000	-20.0	0.0	3
i8.40	107.77423	-1.3523061275	8.000000	8.000000	-20.0	0.0	3
i8.40	109.14563	-1.3648247719	8.000000	8.000000	-20.0	0.0	3
i8.40	110.51703	-1.3524703979	8.000000	8.000000	-20.0	0.0	3
i8.40	111.88843	-1.3577721119	8.000000	8.000000	-20.0	0.0	3
i8.40	113.25983	-1.3555434942	8.000000	8.000000	-20.439751	0.0	3
i8.40	114.63122	1.3481487036	8.000000	8.000000	-35.219875	0.0	3
i8.41	88.44763	-1.3502854109	8.087003	8.087003	-20.0	0.05	3
i8.41	89.82538	-1.3504610062	8.087003	8.094169	-20.0	0.05	3
i8.41	91.203125	-1.3596304655	8.094169	8.099960	-20.0	0.05	3
i8.41	92.58088	-1.3764076233	8.099960	8.093287	-20.0	0.05	3
i8.41	93.958626	-1.3597764969	8.093287	8.081225	-20.0	0.05	3
i8.41	95.33637	-1.3630145788	8.081225	8.074983	-20.0	0.05	3
i8.41	96.71413	-1.373021841	8.074983	8.067642	-20.0	0.05	3
i8.41	98.09187	-1.3544675112	8.067642	8.071286	-20.0	0.05	3
i8.41	99.46962	-1.3634041548	8.071286	8.061814	-20.0	0.05	3
i8.41	100.847374	-1.3775770664	8.061814	8.057418	-20.0	0.05	3
i8.41	102.22512	-1.3603359461	8.057418	8.050703	-20.0	0.05	3
i8.41	103.602875	-1.3541631699	8.050703	8.044558	-20.0	0.05	3
i8.41	104.98062	-1.3637770414	8.044558	8.040000	-20.0	0.05	3
i8.41	106.35837	-1.3711316586	8.040000	8.040000	-20.0	0.05	3
i8.41	107.73612	-1.362385869	8.040000	8.040000	-20.0	0.05	3
i8.41	109.11387	-1.3525953293	8.040000	8.040000	-20.0	0.05	3
i8.41	110.49162	-1.3559503555	8.040000	8.040000	-20.0	0.05	3
i8.41	111.86937	-1.3723073006	8.040000	8.040000	-20.0	0.05	3
i8.41	113.247116	-1.3706127405	8.040000	8.040000	-20.302831	0.05	3
i8.41	114.62487	1.3574025631	8.040000	8.040000	-35.151415	0.05	3
i8.42	89.154076	-1.3215955496	8.093927	8.093927	-20.0	0.1	3
i8.42	90.496506	-1.3201134205	8.093927	8.096758	-20.0	0.1	3
i8.42	91.838936	-1.3290691376	8.096758	8.090581	-20.0	0.1	3
i8.42	93.18136	-1.3159897327	8.090581	8.084086	-20.0	0.1	3
i8.42	94.52379	-1.3220393658	8.084086	8.077564	-20.0	0.1	3
i8.42	95.86621	-1.3310605288	8.077564	8.070982	-20.0	0.1	3
i8.42	97.20864	-1.3417025805	8.070982	8.066948	-20.0	0.1	3
i8.42	98.55106	-1.3233293295	8.066948	8.063850	-20.0	0.1	3
i8.42	99.89349	-1.3299489021	8.063850	8.060023	-20.0	0.1	3
i8.42	101.23592	-1.33200109	8.060023	8.051705	-20.0	0.1	3
i8.42	102.57835	-1.3410868645	8.051705	8.046906	-20.0	0.1	3
i8.42	103.92078	-1.322671771	8.046906	8.043465	-20.0	0.1	3
i8.42	105.2632	-1.3256715536	8.043465	8.040000	-20.0	0.1	3
i8.42	106.60563	-1.324375391	8.040000	8.040000	-20.0	0.1	3
i8.42	107.94806	-1.3204878569	8.040000	8.040000	-20.0	0.1	3
i8.42	109.29048	-1.3295902014	8.040000	8.040000	-20.0	0.1	3
i8.42	110.63291	-1.3152915239	8.040000	8.040000	-20.0	0.1	3
i8.42	111.97534	-1.3262039423	8.040000	8.040000	-20.0	0.1	3
i8.42	113.317764	-1.3390542269	8.040000	8.040000	-21.064202	0.1	3
i8.42	114.660194	1.3224747181	8.040000	8.040000	-35.532101	0.1	3
i8.43	88.31347	-1.3844305277	8.095739	8.095739	-20.0	0.15	3
i8.43	89.69792	-1.3626953363	8.095739	8.098943	-20.0	0.15	3
i8.43	91.08238	-1.3722506762	8.098943	8.079356	-20.0	0.15	3
i8.43	92.46684	-1.3725376129	8.079356	8.082632	-20.0	0.15	3
i8.43	93.851295	-1.3665423393	8.082632	8.075496	-20.0	0.15	3
i8.43	95.235756	-1.3792722225	8.075496	8.065425	-20.0	0.15	3
i8.43	96.62021	-1.3572602272	8.065425	8.061789	-20.0	0.15	3
i8.43	98.00467	-1.3670041561	8.061789	8.054074	-20.0	0.15	3
i8.43	99.38913	-1.3609771729	8.054074	8.046265	-20.0	0.15	3
i8.43	100.77358	-1.3582029343	8.046265	8.044105	-20.0	0.15	3
i8.43	102.15804	-1.3811018467	8.044105	8.032458	-20.0	0.15	3
i8.43	103.5425	-1.3841586113	8.032458	8.026313	-20.0	0.15	3
i8.43	104.926956	-1.3680547476	8.026313	8.020000	-20.0	0.15	3
i8.43	106.31142	-1.3593342304	8.020000	8.020000	-20.0	0.15	3
i8.43	107.69588	-1.3682074547	8.020000	8.020000	-20.0	0.15	3
i8.43	109.08033	-1.370491147	8.020000	8.020000	-20.0	0.15	3
i8.43	110.46478	-1.3743187189	8.020000	8.020000	-20.0	0.15	3
i8.43	111.84924	-1.3801009655	8.020000	8.020000	-20.0	0.15	3
i8.43	113.2337	-1.3680382967	8.020000	8.020000	-20.15824	0.15	3
i8.43	114.618164	1.3818156719	8.020000	8.020000	-35.07912	0.15	3
i8.44	88.86937	-1.3527851105	8.096617	8.096617	-20.0	0.2	3
i8.44	90.22603	-1.3540971279	8.096617	8.083111	-20.0	0.2	3
i8.44	91.582695	-1.3483630419	8.083111	8.089654	-20.0	0.2	3
i8.44	92.939354	-1.355889678	8.089654	8.082247	-20.0	0.2	3
i8.44	94.29602	-1.3337923288	8.082247	8.079612	-20.0	0.2	3
i8.44	95.65268	-1.3311128616	8.079612	8.073724	-20.0	0.2	3
i8.44	97.009346	-1.3428313732	8.073724	8.070172	-20.0	0.2	3
i8.44	98.366005	-1.3393144608	8.070172	8.063992	-20.0	0.2	3
i8.44	99.72267	-1.3356535435	8.063992	8.055780	-20.0	0.2	3
i8.44	101.07933	-1.3409597874	8.055780	8.056186	-20.0	0.2	3
i8.44	102.43599	-1.3345400095	8.056186	8.049289	-20.0	0.2	3
i8.44	103.792656	-1.3356285095	8.049289	8.044625	-20.0	0.2	3
i8.44	105.14932	-1.3363633156	8.044625	8.040000	-20.0	0.2	3
i8.44	106.50598	-1.3350485563	8.040000	8.040000	-20.0	0.2	3
i8.44	107.86264	-1.3521983624	8.040000	8.040000	-20.0	0.2	3
i8.44	109.21931	-1.346362114	8.040000	8.040000	-20.0	0.2	3
i8.44	110.57597	-1.3423542976	8.040000	8.040000	-20.0	0.2	3
i8.44	111.93263	-1.3475580215	8.040000	8.040000	-20.0	0.2	3
i8.44	113.28929	-1.3520443439	8.040000	8.040000	-20.757358	0.2	3
i8.44	114.64596	1.3539944887	8.040000	8.040000	-35.378679	0.2	3
i8.45	88.58477	-1.3687616587	8.099640	8.099640	-20.0	0.25	3
i8.45	89.955666	-1.3463282585	8.099640	8.097564	-20.0	0.25	3
i8.45	91.32655	-1.3528898954	8.097564	8.071291	-20.0	0.25	3
i8.45	92.69745	-1.3698341846	8.071291	8.080278	-20.0	0.25	3
i8.45	94.06834	-1.3590928316	8.080278	8.069621	-20.0	0.25	3
i8.45	95.43923	-1.3708004951	8.069621	8.061228	-20.0	0.25	3
i8.45	96.81013	-1.366330266	8.061228	8.044417	-20.0	0.25	3
i8.45	98.181015	-1.3645839691	8.044417	8.040713	-20.0	0.25	3
i8.45	99.55191	-1.3626607656	8.040713	8.034428	-20.0	0.25	3
i8.45	100.9228	-1.3493722677	8.034428	8.021952	-20.0	0.25	3
i8.45	102.29369	-1.3651999235	8.021952	8.014242	-20.0	0.25	3
i8.45	103.66459	-1.3697082996	8.014242	8.007209	-20.0	0.25	3
i8.45	105.03548	-1.3669047356	8.007209	8.000000	-20.0	0.25	3
i8.45	106.40637	-1.3481842279	8.000000	8.000000	-20.0	0.25	3
i8.45	107.77726	-1.351479888	8.000000	8.000000	-20.0	0.25	3
i8.45	109.148155	-1.360991478	8.000000	8.000000	-20.0	0.25	3
i8.45	110.51904	-1.3502187729	8.000000	8.000000	-20.0	0.25	3
i8.45	111.88994	-1.3609939814	8.000000	8.000000	-20.0	0.25	3
i8.45	113.26083	-1.3600405455	8.000000	8.000000	-20.450633	0.25	3
i8.45	114.63173	1.3444782495	8.000000	8.000000	-35.225317	0.25	3
i8.46	88.49229	-1.3591542244	8.102167	8.102167	-20.0	0.3	3
i8.46	89.867805	-1.3496041298	8.102167	8.105265	-20.0	0.3	3
i8.46	91.243324	-1.3663743734	8.105265	8.086851	-20.0	0.3	3
i8.46	92.618835	-1.3750566244	8.086851	8.080919	-20.0	0.3	3
i8.46	93.994354	-1.3692592382	8.080919	8.070443	-20.0	0.3	3
i8.46	95.36987	-1.3731325865	8.070443	8.064129	-20.0	0.3	3
i8.46	96.745384	-1.3679587841	8.064129	8.061088	-20.0	0.3	3
i8.46	98.1209	-1.3698096275	8.061088	8.051135	-20.0	0.3	3
i8.46	99.496414	-1.3550883532	8.051135	8.048197	-20.0	0.3	3
i8.46	100.87193	-1.3566293716	8.048197	8.040424	-20.0	0.3	3
i8.46	102.24745	-1.3667507172	8.040424	8.033699	-20.0	0.3	3
i8.46	103.62297	-1.3543747663	8.033699	8.026688	-20.0	0.3	3
i8.46	104.99849	-1.3611419201	8.026688	8.020000	-20.0	0.3	3
i8.46	106.37401	-1.3649380207	8.020000	8.020000	-20.0	0.3	3
i8.46	107.74952	-1.3615568876	8.020000	8.020000	-20.0	0.3	3
i8.46	109.12504	-1.3731429577	8.020000	8.020000	-20.0	0.3	3
i8.46	110.50055	-1.3585261106	8.020000	8.020000	-20.0	0.3	3
i8.46	111.87607	-1.3583515882	8.020000	8.020000	-20.0	0.3	3
i8.46	113.25159	-1.3738770485	8.020000	8.020000	-20.350962	0.3	3
i8.46	114.6271	1.3590199947	8.020000	8.020000	-35.175481	0.3	3
i7.00	145.44527	1.1845749617	8.02	8.02	-18.0	-0.5	0
i7.00	146.63759	4.7633757591	8.04	8.04	-18.0	-0.5	0
i7.00	155.65149	1.1442410946	8.11	8.11	-16.0	-0.5	0
i7.00	156.79831	1.1451742649	9.01	9.01	-16.0	-0.5	0
i7.00	157.94513	1.1392753124	9.03	9.03	-16.0	-0.5	0
i7.00	159.09195	1.140824914	9.05	9.05	-16.0	-0.5	0
i7.00	160.23878	1.1421899796	9.07	9.07	-16.0	-0.5	0
i7.00	161.3856	4.580239296	9.09	9.09	-16.0	-0.5	0
i7.00	169.71864	0.6713238955	8.08	8.08	-18.0	-0.5	0
i7.00	170.39357	0.6710428596	8.1	8.1	-18.0	-0.5	0
i7.00	171.06848	0.6739892364	9.0	9.0	-18.0	-0.5	0
i7.00	171.74341	0.6716582179	9.02	9.02	-18.0	-0.5	0
i7.00	172.41832	4.0406537056	9.04	9.04	-18.0	-0.5	0
i7.00	180.48975	1.4526984692	8.11	8.11	-18.0	-0.5	0
i7.00	181.94878	1.4585931301	9.01	9.01	-18.0	-0.5	0
i7.00	183.40779	1.4579153061	9.03	9.03	-18.0	-0.5	0
i7.00	184.86682	5.8293356895	9.05	9.05	-18.0	-0.5	0
i7.01	143.54082	1.0094548464	8.05	8.05	-18.0	-0.166666666667	0
i7.01	144.55899	4.0641393661	8.07	8.07	-18.0	-0.166666666667	0
i7.01	151.14606	1.2342936993	8.1	8.1	-18.0	-0.166666666667	0
i7.01	152.38165	1.2293105125	9.0	9.0	-18.0	-0.166666666667	0
i7.01	153.61726	1.233497858	9.02	9.02	-18.0	-0.166666666667	0
i7.01	154.85286	7.4127612114	9.04	9.04	-18.0	-0.166666666667	0
i7.01	164.6354	1.4510321617	8.08	8.08	-17.0	-0.166666666667	0
i7.01	166.09036	1.4524815083	8.1	8.1	-17.0	-0.166666666667	0
i7.01	167.54532	1.4520567656	9.0	9.0	-17.0	-0.166666666667	0
i7.01	169.00027	1.4503737688	9.02	9.02	-17.0	-0.166666666667	0
i7.01	170.45523	1.4482083321	9.04	9.04	-17.0	-0.166666666667	0
i7.01	171.91019	5.8192181587	9.06	9.06	-17.0	-0.166666666667	0
i7.01	180.4803	0.9257998466	8.04	8.04	-16.0	-0.166666666667	0
i7.01	181.41031	0.9284397364	8.06	8.06	-16.0	-0.166666666667	0
i7.01	182.34032	0.9217891693	8.08	8.08	-16.0	-0.166666666667	0
i7.01	183.27032	0.9225406647	8.1	8.1	-16.0	-0.166666666667	0
i7.01	184.20032	9.2996902466	9.0	9.0	-16.0	-0.166666666667	0
i7.02	144.09183	0.7503401041	8.05	8.05	-16.0	0.166666666667	0
i7.02	144.84335	0.7435357571	8.07	8.07	-16.0	0.166666666667	0
i7.02	145.5949	0.7472403646	8.09	8.09	-16.0	0.166666666667	0
i7.02	146.34642	0.7459072471	8.11	8.11	-16.0	0.166666666667	0
i7.02	147.09795	4.5038108826	9.01	9.01	-16.0	0.166666666667	0
i7.02	155.80135	1.5056223869	8.03	8.03	-17.0	0.166666666667	0
i7.02	157.3083	15.0692539215	8.05	8.05	-17.0	0.166666666667	0
i7.02	175.46887	1.1454777718	8.1	8.1	-16.0	0.166666666667	0
i7.02	176.61731	1.1454292536	9.0	9.0	-16.0	0.166666666667	0
i7.02	177.76575	1.1403993368	9.02	9.02	-16.0	0.166666666667	0
i7.02	178.91417	11.4755277634	9.04	9.04	-16.0	0.166666666667	0
i7.03	144.92644	1.1306693554	8.03	8.03	-18.0	0.5	0
i7.03	146.06195	1.1281422377	8.05	8.05	-18.0	0.5	0
i7.03	147.19746	1.1283510923	8.07	8.07	-18.0	0.5	0
i7.03	148.33298	1.1311351061	8.09	8.09	-18.0	0.5	0
i7.03	149.46848	11.3482151031	8.11	8.11	-18.0	0.5	0
i7.03	163.09888	0.9747572541	8.05	8.05	-17.0	0.5	0
i7.03	164.07916	0.9768995643	8.07	8.07	-17.0	0.5	0
i7.03	165.05943	0.9776770473	8.09	8.09	-17.0	0.5	0
i7.03	166.03972	0.978330791	8.11	8.11	-17.0	0.5	0
i7.03	167.01999	9.7961015701	9.01	9.01	-17.0	0.5	0
i7.03	180.64417	0.8211798072	9.0	9.0	-17.0	0.5	0
i7.03	181.47122	0.8253730536	9.02	9.02	-17.0	0.5	0
i7.03	182.29828	0.8258787394	9.04	9.04	-17.0	0.5	0
i7.03	183.12534	0.8201727271	9.06	9.06	-17.0	0.5	0
i7.03	183.9524	0.8193743825	9.08	9.08	-17.0	0.5	0
i7.03	184.77945	8.2634048462	9.1	9.1	-17.0	0.5	0
i7.00	345.71393	0.5776968002	9.07	9.07	-16.0	-0.5	0
i7.00	346.29782	0.5796179175	9.05	9.05	-16.0	-0.5	0
i7.00	346.8817	0.5803285837	9.03	9.03	-16.0	-0.5	0
i7.00	347.4656	5.8322815895	9.01	9.01	-16.0	-0.5	0
i7.00	356.08	1.0253245831	9.02	9.02	-17.0	-0.5	0
i7.00	357.10638	10.2573280334	9.0	9.0	-17.0	-0.5	0
i7.00	371.3967	1.1729283333	9.01	9.01	-18.0	-0.5	0
i7.00	372.57123	1.1720497608	8.11	8.11	-18.0	-0.5	0
i7.00	373.74576	1.171269536	8.09	8.09	-18.0	-0.5	0
i7.00	374.9203	1.1707473993	8.07	8.07	-18.0	-0.5	0
i7.00	376.09485	1.1727912426	8.05	8.05	-18.0	-0.5	0
i7.00	377.26938	7.046479702	8.03	8.03	-18.0	-0.5	0
i7.01	342.50885	0.6960992813	9.01	9.01	-16.0	-0.166666666667	0
i7.01	343.21042	0.697226584	8.11	8.11	-16.0	-0.166666666667	0
i7.01	343.91196	0.6992805004	8.09	8.09	-16.0	-0.166666666667	0
i7.01	344.61353	2.8027193546	8.07	8.07	-16.0	-0.166666666667	0
i7.01	350.59595	0.6890621185	9.06	9.06	-17.0	-0.166666666667	0
i7.01	351.2914	0.6933414936	9.04	9.04	-17.0	-0.166666666667	0
i7.01	351.98685	0.6913521886	9.02	9.02	-17.0	-0.166666666667	0
i7.01	352.6823	0.6886326075	9.0	9.0	-17.0	-0.166666666667	0
i7.01	353.37778	0.6931496263	8.1	8.1	-17.0	-0.166666666667	0
i7.01	354.0732	4.1719641685	8.08	8.08	-17.0	-0.166666666667	0
i7.01	360.96967	0.8545081019	9.11	9.11	-18.0	-0.166666666667	0
i7.01	361.83133	0.8593506217	9.09	9.09	-18.0	-0.166666666667	0
i7.01	362.693	0.8579076529	9.07	9.07	-18.0	-0.166666666667	0
i7.01	363.55466	3.4463043213	9.05	9.05	-18.0	-0.166666666667	0
i7.01	370.85202	0.9236029983	9.09	9.09	-18.0	-0.166666666667	0
i7.01	371.78055	0.9245880842	9.07	9.07	-18.0	-0.166666666667	0
i7.01	372.70908	0.9281510711	9.05	9.05	-18.0	-0.166666666667	0
i7.01	373.63763	0.9217917919	9.03	9.03	-18.0	-0.166666666667	0
i7.01	374.56616	5.5642757416	9.01	9.01	-18.0	-0.166666666667	0
i7.02	342.15994	0.8833824992	10.0	10.0	-16.0	0.166666666667	0
i7.02	343.04453	8.8388776779	9.1	9.1	-16.0	0.166666666667	0
i7.02	355.48056	1.3888462782	9.06	9.06	-17.0	0.166666666667	0
i7.02	356.8733	13.9219665527	9.04	9.04	-17.0	0.166666666667	0
i7.02	374.22455	1.1871522665	9.11	9.11	-18.0	0.166666666667	0
i7.02	375.4129	1.1835238934	9.09	9.09	-18.0	0.166666666667	0
i7.02	376.60126	1.1837998629	9.07	9.07	-18.0	0.166666666667	0
i7.02	377.7896	1.1857372522	9.05	9.05	-18.0	0.166666666667	0
i7.02	378.97797	4.7502241135	9.03	9.03	-18.0	0.166666666667	0
i7.03	342.4977	1.3767338991	9.05	9.05	-16.0	0.5	0
i7.03	343.88004	5.5256867409	9.03	9.03	-16.0	0.5	0
i7.03	353.4376	1.101079464	9.07	9.07	-17.0	0.5	0
i7.03	354.54404	11.0612163544	9.05	9.05	-17.0	0.5	0
i7.03	367.9918	1.0744811296	10.01	10.01	-17.0	0.5	0
i7.03	369.0706	6.4718151093	9.11	9.11	-17.0	0.5	0
i7.03	378.8782	1.2189199924	9.05	9.05	-17.0	0.5	0
i7.03	380.10144	1.2211362123	9.03	9.03	-17.0	0.5	0
i7.03	381.32465	1.2200065851	9.01	9.01	-17.0	0.5	0
i7.03	382.54788	1.2224344015	8.11	8.11	-17.0	0.5	0
i7.03	383.77112	1.222505331	8.09	8.09	-17.0	0.5	0
i7.03	384.99432	7.3389525414	8.07	8.07	-17.0	0.5	0
i7.00	2.8001637	-1.4090471268	7.070023	7.070023	-20.0	-0.5	3
i7.00	4.22442	-1.4070019722	7.070023	7.075453	-19.163687	-0.5	3
i7.00	5.6486764	-1.3679358959	7.075453	7.077061	-18.788128	-0.5	3
i7.00	7.072933	-1.3875440359	7.077061	7.081489	-18.40307	-0.5	3
i7.00	8.497189	-1.3975305557	7.081489	7.082804	-18.07789	-0.5	3
i7.00	9.921446	-1.4180109501	7.082804	7.084583	-17.665394	-0.5	3
i7.00	11.345702	-1.3899343014	7.084583	7.087491	-17.293591	-0.5	3
i7.00	12.7699585	-1.386474967	7.087491	7.089732	-16.886812	-0.5	3
i7.00	14.194216	-1.3924274445	7.089732	7.092910	-16.601253	-0.5	3
i7.00	15.6184635	-1.3766496181	7.092910	7.093896	-16.178171	-0.5	3
i7.00	17.04272	-1.3670884371	7.093896	7.103081	-15.904423	-0.5	3
i7.00	18.466978	-1.4098463058	7.103081	7.105782	-15.457601	-0.5	3
i7.00	19.891233	-1.3592643738	7.105782	7.097953	-15.089924	-0.5	3
i7.00	21.31549	-1.4004446268	7.097953	7.101799	-14.740939	-0.5	3
i7.00	22.739748	-1.387983799	7.101799	7.107468	-14.336736	-0.5	3
i7.00	24.164003	-1.3948407173	7.107468	7.107960	-14.064003	-0.5	3
i7.00	25.588259	-1.371655941	7.107960	7.107325	-13.566422	-0.5	3
i7.00	27.012516	-1.4184069633	7.107325	7.113458	-13.287597	-0.5	3
i7.00	28.436773	-1.360047102	7.113458	7.119959	-12.860731	-0.5	3
i7.00	29.861029	-1.4232276678	7.119959	7.118043	-12.494157	-0.5	3
i7.00	31.285286	-1.3799799681	7.118043	7.116649	-11.984324	-0.5	3
i7.00	32.709534	-1.4156950712	7.116649	7.119647	-11.712023	-0.5	3
i7.00	34.133793	-1.4221695662	7.119647	7.119293	-11.205632	-0.5	3
i7.00	35.55805	-1.4069162607	7.119293	7.116431	-10.958412	-0.5	3
i7.00	36.982304	-1.4209623337	7.116431	8.002842	-10.77383	-0.5	3
i7.00	38.406563	-1.4174818993	8.002842	8.002879	-10.91923	-0.5	3
i7.00	39.83082	-1.3908958435	8.002879	7.118761	-11.66802	-0.5	3
i7.00	41.255074	-1.4157805443	7.118761	7.118823	-12.092536	-0.5	3
i7.00	42.679333	-1.4024274349	7.118823	8.000218	-12.798457	-0.5	3
i7.00	44.10359	-1.4229837656	8.000218	7.119877	-13.504914	-0.5	3
i7.00	45.527843	-1.370777607	7.119877	7.119656	-14.175836	-0.5	3
i7.00	46.9521	-1.3838779926	7.119656	7.119522	-15.012104	-0.5	3
i7.00	48.376354	-1.4095965624	7.119522	7.119592	-15.718783	-0.5	3
i7.00	49.800606	-1.3933055401	7.119592	7.119684	-16.39771	-0.5	3
i7.00	51.22486	-1.3647783995	7.119684	7.119539	-17.244954	-0.5	3
i7.00	52.649117	-1.358934164	7.119539	7.119476	-17.34169	-0.5	3
i7.00	54.07337	-1.3829805851	7.119476	7.119570	-18.438225	-0.5	3
i7.00	55.49763	-1.3784307241	7.119570	7.119507	-19.151179	-0.5	3
i7.00	56.921886	-1.3820250034	7.119507	7.119565	-19.934524	-0.5	3
i7.00	58.34614	-1.4143899679	7.119565	7.119389	-20.302081	-0.5	3
i7.00	59.770397	-1.4095799923	7.119389	7.119435	-21.266717	-0.5	3
i7.00	61.194656	-1.3552387953	7.119435	7.119495	-22.03793	-0.5	3
i7.00	62.618916	-1.3583017588	7.119495	7.119670	-23.043702	-0.5	3
i7.00	64.04317	-1.4167541265	7.119670	7.119603	-24.050799	-0.5	3
i7.00	65.46742	-1.4031451941	7.119603	7.119636	-24.699279	-0.5	3
i7.00	66.89168	-1.384237051	7.119636	7.119722	-25.634994	-0.5	3
i7.00	68.31593	-1.3790912628	7.119722	7.119560	-26.371642	-0.5	3
i7.00	69.74019	-1.3828295469	7.119560	7.119559	-27.352911	-0.5	3
i7.00	71.164444	-1.4093629122	7.119559	7.119640	-28.186794	-0.5	3
i7.00	72.5887	1.4080451727	7.119640	7.119466	-29.123297	-0.5	3
i7.01	1.1997852	-1.4064866304	7.070056	7.070056	-20.0	-0.166666666667	3
i7.01	2.6560433	-1.429820776	7.070056	7.073093	-19.571289	-0.166666666667	3
i7.01	4.1123085	-1.4286267757	7.073093	7.075614	-19.185778	-0.166666666667	3
i7.01	5.568574	-1.4546477795	7.075614	7.078143	-18.815617	-0.166666666667	3
i7.01	7.0248394	-1.4278855324	7.078143	7.081478	-18.428488	-0.166666666667	3
i7.01	8.481097	-1.4282063246	7.081478	7.083301	-18.066229	-0.166666666667	3
i7.01	9.937363	-1.4268294573	7.083301	7.085002	-17.659969	-0.166666666667	3
i7.01	11.393628	-1.4244706631	7.085002	7.088615	-17.346881	-0.166666666667	3
i7.01	12.849894	-1.4345623255	7.088615	7.089381	-17.018889	-0.166666666667	3
i7.01	14.306152	-1.410730958	7.089381	7.091872	-16.564708	-0.166666666667	3
i7.01	15.762416	-1.4487594366	7.091872	7.096679	-16.140352	-0.166666666667	3
i7.01	17.218683	-1.4346082211	7.096679	7.097433	-15.804881	-0.166666666667	3
i7.01	18.674948	-1.453681469	7.097433	7.100497	-15.361345	-0.166666666667	3
i7.01	20.131207	-1.4427136183	7.100497	7.103263	-14.98647	-0.166666666667	3
i7.01	21.587471	-1.3989889622	7.103263	7.106711	-14.662218	-0.166666666667	3
i7.01	23.043737	-1.4141151905	7.106711	7.109366	-14.217111	-0.166666666667	3
i7.01	24.500002	-1.4025543928	7.109366	7.109399	-13.861027	-0.166666666667	3
i7.01	25.95626	-1.3982018232	7.109399	7.118327	-13.425972	-0.166666666667	3
i7.01	27.412525	-1.3889663219	7.118327	7.118159	-13.15564	-0.166666666667	3
i7.01	28.868792	-1.384319663	7.118159	7.110896	-12.798006	-0.166666666667	3
i7.01	30.325056	-1.3965125084	7.110896	7.118133	-12.349352	-0.166666666667	3
i7.01	31.781313	-1.4173802137	7.118133	7.118826	-11.927585	-0.166666666667	3
i7.01	33.23758	-1.4362553358	7.118826	8.000867	-11.694596	-0.166666666667	3
i7.01	34.693844	-1.452157259	8.000867	7.119277	-11.247777	-0.166666666667	3
i7.01	36.15011	-1.386796236	7.119277	8.002430	-10.843214	-0.166666666667	3
i7.01	37.60637	-1.4426631927	8.002430	7.119998	-10.593935	-0.166666666667	3
i7.01	39.062634	-1.4306310415	7.119998	8.000364	-11.358643	-0.166666666667	3
i7.01	40.518898	-1.396597147	8.000364	7.118914	-12.093113	-0.166666666667	3
i7.01	41.975163	-1.4287179708	7.118914	8.000562	-12.659892	-0.166666666667	3
i7.01	43.431423	-1.426689744	8.000562	7.119230	-13.344511	-0.166666666667	3
i7.01	44.887688	-1.4402960539	7.119230	7.119742	-14.00601	-0.166666666667	3
i7.01	46.343952	-1.3834408522	7.119742	7.119528	-14.841054	-0.166666666667	3
i7.01	47.800217	-1.444045186	7.119528	7.119292	-15.367807	-0.166666666667	3
i7.01	49.256477	-1.384529233	7.119292	7.119460	-16.143883	-0.166666666667	3
i7.01	50.71274	-1.4086518288	7.119460	7.119480	-17.143634	-0.166666666667	3
i7.01	52.16901	-1.443218708	7.119480	7.119591	-17.70729	-0.166666666667	3
i7.01	53.625275	-1.3932590485	7.119591	7.119616	-18.189771	-0.166666666667	3
i7.01	55.08153	-1.4160689116	7.119616	7.119645	-19.015857	-0.166666666667	3
i7.01	56.537796	-1.4065144062	7.119645	7.119794	-19.612048	-0.166666666667	3
i7.01	57.99406	-1.3842264414	7.119794	7.119552	-20.38083	-0.166666666667	3
i7.01	59.45033	-1.4276646376	7.119552	7.119517	-21.29026	-0.166666666667	3
i7.01	60.90658	-1.4069377184	7.119517	7.119619	-22.024683	-0.166666666667	3
i7.01	62.36285	-1.4090727568	7.119619	7.119635	-22.876156	-0.166666666667	3
i7.01	63.81912	-1.4265631437	7.119635	7.119546	-23.861401	-0.166666666667	3
i7.01	65.275375	-1.4480859041	7.119546	7.119549	-24.732193	-0.166666666667	3
i7.01	66.731636	-1.3939802647	7.119549	7.119652	-25.504266	-0.166666666667	3
i7.01	68.187904	-1.3847203255	7.119652	7.119646	-26.508475	-0.166666666667	3
i7.01	69.644165	-1.4141436815	7.119646	7.119546	-27.298816	-0.166666666667	3
i7.01	71.10043	-1.4322186708	7.119546	7.119522	-28.224143	-0.166666666667	3
i7.01	72.55669	1.4433072805	7.119522	7.119493	-29.121095	-0.166666666667	3
i7.02	3.7890584	-1.3734352589	7.070057	7.070057	-20.0	0.166666666667	3
i7.02	5.193536	-1.3767962456	7.070057	7.078000	-18.907637	0.166666666667	3
i7.02	6.598013	-1.3950923681	7.078000	7.078179	-18.571205	0.166666666667	3
i7.02	8.00249	-1.3733144999	7.078179	7.082071	-18.195288	0.166666666667	3
i7.02	9.406967	-1.3352549076	7.082071	7.083326	-17.836013	0.166666666667	3
i7.02	10.811452	-1.366052866	7.083326	7.086310	-17.464774	0.166666666667	3
i7.02	12.21593	-1.3514995575	7.086310	7.091656	-17.043195	0.166666666667	3
i7.02	13.620406	-1.3849781752	7.091656	7.091669	-16.726297	0.166666666667	3
i7.02	15.024884	-1.3694300652	7.091669	7.095925	-16.379566	0.166666666667	3
i7.02	16.42936	-1.3603873253	7.095925	7.098310	-16.013597	0.166666666667	3
i7.02	17.83384	-1.3418399096	7.098310	7.097055	-15.633279	0.166666666667	3
i7.02	19.238316	-1.3964029551	7.097055	7.097449	-15.286722	0.166666666667	3
i7.02	20.642792	-1.3493064642	7.097449	7.106416	-14.922263	0.166666666667	3
i7.02	22.04727	-1.374344945	7.106416	7.106718	-14.605967	0.166666666667	3
i7.02	23.451748	-1.3499168158	7.106718	7.109036	-14.181624	0.166666666667	3
i7.02	24.856232	-1.3847744465	7.109036	7.106700	-13.766262	0.166666666667	3
i7.02	26.26071	-1.379704237	7.106700	7.110167	-13.462688	0.166666666667	3
i7.02	27.665186	-1.337449193	7.110167	7.113670	-13.035575	0.166666666667	3
i7.02	29.069664	-1.3486382961	7.113670	7.115638	-12.654533	0.166666666667	3
i7.02	30.474142	-1.3557018042	7.115638	7.115944	-12.317231	0.166666666667	3
i7.02	31.878618	-1.3507804871	7.115944	7.119216	-11.960134	0.166666666667	3
i7.02	33.283096	-1.3572118282	7.119216	7.116891	-11.63298	0.166666666667	3
i7.02	34.687572	-1.3939628601	7.116891	7.115679	-11.175357	0.166666666667	3
i7.02	36.09205	-1.332880497	7.115679	7.107526	-10.875025	0.166666666667	3
i7.02	37.49653	-1.3757017851	7.107526	7.110998	-10.555058	0.166666666667	3
i7.02	38.901012	-1.3560397625	7.110998	7.110102	-11.013459	0.166666666667	3
i7.02	40.30549	-1.3523162603	7.110102	7.106519	-11.622079	0.166666666667	3
i7.02	41.709965	-1.39042449	7.106519	7.104553	-12.519239	0.166666666667	3
i7.02	43.11444	-1.3853400946	7.104553	7.101739	-13.385693	0.166666666667	3
i7.02	44.51892	-1.3690847158	7.101739	7.100002	-14.141768	0.166666666667	3
i7.02	45.9234	-1.3348189592	7.100002	7.099541	-14.351318	0.166666666667	3
i7.02	47.327877	-1.3803585768	7.099541	7.099664	-15.084652	0.166666666667	3
i7.02	48.732353	-1.3982182741	7.099664	7.099582	-15.949092	0.166666666667	3
i7.02	50.13683	-1.3919934034	7.099582	7.099583	-16.240865	0.166666666667	3
i7.02	51.541306	-1.3418765068	7.099583	7.099638	-17.270481	0.166666666667	3
i7.02	52.945793	-1.3869526386	7.099638	7.099581	-18.161412	0.166666666667	3
i7.02	54.35027	-1.3491177559	7.099581	7.099522	-18.563889	0.166666666667	3
i7.02	55.754745	-1.3741210699	7.099522	7.099562	-19.484088	0.166666666667	3
i7.02	57.15922	-1.3795645237	7.099562	7.099505	-20.177645	0.166666666667	3
i7.02	58.5637	-1.3555296659	7.099505	7.099653	-20.436502	0.166666666667	3
i7.02	59.968178	-1.3589881659	7.099653	7.099579	-21.541707	0.166666666667	3
i7.02	61.372654	-1.3389338255	7.099579	7.099461	-22.24084	0.166666666667	3
i7.02	62.77713	-1.3920091391	7.099461	7.099583	-22.84115	0.166666666667	3
i7.02	64.1816	-1.3608021736	7.099583	7.099463	-23.975087	0.166666666667	3
i7.02	65.58608	-1.3465446234	7.099463	7.099488	-24.884918	0.166666666667	3
i7.02	66.99058	-1.3805294037	7.099488	7.099539	-25.505459	0.166666666667	3
i7.02	68.39505	-1.3549681902	7.099539	7.099759	-26.485182	0.166666666667	3
i7.02	69.79953	-1.3546726704	7.099759	7.099419	-27.364381	0.166666666667	3
i7.02	71.204	-1.3876898289	7.099419	7.099472	-28.288391	0.166666666667	3
i7.02	72.60848	1.3604229689	7.099472	7.099493	-29.14137	0.166666666667	3
i7.03	3.8340564	-1.3791468143	7.070057	7.070057	-20.0	0.5	3
i7.03	5.2376285	-1.4030672312	7.070057	7.077880	-18.904722	0.5	3
i7.03	6.641207	-1.402654171	7.077880	7.078940	-18.549255	0.5	3
i7.03	8.044786	-1.3347218037	7.078940	7.082459	-18.179013	0.5	3
i7.03	9.448365	-1.3717244864	7.082459	7.086190	-17.816523	0.5	3
i7.03	10.851945	-1.3351180553	7.086190	7.085348	-17.478048	0.5	3
i7.03	12.255525	-1.3613920212	7.085348	7.091125	-17.01916	0.5	3
i7.03	13.659103	-1.4017488956	7.091125	7.090568	-16.711361	0.5	3
i7.03	15.062675	-1.3698754311	7.090568	7.094966	-16.274743	0.5	3
i7.03	16.466253	-1.33154881	7.094966	7.095256	-15.979318	0.5	3
i7.03	17.869833	-1.3873537779	7.095256	7.097638	-15.643575	0.5	3
i7.03	19.273413	-1.3348602057	7.097638	7.097429	-15.370591	0.5	3
i7.03	20.676992	-1.3657374382	7.097429	7.104083	-14.943315	0.5	3
i7.03	22.080572	-1.3315877914	7.104083	7.107506	-14.50193	0.5	3
i7.03	23.484144	-1.3542474508	7.107506	7.109467	-14.192223	0.5	3
i7.03	24.887722	-1.3596807718	7.109467	7.107149	-13.787092	0.5	3
i7.03	26.291302	-1.4026741982	7.107149	7.108157	-13.381556	0.5	3
i7.03	27.69488	-1.3872441053	7.108157	7.110053	-13.220947	0.5	3
i7.03	29.098461	-1.3985873461	7.110053	7.116331	-12.820616	0.5	3
i7.03	30.502039	-1.3718954325	7.116331	7.115795	-12.301301	0.5	3
i7.03	31.905617	-1.3436088562	7.115795	8.001192	-11.794859	0.5	3
i7.03	33.30919	-1.3641372919	8.001192	8.000619	-11.591743	0.5	3
i7.03	34.712772	-1.3699709177	8.000619	8.003693	-11.239688	0.5	3
i7.03	36.11635	-1.3538930416	8.003693	8.006349	-10.73929	0.5	3
i7.03	37.519928	-1.3791246414	8.006349	8.007894	-10.570138	0.5	3
i7.03	38.923508	-1.3584280014	8.007894	8.010555	-11.069484	0.5	3
i7.03	40.327084	-1.3757145405	8.010555	8.012986	-11.731986	0.5	3
i7.03	41.730656	-1.391245842	8.012986	8.014908	-12.703299	0.5	3
i7.03	43.13424	-1.3598842621	8.014908	8.017200	-13.151365	0.5	3
i7.03	44.537815	-1.392175436	8.017200	8.019512	-13.732848	0.5	3
i7.03	45.941395	-1.3954129219	8.019512	8.019465	-14.608853	0.5	3
i7.03	47.344975	-1.3860139847	8.019465	8.019406	-15.218458	0.5	3
i7.03	48.748554	-1.3644295931	8.019406	8.019481	-15.806461	0.5	3
i7.03	50.152134	-1.3930234909	8.019481	8.019606	-16.480964	0.5	3
i7.03	51.555706	-1.3445717096	8.019606	8.019484	-17.400312	0.5	3
i7.03	52.959286	-1.3817588091	8.019484	8.019490	-17.80968	0.5	3
i7.03	54.36286	-1.3665885925	8.019490	8.019718	-18.689529	0.5	3
i7.03	55.76644	-1.3460400105	8.019718	8.019642	-19.118073	0.5	3
i7.03	57.17002	-1.4028917551	8.019642	8.019437	-19.730924	0.5	3
i7.03	58.5736	-1.3650175333	8.019437	8.019489	-20.483991	0.5	3
i7.03	59.97718	-1.3855302334	8.019489	8.019599	-21.712941	0.5	3
i7.03	61.380753	-1.3525887728	8.019599	8.019421	-22.130064	0.5	3
i7.03	62.78433	-1.3680118322	8.019421	8.019450	-23.024515	0.5	3
i7.03	64.187904	-1.3530271053	8.019450	8.019550	-23.908931	0.5	3
i7.03	65.591484	-1.3595232964	8.019550	8.019469	-24.596515	0.5	3
i7.03	66.99507	-1.3401687145	8.019469	8.019437	-25.866258	0.5	3
i7.03	68.39865	-1.3382897377	8.019437	8.019552	-26.426879	0.5	3
i7.03	69.80222	-1.3624343872	8.019552	8.019482	-27.304417	0.5	3
i7.03	71.2058	-1.38133955	8.019482	8.019520	-28.372132	0.5	3
i7.03	72.60938	1.3603916168	8.019520	8.019473	-29.128993	0.5	3
i7.00	91.13363	-0.4992278516	8.050874	8.050874	-20.0	-0.5	3
i7.00	91.64436	-0.4887230098	8.050874	8.050626	-20.0	-0.5	3
i7.00	92.1551	-0.5009489655	8.050626	8.049490	-20.0	-0.5	3
i7.00	92.665825	-0.5069493055	8.049490	8.041851	-20.0	-0.5	3
i7.00	93.17656	-0.497805506	8.041851	8.049569	-20.0	-0.5	3
i7.00	93.68729	-0.5034778714	8.049569	8.039754	-20.0	-0.5	3
i7.00	94.19802	-0.5021722317	8.039754	8.027645	-20.0	-0.5	3
i7.00	94.70875	-0.5089733005	8.027645	8.037050	-20.0	-0.5	3
i7.00	95.21948	-0.4883859456	8.037050	8.026783	-20.0	-0.5	3
i7.00	95.73021	-0.4890342355	8.026783	8.029679	-20.0	-0.5	3
i7.00	96.240944	-0.4948140681	8.029679	8.026467	-20.0	-0.5	3
i7.00	96.75167	-0.5007500648	8.026467	8.017922	-20.0	-0.5	3
i7.00	97.262405	-0.5053607821	8.017922	8.017876	-20.0	-0.5	3
i7.00	97.77314	-0.4962214231	8.017876	8.018175	-20.0	-0.5	3
i7.00	98.28387	-0.4858277142	8.018175	8.008475	-20.0	-0.5	3
i7.00	98.7946	-0.510222733	8.008475	8.017713	-20.0	-0.5	3
i7.00	99.30533	-0.4921900332	8.017713	8.012334	-20.0	-0.5	3
i7.00	99.81606	-0.4905088842	8.012334	8.000415	-20.0	-0.5	3
i7.00	100.3268	-0.4990106225	8.000415	8.005597	-20.0	-0.5	3
i7.00	100.837524	-0.50424546	8.005597	7.119891	-20.0	-0.5	3
i7.00	101.34826	-0.4887469411	7.119891	7.114855	-20.0	-0.5	3
i7.00	101.858986	-0.4959315062	7.114855	7.114215	-20.0	-0.5	3
i7.00	102.36972	-0.5000320673	7.114215	7.113050	-20.0	-0.5	3
i7.00	102.880455	-0.5097820163	7.113050	7.108179	-20.0	-0.5	3
i7.00	103.39118	-0.5009212494	7.108179	7.104007	-20.0	-0.5	3
i7.00	103.90192	-0.5031821728	7.104007	7.101476	-20.0	-0.5	3
i7.00	104.41264	-0.4900023639	7.101476	7.100349	-20.0	-0.5	3
i7.00	104.92338	-0.5065821409	7.100349	7.096213	-20.0	-0.5	3
i7.00	105.434105	-0.4910548627	7.096213	7.094350	-20.0	-0.5	3
i7.00	105.94484	-0.4986457527	7.094350	7.091511	-20.0	-0.5	3
i7.00	106.45557	-0.4891186059	7.091511	7.090000	-20.0	-0.5	3
i7.00	106.9663	-0.5106673241	7.090000	7.090000	-20.0	-0.5	3
i7.00	107.477036	-0.5060142279	7.090000	7.090000	-20.0	-0.5	3
i7.00	107.98776	-0.4882276356	7.090000	7.090000	-20.0	-0.5	3
i7.00	108.4985	-0.5093525052	7.090000	7.090000	-20.0	-0.5	3
i7.00	109.00923	-0.501842916	7.090000	7.090000	-20.0	-0.5	3
i7.00	109.51996	-0.4916129112	7.090000	7.090000	-20.0	-0.5	3
i7.00	110.030685	-0.5041821599	7.090000	7.090000	-20.0	-0.5	3
i7.00	110.54142	-0.4911985397	7.090000	7.090000	-20.0	-0.5	3
i7.00	111.052155	-0.4987223744	7.090000	7.090000	-20.0	-0.5	3
i7.00	111.56288	-0.4919194877	7.090000	7.090000	-20.0	-0.5	3
i7.00	112.073616	-0.4886509478	7.090000	7.090000	-20.0	-0.5	3
i7.00	112.58434	-0.4902987182	7.090000	7.090000	-20.0	-0.5	3
i7.00	113.09508	-0.4990299642	7.090000	7.090000	-20.0	-0.5	3
i7.00	113.605804	-0.4871344864	7.090000	7.090000	-20.0	-0.5	3
i7.00	114.11654	-0.5024102926	7.090000	7.090000	-20.538786	-0.5	3
i7.00	114.62727	-0.5070803761	7.090000	7.090000	-26.431029	-0.5	3
i7.00	115.138	-0.4955742359	7.090000	7.090000	-32.323272	-0.5	3
i7.00	115.648735	-0.4929483831	7.090000	7.090000	-38.215514	-0.5	3
i7.00	116.15946	0.4930531383	7.090000	7.090000	-44.107757	-0.5	3
i7.01	91.061005	-0.5029063225	8.057529	8.057529	-20.0	-0.166666666667	3
i7.01	91.57319	-0.4888059497	8.057529	8.043173	-20.0	-0.166666666667	3
i7.01	92.08537	-0.4992721081	8.043173	8.045518	-20.0	-0.166666666667	3
i7.01	92.59756	-0.4988398254	8.045518	8.047988	-20.0	-0.166666666667	3
i7.01	93.10974	-0.4876454175	8.047988	8.038946	-20.0	-0.166666666667	3
i7.01	93.621925	-0.5027154684	8.038946	8.041279	-20.0	-0.166666666667	3
i7.01	94.13411	-0.499571085	8.041279	8.047442	-20.0	-0.166666666667	3
i7.01	94.64629	-0.493598491	8.047442	8.028572	-20.0	-0.166666666667	3
i7.01	95.15848	-0.5078881383	8.028572	8.033764	-20.0	-0.166666666667	3
i7.01	95.67066	-0.5024843216	8.033764	8.034662	-20.0	-0.166666666667	3
i7.01	96.182846	-0.4908031523	8.034662	8.034972	-20.0	-0.166666666667	3
i7.01	96.69503	-0.4968293011	8.034972	8.023768	-20.0	-0.166666666667	3
i7.01	97.20721	-0.4923055768	8.023768	8.026709	-20.0	-0.166666666667	3
i7.01	97.71939	-0.4936900139	8.026709	8.027465	-20.0	-0.166666666667	3
i7.01	98.23158	-0.4890192151	8.027465	8.028456	-20.0	-0.166666666667	3
i7.01	98.74376	-0.4932375252	8.028456	8.017952	-20.0	-0.166666666667	3
i7.01	99.25594	-0.5113375187	8.017952	8.017080	-20.0	-0.166666666667	3
i7.01	99.76813	-0.5074560046	8.017080	8.020802	-20.0	-0.166666666667	3
i7.01	100.28031	-0.4925374389	8.020802	8.014116	-20.0	-0.166666666667	3
i7.01	100.792496	-0.4932239056	8.014116	8.011030	-20.0	-0.166666666667	3
i7.01	101.30468	-0.4932354987	8.011030	8.017032	-20.0	-0.166666666667	3
i7.01	101.816864	-0.503033638	8.017032	8.008344	-20.0	-0.166666666667	3
i7.01	102.32905	-0.4904303551	8.008344	8.004609	-20.0	-0.166666666667	3
i7.01	102.84123	-0.4975512028	8.004609	8.003114	-20.0	-0.166666666667	3
i7.01	103.35342	-0.4876523018	8.003114	8.002252	-20.0	-0.166666666667	3
i7.01	103.8656	-0.4971630275	8.002252	8.002700	-20.0	-0.166666666667	3
i7.01	104.377785	-0.4878428876	8.002700	7.117058	-20.0	-0.166666666667	3
i7.01	104.88997	-0.5111891031	7.117058	7.115698	-20.0	-0.166666666667	3
i7.01	105.40215	-0.489744246	7.115698	7.113328	-20.0	-0.166666666667	3
i7.01	105.91434	-0.5075130463	7.113328	7.111690	-20.0	-0.166666666667	3
i7.01	106.42652	-0.4988497198	7.111690	7.110000	-20.0	-0.166666666667	3
i7.01	106.938705	-0.4864704013	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	107.45089	-0.5082570314	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	107.96307	-0.4910888374	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	108.47525	-0.4926820993	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	108.98744	-0.4998489618	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	109.499626	-0.5003767014	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	110.01181	-0.4986928701	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	110.52399	-0.508486867	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	111.03618	-0.492202729	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	111.548355	-0.5028713346	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	112.06054	-0.4933013618	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	112.57272	-0.5111837983	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	113.08491	-0.5083212256	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	113.59709	-0.4867739677	7.110000	7.110000	-20.0	-0.166666666667	3
i7.01	114.109276	-0.5019538999	7.110000	7.110000	-20.454999	-0.166666666667	3
i7.01	114.62146	-0.4907917976	7.110000	7.110000	-26.363999	-0.166666666667	3
i7.01	115.133644	-0.4981211722	7.110000	7.110000	-32.272999	-0.166666666667	3
i7.01	115.64583	-0.5060206056	7.110000	7.110000	-38.182	-0.166666666667	3
i7.01	116.15801	0.4888322949	7.110000	7.110000	-44.091	-0.166666666667	3
i7.02	91.534035	-0.4781661928	8.054520	8.054520	-20.0	0.166666666667	3
i7.02	92.03676	-0.4767421782	8.054520	8.055571	-20.0	0.166666666667	3
i7.02	92.53948	-0.4880451858	8.055571	8.038870	-20.0	0.166666666667	3
i7.02	93.042206	-0.5026538372	8.038870	8.038503	-20.0	0.166666666667	3
i7.02	93.54492	-0.4936257601	8.038503	8.036898	-20.0	0.166666666667	3
i7.02	94.04765	-0.4801519215	8.036898	8.035549	-20.0	0.166666666667	3
i7.02	94.55037	-0.4906829596	8.035549	8.025339	-20.0	0.166666666667	3
i7.02	95.0531	-0.4784968197	8.025339	8.025271	-20.0	0.166666666667	3
i7.02	95.55582	-0.4952869117	8.025271	8.016895	-20.0	0.166666666667	3
i7.02	96.05854	-0.5015461445	8.016895	8.032004	-20.0	0.166666666667	3
i7.02	96.561264	-0.5010111928	8.032004	8.021024	-20.0	0.166666666667	3
i7.02	97.06399	-0.4771818519	8.021024	8.007810	-20.0	0.166666666667	3
i7.02	97.56671	-0.4778840244	8.007810	8.007666	-20.0	0.166666666667	3
i7.02	98.069435	-0.4921709597	8.007666	8.007687	-20.0	0.166666666667	3
i7.02	98.57216	-0.47828421	8.007687	8.000569	-20.0	0.166666666667	3
i7.02	99.07488	-0.4872311056	8.000569	8.000250	-20.0	0.166666666667	3
i7.02	99.57761	-0.4767784178	8.000250	7.113411	-20.0	0.166666666667	3
i7.02	100.08033	-0.5016131401	7.113411	7.110051	-20.0	0.166666666667	3
i7.02	100.58305	-0.4803541899	7.110051	7.109269	-20.0	0.166666666667	3
i7.02	101.08578	-0.4937316775	7.109269	7.109407	-20.0	0.166666666667	3
i7.02	101.5885	-0.4842529893	7.109407	7.101477	-20.0	0.166666666667	3
i7.02	102.091225	-0.4875125587	7.101477	7.098916	-20.0	0.166666666667	3
i7.02	102.59395	-0.4807823896	7.098916	7.091265	-20.0	0.166666666667	3
i7.02	103.09667	-0.4997675717	7.091265	7.091812	-20.0	0.166666666667	3
i7.02	103.59939	-0.4825100601	7.091812	7.086940	-20.0	0.166666666667	3
i7.02	104.10211	-0.5011215806	7.086940	7.084510	-20.0	0.166666666667	3
i7.02	104.604836	-0.5006074905	7.084510	7.081980	-20.0	0.166666666667	3
i7.02	105.10756	-0.4920906425	7.081980	7.077762	-20.0	0.166666666667	3
i7.02	105.61028	-0.4852502346	7.077762	7.074575	-20.0	0.166666666667	3
i7.02	106.11301	-0.4935162663	7.074575	7.070957	-20.0	0.166666666667	3
i7.02	106.61573	-0.4829380214	7.070957	7.070000	-20.0	0.166666666667	3
i7.02	107.118454	-0.4886796772	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	107.62118	-0.4833405316	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	108.1239	-0.4997105896	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	108.626625	-0.4989221692	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	109.12935	-0.4943752885	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	109.63207	-0.4984419942	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	110.134796	-0.4921514392	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	110.63751	-0.4913685024	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	111.14024	-0.5025959611	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	111.64296	-0.4954091012	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	112.14569	-0.4978676438	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	112.64841	-0.4801283181	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	113.15114	-0.4980707467	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	113.653854	-0.4840478301	7.070000	7.070000	-20.0	0.166666666667	3
i7.02	114.15658	-0.4961986244	7.070000	7.070000	-21.000725	0.166666666667	3
i7.02	114.6593	-0.496408999	7.070000	7.070000	-26.80058	0.166666666667	3
i7.02	115.16203	-0.4916843772	7.070000	7.070000	-32.600435	0.166666666667	3
i7.02	115.66475	-0.4911095798	7.070000	7.070000	-38.40029	0.166666666667	3
i7.02	116.16747	0.4991426766	7.070000	7.070000	-44.200145	0.166666666667	3
i7.03	91.074554	-0.4960852563	8.044603	8.044603	-20.0	0.5	3
i7.03	91.58647	-0.503148675	8.044603	8.042946	-20.0	0.5	3
i7.03	92.09838	-0.4863967299	8.042946	8.051752	-20.0	0.5	3
i7.03	92.6103	-0.4899169803	8.051752	8.043765	-20.0	0.5	3
i7.03	93.12221	-0.4969050884	8.043765	8.046999	-20.0	0.5	3
i7.03	93.63412	-0.5052245259	8.046999	8.042116	-20.0	0.5	3
i7.03	94.146034	-0.5044646263	8.042116	8.031756	-20.0	0.5	3
i7.03	94.65794	-0.4913059771	8.031756	8.033751	-20.0	0.5	3
i7.03	95.16986	-0.5048418641	8.033751	8.031545	-20.0	0.5	3
i7.03	95.68177	-0.5026043653	8.031545	8.016482	-20.0	0.5	3
i7.03	96.19369	-0.4987414777	8.016482	8.026613	-20.0	0.5	3
i7.03	96.7056	-0.5033581853	8.026613	8.014761	-20.0	0.5	3
i7.03	97.21751	-0.4892404377	8.014761	8.020108	-20.0	0.5	3
i7.03	97.72942	-0.500054419	8.020108	8.018152	-20.0	0.5	3
i7.03	98.24133	-0.5046431422	8.018152	8.008303	-20.0	0.5	3
i7.03	98.75325	-0.5028968453	8.008303	8.009035	-20.0	0.5	3
i7.03	99.26516	-0.4884233475	8.009035	8.009837	-20.0	0.5	3
i7.03	99.77708	-0.5115956664	8.009837	8.005744	-20.0	0.5	3
i7.03	100.28899	-0.4880934656	8.005744	7.119047	-20.0	0.5	3
i7.03	100.8009	-0.500870049	7.119047	7.118728	-20.0	0.5	3
i7.03	101.31281	-0.5045052767	7.118728	7.119544	-20.0	0.5	3
i7.03	101.82472	-0.5020279288	7.119544	7.113925	-20.0	0.5	3
i7.03	102.33664	-0.5114212036	7.113925	7.111175	-20.0	0.5	3
i7.03	102.84855	-0.4876170158	7.111175	7.108747	-20.0	0.5	3
i7.03	103.36046	-0.4991333783	7.108747	7.106224	-20.0	0.5	3
i7.03	103.872375	-0.4981181026	7.106224	7.102858	-20.0	0.5	3
i7.03	104.384285	-0.4876435399	7.102858	7.100052	-20.0	0.5	3
i7.03	104.8962	-0.4941647947	7.100052	7.097504	-20.0	0.5	3
i7.03	105.40811	-0.5080054402	7.097504	7.094911	-20.0	0.5	3
i7.03	105.92003	-0.4924952984	7.094911	7.092086	-20.0	0.5	3
i7.03	106.43194	-0.4899028242	7.092086	7.090000	-20.0	0.5	3
i7.03	106.94385	-0.5064539313	7.090000	7.090000	-20.0	0.5	3
i7.03	107.455765	-0.5013282895	7.090000	7.090000	-20.0	0.5	3
i7.03	107.96768	-0.4897444546	7.090000	7.090000	-20.0	0.5	3
i7.03	108.47959	-0.498244375	7.090000	7.090000	-20.0	0.5	3
i7.03	108.9915	-0.4939050674	7.090000	7.090000	-20.0	0.5	3
i7.03	109.50342	-0.4870518744	7.090000	7.090000	-20.0	0.5	3
i7.03	110.01533	-0.502153337	7.090000	7.090000	-20.0	0.5	3
i7.03	110.527245	-0.4890980721	7.090000	7.090000	-20.0	0.5	3
i7.03	111.039154	-0.4988260865	7.090000	7.090000	-20.0	0.5	3
i7.03	111.55107	-0.4933356643	7.090000	7.090000	-20.0	0.5	3
i7.03	112.06298	-0.4943183959	7.090000	7.090000	-20.0	0.5	3
i7.03	112.57489	-0.4927352667	7.090000	7.090000	-20.0	0.5	3
i7.03	113.08681	-0.48894611	7.090000	7.090000	-20.0	0.5	3
i7.03	113.59872	-0.4926908016	7.090000	7.090000	-20.0	0.5	3
i7.03	114.110634	-0.4992585182	7.090000	7.090000	-20.470632	0.5	3
i7.03	114.62254	-0.4972780645	7.090000	7.090000	-26.376506	0.5	3
i7.03	115.13446	-0.4899776578	7.090000	7.090000	-32.282379	0.5	3
i7.03	115.64637	-0.5083814263	7.090000	7.090000	-38.188253	0.5	3
i7.03	116.15828	0.499697417	7.090000	7.090000	-44.094126	0.5	3
i7.00	229.83333	50.1917686462	8.06	8.06	-18.0	-0.5	1
i7.01	229.83333	50.5	8.1	8.1	-18.0	-0.166666666667	1
i7.02	229.83333	50.4944915771	9.02	9.02	-18.0	0.166666666667	1
i7.03	229.83333	50.4788246155	9.06	9.06	-18.0	0.5	1
i7.00	283.33328	0.0400570892	10.03	10.03	-17.5357753445	-0.5	0
i7.00	283.4134	0.0400570892	10.03	10.03	-17.5357753445	-0.5	0
i7.00	283.4935	0.0400570892	10.03	10.03	-17.5357753445	-0.5	0
i7.00	288.3716	0.0407592878	10.03	10.03	-18.0102086918	-0.5	0
i7.00	288.45312	0.0407592878	10.03	10.03	-18.0102086918	-0.5	0
i7.00	288.53464	0.0407592878	10.03	10.03	-18.0102086918	-0.5	0
i7.00	293.7543	0.0417860225	10.03	10.03	-17.7633918079	-0.5	0
i7.00	293.8379	0.0417860225	10.03	10.03	-17.7633918079	-0.5	0
i7.00	293.92145	0.0417860225	10.03	10.03	-17.7633918079	-0.5	0
i7.00	299.50568	0.0427459367	10.03	10.03	-17.4035534614	-0.5	0
i7.00	299.59116	0.0427459367	10.03	10.03	-17.4035534614	-0.5	0
i7.00	299.67667	0.0427459367	10.03	10.03	-17.4035534614	-0.5	0
i7.00	304.10104	0.0407014191	10.03	10.03	-17.7697530431	-0.5	0
i7.00	304.18243	0.0407014191	10.03	10.03	-17.7697530431	-0.5	0
i7.00	304.26385	0.0407014191	10.03	10.03	-17.7697530431	-0.5	0
i7.00	308.83575	0.0401079021	10.03	10.03	-17.942916259	-0.5	0
i7.00	308.916	0.0401079021	10.03	10.03	-17.942916259	-0.5	0
i7.00	308.9962	0.0401079021	10.03	10.03	-17.942916259	-0.5	0
i7.00	314.1232	0.0405335687	10.03	10.03	-17.2563530399	-0.5	0
i7.00	314.20428	0.0405335687	10.03	10.03	-17.2563530399	-0.5	0
i7.00	314.28534	0.0405335687	10.03	10.03	-17.2563530399	-0.5	0
i7.00	321.2466	0.0428545848	10.03	10.03	-17.6987191796	-0.5	0
i7.00	321.33234	0.0428545848	10.03	10.03	-17.6987191796	-0.5	0
i7.00	321.41803	0.0428545848	10.03	10.03	-17.6987191796	-0.5	0
i7.00	325.38043	0.0413466617	10.03	10.03	-17.6133139896	-0.5	0
i7.00	325.46313	0.0413466617	10.03	10.03	-17.6133139896	-0.5	0
i7.00	325.5458	0.0413466617	10.03	10.03	-17.6133139896	-0.5	0
i7.00	329.63104	0.0404512025	10.03	10.03	-17.295511817	-0.5	0
i7.00	329.7119	0.0404512025	10.03	10.03	-17.295511817	-0.5	0
i7.00	329.79285	0.0404512025	10.03	10.03	-17.295511817	-0.5	0
i4.00	76.08331	-1.0293390751	9.090040	9.090040	-20.0	-0.1	3
i4.00	77.14499	-1.0193817616	9.090040	9.093836	-19.7298	-0.1	3
i4.00	78.20667	-1.0279995203	9.093836	9.095982	-19.494276	-0.1	3
i4.00	79.26835	-1.0388308764	9.095982	9.097623	-19.362157	-0.1	3
i4.00	80.33002	-1.0161852837	9.097623	9.100096	-19.194662	-0.1	3
i4.00	81.3917	-1.043223381	9.100096	9.102835	-18.841053	-0.1	3
i4.00	82.45338	-1.0384321213	9.102835	9.105544	-18.761312	-0.1	3
i4.00	83.51505	-1.0440417528	9.105544	9.108636	-18.637893	-0.1	3
i4.00	84.57673	-1.0179973841	9.108636	9.107935	-18.329594	-0.1	3
i4.00	85.638405	-1.0431630611	9.107935	9.112937	-18.067406	-0.1	3
i4.00	86.70008	-1.05562222	9.112937	9.114043	-17.83501	-0.1	3
i4.00	87.76176	-1.0499339104	9.114043	9.116086	-17.736191	-0.1	3
i4.00	88.82343	-1.0357762575	9.116086	10.000770	-17.626646	-0.1	3
i4.00	89.88512	-1.016056776	10.000770	9.119487	-17.405848	-0.1	3
i4.00	90.946785	-1.0340051651	9.119487	10.007174	-17.086082	-0.1	3
i4.00	92.00847	-1.0488137007	10.007174	10.010937	-16.915415	-0.1	3
i4.00	93.070145	-1.0308984518	10.010937	10.011179	-16.745155	-0.1	3
i4.00	94.13182	-1.0155761242	10.011179	10.005990	-16.360703	-0.1	3
i4.00	95.1935	-1.0201745033	10.005990	10.011663	-16.406051	-0.1	3
i4.00	96.25517	-1.012557745	10.011663	10.011851	-16.075739	-0.1	3
i4.00	97.31685	-1.037121892	10.011851	10.016489	-16.008527	-0.1	3
i4.00	98.378525	-1.0515533686	10.016489	10.025138	-16.090093	-0.1	3
i4.00	99.4402	-1.017698884	10.025138	10.021665	-15.558977	-0.1	3
i4.00	100.50188	-1.0562034845	10.021665	10.018400	-15.244892	-0.1	3
i4.00	101.56355	-1.0113083124	10.018400	10.018574	-14.86823	-0.1	3
i4.00	102.62523	-1.0300205946	10.018574	10.019004	-14.678555	-0.1	3
i4.00	103.686905	-1.0129463673	10.019004	10.019791	-15.236072	-0.1	3
i4.00	104.74858	-1.0166317225	10.019791	10.019926	-15.8601	-0.1	3
i4.00	105.810265	-1.0140286684	10.019926	10.019224	-16.295162	-0.1	3
i4.00	106.87193	-1.0361204147	10.019224	10.019689	-16.390226	-0.1	3
i4.00	107.93361	-1.020347476	10.019689	10.019618	-16.728106	-0.1	3
i4.00	108.99529	-1.0159959793	10.019618	10.019522	-16.883618	-0.1	3
i4.00	110.05697	-1.0593430996	10.019522	10.019566	-17.414418	-0.1	3
i4.00	111.118645	-1.0615990162	10.019566	10.019576	-17.717284	-0.1	3
i4.00	112.18033	-1.0301452875	10.019576	10.019510	-17.985869	-0.1	3
i4.00	113.242	-1.0376005173	10.019510	10.019457	-18.408574	-0.1	3
i4.00	114.30368	-1.046759367	10.019457	10.019587	-18.743321	-0.1	3
i4.00	115.36536	-1.0323519707	10.019587	10.019624	-19.070716	-0.1	3
i4.00	116.427025	-1.0321128368	10.019624	10.019449	-19.324261	-0.1	3
i4.00	117.48871	-1.0469995737	10.019449	10.019471	-19.703719	-0.1	3
i4.00	118.550385	-1.056666255	10.019471	10.019394	-20.233642	-0.1	3
i4.00	119.61206	-1.0284327269	10.019394	10.019642	-23.210278	-0.1	3
i4.00	120.67374	-1.0424849987	10.019642	10.019630	-26.186914	-0.1	3
i4.00	121.73541	-1.0100493431	10.019630	10.019481	-29.16355	-0.1	3
i4.00	122.79709	-1.0603888035	10.019481	10.019669	-32.140185	-0.1	3
i4.00	123.858765	-1.012078166	10.019669	10.019515	-35.116821	-0.1	3
i4.00	124.92044	-1.0274397135	10.019515	10.019543	-38.093457	-0.1	3
i4.00	125.98212	-1.0131001472	10.019543	10.019659	-41.070093	-0.1	3
i4.00	127.04379	-1.0474766493	10.019659	10.019614	-44.046728	-0.1	3
i4.00	128.10547	1.0611770153	10.019614	10.019548	-47.023364	-0.1	3
i4.01	76.89772	-1.0377063751	9.090048	9.090048	-20.0	0	3
i4.01	77.94311	-1.0417259932	9.090048	9.095637	-19.593223	0	3
i4.01	78.9885	-0.9946000576	9.095637	9.097791	-19.399822	0	3
i4.01	80.03389	-1.042189002	9.097791	9.100677	-19.201583	0	3
i4.01	81.07928	-1.0231225491	9.100677	9.103311	-18.898427	0	3
i4.01	82.124664	-0.9928637147	9.103311	9.104215	-18.833844	0	3
i4.01	83.17005	-1.0060558319	9.104215	9.107710	-18.586971	0	3
i4.01	84.21544	-1.0291979313	9.107710	9.109502	-18.469632	0	3
i4.01	85.260826	-1.017095089	9.109502	9.113676	-18.219593	0	3
i4.01	86.30622	-1.0450321436	9.113676	9.116660	-17.900053	0	3
i4.01	87.35161	-1.0178210735	9.116660	9.117749	-17.885306	0	3
i4.01	88.396996	-1.0364439487	9.117749	10.001757	-17.625177	0	3
i4.01	89.44238	-1.008136034	10.001757	10.005730	-17.647897	0	3
i4.01	90.48778	-1.0086344481	10.005730	10.007339	-17.190029	0	3
i4.01	91.533165	-1.0104341507	10.007339	10.004599	-16.995758	0	3
i4.01	92.57855	-0.9922505617	10.004599	10.002900	-16.827045	0	3
i4.01	93.62394	-1.037416935	10.002900	10.010192	-16.616803	0	3
i4.01	94.66933	-1.0065901279	10.010192	10.011304	-16.462539	0	3
i4.01	95.714714	-1.0055017471	10.011304	10.018903	-16.207237	0	3
i4.01	96.7601	-1.0184043646	10.018903	10.010588	-16.323039	0	3
i4.01	97.8055	-1.0289508104	10.010588	10.022028	-15.620825	0	3
i4.01	98.85088	-1.0315138102	10.022028	10.029462	-15.71364	0	3
i4.01	99.89627	-1.0221344233	10.029462	10.030853	-15.323291	0	3
i4.01	100.94166	-1.040497303	10.030853	10.026217	-15.216882	0	3
i4.01	101.987045	-1.0260865688	10.026217	10.027562	-15.384852	0	3
i4.01	103.03244	-1.0120439529	10.027562	10.033968	-15.322587	0	3
i4.01	104.07782	-1.0434349775	10.033968	10.031609	-15.360977	0	3
i4.01	105.123215	-1.0319228172	10.031609	10.036105	-16.050198	0	3
i4.01	106.168594	-0.9998857975	10.036105	10.036070	-16.181678	0	3
i4.01	107.21399	-1.001372695	10.036070	10.038480	-16.674957	0	3
i4.01	108.25938	-1.0392534733	10.038480	10.039310	-16.641222	0	3
i4.01	109.30476	-1.028268218	10.039310	10.039418	-17.045801	0	3
i4.01	110.35016	-1.0220631361	10.039418	10.039519	-17.457889	0	3
i4.01	111.395546	-1.0407795906	10.039519	10.039444	-17.866199	0	3
i4.01	112.44093	-0.9989929795	10.039444	10.039617	-18.14556	0	3
i4.01	113.48633	-1.0176525116	10.039617	10.039664	-18.378657	0	3
i4.01	114.53171	-1.0373393297	10.039664	10.039695	-18.8179	0	3
i4.01	115.577095	-1.0049499273	10.039695	10.039448	-19.101678	0	3
i4.01	116.62248	-0.9946577549	10.039448	10.039688	-19.421676	0	3
i4.01	117.66788	-1.017313242	10.039688	10.039685	-19.76248	0	3
i4.01	118.713264	-1.0403237343	10.039685	10.039619	-20.690315	0	3
i4.01	119.75865	-1.0200213194	10.039619	10.039398	-23.621284	0	3
i4.01	120.80405	-1.0380676985	10.039398	10.039499	-26.552252	0	3
i4.01	121.84943	-1.0339462757	10.039499	10.039537	-29.483221	0	3
i4.01	122.89482	-1.0078670979	10.039537	10.039739	-32.414189	0	3
i4.01	123.94021	-1.0406574011	10.039739	10.039445	-35.345158	0	3
i4.01	124.985596	-1.0407249928	10.039445	10.039473	-38.276126	0	3
i4.01	126.03098	-0.9939646125	10.039473	10.039542	-41.207095	0	3
i4.01	127.07637	-1.0232439041	10.039542	10.039493	-44.138063	0	3
i4.01	128.12177	0.9945453405	10.039493	10.039635	-47.069032	0	3
i4.02	77.62395	-1.0220153332	9.090044	9.090044	-20.0	0.1	3
i4.02	78.654816	-1.0095517635	9.090044	9.097742	-19.486034	0.1	3
i4.02	79.68568	-1.0245330334	9.097742	9.099114	-19.222768	0.1	3
i4.02	80.71654	-1.0125728846	9.099114	9.100756	-19.041548	0.1	3
i4.02	81.747406	-1.0171687603	9.100756	9.101016	-18.844143	0.1	3
i4.02	82.77827	-1.0154510736	9.101016	9.106754	-18.584598	0.1	3
i4.02	83.80913	-1.0095391273	9.106754	9.109203	-18.572856	0.1	3
i4.02	84.84	-1.0244543552	9.109203	9.110326	-18.378864	0.1	3
i4.02	85.87086	-1.029189229	9.110326	9.112426	-18.182949	0.1	3
i4.02	86.90172	-0.977748096	9.112426	9.114035	-18.06655	0.1	3
i4.02	87.932594	-1.0158600807	9.114035	10.002171	-17.662973	0.1	3
i4.02	88.963455	-1.0160146952	10.002171	10.002235	-17.417297	0.1	3
i4.02	89.994316	-0.9915301204	10.002235	9.118857	-17.491351	0.1	3
i4.02	91.025185	-0.9886395335	9.118857	10.002191	-17.141657	0.1	3
i4.02	92.056046	-0.988356173	10.002191	10.008753	-17.193867	0.1	3
i4.02	93.08691	-1.000612855	10.008753	10.008944	-16.641125	0.1	3
i4.02	94.117775	-0.9847729802	10.008944	10.013338	-16.648346	0.1	3
i4.02	95.148636	-1.0027881861	10.013338	10.015052	-16.050697	0.1	3
i4.02	96.179504	-1.0035465956	10.015052	10.022923	-16.000955	0.1	3
i4.02	97.210365	-0.9937050939	10.022923	10.017068	-15.968361	0.1	3
i4.02	98.24123	-0.9962109923	10.017068	10.020153	-15.604413	0.1	3
i4.02	99.272095	-1.0014380217	10.020153	10.013813	-15.460786	0.1	3
i4.02	100.302956	-1.0180203915	10.013813	10.012232	-15.314164	0.1	3
i4.02	101.33382	-0.9855005145	10.012232	10.007177	-15.512597	0.1	3
i4.02	102.364685	-0.9840651155	10.007177	10.009981	-15.080391	0.1	3
i4.02	103.395546	-1.0221239328	10.009981	10.007100	-15.447133	0.1	3
i4.02	104.426414	-0.9873405695	10.007100	10.004742	-15.744471	0.1	3
i4.02	105.457275	-0.9817181826	10.004742	10.002507	-15.89723	0.1	3
i4.02	106.488144	-1.012630105	10.002507	10.001612	-16.437109	0.1	3
i4.02	107.519005	-0.9877122641	10.001612	9.119832	-16.443292	0.1	3
i4.02	108.549866	-0.9942347407	9.119832	9.119639	-16.816663	0.1	3
i4.02	109.580734	-1.0196144581	9.119639	9.119691	-17.304237	0.1	3
i4.02	110.611595	-1.0227181911	9.119691	9.119586	-17.599303	0.1	3
i4.02	111.642456	-1.0274963379	9.119586	9.119515	-17.856957	0.1	3
i4.02	112.673325	-1.0294078588	9.119515	9.119646	-18.11286	0.1	3
i4.02	113.70419	-0.9819696546	9.119646	9.119621	-18.434689	0.1	3
i4.02	114.73505	-1.0159238577	9.119621	9.119456	-18.850427	0.1	3
i4.02	115.765915	-1.0252320766	9.119456	9.119384	-19.180566	0.1	3
i4.02	116.79678	-0.9806961417	9.119384	9.119493	-19.475347	0.1	3
i4.02	117.827644	-1.0021964312	9.119493	9.119715	-19.802608	0.1	3
i4.02	118.858505	-0.9954482317	9.119715	9.119564	-21.097541	0.1	3
i4.02	119.88937	-0.9979134798	9.119564	9.119460	-23.987787	0.1	3
i4.02	120.92024	-1.0129816532	9.119460	9.119332	-26.878033	0.1	3
i4.02	121.9511	-0.9991455078	9.119332	9.119457	-29.768279	0.1	3
i4.02	122.981964	-1.0030292273	9.119457	9.119591	-32.658524	0.1	3
i4.02	124.01283	-1.0116471052	9.119591	9.119440	-35.54877	0.1	3
i4.02	125.04369	-1.0227973461	9.119440	9.119463	-38.439016	0.1	3
i4.02	126.074554	-1.01407969	9.119463	9.119491	-41.329262	0.1	3
i4.02	127.10542	-1.0084044933	9.119491	9.119469	-44.219508	0.1	3
i4.02	128.13629	1.0027930737	9.119469	9.119489	-47.109754	0.1	3
i4.00	156.69087	-0.987447679	9.090037	9.090037	-20.0	-0.1	3
i4.00	157.72723	-1.0344479084	9.090037	9.096364	-19.490007	-0.1	3
i4.00	158.76361	-0.9896178842	9.096364	9.099667	-19.322133	-0.1	3
i4.00	159.79999	-1.0121622086	9.099667	9.102209	-19.097563	-0.1	3
i4.00	160.83635	-0.9992687106	9.102209	9.103348	-18.897564	-0.1	3
i4.00	161.87273	-1.0184739828	9.103348	9.107540	-18.716908	-0.1	3
i4.00	162.9091	-1.0330536366	9.107540	9.112198	-18.467907	-0.1	3
i4.00	163.94548	-1.001680851	9.112198	9.108314	-18.343774	-0.1	3
i4.00	164.98184	-1.0024635792	9.108314	9.111700	-18.168142	-0.1	3
i4.00	166.01822	-0.9987315536	9.111700	9.116528	-18.012418	-0.1	3
i4.00	167.05458	-0.9895380139	9.116528	9.119767	-17.892221	-0.1	3
i4.00	168.09096	-0.99484092	9.119767	10.001380	-17.616854	-0.1	3
i4.00	169.12733	-1.0335874557	10.001380	10.003282	-17.365783	-0.1	3
i4.00	170.1637	-0.9918810725	10.003282	10.005554	-17.332027	-0.1	3
i4.00	171.20007	-1.0144119263	10.005554	10.011145	-16.945424	-0.1	3
i4.00	172.23645	-1.0252174139	10.011145	10.008348	-16.644327	-0.1	3
i4.00	173.27281	-1.0068771839	10.008348	10.013713	-16.475577	-0.1	3
i4.00	174.30919	-0.9870339632	10.013713	10.009940	-16.279781	-0.1	3
i4.00	175.34557	-1.0043977499	10.009940	10.016081	-16.228207	-0.1	3
i4.00	176.38193	-1.0346245766	10.016081	10.020134	-15.86213	-0.1	3
i4.00	177.4183	-1.0278906822	10.020134	10.015183	-16.009158	-0.1	3
i4.00	178.45468	-1.022870779	10.015183	10.024275	-15.544076	-0.1	3
i4.00	179.49104	-1.0342366695	10.024275	10.021174	-15.154065	-0.1	3
i4.00	180.52742	-0.9955596924	10.021174	10.018653	-15.472707	-0.1	3
i4.00	181.56378	-0.993573606	10.018653	10.018357	-14.893618	-0.1	3
i4.00	182.60016	-0.9931263924	10.018357	10.021204	-15.148242	-0.1	3
i4.00	183.63654	-1.0158770084	10.021204	10.018735	-15.637303	-0.1	3
i4.00	184.6729	-1.0124713182	10.018735	10.019917	-15.864492	-0.1	3
i4.00	185.70927	-1.0163606405	10.019917	10.019256	-16.357394	-0.1	3
i4.00	186.74565	-1.016825676	10.019256	10.019889	-16.760544	-0.1	3
i4.00	187.78201	-0.9986534715	10.019889	10.019472	-16.920071	-0.1	3
i4.00	188.81839	-1.002686739	10.019472	10.019665	-17.339335	-0.1	3
i4.00	189.85477	-1.0013968945	10.019665	10.019533	-17.474618	-0.1	3
i4.00	190.89113	-0.9889574647	10.019533	10.019699	-17.755112	-0.1	3
i4.00	191.9275	-1.0084704161	10.019699	10.019638	-18.184299	-0.1	3
i4.00	192.96388	-0.9883186221	10.019638	10.019611	-18.503655	-0.1	3
i4.00	194.00024	-0.9971567988	10.019611	10.019691	-18.909155	-0.1	3
i4.00	195.03662	-1.0157256126	10.019691	10.019578	-19.070964	-0.1	3
i4.00	196.073	-1.0291446447	10.019578	10.019674	-19.463859	-0.1	3
i4.00	197.10936	-1.0213109255	10.019674	10.019455	-19.785283	-0.1	3
i4.00	198.14574	-0.9954131246	10.019455	10.019429	-20.947968	-0.1	3
i4.00	199.1821	-1.0105097294	10.019429	10.019571	-23.853171	-0.1	3
i4.00	200.21848	-1.0246090889	10.019571	10.019592	-26.758374	-0.1	3
i4.00	201.25485	-1.0036427975	10.019592	10.019497	-29.663577	-0.1	3
i4.00	202.29123	-1.0206661224	10.019497	10.019584	-32.568781	-0.1	3
i4.00	203.32759	-0.9990543723	10.019584	10.019580	-35.473984	-0.1	3
i4.00	204.36397	-0.9971936941	10.019580	10.019640	-38.379187	-0.1	3
i4.00	205.40033	-1.0333695412	10.019640	10.019546	-41.28439	-0.1	3
i4.00	206.4367	-1.0067485571	10.019546	10.019627	-44.189594	-0.1	3
i4.00	207.47308	1.0269508362	10.019627	10.019415	-47.094797	-0.1	3
i4.01	155.91882	-1.0094569921	9.090048	9.090048	-20.0	0	3
i4.01	156.97064	-1.005807519	9.090048	9.095090	-19.639449	0	3
i4.01	158.02245	-1.0367144346	9.095090	9.097126	-19.432626	0	3
i4.01	159.07426	-1.0106598139	9.097126	9.101104	-19.196516	0	3
i4.01	160.12608	-1.0508533716	9.101104	9.101227	-19.019198	0	3
i4.01	161.17789	-1.0016280413	9.101227	9.104162	-18.819236	0	3
i4.01	162.2297	-1.0001522303	9.104162	9.108321	-18.668324	0	3
i4.01	163.28152	-1.0368487835	9.108321	9.108953	-18.46766	0	3
i4.01	164.33333	-1.0454514027	9.108953	9.111806	-18.342225	0	3
i4.01	165.38513	-1.0016131401	9.111806	9.114884	-18.125989	0	3
i4.01	166.43695	-1.0430971384	9.114884	9.117593	-17.793519	0	3
i4.01	167.48877	-1.038005352	9.117593	9.119157	-17.811332	0	3
i4.01	168.54057	-1.0507959127	9.119157	10.001990	-17.361215	0	3
i4.01	169.59239	-1.0088766813	10.001990	10.004443	-17.396432	0	3
i4.01	170.64421	-1.0153055191	10.004443	10.006393	-17.159962	0	3
i4.01	171.69601	-1.0406299829	10.006393	10.013473	-16.991714	0	3
i4.01	172.74783	-1.0384565592	10.013473	10.008466	-16.721318	0	3
i4.01	173.79964	-1.0480818748	10.008466	10.010438	-16.283026	0	3
i4.01	174.85146	-0.9998013377	10.010438	10.018201	-15.922456	0	3
i4.01	175.90326	-1.0303434134	10.018201	10.013908	-16.147972	0	3
i4.01	176.95508	-1.0073471069	10.013908	10.020891	-16.069312	0	3
i4.01	178.0069	-1.0387917757	10.020891	10.017968	-15.608605	0	3
i4.01	179.0587	-1.0252646208	10.017968	10.020369	-15.652343	0	3
i4.01	180.11052	-1.0336967707	10.020369	10.018615	-15.486267	0	3
i4.01	181.16232	-1.0304867029	10.018615	10.017189	-15.270821	0	3
i4.01	182.21414	-1.0473624468	10.017189	10.022354	-15.077654	0	3
i4.01	183.26596	-1.0499849319	10.022354	10.022292	-15.856487	0	3
i4.01	184.31776	-1.0441639423	10.022292	10.019996	-15.457701	0	3
i4.01	185.36957	-1.0058516264	10.019996	10.019464	-16.023997	0	3
i4.01	186.42139	-1.0277712345	10.019464	10.019454	-16.488731	0	3
i4.01	187.4732	-1.0377498865	10.019454	10.019586	-16.625531	0	3
i4.01	188.52501	-1.043304801	10.019586	10.019438	-16.88086	0	3
i4.01	189.57683	-1.0511801243	10.019438	10.019609	-17.351443	0	3
i4.01	190.62865	-1.0245141983	10.019609	10.019542	-17.774539	0	3
i4.01	191.68045	-1.0375391245	10.019542	10.019418	-18.002301	0	3
i4.01	192.73227	-1.049495697	10.019418	10.019642	-18.434794	0	3
i4.01	193.78407	-1.0382459164	10.019642	10.019576	-18.771781	0	3
i4.01	194.83589	-1.0465182066	10.019576	10.019551	-19.086354	0	3
i4.01	195.8877	-1.0011730194	10.019551	10.019635	-19.436682	0	3
i4.01	196.93951	-1.0070074797	10.019635	10.019532	-19.729126	0	3
i4.01	197.99133	-1.0148532391	10.019532	10.019644	-20.515123	0	3
i4.01	199.04314	-1.0115447044	10.019644	10.019581	-23.463611	0	3
i4.01	200.09496	-1.0173705816	10.019581	10.019591	-26.412099	0	3
i4.01	201.14676	-1.049698472	10.019591	10.019685	-29.360586	0	3
i4.01	202.19858	-1.0124717951	10.019685	10.019747	-32.309074	0	3
i4.01	203.2504	-1.0250635147	10.019747	10.019474	-35.257562	0	3
i4.01	204.3022	-1.0148541927	10.019474	10.019501	-38.206049	0	3
i4.01	205.354	-1.025619626	10.019501	10.019456	-41.154537	0	3
i4.01	206.40582	-1.0236532688	10.019456	10.019678	-44.103025	0	3
i4.01	207.45764	1.0100870132	10.019678	10.019455	-47.051512	0	3
i4.02	157.0489	-0.9844933152	9.090062	9.090062	-20.0	0.1	3
i4.02	158.07811	-0.9936055541	9.090062	9.096345	-19.421356	0.1	3
i4.02	159.10733	-0.9895111322	9.096345	9.098861	-19.183465	0.1	3
i4.02	160.13654	-0.9922509789	9.098861	9.103673	-19.065383	0.1	3
i4.02	161.16576	-0.9806129336	9.103673	9.104595	-18.846321	0.1	3
i4.02	162.19496	-1.0131216049	9.104595	9.107850	-18.622289	0.1	3
i4.02	163.22417	-0.9813613296	9.107850	9.106944	-18.534929	0.1	3
i4.02	164.25339	-0.9975891113	9.106944	9.112584	-18.283892	0.1	3
i4.02	165.2826	-0.992297411	9.112584	9.113218	-18.127932	0.1	3
i4.02	166.3118	-1.0082373619	9.113218	9.118973	-17.847783	0.1	3
i4.02	167.34102	-1.0070573092	9.118973	9.117103	-17.601822	0.1	3
i4.02	168.37022	-1.0227757692	9.117103	10.001752	-17.466217	0.1	3
i4.02	169.39944	-0.9850674868	10.001752	10.004716	-17.333189	0.1	3
i4.02	170.42865	-1.0044711828	10.004716	10.002799	-17.075928	0.1	3
i4.02	171.45786	-1.0263282061	10.002799	10.011650	-17.020776	0.1	3
i4.02	172.48708	-1.0228499174	10.011650	10.012549	-16.578318	0.1	3
i4.02	173.51628	-1.0134739876	10.012549	10.009377	-16.536277	0.1	3
i4.02	174.54549	-0.9904296994	10.009377	10.012904	-16.296387	0.1	3
i4.02	175.5747	-0.9786610603	10.012904	10.013949	-16.396596	0.1	3
i4.02	176.60391	-1.0201793909	10.013949	10.020625	-16.078517	0.1	3
i4.02	177.63312	-1.0071628094	10.020625	10.014383	-15.711068	0.1	3
i4.02	178.66234	-1.021206975	10.014383	10.008862	-15.637608	0.1	3
i4.02	179.69154	-0.9996946454	10.008862	10.013325	-15.472739	0.1	3
i4.02	180.72076	-1.0041261911	10.013325	10.011365	-14.662839	0.1	3
i4.02	181.74997	-0.9967252612	10.011365	10.009616	-15.043662	0.1	3
i4.02	182.77917	-1.0108865499	10.009616	10.006881	-15.213795	0.1	3
i4.02	183.8084	-0.9948559403	10.006881	10.005385	-15.896962	0.1	3
i4.02	184.8376	-0.9898508191	10.005385	10.003046	-15.84451	0.1	3
i4.02	185.8668	-1.0070505142	10.003046	10.001378	-16.369186	0.1	3
i4.02	186.89603	-1.0164604187	10.001378	9.119615	-16.70899	0.1	3
i4.02	187.92523	-0.9964175224	9.119615	9.119615	-16.967347	0.1	3
i4.02	188.95444	-1.0070220232	9.119615	9.119484	-17.24025	0.1	3
i4.02	189.98366	-1.005076766	9.119484	9.119657	-17.60791	0.1	3
i4.02	191.01286	-1.00279212	9.119657	9.119587	-17.881171	0.1	3
i4.02	192.04208	-1.0291261673	9.119587	9.119449	-18.316786	0.1	3
i4.02	193.07129	-1.0224157572	9.119449	9.119598	-18.498212	0.1	3
i4.02	194.1005	-1.0283455849	9.119598	9.119591	-18.84721	0.1	3
i4.02	195.12971	-1.0229356289	9.119591	9.119532	-19.115674	0.1	3
i4.02	196.15892	-1.0016515255	9.119532	9.119423	-19.468342	0.1	3
i4.02	197.18813	-1.0185517073	9.119423	9.119603	-19.807278	0.1	3
i4.02	198.21735	-1.010787487	9.119603	9.119589	-21.148701	0.1	3
i4.02	199.24655	-1.0123559237	9.119589	9.119510	-24.033831	0.1	3
i4.02	200.27576	-1.0051845312	9.119510	9.119522	-26.918961	0.1	3
i4.02	201.30498	-1.0115189552	9.119522	9.119675	-29.804091	0.1	3
i4.02	202.33418	-1.0030819178	9.119675	9.119592	-32.689221	0.1	3
i4.02	203.3634	-0.9891204238	9.119592	9.119535	-35.574351	0.1	3
i4.02	204.39261	-0.978704989	9.119535	9.119628	-38.459481	0.1	3
i4.02	205.42181	-0.9792104363	9.119628	9.119572	-41.34461	0.1	3
i4.02	206.45103	-1.0154691935	9.119572	9.119456	-44.22974	0.1	3
i4.02	207.48024	1.0073281527	9.119456	9.119663	-47.11487	0.1	3
i4.00	237.50003	53.5	9.07	9.07	-28.0	-0.1	1
i4.01	237.50003	53.3210449219	10.02	10.02	-28.0	0	1
i4.02	237.50003	53.228427887	10.09	10.09	-28.0	0.1	1
i4.00	305.23456	-1.0542482138	10.000067	10.000067	-20.0	-0.1	3
i4.00	306.3033	-1.0423169136	10.000067	10.001051	-19.791598	-0.1	3
i4.00	307.37204	-1.0591729879	10.001051	10.002057	-19.580847	-0.1	3
i4.00	308.4408	-1.0303069353	10.002057	10.003359	-19.418275	-0.1	3
i4.00	309.50952	-1.0349737406	10.003359	10.003831	-19.224195	-0.1	3
i4.00	310.57828	-1.0489014387	10.003831	10.005666	-18.904195	-0.1	3
i4.00	311.647	-1.0176497698	10.005666	10.006942	-18.803708	-0.1	3
i4.00	312.71576	-1.0358697176	10.006942	10.009405	-18.558972	-0.1	3
i4.00	313.7845	-1.0448336601	10.009405	10.008408	-18.409141	-0.1	3
i4.00	314.85324	-1.0174788237	10.008408	10.007445	-18.313525	-0.1	3
i4.00	315.92197	-1.0654244423	10.007445	10.013597	-18.133684	-0.1	3
i4.00	316.99072	-1.0646806955	10.013597	10.012243	-18.018841	-0.1	3
i4.00	318.05945	-1.0184286833	10.012243	10.010693	-17.576023	-0.1	3
i4.00	319.1282	-1.0674823523	10.010693	10.014007	-17.412853	-0.1	3
i4.00	320.19693	-1.0654063225	10.014007	10.016252	-17.155977	-0.1	3
i4.00	321.2657	-1.0440578461	10.016252	10.012530	-16.812936	-0.1	3
i4.00	322.3344	-1.0242182016	10.012530	10.014763	-16.814699	-0.1	3
i4.00	323.40317	-1.0614156723	10.014763	10.010881	-16.646963	-0.1	3
i4.00	324.4719	-1.0364751816	10.010881	10.014493	-16.395633	-0.1	3
i4.00	325.54065	-1.0454107523	10.014493	10.017760	-16.297323	-0.1	3
i4.00	326.60938	-1.0528051853	10.017760	10.015984	-16.122423	-0.1	3
i4.00	327.6781	-1.0675737858	10.015984	10.022574	-15.757688	-0.1	3
i4.00	328.74686	-1.0319187641	10.022574	10.030130	-15.568526	-0.1	3
i4.00	329.81558	-1.0168617964	10.030130	10.023370	-15.53233	-0.1	3
i4.00	330.88434	-1.0512657166	10.023370	10.026365	-15.067406	-0.1	3
i4.00	331.95306	-1.0206311941	10.026365	10.029655	-15.086513	-0.1	3
i4.00	333.02182	-1.0177125931	10.029655	10.032133	-15.506756	-0.1	3
i4.00	334.09055	-1.0578130484	10.032133	10.032936	-15.902671	-0.1	3
i4.00	335.1593	-1.0307756662	10.032936	10.034124	-15.990066	-0.1	3
i4.00	336.22803	-1.0206929445	10.034124	10.037753	-16.575375	-0.1	3
i4.00	337.29678	-1.0648521185	10.037753	10.039534	-16.759749	-0.1	3
i4.00	338.3655	-1.0202139616	10.039534	10.039498	-17.100368	-0.1	3
i4.00	339.43427	-1.0183124542	10.039498	10.039576	-17.310774	-0.1	3
i4.00	340.503	-1.0177122355	10.039576	10.039541	-17.566577	-0.1	3
i4.00	341.57175	-1.0625904799	10.039541	10.039590	-18.103631	-0.1	3
i4.00	342.64047	-1.024397254	10.039590	10.039653	-18.343281	-0.1	3
i4.00	343.70923	-1.0198382139	10.039653	10.039490	-18.615468	-0.1	3
i4.00	344.77795	-1.0291608572	10.039490	10.039554	-18.984715	-0.1	3
i4.00	345.8467	-1.0466896296	10.039554	10.039494	-19.308849	-0.1	3
i4.00	346.91544	-1.0588308573	10.039494	10.039541	-19.672632	-0.1	3
i4.00	347.9842	-1.0490459204	10.039541	10.039531	-20.038113	-0.1	3
i4.00	349.05292	-1.0641183853	10.039531	10.039427	-23.034301	-0.1	3
i4.00	350.12167	-1.0559959412	10.039427	10.039500	-26.03049	-0.1	3
i4.00	351.1904	-1.0341802835	10.039500	10.039559	-29.026679	-0.1	3
i4.00	352.25916	-1.0269776583	10.039559	10.039455	-32.022868	-0.1	3
i4.00	353.32788	-1.0672194958	10.039455	10.039593	-35.019056	-0.1	3
i4.00	354.3966	-1.0470290184	10.039593	10.039576	-38.015245	-0.1	3
i4.00	355.46536	-1.032635808	10.039576	10.039437	-41.011434	-0.1	3
i4.00	356.5341	-1.0437247753	10.039437	10.039480	-44.007623	-0.1	3
i4.00	357.60284	1.063754797	10.039480	10.039576	-47.003811	-0.1	3
i4.01	306.14822	-1.0212357044	10.040058	10.040058	-20.0	0	3
i4.01	307.1987	-1.0112316608	10.040058	10.037606	-19.594586	0	3
i4.01	308.24915	-1.0294802189	10.037606	10.037181	-19.408435	0	3
i4.01	309.29962	-1.0315492153	10.037181	10.036891	-19.257918	0	3
i4.01	310.3501	-1.0041621923	10.036891	10.035506	-19.012279	0	3
i4.01	311.40057	-1.0071747303	10.035506	10.035167	-18.856533	0	3
i4.01	312.45102	-1.0052912235	10.035167	10.032958	-18.584223	0	3
i4.01	313.5015	-1.010841012	10.032958	10.031270	-18.444341	0	3
i4.01	314.55197	-1.0445359945	10.031270	10.033082	-18.3914	0	3
i4.01	315.60242	-1.0409327745	10.033082	10.030879	-17.868569	0	3
i4.01	316.6529	-1.0014845133	10.030879	10.025705	-17.771761	0	3
i4.01	317.70337	-1.0026838779	10.025705	10.026444	-17.820444	0	3
i4.01	318.7538	-1.0072898865	10.026444	10.020122	-17.454338	0	3
i4.01	319.8043	-1.0456523895	10.020122	10.026116	-17.489882	0	3
i4.01	320.85477	-1.0165928602	10.026116	10.026528	-17.107407	0	3
i4.01	321.90524	-1.0283555984	10.026528	10.028888	-16.814712	0	3
i4.01	322.9557	-1.0135548115	10.028888	10.020964	-16.764128	0	3
i4.01	324.00616	-1.0018818378	10.020964	10.025459	-16.623772	0	3
i4.01	325.05664	-1.0461415052	10.025459	10.017715	-16.462822	0	3
i4.01	326.1071	-1.0373389721	10.017715	10.028134	-16.222695	0	3
i4.01	327.15756	-1.0032254457	10.028134	10.023244	-15.716755	0	3
i4.01	328.20804	-1.0119293928	10.023244	10.026204	-15.556642	0	3
i4.01	329.25848	-1.0019819736	10.026204	10.021138	-15.369197	0	3
i4.01	330.30896	-1.0397129059	10.021138	10.023411	-15.023884	0	3
i4.01	331.35944	-1.0023268461	10.023411	10.029640	-15.150815	0	3
i4.01	332.4099	-1.0016613007	10.029640	10.028115	-15.155826	0	3
i4.01	333.46036	-1.0246194601	10.028115	10.032779	-15.353988	0	3
i4.01	334.51083	-1.0429493189	10.032779	10.035002	-15.682278	0	3
i4.01	335.5613	-1.0040103197	10.035002	10.035883	-16.223316	0	3
i4.01	336.61176	-1.0366276503	10.035883	10.038350	-16.520796	0	3
i4.01	337.66223	-1.0314975977	10.038350	10.039530	-16.675895	0	3
i4.01	338.7127	-1.0041567087	10.039530	10.039544	-17.133999	0	3
i4.01	339.76318	-1.028938055	10.039544	10.039570	-17.366899	0	3
i4.01	340.81363	-0.9984140396	10.039570	10.039578	-17.799154	0	3
i4.01	341.8641	-1.003521204	10.039578	10.039321	-18.096287	0	3
i4.01	342.91458	-1.0208797455	10.039321	10.039395	-18.448185	0	3
i4.01	343.96503	-1.031208396	10.039395	10.039607	-18.774008	0	3
i4.01	345.0155	-1.0469084978	10.039607	10.039523	-19.050291	0	3
i4.01	346.06598	-1.0198816061	10.039523	10.039582	-19.417699	0	3
i4.01	347.11646	-1.0041205883	10.039582	10.039414	-19.71898	0	3
i4.01	348.1669	-1.0332279205	10.039414	10.039487	-20.550395	0	3
i4.01	349.21738	-1.0332481861	10.039487	10.039487	-23.495356	0	3
i4.01	350.26785	-1.0218098164	10.039487	10.039462	-26.440316	0	3
i4.01	351.3183	-1.0121532679	10.039462	10.039517	-29.385277	0	3
i4.01	352.36877	-1.0502376556	10.039517	10.039656	-32.330237	0	3
i4.01	353.41925	-1.0422816277	10.039656	10.039489	-35.275198	0	3
i4.01	354.46973	-1.0273783207	10.039489	10.039626	-38.220158	0	3
i4.01	355.52017	-1.0497843027	10.039626	10.039625	-41.165119	0	3
i4.01	356.57065	-0.9988565445	10.039625	10.039468	-44.110079	0	3
i4.01	357.62112	1.0160204172	10.039468	10.039436	-47.05504	0	3
i4.02	307.13297	-1.0113850832	10.040040	10.040040	-20.0	0.1	3
i4.02	308.16373	-0.9861552715	10.040040	10.036661	-19.4147	0.1	3
i4.02	309.19452	-0.9911667109	10.036661	10.035946	-19.218747	0.1	3
i4.02	310.22528	-1.0109713078	10.035946	10.034539	-19.052675	0.1	3
i4.02	311.25604	-0.9805733562	10.034539	10.034091	-18.873658	0.1	3
i4.02	312.28683	-1.0155959129	10.034091	10.038071	-18.598385	0.1	3
i4.02	313.3176	-0.9802286029	10.038071	10.033341	-18.579037	0.1	3
i4.02	314.34836	-1.0233713388	10.033341	10.030259	-18.249474	0.1	3
i4.02	315.37915	-0.9964204431	10.030259	10.032161	-18.12542	0.1	3
i4.02	316.4099	-1.0295748711	10.032161	10.030273	-17.833952	0.1	3
i4.02	317.44067	-1.0081406832	10.030273	10.022716	-17.660002	0.1	3
i4.02	318.47147	-0.9969695807	10.022716	10.027111	-17.551769	0.1	3
i4.02	319.50223	-1.0072441101	10.027111	10.025153	-17.448325	0.1	3
i4.02	320.533	-1.0168396235	10.025153	10.023007	-16.963821	0.1	3
i4.02	321.56378	-0.982657373	10.023007	10.021254	-16.88651	0.1	3
i4.02	322.59454	-0.9830700159	10.021254	10.024435	-16.728144	0.1	3
i4.02	323.6253	-0.9796223044	10.024435	10.027094	-16.8183	0.1	3
i4.02	324.6561	-0.9858838916	10.027094	10.024692	-16.365736	0.1	3
i4.02	325.68686	-1.0193356276	10.024692	10.019462	-16.008924	0.1	3
i4.02	326.71762	-1.0235446692	10.019462	10.023400	-15.709571	0.1	3
i4.02	327.7484	-1.0117573738	10.023400	10.024343	-15.873761	0.1	3
i4.02	328.77917	-0.9773540497	10.024343	10.018552	-15.387906	0.1	3
i4.02	329.80997	-1.0258998871	10.018552	10.022145	-15.242364	0.1	3
i4.02	330.84073	-1.0233215094	10.022145	10.018682	-15.289813	0.1	3
i4.02	331.8715	-1.0193513632	10.018682	10.019354	-14.874218	0.1	3
i4.02	332.90228	-1.0009293556	10.019354	10.021725	-15.387167	0.1	3
i4.02	333.93304	-0.9923297763	10.021725	10.022152	-15.694399	0.1	3
i4.02	334.9638	-1.0022038221	10.022152	10.020520	-15.551636	0.1	3
i4.02	335.9946	-1.0048168898	10.020520	10.020227	-16.154711	0.1	3
i4.02	337.02536	-1.0217770338	10.020227	10.019702	-16.687247	0.1	3
i4.02	338.05612	-1.026145339	10.019702	10.019657	-16.978968	0.1	3
i4.02	339.0869	-1.0006576777	10.019657	10.019548	-17.251038	0.1	3
i4.02	340.11768	-0.9906460047	10.019548	10.019587	-17.403219	0.1	3
i4.02	341.14844	-1.0154556036	10.019587	10.019382	-17.900946	0.1	3
i4.02	342.17923	-1.0304706097	10.019382	10.019577	-18.220761	0.1	3
i4.02	343.21	-1.0110064745	10.019577	10.019607	-18.502413	0.1	3
i4.02	344.24078	-1.0299018621	10.019607	10.019646	-18.86999	0.1	3
i4.02	345.27155	-0.9888677597	10.019646	10.019571	-19.204616	0.1	3
i4.02	346.3023	-1.0196840763	10.019571	10.019477	-19.470482	0.1	3
i4.02	347.33307	-1.0228427649	10.019477	10.019455	-19.796256	0.1	3
i4.02	348.36386	-1.0040737391	10.019455	10.019662	-21.10253	0.1	3
i4.02	349.39462	-0.9960612655	10.019662	10.019517	-23.992277	0.1	3
i4.02	350.4254	-0.9794576764	10.019517	10.019674	-26.882024	0.1	3
i4.02	351.45618	-1.0005494356	10.019674	10.019691	-29.771771	0.1	3
i4.02	352.48694	-0.9798061848	10.019691	10.019543	-32.661518	0.1	3
i4.02	353.51773	-1.0263125896	10.019543	10.019631	-35.551265	0.1	3
i4.02	354.5485	-1.0209327936	10.019631	10.019513	-38.441012	0.1	3
i4.02	355.57928	-0.993662715	10.019513	10.019568	-41.330759	0.1	3
i4.02	356.61005	-1.0128335953	10.019568	10.019675	-44.220506	0.1	3
i4.02	357.6408	1.0105506182	10.019675	10.019601	-47.110253	0.1	3
i4.00	364.99994	53.5	9.07	9.07	-28.0	-0.1	1
i4.01	364.99994	53.397693634	10.02	10.02	-28.0	0	1
i4.02	364.99994	53.1490402222	10.09	10.09	-28.0	0.1	1
i1.00	225.71227	-1.1286336184	7.080054	7.080054	-17.975479	-0.25	3
i1.00	226.88199	-1.1341768503	7.080054	7.080285	-18.125959	-0.25	3
i1.00	228.05173	-1.1414166689	7.080285	7.080748	-18.235749	-0.25	3
i1.00	229.22147	-1.1590451002	7.080748	7.081080	-18.328114	-0.25	3
i1.00	230.3912	-1.149099946	7.081080	7.081332	-18.430897	-0.25	3
i1.00	231.56093	-1.1554476023	7.081332	7.081632	-18.537163	-0.25	3
i1.00	232.73067	-1.1564055681	7.081632	7.082527	-18.625996	-0.25	3
i1.00	233.9004	-1.1676763296	7.082527	7.081509	-18.725003	-0.25	3
i1.00	235.07013	-1.1231951714	7.081509	7.082461	-18.821086	-0.25	3
i1.00	236.23987	-1.1429448128	7.082461	7.083428	-18.916905	-0.25	3
i1.00	237.4096	-1.1234161854	7.083428	7.082856	-19.025099	-0.25	3
i1.00	238.57935	-1.1670817137	7.082856	7.083932	-19.118233	-0.25	3
i1.00	239.74908	-1.1673704386	7.083932	7.083838	-19.222752	-0.25	3
i1.00	240.91881	-1.1286882162	7.083838	7.083420	-19.31347	-0.25	3
i1.00	242.08855	-1.1601336002	7.083420	7.084009	-19.407579	-0.25	3
i1.00	243.25829	-1.1250053644	7.084009	7.086115	-19.517161	-0.25	3
i1.00	244.42801	-1.133992672	7.086115	7.084518	-19.609602	-0.25	3
i1.00	245.59775	-1.1575329304	7.084518	7.085589	-19.707218	-0.25	3
i1.00	246.76749	-1.1309244633	7.085589	7.086869	-19.797574	-0.25	3
i1.00	247.93723	-1.1240735054	7.086869	7.086274	-19.910041	-0.25	3
i1.00	249.10695	-1.1241234541	7.086274	7.088505	-19.94583	-0.25	3
i1.00	250.27669	-1.1658353806	7.088505	7.084387	-19.84498	-0.25	3
i1.00	251.44641	-1.1252839565	7.084387	7.084584	-19.746479	-0.25	3
i1.00	252.61615	-1.1395591497	7.084584	7.083296	-19.638382	-0.25	3
i1.00	253.78589	-1.1631952524	7.083296	7.085136	-19.554733	-0.25	3
i1.00	254.95563	-1.1306803226	7.085136	7.083822	-19.454184	-0.25	3
i1.00	256.12537	-1.1452491283	7.083822	7.084026	-19.355354	-0.25	3
i1.00	257.2951	-1.1639926434	7.084026	7.084506	-19.259467	-0.25	3
i1.00	258.46484	-1.1228417158	7.084506	7.082912	-19.160388	-0.25	3
i1.00	259.63458	-1.1291706562	7.082912	7.083992	-19.06483	-0.25	3
i1.00	260.8043	-1.1388218403	7.083992	7.082821	-18.958919	-0.25	3
i1.00	261.97403	-1.1587065458	7.082821	7.083000	-18.858003	-0.25	3
i1.00	263.14377	-1.1411875486	7.083000	7.082650	-18.944597	-0.25	3
i1.00	264.3135	-1.1238859892	7.082650	7.082501	-20.319561	-0.25	3
i1.00	265.48325	-1.1325464249	7.082501	7.081828	-21.706364	-0.25	3
i1.00	266.65298	-1.1414115429	7.081828	7.081257	-23.081377	-0.25	3
i1.00	267.8227	-1.1301860809	7.081257	7.081399	-24.470265	-0.25	3
i1.00	268.99243	-1.1426255703	7.081399	7.080630	-25.83941	-0.25	3
i1.00	270.16217	-1.1610425711	7.080630	7.080567	-27.203833	-0.25	3
i1.00	271.3319	1.1569985151	7.080567	7.080340	-28.586348	-0.25	3
i1.01	225.29703	-1.1484351158	7.080057	7.080057	-17.977173	-0.175	3
i1.01	226.47714	-1.176420927	7.080057	7.080340	-18.09981	-0.175	3
i1.01	227.65726	-1.1726498604	7.080340	7.080599	-18.203434	-0.175	3
i1.01	228.83737	-1.1640840769	7.080599	7.081090	-18.296564	-0.175	3
i1.01	230.01749	-1.154125452	7.081090	7.081316	-18.394534	-0.175	3
i1.01	231.1976	-1.1365650892	7.081316	7.081318	-18.497971	-0.175	3
i1.01	232.37772	-1.1770323515	7.081318	7.082104	-18.590116	-0.175	3
i1.01	233.55783	-1.1476352215	7.082104	7.081782	-18.692065	-0.175	3
i1.01	234.73795	-1.1733689308	7.081782	7.082168	-18.803329	-0.175	3
i1.01	235.91808	-1.1468755007	7.082168	7.083168	-18.889395	-0.175	3
i1.01	237.09818	-1.1784023046	7.083168	7.083298	-18.991332	-0.175	3
i1.01	238.2783	-1.1475324631	7.083298	7.083662	-19.089655	-0.175	3
i1.01	239.45842	-1.136554718	7.083662	7.082916	-19.189976	-0.175	3
i1.01	240.63853	-1.1752763987	7.082916	7.084861	-19.287196	-0.175	3
i1.01	241.81865	-1.1331958771	7.084861	7.085656	-19.392711	-0.175	3
i1.01	242.99876	-1.1786500216	7.085656	7.085668	-19.500494	-0.175	3
i1.01	244.17888	-1.1723011732	7.085668	7.085299	-19.58937	-0.175	3
i1.01	245.359	-1.152184844	7.085299	7.086702	-19.684708	-0.175	3
i1.01	246.53911	-1.1661198139	7.086702	7.083905	-19.789815	-0.175	3
i1.01	247.71922	-1.1546875238	7.083905	7.087911	-19.881293	-0.175	3
i1.01	248.89934	-1.1346873045	7.087911	7.086575	-19.959981	-0.175	3
i1.01	250.07945	-1.1360713243	7.086575	7.087406	-19.86124	-0.175	3
i1.01	251.25957	-1.1579619646	7.087406	7.084911	-19.760341	-0.175	3
i1.01	252.43968	-1.1781806946	7.084911	7.085747	-19.66295	-0.175	3
i1.01	253.6198	-1.1459761858	7.085747	7.084185	-19.558171	-0.175	3
i1.01	254.79991	-1.1647212505	7.084185	7.083786	-19.45929	-0.175	3
i1.01	255.98003	-1.1769523621	7.083786	7.084360	-19.377087	-0.175	3
i1.01	257.16016	-1.1669963598	7.084360	7.082586	-19.266665	-0.175	3
i1.01	258.34027	-1.1645237207	7.082586	7.083449	-19.156282	-0.175	3
i1.01	259.5204	-1.1403632164	7.083449	7.084025	-19.063764	-0.175	3
i1.01	260.7005	-1.1517125368	7.084025	7.083053	-18.969694	-0.175	3
i1.01	261.8806	-1.1704084873	7.083053	7.082719	-18.862884	-0.175	3
i1.01	263.06073	-1.1635072231	7.082719	7.083165	-18.844653	-0.175	3
i1.01	264.24084	-1.1409448385	7.083165	7.082198	-20.243309	-0.175	3
i1.01	265.42096	-1.1771264076	7.082198	7.081829	-21.624923	-0.175	3
i1.01	266.60107	-1.1645778418	7.081829	7.081688	-23.020476	-0.175	3
i1.01	267.7812	-1.1547269821	7.081688	7.081074	-24.403279	-0.175	3
i1.01	268.9613	-1.1674199104	7.081074	7.080911	-25.804048	-0.175	3
i1.01	270.14142	-1.1717127562	7.080911	7.080736	-27.184789	-0.175	3
i1.01	271.32153	1.1363971233	7.080736	7.080329	-28.582124	-0.175	3
i1.02	226.87024	-1.1124454737	7.080034	7.080034	-17.971745	-0.1	3
i1.02	228.01103	-1.1128464937	7.080034	7.080641	-18.230463	-0.1	3
i1.02	229.15181	-1.1094123125	7.080641	7.081210	-18.317986	-0.1	3
i1.02	230.2926	-1.1204377413	7.081210	7.081413	-18.42183	-0.1	3
i1.02	231.43338	-1.1343630552	7.081413	7.081265	-18.513447	-0.1	3
i1.02	232.57416	-1.1118146181	7.081265	7.081620	-18.615121	-0.1	3
i1.02	233.71495	-1.1133283377	7.081620	7.082023	-18.70839	-0.1	3
i1.02	234.85573	-1.1384464502	7.082023	7.082351	-18.800303	-0.1	3
i1.02	235.99652	-1.0965226889	7.082351	7.082577	-18.895884	-0.1	3
i1.02	237.1373	-1.1341115236	7.082577	7.083178	-18.991864	-0.1	3
i1.02	238.27809	-1.1326431036	7.083178	7.084505	-19.094541	-0.1	3
i1.02	239.41888	-1.1380198002	7.084505	7.083359	-19.189853	-0.1	3
i1.02	240.55966	-1.1109335423	7.083359	7.083704	-19.279015	-0.1	3
i1.02	241.70045	-1.1250023842	7.083704	7.083878	-19.38229	-0.1	3
i1.02	242.84123	-1.1030709743	7.083878	7.084051	-19.478742	-0.1	3
i1.02	243.98203	-1.135841608	7.084051	7.083105	-19.581001	-0.1	3
i1.02	245.1228	-1.1267536879	7.083105	7.086822	-19.663931	-0.1	3
i1.02	246.26358	-1.1099959612	7.086822	7.084399	-19.764108	-0.1	3
i1.02	247.40437	-1.133903861	7.084399	7.085124	-19.864118	-0.1	3
i1.02	248.54517	-1.1080896854	7.085124	7.086428	-19.956222	-0.1	3
i1.02	249.68594	-1.0968211889	7.086428	7.085558	-19.890636	-0.1	3
i1.02	250.82672	-1.1367839575	7.085558	7.083961	-19.801463	-0.1	3
i1.02	251.96751	-1.1229438782	7.083961	7.085621	-19.714795	-0.1	3
i1.02	253.10829	-1.095323801	7.085621	7.086503	-19.609765	-0.1	3
i1.02	254.24908	-1.1149446964	7.086503	7.083716	-19.512808	-0.1	3
i1.02	255.38986	-1.0995445251	7.083716	7.085166	-19.413542	-0.1	3
i1.02	256.53064	-1.0974354744	7.085166	7.083966	-19.320012	-0.1	3
i1.02	257.67145	-1.1219294071	7.083966	7.082988	-19.213197	-0.1	3
i1.02	258.81223	-1.1248056889	7.082988	7.083225	-19.126645	-0.1	3
i1.02	259.953	-1.1282718182	7.083225	7.082132	-19.030372	-0.1	3
i1.02	261.0938	-1.1188331842	7.082132	7.082489	-18.933032	-0.1	3
i1.02	262.2346	-1.0967329741	7.082489	7.083315	-18.837425	-0.1	3
i1.02	263.37537	-1.1309469938	7.083315	7.082145	-19.210946	-0.1	3
i1.02	264.51614	-1.115634203	7.082145	7.082218	-20.558718	-0.1	3
i1.02	265.65692	-1.1140637398	7.082218	7.081887	-21.901752	-0.1	3
i1.02	266.79773	-1.101829648	7.081887	7.081621	-23.255163	-0.1	3
i1.02	267.9385	-1.1303700209	7.081621	7.081864	-24.595894	-0.1	3
i1.02	269.07928	-1.1030247211	7.081864	7.080995	-25.937011	-0.1	3
i1.02	270.22006	-1.1179943085	7.080995	7.080626	-27.285302	-0.1	3
i1.02	271.36087	1.1124372482	7.080626	7.080355	-28.632882	-0.1	3
i1.03	225.83513	-1.1485719681	7.080056	7.080056	-17.973305	-0.025	3
i1.03	227.0018	-1.1262780428	7.080056	7.080622	-18.134976	-0.025	3
i1.03	228.16846	-1.144299984	7.080622	7.080841	-18.250772	-0.025	3
i1.03	229.33513	-1.1302677393	7.080841	7.081454	-18.346306	-0.025	3
i1.03	230.50179	-1.1416769028	7.081454	7.081212	-18.441376	-0.025	3
i1.03	231.66844	-1.1387712955	7.081212	7.081008	-18.539032	-0.025	3
i1.03	232.83511	-1.1200758219	7.081008	7.081758	-18.640167	-0.025	3
i1.03	234.00177	-1.1534034014	7.081758	7.082770	-18.736994	-0.025	3
i1.03	235.16844	-1.1564118862	7.082770	7.082589	-18.834446	-0.025	3
i1.03	236.3351	-1.1279751062	7.082589	7.083339	-18.919505	-0.025	3
i1.03	237.50175	-1.1402153969	7.083339	7.082732	-19.027831	-0.025	3
i1.03	238.66843	-1.144764185	7.082732	7.082391	-19.125827	-0.025	3
i1.03	239.83508	-1.1476738453	7.082391	7.084254	-19.234924	-0.025	3
i1.03	241.00175	-1.1577371359	7.084254	7.084178	-19.317867	-0.025	3
i1.03	242.16841	-1.1610975266	7.084178	7.084877	-19.420628	-0.025	3
i1.03	243.33508	-1.1571202278	7.084877	7.085099	-19.525194	-0.025	3
i1.03	244.50174	-1.1281579733	7.085099	7.084092	-19.618492	-0.025	3
i1.03	245.6684	-1.1383625269	7.084092	7.085269	-19.724282	-0.025	3
i1.03	246.83507	-1.1397763491	7.085269	7.084300	-19.803905	-0.025	3
i1.03	248.00172	-1.1425777674	7.084300	7.085598	-19.918746	-0.025	3
i1.03	249.1684	-1.1479120255	7.085598	7.087730	-19.936271	-0.025	3
i1.03	250.33505	-1.122669816	7.087730	7.086669	-19.837961	-0.025	3
i1.03	251.50171	-1.1526191235	7.086669	7.085209	-19.742086	-0.025	3
i1.03	252.66838	-1.1570338011	7.085209	7.085889	-19.636839	-0.025	3
i1.03	253.83504	-1.1241344213	7.085889	7.084210	-19.555787	-0.025	3
i1.03	255.00171	-1.1359636784	7.084210	7.082883	-19.447633	-0.025	3
i1.03	256.16837	-1.1439014673	7.082883	7.084102	-19.350066	-0.025	3
i1.03	257.33502	-1.153268218	7.084102	7.084428	-19.252244	-0.025	3
i1.03	258.50168	-1.1549835205	7.084428	7.083875	-19.150924	-0.025	3
i1.03	259.66837	-1.1316986084	7.083875	7.082660	-19.052882	-0.025	3
i1.03	260.83502	-1.1360884905	7.082660	7.083229	-18.959875	-0.025	3
i1.03	262.00168	-1.1603889465	7.083229	7.082464	-18.86721	-0.025	3
i1.03	263.16833	-1.1527372599	7.082464	7.082415	-18.96843	-0.025	3
i1.03	264.335	-1.1498383284	7.082415	7.082981	-20.348006	-0.025	3
i1.03	265.50168	-1.1481173038	7.082981	7.081684	-21.722558	-0.025	3
i1.03	266.66833	-1.1283601522	7.081684	7.082054	-23.101283	-0.025	3
i1.03	267.835	-1.1425014734	7.082054	7.081226	-24.478072	-0.025	3
i1.03	269.00165	-1.11990273	7.081226	7.080899	-25.850498	-0.025	3
i1.03	270.16833	-1.1530678272	7.080899	7.080257	-27.22353	-0.025	3
i1.03	271.335	1.1409726143	7.080257	7.080331	-28.589803	-0.025	3
i1.04	226.46667	-1.1178700924	7.080055	7.080055	-17.964912	0.05	3
i1.04	227.61755	-1.1305490732	7.080055	7.080728	-18.195404	0.05	3
i1.04	228.76843	-1.1349447966	7.080728	7.081231	-18.289581	0.05	3
i1.04	229.9193	-1.134411931	7.081231	7.081569	-18.390566	0.05	3
i1.04	231.07018	-1.1179442406	7.081569	7.081828	-18.489246	0.05	3
i1.04	232.22105	-1.1436764002	7.081828	7.082098	-18.590137	0.05	3
i1.04	233.37193	-1.1458258629	7.082098	7.082039	-18.675114	0.05	3
i1.04	234.5228	-1.1149879694	7.082039	7.082200	-18.783707	0.05	3
i1.04	235.67368	-1.1193730831	7.082200	7.083523	-18.879256	0.05	3
i1.04	236.82455	-1.1474205256	7.083523	7.083878	-18.970669	0.05	3
i1.04	237.97542	-1.1275330782	7.083878	7.084558	-19.068422	0.05	3
i1.04	239.1263	-1.1335842609	7.084558	7.084298	-19.165897	0.05	3
i1.04	240.27718	-1.108658433	7.084298	7.082844	-19.262529	0.05	3
i1.04	241.42804	-1.1436243057	7.082844	7.083904	-19.361872	0.05	3
i1.04	242.57892	-1.1079781055	7.083904	7.085244	-19.465889	0.05	3
i1.04	243.7298	-1.1235361099	7.085244	7.082437	-19.545008	0.05	3
i1.04	244.88068	-1.1197988987	7.082437	7.084454	-19.654801	0.05	3
i1.04	246.03154	-1.149497509	7.084454	7.085361	-19.745393	0.05	3
i1.04	247.18242	-1.1369973421	7.085361	7.085031	-19.844599	0.05	3
i1.04	248.33328	-1.1035848856	7.085031	7.087309	-19.93755	0.05	3
i1.04	249.48416	-1.1068637371	7.087309	7.087249	-19.919131	0.05	3
i1.04	250.63504	-1.1406872272	7.087249	7.085505	-19.813287	0.05	3
i1.04	251.78592	-1.1168116331	7.085505	7.085028	-19.717976	0.05	3
i1.04	252.93678	-1.1332632303	7.085028	7.086258	-19.62382	0.05	3
i1.04	254.08766	-1.148830533	7.086258	7.084079	-19.526357	0.05	3
i1.04	255.23854	-1.1401702166	7.084079	7.084761	-19.424567	0.05	3
i1.04	256.3894	-1.1093240976	7.084761	7.085200	-19.339608	0.05	3
i1.04	257.54028	-1.1337304115	7.085200	7.084197	-19.23087	0.05	3
i1.04	258.69116	-1.1438548565	7.084197	7.083094	-19.141324	0.05	3
i1.04	259.84204	-1.1388124228	7.083094	7.082157	-19.048686	0.05	3
i1.04	260.99292	-1.1167118549	7.082157	7.083473	-18.941564	0.05	3
i1.04	262.14377	-1.1388447285	7.083473	7.082608	-18.848413	0.05	3
i1.04	263.29465	-1.1084244251	7.082608	7.083009	-19.117131	0.05	3
i1.04	264.44553	-1.1123172045	7.083009	7.082507	-20.48032	0.05	3
i1.04	265.5964	-1.1408668756	7.082507	7.081525	-21.830733	0.05	3
i1.04	266.74728	-1.1362044811	7.081525	7.081580	-23.18519	0.05	3
i1.04	267.89816	-1.1397598982	7.081580	7.081159	-24.548783	0.05	3
i1.04	269.049	-1.1335340738	7.081159	7.080989	-25.907723	0.05	3
i1.04	270.1999	-1.142252326	7.080989	7.080421	-27.263762	0.05	3
i1.04	271.35077	1.1370755434	7.080421	7.080335	-28.61734	0.05	3
i1.05	226.83078	-1.1202476025	7.080055	7.080055	-17.978137	0.125	3
i1.05	227.97256	-1.0966421366	7.080055	7.080828	-18.226213	0.125	3
i1.05	229.11433	-1.1165206432	7.080828	7.081066	-18.321571	0.125	3
i1.05	230.2561	-1.1116533279	7.081066	7.081407	-18.424289	0.125	3
i1.05	231.39787	-1.1010444164	7.081407	7.082062	-18.508732	0.125	3
i1.05	232.53964	-1.1014389992	7.082062	7.081875	-18.611285	0.125	3
i1.05	233.68141	-1.1122093201	7.081875	7.083033	-18.714835	0.125	3
i1.05	234.82318	-1.1334882975	7.083033	7.082923	-18.807144	0.125	3
i1.05	235.96497	-1.1223027706	7.082923	7.083421	-18.909925	0.125	3
i1.05	237.10672	-1.1201030016	7.083421	7.083748	-19.000178	0.125	3
i1.05	238.2485	-1.1291872263	7.083748	7.083255	-19.078922	0.125	3
i1.05	239.39027	-1.136275053	7.083255	7.083450	-19.189657	0.125	3
i1.05	240.53204	-1.1045390368	7.083450	7.083512	-19.287585	0.125	3
i1.05	241.67381	-1.09923172	7.083512	7.084795	-19.367	0.125	3
i1.05	242.81558	-1.1116188765	7.084795	7.085513	-19.470633	0.125	3
i1.05	243.95737	-1.0944542885	7.085513	7.084015	-19.571475	0.125	3
i1.05	245.09912	-1.1374530792	7.084015	7.085682	-19.670295	0.125	3
i1.05	246.2409	-1.1058268547	7.085682	7.084488	-19.771499	0.125	3
i1.05	247.38268	-1.1086972952	7.084488	7.085397	-19.853404	0.125	3
i1.05	248.52444	-1.1056482792	7.085397	7.087782	-19.959848	0.125	3
i1.05	249.66621	-1.1059907675	7.087782	7.084458	-19.898629	0.125	3
i1.05	250.80798	-1.1415929794	7.084458	7.086044	-19.794424	0.125	3
i1.05	251.94975	-1.1020069122	7.086044	7.084663	-19.707293	0.125	3
i1.05	253.09152	-1.0960301161	7.084663	7.084729	-19.609461	0.125	3
i1.05	254.2333	-1.1204078197	7.084729	7.084507	-19.505571	0.125	3
i1.05	255.37508	-1.1152505875	7.084507	7.084072	-19.420131	0.125	3
i1.05	256.51685	-1.1216546297	7.084072	7.084674	-19.326339	0.125	3
i1.05	257.65863	-1.1377261877	7.084674	7.083364	-19.224276	0.125	3
i1.05	258.80038	-1.0943574905	7.083364	7.085551	-19.12546	0.125	3
i1.05	259.94217	-1.10722363	7.085551	7.082279	-19.040474	0.125	3
i1.05	261.08392	-1.1368740797	7.082279	7.083348	-18.937023	0.125	3
i1.05	262.2257	-1.1060955524	7.083348	7.082519	-18.841222	0.125	3
i1.05	263.36746	-1.128207922	7.082519	7.082562	-19.206358	0.125	3
i1.05	264.50925	-1.1180377007	7.082562	7.081297	-20.552512	0.125	3
i1.05	265.651	-1.1085444689	7.081297	7.081662	-21.904225	0.125	3
i1.05	266.7928	-1.1007752419	7.081662	7.081808	-23.239045	0.125	3
i1.05	267.93457	-1.1231577396	7.081808	7.081096	-24.586635	0.125	3
i1.05	269.07632	-1.1123383045	7.081096	7.081137	-25.92927	0.125	3
i1.05	270.2181	-1.1019089222	7.081137	7.080770	-27.283758	0.125	3
i1.05	271.35986	1.1199951172	7.080770	7.080379	-28.630031	0.125	3
i1.06	226.64362	-1.1394408941	7.080050	7.080050	-17.976272	0.2	3
i1.06	227.79005	-1.1241489649	7.080050	7.080601	-18.203953	0.2	3
i1.06	228.93651	-1.1207743883	7.080601	7.080899	-18.314606	0.2	3
i1.06	230.08296	-1.1018824577	7.080899	7.081971	-18.404927	0.2	3
i1.06	231.22942	-1.1162232161	7.081971	7.081258	-18.498071	0.2	3
i1.06	232.37587	-1.1069978476	7.081258	7.081910	-18.594163	0.2	3
i1.06	233.52231	-1.1370273829	7.081910	7.082341	-18.694378	0.2	3
i1.06	234.66876	-1.1107748747	7.082341	7.081674	-18.800342	0.2	3
i1.06	235.81522	-1.1091943979	7.081674	7.082279	-18.895389	0.2	3
i1.06	236.96167	-1.1204891205	7.082279	7.082375	-18.978005	0.2	3
i1.06	238.10812	-1.1036984921	7.082375	7.083841	-19.077898	0.2	3
i1.06	239.25458	-1.1440421343	7.083841	7.084167	-19.173576	0.2	3
i1.06	240.40102	-1.1079084873	7.084167	7.084360	-19.279719	0.2	3
i1.06	241.54747	-1.13142097	7.084360	7.084390	-19.371351	0.2	3
i1.06	242.69392	-1.102979064	7.084390	7.084546	-19.462755	0.2	3
i1.06	243.84038	-1.1183092594	7.084546	7.083993	-19.569184	0.2	3
i1.06	244.98682	-1.1102244854	7.083993	7.084827	-19.66097	0.2	3
i1.06	246.13327	-1.12888062	7.084827	7.084171	-19.758607	0.2	3
i1.06	247.27972	-1.1235374212	7.084171	7.085814	-19.846156	0.2	3
i1.06	248.42618	-1.1014465094	7.085814	7.086105	-19.94409	0.2	3
i1.06	249.57263	-1.1034873724	7.086105	7.086682	-19.908888	0.2	3
i1.06	250.71909	-1.122551918	7.086682	7.086194	-19.808266	0.2	3
i1.06	251.86554	-1.123298645	7.086194	7.085137	-19.703951	0.2	3
i1.06	253.01198	-1.1231458187	7.085137	7.084642	-19.620063	0.2	3
i1.06	254.15843	-1.1147979498	7.084642	7.083539	-19.524277	0.2	3
i1.06	255.30489	-1.1018046141	7.083539	7.084132	-19.424853	0.2	3
i1.06	256.45132	-1.1299735308	7.084132	7.083367	-19.322873	0.2	3
i1.06	257.59778	-1.1181845665	7.083367	7.082385	-19.228091	0.2	3
i1.06	258.74423	-1.1241521835	7.082385	7.084507	-19.134975	0.2	3
i1.06	259.8907	-1.1138079166	7.084507	7.084306	-19.037113	0.2	3
i1.06	261.03714	-1.1337542534	7.084306	7.082403	-18.935698	0.2	3
i1.06	262.1836	-1.1010283232	7.082403	7.082534	-18.84161	0.2	3
i1.06	263.33005	-1.1192194223	7.082534	7.082157	-19.158548	0.2	3
i1.06	264.4765	-1.1223216057	7.082157	7.082849	-20.508278	0.2	3
i1.06	265.62292	-1.1355350018	7.082849	7.081232	-21.862393	0.2	3
i1.06	266.76938	-1.1255999804	7.081232	7.081517	-23.219335	0.2	3
i1.06	267.91583	-1.1039994955	7.081517	7.081280	-24.57118	0.2	3
i1.06	269.0623	-1.128917098	7.081280	7.080849	-25.915725	0.2	3
i1.06	270.20874	-1.1101789474	7.080849	7.080614	-27.265223	0.2	3
i1.06	271.3552	1.1421339512	7.080614	7.080410	-28.6185	0.2	3
i1.07	226.13342	-1.1406592131	7.080049	7.080049	-17.984141	0.275	3
i1.07	227.29263	-1.1350946426	7.080049	7.080625	-18.170974	0.275	3
i1.07	228.45184	-1.1244320869	7.080625	7.080748	-18.258257	0.275	3
i1.07	229.61105	-1.1520469189	7.080748	7.081163	-18.357584	0.275	3
i1.07	230.77025	-1.1395914555	7.081163	7.081407	-18.463021	0.275	3
i1.07	231.92946	-1.1521273851	7.081407	7.082254	-18.554747	0.275	3
i1.07	233.08865	-1.1193503141	7.082254	7.082462	-18.663061	0.275	3
i1.07	234.24786	-1.1370255947	7.082462	7.082163	-18.764727	0.275	3
i1.07	235.40707	-1.1156799793	7.082163	7.082806	-18.859737	0.275	3
i1.07	236.56628	-1.1424309015	7.082806	7.082807	-18.948473	0.275	3
i1.07	237.72548	-1.1228551865	7.082807	7.083407	-19.048303	0.275	3
i1.07	238.88469	-1.1575372219	7.083407	7.083815	-19.139957	0.275	3
i1.07	240.04388	-1.1144043207	7.083815	7.082668	-19.234688	0.275	3
i1.07	241.2031	-1.1398636103	7.082668	7.084278	-19.333882	0.275	3
i1.07	242.3623	-1.1355888844	7.084278	7.083634	-19.431777	0.275	3
i1.07	243.52151	-1.1418876648	7.083634	7.084476	-19.541372	0.275	3
i1.07	244.68071	-1.1218899488	7.084476	7.084553	-19.633927	0.275	3
i1.07	245.83992	-1.128118515	7.084553	7.086341	-19.725409	0.275	3
i1.07	246.99913	-1.1140931845	7.086341	7.084587	-19.826264	0.275	3
i1.07	248.15833	-1.142190814	7.084587	7.086277	-19.920051	0.275	3
i1.07	249.31754	-1.1119202375	7.086277	7.085704	-19.927978	0.275	3
i1.07	250.47675	-1.1276545525	7.085704	7.087150	-19.830334	0.275	3
i1.07	251.63594	-1.1135482788	7.087150	7.084377	-19.733411	0.275	3
i1.07	252.79515	-1.1188538074	7.084377	7.084785	-19.646262	0.275	3
i1.07	253.95436	-1.1263546944	7.084785	7.085097	-19.533291	0.275	3
i1.07	255.11357	-1.1511561871	7.085097	7.084628	-19.438359	0.275	3
i1.07	256.27277	-1.1404408216	7.084628	7.083629	-19.34288	0.275	3
i1.07	257.43198	-1.1542880535	7.083629	7.083924	-19.238803	0.275	3
i1.07	258.5912	-1.1212579012	7.083924	7.083597	-19.151696	0.275	3
i1.07	259.7504	-1.1375499964	7.083597	7.083387	-19.054608	0.275	3
i1.07	260.9096	-1.1493890285	7.083387	7.082933	-18.956932	0.275	3
i1.07	262.0688	-1.1285350323	7.082933	7.082597	-18.85493	0.275	3
i1.07	263.228	-1.1237177849	7.082597	7.081966	-19.040406	0.275	3
i1.07	264.3872	-1.1590040922	7.081966	7.081548	-20.408244	0.275	3
i1.07	265.54642	-1.1477421522	7.081548	7.081584	-21.771851	0.275	3
i1.07	266.70563	-1.1335252523	7.081584	7.081313	-23.136362	0.275	3
i1.07	267.8648	-1.1435865164	7.081313	7.081192	-24.516167	0.275	3
i1.07	269.02402	-1.1194534302	7.081192	7.080992	-25.879319	0.275	3
i1.07	270.18323	-1.1488645077	7.080992	7.080452	-27.23864	0.275	3
i1.07	271.34244	1.1575719118	7.080452	7.080455	-28.609202	0.275	3
i1.10	5.8773546	-1.112069726	8.040044	8.040044	-14.983831	-0.25	3
i1.10	7.0054293	-1.1113890409	8.040044	8.040405	-14.771252	-0.25	3
i1.10	8.133499	-1.0857623816	8.040405	8.040818	-14.677557	-0.25	3
i1.10	9.261574	-1.097868681	8.040818	8.041144	-14.579729	-0.25	3
i1.10	10.389645	-1.1057680845	8.041144	8.041186	-14.48421	-0.25	3
i1.10	11.517719	-1.0901281834	8.041186	8.041406	-14.388034	-0.25	3
i1.10	12.645788	-1.1276531219	8.041406	8.041589	-14.287503	-0.25	3
i1.10	13.773863	-1.096581459	8.041589	8.041943	-14.186468	-0.25	3
i1.10	14.901934	-1.0848693848	8.041943	8.042951	-14.091864	-0.25	3
i1.10	16.030008	-1.0877196789	8.042951	8.042384	-13.979359	-0.25	3
i1.10	17.158083	-1.0994507074	8.042384	8.043509	-13.898532	-0.25	3
i1.10	18.286152	-1.0891638994	8.043509	8.043561	-13.801828	-0.25	3
i1.10	19.414227	-1.1047257185	8.043561	8.043556	-13.698367	-0.25	3
i1.10	20.542297	-1.0957740545	8.043556	8.043688	-13.613389	-0.25	3
i1.10	21.670372	-1.0955168009	8.043688	8.043003	-13.497835	-0.25	3
i1.10	22.798443	-1.1129188538	8.043003	8.044811	-13.411058	-0.25	3
i1.10	23.926516	-1.1166057587	8.044811	8.043672	-13.302716	-0.25	3
i1.10	25.054588	-1.1197938919	8.043672	8.043614	-13.212841	-0.25	3
i1.10	26.182661	-1.1278380156	8.043614	8.047882	-13.122828	-0.25	3
i1.10	27.310738	-1.1144102812	8.047882	8.044090	-13.015962	-0.25	3
i1.10	28.438807	-1.0959511995	8.044090	8.045273	-13.041326	-0.25	3
i1.10	29.566881	-1.1230844259	8.045273	8.045057	-13.158472	-0.25	3
i1.10	30.694952	-1.0890314579	8.045057	8.045770	-13.289258	-0.25	3
i1.10	31.823027	-1.0880110264	8.045770	8.043789	-13.400936	-0.25	3
i1.10	32.951096	-1.0986824036	8.043789	8.044872	-13.525712	-0.25	3
i1.10	34.07917	-1.0918139219	8.044872	8.043798	-13.644123	-0.25	3
i1.10	35.20724	-1.0940721035	8.043798	8.043379	-13.760837	-0.25	3
i1.10	36.33531	-1.0841784477	8.043379	8.043091	-13.875918	-0.25	3
i1.10	37.463387	-1.0916210413	8.043091	8.043494	-14.004003	-0.25	3
i1.10	38.59146	-1.0859624147	8.043494	8.042644	-14.12338	-0.25	3
i1.10	39.719532	-1.1016529799	8.042644	8.043184	-14.240475	-0.25	3
i1.10	40.847607	-1.0848457813	8.043184	8.042034	-14.363131	-0.25	3
i1.10	41.97568	-1.0955189466	8.042034	8.042167	-14.48052	-0.25	3
i1.10	43.10375	-1.1249324083	8.042167	8.041965	-14.602334	-0.25	3
i1.10	44.231823	-1.093172431	8.041965	8.041595	-14.722494	-0.25	3
i1.10	45.359894	-1.0857014656	8.041595	8.041456	-14.842693	-0.25	3
i1.10	46.48797	-1.086319685	8.041456	8.040883	-15.577861	-0.25	3
i1.10	47.61604	-1.1214196682	8.040883	8.040721	-21.424457	-0.25	3
i1.10	48.744114	-1.1076258421	8.040721	8.040518	-27.271548	-0.25	3
i1.10	49.87218	1.1278197765	8.040518	8.040239	-33.12948	-0.25	3
i1.11	5.0847354	-1.1278040409	8.040032	8.040032	-14.975364	-0.175	3
i1.11	6.232622	-1.1282017231	8.040032	8.040371	-14.832266	-0.175	3
i1.11	7.3805094	-1.1385540962	8.040371	8.040619	-14.739724	-0.175	3
i1.11	8.5284	-1.108595252	8.040619	8.040910	-14.64384	-0.175	3
i1.11	9.676288	-1.1151326895	8.040910	8.041353	-14.54224	-0.175	3
i1.11	10.824175	-1.1121262312	8.041353	8.040871	-14.437433	-0.175	3
i1.11	11.972061	-1.1037884951	8.040871	8.041873	-14.34529	-0.175	3
i1.11	13.119953	-1.1038930416	8.041873	8.041819	-14.247026	-0.175	3
i1.11	14.267839	-1.1156389713	8.041819	8.041672	-14.149644	-0.175	3
i1.11	15.415726	-1.1164911985	8.041672	8.043181	-14.047717	-0.175	3
i1.11	16.563614	-1.1355499029	8.043181	8.042592	-13.95165	-0.175	3
i1.11	17.711506	-1.1026550531	8.042592	8.042886	-13.8482	-0.175	3
i1.11	18.859392	-1.145963788	8.042886	8.043783	-13.750011	-0.175	3
i1.11	20.007278	-1.1460682154	8.043783	8.043741	-13.643311	-0.175	3
i1.11	21.155167	-1.1132208109	8.043741	8.043067	-13.552813	-0.175	3
i1.11	22.303059	-1.1200478077	8.043067	8.044183	-13.448765	-0.175	3
i1.11	23.450945	-1.1440070868	8.044183	8.044243	-13.344879	-0.175	3
i1.11	24.598831	-1.1407039165	8.044243	8.042853	-13.264068	-0.175	3
i1.11	25.746717	-1.1069619656	8.042853	8.044073	-13.157108	-0.175	3
i1.11	26.89461	-1.1282742023	8.044073	8.043848	-13.055022	-0.175	3
i1.11	28.042496	-1.1368260384	8.043848	8.044924	-12.996612	-0.175	3
i1.11	29.190384	-1.1302745342	8.044924	8.046236	-13.11712	-0.175	3
i1.11	30.338272	-1.1188602448	8.046236	8.044054	-13.23817	-0.175	3
i1.11	31.486162	-1.1386002302	8.044054	8.044796	-13.366091	-0.175	3
i1.11	32.63405	-1.1401221752	8.044796	8.042594	-13.493101	-0.175	3
i1.11	33.781933	-1.1476112604	8.042594	8.043929	-13.615057	-0.175	3
i1.11	34.92982	-1.1075314283	8.043929	8.043545	-13.7268	-0.175	3
i1.11	36.077713	-1.1260069609	8.043545	8.042872	-13.857803	-0.175	3
i1.11	37.2256	-1.108803153	8.042872	8.042477	-13.975835	-0.175	3
i1.11	38.37349	-1.1216316223	8.042477	8.041971	-14.095016	-0.175	3
i1.11	39.521374	-1.1242448092	8.041971	8.042415	-14.219042	-0.175	3
i1.11	40.669266	-1.1171342134	8.042415	8.042282	-14.344807	-0.175	3
i1.11	41.817154	-1.1291863918	8.042282	8.041886	-14.465005	-0.175	3
i1.11	42.96504	-1.1288753748	8.041886	8.042021	-14.587059	-0.175	3
i1.11	44.112926	-1.1084207296	8.042021	8.042027	-14.709799	-0.175	3
i1.11	45.26082	-1.1355513334	8.042027	8.041260	-14.83226	-0.175	3
i1.11	46.408703	-1.136969924	8.041260	8.041148	-15.166758	-0.175	3
i1.11	47.556595	-1.1461604834	8.041148	8.040809	-21.120419	-0.175	3
i1.11	48.70448	-1.1261100769	8.040809	8.040489	-27.070912	-0.175	3
i1.11	49.85237	1.1128120422	8.040489	8.040301	-33.022667	-0.175	3
i1.12	4.7993207	-1.1156990528	8.040055	8.040055	-14.976871	-0.1	3
i1.12	5.954343	-1.1144207716	8.040055	8.040326	-14.860725	-0.1	3
i1.12	7.1093693	-1.1293717623	8.040326	8.040421	-14.771023	-0.1	3
i1.12	8.264392	-1.1226350069	8.040421	8.040776	-14.676808	-0.1	3
i1.12	9.4194145	-1.1428514719	8.040776	8.040859	-14.565471	-0.1	3
i1.12	10.574436	-1.1365932226	8.040859	8.041410	-14.46078	-0.1	3
i1.12	11.729464	-1.1171810627	8.041410	8.041543	-14.376241	-0.1	3
i1.12	12.884485	-1.1462372541	8.041543	8.041666	-14.264071	-0.1	3
i1.12	14.039507	-1.1216498613	8.041666	8.041830	-14.167209	-0.1	3
i1.12	15.1945305	-1.1177734137	8.041830	8.041588	-14.07177	-0.1	3
i1.12	16.349556	-1.1189777851	8.041588	8.042858	-13.95844	-0.1	3
i1.12	17.50458	-1.1293432713	8.042858	8.042992	-13.859562	-0.1	3
i1.12	18.659601	-1.1435256004	8.042992	8.042568	-13.766404	-0.1	3
i1.12	19.814623	-1.1380059719	8.042568	8.044579	-13.664688	-0.1	3
i1.12	20.96965	-1.1231929064	8.044579	8.043504	-13.567127	-0.1	3
i1.12	22.124674	-1.1380892992	8.043504	8.043779	-13.470248	-0.1	3
i1.12	23.279696	-1.1409187317	8.043779	8.043334	-13.37044	-0.1	3
i1.12	24.434717	-1.1374855042	8.043334	8.043877	-13.267829	-0.1	3
i1.12	25.589745	-1.1420373917	8.043877	8.044598	-13.173747	-0.1	3
i1.12	26.744766	-1.1114469767	8.044598	8.045395	-13.066252	-0.1	3
i1.12	27.89979	-1.1403300762	8.045395	8.043716	-12.988905	-0.1	3
i1.12	29.054811	-1.141046524	8.043716	8.045057	-13.100731	-0.1	3
i1.12	30.209839	-1.1384356022	8.045057	8.044057	-13.235996	-0.1	3
i1.12	31.36486	-1.147834897	8.044057	8.044987	-13.34596	-0.1	3
i1.12	32.519882	-1.1490550041	8.044987	8.044089	-13.476084	-0.1	3
i1.12	33.674904	-1.1168736219	8.044089	8.043022	-13.603352	-0.1	3
i1.12	34.829933	-1.1491507292	8.043022	8.043040	-13.714833	-0.1	3
i1.12	35.984955	-1.1201332808	8.043040	8.043011	-13.844553	-0.1	3
i1.12	37.139977	-1.147685647	8.043011	8.042909	-13.965889	-0.1	3
i1.12	38.295	-1.1417320967	8.042909	8.042077	-14.089909	-0.1	3
i1.12	39.450024	-1.1451532841	8.042077	8.042578	-14.213485	-0.1	3
i1.12	40.60505	-1.1186859608	8.042578	8.042090	-14.336245	-0.1	3
i1.12	41.76007	-1.1243329048	8.042090	8.041411	-14.459436	-0.1	3
i1.12	42.915092	-1.132522583	8.041411	8.041585	-14.582209	-0.1	3
i1.12	44.07012	-1.1218893528	8.041585	8.041733	-14.706106	-0.1	3
i1.12	45.225143	-1.1174775362	8.041733	8.041100	-14.82893	-0.1	3
i1.12	46.380165	-1.1512691975	8.041100	8.041227	-15.018775	-0.1	3
i1.12	47.535183	-1.1291190386	8.041227	8.040728	-21.009163	-0.1	3
i1.12	48.690216	-1.1247471571	8.040728	8.040558	-26.999566	-0.1	3
i1.12	49.845238	1.1414507627	8.040558	8.040270	-32.981722	-0.1	3
i1.13	4.7876396	-1.1489485502	8.040047	8.040047	-14.967332	-0.025	3
i1.13	5.942959	-1.1469157934	8.040047	8.040250	-14.868963	-0.025	3
i1.13	7.098273	-1.118871212	8.040250	8.040516	-14.763341	-0.025	3
i1.13	8.253587	-1.1467881203	8.040516	8.041150	-14.668382	-0.025	3
i1.13	9.408901	-1.1365143061	8.041150	8.041162	-14.572194	-0.025	3
i1.13	10.56422	-1.1191935539	8.041162	8.041228	-14.467047	-0.025	3
i1.13	11.719534	-1.1329811811	8.041228	8.041662	-14.363904	-0.025	3
i1.13	12.874849	-1.1292668581	8.041662	8.041888	-14.268086	-0.025	3
i1.13	14.030163	-1.1102604866	8.041888	8.043181	-14.169536	-0.025	3
i1.13	15.185482	-1.1158446074	8.043181	8.041468	-14.069319	-0.025	3
i1.13	16.340796	-1.1527808905	8.041468	8.043159	-13.97	-0.025	3
i1.13	17.496109	-1.1407034397	8.043159	8.041820	-13.873227	-0.025	3
i1.13	18.651424	-1.1389026642	8.041820	8.044433	-13.768798	-0.025	3
i1.13	19.806742	-1.1470593214	8.044433	8.043499	-13.674656	-0.025	3
i1.13	20.962057	-1.120896697	8.043499	8.044137	-13.56322	-0.025	3
i1.13	22.11737	-1.1258846521	8.044137	8.044038	-13.463443	-0.025	3
i1.13	23.27269	-1.1467107534	8.044038	8.042588	-13.371209	-0.025	3
i1.13	24.428005	-1.1089911461	8.042588	8.043868	-13.269425	-0.025	3
i1.13	25.583319	-1.1533073187	8.043868	8.045176	-13.168376	-0.025	3
i1.13	26.738634	-1.1429632902	8.045176	8.045168	-13.062654	-0.025	3
i1.13	27.893951	-1.1298089027	8.045168	8.044535	-12.979096	-0.025	3
i1.13	29.049265	-1.1251684427	8.044535	8.043906	-13.107196	-0.025	3
i1.13	30.204578	-1.1212935448	8.043906	8.044307	-13.220259	-0.025	3
i1.13	31.359894	-1.1317769289	8.044307	8.043833	-13.353722	-0.025	3
i1.13	32.515213	-1.1130983829	8.043833	8.044211	-13.47384	-0.025	3
i1.13	33.670525	-1.1126326323	8.044211	8.043408	-13.593727	-0.025	3
i1.13	34.82584	-1.1208667755	8.043408	8.042793	-13.720787	-0.025	3
i1.13	35.98116	-1.1377493143	8.042793	8.043511	-13.841401	-0.025	3
i1.13	37.136475	-1.1538699865	8.043511	8.043560	-13.965611	-0.025	3
i1.13	38.29179	-1.154797554	8.043560	8.042548	-14.089744	-0.025	3
i1.13	39.4471	-1.1381311417	8.042548	8.043334	-14.213334	-0.025	3
i1.13	40.60242	-1.1549464464	8.043334	8.043031	-14.336351	-0.025	3
i1.13	41.757736	-1.1457393169	8.043031	8.042189	-14.4575	-0.025	3
i1.13	42.913048	-1.1401627064	8.042189	8.041062	-14.580603	-0.025	3
i1.13	44.068363	-1.1177214384	8.041062	8.041245	-14.704588	-0.025	3
i1.13	45.223682	-1.1168467999	8.041245	8.041213	-14.828245	-0.025	3
i1.13	46.378998	-1.1400951147	8.041213	8.041098	-15.012716	-0.025	3
i1.13	47.53431	-1.1409140825	8.041098	8.040487	-21.003737	-0.025	3
i1.13	48.68962	-1.1486171484	8.040487	8.040336	-26.992903	-0.025	3
i1.13	49.844944	1.1199123859	8.040336	8.040306	-32.986626	-0.025	3
i1.14	5.753853	-1.1075503826	8.040026	8.040026	-14.971007	0.05	3
i1.14	6.885013	-1.113016963	8.040026	8.040336	-14.79232	0.05	3
i1.14	8.016173	-1.1174041033	8.040336	8.040882	-14.680705	0.05	3
i1.14	9.147334	-1.0920927525	8.040882	8.041131	-14.586992	0.05	3
i1.14	10.278495	-1.1251621246	8.041131	8.041073	-14.488858	0.05	3
i1.14	11.409651	-1.11460495	8.041073	8.041563	-14.396906	0.05	3
i1.14	12.540811	-1.0945369005	8.041563	8.042096	-14.300591	0.05	3
i1.14	13.671972	-1.1263359785	8.042096	8.041663	-14.194183	0.05	3
i1.14	14.803133	-1.1233524084	8.041663	8.041368	-14.09656	0.05	3
i1.14	15.934292	-1.1011903286	8.041368	8.042376	-14.012839	0.05	3
i1.14	17.065453	-1.1005955935	8.042376	8.043069	-13.908558	0.05	3
i1.14	18.196613	-1.1306385994	8.043069	8.042655	-13.819108	0.05	3
i1.14	19.327772	-1.1283732653	8.042655	8.042132	-13.713738	0.05	3
i1.14	20.458935	-1.1031014919	8.042132	8.044189	-13.610632	0.05	3
i1.14	21.590096	-1.1228500605	8.044189	8.044423	-13.514175	0.05	3
i1.14	22.721254	-1.0875581503	8.044423	8.042327	-13.413613	0.05	3
i1.14	23.852417	-1.094860673	8.042327	8.042141	-13.31318	0.05	3
i1.14	24.983578	-1.1054861546	8.042141	8.044718	-13.223929	0.05	3
i1.14	26.114737	-1.1168004274	8.044718	8.045343	-13.118943	0.05	3
i1.14	27.245893	-1.1218234301	8.045343	8.045882	-13.022031	0.05	3
i1.14	28.377052	-1.1051709652	8.045882	8.045202	-13.035403	0.05	3
i1.14	29.508213	-1.1045193672	8.045202	8.044745	-13.154023	0.05	3
i1.14	30.639374	-1.1115398407	8.044745	8.045006	-13.272161	0.05	3
i1.14	31.770535	-1.1307250261	8.045006	8.044173	-13.388351	0.05	3
i1.14	32.90169	-1.1032146215	8.044173	8.043728	-13.518099	0.05	3
i1.14	34.032856	-1.1311436892	8.043728	8.043644	-13.628661	0.05	3
i1.14	35.164017	-1.1053351164	8.043644	8.043022	-13.754417	0.05	3
i1.14	36.295177	-1.1017913818	8.043022	8.042541	-13.876636	0.05	3
i1.14	37.42634	-1.0925773382	8.042541	8.041831	-13.997527	0.05	3
i1.14	38.5575	-1.1262208223	8.041831	8.042238	-14.120252	0.05	3
i1.14	39.688656	-1.1291739941	8.042238	8.043110	-14.238867	0.05	3
i1.14	40.819817	-1.1084200144	8.043110	8.042989	-14.356676	0.05	3
i1.14	41.95098	-1.0914367437	8.042989	8.041395	-14.478792	0.05	3
i1.14	43.082134	-1.1127284765	8.041395	8.041754	-14.598881	0.05	3
i1.14	44.213295	-1.0925639868	8.041754	8.041327	-14.721823	0.05	3
i1.14	45.344456	-1.1027462482	8.041327	8.041102	-14.840784	0.05	3
i1.14	46.475616	-1.11589396	8.041102	8.041068	-15.513784	0.05	3
i1.14	47.606777	-1.1071764231	8.041068	8.040629	-21.378532	0.05	3
i1.14	48.737938	-1.1143003702	8.040629	8.040706	-27.241075	0.05	3
i1.14	49.8691	1.0919446945	8.040706	8.040296	-33.114446	0.05	3
i1.15	4.9865036	-1.1045658588	8.040051	8.040051	-14.979385	0.125	3
i1.15	6.136846	-1.1313533783	8.040051	8.040281	-14.84543	0.125	3
i1.15	7.2871885	-1.1132870913	8.040281	8.040568	-14.745235	0.125	3
i1.15	8.437536	-1.1436864138	8.040568	8.040725	-14.649868	0.125	3
i1.15	9.587879	-1.1281247139	8.040725	8.040945	-14.556346	0.125	3
i1.15	10.738221	-1.1066427231	8.040945	8.041706	-14.451471	0.125	3
i1.15	11.888563	-1.1153833866	8.041706	8.041730	-14.355891	0.125	3
i1.15	13.038912	-1.1448243856	8.041730	8.042124	-14.26395	0.125	3
i1.15	14.189253	-1.1136773825	8.042124	8.042631	-14.143743	0.125	3
i1.15	15.339596	-1.1349740028	8.042631	8.042458	-14.053214	0.125	3
i1.15	16.489944	-1.141053915	8.042458	8.042423	-13.951077	0.125	3
i1.15	17.640285	-1.1137683392	8.042423	8.043224	-13.856643	0.125	3
i1.15	18.790628	-1.1437360048	8.043224	8.041884	-13.764385	0.125	3
i1.15	19.94097	-1.123341918	8.041884	8.043565	-13.649267	0.125	3
i1.15	21.091318	-1.1143774986	8.043565	8.043816	-13.557956	0.125	3
i1.15	22.241661	-1.1155577898	8.043816	8.044159	-13.456661	0.125	3
i1.15	23.392004	-1.1494463682	8.044159	8.044187	-13.354232	0.125	3
i1.15	24.54235	-1.1230051517	8.044187	8.044270	-13.257285	0.125	3
i1.15	25.692692	-1.1206495762	8.044270	8.045669	-13.15918	0.125	3
i1.15	26.843037	-1.1500647068	8.045669	8.044346	-13.058204	0.125	3
i1.15	27.993378	-1.1144967079	8.044346	8.045849	-12.992854	0.125	3
i1.15	29.143726	-1.1301840544	8.045849	8.045037	-13.110154	0.125	3
i1.15	30.29407	-1.1488209963	8.045037	8.044402	-13.238562	0.125	3
i1.15	31.44441	-1.150164485	8.044402	8.044833	-13.364653	0.125	3
i1.15	32.594753	-1.1488491297	8.044833	8.043890	-13.475031	0.125	3
i1.15	33.7451	-1.1393662691	8.043890	8.043045	-13.608035	0.125	3
i1.15	34.895443	-1.1278175116	8.043045	8.043841	-13.733955	0.125	3
i1.15	36.045784	-1.1377803087	8.043841	8.043892	-13.849782	0.125	3
i1.15	37.196133	-1.1251385212	8.043892	8.043973	-13.972576	0.125	3
i1.15	38.346474	-1.1356730461	8.043973	8.042124	-14.096676	0.125	3
i1.15	39.49682	-1.1466650963	8.042124	8.042025	-14.217068	0.125	3
i1.15	40.64716	-1.1482191086	8.042025	8.040729	-14.34438	0.125	3
i1.15	41.79751	-1.1314032078	8.040729	8.042057	-14.464342	0.125	3
i1.15	42.947853	-1.1105138063	8.042057	8.041608	-14.58539	0.125	3
i1.15	44.098194	-1.1423393488	8.041608	8.041859	-14.708559	0.125	3
i1.15	45.24854	-1.1445549726	8.041859	8.041358	-14.83041	0.125	3
i1.15	46.39888	-1.116740346	8.041358	8.041085	-15.115889	0.125	3
i1.15	47.549225	-1.1177461147	8.041085	8.040849	-21.079193	0.125	3
i1.15	48.69957	-1.1295741796	8.040849	8.040525	-27.042594	0.125	3
i1.15	49.849915	1.1282074451	8.040525	8.040322	-33.010092	0.125	3
i1.16	5.4597454	-1.1361708641	8.040060	8.040060	-14.981125	0.2	3
i1.16	6.598259	-1.0936105251	8.040060	8.040410	-14.818211	0.2	3
i1.16	7.7367725	-1.1269917488	8.040410	8.040897	-14.716344	0.2	3
i1.16	8.875286	-1.11714077	8.040897	8.040981	-14.607907	0.2	3
i1.16	10.0138	-1.0994278193	8.040981	8.041411	-14.511748	0.2	3
i1.16	11.152309	-1.1304440498	8.041411	8.041486	-14.42529	0.2	3
i1.16	12.290823	-1.1091630459	8.041486	8.041500	-14.316162	0.2	3
i1.16	13.429337	-1.095631361	8.041500	8.041214	-14.217125	0.2	3
i1.16	14.56785	-1.1199855804	8.041214	8.042410	-14.120305	0.2	3
i1.16	15.706364	-1.1236858368	8.042410	8.043190	-14.0244	0.2	3
i1.16	16.844877	-1.1274017096	8.043190	8.042725	-13.919562	0.2	3
i1.16	17.983385	-1.1021205187	8.042725	8.042624	-13.831579	0.2	3
i1.16	19.121899	-1.1083358526	8.042624	8.043932	-13.723713	0.2	3
i1.16	20.260412	-1.1069924831	8.043932	8.044184	-13.639234	0.2	3
i1.16	21.398928	-1.1010975838	8.044184	8.043046	-13.53223	0.2	3
i1.16	22.537441	-1.1369546652	8.043046	8.044487	-13.438659	0.2	3
i1.16	23.675951	-1.0993578434	8.044487	8.043019	-13.332277	0.2	3
i1.16	24.814465	-1.0963300467	8.043019	8.044052	-13.238273	0.2	3
i1.16	25.952976	-1.1181670427	8.044052	8.044936	-13.133862	0.2	3
i1.16	27.09149	-1.1090252399	8.044936	8.045083	-13.036133	0.2	3
i1.16	28.230005	-1.1176577806	8.045083	8.045300	-13.013937	0.2	3
i1.16	29.368517	-1.1111913919	8.045300	8.044641	-13.142319	0.2	3
i1.16	30.507027	-1.0966662169	8.044641	8.043968	-13.260627	0.2	3
i1.16	31.64554	-1.0964500904	8.043968	8.043352	-13.381644	0.2	3
i1.16	32.784054	-1.1365629435	8.043352	8.041525	-13.503862	0.2	3
i1.16	33.922565	-1.0932166576	8.041525	8.043364	-13.628184	0.2	3
i1.16	35.06108	-1.1331366301	8.043364	8.042606	-13.745819	0.2	3
i1.16	36.19959	-1.1068738699	8.042606	8.043132	-13.862684	0.2	3
i1.16	37.338104	-1.0931459665	8.043132	8.043298	-13.986982	0.2	3
i1.16	38.476616	-1.1349288225	8.043298	8.043457	-14.107762	0.2	3
i1.16	39.61513	-1.1165428162	8.043457	8.042641	-14.22476	0.2	3
i1.16	40.753647	-1.0959502459	8.042641	8.043120	-14.351361	0.2	3
i1.16	41.892155	-1.1369854212	8.043120	8.041631	-14.473374	0.2	3
i1.16	43.030666	-1.1100229025	8.041631	8.041870	-14.595628	0.2	3
i1.16	44.169178	-1.1175786257	8.041870	8.041543	-14.715988	0.2	3
i1.16	45.307693	-1.097571969	8.041543	8.041221	-14.837173	0.2	3
i1.16	46.446205	-1.1142542362	8.041221	8.040850	-15.361151	0.2	3
i1.16	47.584724	-1.1226909161	8.040850	8.040628	-21.261971	0.2	3
i1.16	48.723232	-1.1313886642	8.040628	8.040550	-27.171678	0.2	3
i1.16	49.861744	1.1195571423	8.040550	8.040200	-33.077638	0.2	3
i1.17	5.946999	-1.0998445749	8.040045	8.040045	-14.978462	0.275	3
i1.17	7.073327	-1.1192554235	8.040045	8.040663	-14.767822	0.275	3
i1.17	8.199659	-1.120986104	8.040663	8.041004	-14.672818	0.275	3
i1.17	9.325993	-1.0905801058	8.041004	8.041308	-14.568112	0.275	3
i1.17	10.452324	-1.0975425243	8.041308	8.041387	-14.485025	0.275	3
i1.17	11.578651	-1.0964708328	8.041387	8.041267	-14.378123	0.275	3
i1.17	12.704985	-1.0871243477	8.041267	8.041723	-14.275749	0.275	3
i1.17	13.831316	-1.1225157976	8.041723	8.041796	-14.184699	0.275	3
i1.17	14.957649	-1.1040087938	8.041796	8.041624	-14.090892	0.275	3
i1.17	16.083982	-1.0829764605	8.041624	8.042723	-13.990072	0.275	3
i1.17	17.21031	-1.1236590147	8.042723	8.042999	-13.889883	0.275	3
i1.17	18.336641	-1.1210436821	8.042999	8.043890	-13.790316	0.275	3
i1.17	19.462975	-1.1037671566	8.043890	8.042724	-13.693405	0.275	3
i1.17	20.589308	-1.1123309135	8.042724	8.043124	-13.608366	0.275	3
i1.17	21.715641	-1.0865334272	8.043124	8.044602	-13.508031	0.275	3
i1.17	22.841969	-1.1174184084	8.044602	8.043523	-13.412295	0.275	3
i1.17	23.968302	-1.0838050842	8.043523	8.045793	-13.315163	0.275	3
i1.17	25.094633	-1.0891039371	8.045793	8.043760	-13.210549	0.275	3
i1.17	26.220964	-1.1105372906	8.043760	8.044537	-13.118606	0.275	3
i1.17	27.347294	-1.0968638659	8.044537	8.043468	-13.01707	0.275	3
i1.17	28.473627	-1.1126203537	8.043468	8.044731	-13.042382	0.275	3
i1.17	29.599958	-1.1090136766	8.044731	8.043996	-13.161948	0.275	3
i1.17	30.726292	-1.1170034409	8.043996	8.044811	-13.272455	0.275	3
i1.17	31.852625	-1.1009823084	8.044811	8.042414	-13.407351	0.275	3
i1.17	32.97895	-1.1140316725	8.042414	8.043835	-13.526595	0.275	3
i1.17	34.10528	-1.1078261137	8.043835	8.043796	-13.640895	0.275	3
i1.17	35.231617	-1.1073586941	8.043796	8.042001	-13.766538	0.275	3
i1.17	36.35795	-1.119279623	8.042001	8.043489	-13.885706	0.275	3
i1.17	37.484283	-1.0801315308	8.043489	8.040988	-14.004076	0.275	3
i1.17	38.61061	-1.0872173309	8.040988	8.042651	-14.121898	0.275	3
i1.17	39.736942	-1.1101930141	8.042651	8.041552	-14.241925	0.275	3
i1.17	40.863274	-1.0815390348	8.041552	8.042620	-14.362825	0.275	3
i1.17	41.98961	-1.1262139082	8.042620	8.041789	-14.483425	0.275	3
i1.17	43.115936	-1.0955820084	8.041789	8.041896	-14.604664	0.275	3
i1.17	44.242264	-1.0872545242	8.041896	8.041172	-14.723537	0.275	3
i1.17	45.3686	-1.1088888645	8.041172	8.040916	-14.843534	0.275	3
i1.17	46.49493	-1.1039361954	8.040916	8.041090	-15.614053	0.275	3
i1.17	47.621265	-1.1049599648	8.041090	8.040768	-21.452559	0.275	3
i1.17	48.747593	-1.1153209209	8.040768	8.040547	-27.297239	0.275	3
i1.17	49.873928	1.0994027853	8.040547	8.040338	-33.139068	0.275	3
i1.10	52.734493	-0.9667569399	7.070044	7.070044	-13.976682	-0.25	3
i1.10	53.740574	-0.9861342907	7.070044	7.070438	-13.742869	-0.25	3
i1.10	54.74666	-0.98913908	7.070438	7.070912	-13.648103	-0.25	3
i1.10	55.752735	-0.9835131764	7.070912	7.071313	-13.536131	-0.25	3
i1.10	56.75882	-0.9740101695	7.071313	7.071422	-13.455682	-0.25	3
i1.10	57.7649	-0.9927431941	7.071422	7.072232	-13.35617	-0.25	3
i1.10	58.770985	-0.9880409241	7.072232	7.072094	-13.250605	-0.25	3
i1.10	59.77707	-0.9730576873	7.072094	7.072560	-13.1618	-0.25	3
i1.10	60.783146	-0.9929210544	7.072560	7.071990	-13.056517	-0.25	3
i1.10	61.78923	-0.9990447164	7.071990	7.073223	-12.963852	-0.25	3
i1.10	62.79531	-0.9941581488	7.073223	7.074100	-12.865696	-0.25	3
i1.10	63.80139	-0.9950755835	7.074100	7.073669	-12.786282	-0.25	3
i1.10	64.80748	-1.0023123026	7.073669	7.074388	-12.68487	-0.25	3
i1.10	65.81355	-0.9907151461	7.074388	7.073013	-12.585201	-0.25	3
i1.10	66.81964	-0.9760860205	7.073013	7.076560	-12.487948	-0.25	3
i1.10	67.82572	-0.9890078306	7.076560	7.072971	-12.386301	-0.25	3
i1.10	68.8318	-0.9713311791	7.072971	7.075233	-12.297808	-0.25	3
i1.10	69.83789	-0.9825292826	7.075233	7.076414	-12.201927	-0.25	3
i1.10	70.84396	-0.9805915356	7.076414	7.076144	-12.096544	-0.25	3
i1.10	71.85005	-0.994535327	7.076144	7.074884	-11.996408	-0.25	3
i1.10	72.85613	-0.9654452205	7.074884	7.077362	-12.039104	-0.25	3
i1.10	73.86221	-0.980651021	7.077362	7.075678	-12.139811	-0.25	3
i1.10	74.86829	-0.9870486259	7.075678	7.073976	-12.235671	-0.25	3
i1.10	75.874374	-0.9761804938	7.073976	7.074547	-12.338101	-0.25	3
i1.10	76.88046	-0.9912523627	7.074547	7.074706	-12.420858	-0.25	3
i1.10	77.886536	-0.9904327393	7.074706	7.073284	-12.532963	-0.25	3
i1.10	78.892624	-0.9974123836	7.073284	7.074322	-12.617714	-0.25	3
i1.10	79.898705	-1.0050550699	7.074322	7.072899	-12.725265	-0.25	3
i1.10	80.904785	-0.9728565812	7.072899	7.073161	-12.819446	-0.25	3
i1.10	81.91087	-0.9707916975	7.073161	7.072732	-12.9178	-0.25	3
i1.10	82.91695	-0.9657008052	7.072732	7.073298	-13.003791	-0.25	3
i1.10	83.923035	-0.9938576221	7.073298	7.072574	-13.110488	-0.25	3
i1.10	84.92911	-0.97679919	7.072574	7.072320	-13.622448	-0.25	3
i1.10	85.935196	-0.9942747951	7.072320	7.072686	-15.15348	-0.25	3
i1.10	86.94128	-0.9935328364	7.072686	7.071676	-16.708003	-0.25	3
i1.10	87.94736	-0.9865917563	7.071676	7.071774	-18.248245	-0.25	3
i1.10	88.953445	-1.0046083927	7.071774	7.070929	-19.787986	-0.25	3
i1.10	89.95952	-0.9890393615	7.070929	7.071049	-21.343743	-0.25	3
i1.10	90.96561	-0.9978073835	7.071049	7.070786	-22.891907	-0.25	3
i1.10	91.97168	0.9646462202	7.070786	7.070190	-24.437229	-0.25	3
i1.11	52.470673	-0.9939739704	7.070054	7.070054	-13.973869	-0.175	3
i1.11	53.483345	-0.9824803472	7.070054	7.070505	-13.766763	-0.175	3
i1.11	54.496025	-0.9755018353	7.070505	7.071150	-13.662989	-0.175	3
i1.11	55.5087	-0.998863101	7.071150	7.070639	-13.564798	-0.175	3
i1.11	56.52138	-0.9861416817	7.070639	7.071513	-13.467901	-0.175	3
i1.11	57.534058	-0.9859985113	7.071513	7.072004	-13.382932	-0.175	3
i1.11	58.546738	-0.9755452871	7.072004	7.072202	-13.275664	-0.175	3
i1.11	59.559414	-1.0115950108	7.072202	7.072316	-13.181387	-0.175	3
i1.11	60.57209	-0.9733349681	7.072316	7.073298	-13.072386	-0.175	3
i1.11	61.584766	-0.9891457558	7.073298	7.072694	-12.980063	-0.175	3
i1.11	62.59745	-1.0071334839	7.072694	7.073670	-12.889626	-0.175	3
i1.11	63.610123	-0.9759887457	7.073670	7.073500	-12.789949	-0.175	3
i1.11	64.6228	-0.9800592065	7.073500	7.074771	-12.694332	-0.175	3
i1.11	65.63548	-0.9837215543	7.074771	7.074390	-12.596278	-0.175	3
i1.11	66.648155	-0.9871904254	7.074390	7.074261	-12.510363	-0.175	3
i1.11	67.660835	-0.9937687516	7.074261	7.073408	-12.402339	-0.175	3
i1.11	68.67351	-0.9949437976	7.073408	7.075338	-12.305849	-0.175	3
i1.11	69.68619	-0.9875835776	7.075338	7.075026	-12.215047	-0.175	3
i1.11	70.69887	-0.9862149358	7.075026	7.078538	-12.119193	-0.175	3
i1.11	71.71155	-0.9951857328	7.078538	7.074963	-12.02343	-0.175	3
i1.11	72.72422	-0.9934327602	7.074963	7.075225	-12.046186	-0.175	3
i1.11	73.73689	-0.9852382541	7.075225	7.075276	-12.128619	-0.175	3
i1.11	74.74957	-0.9842516184	7.075276	7.077620	-12.234032	-0.175	3
i1.11	75.76225	-0.9795758128	7.077620	7.073691	-12.315782	-0.175	3
i1.11	76.77493	-0.9956721663	7.073691	7.075192	-12.418615	-0.175	3
i1.11	77.787605	-0.9964262843	7.075192	7.073845	-12.515596	-0.175	3
i1.11	78.800285	-1.0111708641	7.073845	7.072846	-12.619275	-0.175	3
i1.11	79.812965	-0.9856997728	7.072846	7.073809	-12.702238	-0.175	3
i1.11	80.82564	-0.9748017788	7.073809	7.073895	-12.81503	-0.175	3
i1.11	81.83832	-0.9867814779	7.073895	7.073380	-12.909357	-0.175	3
i1.11	82.851	-1.0119814873	7.073380	7.072733	-12.998931	-0.175	3
i1.11	83.86367	-1.0098472834	7.072733	7.071940	-13.099992	-0.175	3
i1.11	84.87634	-0.9790154099	7.071940	7.072854	-13.528103	-0.175	3
i1.11	85.88903	-0.9931548834	7.072854	7.071942	-15.083287	-0.175	3
i1.11	86.9017	-0.9816792607	7.071942	7.072073	-16.634171	-0.175	3
i1.11	87.91438	-1.002730608	7.072073	7.071681	-18.198959	-0.175	3
i1.11	88.92706	-0.9713072181	7.071681	7.071494	-19.753505	-0.175	3
i1.11	89.93974	-0.9933496118	7.071494	7.070853	-21.31056	-0.175	3
i1.11	90.952415	-0.9811182022	7.070853	7.070439	-22.869091	-0.175	3
i1.11	91.96509	1.0087679625	7.070439	7.070294	-24.415821	-0.175	3
i1.12	51.860775	-1.0160967112	7.070057	7.070057	-13.979412	-0.1	3
i1.12	52.8887	-1.0221993923	7.070057	7.070442	-13.824762	-0.1	3
i1.12	53.916626	-1.0243242979	7.070442	7.070741	-13.718817	-0.1	3
i1.12	54.94455	-1.0250767469	7.070741	7.071076	-13.627178	-0.1	3
i1.12	55.972473	-1.0176180601	7.071076	7.071625	-13.517316	-0.1	3
i1.12	57.0004	-1.0219557285	7.071625	7.071798	-13.42543	-0.1	3
i1.12	58.02832	-1.0077325106	7.071798	7.071863	-13.330478	-0.1	3
i1.12	59.056248	-0.9892645478	7.071863	7.072464	-13.232087	-0.1	3
i1.12	60.084175	-0.9886488318	7.072464	7.073558	-13.134564	-0.1	3
i1.12	61.112095	-0.9948239326	7.073558	7.071932	-13.033936	-0.1	3
i1.12	62.140022	-0.9871824384	7.071932	7.072044	-12.934138	-0.1	3
i1.12	63.16795	-0.9901897311	7.072044	7.074066	-12.835368	-0.1	3
i1.12	64.19588	-1.0092782974	7.074066	7.074127	-12.741387	-0.1	3
i1.12	65.2238	-0.9993727207	7.074127	7.075848	-12.631544	-0.1	3
i1.12	66.251724	-1.0170807838	7.075848	7.072106	-12.541158	-0.1	3
i1.12	67.27965	-1.0150129795	7.072106	7.073209	-12.447227	-0.1	3
i1.12	68.30757	-1.0076050758	7.073209	7.074875	-12.342366	-0.1	3
i1.12	69.335495	-0.990156889	7.074875	7.075135	-12.24737	-0.1	3
i1.12	70.36343	-1.0037795305	7.075135	7.076682	-12.152205	-0.1	3
i1.12	71.39134	-1.0041606426	7.076682	7.074668	-12.048964	-0.1	3
i1.12	72.41927	-0.9882285595	7.074668	7.077071	-12.001326	-0.1	3
i1.12	73.4472	-1.0077142715	7.077071	7.076484	-12.098092	-0.1	3
i1.12	74.47512	-1.001860261	7.076484	7.076878	-12.19934	-0.1	3
i1.12	75.503044	-0.9950621724	7.076878	7.073177	-12.298312	-0.1	3
i1.12	76.530975	-1.0088807344	7.073177	7.074353	-12.39423	-0.1	3
i1.12	77.5589	-1.0220335722	7.074353	7.074968	-12.50481	-0.1	3
i1.12	78.58682	-1.00101614	7.074968	7.074288	-12.58723	-0.1	3
i1.12	79.614746	-1.0095402002	7.074288	7.072383	-12.690792	-0.1	3
i1.12	80.64267	-1.0158586502	7.072383	7.073054	-12.780952	-0.1	3
i1.12	81.67059	-0.9929991364	7.073054	7.072132	-12.890907	-0.1	3
i1.12	82.69852	-1.0173226595	7.072132	7.073360	-12.982269	-0.1	3
i1.12	83.72645	-1.0222568512	7.073360	7.072030	-13.079834	-0.1	3
i1.12	84.754364	-1.0183551311	7.072030	7.072541	-13.340092	-0.1	3
i1.12	85.782295	-1.0217984915	7.072541	7.072325	-14.924191	-0.1	3
i1.12	86.81023	-1.009953618	7.072325	7.071779	-16.504735	-0.1	3
i1.12	87.83815	-1.0116271973	7.071779	7.071475	-18.079675	-0.1	3
i1.12	88.86607	-0.9915385246	7.071475	7.071291	-19.660392	-0.1	3
i1.12	89.894	-1.0160514116	7.071291	7.070984	-21.243176	-0.1	3
i1.12	90.92192	-0.9962827563	7.070984	7.070701	-22.821191	-0.1	3
i1.12	91.949844	1.0177493095	7.070701	7.070343	-24.398716	-0.1	3
i1.13	51.823013	-0.9998953342	7.070049	7.070049	-13.973634	-0.025	3
i1.13	52.851883	-1.0169541836	7.070049	7.070442	-13.829246	-0.025	3
i1.13	53.88075	-1.0100212097	7.070442	7.070753	-13.728847	-0.025	3
i1.13	54.90962	-0.9933183193	7.070753	7.071299	-13.634539	-0.025	3
i1.13	55.938488	-1.0226862431	7.071299	7.071443	-13.527261	-0.025	3
i1.13	56.967358	-1.0196918249	7.071443	7.071937	-13.433949	-0.025	3
i1.13	57.996223	-0.9974958301	7.071937	7.071927	-13.329055	-0.025	3
i1.13	59.025093	-0.988324523	7.071927	7.072131	-13.235507	-0.025	3
i1.13	60.053963	-1.0167874098	7.072131	7.073240	-13.130224	-0.025	3
i1.13	61.082832	-0.9953690171	7.073240	7.073111	-13.044949	-0.025	3
i1.13	62.111702	-0.9939982295	7.073111	7.073281	-12.938577	-0.025	3
i1.13	63.140568	-1.0189067125	7.073281	7.074816	-12.841533	-0.025	3
i1.13	64.16944	-1.0118666887	7.074816	7.072741	-12.743318	-0.025	3
i1.13	65.19831	-1.0143252611	7.072741	7.074156	-12.641057	-0.025	3
i1.13	66.22717	-1.0100864172	7.074156	7.075183	-12.542469	-0.025	3
i1.13	67.25605	-0.9899383187	7.075183	7.075640	-12.442365	-0.025	3
i1.13	68.28491	-0.9958751798	7.075640	7.076226	-12.346042	-0.025	3
i1.13	69.31378	-0.9889310598	7.076226	7.075906	-12.254998	-0.025	3
i1.13	70.34265	-1.0220235586	7.075906	7.075132	-12.153392	-0.025	3
i1.13	71.37152	-1.0071022511	7.075132	7.074889	-12.052783	-0.025	3
i1.13	72.40039	-0.9951412678	7.074889	7.075467	-12.000257	-0.025	3
i1.13	73.42926	-1.006223917	7.075467	7.076479	-12.09769	-0.025	3
i1.13	74.45813	-0.9874449372	7.076479	7.074884	-12.204165	-0.025	3
i1.13	75.487	-1.016844511	7.074884	7.075816	-12.284708	-0.025	3
i1.13	76.51587	-0.9962390065	7.075816	7.074295	-12.397843	-0.025	3
i1.13	77.54474	-1.0016423464	7.074295	7.073031	-12.491092	-0.025	3
i1.13	78.5736	-0.9977822304	7.073031	7.073739	-12.591596	-0.025	3
i1.13	79.60248	-1.0131248236	7.073739	7.072916	-12.690594	-0.025	3
i1.13	80.63135	-0.9906541705	7.072916	7.074961	-12.794281	-0.025	3
i1.13	81.66021	-1.0115759373	7.074961	7.073947	-12.890787	-0.025	3
i1.13	82.68908	-0.9986436367	7.073947	7.073165	-12.98667	-0.025	3
i1.13	83.71796	-1.018309474	7.073165	7.072683	-13.0943	-0.025	3
i1.13	84.74682	-1.0072025061	7.072683	7.072671	-13.331762	-0.025	3
i1.13	85.77569	-0.9939489961	7.072671	7.072042	-14.917055	-0.025	3
i1.13	86.80455	-0.9885347486	7.072042	7.072007	-16.505145	-0.025	3
i1.13	87.83342	-0.9996503592	7.072007	7.070598	-18.070628	-0.025	3
i1.13	88.8623	-1.0277122259	7.070598	7.071528	-19.657448	-0.025	3
i1.13	89.89116	-1.0189090967	7.071528	7.070859	-21.236724	-0.025	3
i1.13	90.92003	-1.0111483335	7.070859	7.070759	-22.816383	-0.025	3
i1.13	91.9489	1.0022205114	7.070759	7.070263	-24.397735	-0.025	3
i1.14	52.784176	-0.9657623768	7.070063	7.070063	-13.972583	0.05	3
i1.14	53.789013	-0.9898316264	7.070063	7.070682	-13.73862	0.05	3
i1.14	54.793854	-1.0006532669	7.070682	7.071389	-13.651841	0.05	3
i1.14	55.79869	-0.9857743979	7.071389	7.070993	-13.53431	0.05	3
i1.14	56.803535	-0.9747185707	7.070993	7.071844	-13.446893	0.05	3
i1.14	57.808372	-1.0000948906	7.071844	7.071341	-13.354178	0.05	3
i1.14	58.813213	-0.9686945081	7.071341	7.072649	-13.252071	0.05	3
i1.14	59.81805	-0.9725875258	7.072649	7.072199	-13.156432	0.05	3
i1.14	60.82289	-0.9712330103	7.072199	7.072315	-13.057768	0.05	3
i1.14	61.827732	-0.9896743894	7.072315	7.072931	-12.96465	0.05	3
i1.14	62.832573	-0.9768488407	7.072931	7.074288	-12.871216	0.05	3
i1.14	63.83741	-0.9746584892	7.074288	7.074020	-12.773687	0.05	3
i1.14	64.842255	-0.9644755125	7.074020	7.074194	-12.673787	0.05	3
i1.14	65.84709	-0.991353929	7.074194	7.073821	-12.583811	0.05	3
i1.14	66.85194	-1.003326416	7.073821	7.074459	-12.490181	0.05	3
i1.14	67.85677	-0.976480782	7.074459	7.074714	-12.392863	0.05	3
i1.14	68.86161	-0.9632642865	7.074714	7.074493	-12.287969	0.05	3
i1.14	69.866455	-0.9696910381	7.074493	7.074803	-12.189753	0.05	3
i1.14	70.87129	-0.9861880541	7.074803	7.075245	-12.09198	0.05	3
i1.14	71.87613	-0.9691231847	7.075245	7.076854	-12.003356	0.05	3
i1.14	72.880974	-1.0004705191	7.076854	7.076743	-12.041178	0.05	3
i1.14	73.88581	-0.9742031693	7.076743	7.075464	-12.146508	0.05	3
i1.14	74.890656	-0.9786173701	7.075464	7.077385	-12.24161	0.05	3
i1.14	75.89549	-0.9770645499	7.077385	7.076693	-12.334473	0.05	3
i1.14	76.90033	-0.990812242	7.076693	7.073969	-12.437	0.05	3
i1.14	77.90517	-0.9993037581	7.073969	7.075413	-12.524886	0.05	3
i1.14	78.91001	-0.9889196157	7.075413	7.072917	-12.622962	0.05	3
i1.14	79.91485	-0.996293962	7.072917	7.074543	-12.724188	0.05	3
i1.14	80.91969	-0.995095551	7.074543	7.073149	-12.822584	0.05	3
i1.14	81.92453	-0.9875165224	7.073149	7.072006	-12.913035	0.05	3
i1.14	82.929375	-0.9763935804	7.072006	7.072565	-13.015032	0.05	3
i1.14	83.934204	-0.9860649109	7.072565	7.071728	-13.107801	0.05	3
i1.14	84.93905	-0.9680988789	7.071728	7.072238	-13.633984	0.05	3
i1.14	85.943886	-0.9983782768	7.072238	7.072057	-15.161136	0.05	3
i1.14	86.94873	-0.9725369215	7.072057	7.071573	-16.713451	0.05	3
i1.14	87.95357	-0.9856867194	7.071573	7.071474	-18.251265	0.05	3
i1.14	88.958405	-0.9660854936	7.071474	7.071190	-19.796096	0.05	3
i1.14	89.96324	-0.9937620163	7.071190	7.070836	-21.345109	0.05	3
i1.14	90.968094	-1.0023957491	7.070836	7.070456	-22.880597	0.05	3
i1.14	91.97293	0.9699931145	7.070456	7.070273	-24.422953	0.05	3
i1.15	51.511734	-1.0129332542	7.070036	7.070036	-13.977211	0.125	3
i1.15	52.548386	-1.0361081362	7.070036	7.070399	-13.860784	0.125	3
i1.15	53.585037	-1.0092073679	7.070399	7.070571	-13.765249	0.125	3
i1.15	54.62169	-1.0029084682	7.070571	7.070898	-13.652852	0.125	3
i1.15	55.65834	-0.9976884723	7.070898	7.071304	-13.560679	0.125	3
i1.15	56.69499	-1.0090267658	7.071304	7.071518	-13.451255	0.125	3
i1.15	57.73164	-1.0230555534	7.071518	7.071886	-13.362195	0.125	3
i1.15	58.76829	-1.0101943016	7.071886	7.071655	-13.246322	0.125	3
i1.15	59.804943	-1.0155540705	7.071655	7.072816	-13.158359	0.125	3
i1.15	60.841595	-1.0178660154	7.072816	7.072224	-13.049988	0.125	3
i1.15	61.878246	-1.033596158	7.072224	7.073052	-12.965897	0.125	3
i1.15	62.914894	-1.0051445961	7.073052	7.073429	-12.862345	0.125	3
i1.15	63.951546	-1.0277388096	7.073429	7.072541	-12.756099	0.125	3
i1.15	64.9882	-1.0301225185	7.072541	7.074922	-12.656375	0.125	3
i1.15	66.02485	-1.0053472519	7.074922	7.071841	-12.565589	0.125	3
i1.15	67.0615	-1.0017482042	7.071841	7.076402	-12.464688	0.125	3
i1.15	68.09815	-1.003921628	7.076402	7.076363	-12.36619	0.125	3
i1.15	69.1348	-1.0022054911	7.076363	7.073131	-12.260692	0.125	3
i1.15	70.17145	-0.9971772432	7.073131	7.074740	-12.165975	0.125	3
i1.15	71.2081	-1.0072788	7.074740	7.076914	-12.065192	0.125	3
i1.15	72.24475	-1.0205208063	7.076914	7.076118	-11.98123	0.125	3
i1.15	73.2814	-1.0194846392	7.076118	7.075463	-12.084964	0.125	3
i1.15	74.318054	-1.0345298052	7.075463	7.073634	-12.169504	0.125	3
i1.15	75.354706	-1.0257301331	7.073634	7.074754	-12.28173	0.125	3
i1.15	76.39136	-1.0313918591	7.074754	7.074742	-12.381558	0.125	3
i1.15	77.42801	-1.0344344378	7.074742	7.073415	-12.48021	0.125	3
i1.15	78.46466	-1.032793045	7.073415	7.074763	-12.58986	0.125	3
i1.15	79.50131	-1.0256268978	7.074763	7.074438	-12.681514	0.125	3
i1.15	80.537964	-0.9975744486	7.074438	7.073979	-12.781748	0.125	3
i1.15	81.574615	-1.0159137249	7.073979	7.072935	-12.876871	0.125	3
i1.15	82.61127	-1.0197579861	7.072935	7.072404	-12.973684	0.125	3
i1.15	83.64791	-1.0322117805	7.072404	7.073419	-13.077035	0.125	3
i1.15	84.684555	-1.005333662	7.073419	7.071912	-13.229679	0.125	3
i1.15	85.721214	-1.0318368673	7.071912	7.071234	-14.832161	0.125	3
i1.15	86.757866	-1.0241752863	7.071234	7.071498	-16.424558	0.125	3
i1.15	87.79452	-1.0303132534	7.071498	7.071525	-18.016526	0.125	3
i1.15	88.83117	-0.9951933622	7.071525	7.070909	-19.604341	0.125	3
i1.15	89.86781	-0.9954733253	7.070909	7.071041	-21.202482	0.125	3
i1.15	90.904465	-1.0215069056	7.071041	7.070700	-22.785525	0.125	3
i1.15	91.94112	1.0350854397	7.070700	7.070334	-24.377859	0.125	3
i1.16	52.018215	-0.9828671217	7.070064	7.070064	-13.971023	0.2	3
i1.16	53.042206	-1.0145230293	7.070064	7.070554	-13.808822	0.2	3
i1.16	54.066193	-0.99282974	7.070554	7.070956	-13.705831	0.2	3
i1.16	55.090183	-1.0001505613	7.070956	7.071180	-13.611519	0.2	3
i1.16	56.11417	-0.9973435998	7.071180	7.071580	-13.512842	0.2	3
i1.16	57.13816	-1.0207003355	7.071580	7.071780	-13.41588	0.2	3
i1.16	58.162148	-0.994817853	7.071780	7.072609	-13.322023	0.2	3
i1.16	59.18614	-0.985568881	7.072609	7.071495	-13.212127	0.2	3
i1.16	60.210125	-1.000860095	7.071495	7.072396	-13.117823	0.2	3
i1.16	61.234116	-0.997179389	7.072396	7.074162	-13.014651	0.2	3
i1.16	62.258106	-1.001292944	7.074162	7.072549	-12.936004	0.2	3
i1.16	63.282097	-1.0015318394	7.072549	7.074217	-12.824213	0.2	3
i1.16	64.30608	-0.9866350889	7.074217	7.074186	-12.740524	0.2	3
i1.16	65.33007	-0.9959828854	7.074186	7.073261	-12.625954	0.2	3
i1.16	66.35406	-1.0071191788	7.073261	7.074992	-12.533615	0.2	3
i1.16	67.37805	-0.996427238	7.074992	7.075295	-12.438918	0.2	3
i1.16	68.40204	-1.0111122131	7.075295	7.074833	-12.335972	0.2	3
i1.16	69.426025	-1.0051916838	7.074833	7.075138	-12.238713	0.2	3
i1.16	70.45001	-1.0159628391	7.075138	7.076172	-12.133846	0.2	3
i1.16	71.474	-1.017855525	7.076172	7.077148	-12.037003	0.2	3
i1.16	72.49799	-1.0099285841	7.077148	7.072576	-11.999109	0.2	3
i1.16	73.52198	-1.0167052746	7.072576	7.076303	-12.105319	0.2	3
i1.16	74.545975	-1.0028324127	7.076303	7.076331	-12.198818	0.2	3
i1.16	75.56996	-1.0039123297	7.076331	7.073187	-12.305045	0.2	3
i1.16	76.59395	-1.0145442486	7.073187	7.074404	-12.401947	0.2	3
i1.16	77.617935	-1.0218341351	7.074404	7.073604	-12.501105	0.2	3
i1.16	78.64192	-1.0146713257	7.073604	7.073569	-12.606353	0.2	3
i1.16	79.66592	-1.0084946156	7.073569	7.074192	-12.69922	0.2	3
i1.16	80.6899	-1.0025132895	7.074192	7.072904	-12.800143	0.2	3
i1.16	81.71389	-0.9913350344	7.072904	7.072535	-12.896143	0.2	3
i1.16	82.737885	-1.0215321779	7.072535	7.072783	-12.995829	0.2	3
i1.16	83.76187	-1.0081726313	7.072783	7.072193	-13.098376	0.2	3
i1.16	84.78586	-0.9929708242	7.072193	7.073354	-13.395481	0.2	3
i1.16	85.809845	-0.9973751903	7.073354	7.071923	-14.971224	0.2	3
i1.16	86.83384	-0.9931668639	7.071923	7.071752	-16.544981	0.2	3
i1.16	87.857834	-0.9967783093	7.071752	7.071566	-18.116662	0.2	3
i1.16	88.88182	-1.0011098385	7.071566	7.071076	-19.688736	0.2	3
i1.16	89.90581	-1.0157059431	7.071076	7.070806	-21.249367	0.2	3
i1.16	90.929794	-1.0159620047	7.070806	7.070432	-22.822725	0.2	3
i1.16	91.95378	1.0164865255	7.070432	7.070425	-24.395557	0.2	3
i1.17	51.94729	-0.9924766421	7.070037	7.070037	-13.975187	0.275	3
i1.17	52.973053	-0.9994550347	7.070037	7.070481	-13.816797	0.275	3
i1.17	53.998814	-1.0199973583	7.070481	7.071159	-13.716345	0.275	3
i1.17	55.024574	-1.0081197023	7.071159	7.071207	-13.628366	0.275	3
i1.17	56.05034	-1.0178774595	7.071207	7.071240	-13.518437	0.275	3
i1.17	57.0761	-1.0052787066	7.071240	7.071534	-13.424824	0.275	3
i1.17	58.101864	-1.0197113752	7.071534	7.071381	-13.325928	0.275	3
i1.17	59.127625	-1.0204783678	7.071381	7.072981	-13.215352	0.275	3
i1.17	60.153385	-0.9858484268	7.072981	7.072416	-13.121305	0.275	3
i1.17	61.17915	-0.9843118191	7.072416	7.072428	-13.026046	0.275	3
i1.17	62.20491	-0.993730545	7.072428	7.073194	-12.931072	0.275	3
i1.17	63.23067	-1.0099439621	7.073194	7.073626	-12.82957	0.275	3
i1.17	64.25644	-1.018179059	7.073626	7.073764	-12.72665	0.275	3
i1.17	65.282196	-0.9862101078	7.073764	7.072190	-12.632738	0.275	3
i1.17	66.30796	-0.9848698974	7.072190	7.076417	-12.53057	0.275	3
i1.17	67.33372	-1.0215041637	7.076417	7.075834	-12.44417	0.275	3
i1.17	68.35948	-1.0166676044	7.075834	7.075633	-12.339479	0.275	3
i1.17	69.38525	-1.0205630064	7.075633	7.074376	-12.239085	0.275	3
i1.17	70.411	-1.00433743	7.074376	7.075711	-12.152593	0.275	3
i1.17	71.43677	-0.9987143874	7.075711	7.076368	-12.041692	0.275	3
i1.17	72.46253	-0.9904204607	7.076368	7.075252	-12.002013	0.275	3
i1.17	73.48829	-0.9980665445	7.075252	7.077132	-12.101266	0.275	3
i1.17	74.51405	-1.0058329105	7.077132	7.074599	-12.19837	0.275	3
i1.17	75.53981	-1.0203744173	7.074599	7.075166	-12.296228	0.275	3
i1.17	76.56558	-1.018229723	7.075166	7.075337	-12.399815	0.275	3
i1.17	77.59134	-0.9845610857	7.075337	7.074208	-12.500402	0.275	3
i1.17	78.617096	-0.988261342	7.074208	7.074748	-12.590974	0.275	3
i1.17	79.64287	-0.9960796833	7.074748	7.073772	-12.689985	0.275	3
i1.17	80.668625	-0.9977783561	7.073772	7.073510	-12.791984	0.275	3
i1.17	81.69439	-0.9944666624	7.073510	7.073371	-12.895278	0.275	3
i1.17	82.72015	-1.0127309561	7.073371	7.072624	-12.992075	0.275	3
i1.17	83.74591	-1.0163071156	7.072624	7.073406	-13.090078	0.275	3
i1.17	84.771675	-0.9994190335	7.073406	7.072565	-13.369953	0.275	3
i1.17	85.79744	-0.9984027147	7.072565	7.072047	-14.943404	0.275	3
i1.17	86.8232	-1.0014916658	7.072047	7.072298	-16.528602	0.275	3
i1.17	87.84895	-1.0157786608	7.072298	7.070903	-18.094636	0.275	3
i1.17	88.874725	-0.9881218672	7.070903	7.070892	-19.678034	0.275	3
i1.17	89.90048	-0.9958165288	7.070892	7.071054	-21.251543	0.275	3
i1.17	90.92625	-0.9859433174	7.071054	7.070666	-22.832823	0.275	3
i1.17	91.95201	0.9958128333	7.070666	7.070439	-24.415186	0.275	3
i1.10	144.7385	-0.9708521962	8.030038	8.030038	-17.965695	-0.25	3
i1.10	145.74104	-0.9902592301	8.030038	8.030638	-18.219394	-0.25	3
i1.10	146.7436	-0.9834008813	8.030638	8.030954	-18.309816	-0.25	3
i1.10	147.74615	-0.9845252633	8.030954	8.031137	-18.407709	-0.25	3
i1.10	148.74872	-0.9912160039	8.031137	8.031361	-18.510426	-0.25	3
i1.10	149.75128	-0.9664435983	8.031361	8.032271	-18.602178	-0.25	3
i1.10	150.75385	-0.9759553075	8.032271	8.031131	-18.708221	-0.25	3
i1.10	151.7564	-0.9841064811	8.031131	8.031342	-18.789927	-0.25	3
i1.10	152.75896	-0.9800201654	8.031342	8.033223	-18.89635	-0.25	3
i1.10	153.76152	-1.0012243986	8.033223	8.033013	-18.99216	-0.25	3
i1.10	154.76407	-0.9906813502	8.033013	8.034119	-19.080619	-0.25	3
i1.10	155.76663	-0.9993519783	8.034119	8.032831	-19.183334	-0.25	3
i1.10	156.7692	-0.9859542251	8.032831	8.033825	-19.278141	-0.25	3
i1.10	157.77174	-0.9679884911	8.033825	8.035225	-19.370041	-0.25	3
i1.10	158.7743	-0.9709436297	8.035225	8.033686	-19.473116	-0.25	3
i1.10	159.77687	-0.9652273655	8.033686	8.033875	-19.575665	-0.25	3
i1.10	160.77942	-0.9649333954	8.033875	8.034059	-19.675506	-0.25	3
i1.10	161.78198	-0.9639851451	8.034059	8.036027	-19.760287	-0.25	3
i1.10	162.78455	-0.9907377362	8.036027	8.035743	-19.867004	-0.25	3
i1.10	163.7871	-0.9823612571	8.035743	8.035472	-19.95503	-0.25	3
i1.10	164.78966	-0.9880248308	8.035472	8.038229	-19.893887	-0.25	3
i1.10	165.79222	-0.9943137765	8.038229	8.034414	-19.801261	-0.25	3
i1.10	166.79477	-0.9933680296	8.034414	8.033630	-19.708836	-0.25	3
i1.10	167.79733	-0.9691672325	8.033630	8.032907	-19.620767	-0.25	3
i1.10	168.7999	-0.9901752472	8.032907	8.033146	-19.519919	-0.25	3
i1.10	169.80244	-0.9842292666	8.033146	8.034106	-19.428965	-0.25	3
i1.10	170.80501	-0.9691224098	8.034106	8.034897	-19.325766	-0.25	3
i1.10	171.80756	-0.9890854359	8.034897	8.032531	-19.224244	-0.25	3
i1.10	172.81012	-0.9786036611	8.032531	8.033053	-19.132779	-0.25	3
i1.10	173.81268	-0.9966462851	8.033053	8.033749	-19.03771	-0.25	3
i1.10	174.81523	-0.9713100791	8.033749	8.033033	-18.935516	-0.25	3
i1.10	175.8178	-0.9754651785	8.033033	8.032450	-18.839176	-0.25	3
i1.10	176.82034	-0.9869033098	8.032450	8.031573	-18.73924	-0.25	3
i1.10	177.8229	-0.9703813791	8.031573	8.033062	-18.638967	-0.25	3
i1.10	178.82547	-0.9609140158	8.033062	8.031961	-18.553604	-0.25	3
i1.10	179.82803	-0.9630573392	8.031961	8.031574	-18.457638	-0.25	3
i1.10	180.83058	-0.9897348881	8.031574	8.031237	-18.358443	-0.25	3
i1.10	181.83315	-0.9928527474	8.031237	8.031037	-18.265175	-0.25	3
i1.10	182.83571	-0.976344049	8.031037	8.030573	-18.169918	-0.25	3
i1.10	183.83826	0.9757152796	8.030573	8.030437	-18.075234	-0.25	3
i1.11	143.95476	-1.0181885958	8.030042	8.030042	-17.98685	-0.175	3
i1.11	144.97691	-0.9894138575	8.030042	8.030511	-18.153528	-0.175	3
i1.11	145.99907	-1.0036301613	8.030511	8.031055	-18.251824	-0.175	3
i1.11	147.02121	-1.0213117599	8.031055	8.031019	-18.342093	-0.175	3
i1.11	148.04337	-0.9920235276	8.031019	8.030801	-18.447247	-0.175	3
i1.11	149.06552	-1.016163826	8.030801	8.032244	-18.54035	-0.175	3
i1.11	150.08768	-0.9855260253	8.032244	8.031960	-18.639537	-0.175	3
i1.11	151.10982	-1.0054440498	8.031960	8.031894	-18.735137	-0.175	3
i1.11	152.13197	-0.9909417629	8.031894	8.033048	-18.840716	-0.175	3
i1.11	153.15413	-1.0092746019	8.033048	8.033496	-18.927865	-0.175	3
i1.11	154.17628	-1.0063068867	8.033496	8.032864	-19.027647	-0.175	3
i1.11	155.19843	-1.0157895088	8.032864	8.033127	-19.121744	-0.175	3
i1.11	156.22058	-1.0135471821	8.033127	8.036291	-19.233038	-0.175	3
i1.11	157.24274	-1.0095735788	8.036291	8.033036	-19.323389	-0.175	3
i1.11	158.2649	-0.9891782999	8.033036	8.034058	-19.427839	-0.175	3
i1.11	159.28703	-1.0101134777	8.034058	8.033757	-19.509622	-0.175	3
i1.11	160.30919	-0.9953071475	8.033757	8.037511	-19.621787	-0.175	3
i1.11	161.33134	-0.9875218272	8.037511	8.035206	-19.726135	-0.175	3
i1.11	162.35349	-1.0178812742	8.035206	8.035011	-19.820096	-0.175	3
i1.11	163.37564	-0.997433722	8.035011	8.035152	-19.91247	-0.175	3
i1.11	164.3978	-0.9904498458	8.035152	8.038426	-19.931707	-0.175	3
i1.11	165.41994	-0.9856268764	8.038426	8.035934	-19.835889	-0.175	3
i1.11	166.4421	-1.0009217262	8.035934	8.035374	-19.739369	-0.175	3
i1.11	167.46425	-1.0059719086	8.035374	8.035895	-19.642573	-0.175	3
i1.11	168.48639	-0.9805007577	8.035895	8.033886	-19.542628	-0.175	3
i1.11	169.50854	-1.0116223097	8.033886	8.033853	-19.445742	-0.175	3
i1.11	170.5307	-0.9952737093	8.033853	8.033617	-19.35927	-0.175	3
i1.11	171.55286	-0.9892778397	8.033617	8.033765	-19.242423	-0.175	3
i1.11	172.575	-0.9808282852	8.033765	8.033265	-19.146796	-0.175	3
i1.11	173.59715	-0.988923192	8.033265	8.033255	-19.042832	-0.175	3
i1.11	174.61931	-1.0202524662	8.033255	8.033036	-18.961732	-0.175	3
i1.11	175.64146	-1.021294117	8.033036	8.032681	-18.858239	-0.175	3
i1.11	176.6636	-0.9952403903	8.032681	8.032700	-18.767801	-0.175	3
i1.11	177.68576	-0.9975738525	8.032700	8.032600	-18.667789	-0.175	3
i1.11	178.70792	-1.0187023878	8.032600	8.031651	-18.562609	-0.175	3
i1.11	179.73007	-1.0205396414	8.031651	8.030814	-18.465253	-0.175	3
i1.11	180.75221	-1.0067615509	8.030814	8.031421	-18.362391	-0.175	3
i1.11	181.77437	-1.0057996511	8.031421	8.030610	-18.266186	-0.175	3
i1.11	182.79651	-1.0202901363	8.030610	8.030703	-18.175313	-0.175	3
i1.11	183.81866	0.9863761663	8.030703	8.030331	-18.072648	-0.175	3
i1.12	143.79454	-1.0140411854	8.030059	8.030059	-17.982702	-0.1	3
i1.12	144.82071	-0.9892129898	8.030059	8.030608	-18.133059	-0.1	3
i1.12	145.84686	-0.9952296019	8.030608	8.030965	-18.230107	-0.1	3
i1.12	146.87302	-1.013224721	8.030965	8.031083	-18.326728	-0.1	3
i1.12	147.89917	-0.9980490804	8.031083	8.031427	-18.422392	-0.1	3
i1.12	148.92532	-0.9889987707	8.031427	8.031131	-18.525643	-0.1	3
i1.12	149.95149	-0.9992358088	8.031131	8.032218	-18.628369	-0.1	3
i1.12	150.97765	-0.9894821048	8.032218	8.031883	-18.727271	-0.1	3
i1.12	152.0038	-0.9847494364	8.031883	8.032571	-18.833378	-0.1	3
i1.12	153.02995	-0.9960047007	8.032571	8.033001	-18.918409	-0.1	3
i1.12	154.0561	-1.0182145834	8.033001	8.033298	-19.017161	-0.1	3
i1.12	155.08228	-1.007707119	8.033298	8.033998	-19.11676	-0.1	3
i1.12	156.10843	-1.0052853823	8.033998	8.034477	-19.217868	-0.1	3
i1.12	157.13458	-1.0185049772	8.034477	8.033840	-19.316546	-0.1	3
i1.12	158.16074	-1.0241816044	8.033840	8.034977	-19.418747	-0.1	3
i1.12	159.18689	-1.0164306164	8.034977	8.035392	-19.517256	-0.1	3
i1.12	160.21306	-0.9849480987	8.035392	8.033523	-19.617188	-0.1	3
i1.12	161.23921	-1.0231554508	8.033523	8.034878	-19.710476	-0.1	3
i1.12	162.26537	-0.9951574802	8.034878	8.034879	-19.808821	-0.1	3
i1.12	163.29152	-0.9957756996	8.034879	8.035689	-19.899166	-0.1	3
i1.12	164.31769	-1.0063107014	8.035689	8.035134	-19.945521	-0.1	3
i1.12	165.34384	-1.0121532679	8.035134	8.033627	-19.840733	-0.1	3
i1.12	166.37	-1.0224107504	8.033627	8.034973	-19.749323	-0.1	3
i1.12	167.39615	-0.9909649491	8.034973	8.032571	-19.645783	-0.1	3
i1.12	168.4223	-1.0189182758	8.032571	8.034104	-19.553336	-0.1	3
i1.12	169.44847	-1.0173714161	8.034104	8.032717	-19.4524	-0.1	3
i1.12	170.47462	-0.9865853786	8.032717	8.033558	-19.350258	-0.1	3
i1.12	171.50078	-1.0155614614	8.033558	8.034566	-19.251896	-0.1	3
i1.12	172.52695	-0.9956073165	8.034566	8.034021	-19.157315	-0.1	3
i1.12	173.5531	-0.98697716	8.034021	8.033335	-19.0565	-0.1	3
i1.12	174.57925	-1.0046303272	8.033335	8.031817	-18.956869	-0.1	3
i1.12	175.60541	-1.0205141306	8.031817	8.032592	-18.864051	-0.1	3
i1.12	176.63156	-1.0062482357	8.032592	8.032851	-18.764671	-0.1	3
i1.12	177.65773	-1.0146973133	8.032851	8.032105	-18.673544	-0.1	3
i1.12	178.68388	-0.9911429882	8.032105	8.031513	-18.5648	-0.1	3
i1.12	179.71004	-0.9948013425	8.031513	8.031295	-18.469892	-0.1	3
i1.12	180.73619	-1.0244464874	8.031295	8.031368	-18.369932	-0.1	3
i1.12	181.76234	-0.9911634326	8.031368	8.030929	-18.272572	-0.1	3
i1.12	182.78851	-1.006750226	8.030929	8.030539	-18.167592	-0.1	3
i1.12	183.81467	1.0172926188	8.030539	8.030328	-18.065593	-0.1	3
i1.13	144.16292	-1.014061451	8.030061	8.030061	-17.969376	-0.025	3
i1.13	145.17986	-0.9949932694	8.030061	8.030526	-18.162011	-0.025	3
i1.13	146.19681	-1.0008428097	8.030526	8.030811	-18.263825	-0.025	3
i1.13	147.21376	-1.0132198334	8.030811	8.031348	-18.361007	-0.025	3
i1.13	148.2307	-0.9802341461	8.031348	8.031397	-18.465379	-0.025	3
i1.13	149.24765	-0.9929939508	8.031397	8.031891	-18.557328	-0.025	3
i1.13	150.2646	-0.9905977845	8.031891	8.032461	-18.648363	-0.025	3
i1.13	151.28156	-1.0126457214	8.032461	8.032710	-18.75403	-0.025	3
i1.13	152.2985	-1.0078918934	8.032710	8.032555	-18.848285	-0.025	3
i1.13	153.31544	-0.9916089177	8.032555	8.032955	-18.961281	-0.025	3
i1.13	154.3324	-1.0003157854	8.032955	8.033316	-19.046604	-0.025	3
i1.13	155.34933	-1.0022889376	8.033316	8.034249	-19.14993	-0.025	3
i1.13	156.36629	-1.007167697	8.034249	8.034750	-19.247877	-0.025	3
i1.13	157.38322	-0.987379849	8.034750	8.035754	-19.349702	-0.025	3
i1.13	158.40018	-1.008089304	8.035754	8.033880	-19.43886	-0.025	3
i1.13	159.41713	-0.9984062314	8.033880	8.034542	-19.540537	-0.025	3
i1.13	160.43408	-0.99039042	8.034542	8.034247	-19.634401	-0.025	3
i1.13	161.45102	-0.9865493178	8.034247	8.034588	-19.724842	-0.025	3
i1.13	162.46797	-1.01090765	8.034588	8.035702	-19.832515	-0.025	3
i1.13	163.48492	-0.9877923727	8.035702	8.036922	-19.930926	-0.025	3
i1.13	164.50186	-0.9787734151	8.036922	8.036753	-19.91986	-0.025	3
i1.13	165.51881	-1.0131011009	8.036753	8.035773	-19.830566	-0.025	3
i1.13	166.53577	-0.9829057455	8.035773	8.035128	-19.734586	-0.025	3
i1.13	167.5527	-0.9850755334	8.035128	8.033437	-19.623491	-0.025	3
i1.13	168.56966	-0.9924312234	8.033437	8.035073	-19.54007	-0.025	3
i1.13	169.58661	-0.9791176319	8.035073	8.035643	-19.431786	-0.025	3
i1.13	170.60355	-1.0146235228	8.035643	8.034768	-19.342291	-0.025	3
i1.13	171.6205	-0.9816558957	8.034768	8.034400	-19.248472	-0.025	3
i1.13	172.63745	-0.988617301	8.034400	8.032291	-19.141352	-0.025	3
i1.13	173.65439	-1.0067098141	8.032291	8.033211	-19.059575	-0.025	3
i1.13	174.67134	-1.0115724802	8.033211	8.032749	-18.942393	-0.025	3
i1.13	175.6883	-0.9897125959	8.032749	8.033393	-18.85446	-0.025	3
i1.13	176.70523	-0.9861504436	8.033393	8.032605	-18.755847	-0.025	3
i1.13	177.72218	-0.9769342542	8.032605	8.031185	-18.663241	-0.025	3
i1.13	178.73914	-1.0155603886	8.031185	8.031299	-18.551105	-0.025	3
i1.13	179.75607	-0.9819210768	8.031299	8.031254	-18.458016	-0.025	3
i1.13	180.77303	-1.0168423653	8.031254	8.030962	-18.359651	-0.025	3
i1.13	181.78998	-0.9959803224	8.030962	8.030946	-18.266691	-0.025	3
i1.13	182.80693	-0.9891306758	8.030946	8.030576	-18.161824	-0.025	3
i1.13	183.82387	0.998596251	8.030576	8.030202	-18.075836	-0.025	3
i1.14	144.73584	-0.9626360536	8.030049	8.030049	-17.965428	0.05	3
i1.14	145.73846	-0.9828231335	8.030049	8.030769	-18.217583	0.05	3
i1.14	146.74109	-0.9637153745	8.030769	8.031015	-18.331443	0.05	3
i1.14	147.74371	-1.0008995533	8.031015	8.032107	-18.415613	0.05	3
i1.14	148.74634	-0.9655883908	8.032107	8.031670	-18.512015	0.05	3
i1.14	149.74896	-0.9730719924	8.031670	8.032038	-18.602441	0.05	3
i1.14	150.75159	-0.9616913795	8.032038	8.032240	-18.694008	0.05	3
i1.14	151.75421	-0.9886587858	8.032240	8.033275	-18.798491	0.05	3
i1.14	152.75684	-0.9626727104	8.033275	8.032242	-18.892316	0.05	3
i1.14	153.75946	-0.9852558374	8.032242	8.033196	-18.995148	0.05	3
i1.14	154.76208	-0.9995746613	8.033196	8.033537	-19.093153	0.05	3
i1.14	155.76471	-0.9650922418	8.033537	8.033880	-19.187108	0.05	3
i1.14	156.76733	-0.9733217955	8.033880	8.034059	-19.28653	0.05	3
i1.14	157.76996	-0.9722505808	8.034059	8.031788	-19.380668	0.05	3
i1.14	158.77258	-0.9872666001	8.031788	8.035436	-19.471716	0.05	3
i1.14	159.7752	-0.9823413491	8.035436	8.036958	-19.565343	0.05	3
i1.14	160.77783	-0.9682946801	8.036958	8.035850	-19.669179	0.05	3
i1.14	161.78046	-0.9644427896	8.035850	8.036700	-19.76422	0.05	3
i1.14	162.78308	-0.998790741	8.036700	8.036275	-19.8534	0.05	3
i1.14	163.7857	-0.9684783816	8.036275	8.036183	-19.953636	0.05	3
i1.14	164.78833	-0.9857414961	8.036183	8.037408	-19.905912	0.05	3
i1.14	165.79095	-0.9862089753	8.037408	8.035567	-19.794867	0.05	3
i1.14	166.79358	-0.9922524691	8.035567	8.034450	-19.716167	0.05	3
i1.14	167.7962	-0.9610437751	8.034450	8.032614	-19.608629	0.05	3
i1.14	168.79883	-0.9926231503	8.032614	8.036492	-19.521182	0.05	3
i1.14	169.80145	-0.9644299746	8.036492	8.034094	-19.416293	0.05	3
i1.14	170.80408	-0.9745615721	8.034094	8.034911	-19.317544	0.05	3
i1.14	171.8067	-0.9667078853	8.034911	8.034093	-19.220115	0.05	3
i1.14	172.80933	-0.9629639983	8.034093	8.033697	-19.128269	0.05	3
i1.14	173.81195	-0.9763413668	8.033697	8.033319	-19.028218	0.05	3
i1.14	174.81458	-0.9998277426	8.033319	8.033292	-18.93954	0.05	3
i1.14	175.8172	-0.9677072167	8.033292	8.032623	-18.843557	0.05	3
i1.14	176.81982	-1.0000534058	8.032623	8.032128	-18.752482	0.05	3
i1.14	177.82245	-0.9754280448	8.032128	8.031938	-18.649051	0.05	3
i1.14	178.82507	-0.9903346896	8.031938	8.032199	-18.546536	0.05	3
i1.14	179.8277	-0.980322361	8.032199	8.031702	-18.462162	0.05	3
i1.14	180.83032	-0.9966040254	8.031702	8.031031	-18.367997	0.05	3
i1.14	181.83295	-0.9768118262	8.031031	8.030762	-18.258091	0.05	3
i1.14	182.83557	-0.967703104	8.030762	8.030670	-18.172728	0.05	3
i1.14	183.8382	0.9853181243	8.030670	8.030235	-18.066284	0.05	3
i1.15	144.39226	-0.9970346689	8.030046	8.030046	-17.988061	0.125	3
i1.15	145.40346	-1.0062623024	8.030046	8.030490	-18.192887	0.125	3
i1.15	146.41467	-0.9954647422	8.030490	8.030687	-18.294883	0.125	3
i1.15	147.42589	-0.9938987494	8.030687	8.031023	-18.386676	0.125	3
i1.15	148.4371	-0.992536664	8.031023	8.031972	-18.469411	0.125	3
i1.15	149.44832	-0.9870738387	8.031972	8.032113	-18.579351	0.125	3
i1.15	150.45953	-0.9865185618	8.032113	8.032156	-18.670081	0.125	3
i1.15	151.47075	-1.0103642941	8.032156	8.033409	-18.766377	0.125	3
i1.15	152.48196	-1.0014408827	8.033409	8.033014	-18.864638	0.125	3
i1.15	153.49318	-1.0038477182	8.033014	8.033116	-18.964866	0.125	3
i1.15	154.5044	-0.9903939366	8.033116	8.033106	-19.060764	0.125	3
i1.15	155.51561	-0.9966798425	8.033106	8.034629	-19.159695	0.125	3
i1.15	156.52682	-0.9970749617	8.034629	8.032238	-19.259983	0.125	3
i1.15	157.53804	-0.9717000127	8.032238	8.035483	-19.352886	0.125	3
i1.15	158.54926	-0.9735440612	8.035483	8.034375	-19.461343	0.125	3
i1.15	159.56047	-0.9997020364	8.034375	8.034365	-19.55222	0.125	3
i1.15	160.57169	-0.9896885753	8.034365	8.034992	-19.650367	0.125	3
i1.15	161.5829	-1.0025163889	8.034992	8.034514	-19.748213	0.125	3
i1.15	162.59412	-0.9925636649	8.034514	8.034662	-19.839304	0.125	3
i1.15	163.60532	-1.0009623766	8.034662	8.035844	-19.931761	0.125	3
i1.15	164.61653	-0.9974887371	8.035844	8.035412	-19.91416	0.125	3
i1.15	165.62775	-0.9911389351	8.035412	8.033422	-19.815627	0.125	3
i1.15	166.63896	-0.9867518544	8.033422	8.036002	-19.731899	0.125	3
i1.15	167.65018	-1.0012816191	8.036002	8.036251	-19.625827	0.125	3
i1.15	168.66139	-0.9976869822	8.036251	8.033834	-19.521333	0.125	3
i1.15	169.6726	-0.9843921065	8.033834	8.034923	-19.432207	0.125	3
i1.15	170.68382	-1.007555604	8.034923	8.034449	-19.338353	0.125	3
i1.15	171.69504	-0.9740138054	8.034449	8.033933	-19.235858	0.125	3
i1.15	172.70625	-1.0017786026	8.033933	8.033442	-19.147299	0.125	3
i1.15	173.71747	-0.9854774475	8.033442	8.033007	-19.046399	0.125	3
i1.15	174.72868	-0.9743794203	8.033007	8.032821	-18.94607	0.125	3
i1.15	175.7399	-0.9770890474	8.032821	8.032171	-18.841866	0.125	3
i1.15	176.7511	-1.0059337616	8.032171	8.032336	-18.761619	0.125	3
i1.15	177.76233	-0.990814507	8.032336	8.031727	-18.6533	0.125	3
i1.15	178.77353	-0.996425271	8.031727	8.031964	-18.552575	0.125	3
i1.15	179.78476	-1.0084570646	8.031964	8.031518	-18.448875	0.125	3
i1.15	180.79596	-0.9749638438	8.031518	8.030888	-18.366533	0.125	3
i1.15	181.80717	-0.9907436967	8.030888	8.030954	-18.274161	0.125	3
i1.15	182.81839	-0.987924695	8.030954	8.030484	-18.167758	0.125	3
i1.15	183.8296	1.0037634373	8.030484	8.030340	-18.063475	0.125	3
i1.16	144.5507	-0.9871819019	8.030037	8.030037	-17.970195	0.2	3
i1.16	145.55795	-0.9710955024	8.030037	8.030680	-18.204386	0.2	3
i1.16	146.5652	-0.9915992022	8.030680	8.031047	-18.296523	0.2	3
i1.16	147.57245	-0.9891872406	8.031047	8.031303	-18.402726	0.2	3
i1.16	148.57971	-1.0043261051	8.031303	8.031228	-18.498837	0.2	3
i1.16	149.58696	-1.005343318	8.031228	8.032093	-18.589431	0.2	3
i1.16	150.59422	-0.9715684056	8.032093	8.032302	-18.692895	0.2	3
i1.16	151.60147	-0.993255198	8.032302	8.032656	-18.781035	0.2	3
i1.16	152.60872	-0.98977983	8.032656	8.033919	-18.876238	0.2	3
i1.16	153.61597	-0.9724456668	8.033919	8.032993	-18.980828	0.2	3
i1.16	154.62323	-0.9879155159	8.032993	8.032695	-19.08151	0.2	3
i1.16	155.63048	-0.9972391129	8.032695	8.033712	-19.160868	0.2	3
i1.16	156.63774	-0.9798977375	8.033712	8.033599	-19.27365	0.2	3
i1.16	157.64499	-0.9958873391	8.033599	8.033985	-19.360144	0.2	3
i1.16	158.65224	-0.9894226789	8.033985	8.033779	-19.460465	0.2	3
i1.16	159.65948	-0.998351872	8.033779	8.034430	-19.560992	0.2	3
i1.16	160.66675	-0.9699679017	8.034430	8.035535	-19.663774	0.2	3
i1.16	161.674	-1.0011616945	8.035535	8.035103	-19.751109	0.2	3
i1.16	162.68126	-0.9716333151	8.035103	8.038339	-19.852371	0.2	3
i1.16	163.6885	-0.9670390487	8.038339	8.037633	-19.941635	0.2	3
i1.16	164.69576	-0.9794417024	8.037633	8.036025	-19.908144	0.2	3
i1.16	165.703	-0.9720169306	8.036025	8.035224	-19.810881	0.2	3
i1.16	166.71027	-0.9727530479	8.035224	8.034634	-19.714899	0.2	3
i1.16	167.71751	-0.9995585084	8.034634	8.035955	-19.618824	0.2	3
i1.16	168.72478	-0.9915992618	8.035955	8.035431	-19.516535	0.2	3
i1.16	169.73203	-0.9721391797	8.035431	8.034449	-19.424285	0.2	3
i1.16	170.73927	-0.9870175123	8.034449	8.031529	-19.329797	0.2	3
i1.16	171.74652	-0.9784120917	8.031529	8.033656	-19.232429	0.2	3
i1.16	172.75378	-0.9706691504	8.033656	8.033768	-19.134154	0.2	3
i1.16	173.76103	-1.0024844408	8.033768	8.033588	-19.036084	0.2	3
i1.16	174.7683	-1.0017821789	8.033588	8.032648	-18.948484	0.2	3
i1.16	175.77554	-0.973626852	8.032648	8.032764	-18.848186	0.2	3
i1.16	176.78279	-0.9728215337	8.032764	8.032460	-18.75047	0.2	3
i1.16	177.79004	-0.9877775311	8.032460	8.032116	-18.66523	0.2	3
i1.16	178.7973	-0.9950132966	8.032116	8.031321	-18.55896	0.2	3
i1.16	179.80455	-1.0066977739	8.031321	8.031590	-18.472285	0.2	3
i1.16	180.8118	-0.9711851478	8.031590	8.031071	-18.354612	0.2	3
i1.16	181.81906	-0.9805410504	8.031071	8.030930	-18.264622	0.2	3
i1.16	182.82632	-1.0049320459	8.030930	8.030494	-18.160401	0.2	3
i1.16	183.83356	0.9894601703	8.030494	8.030354	-18.072457	0.2	3
i1.17	143.74847	-1.0201950073	8.030054	8.030054	-17.985596	0.275	3
i1.17	144.77579	-1.0090174675	8.030054	8.030685	-18.131818	0.275	3
i1.17	145.8031	-1.009634614	8.030685	8.030546	-18.224381	0.275	3
i1.17	146.8304	-1.0162914991	8.030546	8.031601	-18.326229	0.275	3
i1.17	147.85771	-0.9902936816	8.031601	8.031240	-18.426457	0.275	3
i1.17	148.88503	-1.0151045322	8.031240	8.032151	-18.527972	0.275	3
i1.17	149.91232	-1.0088635683	8.032151	8.031880	-18.624561	0.275	3
i1.17	150.93964	-0.9982861876	8.031880	8.031946	-18.714574	0.275	3
i1.17	151.96695	-1.0260757208	8.031946	8.032516	-18.819775	0.275	3
i1.17	152.99426	-1.0033431053	8.032516	8.034054	-18.922022	0.275	3
i1.17	154.02156	-1.0049755573	8.034054	8.032679	-19.020298	0.275	3
i1.17	155.04887	-1.0199333429	8.032679	8.033132	-19.1161	0.275	3
i1.17	156.07619	-0.9870541096	8.033132	8.033837	-19.209947	0.275	3
i1.17	157.10349	-1.0195593834	8.033837	8.034088	-19.323404	0.275	3
i1.17	158.1308	-1.0151869059	8.034088	8.035035	-19.412447	0.275	3
i1.17	159.15811	-1.0060690641	8.035035	8.033539	-19.507158	0.275	3
i1.17	160.18542	-1.0090779066	8.033539	8.033574	-19.608986	0.275	3
i1.17	161.21272	-0.9864541292	8.033574	8.036152	-19.708297	0.275	3
i1.17	162.24004	-1.0042486191	8.036152	8.035414	-19.802623	0.275	3
i1.17	163.26733	-0.9912686348	8.035414	8.035645	-19.911008	0.275	3
i1.17	164.29465	-0.9882356524	8.035645	8.036421	-19.945837	0.275	3
i1.17	165.32196	-1.0258975029	8.036421	8.037165	-19.862886	0.275	3
i1.17	166.34927	-1.0123986006	8.037165	8.034346	-19.745413	0.275	3
i1.17	167.37657	-1.0204348564	8.034346	8.036488	-19.643043	0.275	3
i1.17	168.40388	-1.0209034681	8.036488	8.035144	-19.551665	0.275	3
i1.17	169.43118	-0.9881173968	8.035144	8.035710	-19.463679	0.275	3
i1.17	170.4585	-0.9924765229	8.035710	8.034913	-19.354989	0.275	3
i1.17	171.48581	-0.9860702753	8.034913	8.033525	-19.251777	0.275	3
i1.17	172.51312	-1.0118228197	8.033525	8.032507	-19.156941	0.275	3
i1.17	173.54042	-1.0135463476	8.032507	8.032925	-19.064627	0.275	3
i1.17	174.56773	-1.0240778923	8.032925	8.032836	-18.965136	0.275	3
i1.17	175.59505	-1.0080322027	8.032836	8.032169	-18.858975	0.275	3
i1.17	176.62234	-0.9927312732	8.032169	8.032942	-18.758104	0.275	3
i1.17	177.64966	-1.0021502972	8.032942	8.031850	-18.652032	0.275	3
i1.17	178.67697	-1.0267281532	8.031850	8.031583	-18.564432	0.275	3
i1.17	179.70428	-1.0259641409	8.031583	8.031706	-18.477274	0.275	3
i1.17	180.73158	-1.0119045973	8.031706	8.031116	-18.37228	0.275	3
i1.17	181.7589	-1.0184309483	8.031116	8.030826	-18.275842	0.275	3
i1.17	182.7862	-1.0162389278	8.030826	8.030530	-18.161871	0.275	3
i1.17	183.8135	1.0051839352	8.030530	8.030365	-18.067668	0.275	3
i1.10	186.78496	-1.023512125	7.060055	7.060055	-17.969021	-0.25	3
i1.10	187.8112	-0.9976401925	7.060055	7.060405	-18.124155	-0.25	3
i1.10	188.83746	-1.0168434381	7.060405	7.060756	-18.239536	-0.25	3
i1.10	189.86372	-0.9982861876	7.060756	7.061145	-18.328437	-0.25	3
i1.10	190.88998	-1.0185488462	7.061145	7.061551	-18.435933	-0.25	3
i1.10	191.91623	-1.0213655233	7.061551	7.061906	-18.532022	-0.25	3
i1.10	192.94249	-1.0185450315	7.061906	7.062052	-18.630384	-0.25	3
i1.10	193.96875	-1.0068074465	7.062052	7.063141	-18.731918	-0.25	3
i1.10	194.995	-0.9854586124	7.063141	7.062473	-18.810874	-0.25	3
i1.10	196.02126	-1.0102971792	7.062473	7.063507	-18.919494	-0.25	3
i1.10	197.04752	-1.0189125538	7.063507	7.063013	-19.027342	-0.25	3
i1.10	198.07378	-0.9890338778	7.063013	7.063152	-19.122636	-0.25	3
i1.10	199.10004	-0.9855430722	7.063152	7.063813	-19.215447	-0.25	3
i1.10	200.1263	-0.9855648279	7.063813	7.063598	-19.307927	-0.25	3
i1.10	201.15254	-1.0197589397	7.063598	7.065038	-19.418905	-0.25	3
i1.10	202.1788	-1.0044548512	7.065038	7.064166	-19.518761	-0.25	3
i1.10	203.20506	-1.0247610807	7.064166	7.063188	-19.605818	-0.25	3
i1.10	204.23131	-1.0187354088	7.063188	7.063525	-19.715519	-0.25	3
i1.10	205.25757	-1.0171742439	7.063525	7.067285	-19.803941	-0.25	3
i1.10	206.28383	-0.9854382277	7.067285	7.065667	-19.897721	-0.25	3
i1.10	207.31009	-0.9900528193	7.065667	7.066562	-19.943104	-0.25	3
i1.10	208.33633	-0.994728744	7.066562	7.065737	-19.853822	-0.25	3
i1.10	209.36261	-1.0062042475	7.065737	7.064606	-19.746714	-0.25	3
i1.10	210.38885	-0.987462163	7.064606	7.066614	-19.649246	-0.25	3
i1.10	211.41512	-1.0000785589	7.066614	7.064683	-19.552504	-0.25	3
i1.10	212.44138	-0.9882165194	7.064683	7.063683	-19.456296	-0.25	3
i1.10	213.46762	-1.0091817379	7.063683	7.063474	-19.355668	-0.25	3
i1.10	214.49388	-1.0153673887	7.063474	7.062347	-19.2515	-0.25	3
i1.10	215.52014	-0.9847691059	7.062347	7.063030	-19.154614	-0.25	3
i1.10	216.5464	-1.017636776	7.063030	7.062790	-19.060146	-0.25	3
i1.10	217.57266	-1.0257982016	7.062790	7.062694	-18.953896	-0.25	3
i1.10	218.5989	-1.0031392574	7.062694	7.062642	-18.854734	-0.25	3
i1.10	219.62517	-0.9855766296	7.062642	7.062810	-18.758557	-0.25	3
i1.10	220.65143	-1.0022087097	7.062810	7.062152	-18.666135	-0.25	3
i1.10	221.67767	-0.9953508377	7.062152	7.062492	-18.565409	-0.25	3
i1.10	222.70395	-0.9914593101	7.062492	7.061514	-18.473483	-0.25	3
i1.10	223.7302	-0.9900907278	7.061514	7.060849	-18.364099	-0.25	3
i1.10	224.75645	-1.0259035826	7.060849	7.060978	-18.265327	-0.25	3
i1.10	225.78271	-1.0109827518	7.060978	7.060682	-18.171529	-0.25	3
i1.10	226.80896	1.0022820234	7.060682	7.060379	-18.079184	-0.25	3
i1.11	187.3023	-1.0101839304	7.060060	7.060060	-17.97736	-0.175	3
i1.11	188.31563	-0.9801152945	7.060060	7.060518	-18.176929	-0.175	3
i1.11	189.32895	-0.9746021628	7.060518	7.060680	-18.27504	-0.175	3
i1.11	190.34227	-1.0095380545	7.060680	7.061117	-18.376717	-0.175	3
i1.11	191.35559	-0.9844349623	7.061117	7.061073	-18.477299	-0.175	3
i1.11	192.36893	-1.0010237694	7.061073	7.061787	-18.56595	-0.175	3
i1.11	193.38223	-0.9924323559	7.061787	7.061533	-18.664699	-0.175	3
i1.11	194.39557	-1.0068097115	7.061533	7.063069	-18.761233	-0.175	3
i1.11	195.40889	-1.0089138746	7.063069	7.062377	-18.873173	-0.175	3
i1.11	196.42221	-0.9985364079	7.062377	7.062552	-18.956225	-0.175	3
i1.11	197.43553	-1.0033909082	7.062552	7.063707	-19.053456	-0.175	3
i1.11	198.44885	-0.9903526306	7.063707	7.061707	-19.159279	-0.175	3
i1.11	199.46219	-1.0113766193	7.061707	7.064018	-19.26306	-0.175	3
i1.11	200.4755	-1.0041793585	7.064018	7.064653	-19.351704	-0.175	3
i1.11	201.48883	-0.99402982	7.064653	7.064371	-19.44884	-0.175	3
i1.11	202.50215	-1.0062793493	7.064371	7.064207	-19.53991	-0.175	3
i1.11	203.51547	-1.0078977346	7.064207	7.064131	-19.64387	-0.175	3
i1.11	204.5288	-1.0093841553	7.064131	7.064515	-19.730585	-0.175	3
i1.11	205.54211	-0.9907604456	7.064515	7.066950	-19.830627	-0.175	3
i1.11	206.55544	-0.981564641	7.066950	7.066519	-19.926458	-0.175	3
i1.11	207.56876	-0.9836545587	7.066519	7.064692	-19.916806	-0.175	3
i1.11	208.58209	-0.9911432862	7.064692	7.066750	-19.816987	-0.175	3
i1.11	209.59541	-1.0074038506	7.066750	7.066974	-19.726297	-0.175	3
i1.11	210.60873	-1.0057632923	7.066974	7.067635	-19.637957	-0.175	3
i1.11	211.62206	-1.0047941208	7.067635	7.064496	-19.528079	-0.175	3
i1.11	212.63538	-0.9947326183	7.064496	7.063960	-19.44148	-0.175	3
i1.11	213.6487	-0.9790807366	7.063960	7.064963	-19.330169	-0.175	3
i1.11	214.66202	-1.0026016235	7.064963	7.064326	-19.240685	-0.175	3
i1.11	215.67535	-1.0001069307	7.064326	7.063625	-19.137013	-0.175	3
i1.11	216.68866	-1.00043118	7.063625	7.063021	-19.052994	-0.175	3
i1.11	217.702	-0.9983017445	7.063021	7.062525	-18.954372	-0.175	3
i1.11	218.71532	-0.9780595899	7.062525	7.061962	-18.837109	-0.175	3
i1.11	219.72864	-0.9858875275	7.061962	7.061982	-18.749887	-0.175	3
i1.11	220.74196	-0.99615556	7.061982	7.062087	-18.66007	-0.175	3
i1.11	221.75528	-0.9925909638	7.062087	7.061643	-18.558719	-0.175	3
i1.11	222.76862	-0.980969131	7.061643	7.061329	-18.458225	-0.175	3
i1.11	223.78192	-0.9760011435	7.061329	7.061455	-18.368285	-0.175	3
i1.11	224.79526	-0.9965331554	7.061455	7.060981	-18.269072	-0.175	3
i1.11	225.80858	-1.0032095909	7.060981	7.060785	-18.167966	-0.175	3
i1.11	226.8219	1.0062429905	7.060785	7.060455	-18.078154	-0.175	3
i1.12	186.48413	-0.9940767884	7.060052	7.060052	-17.966971	-0.1	3
i1.12	187.51791	-1.0240933895	7.060052	7.060567	-18.114282	-0.1	3
i1.12	188.5517	-1.0243781805	7.060567	7.060740	-18.21138	-0.1	3
i1.12	189.58546	-0.9924384952	7.060740	7.061059	-18.302919	-0.1	3
i1.12	190.61925	-1.0238982439	7.061059	7.061775	-18.400583	-0.1	3
i1.12	191.65303	-0.9991093278	7.061775	7.061726	-18.505718	-0.1	3
i1.12	192.6868	-1.0223172903	7.061726	7.061760	-18.596912	-0.1	3
i1.12	193.72058	-1.0080785751	7.061760	7.062657	-18.695	-0.1	3
i1.12	194.75435	-1.0145816803	7.062657	7.062784	-18.7933	-0.1	3
i1.12	195.78813	-1.027151823	7.062784	7.062752	-18.905529	-0.1	3
i1.12	196.82191	-1.0230923891	7.062752	7.062233	-18.999848	-0.1	3
i1.12	197.85568	-1.020650506	7.062233	7.063841	-19.096911	-0.1	3
i1.12	198.88947	-1.0012611151	7.063841	7.062760	-19.206268	-0.1	3
i1.12	199.92323	-1.0055450201	7.062760	7.063591	-19.296555	-0.1	3
i1.12	200.95702	-1.0028493404	7.063591	7.063788	-19.394208	-0.1	3
i1.12	201.9908	-1.0013796091	7.063788	7.064411	-19.490435	-0.1	3
i1.12	203.02457	-1.0102250576	7.064411	7.063314	-19.601338	-0.1	3
i1.12	204.05835	-0.9963982105	7.063314	7.063991	-19.693925	-0.1	3
i1.12	205.09213	-0.9962225556	7.063991	7.065433	-19.792804	-0.1	3
i1.12	206.1259	-1.0098608732	7.065433	7.064303	-19.88814	-0.1	3
i1.12	207.15968	-1.0253838301	7.064303	7.064363	-19.962011	-0.1	3
i1.12	208.19345	-1.0245115757	7.064363	7.064250	-19.861996	-0.1	3
i1.12	209.22723	-1.0100235939	7.064250	7.064292	-19.75261	-0.1	3
i1.12	210.26102	-1.0087941885	7.064292	7.066450	-19.656319	-0.1	3
i1.12	211.29478	-1.0020776987	7.066450	7.064476	-19.564683	-0.1	3
i1.12	212.32857	-0.9931200743	7.064476	7.064006	-19.461855	-0.1	3
i1.12	213.36234	-1.0046514273	7.064006	7.064355	-19.362825	-0.1	3
i1.12	214.39612	-1.0259898901	7.064355	7.063090	-19.260543	-0.1	3
i1.12	215.4299	-1.0204952955	7.063090	7.063554	-19.162837	-0.1	3
i1.12	216.46367	-1.0164898634	7.063554	7.061938	-19.062706	-0.1	3
i1.12	217.49745	-1.0276595354	7.061938	7.062975	-18.964705	-0.1	3
i1.12	218.53122	-1.0047470331	7.062975	7.062178	-18.870816	-0.1	3
i1.12	219.565	-0.9934880137	7.062178	7.062571	-18.763055	-0.1	3
i1.12	220.59879	-1.0236122608	7.062571	7.061374	-18.673277	-0.1	3
i1.12	221.63255	-0.9943304658	7.061374	7.060956	-18.567995	-0.1	3
i1.12	222.66634	-1.0092517138	7.060956	7.061273	-18.468725	-0.1	3
i1.12	223.7001	-0.998225987	7.061273	7.061346	-18.368037	-0.1	3
i1.12	224.73389	-1.0309360027	7.061346	7.060781	-18.284906	-0.1	3
i1.12	225.76767	-0.9984717369	7.060781	7.060433	-18.17832	-0.1	3
i1.12	226.80145	0.994500339	7.060433	7.060309	-18.07899	-0.1	3
i1.13	187.6785	-0.9644411206	7.060056	7.060056	-17.975372	-0.025	3
i1.13	188.68242	-0.9699078798	7.060056	7.060671	-18.218691	-0.025	3
i1.13	189.68633	-0.9810895324	7.060671	7.061105	-18.31922	-0.025	3
i1.13	190.69025	-0.992887795	7.061105	7.061199	-18.416914	-0.025	3
i1.13	191.69417	-0.9750207067	7.061199	7.061850	-18.504396	-0.025	3
i1.13	192.69809	-0.9711003304	7.061850	7.061869	-18.60581	-0.025	3
i1.13	193.70201	-0.973282516	7.061869	7.061820	-18.702786	-0.025	3
i1.13	194.70592	-0.9956656098	7.061820	7.062981	-18.795638	-0.025	3
i1.13	195.70984	-0.9838901162	7.062981	7.062644	-18.893731	-0.025	3
i1.13	196.71376	-0.9766074419	7.062644	7.062131	-18.983911	-0.025	3
i1.13	197.71768	-0.9841046333	7.062131	7.063081	-19.085642	-0.025	3
i1.13	198.72159	-0.9746115208	7.063081	7.062797	-19.178089	-0.025	3
i1.13	199.72551	-0.9755523205	7.062797	7.064688	-19.27138	-0.025	3
i1.13	200.72943	-0.963498652	7.064688	7.063468	-19.362458	-0.025	3
i1.13	201.73335	-0.9892175794	7.063468	7.064061	-19.475603	-0.025	3
i1.13	202.73727	-0.9660720229	7.064061	7.066534	-19.563535	-0.025	3
i1.13	203.74118	-0.9704964161	7.066534	7.064696	-19.664465	-0.025	3
i1.13	204.7451	-0.9994581342	7.064696	7.064717	-19.751336	-0.025	3
i1.13	205.74902	-0.9721089602	7.064717	7.063492	-19.856217	-0.025	3
i1.13	206.75294	-0.9656488895	7.063492	7.066305	-19.948265	-0.025	3
i1.13	207.75687	-0.9882873893	7.066305	7.067126	-19.901091	-0.025	3
i1.13	208.76077	-0.9767602086	7.067126	7.068090	-19.803687	-0.025	3
i1.13	209.7647	-0.9927823544	7.068090	7.067140	-19.714489	-0.025	3
i1.13	210.76862	-0.9923179746	7.067140	7.064590	-19.61576	-0.025	3
i1.13	211.77254	-0.9915886521	7.064590	7.064926	-19.512253	-0.025	3
i1.13	212.77644	-0.9939929247	7.064926	7.064279	-19.418855	-0.025	3
i1.13	213.78036	-0.9684578776	7.064279	7.063224	-19.322823	-0.025	3
i1.13	214.78429	-0.984813571	7.063224	7.063158	-19.227036	-0.025	3
i1.13	215.78821	-0.9630705714	7.063158	7.063475	-19.133318	-0.025	3
i1.13	216.79211	-0.9875561595	7.063475	7.063660	-19.027652	-0.025	3
i1.13	217.79604	-0.9867005348	7.063660	7.063841	-18.940284	-0.025	3
i1.13	218.79996	-0.9744901061	7.063841	7.062079	-18.847708	-0.025	3
i1.13	219.80388	-0.9708789587	7.062079	7.062176	-18.734255	-0.025	3
i1.13	220.8078	-1.0031335354	7.062176	7.061960	-18.652441	-0.025	3
i1.13	221.8117	-0.9868934155	7.061960	7.061211	-18.55223	-0.025	3
i1.13	222.81563	-0.969348371	7.061211	7.061878	-18.45878	-0.025	3
i1.13	223.81955	-0.9786852598	7.061878	7.061173	-18.365822	-0.025	3
i1.13	224.82347	-0.9714642763	7.061173	7.060559	-18.270046	-0.025	3
i1.13	225.8274	-0.9624375105	7.060559	7.060605	-18.169821	-0.025	3
i1.13	226.8313	0.9731725454	7.060605	7.060295	-18.071656	-0.025	3
i1.14	186.18996	-1.0315642357	7.060049	7.060049	-17.971529	0.05	3
i1.14	187.2311	-1.0285760164	7.060049	7.060440	-18.081903	0.05	3
i1.14	188.27222	-1.0034840107	7.060440	7.060794	-18.171151	0.05	3
i1.14	189.31335	-1.0298442841	7.060794	7.061166	-18.280973	0.05	3
i1.14	190.35449	-1.0259776115	7.061166	7.061056	-18.378929	0.05	3
i1.14	191.39561	-1.0309306383	7.061056	7.061430	-18.472663	0.05	3
i1.14	192.43675	-1.0320547819	7.061430	7.061611	-18.587649	0.05	3
i1.14	193.47787	-1.0136325359	7.061611	7.062180	-18.670923	0.05	3
i1.14	194.51901	-1.0158150196	7.062180	7.062205	-18.782396	0.05	3
i1.14	195.56013	-1.0405683517	7.062205	7.062461	-18.880875	0.05	3
i1.14	196.60127	-1.0216946602	7.062461	7.063179	-18.984065	0.05	3
i1.14	197.64241	-1.0330507755	7.063179	7.062887	-19.079501	0.05	3
i1.14	198.68353	-1.0115388632	7.062887	7.063949	-19.175927	0.05	3
i1.14	199.72467	-1.0341818333	7.063949	7.065294	-19.286277	0.05	3
i1.14	200.7658	-1.0380755663	7.065294	7.065391	-19.366405	0.05	3
i1.14	201.80693	-1.0066291094	7.065391	7.064442	-19.472671	0.05	3
i1.14	202.84805	-1.0363456011	7.064442	7.062997	-19.574966	0.05	3
i1.14	203.88919	-1.0103114843	7.062997	7.066296	-19.674424	0.05	3
i1.14	204.93033	-1.0297533274	7.066296	7.065891	-19.778059	0.05	3
i1.14	205.97147	-1.0135215521	7.065891	7.067204	-19.875346	0.05	3
i1.14	207.01259	-1.0018895864	7.067204	7.067816	-19.965229	0.05	3
i1.14	208.05373	-1.0091965199	7.067816	7.067625	-19.880145	0.05	3
i1.14	209.09485	-1.0334972143	7.067625	7.064528	-19.778305	0.05	3
i1.14	210.13599	-1.0052517653	7.064528	7.063650	-19.67057	0.05	3
i1.14	211.17711	-1.0160087347	7.063650	7.065969	-19.569724	0.05	3
i1.14	212.21825	-1.0321669579	7.065969	7.065270	-19.455506	0.05	3
i1.14	213.25938	-1.0020383596	7.065270	7.063747	-19.369698	0.05	3
i1.14	214.3005	-1.01989007	7.063747	7.063277	-19.277071	0.05	3
i1.14	215.34164	-1.0286108255	7.063277	7.063921	-19.179661	0.05	3
i1.14	216.38278	-1.0300070047	7.063921	7.064581	-19.071763	0.05	3
i1.14	217.4239	-1.0143027306	7.064581	7.062875	-18.981578	0.05	3
i1.14	218.46504	-1.000480175	7.062875	7.063236	-18.87745	0.05	3
i1.14	219.50616	-1.0126317739	7.063236	7.061142	-18.774219	0.05	3
i1.14	220.5473	-1.0020679235	7.061142	7.061880	-18.674789	0.05	3
i1.14	221.58844	-1.0379065275	7.061880	7.061309	-18.570591	0.05	3
i1.14	222.62956	-1.0350593328	7.061309	7.061386	-18.480552	0.05	3
i1.14	223.6707	-1.0204074383	7.061386	7.061161	-18.375305	0.05	3
i1.14	224.71182	-1.0043690205	7.061161	7.060961	-18.272275	0.05	3
i1.14	225.75296	-1.0305929184	7.060961	7.060614	-18.179242	0.05	3
i1.14	226.7941	1.039276123	7.060614	7.060297	-18.074401	0.05	3
i1.15	186.39034	-0.9954209328	7.060046	7.060046	-17.972349	0.125	3
i1.15	187.42645	-1.0061655045	7.060046	7.060523	-18.094328	0.125	3
i1.15	188.46257	-0.9951087236	7.060523	7.060877	-18.193062	0.125	3
i1.15	189.4987	-1.0088653564	7.060877	7.061189	-18.302941	0.125	3
i1.15	190.53482	-1.0038086176	7.061189	7.061695	-18.403482	0.125	3
i1.15	191.57094	-1.0103513002	7.061695	7.060951	-18.498821	0.125	3
i1.15	192.60707	-1.0134789944	7.060951	7.062046	-18.593994	0.125	3
i1.15	193.64319	-1.0285148621	7.062046	7.062376	-18.695794	0.125	3
i1.15	194.6793	-1.0299886465	7.062376	7.061663	-18.791231	0.125	3
i1.15	195.71542	-1.0346724987	7.061663	7.063150	-18.89455	0.125	3
i1.15	196.75156	-1.0344113111	7.063150	7.063635	-18.998947	0.125	3
i1.15	197.78767	-1.008957386	7.063635	7.062537	-19.1013	0.125	3
i1.15	198.82379	-1.0305634737	7.062537	7.064156	-19.193887	0.125	3
i1.15	199.85992	-1.0242151022	7.064156	7.062767	-19.28821	0.125	3
i1.15	200.89604	-1.0142097473	7.062767	7.064885	-19.383171	0.125	3
i1.15	201.93216	-1.0203000307	7.064885	7.063790	-19.484793	0.125	3
i1.15	202.96829	-1.0112783909	7.063790	7.064555	-19.588721	0.125	3
i1.15	204.00441	-1.0183218718	7.064555	7.063200	-19.692506	0.125	3
i1.15	205.04053	-1.0344880819	7.063200	7.066102	-19.790358	0.125	3
i1.15	206.07666	-1.0112702847	7.066102	7.065069	-19.881545	0.125	3
i1.15	207.11278	-1.0289129019	7.065069	7.064698	-19.967432	0.125	3
i1.15	208.1489	-0.9971852899	7.064698	7.065051	-19.86549	0.125	3
i1.15	209.18503	-1.0266388655	7.065051	7.064239	-19.768652	0.125	3
i1.15	210.22115	-1.0247094631	7.064239	7.065603	-19.67019	0.125	3
i1.15	211.25726	-1.0300716162	7.065603	7.065346	-19.568021	0.125	3
i1.15	212.2934	-0.9989649057	7.065346	7.065357	-19.466547	0.125	3
i1.15	213.32951	-1.0321662426	7.065357	7.062840	-19.373983	0.125	3
i1.15	214.36563	-1.0074260235	7.062840	7.065057	-19.26995	0.125	3
i1.15	215.40176	-0.9984812737	7.065057	7.064612	-19.168212	0.125	3
i1.15	216.43788	-0.9947267175	7.064612	7.062919	-19.064402	0.125	3
i1.15	217.474	-1.0083272457	7.062919	7.063382	-18.967195	0.125	3
i1.15	218.51012	-1.0044797659	7.063382	7.062314	-18.869233	0.125	3
i1.15	219.54623	-1.0281556845	7.062314	7.063216	-18.768092	0.125	3
i1.15	220.58237	-1.0042802095	7.063216	7.062749	-18.673709	0.125	3
i1.15	221.61848	-1.0108319521	7.062749	7.061791	-18.56191	0.125	3
i1.15	222.65462	-1.0073575974	7.061791	7.060919	-18.482362	0.125	3
i1.15	223.69073	-1.0113704205	7.060919	7.061329	-18.378678	0.125	3
i1.15	224.72685	-1.0137012005	7.061329	7.060688	-18.277401	0.125	3
i1.15	225.76297	-1.0207939148	7.060688	7.060662	-18.16936	0.125	3
i1.15	226.7991	1.0162014961	7.060662	7.060322	-18.080013	0.125	3
i1.16	187.49951	-0.9901278019	7.060043	7.060043	-17.972586	0.2	3
i1.16	188.5079	-0.9854064584	7.060043	7.060709	-18.199324	0.2	3
i1.16	189.5163	-0.9819051027	7.060709	7.061018	-18.292892	0.2	3
i1.16	190.52469	-0.9727602601	7.061018	7.061517	-18.389682	0.2	3
i1.16	191.53308	-0.9814674258	7.061517	7.061354	-18.48578	0.2	3
i1.16	192.54147	-0.9791229367	7.061354	7.061899	-18.593951	0.2	3
i1.16	193.54987	-1.0070474148	7.061899	7.061647	-18.689652	0.2	3
i1.16	194.55826	-1.0076415539	7.061647	7.062244	-18.776758	0.2	3
i1.16	195.56665	-0.9941897988	7.062244	7.063379	-18.871462	0.2	3
i1.16	196.57504	-0.9883164167	7.063379	7.062042	-18.971977	0.2	3
i1.16	197.58344	-0.9916794896	7.062042	7.062701	-19.061148	0.2	3
i1.16	198.59183	-0.9798714519	7.062701	7.063318	-19.173837	0.2	3
i1.16	199.60022	-0.9988746643	7.063318	7.064362	-19.273583	0.2	3
i1.16	200.60861	-0.9687411189	7.064362	7.064411	-19.367527	0.2	3
i1.16	201.617	-0.9758769274	7.064411	7.063564	-19.45533	0.2	3
i1.16	202.6254	-0.9978433251	7.063564	7.066088	-19.558548	0.2	3
i1.16	203.63379	-0.9818223715	7.066088	7.064613	-19.653048	0.2	3
i1.16	204.64218	-0.9778807759	7.064613	7.064332	-19.74826	0.2	3
i1.16	205.65057	-0.9725469947	7.064332	7.065994	-19.837527	0.2	3
i1.16	206.65897	-1.0053478479	7.065994	7.067768	-19.939913	0.2	3
i1.16	207.66736	-0.9880259633	7.067768	7.066056	-19.909513	0.2	3
i1.16	208.67575	-0.9751686454	7.066056	7.066942	-19.823801	0.2	3
i1.16	209.68414	-1.0076723099	7.066942	7.064384	-19.719376	0.2	3
i1.16	210.69254	-0.9770724773	7.064384	7.064649	-19.620706	0.2	3
i1.16	211.70094	-0.992713809	7.064649	7.065387	-19.515113	0.2	3
i1.16	212.70932	-0.9908092022	7.065387	7.063849	-19.431495	0.2	3
i1.16	213.71773	-0.9810014367	7.063849	7.063254	-19.332673	0.2	3
i1.16	214.72612	-1.0004928112	7.063254	7.064015	-19.236498	0.2	3
i1.16	215.73451	-0.9775570035	7.064015	7.063007	-19.132177	0.2	3
i1.16	216.7429	-0.9917523265	7.063007	7.063699	-19.040562	0.2	3
i1.16	217.7513	-0.9752229452	7.063699	7.062921	-18.939764	0.2	3
i1.16	218.75969	-0.9735827446	7.062921	7.061858	-18.843154	0.2	3
i1.16	219.76808	-1.0026056767	7.061858	7.061777	-18.746421	0.2	3
i1.16	220.77647	-0.994089365	7.061777	7.063097	-18.65095	0.2	3
i1.16	221.78487	-0.9986453652	7.063097	7.062007	-18.559352	0.2	3
i1.16	222.79326	-0.9928433299	7.062007	7.061357	-18.456779	0.2	3
i1.16	223.80165	-0.978715241	7.061357	7.061173	-18.368987	0.2	3
i1.16	224.81004	-0.9717043638	7.061173	7.060936	-18.268196	0.2	3
i1.16	225.81844	-0.981403172	7.060936	7.060702	-18.169892	0.2	3
i1.16	226.82683	0.9851635098	7.060702	7.060298	-18.077986	0.2	3
i1.17	186.1959	-1.0002324581	7.060047	7.060047	-17.97014	0.275	3
i1.17	187.2369	-1.0189334154	7.060047	7.060270	-18.080033	0.275	3
i1.17	188.27788	-1.011115551	7.060270	7.061000	-18.181646	0.275	3
i1.17	189.31885	-1.0191358328	7.061000	7.060731	-18.275248	0.275	3
i1.17	190.35983	-1.0256128311	7.060731	7.061073	-18.378736	0.275	3
i1.17	191.40082	-1.0373136997	7.061073	7.061491	-18.472596	0.275	3
i1.17	192.4418	-1.0163036585	7.061491	7.061564	-18.575439	0.275	3
i1.17	193.48279	-1.0335729122	7.061564	7.062378	-18.675956	0.275	3
i1.17	194.52377	-1.0042544603	7.062378	7.061726	-18.771408	0.275	3
i1.17	195.56476	-1.032412529	7.061726	7.063515	-18.88586	0.275	3
i1.17	196.60574	-1.0237790346	7.063515	7.062762	-18.975669	0.275	3
i1.17	197.64671	-1.0208966732	7.062762	7.062773	-19.077519	0.275	3
i1.17	198.6877	-1.0273518562	7.062773	7.063689	-19.178336	0.275	3
i1.17	199.72868	-1.0059629679	7.063689	7.063977	-19.283228	0.275	3
i1.17	200.76967	-1.0218930244	7.063977	7.065305	-19.377765	0.275	3
i1.17	201.81065	-1.0224064589	7.065305	7.063065	-19.475202	0.275	3
i1.17	202.85164	-1.0151582956	7.063065	7.064639	-19.572125	0.275	3
i1.17	203.89261	-1.0214182138	7.064639	7.066810	-19.674175	0.275	3
i1.17	204.9336	-1.0198792219	7.066810	7.066785	-19.788284	0.275	3
i1.17	205.97458	-1.0343151093	7.066785	7.066678	-19.876748	0.275	3
i1.17	207.01556	-1.036534071	7.066678	7.066387	-19.971069	0.275	3
i1.17	208.05655	-1.0253196955	7.066387	7.067369	-19.872831	0.275	3
i1.17	209.09753	-1.0064041615	7.067369	7.065885	-19.771635	0.275	3
i1.17	210.13852	-1.0184134245	7.065885	7.067249	-19.674366	0.275	3
i1.17	211.1795	-1.0145317316	7.067249	7.065028	-19.579021	0.275	3
i1.17	212.22047	-1.0288516283	7.065028	7.064257	-19.472281	0.275	3
i1.17	213.26146	-1.0128829479	7.064257	7.064172	-19.37115	0.275	3
i1.17	214.30244	-1.0210852623	7.064172	7.063722	-19.27268	0.275	3
i1.17	215.34343	-1.0022007227	7.063722	7.064216	-19.171897	0.275	3
i1.17	216.38441	-1.0269941092	7.064216	7.064383	-19.074398	0.275	3
i1.17	217.42538	-1.0345112085	7.064383	7.062898	-18.971232	0.275	3
i1.17	218.46637	-1.0362108946	7.062898	7.062795	-18.878294	0.275	3
i1.17	219.50735	-1.0401358604	7.062795	7.062727	-18.780414	0.275	3
i1.17	220.54834	-1.0173925161	7.062727	7.062089	-18.674619	0.275	3
i1.17	221.58932	-1.0137617588	7.062089	7.062077	-18.566277	0.275	3
i1.17	222.63031	-1.0388408899	7.062077	7.062297	-18.480507	0.275	3
i1.17	223.6713	-1.0063972473	7.062297	7.061340	-18.375339	0.275	3
i1.17	224.71228	-1.0268946886	7.061340	7.061218	-18.276143	0.275	3
i1.17	225.75325	-1.01032269	7.061218	7.060684	-18.174176	0.275	3
i1.17	226.79424	1.031484127	7.060684	7.060375	-18.080303	0.275	3
i1.10	377.8684	-0.9850388169	7.070043	7.070043	-13.978281	-0.25	3
i1.10	378.8759	-0.97821486	7.070043	7.070611	-13.742719	-0.25	3
i1.10	379.88336	-0.9826207161	7.070611	7.070864	-13.64537	-0.25	3
i1.10	380.89084	-0.9970974326	7.070864	7.071255	-13.563061	-0.25	3
i1.10	381.89835	-0.9780783057	7.071255	7.071719	-13.455034	-0.25	3
i1.10	382.90582	-0.9662678838	7.071719	7.071728	-13.365363	-0.25	3
i1.10	383.9133	-0.9839525223	7.071728	7.072449	-13.261309	-0.25	3
i1.10	384.92078	-0.97119838	7.072449	7.071781	-13.161602	-0.25	3
i1.10	385.92825	-0.9942246675	7.071781	7.073404	-13.074016	-0.25	3
i1.10	386.93573	-1.0060319901	7.073404	7.073421	-12.965782	-0.25	3
i1.10	387.9432	-1.0008939505	7.073421	7.073003	-12.880533	-0.25	3
i1.10	388.95068	-0.9714218974	7.073003	7.072831	-12.783379	-0.25	3
i1.10	389.95816	-0.9933612943	7.072831	7.075161	-12.687724	-0.25	3
i1.10	390.96564	-1.0049136877	7.075161	7.073277	-12.58367	-0.25	3
i1.10	391.97314	-0.9931952953	7.073277	7.075407	-12.490094	-0.25	3
i1.10	392.98062	-0.9862886071	7.075407	7.073458	-12.393446	-0.25	3
i1.10	393.9881	-0.975846231	7.073458	7.073409	-12.296026	-0.25	3
i1.10	394.99557	-0.9990374446	7.073409	7.074990	-12.202758	-0.25	3
i1.10	396.00305	-0.9741365314	7.074990	7.075237	-12.104904	-0.25	3
i1.10	397.01053	-0.9735292792	7.075237	7.078059	-12.006952	-0.25	3
i1.10	398.018	-0.9766175747	7.078059	7.077413	-12.039176	-0.25	3
i1.10	399.02548	-0.9794626236	7.077413	7.077165	-12.140498	-0.25	3
i1.10	400.03296	-0.9854172468	7.077165	7.074374	-12.245348	-0.25	3
i1.10	401.04047	-0.9758780003	7.074374	7.076751	-12.333185	-0.25	3
i1.10	402.04794	-0.9915736318	7.076751	7.075618	-12.428606	-0.25	3
i1.10	403.05542	-0.984079957	7.075618	7.074513	-12.524501	-0.25	3
i1.10	404.0629	-0.9680277705	7.074513	7.073937	-12.631272	-0.25	3
i1.10	405.07037	-0.9950244427	7.073937	7.073527	-12.715278	-0.25	3
i1.10	406.07785	-0.9995605946	7.073527	7.073224	-12.81452	-0.25	3
i1.10	407.08533	-0.976447165	7.073224	7.072425	-12.907917	-0.25	3
i1.10	408.0928	-1.0039476156	7.072425	7.072362	-13.008695	-0.25	3
i1.10	409.10028	-0.9674128294	7.072362	7.072410	-13.098918	-0.25	3
i1.10	410.1078	-0.9805569649	7.072410	7.073144	-13.193206	-0.25	3
i1.10	411.11526	-0.9663955569	7.073144	7.071655	-13.288977	-0.25	3
i1.10	412.12274	-0.9890486002	7.071655	7.072492	-13.391724	-0.25	3
i1.10	413.13022	-0.9830532074	7.072492	7.071513	-13.491845	-0.25	3
i1.10	414.1377	-1.0041134357	7.071513	7.071145	-13.588884	-0.25	3
i1.10	415.14517	-0.9782232046	7.071145	7.070859	-13.673204	-0.25	3
i1.10	416.15265	-1.0069087744	7.070859	7.070558	-13.788199	-0.25	3
i1.10	417.16013	0.965921104	7.070558	7.070205	-13.880939	-0.25	3
i1.11	377.2624	-1.0078850985	7.070047	7.070047	-13.975013	-0.175	3
i1.11	378.28503	-1.0135076046	7.070047	7.070700	-13.804522	-0.175	3
i1.11	379.30768	-0.99154526	7.070700	7.070858	-13.704942	-0.175	3
i1.11	380.3303	-0.9963877201	7.070858	7.071160	-13.612612	-0.175	3
i1.11	381.35294	-1.014257431	7.071160	7.071617	-13.502101	-0.175	3
i1.11	382.37555	-0.9854297638	7.071617	7.071929	-13.412255	-0.175	3
i1.11	383.3982	-1.0059863329	7.071929	7.072578	-13.307652	-0.175	3
i1.11	384.4208	-1.0125454664	7.072578	7.072185	-13.216891	-0.175	3
i1.11	385.44345	-1.0012959242	7.072185	7.072730	-13.114889	-0.175	3
i1.11	386.46606	-0.9847583771	7.072730	7.072923	-13.015736	-0.175	3
i1.11	387.4887	-1.0210703611	7.072923	7.072542	-12.917905	-0.175	3
i1.11	388.51135	-1.0046753883	7.072542	7.072864	-12.827883	-0.175	3
i1.11	389.53397	-1.0108677149	7.072864	7.074425	-12.719359	-0.175	3
i1.11	390.5566	-0.9821862578	7.074425	7.073690	-12.624663	-0.175	3
i1.11	391.57922	-1.0032119751	7.073690	7.075420	-12.533129	-0.175	3
i1.11	392.60187	-1.0030244589	7.075420	7.074358	-12.434244	-0.175	3
i1.11	393.62448	-0.99350667	7.074358	7.074672	-12.337272	-0.175	3
i1.11	394.64713	-1.0127466917	7.074672	7.074500	-12.236307	-0.175	3
i1.11	395.66974	-1.0051993132	7.074500	7.076973	-12.13282	-0.175	3
i1.11	396.69238	-0.9861754179	7.076973	7.077452	-12.041864	-0.175	3
i1.11	397.71503	-0.9926601648	7.077452	7.075810	-12.017593	-0.175	3
i1.11	398.73764	-0.9846290946	7.075810	7.076116	-12.10663	-0.175	3
i1.11	399.76025	-0.998196125	7.076116	7.074723	-12.201497	-0.175	3
i1.11	400.7829	-0.9843903184	7.074723	7.075520	-12.306679	-0.175	3
i1.11	401.80554	-1.000141263	7.075520	7.074790	-12.406388	-0.175	3
i1.11	402.82816	-0.9826686978	7.074790	7.074178	-12.500551	-0.175	3
i1.11	403.8508	-1.0169146061	7.074178	7.073177	-12.597391	-0.175	3
i1.11	404.8734	-1.0074802637	7.073177	7.073356	-12.695026	-0.175	3
i1.11	405.89606	-1.0171724558	7.073356	7.072935	-12.804192	-0.175	3
i1.11	406.91867	-1.0003789663	7.072935	7.073387	-12.885984	-0.175	3
i1.11	407.9413	-0.9968547821	7.073387	7.072917	-12.985977	-0.175	3
i1.11	408.96393	-0.9810828567	7.072917	7.072765	-13.093522	-0.175	3
i1.11	409.98657	-1.0207086802	7.072765	7.072063	-13.188432	-0.175	3
i1.11	411.00922	-0.9976255298	7.072063	7.073206	-13.28667	-0.175	3
i1.11	412.03183	-1.0034698248	7.073206	7.071809	-13.382385	-0.175	3
i1.11	413.05447	-1.0096307993	7.071809	7.071925	-13.483882	-0.175	3
i1.11	414.0771	-1.0008445978	7.071925	7.071480	-13.58764	-0.175	3
i1.11	415.09973	-1.0178787708	7.071480	7.071091	-13.675875	-0.175	3
i1.11	416.12234	-0.9872750044	7.071091	7.070682	-13.773562	-0.175	3
i1.11	417.145	1.021530509	7.070682	7.070491	-13.877592	-0.175	3
i1.12	377.32544	-1.0176563263	7.070039	7.070039	-13.979612	-0.1	3
i1.12	378.3465	-1.0059437752	7.070039	7.070637	-13.803093	-0.1	3
i1.12	379.36755	-1.0044457912	7.070637	7.070868	-13.700009	-0.1	3
i1.12	380.3886	-1.0035395622	7.070868	7.071312	-13.608418	-0.1	3
i1.12	381.40967	-1.003890872	7.071312	7.071383	-13.5001	-0.1	3
i1.12	382.43073	-1.0071336031	7.071383	7.071472	-13.413426	-0.1	3
i1.12	383.45178	-1.0061526299	7.071472	7.072145	-13.312138	-0.1	3
i1.12	384.47284	-1.0034235716	7.072145	7.072741	-13.20983	-0.1	3
i1.12	385.49387	-0.9898939133	7.072741	7.072508	-13.117449	-0.1	3
i1.12	386.51492	-0.987380743	7.072508	7.071818	-13.01346	-0.1	3
i1.12	387.53598	-0.9939422607	7.071818	7.073217	-12.921429	-0.1	3
i1.12	388.55704	-0.9824594855	7.073217	7.071849	-12.817724	-0.1	3
i1.12	389.5781	-1.0141541958	7.071849	7.072823	-12.710593	-0.1	3
i1.12	390.59915	-0.9957979321	7.072823	7.073926	-12.623473	-0.1	3
i1.12	391.6202	-1.0000536442	7.073926	7.075368	-12.523051	-0.1	3
i1.12	392.64127	-1.0135370493	7.075368	7.075109	-12.426479	-0.1	3
i1.12	393.66232	-1.0147866011	7.075109	7.075316	-12.322783	-0.1	3
i1.12	394.68335	-0.9805929661	7.075316	7.075528	-12.229118	-0.1	3
i1.12	395.7044	-1.020619154	7.075528	7.074323	-12.132859	-0.1	3
i1.12	396.72546	-0.989423871	7.074323	7.076879	-12.032224	-0.1	3
i1.12	397.74652	-0.990755558	7.076879	7.076204	-12.014023	-0.1	3
i1.12	398.76758	-1.0134409666	7.076204	7.073161	-12.111286	-0.1	3
i1.12	399.78864	-1.007060647	7.073161	7.075141	-12.208354	-0.1	3
i1.12	400.8097	-1.0187664032	7.075141	7.073536	-12.307361	-0.1	3
i1.12	401.83075	-0.9945491552	7.073536	7.073278	-12.403261	-0.1	3
i1.12	402.8518	-1.0094419718	7.073278	7.074527	-12.506354	-0.1	3
i1.12	403.87286	-1.0006252527	7.074527	7.074518	-12.604589	-0.1	3
i1.12	404.89392	-0.987800777	7.074518	7.073685	-12.692722	-0.1	3
i1.12	405.91495	-1.01072824	7.073685	7.072658	-12.799746	-0.1	3
i1.12	406.936	-1.0183008909	7.072658	7.073312	-12.893939	-0.1	3
i1.12	407.95706	-0.9970027208	7.073312	7.073345	-12.993107	-0.1	3
i1.12	408.97812	-1.0188463926	7.073345	7.072315	-13.095212	-0.1	3
i1.12	409.99918	-0.9905572534	7.072315	7.072178	-13.185593	-0.1	3
i1.12	411.02023	-1.0066759586	7.072178	7.072452	-13.282625	-0.1	3
i1.12	412.0413	-1.0149959326	7.072452	7.071339	-13.386059	-0.1	3
i1.12	413.06235	-1.0044392347	7.071339	7.072083	-13.480569	-0.1	3
i1.12	414.0834	-0.9857294559	7.072083	7.071093	-13.583149	-0.1	3
i1.12	415.10446	-1.0093300343	7.071093	7.070811	-13.675822	-0.1	3
i1.12	416.1255	-0.9997243285	7.070811	7.070576	-13.782057	-0.1	3
i1.12	417.14655	1.0197097063	7.070576	7.070321	-13.882941	-0.1	3
i1.13	377.51425	-1.0030565262	7.070042	7.070042	-13.981616	-0.025	3
i1.13	378.53058	-1.0138927698	7.070042	7.070329	-13.771805	-0.025	3
i1.13	379.5469	-0.9980979562	7.070329	7.070581	-13.675413	-0.025	3
i1.13	380.56326	-0.9803453684	7.070581	7.070915	-13.590797	-0.025	3
i1.13	381.5796	-0.9953590631	7.070915	7.071255	-13.491438	-0.025	3
i1.13	382.59592	-0.9882885218	7.071255	7.072080	-13.39568	-0.025	3
i1.13	383.61224	-0.9778655171	7.072080	7.071982	-13.292907	-0.025	3
i1.13	384.6286	-1.0012208223	7.071982	7.071932	-13.200479	-0.025	3
i1.13	385.64493	-0.9905868173	7.071932	7.072498	-13.103196	-0.025	3
i1.13	386.66125	-0.9990095496	7.072498	7.073299	-12.998259	-0.025	3
i1.13	387.67758	-0.9840424657	7.073299	7.073191	-12.898498	-0.025	3
i1.13	388.69394	-0.9994860291	7.073191	7.073507	-12.799226	-0.025	3
i1.13	389.71027	-0.9753478765	7.073507	7.074197	-12.696531	-0.025	3
i1.13	390.7266	-1.0115686655	7.074197	7.073769	-12.608449	-0.025	3
i1.13	391.74292	-1.0108796358	7.073769	7.076042	-12.505488	-0.025	3
i1.13	392.75928	-0.9821759462	7.076042	7.075232	-12.408462	-0.025	3
i1.13	393.7756	-1.0024262667	7.075232	7.075269	-12.312258	-0.025	3
i1.13	394.79193	-0.9793165922	7.075269	7.074278	-12.227236	-0.025	3
i1.13	395.80826	-0.9893504381	7.074278	7.075309	-12.120593	-0.025	3
i1.13	396.8246	-0.99883008	7.075309	7.077027	-12.017832	-0.025	3
i1.13	397.84094	-0.9995957017	7.077027	7.076989	-12.023898	-0.025	3
i1.13	398.85727	-0.9837960005	7.076989	7.074318	-12.124849	-0.025	3
i1.13	399.8736	-0.980144918	7.074318	7.073984	-12.218646	-0.025	3
i1.13	400.88992	-1.009955883	7.073984	7.075963	-12.321605	-0.025	3
i1.13	401.90628	-0.9776699543	7.075963	7.072597	-12.422136	-0.025	3
i1.13	402.9226	-0.9785916805	7.072597	7.075114	-12.518134	-0.025	3
i1.13	403.93893	-1.0027859211	7.075114	7.073835	-12.611158	-0.025	3
i1.13	404.95526	-1.0086889267	7.073835	7.072824	-12.699639	-0.025	3
i1.13	405.97162	-0.9882039428	7.072824	7.072962	-12.80683	-0.025	3
i1.13	406.98795	-0.9965208173	7.072962	7.073199	-12.889699	-0.025	3
i1.13	408.00427	-1.0080336332	7.073199	7.073301	-12.994035	-0.025	3
i1.13	409.0206	-0.9920932651	7.073301	7.071694	-13.094453	-0.025	3
i1.13	410.03693	-1.0074146986	7.071694	7.072410	-13.196358	-0.025	3
i1.13	411.05328	-0.9862363935	7.072410	7.072180	-13.292397	-0.025	3
i1.13	412.0696	-1.0137065649	7.072180	7.072001	-13.38969	-0.025	3
i1.13	413.08594	-1.0123101473	7.072001	7.071662	-13.479362	-0.025	3
i1.13	414.1023	-0.987303853	7.071662	7.071376	-13.593072	-0.025	3
i1.13	415.11862	-0.9784978628	7.071376	7.070526	-13.680061	-0.025	3
i1.13	416.13495	-0.9878017902	7.070526	7.070446	-13.778171	-0.025	3
i1.13	417.15128	1.0035309792	7.070446	7.070227	-13.884104	-0.025	3
i1.14	377.44736	-1.0049902201	7.070053	7.070053	-13.977379	0.05	3
i1.14	378.46536	-0.9836186171	7.070053	7.070537	-13.78521	0.05	3
i1.14	379.48337	-1.0045827627	7.070537	7.070851	-13.68315	0.05	3
i1.14	380.50137	-1.0037120581	7.070851	7.071318	-13.597334	0.05	3
i1.14	381.51938	-0.988958478	7.071318	7.071395	-13.493881	0.05	3
i1.14	382.53738	-0.9812280536	7.071395	7.071926	-13.390281	0.05	3
i1.14	383.55542	-0.9823035002	7.071926	7.071754	-13.297345	0.05	3
i1.14	384.57343	-1.0122592449	7.071754	7.071941	-13.201423	0.05	3
i1.14	385.59143	-0.9802654982	7.071941	7.072092	-13.1007	0.05	3
i1.14	386.60944	-0.9926990867	7.072092	7.072999	-13.00691	0.05	3
i1.14	387.62744	-0.9988458753	7.072999	7.072224	-12.903999	0.05	3
i1.14	388.64545	-0.9972755909	7.072224	7.074465	-12.805124	0.05	3
i1.14	389.66345	-1.0057759285	7.074465	7.074198	-12.707708	0.05	3
i1.14	390.68146	-1.012345314	7.074198	7.073446	-12.601114	0.05	3
i1.14	391.69946	-1.0000752211	7.073446	7.074103	-12.510279	0.05	3
i1.14	392.71747	-0.9874498844	7.074103	7.074888	-12.414866	0.05	3
i1.14	393.73547	-1.0028291941	7.074888	7.074587	-12.313117	0.05	3
i1.14	394.75348	-0.9864697456	7.074587	7.073717	-12.226587	0.05	3
i1.14	395.77148	-1.0076440573	7.073717	7.075974	-12.123906	0.05	3
i1.14	396.7895	-1.014767766	7.075974	7.076660	-12.027797	0.05	3
i1.14	397.8075	-0.9817532897	7.076660	7.077152	-12.025999	0.05	3
i1.14	398.8255	-0.9768126607	7.077152	7.074792	-12.12095	0.05	3
i1.14	399.8435	-1.0006949902	7.074792	7.075990	-12.215993	0.05	3
i1.14	400.8615	-0.9794512987	7.075990	7.076220	-12.317031	0.05	3
i1.14	401.87952	-0.9877646565	7.076220	7.078030	-12.414175	0.05	3
i1.14	402.89752	-0.9928616285	7.078030	7.075498	-12.510022	0.05	3
i1.14	403.91553	-1.0051475763	7.075498	7.073065	-12.595729	0.05	3
i1.14	404.93353	-1.0027515888	7.073065	7.073154	-12.705865	0.05	3
i1.14	405.95154	-0.9897372127	7.073154	7.072579	-12.800622	0.05	3
i1.14	406.96954	-0.979434669	7.072579	7.072123	-12.905156	0.05	3
i1.14	407.98755	-1.016392827	7.072123	7.073137	-12.991059	0.05	3
i1.14	409.00555	-0.9871737361	7.073137	7.071822	-13.089451	0.05	3
i1.14	410.02356	-1.0072102547	7.071822	7.072063	-13.202	0.05	3
i1.14	411.04156	-0.9823521972	7.072063	7.071627	-13.288045	0.05	3
i1.14	412.05957	-1.0175858736	7.071627	7.072125	-13.391058	0.05	3
i1.14	413.07758	-0.9833065271	7.072125	7.071459	-13.480118	0.05	3
i1.14	414.09558	-0.9903888106	7.071459	7.071500	-13.59089	0.05	3
i1.14	415.1136	-0.9772002697	7.071500	7.071187	-13.676925	0.05	3
i1.14	416.1316	-0.9907714725	7.071187	7.070550	-13.776334	0.05	3
i1.14	417.1496	0.9968153238	7.070550	7.070414	-13.872393	0.05	3
i1.15	377.91888	-0.9698473215	7.070045	7.070045	-13.968829	0.125	3
i1.15	378.92508	-0.9833354354	7.070045	7.070721	-13.746806	0.125	3
i1.15	379.9313	-0.9835978746	7.070721	7.071188	-13.644088	0.125	3
i1.15	380.93753	-0.9778916836	7.071188	7.071249	-13.56157	0.125	3
i1.15	381.94376	-1.0043671131	7.071249	7.071488	-13.455069	0.125	3
i1.15	382.94995	-1.0020120144	7.071488	7.071431	-13.360772	0.125	3
i1.15	383.95618	-1.0030397177	7.071431	7.072076	-13.259784	0.125	3
i1.15	384.9624	-0.9880844355	7.072076	7.072967	-13.160848	0.125	3
i1.15	385.96863	-0.9824512601	7.072967	7.072450	-13.06821	0.125	3
i1.15	386.97482	-0.9926006198	7.072450	7.072809	-12.973391	0.125	3
i1.15	387.98105	-0.9663448334	7.072809	7.074298	-12.86821	0.125	3
i1.15	388.98727	-0.9921439886	7.074298	7.074932	-12.777941	0.125	3
i1.15	389.9935	-0.9884546995	7.074932	7.074492	-12.685873	0.125	3
i1.15	390.99973	-0.9700875878	7.074492	7.074633	-12.590503	0.125	3
i1.15	392.00592	-0.9788221717	7.074633	7.074456	-12.487217	0.125	3
i1.15	393.01215	-0.9874896407	7.074456	7.075411	-12.380747	0.125	3
i1.15	394.01837	-0.9803147316	7.075411	7.075168	-12.29068	0.125	3
i1.15	395.0246	-0.9661204815	7.075168	7.075030	-12.189645	0.125	3
i1.15	396.0308	-0.9734161496	7.075030	7.073772	-12.096462	0.125	3
i1.15	397.03702	-0.9767307043	7.073772	7.074946	-12.005704	0.125	3
i1.15	398.04324	-0.9930706024	7.074946	7.075977	-12.043915	0.125	3
i1.15	399.04947	-0.9914110899	7.075977	7.076181	-12.133571	0.125	3
i1.15	400.05566	-0.9694072604	7.076181	7.074978	-12.236819	0.125	3
i1.15	401.0619	-0.9832178354	7.074978	7.075829	-12.325939	0.125	3
i1.15	402.0681	-0.9917366505	7.075829	7.072924	-12.428592	0.125	3
i1.15	403.07434	-0.9659327269	7.072924	7.074255	-12.52627	0.125	3
i1.15	404.08057	-1.0022759438	7.074255	7.075106	-12.621395	0.125	3
i1.15	405.08676	-0.9893983603	7.075106	7.074986	-12.715946	0.125	3
i1.15	406.093	-1.0006498098	7.074986	7.074264	-12.817302	0.125	3
i1.15	407.0992	-0.9752553701	7.074264	7.072330	-12.914202	0.125	3
i1.15	408.10544	-0.982191205	7.072330	7.072884	-13.009169	0.125	3
i1.15	409.11163	-0.9993944168	7.072884	7.072748	-13.102226	0.125	3
i1.15	410.11786	-0.9879036546	7.072748	7.072436	-13.208451	0.125	3
i1.15	411.12408	-0.97529006	7.072436	7.072493	-13.297535	0.125	3
i1.15	412.1303	-0.9748808146	7.072493	7.071856	-13.39453	0.125	3
i1.15	413.13654	-0.9665605426	7.071856	7.071436	-13.482649	0.125	3
i1.15	414.14273	-0.9691441059	7.071436	7.071432	-13.588215	0.125	3
i1.15	415.14896	-0.9970829487	7.071432	7.070695	-13.678351	0.125	3
i1.15	416.15518	-0.9981685877	7.070695	7.070421	-13.781988	0.125	3
i1.15	417.1614	0.9690032005	7.070421	7.070275	-13.875154	0.125	3
i1.16	376.82596	-1.0158683062	7.070044	7.070044	-13.983261	0.2	3
i1.16	377.85953	-1.0190322399	7.070044	7.070626	-13.856268	0.2	3
i1.16	378.89307	-1.0036650896	7.070626	7.071102	-13.74795	0.2	3
i1.16	379.9266	-1.0214508772	7.071102	7.071272	-13.654292	0.2	3
i1.16	380.96014	-1.0281381607	7.071272	7.071059	-13.547242	0.2	3
i1.16	381.99368	-1.0101011992	7.071059	7.071970	-13.442946	0.2	3
i1.16	383.02722	-1.0046721697	7.071970	7.072901	-13.343677	0.2	3
i1.16	384.06076	-0.9975560308	7.072901	7.072354	-13.251197	0.2	3
i1.16	385.0943	-1.0033333302	7.072354	7.072086	-13.150671	0.2	3
i1.16	386.12784	-1.0038831234	7.072086	7.072587	-13.040957	0.2	3
i1.16	387.16138	-0.9983149767	7.072587	7.074265	-12.955706	0.2	3
i1.16	388.19492	-1.0333664417	7.074265	7.073063	-12.860496	0.2	3
i1.16	389.22845	-1.0259022713	7.073063	7.073793	-12.753545	0.2	3
i1.16	390.262	-1.0183975697	7.073793	7.075005	-12.656049	0.2	3
i1.16	391.29553	-0.9956045747	7.075005	7.074012	-12.553052	0.2	3
i1.16	392.3291	-1.0128422976	7.074012	7.074383	-12.451401	0.2	3
i1.16	393.36264	-0.9996934533	7.074383	7.075176	-12.359688	0.2	3
i1.16	394.39618	-1.0195496082	7.075176	7.076161	-12.255688	0.2	3
i1.16	395.42972	-1.027412653	7.076161	7.076565	-12.163465	0.2	3
i1.16	396.46326	-1.0089037418	7.076565	7.077096	-12.06864	0.2	3
i1.16	397.4968	-1.0010390282	7.077096	7.074154	-11.991028	0.2	3
i1.16	398.53033	-1.0242959261	7.074154	7.075446	-12.08393	0.2	3
i1.16	399.56387	-1.0053311586	7.075446	7.074386	-12.190727	0.2	3
i1.16	400.5974	-1.018309474	7.074386	7.074931	-12.291367	0.2	3
i1.16	401.63095	-1.0094094276	7.074931	7.073822	-12.391252	0.2	3
i1.16	402.6645	-1.0138759613	7.073822	7.073952	-12.479782	0.2	3
i1.16	403.69803	-1.0024212599	7.073952	7.074093	-12.589526	0.2	3
i1.16	404.73157	-1.0055019855	7.074093	7.071843	-12.695962	0.2	3
i1.16	405.7651	-1.0179619789	7.071843	7.075248	-12.787241	0.2	3
i1.16	406.79868	-1.0305405855	7.075248	7.073359	-12.876181	0.2	3
i1.16	407.8322	-0.998421967	7.073359	7.072808	-12.981643	0.2	3
i1.16	408.86575	-1.0179790258	7.072808	7.072477	-13.078993	0.2	3
i1.16	409.8993	-1.0011621714	7.072477	7.071435	-13.183635	0.2	3
i1.16	410.93283	-1.0075784922	7.071435	7.071765	-13.283885	0.2	3
i1.16	411.96637	-1.0093218088	7.071765	7.071890	-13.372078	0.2	3
i1.16	412.9999	-1.0198147297	7.071890	7.071240	-13.49	0.2	3
i1.16	414.03345	-1.0236023664	7.071240	7.071140	-13.574761	0.2	3
i1.16	415.067	-1.0054790974	7.071140	7.071059	-13.671564	0.2	3
i1.16	416.10052	-0.9993074536	7.071059	7.070636	-13.780209	0.2	3
i1.16	417.13406	1.0248372555	7.070636	7.070417	-13.878292	0.2	3
i1.17	377.98495	-0.9871589541	7.070062	7.070062	-13.975545	0.275	3
i1.17	378.98953	-0.9852132201	7.070062	7.070749	-13.730987	0.275	3
i1.17	379.9941	-0.9898179173	7.070749	7.071016	-13.643814	0.275	3
i1.17	380.99866	-0.9934891462	7.071016	7.071254	-13.544088	0.275	3
i1.17	382.00323	-0.967594564	7.071254	7.071823	-13.449948	0.275	3
i1.17	383.0078	-0.9851054549	7.071823	7.072069	-13.347026	0.275	3
i1.17	384.01236	-0.9649211764	7.072069	7.072581	-13.259437	0.275	3
i1.17	385.01694	-0.9738128781	7.072581	7.073223	-13.148181	0.275	3
i1.17	386.02148	-0.9837465882	7.073223	7.073042	-13.068872	0.275	3
i1.17	387.02606	-0.977891624	7.073042	7.072280	-12.953648	0.275	3
i1.17	388.03064	-0.9863099456	7.072280	7.074412	-12.871664	0.275	3
i1.17	389.0352	-0.99726367	7.074412	7.072774	-12.774647	0.275	3
i1.17	390.03976	-0.9826273918	7.072774	7.073317	-12.676614	0.275	3
i1.17	391.04434	-0.971434474	7.073317	7.073472	-12.584987	0.275	3
i1.17	392.0489	-0.9716545343	7.073472	7.073627	-12.480112	0.275	3
i1.17	393.05347	-0.9961391687	7.073627	7.076517	-12.385199	0.275	3
i1.17	394.058	-0.9890836477	7.076517	7.074605	-12.29821	0.275	3
i1.17	395.0626	-0.9818808436	7.074605	7.076506	-12.193269	0.275	3
i1.17	396.06717	-0.9840567112	7.076506	7.074360	-12.099318	0.275	3
i1.17	397.07172	-0.9647338986	7.074360	7.077449	-12.00224	0.275	3
i1.17	398.0763	-0.9888470173	7.077449	7.075298	-12.048802	0.275	3
i1.17	399.08087	-0.9667181373	7.075298	7.075127	-12.142222	0.275	3
i1.17	400.08542	-0.9919563532	7.075127	7.075561	-12.244003	0.275	3
i1.17	401.09	-0.9737765193	7.075561	7.075415	-12.340321	0.275	3
i1.17	402.09454	-0.976539731	7.075415	7.074200	-12.430113	0.275	3
i1.17	403.09912	-0.9780109525	7.074200	7.073470	-12.52982	0.275	3
i1.17	404.1037	-0.9755473137	7.073470	7.073950	-12.625704	0.275	3
i1.17	405.10825	-0.9816176891	7.073950	7.072596	-12.723515	0.275	3
i1.17	406.11282	-0.9861444831	7.072596	7.074135	-12.815026	0.275	3
i1.17	407.1174	-1.0017031431	7.074135	7.073284	-12.911183	0.275	3
i1.17	408.12195	-1.0043137074	7.073284	7.073210	-13.00666	0.275	3
i1.17	409.12653	-0.9774000645	7.073210	7.072484	-13.114852	0.275	3
i1.17	410.1311	-0.9962799549	7.072484	7.072927	-13.200505	0.275	3
i1.17	411.13565	-0.9934561849	7.072927	7.071640	-13.299919	0.275	3
i1.17	412.14023	-0.9844807386	7.071640	7.071294	-13.388361	0.275	3
i1.17	413.14478	-0.9676097035	7.071294	7.071527	-13.48829	0.275	3
i1.17	414.14935	-0.9990743995	7.071527	7.071366	-13.595247	0.275	3
i1.17	415.15393	-0.9772276282	7.071366	7.070989	-13.686099	0.275	3
i1.17	416.15848	-0.9834960699	7.070989	7.070731	-13.781558	0.275	3
i1.17	417.16306	1.0006535053	7.070731	7.070347	-13.874796	0.275	3
i1.20	1.0388056	-2.6291148663	6.030066	6.030066	-15.985213	-0.25	3
i1.20	3.71704	-2.616638422	6.030066	6.030376	-15.859152	-0.25	3
i1.20	6.3952856	-2.5810599327	6.030376	6.030590	-15.778065	-0.25	3
i1.20	9.07352	-2.6112518311	6.030590	6.030709	-15.674873	-0.25	3
i1.20	11.751764	-2.6000299454	6.030709	6.030860	-15.568144	-0.25	3
i1.20	14.429999	-2.5958030224	6.030860	6.031525	-15.462851	-0.25	3
i1.20	17.108244	-2.6355557442	6.031525	6.031898	-15.371796	-0.25	3
i1.20	19.78648	-2.6340272427	6.031898	6.031215	-15.274519	-0.25	3
i1.20	22.464725	-2.6388392448	6.031215	6.031643	-15.164863	-0.25	3
i1.20	25.142958	-2.606374979	6.031643	6.032520	-15.073184	-0.25	3
i1.20	27.821205	-2.5980696678	6.032520	6.033017	-14.963991	-0.25	3
i1.20	30.49944	-2.5917131901	6.033017	6.032883	-14.880969	-0.25	3
i1.20	33.177685	-2.6236224174	6.032883	6.033138	-14.777319	-0.25	3
i1.20	35.85592	-2.6154391766	6.033138	6.034090	-14.686919	-0.25	3
i1.20	38.53416	-2.6206562519	6.034090	6.033176	-14.577273	-0.25	3
i1.20	41.2124	-2.5947890282	6.033176	6.034510	-14.480053	-0.25	3
i1.20	43.890633	-2.6244294643	6.034510	6.033871	-14.378554	-0.25	3
i1.20	46.568874	-2.5758321285	6.033871	6.034396	-14.26539	-0.25	3
i1.20	49.24711	-2.6393585205	6.034396	6.035225	-14.178797	-0.25	3
i1.20	51.925358	-2.6013913155	6.035225	6.034367	-14.083289	-0.25	3
i1.20	54.603592	-2.6371393204	6.034367	6.035655	-13.977463	-0.25	3
i1.20	57.281837	-2.5899913311	6.035655	6.034940	-14.078042	-0.25	3
i1.20	59.96007	-2.6771607399	6.034940	6.032976	-14.170227	-0.25	3
i1.20	62.638317	-2.6748461723	6.032976	6.034197	-14.277638	-0.25	3
i1.20	65.31655	-2.640815258	6.034197	6.034134	-14.372627	-0.25	3
i1.20	67.9948	-2.6009807587	6.034134	6.034626	-14.486666	-0.25	3
i1.20	70.67303	-2.6209492683	6.034626	6.033985	-14.582343	-0.25	3
i1.20	73.35127	-2.6049592495	6.033985	6.033297	-14.679631	-0.25	3
i1.20	76.02951	-2.6750538349	6.033297	6.032972	-14.773472	-0.25	3
i1.20	78.707756	-2.6347284317	6.032972	6.032859	-14.875948	-0.25	3
i1.20	81.385994	-2.6634273529	6.032859	6.033273	-14.98424	-0.25	3
i1.20	84.06423	-2.6626110077	6.033273	6.032798	-15.072101	-0.25	3
i1.20	86.74247	-2.6479446888	6.032798	6.031933	-15.166177	-0.25	3
i1.20	89.420715	-2.6180460453	6.031933	6.031835	-15.274588	-0.25	3
i1.20	92.098946	-2.6528408527	6.031835	6.031816	-15.377326	-0.25	3
i1.20	94.77719	-2.6572525501	6.031816	6.031209	-15.48308	-0.25	3
i1.20	97.45544	-2.6141469479	6.031209	6.030867	-15.573142	-0.25	3
i1.20	100.133675	-2.571873188	6.030867	6.031027	-15.67456	-0.25	3
i1.20	102.81191	-2.6079072952	6.031027	6.030609	-15.772216	-0.25	3
i1.20	105.49015	2.6607673168	6.030609	6.030285	-15.879907	-0.25	3
i1.21	1.0157537	-2.6223506927	6.030040	6.030040	-15.977688	-0.2	3
i1.21	3.6945672	-2.6621222496	6.030040	6.030453	-15.872357	-0.2	3
i1.21	6.373391	-2.6340985298	6.030453	6.030413	-15.774062	-0.2	3
i1.21	9.052204	-2.6574482918	6.030413	6.030607	-15.680632	-0.2	3
i1.21	11.731017	-2.6105439663	6.030607	6.030941	-15.580935	-0.2	3
i1.21	14.409831	-2.6494529247	6.030941	6.031524	-15.473125	-0.2	3
i1.21	17.088655	-2.6643760204	6.031524	6.031789	-15.375702	-0.2	3
i1.21	19.767467	-2.5973801613	6.031789	6.031538	-15.283103	-0.2	3
i1.21	22.446281	-2.6332449913	6.031538	6.032028	-15.174457	-0.2	3
i1.21	25.125093	-2.6782019138	6.032028	6.032725	-15.064488	-0.2	3
i1.21	27.803917	-2.6397659779	6.032725	6.032209	-14.981358	-0.2	3
i1.21	30.48273	-2.6450572014	6.032209	6.032020	-14.87983	-0.2	3
i1.21	33.161545	-2.6008663177	6.032020	6.033320	-14.77364	-0.2	3
i1.21	35.84036	-2.6701207161	6.033320	6.032841	-14.6867	-0.2	3
i1.21	38.51918	-2.5982255936	6.032841	6.033387	-14.574844	-0.2	3
i1.21	41.197994	-2.6416704655	6.033387	6.032541	-14.478512	-0.2	3
i1.21	43.87681	-2.6703381538	6.032541	6.034450	-14.36496	-0.2	3
i1.21	46.555622	-2.6466267109	6.034450	6.034254	-14.277149	-0.2	3
i1.21	49.234447	-2.5787277222	6.034254	6.034758	-14.171566	-0.2	3
i1.21	51.913258	-2.5719459057	6.034758	6.033932	-14.085439	-0.2	3
i1.21	54.592068	-2.6308193207	6.033932	6.035850	-13.981288	-0.2	3
i1.21	57.270885	-2.5731272697	6.035850	6.035978	-14.073795	-0.2	3
i1.21	59.949707	-2.5733935833	6.035978	6.032478	-14.175497	-0.2	3
i1.21	62.62852	-2.6719536781	6.032478	6.034680	-14.283412	-0.2	3
i1.21	65.307335	-2.6269946098	6.034680	6.034509	-14.37155	-0.2	3
i1.21	67.98615	-2.6616590023	6.034509	6.033574	-14.475471	-0.2	3
i1.21	70.66497	-2.5981194973	6.033574	6.033180	-14.576919	-0.2	3
i1.21	73.34378	-2.6323785782	6.033180	6.032438	-14.676908	-0.2	3
i1.21	76.0226	-2.6473612785	6.032438	6.032876	-14.769774	-0.2	3
i1.21	78.70141	-2.6588482857	6.032876	6.032649	-14.87668	-0.2	3
i1.21	81.38023	-2.6119089127	6.032649	6.031645	-14.978692	-0.2	3
i1.21	84.059044	-2.6004261971	6.031645	6.031709	-15.071624	-0.2	3
i1.21	86.73786	-2.5886671543	6.031709	6.031677	-15.171296	-0.2	3
i1.21	89.41667	-2.6707723141	6.031677	6.031724	-15.27891	-0.2	3
i1.21	92.095505	-2.6195259094	6.031724	6.031863	-15.371919	-0.2	3
i1.21	94.774315	-2.6459987164	6.031863	6.031295	-15.473977	-0.2	3
i1.21	97.453125	-2.5775785446	6.031295	6.031209	-15.57465	-0.2	3
i1.21	100.131935	-2.6667003632	6.031209	6.030850	-15.675164	-0.2	3
i1.21	102.81077	-2.5803067684	6.030850	6.030461	-15.785973	-0.2	3
i1.21	105.48958	2.6231579781	6.030461	6.030317	-15.871245	-0.2	3
i1.22	1.0544307	-2.5993762016	6.030036	6.030036	-15.974957	-0.15	3
i1.22	3.7322795	-2.5768275261	6.030036	6.030323	-15.872824	-0.15	3
i1.22	6.410128	-2.5970952511	6.030323	6.030500	-15.773788	-0.15	3
i1.22	9.087976	-2.5871114731	6.030500	6.030487	-15.670457	-0.15	3
i1.22	11.765825	-2.6382601261	6.030487	6.031214	-15.575272	-0.15	3
i1.22	14.443674	-2.5862495899	6.031214	6.030471	-15.46742	-0.15	3
i1.22	17.121523	-2.5905358791	6.030471	6.031911	-15.380285	-0.15	3
i1.22	19.799372	-2.6719410419	6.031911	6.031884	-15.276812	-0.15	3
i1.22	22.477219	-2.6512098312	6.031884	6.032040	-15.168597	-0.15	3
i1.22	25.15507	-2.6147706509	6.032040	6.032640	-15.066027	-0.15	3
i1.22	27.832918	-2.6386620998	6.032640	6.032283	-14.974107	-0.15	3
i1.22	30.510765	-2.6603047848	6.032283	6.032521	-14.875524	-0.15	3
i1.22	33.188614	-2.5837221146	6.032521	6.032291	-14.772409	-0.15	3
i1.22	35.866463	-2.602186203	6.032291	6.033352	-14.667845	-0.15	3
i1.22	38.54431	-2.6416668892	6.033352	6.033918	-14.571746	-0.15	3
i1.22	41.22216	-2.6581423283	6.033918	6.032708	-14.475399	-0.15	3
i1.22	43.90001	-2.6476209164	6.032708	6.034699	-14.377527	-0.15	3
i1.22	46.577858	-2.5763139725	6.034699	6.035184	-14.275143	-0.15	3
i1.22	49.255707	-2.6445119381	6.035184	6.034218	-14.175898	-0.15	3
i1.22	51.933556	-2.6237595081	6.034218	6.034335	-14.076782	-0.15	3
i1.22	54.611404	-2.6328542233	6.034335	6.034696	-13.970536	-0.15	3
i1.22	57.28925	-2.651465416	6.034696	6.035192	-14.079209	-0.15	3
i1.22	59.967102	-2.6531591415	6.035192	6.033932	-14.185776	-0.15	3
i1.22	62.64495	-2.577706337	6.033932	6.034274	-14.275438	-0.15	3
i1.22	65.3228	-2.6045572758	6.034274	6.034141	-14.378645	-0.15	3
i1.22	68.00065	-2.5936105251	6.034141	6.034161	-14.468548	-0.15	3
i1.22	70.678505	-2.6474659443	6.034161	6.032348	-14.566441	-0.15	3
i1.22	73.35635	-2.657766819	6.032348	6.033900	-14.684383	-0.15	3
i1.22	76.0342	-2.6569223404	6.033900	6.034498	-14.779658	-0.15	3
i1.22	78.71205	-2.5949540138	6.034498	6.033441	-14.875313	-0.15	3
i1.22	81.3899	-2.5788152218	6.033441	6.032527	-14.974402	-0.15	3
i1.22	84.06775	-2.6736547947	6.032527	6.032648	-15.069735	-0.15	3
i1.22	86.7456	-2.6765139103	6.032648	6.031529	-15.17547	-0.15	3
i1.22	89.42345	-2.635559082	6.031529	6.031673	-15.272626	-0.15	3
i1.22	92.101295	-2.6469755173	6.031673	6.031537	-15.370546	-0.15	3
i1.22	94.779144	-2.6042933464	6.031537	6.031210	-15.465071	-0.15	3
i1.22	97.457	-2.5945060253	6.031210	6.030989	-15.580463	-0.15	3
i1.22	100.13485	-2.623765707	6.030989	6.030844	-15.675969	-0.15	3
i1.22	102.81269	-2.6711666584	6.030844	6.030614	-15.771781	-0.15	3
i1.22	105.49054	2.5768487453	6.030614	6.030243	-15.880234	-0.15	3
i1.23	1.0828625	-2.5857536793	6.030044	6.030044	-15.974167	-0.1	3
i1.23	3.760004	-2.6435499191	6.030044	6.030420	-15.873539	-0.1	3
i1.23	6.437145	-2.6625599861	6.030420	6.030410	-15.777259	-0.1	3
i1.23	9.114286	-2.5812118053	6.030410	6.030742	-15.670712	-0.1	3
i1.23	11.791417	-2.6232032776	6.030742	6.030869	-15.575399	-0.1	3
i1.23	14.468558	-2.6357960701	6.030869	6.031232	-15.472589	-0.1	3
i1.23	17.1457	-2.5784409046	6.031232	6.031150	-15.36925	-0.1	3
i1.23	19.82283	-2.6436655521	6.031150	6.031109	-15.268507	-0.1	3
i1.23	22.499971	-2.6140141487	6.031109	6.031387	-15.169768	-0.1	3
i1.23	25.177113	-2.6063659191	6.031387	6.032417	-15.07532	-0.1	3
i1.23	27.854244	-2.6194579601	6.032417	6.032515	-14.970493	-0.1	3
i1.23	30.531385	-2.6716024876	6.032515	6.033476	-14.874655	-0.1	3
i1.23	33.208527	-2.6321091652	6.033476	6.033392	-14.779631	-0.1	3
i1.23	35.88566	-2.5856056213	6.033392	6.033395	-14.67493	-0.1	3
i1.23	38.5628	-2.5828235149	6.033395	6.033904	-14.582263	-0.1	3
i1.23	41.23994	-2.6343972683	6.033904	6.033253	-14.471119	-0.1	3
i1.23	43.917072	-2.6137521267	6.033253	6.033116	-14.367449	-0.1	3
i1.23	46.59421	-2.6698899269	6.033116	6.034215	-14.26458	-0.1	3
i1.23	49.27135	-2.5786657333	6.034215	6.032937	-14.174922	-0.1	3
i1.23	51.948494	-2.6256895065	6.032937	6.034032	-14.079023	-0.1	3
i1.23	54.62563	-2.634365797	6.034032	6.036622	-13.980486	-0.1	3
i1.23	57.30277	-2.6002640724	6.036622	6.033547	-14.080571	-0.1	3
i1.23	59.979908	-2.5748336315	6.033547	6.036617	-14.180528	-0.1	3
i1.23	62.657036	-2.6255097389	6.036617	6.033419	-14.268992	-0.1	3
i1.23	65.334175	-2.6352035999	6.033419	6.033617	-14.380075	-0.1	3
i1.23	68.01132	-2.6552817822	6.033617	6.034472	-14.475162	-0.1	3
i1.23	70.68845	-2.6521677971	6.034472	6.032668	-14.581756	-0.1	3
i1.23	73.36559	-2.63276124	6.032668	6.034269	-14.674568	-0.1	3
i1.23	76.04273	-2.6768126488	6.034269	6.033839	-14.77979	-0.1	3
i1.23	78.71987	-2.6104362011	6.033839	6.031747	-14.872675	-0.1	3
i1.23	81.39701	-2.6337425709	6.031747	6.031115	-14.974224	-0.1	3
i1.23	84.07415	-2.6155302525	6.031115	6.031924	-15.067405	-0.1	3
i1.23	86.751274	-2.6276404858	6.031924	6.031843	-15.181298	-0.1	3
i1.23	89.42842	-2.6741502285	6.031843	6.031697	-15.278167	-0.1	3
i1.23	92.10556	-2.6718206406	6.031697	6.031616	-15.370977	-0.1	3
i1.23	94.7827	-2.6534116268	6.031616	6.031107	-15.479966	-0.1	3
i1.23	97.45984	-2.6056387424	6.031107	6.030806	-15.578424	-0.1	3
i1.23	100.13697	-2.6216967106	6.030806	6.030698	-15.676572	-0.1	3
i1.23	102.81412	-2.6754930019	6.030698	6.030466	-15.77312	-0.1	3
i1.23	105.49124	2.6404075623	6.030466	6.030302	-15.884717	-0.1	3
i1.24	1.0582888	-2.6701960564	6.030058	6.030058	-15.968931	-0.05	3
i1.24	3.736041	-2.622402668	6.030058	6.030359	-15.8758	-0.05	3
i1.24	6.4137936	-2.6008319855	6.030359	6.030574	-15.771683	-0.05	3
i1.24	9.091545	-2.6541473866	6.030574	6.030955	-15.677359	-0.05	3
i1.24	11.769298	-2.5781626701	6.030955	6.031190	-15.568523	-0.05	3
i1.24	14.447049	-2.609197855	6.031190	6.031514	-15.46171	-0.05	3
i1.24	17.124804	-2.5778462887	6.031514	6.031244	-15.370864	-0.05	3
i1.24	19.802555	-2.6557598114	6.031244	6.032002	-15.277606	-0.05	3
i1.24	22.480305	-2.621243	6.032002	6.031496	-15.178401	-0.05	3
i1.24	25.158058	-2.6537804604	6.031496	6.032199	-15.08048	-0.05	3
i1.24	27.835812	-2.6742444038	6.032199	6.031716	-14.982037	-0.05	3
i1.24	30.513563	-2.6699411869	6.031716	6.033627	-14.869927	-0.05	3
i1.24	33.191315	-2.6719925404	6.033627	6.033072	-14.775533	-0.05	3
i1.24	35.869076	-2.6535727978	6.033072	6.033541	-14.67017	-0.05	3
i1.24	38.54683	-2.6684408188	6.033541	6.033640	-14.566815	-0.05	3
i1.24	41.224583	-2.6119418144	6.033640	6.033113	-14.466567	-0.05	3
i1.24	43.902336	-2.6049151421	6.033113	6.033340	-14.370673	-0.05	3
i1.24	46.58009	-2.5924389362	6.033340	6.033500	-14.264914	-0.05	3
i1.24	49.257843	-2.6298274994	6.033500	6.035212	-14.168409	-0.05	3
i1.24	51.93559	-2.6494748592	6.035212	6.033930	-14.079217	-0.05	3
i1.24	54.613342	-2.6769542694	6.033930	6.034352	-13.968516	-0.05	3
i1.24	57.291096	-2.6091945171	6.034352	6.035154	-14.083646	-0.05	3
i1.24	59.96885	-2.5942926407	6.035154	6.034989	-14.176254	-0.05	3
i1.24	62.646603	-2.6468169689	6.034989	6.032822	-14.26463	-0.05	3
i1.24	65.32435	-2.631934166	6.032822	6.033965	-14.371486	-0.05	3
i1.24	68.002106	-2.6321179867	6.033965	6.033980	-14.471418	-0.05	3
i1.24	70.679855	-2.6204676628	6.033980	6.034353	-14.574542	-0.05	3
i1.24	73.35761	-2.6516208649	6.034353	6.032621	-14.670988	-0.05	3
i1.24	76.03536	-2.6631002426	6.032621	6.032669	-14.778918	-0.05	3
i1.24	78.71311	-2.6678595543	6.032669	6.032920	-14.873393	-0.05	3
i1.24	81.39087	-2.6559560299	6.032920	6.032587	-14.975654	-0.05	3
i1.24	84.06862	-2.5995502472	6.032587	6.032452	-15.074862	-0.05	3
i1.24	86.74637	-2.6002864838	6.032452	6.032264	-15.176446	-0.05	3
i1.24	89.42412	-2.6695840359	6.032264	6.031508	-15.275183	-0.05	3
i1.24	92.101875	-2.5762240887	6.031508	6.031478	-15.378389	-0.05	3
i1.24	94.779625	-2.6318433285	6.031478	6.031349	-15.470249	-0.05	3
i1.24	97.457375	-2.5812368393	6.031349	6.030967	-15.573631	-0.05	3
i1.24	100.13513	-2.6271176338	6.030967	6.030919	-15.67536	-0.05	3
i1.24	102.81288	-2.6172437668	6.030919	6.030506	-15.77932	-0.05	3
i1.24	105.49064	2.6092944145	6.030506	6.030321	-15.882555	-0.05	3
i1.25	1.0209514	-2.6607620716	6.030047	6.030047	-15.97367	0.0	3
i1.25	3.699636	-2.6200113297	6.030047	6.030291	-15.876623	0.0	3
i1.25	6.37832	-2.6570351124	6.030291	6.030421	-15.776907	0.0	3
i1.25	9.057005	-2.6354236603	6.030421	6.030571	-15.674521	0.0	3
i1.25	11.73569	-2.5937092304	6.030571	6.031081	-15.579567	0.0	3
i1.25	14.414375	-2.6716926098	6.031081	6.031568	-15.471029	0.0	3
i1.25	17.093058	-2.6171307564	6.031568	6.031208	-15.378882	0.0	3
i1.25	19.771755	-2.6236844063	6.031208	6.032433	-15.27747	0.0	3
i1.25	22.45044	-2.6493778229	6.032433	6.031585	-15.1706	0.0	3
i1.25	25.129122	-2.6214828491	6.031585	6.032126	-15.068142	0.0	3
i1.25	27.807808	-2.6715593338	6.032126	6.032886	-14.964727	0.0	3
i1.25	30.486492	-2.5981607437	6.032886	6.032335	-14.866003	0.0	3
i1.25	33.165176	-2.6446638107	6.032335	6.032641	-14.774201	0.0	3
i1.25	35.84386	-2.5733625889	6.032641	6.033063	-14.666526	0.0	3
i1.25	38.52255	-2.5964851379	6.033063	6.032856	-14.571534	0.0	3
i1.25	41.20124	-2.6449034214	6.032856	6.034134	-14.473435	0.0	3
i1.25	43.879925	-2.6764900684	6.034134	6.033337	-14.370107	0.0	3
i1.25	46.55861	-2.6354999542	6.033337	6.033612	-14.268796	0.0	3
i1.25	49.237293	-2.6001477242	6.033612	6.032975	-14.177802	0.0	3
i1.25	51.91598	-2.5795176029	6.032975	6.035383	-14.062993	0.0	3
i1.25	54.594666	-2.6531033516	6.035383	6.037169	-13.971829	0.0	3
i1.25	57.27335	-2.5880639553	6.037169	6.035360	-14.076296	0.0	3
i1.25	59.95204	-2.5904040337	6.035360	6.035164	-14.176361	0.0	3
i1.25	62.63073	-2.590436697	6.035164	6.034882	-14.274373	0.0	3
i1.25	65.30941	-2.6577782631	6.034882	6.034650	-14.378899	0.0	3
i1.25	67.9881	-2.5947706699	6.034650	6.033512	-14.468704	0.0	3
i1.25	70.66678	-2.6186802387	6.033512	6.034254	-14.570368	0.0	3
i1.25	73.34547	-2.6223728657	6.034254	6.033086	-14.673946	0.0	3
i1.25	76.024155	-2.607904911	6.033086	6.033047	-14.763939	0.0	3
i1.25	78.70284	-2.6411168575	6.033047	6.032907	-14.874731	0.0	3
i1.25	81.38153	-2.5718479156	6.032907	6.032309	-14.973661	0.0	3
i1.25	84.06022	-2.5985145569	6.032309	6.032820	-15.080573	0.0	3
i1.25	86.7389	-2.6060807705	6.032820	6.032285	-15.169792	0.0	3
i1.25	89.41759	-2.6446003914	6.032285	6.031861	-15.27195	0.0	3
i1.25	92.09627	-2.6781308651	6.031861	6.031730	-15.37404	0.0	3
i1.25	94.774956	-2.6202464104	6.031730	6.031479	-15.479532	0.0	3
i1.25	97.453636	-2.6569640636	6.031479	6.031018	-15.57655	0.0	3
i1.25	100.13233	-2.5824563503	6.031018	6.030582	-15.676857	0.0	3
i1.25	102.81102	-2.6773073673	6.030582	6.030484	-15.768372	0.0	3
i1.25	105.4897	2.5886657238	6.030484	6.030270	-15.877112	0.0	3
i1.26	1.0246916	-2.6601362228	6.030048	6.030048	-15.971519	0.05	3
i1.26	3.7032905	-2.64295578	6.030048	6.030164	-15.87648	0.05	3
i1.26	6.3818784	-2.6176674366	6.030164	6.030427	-15.777644	0.05	3
i1.26	9.060477	-2.578327179	6.030427	6.030770	-15.676254	0.05	3
i1.26	11.739065	-2.6405332088	6.030770	6.031149	-15.573041	0.05	3
i1.26	14.417653	-2.6216835976	6.031149	6.031634	-15.477763	0.05	3
i1.26	17.096252	-2.5928986073	6.031634	6.031489	-15.38174	0.05	3
i1.26	19.774841	-2.6782715321	6.031489	6.032169	-15.269784	0.05	3
i1.26	22.453428	-2.6442523003	6.032169	6.032568	-15.168872	0.05	3
i1.26	25.132027	-2.5932862759	6.032568	6.032346	-15.076502	0.05	3
i1.26	27.810616	-2.6235804558	6.032346	6.031961	-14.968819	0.05	3
i1.26	30.489216	-2.5815513134	6.031961	6.033260	-14.871854	0.05	3
i1.26	33.1678	-2.5928752422	6.033260	6.032077	-14.770625	0.05	3
i1.26	35.84639	-2.6772100925	6.032077	6.033487	-14.674578	0.05	3
i1.26	38.52499	-2.6302762032	6.033487	6.033899	-14.570666	0.05	3
i1.26	41.20358	-2.6432154179	6.033899	6.034335	-14.479996	0.05	3
i1.26	43.882175	-2.6008405685	6.034335	6.035084	-14.370084	0.05	3
i1.26	46.56077	-2.5764284134	6.035084	6.034161	-14.27148	0.05	3
i1.26	49.239353	-2.6091082096	6.034161	6.035662	-14.166173	0.05	3
i1.26	51.917953	-2.6691401005	6.035662	6.034707	-14.080796	0.05	3
i1.26	54.59654	-2.6416072845	6.034707	6.035375	-13.971974	0.05	3
i1.26	57.275135	-2.6641085148	6.035375	6.035966	-14.079836	0.05	3
i1.26	59.953728	-2.6160643101	6.035966	6.035453	-14.176897	0.05	3
i1.26	62.632313	-2.6182262897	6.035453	6.033516	-14.269076	0.05	3
i1.26	65.31091	-2.6709566116	6.033516	6.034389	-14.370931	0.05	3
i1.26	67.9895	-2.5955884457	6.034389	6.035088	-14.462399	0.05	3
i1.26	70.6681	-2.6364295483	6.035088	6.033381	-14.573481	0.05	3
i1.26	73.34669	-2.5935561657	6.033381	6.032962	-14.670165	0.05	3
i1.26	76.025276	-2.6672482491	6.032962	6.033686	-14.776418	0.05	3
i1.26	78.70388	-2.5804567337	6.033686	6.032809	-14.878398	0.05	3
i1.26	81.38246	-2.6547751427	6.032809	6.031867	-14.98451	0.05	3
i1.26	84.06105	-2.6552839279	6.031867	6.032342	-15.066333	0.05	3
i1.26	86.73965	-2.6737642288	6.032342	6.031670	-15.170636	0.05	3
i1.26	89.41824	-2.6083505154	6.031670	6.032595	-15.280277	0.05	3
i1.26	92.09684	-2.6455442905	6.032595	6.031216	-15.367939	0.05	3
i1.26	94.77543	-2.5760056973	6.031216	6.031259	-15.472567	0.05	3
i1.26	97.45401	-2.5857326984	6.031259	6.031079	-15.569626	0.05	3
i1.26	100.13261	-2.6263825893	6.031079	6.030878	-15.680281	0.05	3
i1.26	102.8112	-2.6236357689	6.030878	6.030612	-15.785172	0.05	3
i1.26	105.4898	2.6639535427	6.030612	6.030241	-15.874522	0.05	3
i1.27	1.099495	-2.6499724388	6.030044	6.030044	-15.981226	0.1	3
i1.27	3.7762187	-2.6576607227	6.030044	6.030210	-15.877681	0.1	3
i1.27	6.452942	-2.5702188015	6.030210	6.030376	-15.768432	0.1	3
i1.27	9.129665	-2.6582324505	6.030376	6.030898	-15.677444	0.1	3
i1.27	11.806389	-2.6375434399	6.030898	6.030899	-15.566977	0.1	3
i1.27	14.483102	-2.6215391159	6.030899	6.031015	-15.464932	0.1	3
i1.27	17.159826	-2.6590025425	6.031015	6.031425	-15.374454	0.1	3
i1.27	19.836548	-2.6667468548	6.031425	6.032717	-15.271457	0.1	3
i1.27	22.513271	-2.5949428082	6.032717	6.031809	-15.178193	0.1	3
i1.27	25.189995	-2.6539423466	6.031809	6.032237	-15.074267	0.1	3
i1.27	27.866718	-2.5836331844	6.032237	6.031980	-14.974718	0.1	3
i1.27	30.543442	-2.6329081059	6.031980	6.033451	-14.870964	0.1	3
i1.27	33.220165	-2.6631627083	6.033451	6.034010	-14.775326	0.1	3
i1.27	35.89689	-2.6754045486	6.034010	6.033978	-14.673932	0.1	3
i1.27	38.573612	-2.6141161919	6.033978	6.033230	-14.57594	0.1	3
i1.27	41.250324	-2.6288752556	6.033230	6.033388	-14.470327	0.1	3
i1.27	43.927048	-2.6749603748	6.033388	6.034031	-14.375837	0.1	3
i1.27	46.603775	-2.5701229572	6.034031	6.035651	-14.273035	0.1	3
i1.27	49.280495	-2.6626489162	6.035651	6.035189	-14.170667	0.1	3
i1.27	51.957222	-2.5950496197	6.035189	6.035661	-14.079585	0.1	3
i1.27	54.63394	-2.6766593456	6.035661	6.035624	-13.980407	0.1	3
i1.27	57.31066	-2.629850626	6.035624	6.033619	-14.081283	0.1	3
i1.27	59.98739	-2.6397411823	6.033619	6.034365	-14.187265	0.1	3
i1.27	62.66411	-2.6753282547	6.034365	6.033331	-14.279588	0.1	3
i1.27	65.340836	-2.6754689217	6.033331	6.032767	-14.372529	0.1	3
i1.27	68.01755	-2.6730940342	6.032767	6.034373	-14.482074	0.1	3
i1.27	70.694275	-2.6148905754	6.034373	6.033567	-14.580414	0.1	3
i1.27	73.370995	-2.6731877327	6.033567	6.034131	-14.674096	0.1	3
i1.27	76.04772	-2.6514775753	6.034131	6.033214	-14.786425	0.1	3
i1.27	78.72444	-2.6452407837	6.033214	6.032389	-14.86962	0.1	3
i1.27	81.40116	-2.6516990662	6.032389	6.031807	-14.985024	0.1	3
i1.27	84.07789	-2.5910770893	6.031807	6.031613	-15.082924	0.1	3
i1.27	86.75461	-2.6660604477	6.031613	6.032093	-15.184666	0.1	3
i1.27	89.431335	-2.6298251152	6.032093	6.031218	-15.281653	0.1	3
i1.27	92.10806	-2.5857334137	6.031218	6.031331	-15.380744	0.1	3
i1.27	94.78477	-2.6646745205	6.031331	6.031776	-15.479588	0.1	3
i1.27	97.461494	-2.6253843307	6.031776	6.031005	-15.571609	0.1	3
i1.27	100.13822	-2.6633856297	6.031005	6.031166	-15.674238	0.1	3
i1.27	102.81495	-2.6496539116	6.031166	6.030466	-15.771135	0.1	3
i1.27	105.49166	2.5719280243	6.030466	6.030337	-15.87254	0.1	3
i1.28	1.0075232	-2.5915813446	6.030044	6.030044	-15.972965	0.15	3
i1.28	3.6865509	-2.6369028091	6.030044	6.030424	-15.884515	0.15	3
i1.28	6.365567	-2.5809388161	6.030424	6.030429	-15.768591	0.15	3
i1.28	9.044595	-2.6018152237	6.030429	6.030766	-15.674553	0.15	3
i1.28	11.723613	-2.6183922291	6.030766	6.031079	-15.574369	0.15	3
i1.28	14.402639	-2.5785708427	6.031079	6.030894	-15.473656	0.15	3
i1.28	17.081656	-2.6751451492	6.030894	6.031587	-15.379893	0.15	3
i1.28	19.760674	-2.6051852703	6.031587	6.031973	-15.277347	0.15	3
i1.28	22.4397	-2.620896101	6.031973	6.031923	-15.170969	0.15	3
i1.28	25.118717	-2.6100564003	6.031923	6.032922	-15.075407	0.15	3
i1.28	27.797745	-2.6192674637	6.032922	6.032431	-14.969468	0.15	3
i1.28	30.476763	-2.6555716991	6.032431	6.033731	-14.875005	0.15	3
i1.28	33.15579	-2.628027916	6.033731	6.032689	-14.775415	0.15	3
i1.28	35.834805	-2.6588046551	6.032689	6.032970	-14.677418	0.15	3
i1.28	38.513836	-2.5953862667	6.032970	6.033159	-14.569316	0.15	3
i1.28	41.19285	-2.6194860935	6.033159	6.033210	-14.475776	0.15	3
i1.28	43.87187	-2.6537117958	6.033210	6.035433	-14.386315	0.15	3
i1.28	46.55089	-2.5866310596	6.035433	6.033369	-14.273565	0.15	3
i1.28	49.229916	-2.6682183743	6.033369	6.033074	-14.174626	0.15	3
i1.28	51.90894	-2.6103036404	6.033074	6.035345	-14.075709	0.15	3
i1.28	54.587955	-2.6232569218	6.035345	6.035311	-13.988936	0.15	3
i1.28	57.26698	-2.6680932045	6.035311	6.034576	-14.07749	0.15	3
i1.28	59.946003	-2.5861017704	6.034576	6.034499	-14.168389	0.15	3
i1.28	62.62502	-2.6461117268	6.034499	6.036722	-14.280426	0.15	3
i1.28	65.30405	-2.5813310146	6.036722	6.033943	-14.373509	0.15	3
i1.28	67.98306	-2.5801267624	6.033943	6.033162	-14.470613	0.15	3
i1.28	70.66209	-2.6625180244	6.033162	6.034428	-14.571298	0.15	3
i1.28	73.3411	-2.6479644775	6.034428	6.033012	-14.672919	0.15	3
i1.28	76.020134	-2.6768536568	6.033012	6.032874	-14.778115	0.15	3
i1.28	78.69915	-2.5976161957	6.032874	6.032958	-14.875444	0.15	3
i1.28	81.378174	-2.598606348	6.032958	6.033060	-14.976239	0.15	3
i1.28	84.05719	-2.6339230537	6.033060	6.032458	-15.069436	0.15	3
i1.28	86.73621	-2.5883352757	6.032458	6.031601	-15.172408	0.15	3
i1.28	89.41524	-2.5747961998	6.031601	6.031614	-15.275103	0.15	3
i1.28	92.09425	-2.6012744904	6.031614	6.031322	-15.371623	0.15	3
i1.28	94.77328	-2.644340992	6.031322	6.031439	-15.479983	0.15	3
i1.28	97.45229	-2.6293125153	6.031439	6.030795	-15.578999	0.15	3
i1.28	100.13133	-2.5978357792	6.030795	6.030602	-15.667624	0.15	3
i1.28	102.81035	-2.6742122173	6.030602	6.030627	-15.76805	0.15	3
i1.28	105.48937	2.6554481983	6.030627	6.030393	-15.877266	0.15	3
i1.29	1.066948	-2.6234796047	6.030069	6.030069	-15.97556	0.2	3
i1.29	3.7444751	-2.6239407063	6.030069	6.030308	-15.883217	0.2	3
i1.29	6.4220133	-2.6079926491	6.030308	6.030577	-15.770899	0.2	3
i1.29	9.099551	-2.5857827663	6.030577	6.030795	-15.666661	0.2	3
i1.29	11.777089	-2.6583786011	6.030795	6.031263	-15.578355	0.2	3
i1.29	14.454627	-2.5872244835	6.031263	6.031138	-15.474519	0.2	3
i1.29	17.132166	-2.621111393	6.031138	6.031653	-15.374736	0.2	3
i1.29	19.80969	-2.6526334286	6.031653	6.031650	-15.26281	0.2	3
i1.29	22.48723	-2.5763206482	6.031650	6.031844	-15.173884	0.2	3
i1.29	25.164768	-2.5798892975	6.031844	6.032026	-15.072481	0.2	3
i1.29	27.842304	-2.5747764111	6.032026	6.032524	-14.975058	0.2	3
i1.29	30.519844	-2.618721962	6.032524	6.032231	-14.869416	0.2	3
i1.29	33.197384	-2.581890583	6.032231	6.033542	-14.775293	0.2	3
i1.29	35.87491	-2.636480093	6.033542	6.033013	-14.674386	0.2	3
i1.29	38.55245	-2.5807077885	6.033013	6.032794	-14.565342	0.2	3
i1.29	41.229984	-2.577865839	6.032794	6.033439	-14.476981	0.2	3
i1.29	43.90752	-2.5935685635	6.033439	6.033229	-14.37255	0.2	3
i1.29	46.58506	-2.6473016739	6.033229	6.032906	-14.26441	0.2	3
i1.29	49.2626	-2.6765727997	6.032906	6.034192	-14.165315	0.2	3
i1.29	51.94013	-2.6495668888	6.034192	6.034771	-14.075718	0.2	3
i1.29	54.61766	-2.5901277065	6.034771	6.034529	-13.972857	0.2	3
i1.29	57.2952	-2.6011497974	6.034529	6.035121	-14.08344	0.2	3
i1.29	59.972736	-2.603774786	6.035121	6.035395	-14.170633	0.2	3
i1.29	62.650276	-2.5991504192	6.035395	6.033851	-14.271875	0.2	3
i1.29	65.32781	-2.5724811554	6.033851	6.034326	-14.370874	0.2	3
i1.29	68.00534	-2.6494641304	6.034326	6.034461	-14.475358	0.2	3
i1.29	70.68288	-2.677448988	6.034461	6.033049	-14.571673	0.2	3
i1.29	73.36041	-2.5746443272	6.033049	6.034110	-14.668817	0.2	3
i1.29	76.03796	-2.573921442	6.034110	6.033863	-14.775089	0.2	3
i1.29	78.71549	-2.6674101353	6.033863	6.033620	-14.872807	0.2	3
i1.29	81.393036	-2.6135983467	6.033620	6.032170	-14.973259	0.2	3
i1.29	84.07056	-2.5929584503	6.032170	6.032146	-15.070495	0.2	3
i1.29	86.7481	-2.5989897251	6.032146	6.032695	-15.163608	0.2	3
i1.29	89.42564	-2.5939831734	6.032695	6.031889	-15.28294	0.2	3
i1.29	92.10318	-2.6347668171	6.031889	6.031483	-15.377935	0.2	3
i1.29	94.78071	-2.5982706547	6.031483	6.031468	-15.472908	0.2	3
i1.29	97.458244	-2.5921528339	6.031468	6.031351	-15.580409	0.2	3
i1.29	100.13578	-2.5783998966	6.031351	6.030746	-15.673902	0.2	3
i1.29	102.81331	-2.6338899136	6.030746	6.030660	-15.774667	0.2	3
i1.29	105.49085	2.6188337803	6.030660	6.030349	-15.873089	0.2	3
i1.30	1.0028721	-2.6541352272	6.030047	6.030047	-15.960765	0.25	3
i1.30	3.6820173	-2.6665449142	6.030047	6.030263	-15.876594	0.25	3
i1.30	6.361152	-2.677113533	6.030263	6.030565	-15.778655	0.25	3
i1.30	9.040287	-2.6059641838	6.030565	6.030563	-15.683861	0.25	3
i1.30	11.719432	-2.6496679783	6.030563	6.031085	-15.584335	0.25	3
i1.30	14.398566	-2.6226940155	6.031085	6.031244	-15.480349	0.25	3
i1.30	17.077702	-2.5756242275	6.031244	6.031935	-15.368696	0.25	3
i1.30	19.756836	-2.6398639679	6.031935	6.031849	-15.288858	0.25	3
i1.30	22.435982	-2.6417074203	6.031849	6.031957	-15.171996	0.25	3
i1.30	25.115116	-2.6229617596	6.031957	6.032228	-15.0802	0.25	3
i1.30	27.79425	-2.6466004848	6.032228	6.032483	-14.978742	0.25	3
i1.30	30.473396	-2.6338427067	6.032483	6.032828	-14.878869	0.25	3
i1.30	33.15253	-2.6630692482	6.032828	6.032642	-14.774624	0.25	3
i1.30	35.831665	-2.6025032997	6.032642	6.033181	-14.674936	0.25	3
i1.30	38.5108	-2.6235826015	6.033181	6.033419	-14.567883	0.25	3
i1.30	41.189945	-2.6018178463	6.033419	6.033732	-14.476864	0.25	3
i1.30	43.869083	-2.5798370838	6.033732	6.034660	-14.374684	0.25	3
i1.30	46.548214	-2.6429748535	6.034660	6.034567	-14.269707	0.25	3
i1.30	49.22736	-2.581176281	6.034567	6.034905	-14.182216	0.25	3
i1.30	51.906498	-2.6258490086	6.034905	6.034354	-14.074441	0.25	3
i1.30	54.58563	-2.6341223717	6.034354	6.033936	-13.976393	0.25	3
i1.30	57.264763	-2.6384301186	6.033936	6.034815	-14.077813	0.25	3
i1.30	59.943913	-2.6157958508	6.034815	6.033718	-14.173453	0.25	3
i1.30	62.623043	-2.6120650768	6.033718	6.034314	-14.28287	0.25	3
i1.30	65.30218	-2.5721559525	6.034314	6.034397	-14.380881	0.25	3
i1.30	67.98132	-2.5790758133	6.034397	6.033638	-14.487908	0.25	3
i1.30	70.66046	-2.5880060196	6.033638	6.033537	-14.566943	0.25	3
i1.30	73.33959	-2.6698141098	6.033537	6.033031	-14.665922	0.25	3
i1.30	76.01874	-2.5850477219	6.033031	6.033644	-14.781872	0.25	3
i1.30	78.697876	-2.6723818779	6.033644	6.032349	-14.873629	0.25	3
i1.30	81.377014	-2.6587433815	6.032349	6.031501	-14.972071	0.25	3
i1.30	84.056145	-2.6012988091	6.031501	6.032394	-15.073116	0.25	3
i1.30	86.73529	-2.650885582	6.032394	6.031853	-15.167888	0.25	3
i1.30	89.41442	-2.6431736946	6.031853	6.031628	-15.278527	0.25	3
i1.30	92.09356	-2.5827949047	6.031628	6.031596	-15.374439	0.25	3
i1.30	94.772705	-2.5923922062	6.031596	6.031700	-15.472225	0.25	3
i1.30	97.451836	-2.6563272476	6.031700	6.030856	-15.577666	0.25	3
i1.30	100.130974	-2.6470417976	6.030856	6.030770	-15.673609	0.25	3
i1.30	102.81011	-2.6132013798	6.030770	6.030424	-15.769008	0.25	3
i1.30	105.48925	2.6774113178	6.030424	6.030266	-15.87225	0.25	3
i1.31	1.0049404	-2.628190279	6.030054	6.030054	-15.973272	0.3	3
i1.31	3.6840215	-2.6762835979	6.030054	6.030290	-15.871963	0.3	3
i1.31	6.363113	-2.6385211945	6.030290	6.030489	-15.774892	0.3	3
i1.31	9.042194	-2.6183242798	6.030489	6.030760	-15.677647	0.3	3
i1.31	11.721286	-2.597786665	6.030760	6.030856	-15.579096	0.3	3
i1.31	14.400368	-2.653188467	6.030856	6.031295	-15.479912	0.3	3
i1.31	17.079458	-2.6031343937	6.031295	6.031677	-15.381489	0.3	3
i1.31	19.758541	-2.6039812565	6.031677	6.031798	-15.261448	0.3	3
i1.31	22.437634	-2.6197907925	6.031798	6.031835	-15.174639	0.3	3
i1.31	25.116713	-2.5844814777	6.031835	6.032526	-15.081361	0.3	3
i1.31	27.795805	-2.607367754	6.032526	6.032392	-14.984058	0.3	3
i1.31	30.474886	-2.6137120724	6.032392	6.032575	-14.874294	0.3	3
i1.31	33.15398	-2.6573929787	6.032575	6.033052	-14.774399	0.3	3
i1.31	35.833057	-2.6053230762	6.033052	6.033861	-14.674636	0.3	3
i1.31	38.51215	-2.6167359352	6.033861	6.034272	-14.577171	0.3	3
i1.31	41.19123	-2.6304588318	6.034272	6.033231	-14.478827	0.3	3
i1.31	43.870323	-2.5740690231	6.033231	6.034129	-14.369457	0.3	3
i1.31	46.549408	-2.6141376495	6.034129	6.034951	-14.275897	0.3	3
i1.31	49.22849	-2.6581904888	6.034951	6.032525	-14.173521	0.3	3
i1.31	51.90758	-2.6556770802	6.032525	6.036383	-14.086007	0.3	3
i1.31	54.58666	-2.6756341457	6.036383	6.034042	-13.980431	0.3	3
i1.31	57.26575	-2.5761625767	6.034042	6.034771	-14.08377	0.3	3
i1.31	59.94483	-2.6396050453	6.034771	6.033828	-14.179559	0.3	3
i1.31	62.623924	-2.638856411	6.033828	6.035186	-14.267218	0.3	3
i1.31	65.30301	-2.660602808	6.035186	6.032606	-14.371948	0.3	3
i1.31	67.9821	-2.5731687546	6.032606	6.031973	-14.471748	0.3	3
i1.31	70.66118	-2.5899248123	6.031973	6.033343	-14.578215	0.3	3
i1.31	73.34027	-2.6066515446	6.033343	6.033203	-14.666708	0.3	3
i1.31	76.01935	-2.5757126808	6.033203	6.033345	-14.776334	0.3	3
i1.31	78.69844	-2.6670629978	6.033345	6.032646	-14.873924	0.3	3
i1.31	81.377525	-2.6514046192	6.032646	6.032119	-14.977673	0.3	3
i1.31	84.05662	-2.5895738602	6.032119	6.032576	-15.070427	0.3	3
i1.31	86.735695	-2.5899484158	6.032576	6.032333	-15.175811	0.3	3
i1.31	89.41479	-2.669254303	6.032333	6.031829	-15.271752	0.3	3
i1.31	92.093864	-2.6040248871	6.031829	6.031482	-15.365235	0.3	3
i1.31	94.772964	-2.5963275433	6.031482	6.031216	-15.476468	0.3	3
i1.31	97.45204	-2.6250684261	6.031216	6.030950	-15.571929	0.3	3
i1.31	100.131134	-2.6250920296	6.030950	6.030783	-15.673403	0.3	3
i1.31	102.81021	-2.6746349335	6.030783	6.030732	-15.776577	0.3	3
i1.31	105.48931	2.6772737503	6.030732	6.030311	-15.880675	0.3	3
i1.20	108.0302	-0.7607114315	5.090044	5.090044	-14.970075	-0.25	3
i1.20	108.80029	-0.7483884096	5.090044	5.090344	-14.874296	-0.25	3
i1.20	109.57039	-0.7630078793	5.090344	5.090622	-14.773181	-0.25	3
i1.20	110.340485	-0.7473337054	5.090622	5.090911	-14.685645	-0.25	3
i1.20	111.11058	-0.7491750717	5.090911	5.091305	-14.570149	-0.25	3
i1.20	111.88068	-0.7666870952	5.091305	5.091489	-14.47053	-0.25	3
i1.20	112.65077	-0.7592297792	5.091489	5.091148	-14.381565	-0.25	3
i1.20	113.420876	-0.7506462336	5.091148	5.091799	-14.271592	-0.25	3
i1.20	114.19097	-0.7654973269	5.091799	5.092885	-14.17136	-0.25	3
i1.20	114.96107	-0.7581243515	5.092885	5.092623	-14.077959	-0.25	3
i1.20	115.73116	-0.7630906105	5.092623	5.092593	-13.96461	-0.25	3
i1.20	116.50126	-0.7580767274	5.092593	5.092913	-13.877387	-0.25	3
i1.20	117.271355	-0.7472351789	5.092913	5.093179	-13.773521	-0.25	3
i1.20	118.04146	-0.7579970956	5.093179	5.093738	-13.675618	-0.25	3
i1.20	118.811554	-0.7489982843	5.093738	5.093019	-13.574662	-0.25	3
i1.20	119.58165	-0.7449483871	5.093019	5.092962	-13.472905	-0.25	3
i1.20	120.351746	-0.7695810199	5.092962	5.094469	-13.366304	-0.25	3
i1.20	121.12184	-0.7664977908	5.094469	5.093541	-13.271541	-0.25	3
i1.20	121.89194	-0.7414986491	5.093541	5.095888	-13.167089	-0.25	3
i1.20	122.66203	-0.7661038637	5.095888	5.093817	-13.075444	-0.25	3
i1.20	123.43213	-0.7550666332	5.093817	5.093471	-12.979748	-0.25	3
i1.20	124.202225	-0.7620024681	5.093471	5.095494	-13.069449	-0.25	3
i1.20	124.97232	-0.7490965128	5.095494	5.094128	-13.189559	-0.25	3
i1.20	125.74242	-0.7685767412	5.094128	5.093836	-13.281169	-0.25	3
i1.20	126.51252	-0.7641982436	5.093836	5.093967	-13.375333	-0.25	3
i1.20	127.282616	-0.7461588383	5.093967	5.094210	-13.484448	-0.25	3
i1.20	128.0527	-0.7412654161	5.094210	5.093379	-13.579616	-0.25	3
i1.20	128.82281	-0.7394934893	5.093379	5.093499	-13.662585	-0.25	3
i1.20	129.5929	-0.7664180994	5.093499	5.092218	-13.782613	-0.25	3
i1.20	130.363	-0.7441006899	5.092218	5.093162	-13.878023	-0.25	3
i1.20	131.1331	-0.7674274445	5.093162	5.092147	-13.97781	-0.25	3
i1.20	131.9032	-0.7435957193	5.092147	5.092094	-14.075351	-0.25	3
i1.20	132.6733	-0.7422223091	5.092094	5.091985	-14.172664	-0.25	3
i1.20	133.44339	-0.7678807974	5.091985	5.091387	-14.281394	-0.25	3
i1.20	134.21349	-0.7662134171	5.091387	5.091378	-14.378016	-0.25	3
i1.20	134.98358	-0.7434311509	5.091378	5.091036	-14.471063	-0.25	3
i1.20	135.75368	-0.7572315931	5.091036	5.091217	-14.568973	-0.25	3
i1.20	136.52377	-0.7502203584	5.091217	5.090665	-14.680988	-0.25	3
i1.20	137.29387	-0.7577632666	5.090665	5.090750	-14.776316	-0.25	3
i1.20	138.06396	0.7644317746	5.090750	5.090357	-14.880562	-0.25	3
i1.21	108.021614	-0.7514158487	5.090040	5.090040	-14.975342	-0.2	3
i1.21	108.79192	-0.7682192326	5.090040	5.090460	-14.872946	-0.2	3
i1.21	109.56223	-0.7682638168	5.090460	5.090273	-14.767721	-0.2	3
i1.21	110.33255	-0.7546489835	5.090273	5.090780	-14.669159	-0.2	3
i1.21	111.10286	-0.759865284	5.090780	5.090993	-14.576621	-0.2	3
i1.21	111.87317	-0.7575838566	5.090993	5.091249	-14.477286	-0.2	3
i1.21	112.64348	-0.7678202987	5.091249	5.091693	-14.373835	-0.2	3
i1.21	113.413795	-0.7425346375	5.091693	5.091727	-14.272178	-0.2	3
i1.21	114.184105	-0.7506969571	5.091727	5.092324	-14.168505	-0.2	3
i1.21	114.954414	-0.7652143836	5.092324	5.092759	-14.075178	-0.2	3
i1.21	115.724724	-0.7691441178	5.092759	5.092193	-13.976635	-0.2	3
i1.21	116.49503	-0.7558849454	5.092193	5.092638	-13.87363	-0.2	3
i1.21	117.26535	-0.7481298447	5.092638	5.093140	-13.781119	-0.2	3
i1.21	118.03566	-0.7586981654	5.093140	5.092292	-13.672699	-0.2	3
i1.21	118.80597	-0.7472257018	5.092292	5.093268	-13.582577	-0.2	3
i1.21	119.57628	-0.7682332993	5.093268	5.093511	-13.470841	-0.2	3
i1.21	120.346596	-0.7446674109	5.093511	5.095677	-13.373608	-0.2	3
i1.21	121.116905	-0.7655384541	5.095677	5.092731	-13.274469	-0.2	3
i1.21	121.887215	-0.7401836514	5.092731	5.093835	-13.17756	-0.2	3
i1.21	122.65753	-0.7433524132	5.093835	5.094010	-13.073818	-0.2	3
i1.21	123.42784	-0.7497081757	5.094010	5.093172	-12.970298	-0.2	3
i1.21	124.19815	-0.7411359549	5.093172	5.095600	-13.074607	-0.2	3
i1.21	124.96846	-0.7702478766	5.095600	5.096430	-13.179962	-0.2	3
i1.21	125.73877	-0.7563247681	5.096430	5.093850	-13.27776	-0.2	3
i1.21	126.50909	-0.7574753761	5.093850	5.093358	-13.375769	-0.2	3
i1.21	127.279396	-0.7691219449	5.093358	5.094947	-13.484251	-0.2	3
i1.21	128.04971	-0.7406128645	5.094947	5.095206	-13.577662	-0.2	3
i1.21	128.82002	-0.7540509105	5.095206	5.093126	-13.670607	-0.2	3
i1.21	129.59033	-0.761931181	5.093126	5.092921	-13.776386	-0.2	3
i1.21	130.36064	-0.7625599504	5.092921	5.093396	-13.88503	-0.2	3
i1.21	131.13095	-0.7616121173	5.093396	5.093054	-13.973566	-0.2	3
i1.21	131.90126	-0.7632049322	5.093054	5.093101	-14.068917	-0.2	3
i1.21	132.67157	-0.7401044369	5.093101	5.092184	-14.175883	-0.2	3
i1.21	133.4419	-0.7527208924	5.092184	5.091942	-14.272143	-0.2	3
i1.21	134.2122	-0.7422969937	5.091942	5.091621	-14.37297	-0.2	3
i1.21	134.98251	-0.7447021008	5.091621	5.090957	-14.470799	-0.2	3
i1.21	135.75282	-0.7574535012	5.090957	5.090937	-14.5689	-0.2	3
i1.21	136.52313	-0.7609295845	5.090937	5.090651	-14.668003	-0.2	3
i1.21	137.29344	-0.743388772	5.090651	5.090563	-14.765104	-0.2	3
i1.21	138.06375	0.751829803	5.090563	5.090255	-14.875394	-0.2	3
i1.22	108.01501	-0.7562173605	5.090045	5.090045	-14.981749	-0.15	3
i1.22	108.785484	-0.7634142637	5.090045	5.090386	-14.873847	-0.15	3
i1.22	109.55596	-0.7627526522	5.090386	5.090602	-14.773562	-0.15	3
i1.22	110.32644	-0.7453243136	5.090602	5.090757	-14.673097	-0.15	3
i1.22	111.09692	-0.7591756582	5.090757	5.090803	-14.572244	-0.15	3
i1.22	111.86739	-0.7675170898	5.090803	5.091057	-14.47311	-0.15	3
i1.22	112.63786	-0.7543857694	5.091057	5.091266	-14.377874	-0.15	3
i1.22	113.40834	-0.7581589222	5.091266	5.091247	-14.268478	-0.15	3
i1.22	114.17882	-0.760427475	5.091247	5.091717	-14.171599	-0.15	3
i1.22	114.949295	-0.7661672235	5.091717	5.092463	-14.070164	-0.15	3
i1.22	115.71977	-0.7621455789	5.092463	5.092892	-13.974616	-0.15	3
i1.22	116.49025	-0.7459098101	5.092892	5.092808	-13.872747	-0.15	3
i1.22	117.26073	-0.7586761713	5.092808	5.093241	-13.777814	-0.15	3
i1.22	118.031204	-0.7680404186	5.093241	5.093972	-13.677757	-0.15	3
i1.22	118.80168	-0.7631993294	5.093972	5.093891	-13.56805	-0.15	3
i1.22	119.57215	-0.7468600273	5.093891	5.094967	-13.472225	-0.15	3
i1.22	120.342636	-0.7698277831	5.094967	5.094770	-13.375628	-0.15	3
i1.22	121.113106	-0.7420572042	5.094770	5.094736	-13.270844	-0.15	3
i1.22	121.88358	-0.760602951	5.094736	5.094112	-13.174502	-0.15	3
i1.22	122.65406	-0.7412748933	5.094112	5.095654	-13.082459	-0.15	3
i1.22	123.42454	-0.7578262091	5.095654	5.095104	-12.978873	-0.15	3
i1.22	124.195015	-0.7677534819	5.095104	5.093537	-13.078069	-0.15	3
i1.22	124.965485	-0.7497388124	5.093537	5.094359	-13.187458	-0.15	3
i1.22	125.73597	-0.7436460853	5.094359	5.095262	-13.280307	-0.15	3
i1.22	126.50644	-0.7580941319	5.095262	5.093788	-13.382139	-0.15	3
i1.22	127.27692	-0.7538586855	5.093788	5.092776	-13.473355	-0.15	3
i1.22	128.0474	-0.746234417	5.092776	5.093950	-13.5841	-0.15	3
i1.22	128.81787	-0.7677118778	5.093950	5.092031	-13.676492	-0.15	3
i1.22	129.58835	-0.7538474202	5.092031	5.092049	-13.775758	-0.15	3
i1.22	130.35883	-0.7654063106	5.092049	5.092963	-13.88226	-0.15	3
i1.22	131.1293	-0.7425109148	5.092963	5.092358	-13.972751	-0.15	3
i1.22	131.89978	-0.7418416739	5.092358	5.091702	-14.074222	-0.15	3
i1.22	132.67026	-0.7681391835	5.091702	5.092128	-14.168003	-0.15	3
i1.22	133.44073	-0.7521572709	5.092128	5.091948	-14.27777	-0.15	3
i1.22	134.21121	-0.7648049593	5.091948	5.091791	-14.381027	-0.15	3
i1.22	134.98169	-0.7635754943	5.091791	5.091434	-14.47123	-0.15	3
i1.22	135.75217	-0.7477384806	5.091434	5.091069	-14.575546	-0.15	3
i1.22	136.52264	-0.7475079298	5.091069	5.091065	-14.676344	-0.15	3
i1.22	137.2931	-0.7508085966	5.091065	5.090570	-14.779506	-0.15	3
i1.22	138.0636	0.7658479214	5.090570	5.090238	-14.885388	-0.15	3
i1.23	108.024025	-0.7405990958	5.090045	5.090045	-14.97286	-0.1	3
i1.23	108.79427	-0.7448971868	5.090045	5.090388	-14.8685	-0.1	3
i1.23	109.56452	-0.763199091	5.090388	5.090755	-14.773041	-0.1	3
i1.23	110.33477	-0.7578703761	5.090755	5.090706	-14.664434	-0.1	3
i1.23	111.10503	-0.7554442286	5.090706	5.090694	-14.572614	-0.1	3
i1.23	111.875275	-0.7643922567	5.090694	5.091457	-14.477537	-0.1	3
i1.23	112.64553	-0.7660304308	5.091457	5.091389	-14.36972	-0.1	3
i1.23	113.41578	-0.748113215	5.091389	5.091626	-14.267687	-0.1	3
i1.23	114.18603	-0.7658627033	5.091626	5.091607	-14.170389	-0.1	3
i1.23	114.956276	-0.7537823915	5.091607	5.091232	-14.057998	-0.1	3
i1.23	115.72653	-0.7406559587	5.091232	5.091962	-13.975774	-0.1	3
i1.23	116.49678	-0.7593021989	5.091962	5.092341	-13.872624	-0.1	3
i1.23	117.26704	-0.7464944124	5.092341	5.093078	-13.768468	-0.1	3
i1.23	118.037285	-0.7588141561	5.093078	5.093299	-13.68116	-0.1	3
i1.23	118.80753	-0.7561746836	5.093299	5.092977	-13.581442	-0.1	3
i1.23	119.57779	-0.763461709	5.092977	5.094159	-13.47633	-0.1	3
i1.23	120.34804	-0.7484879494	5.094159	5.093364	-13.372101	-0.1	3
i1.23	121.118286	-0.7617034912	5.093364	5.094747	-13.28154	-0.1	3
i1.23	121.88854	-0.756849587	5.094747	5.094112	-13.171775	-0.1	3
i1.23	122.65879	-0.7496623397	5.094112	5.095397	-13.081241	-0.1	3
i1.23	123.42905	-0.7414947748	5.095397	5.093953	-12.977414	-0.1	3
i1.23	124.199295	-0.7682754993	5.093953	5.093802	-13.075227	-0.1	3
i1.23	124.96954	-0.7568310499	5.093802	5.093982	-13.174206	-0.1	3
i1.23	125.7398	-0.7654470205	5.093982	5.093981	-13.279129	-0.1	3
i1.23	126.51005	-0.7473140359	5.093981	5.094568	-13.380305	-0.1	3
i1.23	127.2803	-0.7550817132	5.094568	5.091807	-13.475743	-0.1	3
i1.23	128.05055	-0.7526000142	5.091807	5.093761	-13.579501	-0.1	3
i1.23	128.8208	-0.7539215684	5.093761	5.093810	-13.677679	-0.1	3
i1.23	129.59105	-0.7609792948	5.093810	5.092100	-13.770828	-0.1	3
i1.23	130.3613	-0.7556273937	5.092100	5.092332	-13.878453	-0.1	3
i1.23	131.13156	-0.7680261731	5.092332	5.092887	-13.96991	-0.1	3
i1.23	131.90181	-0.7616791725	5.092887	5.092397	-14.078695	-0.1	3
i1.23	132.67206	-0.7466163039	5.092397	5.092307	-14.173975	-0.1	3
i1.23	133.4423	-0.746442616	5.092307	5.091954	-14.273021	-0.1	3
i1.23	134.21255	-0.7579602599	5.091954	5.091530	-14.375831	-0.1	3
i1.23	134.9828	-0.7453991175	5.091530	5.091142	-14.486602	-0.1	3
i1.23	135.75307	-0.7607435584	5.091142	5.090982	-14.582004	-0.1	3
i1.23	136.52332	-0.7464851737	5.090982	5.090374	-14.67313	-0.1	3
i1.23	137.29356	-0.7399077415	5.090374	5.090395	-14.766279	-0.1	3
i1.23	138.06381	0.7550587654	5.090395	5.090293	-14.878723	-0.1	3
i1.24	108.00456	-0.7532058954	5.090039	5.090039	-14.976596	-0.05	3
i1.24	108.7753	-0.7457361221	5.090039	5.090294	-14.875357	-0.05	3
i1.24	109.546036	-0.7447165251	5.090294	5.090518	-14.777147	-0.05	3
i1.24	110.31677	-0.7543271184	5.090518	5.090974	-14.666595	-0.05	3
i1.24	111.08751	-0.7703123689	5.090974	5.091217	-14.570177	-0.05	3
i1.24	111.858246	-0.7646701932	5.091217	5.091141	-14.473326	-0.05	3
i1.24	112.62898	-0.7563052773	5.091141	5.091339	-14.378358	-0.05	3
i1.24	113.39973	-0.7616556287	5.091339	5.091341	-14.284418	-0.05	3
i1.24	114.17046	-0.755548358	5.091341	5.091862	-14.173414	-0.05	3
i1.24	114.9412	-0.7638603449	5.091862	5.092706	-14.072808	-0.05	3
i1.24	115.71194	-0.7648362517	5.092706	5.092821	-13.979986	-0.05	3
i1.24	116.48267	-0.7430932522	5.092821	5.092151	-13.868945	-0.05	3
i1.24	117.25341	-0.7668835521	5.092151	5.092791	-13.776967	-0.05	3
i1.24	118.02415	-0.7620999217	5.092791	5.093921	-13.671918	-0.05	3
i1.24	118.79489	-0.7561019063	5.093921	5.093340	-13.576966	-0.05	3
i1.24	119.56563	-0.7673332691	5.093340	5.093294	-13.479481	-0.05	3
i1.24	120.336365	-0.7548274398	5.093294	5.094717	-13.37844	-0.05	3
i1.24	121.1071	-0.76210922	5.094717	5.093195	-13.265229	-0.05	3
i1.24	121.87784	-0.7574785948	5.093195	5.094037	-13.173276	-0.05	3
i1.24	122.648575	-0.7665563226	5.094037	5.094220	-13.073176	-0.05	3
i1.24	123.41931	-0.7664131522	5.094220	5.094559	-12.971657	-0.05	3
i1.24	124.19005	-0.7563465238	5.094559	5.094411	-13.073265	-0.05	3
i1.24	124.960785	-0.7635505795	5.094411	5.095847	-13.172171	-0.05	3
i1.24	125.73152	-0.7652650476	5.095847	5.094571	-13.281012	-0.05	3
i1.24	126.50226	-0.7468302846	5.094571	5.097175	-13.379267	-0.05	3
i1.24	127.273	-0.754018724	5.097175	5.093845	-13.464678	-0.05	3
i1.24	128.04373	-0.7611917853	5.093845	5.093192	-13.574636	-0.05	3
i1.24	128.81448	-0.7479172945	5.093192	5.092808	-13.672622	-0.05	3
i1.24	129.5852	-0.7493050098	5.092808	5.092506	-13.774753	-0.05	3
i1.24	130.35596	-0.7451200485	5.092506	5.092578	-13.875897	-0.05	3
i1.24	131.1267	-0.7668895125	5.092578	5.092808	-13.97033	-0.05	3
i1.24	131.89743	-0.7408537269	5.092808	5.092048	-14.074387	-0.05	3
i1.24	132.66817	-0.7606646419	5.092048	5.092149	-14.181072	-0.05	3
i1.24	133.4389	-0.7707183957	5.092149	5.091310	-14.279855	-0.05	3
i1.24	134.20964	-0.7695468068	5.091310	5.091647	-14.374305	-0.05	3
i1.24	134.98038	-0.7575176954	5.091647	5.091555	-14.474319	-0.05	3
i1.24	135.75111	-0.7522206306	5.091555	5.091351	-14.572547	-0.05	3
i1.24	136.52185	-0.7579858303	5.091351	5.090788	-14.676398	-0.05	3
i1.24	137.29259	-0.7598385811	5.090788	5.090654	-14.78716	-0.05	3
i1.24	138.06332	0.7699974775	5.090654	5.090386	-14.869261	-0.05	3
i1.25	108.00853	-0.7511491776	5.090060	5.090060	-14.97422	0.0	3
i1.25	108.77917	-0.7588384151	5.090060	5.090281	-14.871937	0.0	3
i1.25	109.549805	-0.7445291877	5.090281	5.090574	-14.775298	0.0	3
i1.25	110.32044	-0.748506844	5.090574	5.090825	-14.6849	0.0	3
i1.25	111.09108	-0.7605934739	5.090825	5.090827	-14.576977	0.0	3
i1.25	111.86172	-0.7697487473	5.090827	5.090716	-14.477005	0.0	3
i1.25	112.632355	-0.7467465401	5.090716	5.091400	-14.369036	0.0	3
i1.25	113.403	-0.7682293653	5.091400	5.091726	-14.265821	0.0	3
i1.25	114.17364	-0.7678518891	5.091726	5.091547	-14.178443	0.0	3
i1.25	114.944275	-0.7506857514	5.091547	5.093084	-14.077465	0.0	3
i1.25	115.71491	-0.746342957	5.093084	5.093465	-13.98758	0.0	3
i1.25	116.48555	-0.7589264512	5.093465	5.092127	-13.86833	0.0	3
i1.25	117.25619	-0.7515394688	5.092127	5.093942	-13.769741	0.0	3
i1.25	118.026825	-0.7492895126	5.093942	5.092510	-13.67619	0.0	3
i1.25	118.79746	-0.7618171573	5.092510	5.093137	-13.572902	0.0	3
i1.25	119.56811	-0.7476349473	5.093137	5.093584	-13.475123	0.0	3
i1.25	120.338745	-0.7401217222	5.093584	5.095289	-13.376856	0.0	3
i1.25	121.10938	-0.7680125833	5.095289	5.094478	-13.274964	0.0	3
i1.25	121.88002	-0.7576657534	5.094478	5.093993	-13.171197	0.0	3
i1.25	122.65066	-0.7592805624	5.093993	5.095543	-13.06087	0.0	3
i1.25	123.421295	-0.7616315484	5.095543	5.093268	-12.978105	0.0	3
i1.25	124.19194	-0.7427411079	5.093268	5.095897	-13.073295	0.0	3
i1.25	124.96257	-0.7682535648	5.095897	5.094594	-13.169973	0.0	3
i1.25	125.733215	-0.7687568069	5.094594	5.094643	-13.27149	0.0	3
i1.25	126.50385	-0.7517889738	5.094643	5.093429	-13.372432	0.0	3
i1.25	127.27449	-0.7617075443	5.093429	5.095139	-13.478518	0.0	3
i1.25	128.04514	-0.7603184581	5.095139	5.093897	-13.571332	0.0	3
i1.25	128.81577	-0.7492393255	5.093897	5.094661	-13.670168	0.0	3
i1.25	129.58641	-0.7584568858	5.094661	5.093060	-13.771159	0.0	3
i1.25	130.35704	-0.740398407	5.093060	5.092273	-13.872916	0.0	3
i1.25	131.12769	-0.7547439337	5.092273	5.092501	-13.974044	0.0	3
i1.25	131.89832	-0.769549787	5.092501	5.092300	-14.073234	0.0	3
i1.25	132.66896	-0.7560634613	5.092300	5.092319	-14.172567	0.0	3
i1.25	133.4396	-0.7547581792	5.092319	5.091951	-14.274118	0.0	3
i1.25	134.21024	-0.7574103475	5.091951	5.091754	-14.375951	0.0	3
i1.25	134.98088	-0.7399654984	5.091754	5.091598	-14.476268	0.0	3
i1.25	135.75151	-0.74029392	5.091598	5.090971	-14.577354	0.0	3
i1.25	136.52216	-0.7496873736	5.090971	5.090782	-14.6728	0.0	3
i1.25	137.29279	-0.7653159499	5.090782	5.090635	-14.776866	0.0	3
i1.25	138.06343	0.7627826929	5.090635	5.090357	-14.887231	0.0	3
i1.26	108.00809	-0.7700555325	5.090071	5.090071	-14.977117	0.05	3
i1.26	108.77874	-0.7687535882	5.090071	5.090346	-14.875161	0.05	3
i1.26	109.549385	-0.7475569844	5.090346	5.090520	-14.769548	0.05	3
i1.26	110.32004	-0.7480479479	5.090520	5.090926	-14.679282	0.05	3
i1.26	111.09068	-0.7584633231	5.090926	5.090872	-14.575954	0.05	3
i1.26	111.861336	-0.7552178502	5.090872	5.091819	-14.471424	0.05	3
i1.26	112.63199	-0.7549234629	5.091819	5.091851	-14.380041	0.05	3
i1.26	113.40263	-0.7416818738	5.091851	5.091975	-14.274822	0.05	3
i1.26	114.17329	-0.7459210157	5.091975	5.092918	-14.170884	0.05	3
i1.26	114.94393	-0.7502622604	5.092918	5.091522	-14.067482	0.05	3
i1.26	115.714584	-0.761947751	5.091522	5.092183	-13.976794	0.05	3
i1.26	116.48523	-0.7495852709	5.092183	5.092793	-13.871897	0.05	3
i1.26	117.25588	-0.758761704	5.092793	5.093558	-13.770975	0.05	3
i1.26	118.02653	-0.7574927807	5.093558	5.092575	-13.678687	0.05	3
i1.26	118.79718	-0.7617837191	5.092575	5.094309	-13.571043	0.05	3
i1.26	119.56783	-0.7468897104	5.094309	5.094976	-13.465728	0.05	3
i1.26	120.33848	-0.755546093	5.094976	5.094868	-13.376542	0.05	3
i1.26	121.10913	-0.7692016959	5.094868	5.093692	-13.278714	0.05	3
i1.26	121.879776	-0.7434090376	5.093692	5.092431	-13.165742	0.05	3
i1.26	122.65043	-0.7667357922	5.092431	5.095484	-13.065427	0.05	3
i1.26	123.42108	-0.7679821849	5.095484	5.093935	-12.968876	0.05	3
i1.26	124.19173	-0.7510929108	5.093935	5.094861	-13.072413	0.05	3
i1.26	124.96238	-0.7569290996	5.094861	5.094528	-13.181457	0.05	3
i1.26	125.733025	-0.7492104769	5.094528	5.094963	-13.280762	0.05	3
i1.26	126.50368	-0.7435353398	5.094963	5.094086	-13.374225	0.05	3
i1.26	127.27432	-0.7525002956	5.094086	5.093712	-13.480749	0.05	3
i1.26	128.04497	-0.7446760535	5.093712	5.093830	-13.57531	0.05	3
i1.26	128.81563	-0.745172739	5.093830	5.093903	-13.67508	0.05	3
i1.26	129.58627	-0.7628847361	5.093903	5.092462	-13.770846	0.05	3
i1.26	130.35692	-0.7406603694	5.092462	5.092396	-13.878616	0.05	3
i1.26	131.12756	-0.7399374247	5.092396	5.093300	-13.976796	0.05	3
i1.26	131.89822	-0.7616811991	5.093300	5.092419	-14.075256	0.05	3
i1.26	132.66887	-0.7479875088	5.092419	5.091795	-14.174411	0.05	3
i1.26	133.43951	-0.7466700673	5.091795	5.091756	-14.282324	0.05	3
i1.26	134.21017	-0.7586370111	5.091756	5.091729	-14.36745	0.05	3
i1.26	134.98082	-0.7555777431	5.091729	5.091535	-14.484014	0.05	3
i1.26	135.75146	-0.7640784979	5.091535	5.091264	-14.577998	0.05	3
i1.26	136.52213	-0.7636057734	5.091264	5.090666	-14.671906	0.05	3
i1.26	137.29277	-0.7597888708	5.090666	5.090322	-14.773104	0.05	3
i1.26	138.06342	0.7508306503	5.090322	5.090292	-14.88082	0.05	3
i1.27	108.02021	-0.7448746562	5.090050	5.090050	-14.970078	0.1	3
i1.27	108.79056	-0.7418493629	5.090050	5.090407	-14.873583	0.1	3
i1.27	109.560905	-0.7572532892	5.090407	5.090503	-14.781117	0.1	3
i1.27	110.33125	-0.7584437132	5.090503	5.090778	-14.679124	0.1	3
i1.27	111.1016	-0.7465925813	5.090778	5.091129	-14.567729	0.1	3
i1.27	111.87195	-0.7514544129	5.091129	5.091183	-14.465537	0.1	3
i1.27	112.642296	-0.7528150082	5.091183	5.091449	-14.368218	0.1	3
i1.27	113.41264	-0.7607027292	5.091449	5.092013	-14.277041	0.1	3
i1.27	114.18298	-0.7470719814	5.092013	5.092042	-14.186584	0.1	3
i1.27	114.95333	-0.7468190789	5.092042	5.091838	-14.072705	0.1	3
i1.27	115.72368	-0.7566482425	5.091838	5.091683	-13.980114	0.1	3
i1.27	116.494026	-0.7654492855	5.091683	5.092658	-13.880058	0.1	3
i1.27	117.26437	-0.7491753697	5.092658	5.092598	-13.771944	0.1	3
i1.27	118.03471	-0.7536877394	5.092598	5.093011	-13.683106	0.1	3
i1.27	118.80506	-0.7702072263	5.093011	5.093749	-13.571379	0.1	3
i1.27	119.57541	-0.7494881153	5.093749	5.092787	-13.474734	0.1	3
i1.27	120.34576	-0.7621996999	5.092787	5.094018	-13.373919	0.1	3
i1.27	121.116104	-0.7433653474	5.094018	5.092841	-13.272482	0.1	3
i1.27	121.886444	-0.7639923096	5.092841	5.095688	-13.181939	0.1	3
i1.27	122.65679	-0.7405387163	5.095688	5.094216	-13.075879	0.1	3
i1.27	123.42714	-0.7638339996	5.094216	5.095647	-12.970611	0.1	3
i1.27	124.19749	-0.7646304369	5.095647	5.092079	-13.080827	0.1	3
i1.27	124.967834	-0.743090868	5.092079	5.094451	-13.171436	0.1	3
i1.27	125.738174	-0.7562283874	5.094451	5.093681	-13.273807	0.1	3
i1.27	126.50852	-0.7600147128	5.093681	5.093543	-13.381765	0.1	3
i1.27	127.27887	-0.7469552159	5.093543	5.094536	-13.483563	0.1	3
i1.27	128.04922	-0.7481117249	5.094536	5.094025	-13.574083	0.1	3
i1.27	128.81956	-0.7445210218	5.094025	5.092220	-13.683169	0.1	3
i1.27	129.5899	-0.7561748028	5.092220	5.092750	-13.773997	0.1	3
i1.27	130.36026	-0.7595230937	5.092750	5.091702	-13.879302	0.1	3
i1.27	131.1306	-0.7566353679	5.091702	5.091920	-13.969138	0.1	3
i1.27	131.90096	-0.7576951385	5.091920	5.091582	-14.079178	0.1	3
i1.27	132.6713	-0.7506142259	5.091582	5.092074	-14.177797	0.1	3
i1.27	133.44165	-0.7426047325	5.092074	5.091330	-14.277162	0.1	3
i1.27	134.21199	-0.7624682188	5.091330	5.091095	-14.376751	0.1	3
i1.27	134.98233	-0.7447389364	5.091095	5.091424	-14.483189	0.1	3
i1.27	135.75269	-0.748431325	5.091424	5.091325	-14.577499	0.1	3
i1.27	136.52303	-0.7669681311	5.091325	5.090797	-14.676534	0.1	3
i1.27	137.29338	-0.7655433416	5.090797	5.090490	-14.769958	0.1	3
i1.27	138.06372	0.7497105598	5.090490	5.090162	-14.875212	0.1	3
i1.28	108.00433	-0.7401756644	5.090043	5.090043	-14.97688	0.15	3
i1.28	108.77508	-0.7468602061	5.090043	5.090352	-14.876333	0.15	3
i1.28	109.54582	-0.7614553571	5.090352	5.090508	-14.78038	0.15	3
i1.28	110.31657	-0.766258657	5.090508	5.090659	-14.673975	0.15	3
i1.28	111.08731	-0.7673016191	5.090659	5.091428	-14.580485	0.15	3
i1.28	111.858055	-0.7477049232	5.091428	5.091340	-14.469838	0.15	3
i1.28	112.6288	-0.7511079907	5.091340	5.091649	-14.368551	0.15	3
i1.28	113.39954	-0.7629897594	5.091649	5.091400	-14.270277	0.15	3
i1.28	114.17028	-0.7503548861	5.091400	5.092001	-14.171817	0.15	3
i1.28	114.941025	-0.7580525279	5.092001	5.091698	-14.069942	0.15	3
i1.28	115.71177	-0.7606639862	5.091698	5.093185	-13.964413	0.15	3
i1.28	116.48251	-0.7554671168	5.093185	5.093020	-13.871986	0.15	3
i1.28	117.25326	-0.7631299496	5.093020	5.092933	-13.777716	0.15	3
i1.28	118.024	-0.7567950487	5.092933	5.092669	-13.673832	0.15	3
i1.28	118.79474	-0.7580858469	5.092669	5.093947	-13.573716	0.15	3
i1.28	119.56549	-0.7448462248	5.093947	5.095378	-13.463458	0.15	3
i1.28	120.33623	-0.7547121644	5.095378	5.092509	-13.376766	0.15	3
i1.28	121.10697	-0.752348721	5.092509	5.093311	-13.276745	0.15	3
i1.28	121.877716	-0.7470653653	5.093311	5.094073	-13.181421	0.15	3
i1.28	122.64846	-0.7593368888	5.094073	5.093878	-13.075856	0.15	3
i1.28	123.419205	-0.7690742612	5.093878	5.093513	-12.977825	0.15	3
i1.28	124.18994	-0.770395577	5.093513	5.094472	-13.074015	0.15	3
i1.28	124.960686	-0.7607816458	5.094472	5.095192	-13.178258	0.15	3
i1.28	125.73143	-0.7701351643	5.095192	5.094269	-13.280812	0.15	3
i1.28	126.502174	-0.7693144083	5.094269	5.095001	-13.374832	0.15	3
i1.28	127.27292	-0.7505371571	5.095001	5.094947	-13.468562	0.15	3
i1.28	128.04366	-0.7408361435	5.094947	5.093697	-13.567293	0.15	3
i1.28	128.8144	-0.7580020428	5.093697	5.094133	-13.670864	0.15	3
i1.28	129.58514	-0.7523221374	5.094133	5.092853	-13.777894	0.15	3
i1.28	130.3559	-0.7448662519	5.092853	5.092871	-13.884407	0.15	3
i1.28	131.12663	-0.7517867088	5.092871	5.092138	-13.974065	0.15	3
i1.28	131.89737	-0.7454602718	5.092138	5.093048	-14.070148	0.15	3
i1.28	132.66812	-0.7520047426	5.093048	5.091820	-14.166111	0.15	3
i1.28	133.43887	-0.7534387708	5.091820	5.091599	-14.276193	0.15	3
i1.28	134.20961	-0.7663737535	5.091599	5.091367	-14.376003	0.15	3
i1.28	134.98035	-0.7613132	5.091367	5.091314	-14.464856	0.15	3
i1.28	135.7511	-0.7668754458	5.091314	5.090875	-14.569023	0.15	3
i1.28	136.52184	-0.7620671391	5.090875	5.090909	-14.679039	0.15	3
i1.28	137.29257	-0.753642261	5.090909	5.090689	-14.771219	0.15	3
i1.28	138.06332	0.7547454238	5.090689	5.090352	-14.871007	0.15	3
i1.29	108.00998	-0.7538074255	5.090051	5.090051	-14.973966	0.2	3
i1.29	108.78059	-0.7548354268	5.090051	5.090268	-14.874761	0.2	3
i1.29	109.551186	-0.7639245391	5.090268	5.090562	-14.771579	0.2	3
i1.29	110.32179	-0.7582153082	5.090562	5.090741	-14.672248	0.2	3
i1.29	111.09239	-0.7441240549	5.090741	5.091206	-14.565761	0.2	3
i1.29	111.86299	-0.7502831817	5.091206	5.091383	-14.46862	0.2	3
i1.29	112.6336	-0.7548251152	5.091383	5.091633	-14.373229	0.2	3
i1.29	113.4042	-0.745256722	5.091633	5.091767	-14.263261	0.2	3
i1.29	114.1748	-0.7644695044	5.091767	5.092087	-14.178272	0.2	3
i1.29	114.945404	-0.7407494187	5.092087	5.092171	-14.077184	0.2	3
i1.29	115.716	-0.7499212027	5.092171	5.092615	-13.974029	0.2	3
i1.29	116.4866	-0.7460878491	5.092615	5.093364	-13.870701	0.2	3
i1.29	117.25721	-0.7699443102	5.093364	5.093115	-13.776138	0.2	3
i1.29	118.02781	-0.7465680838	5.093115	5.092449	-13.676791	0.2	3
i1.29	118.79841	-0.7418550849	5.092449	5.093091	-13.568737	0.2	3
i1.29	119.569016	-0.7526925206	5.093091	5.094912	-13.47377	0.2	3
i1.29	120.339615	-0.7581108809	5.094912	5.094937	-13.378501	0.2	3
i1.29	121.110214	-0.7490653396	5.094937	5.095515	-13.268658	0.2	3
i1.29	121.88082	-0.7442194819	5.095515	5.095371	-13.174108	0.2	3
i1.29	122.65142	-0.7538397312	5.095371	5.093609	-13.078282	0.2	3
i1.29	123.42203	-0.7547822595	5.093609	5.095298	-12.976982	0.2	3
i1.29	124.19263	-0.7535917759	5.095298	5.095003	-13.077051	0.2	3
i1.29	124.96323	-0.7516082525	5.095003	5.095643	-13.17955	0.2	3
i1.29	125.73383	-0.7508868575	5.095643	5.094667	-13.27213	0.2	3
i1.29	126.50443	-0.7437903285	5.094667	5.094162	-13.376372	0.2	3
i1.29	127.27504	-0.7629977465	5.094162	5.093404	-13.476353	0.2	3
i1.29	128.04564	-0.7483440042	5.093404	5.094069	-13.570637	0.2	3
i1.29	128.81624	-0.7453141809	5.094069	5.093764	-13.675159	0.2	3
i1.29	129.58684	-0.7410857677	5.093764	5.092772	-13.77984	0.2	3
i1.29	130.35745	-0.7405784726	5.092772	5.092099	-13.87404	0.2	3
i1.29	131.12805	-0.7437554598	5.092099	5.092820	-13.978206	0.2	3
i1.29	131.89865	-0.7505035996	5.092820	5.093153	-14.082639	0.2	3
i1.29	132.66925	-0.7586898804	5.093153	5.092358	-14.176629	0.2	3
i1.29	133.43985	-0.7539814711	5.092358	5.091351	-14.276418	0.2	3
i1.29	134.21045	-0.7651177049	5.091351	5.091502	-14.37122	0.2	3
i1.29	134.98105	-0.7648572326	5.091502	5.091244	-14.470253	0.2	3
i1.29	135.75166	-0.7576169968	5.091244	5.090788	-14.578663	0.2	3
i1.29	136.52226	-0.7705508471	5.090788	5.090712	-14.677216	0.2	3
i1.29	137.29286	-0.7455996275	5.090712	5.090456	-14.775143	0.2	3
i1.29	138.06346	0.758228302	5.090456	5.090304	-14.867041	0.2	3
i1.30	108.02971	-0.7457826734	5.090048	5.090048	-14.977626	0.25	3
i1.30	108.79981	-0.7650512457	5.090048	5.090272	-14.86971	0.25	3
i1.30	109.56992	-0.753600955	5.090272	5.090331	-14.772681	0.25	3
i1.30	110.340034	-0.7400060892	5.090331	5.090505	-14.666395	0.25	3
i1.30	111.110146	-0.757587254	5.090505	5.090879	-14.570258	0.25	3
i1.30	111.88025	-0.7578354478	5.090879	5.091482	-14.473802	0.25	3
i1.30	112.65036	-0.7457050085	5.091482	5.091206	-14.37675	0.25	3
i1.30	113.42047	-0.7668167353	5.091206	5.091406	-14.270182	0.25	3
i1.30	114.19058	-0.7400598526	5.091406	5.091219	-14.166889	0.25	3
i1.30	114.960686	-0.7398232222	5.091219	5.092458	-14.079633	0.25	3
i1.30	115.7308	-0.7684095502	5.092458	5.092971	-13.976928	0.25	3
i1.30	116.50091	-0.7643051147	5.092971	5.093194	-13.869194	0.25	3
i1.30	117.27101	-0.7624390721	5.093194	5.093290	-13.7708	0.25	3
i1.30	118.04112	-0.744222343	5.093290	5.093403	-13.669442	0.25	3
i1.30	118.81123	-0.7687811255	5.093403	5.093551	-13.580415	0.25	3
i1.30	119.581345	-0.7594305873	5.093551	5.095004	-13.478546	0.25	3
i1.30	120.35145	-0.7576504946	5.095004	5.095108	-13.373116	0.25	3
i1.30	121.12156	-0.741019547	5.095108	5.094594	-13.270193	0.25	3
i1.30	121.89167	-0.7646848559	5.094594	5.093726	-13.171972	0.25	3
i1.30	122.66177	-0.7573919296	5.093726	5.094228	-13.068677	0.25	3
i1.30	123.431885	-0.7406685948	5.094228	5.095992	-12.980995	0.25	3
i1.30	124.201996	-0.7562020421	5.095992	5.093921	-13.081671	0.25	3
i1.30	124.97211	-0.7430859804	5.093921	5.095048	-13.181602	0.25	3
i1.30	125.74222	-0.7419342995	5.095048	5.094687	-13.274878	0.25	3
i1.30	126.51232	-0.7418094873	5.094687	5.094660	-13.380004	0.25	3
i1.30	127.28243	-0.7583419085	5.094660	5.092787	-13.478254	0.25	3
i1.30	128.05254	-0.7441163659	5.092787	5.093776	-13.567513	0.25	3
i1.30	128.82265	-0.7586379051	5.093776	5.094283	-13.67277	0.25	3
i1.30	129.59276	-0.7445818782	5.094283	5.093968	-13.776523	0.25	3
i1.30	130.36287	-0.7578058243	5.093968	5.093433	-13.871301	0.25	3
i1.30	131.13298	-0.7397574782	5.093433	5.093269	-13.976458	0.25	3
i1.30	131.90309	-0.7400479913	5.093269	5.092411	-14.074723	0.25	3
i1.30	132.67319	-0.7546070218	5.092411	5.092674	-14.178382	0.25	3
i1.30	133.4433	-0.763584137	5.092674	5.091601	-14.275158	0.25	3
i1.30	134.21341	-0.7583580613	5.091601	5.091456	-14.365552	0.25	3
i1.30	134.98352	-0.749963522	5.091456	5.091346	-14.485121	0.25	3
i1.30	135.75363	-0.7462048531	5.091346	5.090812	-14.579661	0.25	3
i1.30	136.52374	-0.7596549988	5.090812	5.090747	-14.678523	0.25	3
i1.30	137.29385	-0.743814528	5.090747	5.090796	-14.776525	0.25	3
i1.30	138.06396	0.759342432	5.090796	5.090241	-14.867123	0.25	3
i1.31	108.02355	-0.7622272968	5.090061	5.090061	-14.974638	0.3	3
i1.31	108.793816	-0.7571282983	5.090061	5.090389	-14.873797	0.3	3
i1.31	109.56407	-0.7406355143	5.090389	5.090678	-14.772401	0.3	3
i1.31	110.334335	-0.7461265326	5.090678	5.090732	-14.669165	0.3	3
i1.31	111.1046	-0.7481649518	5.090732	5.090869	-14.569187	0.3	3
i1.31	111.87486	-0.7400755882	5.090869	5.091166	-14.476631	0.3	3
i1.31	112.64513	-0.7646376491	5.091166	5.091405	-14.378427	0.3	3
i1.31	113.41539	-0.7423432469	5.091405	5.091709	-14.269595	0.3	3
i1.31	114.18565	-0.7681067586	5.091709	5.092448	-14.180627	0.3	3
i1.31	114.95592	-0.7548289299	5.092448	5.093553	-14.072886	0.3	3
i1.31	115.72618	-0.7573712468	5.093553	5.092706	-13.956154	0.3	3
i1.31	116.496445	-0.7435123324	5.092706	5.092075	-13.868864	0.3	3
i1.31	117.26671	-0.7579058409	5.092075	5.091729	-13.77835	0.3	3
i1.31	118.036964	-0.7576241493	5.091729	5.092138	-13.671693	0.3	3
i1.31	118.80723	-0.7429318428	5.092138	5.094153	-13.566447	0.3	3
i1.31	119.57749	-0.7555406094	5.094153	5.093268	-13.470773	0.3	3
i1.31	120.347755	-0.7456377149	5.093268	5.094860	-13.37189	0.3	3
i1.31	121.11802	-0.757615149	5.094860	5.094531	-13.286285	0.3	3
i1.31	121.88828	-0.7541174889	5.094531	5.093949	-13.175127	0.3	3
i1.31	122.65855	-0.7529127598	5.093949	5.093864	-13.070144	0.3	3
i1.31	123.42881	-0.7557948828	5.093864	5.093333	-12.968813	0.3	3
i1.31	124.19907	-0.7494320273	5.093333	5.094138	-13.074986	0.3	3
i1.31	124.96933	-0.7636446357	5.094138	5.095177	-13.173546	0.3	3
i1.31	125.73959	-0.7475891709	5.095177	5.094457	-13.28321	0.3	3
i1.31	126.50986	-0.7679123282	5.094457	5.094849	-13.381439	0.3	3
i1.31	127.28012	-0.753456533	5.094849	5.092715	-13.474388	0.3	3
i1.31	128.05038	-0.7409391403	5.092715	5.093238	-13.577209	0.3	3
i1.31	128.82065	-0.7531283498	5.093238	5.092890	-13.673234	0.3	3
i1.31	129.59091	-0.7442348003	5.092890	5.093884	-13.771487	0.3	3
i1.31	130.36118	-0.74183321	5.093884	5.092790	-13.884472	0.3	3
i1.31	131.13144	-0.7420241833	5.092790	5.091967	-13.978831	0.3	3
i1.31	131.9017	-0.7633794546	5.091967	5.092563	-14.062424	0.3	3
i1.31	132.67197	-0.7597956657	5.092563	5.091773	-14.168295	0.3	3
i1.31	133.44223	-0.7641861439	5.091773	5.091692	-14.274729	0.3	3
i1.31	134.2125	-0.7424613833	5.091692	5.091326	-14.378205	0.3	3
i1.31	134.98276	-0.7646093369	5.091326	5.091107	-14.460807	0.3	3
i1.31	135.75302	-0.754185617	5.091107	5.090976	-14.575144	0.3	3
i1.31	136.52328	-0.7498859167	5.090976	5.090723	-14.675374	0.3	3
i1.31	137.29355	-0.7500138879	5.090723	5.090343	-14.769107	0.3	3
i1.31	138.0638	0.7601504326	5.090343	5.090327	-14.870287	0.3	3
i1.20	138.85938	-1.0524408817	6.020035	6.020035	-14.977687	-0.25	3
i1.20	139.93387	-1.0563446283	6.020035	6.020375	-14.874141	-0.25	3
i1.20	141.00836	-1.0524898767	6.020375	6.020519	-14.774302	-0.25	3
i1.20	142.08286	-1.0722131729	6.020519	6.020915	-14.671069	-0.25	3
i1.20	143.15735	-1.0569529533	6.020915	6.021284	-14.572073	-0.25	3
i1.20	144.23184	-1.0542061329	6.021284	6.021314	-14.469061	-0.25	3
i1.20	145.30634	-1.0441782475	6.021314	6.021641	-14.367219	-0.25	3
i1.20	146.38084	-1.0371719599	6.021641	6.021660	-14.264887	-0.25	3
i1.20	147.45534	-1.0484580994	6.021660	6.022796	-14.17377	-0.25	3
i1.20	148.52983	-1.0672819614	6.022796	6.022233	-14.07562	-0.25	3
i1.20	149.60432	-1.0504858494	6.022233	6.022160	-13.97863	-0.25	3
i1.20	150.67882	-1.0711734295	6.022160	6.021644	-13.873046	-0.25	3
i1.20	151.75331	-1.05179286	6.021644	6.024005	-13.7754	-0.25	3
i1.20	152.8278	-1.0561407804	6.024005	6.023540	-13.680396	-0.25	3
i1.20	153.9023	-1.0385762453	6.023540	6.023342	-13.582984	-0.25	3
i1.20	154.97679	-1.0421054363	6.023342	6.022795	-13.47322	-0.25	3
i1.20	156.0513	-1.0360236168	6.022795	6.024359	-13.374678	-0.25	3
i1.20	157.1258	-1.0653259754	6.024359	6.024536	-13.279097	-0.25	3
i1.20	158.20029	-1.0606597662	6.024536	6.024387	-13.173317	-0.25	3
i1.20	159.27478	-1.0439295769	6.024387	6.024571	-13.074763	-0.25	3
i1.20	160.34927	-1.0559703112	6.024571	6.027079	-12.982659	-0.25	3
i1.20	161.42377	-1.0409178734	6.027079	6.026241	-13.080427	-0.25	3
i1.20	162.49826	-1.0348221064	6.026241	6.024061	-13.178274	-0.25	3
i1.20	163.57275	-1.0601661205	6.024061	6.025033	-13.271648	-0.25	3
i1.20	164.64725	-1.0384839773	6.025033	6.023908	-13.37754	-0.25	3
i1.20	165.72174	-1.0383790731	6.023908	6.023697	-13.480481	-0.25	3
i1.20	166.79625	-1.0535777807	6.023697	6.022799	-13.570905	-0.25	3
i1.20	167.87073	-1.0635027885	6.022799	6.023434	-13.682328	-0.25	3
i1.20	168.94524	-1.0375622511	6.023434	6.023498	-13.775731	-0.25	3
i1.20	170.01973	-1.04400599	6.023498	6.021590	-13.871775	-0.25	3
i1.20	171.09422	-1.0380511284	6.021590	6.022844	-13.969712	-0.25	3
i1.20	172.16872	-1.0592386723	6.022844	6.021827	-14.067129	-0.25	3
i1.20	173.24323	-1.0382509232	6.021827	6.021614	-14.173447	-0.25	3
i1.20	174.31772	-1.0591779947	6.021614	6.022648	-14.278607	-0.25	3
i1.20	175.3922	-1.0415889025	6.022648	6.021733	-14.379152	-0.25	3
i1.20	176.4667	-1.0485906601	6.021733	6.021426	-14.469729	-0.25	3
i1.20	177.5412	-1.0627746582	6.021426	6.021058	-14.578189	-0.25	3
i1.20	178.61569	-1.037533164	6.021058	6.020545	-14.675275	-0.25	3
i1.20	179.69019	-1.0454864502	6.020545	6.020586	-14.765818	-0.25	3
i1.20	180.76468	1.0430731773	6.020586	6.020326	-14.867445	-0.25	3
i1.21	138.84921	-1.0476373434	6.020048	6.020048	-14.980114	-0.2	3
i1.21	139.92395	-1.0441420078	6.020048	6.020291	-14.873083	-0.2	3
i1.21	140.9987	-1.0519685745	6.020291	6.020651	-14.771775	-0.2	3
i1.21	142.07346	-1.0564761162	6.020651	6.020863	-14.685018	-0.2	3
i1.21	143.14821	-1.0563272238	6.020863	6.021458	-14.561182	-0.2	3
i1.21	144.22295	-1.0494031906	6.021458	6.021175	-14.476362	-0.2	3
i1.21	145.2977	-1.0345044136	6.021175	6.021784	-14.373605	-0.2	3
i1.21	146.37245	-1.0418092012	6.021784	6.021561	-14.274724	-0.2	3
i1.21	147.4472	-1.0612607002	6.021561	6.021738	-14.167939	-0.2	3
i1.21	148.52194	-1.0458245277	6.021738	6.022131	-14.081175	-0.2	3
i1.21	149.5967	-1.0321674347	6.022131	6.022423	-13.97618	-0.2	3
i1.21	150.67145	-1.0720539093	6.022423	6.023104	-13.867738	-0.2	3
i1.21	151.7462	-1.0643230677	6.023104	6.022630	-13.774625	-0.2	3
i1.21	152.82095	-1.0739377737	6.022630	6.023874	-13.676684	-0.2	3
i1.21	153.89569	-1.0468080044	6.023874	6.023042	-13.573628	-0.2	3
i1.21	154.97044	-1.0722634792	6.023042	6.023620	-13.478136	-0.2	3
i1.21	156.0452	-1.0614799261	6.023620	6.024724	-13.370574	-0.2	3
i1.21	157.11995	-1.0344517231	6.024724	6.023486	-13.280277	-0.2	3
i1.21	158.1947	-1.0733857155	6.023486	6.025086	-13.180538	-0.2	3
i1.21	159.26944	-1.0532771349	6.025086	6.024952	-13.075427	-0.2	3
i1.21	160.3442	-1.0528248549	6.024952	6.024754	-12.984055	-0.2	3
i1.21	161.41895	-1.0716325045	6.024754	6.024938	-13.079099	-0.2	3
i1.21	162.49368	-1.0679506063	6.024938	6.023785	-13.174211	-0.2	3
i1.21	163.56844	-1.0727701187	6.023785	6.023891	-13.267301	-0.2	3
i1.21	164.64319	-1.0504221916	6.023891	6.023990	-13.367799	-0.2	3
i1.21	165.71794	-1.0709707737	6.023990	6.024815	-13.477112	-0.2	3
i1.21	166.7927	-1.0382561684	6.024815	6.024605	-13.569685	-0.2	3
i1.21	167.86743	-1.0419788361	6.024605	6.023824	-13.681348	-0.2	3
i1.21	168.94218	-1.0733921528	6.023824	6.023727	-13.77914	-0.2	3
i1.21	170.01694	-1.0356975794	6.023727	6.022685	-13.889056	-0.2	3
i1.21	171.09167	-1.0376204252	6.022685	6.022408	-13.971913	-0.2	3
i1.21	172.16643	-1.0621191263	6.022408	6.022556	-14.084853	-0.2	3
i1.21	173.24118	-1.0645418167	6.022556	6.022046	-14.175129	-0.2	3
i1.21	174.31592	-1.0475409031	6.022046	6.021810	-14.280664	-0.2	3
i1.21	175.39069	-1.0341113806	6.021810	6.021542	-14.366448	-0.2	3
i1.21	176.46542	-1.0382014513	6.021542	6.021066	-14.481839	-0.2	3
i1.21	177.54018	-1.0471689701	6.021066	6.021230	-14.573174	-0.2	3
i1.21	178.61493	-1.0582284927	6.021230	6.020809	-14.66925	-0.2	3
i1.21	179.68967	-1.0645492077	6.020809	6.020718	-14.768646	-0.2	3
i1.21	180.76442	1.0464291573	6.020718	6.020313	-14.87031	-0.2	3
i1.22	138.83481	-1.0407428741	6.020064	6.020064	-14.972434	-0.15	3
i1.22	139.90993	-1.0637561083	6.020064	6.020373	-14.871041	-0.15	3
i1.22	140.98503	-1.0324521065	6.020373	6.020471	-14.777255	-0.15	3
i1.22	142.06013	-1.0451905727	6.020471	6.021008	-14.679026	-0.15	3
i1.22	143.13525	-1.0464377403	6.021008	6.020919	-14.57644	-0.15	3
i1.22	144.21036	-1.0599420071	6.020919	6.021720	-14.468681	-0.15	3
i1.22	145.28546	-1.0646613836	6.021720	6.021083	-14.373892	-0.15	3
i1.22	146.36058	-1.0709825754	6.021083	6.022095	-14.279488	-0.15	3
i1.22	147.43568	-1.0643821955	6.022095	6.021657	-14.174011	-0.15	3
i1.22	148.51079	-1.0560262203	6.021657	6.022132	-14.075127	-0.15	3
i1.22	149.5859	-1.0321938992	6.022132	6.022326	-13.964864	-0.15	3
i1.22	150.66101	-1.0690507889	6.022326	6.023658	-13.880956	-0.15	3
i1.22	151.73613	-1.0436416864	6.023658	6.024119	-13.784858	-0.15	3
i1.22	152.81123	-1.0468051434	6.024119	6.023126	-13.674434	-0.15	3
i1.22	153.88634	-1.0626969337	6.023126	6.023207	-13.569669	-0.15	3
i1.22	154.96146	-1.0323330164	6.023207	6.022155	-13.485783	-0.15	3
i1.22	156.03656	-1.0731267929	6.022155	6.024315	-13.381949	-0.15	3
i1.22	157.11166	-1.0602596998	6.024315	6.024330	-13.271517	-0.15	3
i1.22	158.18678	-1.0577104092	6.024330	6.025134	-13.175559	-0.15	3
i1.22	159.26189	-1.0400830507	6.025134	6.025156	-13.078203	-0.15	3
i1.22	160.33699	-1.0735635757	6.025156	6.024817	-12.977461	-0.15	3
i1.22	161.4121	-1.0621659756	6.024817	6.026365	-13.078175	-0.15	3
i1.22	162.48721	-1.0450260639	6.026365	6.024490	-13.169324	-0.15	3
i1.22	163.56232	-1.0384480953	6.024490	6.023452	-13.283945	-0.15	3
i1.22	164.63744	-1.0594441891	6.023452	6.025042	-13.373721	-0.15	3
i1.22	165.71254	-1.0594220161	6.025042	6.023907	-13.474834	-0.15	3
i1.22	166.78764	-1.0611515045	6.023907	6.022913	-13.578196	-0.15	3
i1.22	167.86276	-1.0677700043	6.022913	6.022572	-13.669958	-0.15	3
i1.22	168.93787	-1.0430312157	6.022572	6.023354	-13.782238	-0.15	3
i1.22	170.01297	-1.063175559	6.023354	6.022598	-13.87069	-0.15	3
i1.22	171.08809	-1.0403428078	6.022598	6.022304	-13.984252	-0.15	3
i1.22	172.1632	-1.0646370649	6.022304	6.022244	-14.07085	-0.15	3
i1.22	173.2383	-1.0686205626	6.022244	6.021770	-14.174591	-0.15	3
i1.22	174.31342	-1.0465341806	6.021770	6.021496	-14.271363	-0.15	3
i1.22	175.38852	-1.0592935085	6.021496	6.021367	-14.379646	-0.15	3
i1.22	176.46362	-1.0654033422	6.021367	6.021488	-14.474192	-0.15	3
i1.22	177.53874	-1.0437442064	6.021488	6.020950	-14.576048	-0.15	3
i1.22	178.61385	-1.0631788969	6.020950	6.020924	-14.675886	-0.15	3
i1.22	179.68896	-1.0611900091	6.020924	6.020459	-14.774811	-0.15	3
i1.22	180.76407	1.0345393419	6.020459	6.020242	-14.881494	-0.15	3
i1.23	138.84802	-1.0510870218	6.020049	6.020049	-14.975994	-0.1	3
i1.23	139.9228	-1.0564041138	6.020049	6.020400	-14.8727	-0.1	3
i1.23	140.99757	-1.0436176062	6.020400	6.020485	-14.771474	-0.1	3
i1.23	142.07236	-1.0708043575	6.020485	6.020672	-14.680348	-0.1	3
i1.23	143.14714	-1.0717161894	6.020672	6.021033	-14.573088	-0.1	3
i1.23	144.22192	-1.03741014	6.021033	6.021527	-14.472684	-0.1	3
i1.23	145.29669	-1.035431385	6.021527	6.021521	-14.365037	-0.1	3
i1.23	146.37148	-1.0465804338	6.021521	6.021767	-14.286348	-0.1	3
i1.23	147.44626	-1.0443003178	6.021767	6.022030	-14.168947	-0.1	3
i1.23	148.52103	-1.0414276123	6.022030	6.022051	-14.078243	-0.1	3
i1.23	149.59581	-1.0724470615	6.022051	6.022040	-13.970062	-0.1	3
i1.23	150.6706	-1.0676437616	6.022040	6.023219	-13.870216	-0.1	3
i1.23	151.74538	-1.0656218529	6.023219	6.022600	-13.779159	-0.1	3
i1.23	152.82014	-1.0663555861	6.022600	6.022958	-13.672627	-0.1	3
i1.23	153.89493	-1.0409532785	6.022958	6.024414	-13.573811	-0.1	3
i1.23	154.96971	-1.0681728125	6.024414	6.023797	-13.470378	-0.1	3
i1.23	156.04448	-1.035738945	6.023797	6.023675	-13.377578	-0.1	3
i1.23	157.11926	-1.0695619583	6.023675	6.024186	-13.266785	-0.1	3
i1.23	158.19405	-1.0520381927	6.024186	6.024728	-13.169683	-0.1	3
i1.23	159.26883	-1.0703357458	6.024728	6.025672	-13.076513	-0.1	3
i1.23	160.3436	-1.050948143	6.025672	6.026587	-12.975796	-0.1	3
i1.23	161.41838	-1.0333640575	6.026587	6.026296	-13.07881	-0.1	3
i1.23	162.49316	-1.0324845314	6.026296	6.023979	-13.175732	-0.1	3
i1.23	163.56793	-1.0470913649	6.023979	6.024456	-13.279861	-0.1	3
i1.23	164.64272	-1.0526748896	6.024456	6.022806	-13.374857	-0.1	3
i1.23	165.7175	-1.0364514589	6.022806	6.023854	-13.482819	-0.1	3
i1.23	166.79227	-1.0604299307	6.023854	6.022801	-13.575651	-0.1	3
i1.23	167.86705	-1.032615304	6.022801	6.023612	-13.669908	-0.1	3
i1.23	168.94183	-1.0747227669	6.023612	6.023919	-13.774975	-0.1	3
i1.23	170.01662	-1.0357128382	6.023919	6.023109	-13.876077	-0.1	3
i1.23	171.09138	-1.0632066727	6.023109	6.022659	-13.965712	-0.1	3
i1.23	172.16617	-1.0366219282	6.022659	6.022131	-14.07732	-0.1	3
i1.23	173.24094	-1.0478047132	6.022131	6.021968	-14.165567	-0.1	3
i1.23	174.31572	-1.0563852787	6.021968	6.021506	-14.272653	-0.1	3
i1.23	175.3905	-1.0347723961	6.021506	6.021413	-14.369627	-0.1	3
i1.23	176.46529	-1.0482274294	6.021413	6.020980	-14.475426	-0.1	3
i1.23	177.54005	-1.068266511	6.020980	6.020894	-14.57117	-0.1	3
i1.23	178.61484	-1.050732851	6.020894	6.020924	-14.670782	-0.1	3
i1.23	179.6896	-1.0499340296	6.020924	6.020622	-14.775476	-0.1	3
i1.23	180.7644	1.0678915977	6.020622	6.020380	-14.876812	-0.1	3
i1.24	138.8478	-1.0437405109	6.020051	6.020051	-14.97915	-0.05	3
i1.24	139.92258	-1.0341789722	6.020051	6.020284	-14.872285	-0.05	3
i1.24	140.99736	-1.0393270254	6.020284	6.020514	-14.777745	-0.05	3
i1.24	142.07214	-1.0365308523	6.020514	6.020961	-14.671443	-0.05	3
i1.24	143.14693	-1.052464962	6.020961	6.021243	-14.57865	-0.05	3
i1.24	144.22173	-1.050110817	6.021243	6.021105	-14.478611	-0.05	3
i1.24	145.29651	-1.0512930155	6.021105	6.021460	-14.369933	-0.05	3
i1.24	146.37129	-1.0706437826	6.021460	6.022403	-14.272471	-0.05	3
i1.24	147.44608	-1.033842802	6.022403	6.021598	-14.165446	-0.05	3
i1.24	148.52086	-1.0733933449	6.021598	6.022802	-14.0766	-0.05	3
i1.24	149.59564	-1.0346695185	6.022802	6.021651	-13.983191	-0.05	3
i1.24	150.67043	-1.0327308178	6.021651	6.022231	-13.87917	-0.05	3
i1.24	151.74521	-1.0447225571	6.022231	6.022699	-13.772893	-0.05	3
i1.24	152.81999	-1.0352090597	6.022699	6.023256	-13.674265	-0.05	3
i1.24	153.89478	-1.0741428137	6.023256	6.022516	-13.570724	-0.05	3
i1.24	154.96956	-1.0562597513	6.022516	6.022514	-13.474622	-0.05	3
i1.24	156.04434	-1.0718569756	6.022514	6.024864	-13.377223	-0.05	3
i1.24	157.11913	-1.0613042116	6.024864	6.023980	-13.275986	-0.05	3
i1.24	158.19391	-1.0729067326	6.023980	6.024574	-13.179152	-0.05	3
i1.24	159.2687	-1.0430754423	6.024574	6.025548	-13.069699	-0.05	3
i1.24	160.34349	-1.0653421879	6.025548	6.026573	-12.974719	-0.05	3
i1.24	161.41827	-1.0401388407	6.026573	6.024411	-13.07922	-0.05	3
i1.24	162.49306	-1.0664319992	6.024411	6.023729	-13.174866	-0.05	3
i1.24	163.56784	-1.0736479759	6.023729	6.024289	-13.275605	-0.05	3
i1.24	164.64262	-1.0518349409	6.024289	6.024485	-13.377043	-0.05	3
i1.24	165.7174	-1.0401467085	6.024485	6.022807	-13.484122	-0.05	3
i1.24	166.79219	-1.0601125956	6.022807	6.023633	-13.569006	-0.05	3
i1.24	167.86697	-1.0655943155	6.023633	6.023263	-13.679966	-0.05	3
i1.24	168.94176	-1.0717377663	6.023263	6.022742	-13.778524	-0.05	3
i1.24	170.01654	-1.0645899773	6.022742	6.022430	-13.881519	-0.05	3
i1.24	171.09134	-1.0740321875	6.022430	6.022586	-13.97289	-0.05	3
i1.24	172.16612	-1.0706589222	6.022586	6.022074	-14.082305	-0.05	3
i1.24	173.2409	-1.0356029272	6.022074	6.022047	-14.173177	-0.05	3
i1.24	174.31569	-1.0676550865	6.022047	6.021564	-14.27937	-0.05	3
i1.24	175.39047	-1.0469170809	6.021564	6.021539	-14.372623	-0.05	3
i1.24	176.46524	-1.0568976402	6.021539	6.021179	-14.480781	-0.05	3
i1.24	177.54004	-1.0522345304	6.021179	6.021128	-14.575617	-0.05	3
i1.24	178.61482	-1.0735310316	6.021128	6.020611	-14.676599	-0.05	3
i1.24	179.6896	-1.0680757761	6.020611	6.020704	-14.777054	-0.05	3
i1.24	180.76439	1.068908453	6.020704	6.020281	-14.875927	-0.05	3
i1.25	138.84302	-1.0555958748	6.020047	6.020047	-14.976135	0.0	3
i1.25	139.91792	-1.062718153	6.020047	6.020329	-14.876376	0.0	3
i1.25	140.99283	-1.0559971333	6.020329	6.020520	-14.76898	0.0	3
i1.25	142.06773	-1.0495494604	6.020520	6.020655	-14.669789	0.0	3
i1.25	143.14264	-1.0402964354	6.020655	6.021064	-14.567983	0.0	3
i1.25	144.21754	-1.0609200001	6.021064	6.021151	-14.471983	0.0	3
i1.25	145.29245	-1.0491788387	6.021151	6.021844	-14.376472	0.0	3
i1.25	146.36734	-1.0538582802	6.021844	6.021719	-14.274136	0.0	3
i1.25	147.44225	-1.0598626137	6.021719	6.022402	-14.175715	0.0	3
i1.25	148.51715	-1.0468665361	6.022402	6.023099	-14.070446	0.0	3
i1.25	149.59206	-1.0324145555	6.023099	6.021336	-13.987076	0.0	3
i1.25	150.66696	-1.0343537331	6.021336	6.022790	-13.8771	0.0	3
i1.25	151.74187	-1.0426386595	6.022790	6.022642	-13.76465	0.0	3
i1.25	152.81677	-1.0577275753	6.022642	6.022828	-13.670123	0.0	3
i1.25	153.89168	-1.073002696	6.022828	6.024911	-13.572019	0.0	3
i1.25	154.96658	-1.0458298922	6.024911	6.023575	-13.482688	0.0	3
i1.25	156.04149	-1.0739451647	6.023575	6.023958	-13.380889	0.0	3
i1.25	157.11638	-1.0402100086	6.023958	6.024973	-13.277582	0.0	3
i1.25	158.19128	-1.0632835627	6.024973	6.024473	-13.170493	0.0	3
i1.25	159.26619	-1.0515990257	6.024473	6.024328	-13.07357	0.0	3
i1.25	160.3411	-1.0442460775	6.024328	6.024545	-12.977387	0.0	3
i1.25	161.416	-1.0599931479	6.024545	6.023643	-13.080012	0.0	3
i1.25	162.4909	-1.0709676743	6.023643	6.025569	-13.183724	0.0	3
i1.25	163.56581	-1.0365005732	6.025569	6.024687	-13.272744	0.0	3
i1.25	164.64072	-1.0678310394	6.024687	6.022778	-13.383422	0.0	3
i1.25	165.71562	-1.0570083857	6.022778	6.024470	-13.468746	0.0	3
i1.25	166.79053	-1.0362493992	6.024470	6.023417	-13.578455	0.0	3
i1.25	167.86542	-1.0478663445	6.023417	6.023304	-13.677194	0.0	3
i1.25	168.94032	-1.069190383	6.023304	6.022099	-13.776276	0.0	3
i1.25	170.01523	-1.0482811928	6.022099	6.022885	-13.880604	0.0	3
i1.25	171.09013	-1.0514187813	6.022885	6.022215	-13.964673	0.0	3
i1.25	172.16504	-1.038700223	6.022215	6.022055	-14.071137	0.0	3
i1.25	173.23994	-1.0387091637	6.022055	6.022743	-14.171755	0.0	3
i1.25	174.31485	-1.0494765043	6.022743	6.021818	-14.274123	0.0	3
i1.25	175.38974	-1.0684572458	6.021818	6.021638	-14.371273	0.0	3
i1.25	176.46466	-1.0622783899	6.021638	6.021165	-14.472432	0.0	3
i1.25	177.53955	-1.068400979	6.021165	6.020648	-14.575755	0.0	3
i1.25	178.61447	-1.0637549162	6.020648	6.020961	-14.68108	0.0	3
i1.25	179.68936	-1.0364027023	6.020961	6.020683	-14.769171	0.0	3
i1.25	180.76428	1.0412063599	6.020683	6.020305	-14.866103	0.0	3
i1.26	138.87186	-1.0537240505	6.020063	6.020063	-14.979298	0.05	3
i1.26	139.94603	-1.0378226042	6.020063	6.020374	-14.875488	0.05	3
i1.26	141.02022	-1.0320093632	6.020374	6.020412	-14.759398	0.05	3
i1.26	142.0944	-1.0669136047	6.020412	6.020608	-14.677298	0.05	3
i1.26	143.1686	-1.0509139299	6.020608	6.020810	-14.5748	0.05	3
i1.26	144.24277	-1.0475409031	6.020810	6.021091	-14.474428	0.05	3
i1.26	145.31696	-1.0719676018	6.021091	6.021697	-14.37839	0.05	3
i1.26	146.39113	-1.0444780588	6.021697	6.021390	-14.270069	0.05	3
i1.26	147.46532	-1.0523322821	6.021390	6.022507	-14.164129	0.05	3
i1.26	148.5395	-1.0582380295	6.022507	6.022184	-14.073744	0.05	3
i1.26	149.61368	-1.062042594	6.022184	6.021638	-13.977156	0.05	3
i1.26	150.68787	-1.0314884186	6.021638	6.021949	-13.876102	0.05	3
i1.26	151.76205	-1.0562568903	6.021949	6.022892	-13.772711	0.05	3
i1.26	152.83624	-1.0575033426	6.022892	6.024036	-13.666825	0.05	3
i1.26	153.91042	-1.0460292101	6.024036	6.024564	-13.566903	0.05	3
i1.26	154.9846	-1.0421509743	6.024564	6.024266	-13.47068	0.05	3
i1.26	156.05878	-1.0334889889	6.024266	6.025206	-13.370232	0.05	3
i1.26	157.13297	-1.0533553362	6.025206	6.023603	-13.278959	0.05	3
i1.26	158.20715	-1.072009325	6.023603	6.024113	-13.172653	0.05	3
i1.26	159.28133	-1.0656695366	6.024113	6.023513	-13.072579	0.05	3
i1.26	160.35551	-1.0715073347	6.023513	6.025530	-12.981696	0.05	3
i1.26	161.42969	-1.0651606321	6.025530	6.025783	-13.078377	0.05	3
i1.26	162.50388	-1.0457658768	6.025783	6.023953	-13.180286	0.05	3
i1.26	163.57806	-1.0732103586	6.023953	6.024871	-13.274642	0.05	3
i1.26	164.65225	-1.0687963963	6.024871	6.024120	-13.386602	0.05	3
i1.26	165.72643	-1.0730606318	6.024120	6.024191	-13.485832	0.05	3
i1.26	166.80061	-1.04737854	6.024191	6.024338	-13.58272	0.05	3
i1.26	167.8748	-1.0492576361	6.024338	6.023768	-13.674917	0.05	3
i1.26	168.94897	-1.051153779	6.023768	6.022805	-13.766232	0.05	3
i1.26	170.02316	-1.0556461811	6.022805	6.022681	-13.870472	0.05	3
i1.26	171.09735	-1.0707964897	6.022681	6.023268	-13.986252	0.05	3
i1.26	172.17152	-1.0573011637	6.023268	6.021933	-14.080008	0.05	3
i1.26	173.24571	-1.0378338099	6.021933	6.022177	-14.172643	0.05	3
i1.26	174.31989	-1.0728832483	6.022177	6.021460	-14.272516	0.05	3
i1.26	175.39407	-1.0709857941	6.021460	6.021594	-14.385058	0.05	3
i1.26	176.46826	-1.0473719835	6.021594	6.020922	-14.475685	0.05	3
i1.26	177.54245	-1.0676066875	6.020922	6.020790	-14.579563	0.05	3
i1.26	178.61662	-1.0374437571	6.020790	6.020777	-14.674293	0.05	3
i1.26	179.69081	-1.051799655	6.020777	6.020504	-14.766533	0.05	3
i1.26	180.76498	1.0670900345	6.020504	6.020244	-14.872474	0.05	3
i1.27	138.85513	-1.0335508585	6.020045	6.020045	-14.967474	0.1	3
i1.27	139.92975	-1.0603859425	6.020045	6.020303	-14.872847	0.1	3
i1.27	141.00435	-1.0457059145	6.020303	6.020639	-14.780444	0.1	3
i1.27	142.07895	-1.0357671976	6.020639	6.020706	-14.671529	0.1	3
i1.27	143.15355	-1.0494573116	6.020706	6.020999	-14.566034	0.1	3
i1.27	144.22815	-1.0346015692	6.020999	6.021227	-14.467082	0.1	3
i1.27	145.30275	-1.0474940538	6.021227	6.021539	-14.379541	0.1	3
i1.27	146.37735	-1.0601344109	6.021539	6.022237	-14.273175	0.1	3
i1.27	147.45195	-1.0616360903	6.022237	6.021844	-14.169043	0.1	3
i1.27	148.52655	-1.0386713743	6.021844	6.021876	-14.072496	0.1	3
i1.27	149.60115	-1.0355842113	6.021876	6.021688	-13.9749	0.1	3
i1.27	150.67575	-1.0383317471	6.021688	6.021991	-13.874372	0.1	3
i1.27	151.75035	-1.0591011047	6.021991	6.023534	-13.778909	0.1	3
i1.27	152.82495	-1.0604993105	6.023534	6.023543	-13.674227	0.1	3
i1.27	153.89955	-1.053429842	6.023543	6.023447	-13.570344	0.1	3
i1.27	154.97415	-1.0713341236	6.023447	6.024083	-13.47458	0.1	3
i1.27	156.04875	-1.0711889267	6.024083	6.024886	-13.377913	0.1	3
i1.27	157.12335	-1.0570927858	6.024886	6.024285	-13.280495	0.1	3
i1.27	158.19795	-1.0395454168	6.024285	6.024585	-13.167059	0.1	3
i1.27	159.27255	-1.0691915751	6.024585	6.025070	-13.070356	0.1	3
i1.27	160.34715	-1.042861104	6.025070	6.025228	-12.977827	0.1	3
i1.27	161.42175	-1.0392497778	6.025228	6.024253	-13.073361	0.1	3
i1.27	162.49637	-1.0743464231	6.024253	6.023244	-13.173753	0.1	3
i1.27	163.57097	-1.0324271917	6.023244	6.024650	-13.277208	0.1	3
i1.27	164.64557	-1.0731025934	6.024650	6.024497	-13.374642	0.1	3
i1.27	165.72017	-1.0484271049	6.024497	6.023807	-13.479203	0.1	3
i1.27	166.79477	-1.0510852337	6.023807	6.023384	-13.57814	0.1	3
i1.27	167.86937	-1.0424245596	6.023384	6.023713	-13.673873	0.1	3
i1.27	168.94397	-1.0348087549	6.023713	6.022858	-13.776139	0.1	3
i1.27	170.01857	-1.0440140963	6.022858	6.022485	-13.870475	0.1	3
i1.27	171.09317	-1.0361428261	6.022485	6.022842	-13.971431	0.1	3
i1.27	172.16777	-1.045199275	6.022842	6.022323	-14.07645	0.1	3
i1.27	173.24237	-1.0693651438	6.022323	6.022235	-14.177117	0.1	3
i1.27	174.31697	-1.0555161238	6.022235	6.021739	-14.278612	0.1	3
i1.27	175.39157	-1.0693945885	6.021739	6.021572	-14.376787	0.1	3
i1.27	176.46617	-1.0367039442	6.021572	6.020773	-14.477573	0.1	3
i1.27	177.54077	-1.063038826	6.020773	6.020908	-14.56938	0.1	3
i1.27	178.61537	-1.0634161234	6.020908	6.020857	-14.678358	0.1	3
i1.27	179.68997	-1.036831975	6.020857	6.020521	-14.775283	0.1	3
i1.27	180.76457	1.0599923134	6.020521	6.020356	-14.874193	0.1	3
i1.28	138.86879	-1.052965045	6.020051	6.020051	-14.974813	0.15	3
i1.28	139.94304	-1.0450284481	6.020051	6.020307	-14.885823	0.15	3
i1.28	141.0173	-1.0378475189	6.020307	6.020699	-14.78272	0.15	3
i1.28	142.09157	-1.0553450584	6.020699	6.020607	-14.671771	0.15	3
i1.28	143.16583	-1.0541772842	6.020607	6.021369	-14.574787	0.15	3
i1.28	144.24008	-1.0367457867	6.021369	6.021164	-14.467911	0.15	3
i1.28	145.31435	-1.0724722147	6.021164	6.021506	-14.378003	0.15	3
i1.28	146.38861	-1.0703189373	6.021506	6.021867	-14.262064	0.15	3
i1.28	147.46286	-1.0592659712	6.021867	6.021895	-14.17373	0.15	3
i1.28	148.53712	-1.0418907404	6.021895	6.022412	-14.081632	0.15	3
i1.28	149.61139	-1.0688134432	6.022412	6.023172	-13.978058	0.15	3
i1.28	150.68564	-1.061322093	6.023172	6.022827	-13.865138	0.15	3
i1.28	151.7599	-1.045922637	6.022827	6.022123	-13.767095	0.15	3
i1.28	152.83417	-1.0425132513	6.022123	6.023711	-13.679714	0.15	3
i1.28	153.90842	-1.0349903107	6.023711	6.023463	-13.573183	0.15	3
i1.28	154.98268	-1.0582299232	6.023463	6.023439	-13.468301	0.15	3
i1.28	156.05695	-1.0340389013	6.023439	6.022505	-13.375725	0.15	3
i1.28	157.1312	-1.0467252731	6.022505	6.023752	-13.274325	0.15	3
i1.28	158.20546	-1.0570862293	6.023752	6.024252	-13.176548	0.15	3
i1.28	159.27972	-1.0462414026	6.024252	6.023413	-13.07549	0.15	3
i1.28	160.35397	-1.0730694532	6.023413	6.023954	-12.975608	0.15	3
i1.28	161.42824	-1.0339310169	6.023954	6.025143	-13.069025	0.15	3
i1.28	162.5025	-1.0554209948	6.025143	6.024905	-13.177227	0.15	3
i1.28	163.57675	-1.073307395	6.024905	6.023971	-13.274181	0.15	3
i1.28	164.65102	-1.0463184118	6.023971	6.022697	-13.379795	0.15	3
i1.28	165.72528	-1.0729999542	6.022697	6.023812	-13.474	0.15	3
i1.28	166.79953	-1.0555477142	6.023812	6.023625	-13.584797	0.15	3
i1.28	167.8738	-1.0346939564	6.023625	6.022864	-13.683006	0.15	3
i1.28	168.94806	-1.0623878241	6.022864	6.022789	-13.7781	0.15	3
i1.28	170.02231	-1.0321618319	6.022789	6.022833	-13.878427	0.15	3
i1.28	171.09657	-1.0592353344	6.022833	6.022053	-13.970808	0.15	3
i1.28	172.17084	-1.0514221191	6.022053	6.022674	-14.067276	0.15	3
i1.28	173.24509	-1.0486563444	6.022674	6.022084	-14.178342	0.15	3
i1.28	174.31935	-1.0666329861	6.022084	6.021693	-14.266512	0.15	3
i1.28	175.39362	-1.0732722282	6.021693	6.021433	-14.38728	0.15	3
i1.28	176.46786	-1.0725772381	6.021433	6.021595	-14.480885	0.15	3
i1.28	177.54213	-1.058121562	6.021595	6.020969	-14.573775	0.15	3
i1.28	178.6164	-1.0729694366	6.020969	6.020656	-14.670043	0.15	3
i1.28	179.69066	-1.0458461046	6.020656	6.020469	-14.770762	0.15	3
i1.28	180.76491	1.0643315315	6.020469	6.020347	-14.874808	0.15	3
i1.29	138.86676	-1.0320587158	6.020050	6.020050	-14.977278	0.2	3
i1.29	139.94107	-1.0382561684	6.020050	6.020308	-14.861731	0.2	3
i1.29	141.01538	-1.0599998236	6.020308	6.020611	-14.768199	0.2	3
i1.29	142.08969	-1.0700982809	6.020611	6.020669	-14.669632	0.2	3
i1.29	143.164	-1.0329245329	6.020669	6.021288	-14.579779	0.2	3
i1.29	144.23831	-1.0565673113	6.021288	6.021400	-14.4693	0.2	3
i1.29	145.31262	-1.0499638319	6.021400	6.021384	-14.377695	0.2	3
i1.29	146.38693	-1.0583367348	6.021384	6.021996	-14.267762	0.2	3
i1.29	147.46124	-1.0695174932	6.021996	6.021855	-14.16988	0.2	3
i1.29	148.53555	-1.0739908218	6.021855	6.022923	-14.070144	0.2	3
i1.29	149.60986	-1.0471355915	6.022923	6.022942	-13.968881	0.2	3
i1.29	150.68417	-1.0383150578	6.022942	6.022786	-13.871594	0.2	3
i1.29	151.75848	-1.0621880293	6.022786	6.023319	-13.781165	0.2	3
i1.29	152.8328	-1.0432825089	6.023319	6.023934	-13.675601	0.2	3
i1.29	153.9071	-1.0636492968	6.023934	6.021549	-13.577064	0.2	3
i1.29	154.98141	-1.0692138672	6.021549	6.023928	-13.471585	0.2	3
i1.29	156.05573	-1.0497447252	6.023928	6.023118	-13.378361	0.2	3
i1.29	157.13004	-1.0390638113	6.023118	6.025380	-13.278353	0.2	3
i1.29	158.20435	-1.0612508059	6.025380	6.024397	-13.167861	0.2	3
i1.29	159.27866	-1.0432879925	6.024397	6.025495	-13.086096	0.2	3
i1.29	160.35297	-1.0552812815	6.025495	6.024390	-12.977034	0.2	3
i1.29	161.42728	-1.035525322	6.024390	6.024810	-13.086083	0.2	3
i1.29	162.50159	-1.0618495941	6.024810	6.023553	-13.178712	0.2	3
i1.29	163.5759	-1.0736960173	6.023553	6.023161	-13.282291	0.2	3
i1.29	164.6502	-1.0403857231	6.023161	6.023894	-13.376152	0.2	3
i1.29	165.72452	-1.0676988363	6.023894	6.023898	-13.472567	0.2	3
i1.29	166.79883	-1.0398465395	6.023898	6.022984	-13.583099	0.2	3
i1.29	167.87314	-1.0670176744	6.022984	6.022053	-13.67343	0.2	3
i1.29	168.94745	-1.0520020723	6.022053	6.022841	-13.784155	0.2	3
i1.29	170.02176	-1.0612148046	6.022841	6.022874	-13.882038	0.2	3
i1.29	171.09607	-1.0601565838	6.022874	6.022335	-13.970521	0.2	3
i1.29	172.17038	-1.0379487276	6.022335	6.022860	-14.083195	0.2	3
i1.29	173.24469	-1.0493035316	6.022860	6.022342	-14.181911	0.2	3
i1.29	174.319	-1.0477236509	6.022342	6.022136	-14.280881	0.2	3
i1.29	175.39331	-1.0674538612	6.022136	6.021564	-14.381304	0.2	3
i1.29	176.46762	-1.0320631266	6.021564	6.021136	-14.469472	0.2	3
i1.29	177.54193	-1.0536835194	6.021136	6.021171	-14.582136	0.2	3
i1.29	178.61624	-1.0326744318	6.021171	6.020594	-14.674323	0.2	3
i1.29	179.69055	-1.0700122118	6.020594	6.020481	-14.772095	0.2	3
i1.29	180.76486	1.065657258	6.020481	6.020240	-14.878743	0.2	3
i1.30	138.84282	-1.0385040045	6.020042	6.020042	-14.964512	0.25	3
i1.30	139.91772	-1.0321390629	6.020042	6.020319	-14.878535	0.25	3
i1.30	140.99263	-1.0583170652	6.020319	6.020686	-14.767315	0.25	3
i1.30	142.06755	-1.0560626984	6.020686	6.020889	-14.672687	0.25	3
i1.30	143.14246	-1.0474463701	6.020889	6.020949	-14.573201	0.25	3
i1.30	144.21736	-1.0693905354	6.020949	6.020971	-14.477356	0.25	3
i1.30	145.29227	-1.0325152874	6.020971	6.022375	-14.377746	0.25	3
i1.30	146.36717	-1.0354231596	6.022375	6.021204	-14.276989	0.25	3
i1.30	147.4421	-1.0345660448	6.021204	6.022091	-14.174654	0.25	3
i1.30	148.517	-1.0645543337	6.022091	6.022750	-14.058824	0.25	3
i1.30	149.5919	-1.0514497757	6.022750	6.022388	-13.971132	0.25	3
i1.30	150.66681	-1.0685973167	6.022388	6.023101	-13.881183	0.25	3
i1.30	151.74173	-1.0658944845	6.023101	6.023568	-13.770809	0.25	3
i1.30	152.81664	-1.0340188742	6.023568	6.023712	-13.674498	0.25	3
i1.30	153.89154	-1.054754138	6.023712	6.024216	-13.571913	0.25	3
i1.30	154.96646	-1.0725069046	6.024216	6.023447	-13.468684	0.25	3
i1.30	156.04135	-1.0718172789	6.023447	6.024336	-13.37221	0.25	3
i1.30	157.11627	-1.0659564734	6.024336	6.024975	-13.275219	0.25	3
i1.30	158.19118	-1.0367194414	6.024975	6.024798	-13.168613	0.25	3
i1.30	159.26608	-1.0563480854	6.024798	6.024210	-13.085202	0.25	3
i1.30	160.341	-1.0667715073	6.024210	6.023026	-12.974797	0.25	3
i1.30	161.41591	-1.0684851408	6.023026	6.025267	-13.082247	0.25	3
i1.30	162.49081	-1.0619575977	6.025267	6.025536	-13.180426	0.25	3
i1.30	163.56572	-1.0535750389	6.025536	6.024313	-13.274411	0.25	3
i1.30	164.64062	-1.0392626524	6.024313	6.023788	-13.366858	0.25	3
i1.30	165.71555	-1.0411045551	6.023788	6.024978	-13.474884	0.25	3
i1.30	166.79045	-1.0373456478	6.024978	6.023772	-13.574158	0.25	3
i1.30	167.86536	-1.0624393225	6.023772	6.023661	-13.679635	0.25	3
i1.30	168.94026	-1.0665490627	6.023661	6.022232	-13.77385	0.25	3
i1.30	170.01518	-1.0580130816	6.022232	6.022563	-13.877549	0.25	3
i1.30	171.09009	-1.0364898443	6.022563	6.023801	-13.969154	0.25	3
i1.30	172.165	-1.0577355623	6.023801	6.021774	-14.075809	0.25	3
i1.30	173.2399	-1.0629351139	6.021774	6.021756	-14.171063	0.25	3
i1.30	174.31482	-1.0529836416	6.021756	6.022356	-14.282335	0.25	3
i1.30	175.38972	-1.0581341982	6.022356	6.021562	-14.376649	0.25	3
i1.30	176.46463	-1.069162488	6.021562	6.021277	-14.473777	0.25	3
i1.30	177.53954	-1.0472198725	6.021277	6.021060	-14.571635	0.25	3
i1.30	178.61444	-1.0403926373	6.021060	6.020771	-14.670896	0.25	3
i1.30	179.68936	-1.0328109264	6.020771	6.020558	-14.769799	0.25	3
i1.30	180.76427	1.0488495827	6.020558	6.020314	-14.873369	0.25	3
i1.31	138.84354	-1.0489451885	6.020059	6.020059	-14.969995	0.3	3
i1.31	139.91843	-1.0462015867	6.020059	6.020277	-14.873545	0.3	3
i1.31	140.99332	-1.0475635529	6.020277	6.020423	-14.781561	0.3	3
i1.31	142.0682	-1.0711063147	6.020423	6.020852	-14.669704	0.3	3
i1.31	143.14311	-1.0676246881	6.020852	6.020957	-14.569048	0.3	3
i1.31	144.21799	-1.0495938063	6.020957	6.021019	-14.471408	0.3	3
i1.31	145.29288	-1.0625962019	6.021019	6.021234	-14.376731	0.3	3
i1.31	146.36778	-1.0432873964	6.021234	6.021785	-14.272139	0.3	3
i1.31	147.44266	-1.0694202185	6.021785	6.021806	-14.176204	0.3	3
i1.31	148.51756	-1.0626419783	6.021806	6.021386	-14.087015	0.3	3
i1.31	149.59245	-1.0541862249	6.021386	6.022555	-13.972834	0.3	3
i1.31	150.66734	-1.0664587021	6.022555	6.022828	-13.881026	0.3	3
i1.31	151.74223	-1.0688537359	6.022828	6.021985	-13.777984	0.3	3
i1.31	152.81712	-1.0743194818	6.021985	6.023952	-13.680695	0.3	3
i1.31	153.89201	-1.0710157156	6.023952	6.023784	-13.563041	0.3	3
i1.31	154.9669	-1.0694373846	6.023784	6.022997	-13.477424	0.3	3
i1.31	156.0418	-1.0695887804	6.022997	6.024279	-13.371022	0.3	3
i1.31	157.11668	-1.0512712002	6.024279	6.024747	-13.278467	0.3	3
i1.31	158.19157	-1.0667088032	6.024747	6.024391	-13.17421	0.3	3
i1.31	159.26646	-1.0527415276	6.024391	6.023217	-13.07235	0.3	3
i1.31	160.34135	-1.0687861443	6.023217	6.025525	-12.975628	0.3	3
i1.31	161.41624	-1.0746952295	6.025525	6.024440	-13.080046	0.3	3
i1.31	162.49113	-1.0376743078	6.024440	6.025215	-13.177622	0.3	3
i1.31	163.56602	-1.0541661978	6.025215	6.023591	-13.263983	0.3	3
i1.31	164.64093	-1.0385721922	6.023591	6.023640	-13.376365	0.3	3
i1.31	165.7158	-1.0375488997	6.023640	6.024386	-13.48002	0.3	3
i1.31	166.79071	-1.0712541342	6.024386	6.023204	-13.572942	0.3	3
i1.31	167.8656	-1.0604566336	6.023204	6.023184	-13.671517	0.3	3
i1.31	168.94049	-1.0718567371	6.023184	6.022780	-13.774723	0.3	3
i1.31	170.01538	-1.0498349667	6.022780	6.023075	-13.877249	0.3	3
i1.31	171.09027	-1.0336129665	6.023075	6.022591	-13.97345	0.3	3
i1.31	172.16516	-1.0676989555	6.022591	6.022308	-14.069776	0.3	3
i1.31	173.24005	-1.0417535305	6.022308	6.022487	-14.18159	0.3	3
i1.31	174.31494	-1.0565071106	6.022487	6.021794	-14.268824	0.3	3
i1.31	175.38983	-1.0459603071	6.021794	6.021617	-14.371729	0.3	3
i1.31	176.46472	-1.0370720625	6.021617	6.021719	-14.473848	0.3	3
i1.31	177.53961	-1.0691525936	6.021719	6.021080	-14.58321	0.3	3
i1.31	178.6145	-1.0542184114	6.021080	6.020740	-14.67511	0.3	3
i1.31	179.68939	-1.0686718225	6.020740	6.020352	-14.777224	0.3	3
i1.31	180.76428	1.0674347878	6.020352	6.020249	-14.881256	0.3	3
i1.20	181.92644	-2.6577892303	6.010046	6.010046	-15.974262	-0.25	3
i1.20	184.60347	-2.6118276119	6.010046	6.010431	-15.867096	-0.25	3
i1.20	187.2805	-2.6604020596	6.010431	6.010446	-15.773815	-0.25	3
i1.20	189.95755	-2.6002011299	6.010446	6.010653	-15.675204	-0.25	3
i1.20	192.63458	-2.6269490719	6.010653	6.010982	-15.569188	-0.25	3
i1.20	195.31161	-2.6270618439	6.010982	6.011155	-15.472399	-0.25	3
i1.20	197.98865	-2.6616430283	6.011155	6.011229	-15.379994	-0.25	3
i1.20	200.66568	-2.6671521664	6.011229	6.011753	-15.271869	-0.25	3
i1.20	203.34273	-2.6376535892	6.011753	6.012890	-15.167019	-0.25	3
i1.20	206.01976	-2.6047582626	6.012890	6.012623	-15.069586	-0.25	3
i1.20	208.69681	-2.6131420135	6.012623	6.012620	-14.972278	-0.25	3
i1.20	211.37384	-2.5869042873	6.012620	6.012034	-14.867362	-0.25	3
i1.20	214.05087	-2.5810976028	6.012034	6.013493	-14.774622	-0.25	3
i1.20	216.7279	-2.6156795025	6.013493	6.013604	-14.672828	-0.25	3
i1.20	219.40494	-2.6696622372	6.013604	6.012288	-14.573624	-0.25	3
i1.20	222.08199	-2.5738887787	6.012288	6.012588	-14.472018	-0.25	3
i1.20	224.75902	-2.6371684074	6.012588	6.014799	-14.377203	-0.25	3
i1.20	227.43605	-2.6743342876	6.014799	6.015005	-14.268173	-0.25	3
i1.20	230.11308	-2.6446325779	6.015005	6.014661	-14.162338	-0.25	3
i1.20	232.79013	-2.6696231365	6.014661	6.012795	-14.083541	-0.25	3
i1.20	235.46716	-2.5959675312	6.012795	6.014506	-13.983282	-0.25	3
i1.20	238.1442	-2.6107313633	6.014506	6.014424	-14.074726	-0.25	3
i1.20	240.82123	-2.5825784206	6.014424	6.015881	-14.178798	-0.25	3
i1.20	243.49826	-2.625	6.015881	6.014011	-14.28032	-0.25	3
i1.20	246.17531	-2.6392767429	6.014011	6.014326	-14.379422	-0.25	3
i1.20	248.85236	-2.5718729496	6.014326	6.012201	-14.470963	-0.25	3
i1.20	251.52939	-2.5930178165	6.012201	6.013606	-14.569724	-0.25	3
i1.20	254.2064	-2.5891931057	6.013606	6.014188	-14.674581	-0.25	3
i1.20	256.88345	-2.6600902081	6.014188	6.014180	-14.775984	-0.25	3
i1.20	259.5605	-2.6349337101	6.014180	6.012627	-14.880991	-0.25	3
i1.20	262.23752	-2.5933077335	6.012627	6.013701	-14.972917	-0.25	3
i1.20	264.91455	-2.6253023148	6.013701	6.012095	-15.072858	-0.25	3
i1.20	267.5916	-2.6214489937	6.012095	6.011622	-15.18442	-0.25	3
i1.20	270.26862	-2.6464343071	6.011622	6.011316	-16.780185	-0.25	3
i1.20	272.94568	-2.6572363377	6.011316	6.011127	-18.37717	-0.25	3
i1.20	275.6227	-2.5877420902	6.011127	6.010883	-19.974122	-0.25	3
i1.20	278.29974	-2.604937315	6.010883	6.011369	-21.580773	-0.25	3
i1.20	280.97678	-2.6279599667	6.011369	6.010760	-23.176853	-0.25	3
i1.20	283.6538	-2.6757726669	6.010760	6.010490	-24.770362	-0.25	3
i1.20	286.33087	2.6654415131	6.010490	6.010288	-26.379181	-0.25	3
i1.21	181.86021	-2.58355546	6.010047	6.010047	-15.971711	-0.2	3
i1.21	184.5389	-2.6531779766	6.010047	6.010255	-15.881731	-0.2	3
i1.21	187.21759	-2.6262900829	6.010255	6.010437	-15.771571	-0.2	3
i1.21	189.89629	-2.6597266197	6.010437	6.010605	-15.669041	-0.2	3
i1.21	192.57497	-2.6210794449	6.010605	6.010781	-15.583126	-0.2	3
i1.21	195.25366	-2.6511471272	6.010781	6.011670	-15.477852	-0.2	3
i1.21	197.93236	-2.6251244545	6.011670	6.011654	-15.368644	-0.2	3
i1.21	200.61105	-2.6292891502	6.011654	6.012180	-15.275521	-0.2	3
i1.21	203.28973	-2.6624133587	6.012180	6.012309	-15.176693	-0.2	3
i1.21	205.96844	-2.6204390526	6.012309	6.012065	-15.08309	-0.2	3
i1.21	208.64713	-2.6568312645	6.012065	6.012147	-14.967869	-0.2	3
i1.21	211.32582	-2.5893266201	6.012147	6.012835	-14.871599	-0.2	3
i1.21	214.0045	-2.6401891708	6.012835	6.014004	-14.771744	-0.2	3
i1.21	216.6832	-2.5816400051	6.014004	6.012682	-14.675655	-0.2	3
i1.21	219.3619	-2.645200491	6.012682	6.013968	-14.579349	-0.2	3
i1.21	222.04059	-2.6768929958	6.013968	6.012831	-14.479078	-0.2	3
i1.21	224.71928	-2.6043777466	6.012831	6.014471	-14.370966	-0.2	3
i1.21	227.39796	-2.6378047466	6.014471	6.013335	-14.274543	-0.2	3
i1.21	230.07666	-2.6257226467	6.013335	6.013573	-14.173552	-0.2	3
i1.21	232.75536	-2.5985853672	6.013573	6.015551	-14.076584	-0.2	3
i1.21	235.43405	-2.6387784481	6.015551	6.015064	-13.966914	-0.2	3
i1.21	238.11273	-2.6194581985	6.015064	6.014240	-14.074194	-0.2	3
i1.21	240.79144	-2.5786297321	6.014240	6.013783	-14.172686	-0.2	3
i1.21	243.47012	-2.6636323929	6.013783	6.014286	-14.276087	-0.2	3
i1.21	246.1488	-2.5988893509	6.014286	6.014002	-14.373987	-0.2	3
i1.21	248.8275	-2.6471436024	6.014002	6.013527	-14.471123	-0.2	3
i1.21	251.5062	-2.6546680927	6.013527	6.011157	-14.570557	-0.2	3
i1.21	254.18489	-2.6500525475	6.011157	6.012567	-14.677168	-0.2	3
i1.21	256.8636	-2.6183333397	6.012567	6.012313	-14.767495	-0.2	3
i1.21	259.54227	-2.6016223431	6.012313	6.011986	-14.872578	-0.2	3
i1.21	262.22098	-2.6210975647	6.011986	6.012845	-14.974063	-0.2	3
i1.21	264.89966	-2.6112587452	6.012845	6.012007	-15.07161	-0.2	3
i1.21	267.57837	-2.6649301052	6.012007	6.012278	-15.171973	-0.2	3
i1.21	270.25705	-2.6204633713	6.012278	6.012206	-16.779215	-0.2	3
i1.21	272.93573	-2.609048605	6.012206	6.011716	-18.382874	-0.2	3
i1.21	275.6144	-2.6711006165	6.011716	6.010879	-19.98694	-0.2	3
i1.21	278.29312	-2.5723130703	6.010879	6.010955	-21.576535	-0.2	3
i1.21	280.9718	-2.6125917435	6.010955	6.010872	-23.181846	-0.2	3
i1.21	283.6505	-2.6431369781	6.010872	6.010377	-24.773378	-0.2	3
i1.21	286.3292	2.670801878	6.010377	6.010368	-26.368744	-0.2	3
i1.22	181.87213	-2.6622827053	6.010036	6.010036	-15.969434	-0.15	3
i1.22	184.5505	-2.5995130539	6.010036	6.010230	-15.871402	-0.15	3
i1.22	187.22891	-2.5769166946	6.010230	6.010669	-15.772038	-0.15	3
i1.22	189.9073	-2.6081213951	6.010669	6.011096	-15.674661	-0.15	3
i1.22	192.58571	-2.5752694607	6.011096	6.011473	-15.574406	-0.15	3
i1.22	195.26408	-2.6372385025	6.011473	6.011712	-15.479342	-0.15	3
i1.22	197.94249	-2.5931756496	6.011712	6.011501	-15.383708	-0.15	3
i1.22	200.62088	-2.6174013615	6.011501	6.011538	-15.275881	-0.15	3
i1.22	203.29929	-2.6033329964	6.011538	6.011874	-15.177983	-0.15	3
i1.22	205.97766	-2.6541616917	6.011874	6.011894	-15.080215	-0.15	3
i1.22	208.65607	-2.6311311722	6.011894	6.013178	-14.971982	-0.15	3
i1.22	211.33446	-2.6135110855	6.013178	6.012752	-14.873142	-0.15	3
i1.22	214.01285	-2.6476755142	6.012752	6.013024	-14.763759	-0.15	3
i1.22	216.69124	-2.6159186363	6.013024	6.013104	-14.679335	-0.15	3
i1.22	219.36964	-2.6686053276	6.013104	6.014261	-14.572722	-0.15	3
i1.22	222.04803	-2.6707217693	6.014261	6.013089	-14.480167	-0.15	3
i1.22	224.72643	-2.6374659538	6.013089	6.014261	-14.379056	-0.15	3
i1.22	227.40482	-2.6130595207	6.014261	6.014149	-14.266814	-0.15	3
i1.22	230.08322	-2.6710782051	6.014149	6.013423	-14.170891	-0.15	3
i1.22	232.76161	-2.5944287777	6.013423	6.013787	-14.072678	-0.15	3
i1.22	235.44	-2.5898008347	6.013787	6.013891	-13.969283	-0.15	3
i1.22	238.1184	-2.6277630329	6.013891	6.015702	-14.073565	-0.15	3
i1.22	240.79678	-2.6396911144	6.015702	6.013799	-14.178932	-0.15	3
i1.22	243.47519	-2.618032217	6.013799	6.015537	-14.281176	-0.15	3
i1.22	246.1536	-2.6003551483	6.015537	6.013441	-14.368997	-0.15	3
i1.22	248.83197	-2.6741945744	6.013441	6.014521	-14.475737	-0.15	3
i1.22	251.51038	-2.657171011	6.014521	6.014942	-14.570222	-0.15	3
i1.22	254.18875	-2.6263430119	6.014942	6.014202	-14.682305	-0.15	3
i1.22	256.86716	-2.5853757858	6.014202	6.012516	-14.774449	-0.15	3
i1.22	259.54553	-2.6124384403	6.012516	6.013244	-14.871427	-0.15	3
i1.22	262.22394	-2.6300318241	6.013244	6.013166	-14.970694	-0.15	3
i1.22	264.90234	-2.6278719902	6.013166	6.011391	-15.079648	-0.15	3
i1.22	267.58075	-2.622944355	6.011391	6.011879	-15.184963	-0.15	3
i1.22	270.25912	-2.6422591209	6.011879	6.011620	-16.770756	-0.15	3
i1.22	272.9375	-2.6251626015	6.011620	6.012149	-18.376158	-0.15	3
i1.22	275.6159	-2.5796861649	6.012149	6.011305	-19.972445	-0.15	3
i1.22	278.2943	-2.6572773457	6.011305	6.010949	-21.577548	-0.15	3
i1.22	280.9727	-2.6577780247	6.010949	6.010813	-23.176183	-0.15	3
i1.22	283.6511	-2.6264779568	6.010813	6.010546	-24.781203	-0.15	3
i1.22	286.32947	2.57553792	6.010546	6.010313	-26.375429	-0.15	3
i1.23	181.87523	-2.6201169491	6.010054	6.010054	-15.984454	-0.1	3
i1.23	184.55354	-2.6106698513	6.010054	6.010313	-15.86536	-0.1	3
i1.23	187.23186	-2.5750889778	6.010313	6.010612	-15.776115	-0.1	3
i1.23	189.91017	-2.5864465237	6.010612	6.010920	-15.681016	-0.1	3
i1.23	192.58849	-2.631901741	6.010920	6.011126	-15.576744	-0.1	3
i1.23	195.26682	-2.6344642639	6.011126	6.011628	-15.478899	-0.1	3
i1.23	197.94513	-2.6393251419	6.011628	6.011068	-15.36387	-0.1	3
i1.23	200.62344	-2.6708807945	6.011068	6.011907	-15.271903	-0.1	3
i1.23	203.30176	-2.589214325	6.011907	6.011344	-15.168095	-0.1	3
i1.23	205.98007	-2.6097130775	6.011344	6.011379	-15.070347	-0.1	3
i1.23	208.65839	-2.6530427933	6.011379	6.012937	-14.970404	-0.1	3
i1.23	211.3367	-2.6440701485	6.012937	6.012493	-14.875464	-0.1	3
i1.23	214.01501	-2.6711349487	6.012493	6.013259	-14.782853	-0.1	3
i1.23	216.69334	-2.5887658596	6.013259	6.014029	-14.672699	-0.1	3
i1.23	219.37166	-2.5940561295	6.014029	6.014212	-14.580419	-0.1	3
i1.23	222.04997	-2.6376709938	6.014212	6.013153	-14.471816	-0.1	3
i1.23	224.7283	-2.610969305	6.013153	6.014047	-14.37472	-0.1	3
i1.23	227.4066	-2.5742208958	6.014047	6.014687	-14.275278	-0.1	3
i1.23	230.08493	-2.6196660995	6.014687	6.015632	-14.172257	-0.1	3
i1.23	232.76323	-2.5857636929	6.015632	6.014369	-14.066812	-0.1	3
i1.23	235.44156	-2.5727217197	6.014369	6.014492	-13.970068	-0.1	3
i1.23	238.11987	-2.5899446011	6.014492	6.014646	-14.076847	-0.1	3
i1.23	240.79819	-2.6145234108	6.014646	6.014774	-14.165345	-0.1	3
i1.23	243.4765	-2.6012544632	6.014774	6.013979	-14.274817	-0.1	3
i1.23	246.15482	-2.6602058411	6.013979	6.014447	-14.378879	-0.1	3
i1.23	248.83313	-2.6671233177	6.014447	6.012199	-14.48242	-0.1	3
i1.23	251.51144	-2.6176872253	6.012199	6.013692	-14.584021	-0.1	3
i1.23	254.18977	-2.6038651466	6.013692	6.012771	-14.673826	-0.1	3
i1.23	256.8681	-2.6397440434	6.012771	6.012754	-14.769366	-0.1	3
i1.23	259.5464	-2.6297976971	6.012754	6.011962	-14.864621	-0.1	3
i1.23	262.22473	-2.5979478359	6.011962	6.012618	-14.970945	-0.1	3
i1.23	264.90305	-2.5853879452	6.012618	6.011640	-15.074061	-0.1	3
i1.23	267.58136	-2.6518249512	6.011640	6.011811	-15.180347	-0.1	3
i1.23	270.25967	-2.6635994911	6.011811	6.012301	-16.781572	-0.1	3
i1.23	272.938	-2.6688036919	6.012301	6.011815	-18.380634	-0.1	3
i1.23	275.6163	-2.6060860157	6.011815	6.011592	-19.982591	-0.1	3
i1.23	278.29462	-2.6006770134	6.011592	6.011076	-21.59198	-0.1	3
i1.23	280.97293	-2.6211135387	6.011076	6.010701	-23.175041	-0.1	3
i1.23	283.65125	-2.6574029922	6.010701	6.010653	-24.78458	-0.1	3
i1.23	286.3296	2.6433832645	6.010653	6.010228	-26.377655	-0.1	3
i1.24	181.8937	-2.5774590969	6.010054	6.010054	-15.981748	-0.05	3
i1.24	184.57156	-2.6252532005	6.010054	6.010315	-15.87441	-0.05	3
i1.24	187.24942	-2.6441133022	6.010315	6.010512	-15.767029	-0.05	3
i1.24	189.92728	-2.6109621525	6.010512	6.010801	-15.677612	-0.05	3
i1.24	192.60512	-2.671936512	6.010801	6.011100	-15.568699	-0.05	3
i1.24	195.28297	-2.5831887722	6.011100	6.011308	-15.482433	-0.05	3
i1.24	197.96085	-2.585486412	6.011308	6.010957	-15.370028	-0.05	3
i1.24	200.63869	-2.5744788647	6.010957	6.011322	-15.275282	-0.05	3
i1.24	203.31654	-2.6047487259	6.011322	6.011881	-15.173037	-0.05	3
i1.24	205.9944	-2.6100986004	6.011881	6.012539	-15.074888	-0.05	3
i1.24	208.67224	-2.5800449848	6.012539	6.011501	-14.966067	-0.05	3
i1.24	211.3501	-2.6308426857	6.011501	6.012311	-14.875365	-0.05	3
i1.24	214.02797	-2.5809042454	6.012311	6.012285	-14.780634	-0.05	3
i1.24	216.70581	-2.5959858894	6.012285	6.012950	-14.669566	-0.05	3
i1.24	219.38367	-2.6668119431	6.012950	6.012465	-14.574419	-0.05	3
i1.24	222.06152	-2.6674087048	6.012465	6.013385	-14.463969	-0.05	3
i1.24	224.73938	-2.6462402344	6.013385	6.014970	-14.36838	-0.05	3
i1.24	227.41724	-2.668762207	6.014970	6.014912	-14.279795	-0.05	3
i1.24	230.09508	-2.5884904861	6.014912	6.013704	-14.170878	-0.05	3
i1.24	232.77295	-2.5742425919	6.013704	6.016325	-14.070363	-0.05	3
i1.24	235.4508	-2.6583607197	6.016325	6.014437	-13.977181	-0.05	3
i1.24	238.12865	-2.6743509769	6.014437	6.014801	-14.084536	-0.05	3
i1.24	240.8065	-2.6078197956	6.014801	6.014013	-14.175109	-0.05	3
i1.24	243.48436	-2.5999128819	6.014013	6.015120	-14.279322	-0.05	3
i1.24	246.1622	-2.6553168297	6.015120	6.013414	-14.376619	-0.05	3
i1.24	248.84007	-2.6509664059	6.013414	6.013087	-14.476523	-0.05	3
i1.24	251.51793	-2.616502285	6.013087	6.014055	-14.564913	-0.05	3
i1.24	254.19577	-2.6452007294	6.014055	6.013417	-14.678836	-0.05	3
i1.24	256.87363	-2.6074287891	6.013417	6.013060	-14.778503	-0.05	3
i1.24	259.55148	-2.5725872517	6.013060	6.013299	-14.881711	-0.05	3
i1.24	262.22934	-2.6256585121	6.013299	6.012214	-14.971347	-0.05	3
i1.24	264.9072	-2.6334223747	6.012214	6.012567	-15.071818	-0.05	3
i1.24	267.58505	-2.6081852913	6.012567	6.011807	-15.181763	-0.05	3
i1.24	270.2629	-2.6407899857	6.011807	6.012277	-16.781243	-0.05	3
i1.24	272.94077	-2.6551306248	6.012277	6.011449	-18.386462	-0.05	3
i1.24	275.6186	-2.6412591934	6.011449	6.011130	-19.981253	-0.05	3
i1.24	278.29645	-2.6083061695	6.011130	6.011352	-21.579837	-0.05	3
i1.24	280.97433	-2.6442391872	6.011352	6.010714	-23.174832	-0.05	3
i1.24	283.6522	-2.5733575821	6.010714	6.010514	-24.774042	-0.05	3
i1.24	286.33002	2.597537756	6.010514	6.010272	-26.381211	-0.05	3
i1.25	181.86464	-2.6093094349	6.010051	6.010051	-15.9682	0.0	3
i1.25	184.54321	-2.6108074188	6.010051	6.010182	-15.884534	0.0	3
i1.25	187.2218	-2.6207766533	6.010182	6.010530	-15.775814	0.0	3
i1.25	189.90038	-2.6106436253	6.010530	6.010775	-15.668789	0.0	3
i1.25	192.57896	-2.6193053722	6.010775	6.011133	-15.568449	0.0	3
i1.25	195.25754	-2.6534738541	6.011133	6.011266	-15.468082	0.0	3
i1.25	197.93613	-2.6139917374	6.011266	6.011610	-15.372047	0.0	3
i1.25	200.6147	-2.6242074966	6.011610	6.011773	-15.270663	0.0	3
i1.25	203.29329	-2.5843262672	6.011773	6.011666	-15.173202	0.0	3
i1.25	205.97186	-2.6429777145	6.011666	6.011298	-15.075505	0.0	3
i1.25	208.65045	-2.6286356449	6.011298	6.011816	-14.969028	0.0	3
i1.25	211.32904	-2.5848038197	6.011816	6.012952	-14.876852	0.0	3
i1.25	214.00761	-2.5797863007	6.012952	6.013456	-14.782088	0.0	3
i1.25	216.68619	-2.6500439644	6.013456	6.013226	-14.675584	0.0	3
i1.25	219.36478	-2.5940361023	6.013226	6.013477	-14.57325	0.0	3
i1.25	222.04337	-2.619533062	6.013477	6.014679	-14.483136	0.0	3
i1.25	224.72194	-2.677314043	6.014679	6.013615	-14.374324	0.0	3
i1.25	227.40051	-2.6045219898	6.013615	6.013803	-14.285047	0.0	3
i1.25	230.0791	-2.6211295128	6.013803	6.013596	-14.176914	0.0	3
i1.25	232.75769	-2.6520233154	6.013596	6.015500	-14.078077	0.0	3
i1.25	235.43626	-2.6085906029	6.015500	6.015187	-13.979018	0.0	3
i1.25	238.11484	-2.6488637924	6.015187	6.014941	-14.075516	0.0	3
i1.25	240.79343	-2.6158292294	6.014941	6.015141	-14.182205	0.0	3
i1.25	243.472	-2.6526033878	6.015141	6.013630	-14.276742	0.0	3
i1.25	246.15057	-2.5781092644	6.013630	6.014854	-14.380495	0.0	3
i1.25	248.82916	-2.643355608	6.014854	6.014567	-14.468555	0.0	3
i1.25	251.50775	-2.5885975361	6.014567	6.012978	-14.569092	0.0	3
i1.25	254.18633	-2.6486155987	6.012978	6.014022	-14.675084	0.0	3
i1.25	256.8649	-2.6493942738	6.014022	6.013949	-14.765649	0.0	3
i1.25	259.5435	-2.6010527611	6.013949	6.012944	-14.872572	0.0	3
i1.25	262.22208	-2.6475250721	6.012944	6.012547	-14.976816	0.0	3
i1.25	264.90063	-2.6450595856	6.012547	6.012806	-15.06949	0.0	3
i1.25	267.57922	-2.5869047642	6.012806	6.011921	-15.184118	0.0	3
i1.25	270.2578	-2.5874054432	6.011921	6.011239	-16.77077	0.0	3
i1.25	272.9364	-2.6618628502	6.011239	6.011372	-18.378043	0.0	3
i1.25	275.615	-2.589738369	6.011372	6.010801	-19.985283	0.0	3
i1.25	278.29355	-2.6223731041	6.010801	6.011099	-21.577657	0.0	3
i1.25	280.97214	-2.6247804165	6.011099	6.010601	-23.176897	0.0	3
i1.25	283.65073	-2.6596066952	6.010601	6.010646	-24.771925	0.0	3
i1.25	286.3293	2.6584823132	6.010646	6.010435	-26.376286	0.0	3
i1.26	181.89522	-2.6299097538	6.010041	6.010041	-15.974892	0.05	3
i1.26	184.57303	-2.6094486713	6.010041	6.010390	-15.864437	0.05	3
i1.26	187.25085	-2.647875309	6.010390	6.010523	-15.773433	0.05	3
i1.26	189.92867	-2.5921182632	6.010523	6.010652	-15.673546	0.05	3
i1.26	192.60648	-2.5760912895	6.010652	6.010679	-15.571125	0.05	3
i1.26	195.2843	-2.5884749889	6.010679	6.011541	-15.473624	0.05	3
i1.26	197.96211	-2.6299600601	6.011541	6.011428	-15.37419	0.05	3
i1.26	200.63994	-2.6608352661	6.011428	6.011791	-15.266965	0.05	3
i1.26	203.31775	-2.5808610916	6.011791	6.012401	-15.16968	0.05	3
i1.26	205.99556	-2.5742690563	6.012401	6.012163	-15.080209	0.05	3
i1.26	208.67339	-2.6411707401	6.012163	6.012564	-14.969093	0.05	3
i1.26	211.3512	-2.6285891533	6.012564	6.013624	-14.875978	0.05	3
i1.26	214.02902	-2.5895636082	6.013624	6.013489	-14.775835	0.05	3
i1.26	216.70683	-2.6704947948	6.013489	6.012037	-14.671383	0.05	3
i1.26	219.38464	-2.6331977844	6.012037	6.012867	-14.575337	0.05	3
i1.26	222.06247	-2.5999698639	6.012867	6.014297	-14.475188	0.05	3
i1.26	224.7403	-2.6543087959	6.014297	6.015036	-14.36396	0.05	3
i1.26	227.41809	-2.653557539	6.015036	6.015254	-14.270574	0.05	3
i1.26	230.09592	-2.6664419174	6.015254	6.014758	-14.175832	0.05	3
i1.26	232.77374	-2.6703443527	6.014758	6.017094	-14.067114	0.05	3
i1.26	235.45154	-2.6259121895	6.017094	6.015574	-13.976436	0.05	3
i1.26	238.12936	-2.6714706421	6.015574	6.014392	-14.071417	0.05	3
i1.26	240.80717	-2.6150588989	6.014392	6.014581	-14.181939	0.05	3
i1.26	243.485	-2.6544046402	6.014581	6.012476	-14.275382	0.05	3
i1.26	246.16281	-2.630011797	6.012476	6.013945	-14.377514	0.05	3
i1.26	248.84064	-2.5987894535	6.013945	6.013102	-14.478003	0.05	3
i1.26	251.51845	-2.6149349213	6.013102	6.013890	-14.577001	0.05	3
i1.26	254.19627	-2.6393203735	6.013890	6.013110	-14.677414	0.05	3
i1.26	256.87408	-2.6374320984	6.013110	6.013779	-14.780798	0.05	3
i1.26	259.5519	-2.6221375465	6.013779	6.012187	-14.875636	0.05	3
i1.26	262.22974	-2.6282374859	6.012187	6.013699	-14.97798	0.05	3
i1.26	264.90753	-2.6545808315	6.013699	6.012801	-15.066816	0.05	3
i1.26	267.58536	-2.6330504417	6.012801	6.012727	-15.177108	0.05	3
i1.26	270.26318	-2.581799984	6.012727	6.011706	-16.77743	0.05	3
i1.26	272.94098	-2.5969290733	6.011706	6.011820	-18.383733	0.05	3
i1.26	275.6188	-2.577231884	6.011820	6.011377	-19.983602	0.05	3
i1.26	278.29663	-2.6123785973	6.011377	6.011202	-21.574867	0.05	3
i1.26	280.97443	-2.5901083946	6.011202	6.010606	-23.176267	0.05	3
i1.26	283.65225	-2.6622457504	6.010606	6.010491	-24.780378	0.05	3
i1.26	286.33008	2.5973556042	6.010491	6.010284	-26.378264	0.05	3
i1.27	181.93925	-2.6753017902	6.010041	6.010041	-15.983172	0.1	3
i1.27	184.61597	-2.6266560555	6.010041	6.010327	-15.865795	0.1	3
i1.27	187.29268	-2.602435112	6.010327	6.010706	-15.75963	0.1	3
i1.27	189.96939	-2.6477394104	6.010706	6.010838	-15.664851	0.1	3
i1.27	192.64612	-2.6331775188	6.010838	6.011106	-15.575569	0.1	3
i1.27	195.32283	-2.6221630573	6.011106	6.011609	-15.47302	0.1	3
i1.27	197.99954	-2.663138628	6.011609	6.011480	-15.367187	0.1	3
i1.27	200.67627	-2.6715073586	6.011480	6.011495	-15.272054	0.1	3
i1.27	203.35298	-2.6467380524	6.011495	6.012206	-15.174755	0.1	3
i1.27	206.0297	-2.5984237194	6.012206	6.012907	-15.062285	0.1	3
i1.27	208.70642	-2.6266098022	6.012907	6.012755	-14.972938	0.1	3
i1.27	211.38312	-2.6534729004	6.012755	6.012593	-14.871756	0.1	3
i1.27	214.05984	-2.5807409286	6.012593	6.014223	-14.773059	0.1	3
i1.27	216.73656	-2.6092255116	6.014223	6.013498	-14.674193	0.1	3
i1.27	219.41327	-2.6008667946	6.013498	6.013069	-14.569735	0.1	3
i1.27	222.09	-2.6456577778	6.013069	6.014004	-14.465514	0.1	3
i1.27	224.76671	-2.6145858765	6.014004	6.014433	-14.37187	0.1	3
i1.27	227.44342	-2.5833892822	6.014433	6.013926	-14.276055	0.1	3
i1.27	230.12015	-2.660823822	6.013926	6.014302	-14.173718	0.1	3
i1.27	232.79686	-2.6662929058	6.014302	6.015189	-14.077841	0.1	3
i1.27	235.47357	-2.6086390018	6.015189	6.016026	-13.975188	0.1	3
i1.27	238.15028	-2.5794458389	6.016026	6.015356	-14.07412	0.1	3
i1.27	240.82701	-2.5893759727	6.015356	6.012420	-14.179141	0.1	3
i1.27	243.50371	-2.6122498512	6.012420	6.013862	-14.280758	0.1	3
i1.27	246.18042	-2.6744942665	6.013862	6.014141	-14.371667	0.1	3
i1.27	248.85715	-2.6120731831	6.014141	6.013767	-14.475006	0.1	3
i1.27	251.53386	-2.6307051182	6.013767	6.013695	-14.58015	0.1	3
i1.27	254.21057	-2.5747361183	6.013695	6.012869	-14.678384	0.1	3
i1.27	256.8873	-2.6307015419	6.012869	6.012130	-14.768161	0.1	3
i1.27	259.56403	-2.5994606018	6.012130	6.011765	-14.870328	0.1	3
i1.27	262.24072	-2.6237130165	6.011765	6.012941	-14.984019	0.1	3
i1.27	264.91745	-2.6596758366	6.012941	6.012917	-15.072662	0.1	3
i1.27	267.59418	-2.575294733	6.012917	6.011516	-15.191901	0.1	3
i1.27	270.27087	-2.6566128731	6.011516	6.011920	-16.788971	0.1	3
i1.27	272.9476	-2.6641249657	6.011920	6.011633	-18.384732	0.1	3
i1.27	275.6243	-2.575414896	6.011633	6.011150	-19.985199	0.1	3
i1.27	278.30103	-2.6449475288	6.011150	6.011315	-21.589366	0.1	3
i1.27	280.97772	-2.6139779091	6.011315	6.010907	-23.181044	0.1	3
i1.27	283.65445	-2.6730144024	6.010907	6.010491	-24.775145	0.1	3
i1.27	286.33118	2.622638464	6.010491	6.010202	-26.371007	0.1	3
i1.28	181.91908	-2.5953149796	6.010070	6.010070	-15.981	0.15	3
i1.28	184.59631	-2.6210017204	6.010070	6.010241	-15.875336	0.15	3
i1.28	187.27353	-2.6075029373	6.010241	6.010411	-15.770471	0.15	3
i1.28	189.95074	-2.6340329647	6.010411	6.010415	-15.68366	0.15	3
i1.28	192.62798	-2.596524477	6.010415	6.010888	-15.568736	0.15	3
i1.28	195.30519	-2.6369481087	6.010888	6.011320	-15.473952	0.15	3
i1.28	197.9824	-2.6697146893	6.011320	6.011481	-15.376178	0.15	3
i1.28	200.65964	-2.5923116207	6.011481	6.011662	-15.26948	0.15	3
i1.28	203.33684	-2.6567287445	6.011662	6.011914	-15.181195	0.15	3
i1.28	206.01407	-2.5892491341	6.011914	6.012125	-15.075804	0.15	3
i1.28	208.69128	-2.5787301064	6.012125	6.012679	-14.974049	0.15	3
i1.28	211.3685	-2.5853819847	6.012679	6.011938	-14.875044	0.15	3
i1.28	214.04572	-2.619787693	6.011938	6.012852	-14.777134	0.15	3
i1.28	216.72295	-2.6381716728	6.012852	6.013991	-14.674897	0.15	3
i1.28	219.40016	-2.6227517128	6.013991	6.014288	-14.57026	0.15	3
i1.28	222.0774	-2.5889527798	6.014288	6.013734	-14.464247	0.15	3
i1.28	224.75461	-2.6534061432	6.013734	6.013409	-14.373008	0.15	3
i1.28	227.43182	-2.6448259354	6.013409	6.014738	-14.275922	0.15	3
i1.28	230.10905	-2.602342844	6.014738	6.014687	-14.171816	0.15	3
i1.28	232.78627	-2.5815796852	6.014687	6.014703	-14.075954	0.15	3
i1.28	235.46349	-2.6505310535	6.014703	6.015358	-13.975369	0.15	3
i1.28	238.14072	-2.5936772823	6.015358	6.015334	-14.085505	0.15	3
i1.28	240.81793	-2.6262247562	6.015334	6.016351	-14.175001	0.15	3
i1.28	243.49515	-2.6561555862	6.016351	6.016477	-14.268525	0.15	3
i1.28	246.17236	-2.6198563576	6.016477	6.013014	-14.382237	0.15	3
i1.28	248.8496	-2.6068482399	6.013014	6.014480	-14.480111	0.15	3
i1.28	251.52681	-2.5745127201	6.014480	6.013031	-14.57486	0.15	3
i1.28	254.20404	-2.665525198	6.013031	6.012880	-14.679947	0.15	3
i1.28	256.88126	-2.5969154835	6.012880	6.013056	-14.777696	0.15	3
i1.28	259.55847	-2.6244988441	6.013056	6.012847	-14.877479	0.15	3
i1.28	262.2357	-2.5948207378	6.012847	6.013146	-14.978188	0.15	3
i1.28	264.9129	-2.6457440853	6.013146	6.012293	-15.081602	0.15	3
i1.28	267.59012	-2.6476316452	6.012293	6.012079	-15.189606	0.15	3
i1.28	270.26733	-2.6292660236	6.012079	6.011413	-16.796595	0.15	3
i1.28	272.94458	-2.5915148258	6.011413	6.011782	-18.381019	0.15	3
i1.28	275.6218	-2.659735918	6.011782	6.011467	-19.977669	0.15	3
i1.28	278.299	-2.6259493828	6.011467	6.011126	-21.580984	0.15	3
i1.28	280.97623	-2.6548843384	6.011126	6.010614	-23.173661	0.15	3
i1.28	283.65344	-2.6195058823	6.010614	6.010691	-24.773329	0.15	3
i1.28	286.33066	2.5745375156	6.010691	6.010333	-26.380447	0.15	3
i1.29	181.87991	-2.5942685604	6.010043	6.010043	-15.976746	0.2	3
i1.29	184.5581	-2.6760494709	6.010043	6.010290	-15.862847	0.2	3
i1.29	187.2363	-2.5776183605	6.010290	6.010370	-15.776532	0.2	3
i1.29	189.9145	-2.6262397766	6.010370	6.010901	-15.671606	0.2	3
i1.29	192.5927	-2.6453566551	6.010901	6.011082	-15.572612	0.2	3
i1.29	195.27089	-2.6348237991	6.011082	6.011277	-15.47236	0.2	3
i1.29	197.9491	-2.6481511593	6.011277	6.011300	-15.374039	0.2	3
i1.29	200.6273	-2.6566212177	6.011300	6.011426	-15.27201	0.2	3
i1.29	203.3055	-2.6175234318	6.011426	6.011992	-15.168195	0.2	3
i1.29	205.9837	-2.5892145634	6.011992	6.012029	-15.071921	0.2	3
i1.29	208.6619	-2.583347559	6.012029	6.013499	-14.971763	0.2	3
i1.29	211.3401	-2.5950622559	6.013499	6.013236	-14.875458	0.2	3
i1.29	214.0183	-2.6222395897	6.013236	6.012262	-14.768197	0.2	3
i1.29	216.6965	-2.6042816639	6.012262	6.012771	-14.663801	0.2	3
i1.29	219.3747	-2.6613409519	6.012771	6.013874	-14.579781	0.2	3
i1.29	222.0529	-2.6684114933	6.013874	6.014323	-14.471625	0.2	3
i1.29	224.7311	-2.6102318764	6.014323	6.013717	-14.371592	0.2	3
i1.29	227.4093	-2.5901937485	6.013717	6.013683	-14.268534	0.2	3
i1.29	230.0875	-2.6761982441	6.013683	6.015660	-14.179547	0.2	3
i1.29	232.76569	-2.5897593498	6.015660	6.016573	-14.069348	0.2	3
i1.29	235.4439	-2.5911068916	6.016573	6.013776	-13.969269	0.2	3
i1.29	238.1221	-2.676230669	6.013776	6.015295	-14.069926	0.2	3
i1.29	240.8003	-2.6637325287	6.015295	6.013833	-14.178163	0.2	3
i1.29	243.47849	-2.6745970249	6.013833	6.015232	-14.27362	0.2	3
i1.29	246.1567	-2.6583414078	6.015232	6.013366	-14.378029	0.2	3
i1.29	248.8349	-2.6427340508	6.013366	6.014896	-14.471253	0.2	3
i1.29	251.51309	-2.650853157	6.014896	6.012699	-14.581614	0.2	3
i1.29	254.19128	-2.6208546162	6.012699	6.013137	-14.675273	0.2	3
i1.29	256.8695	-2.5859994888	6.013137	6.013098	-14.780849	0.2	3
i1.29	259.5477	-2.5974509716	6.013098	6.012824	-14.869907	0.2	3
i1.29	262.2259	-2.6353347301	6.012824	6.013081	-14.975169	0.2	3
i1.29	264.90408	-2.6092514992	6.013081	6.010966	-15.067291	0.2	3
i1.29	267.58228	-2.5921037197	6.010966	6.011970	-15.184021	0.2	3
i1.29	270.2605	-2.5771076679	6.011970	6.011543	-16.776687	0.2	3
i1.29	272.9387	-2.6413402557	6.011543	6.011034	-18.381984	0.2	3
i1.29	275.61688	-2.653106451	6.011034	6.010934	-19.985249	0.2	3
i1.29	278.2951	-2.6066410542	6.010934	6.011364	-21.580699	0.2	3
i1.29	280.9733	-2.6056809425	6.011364	6.010769	-23.180982	0.2	3
i1.29	283.6515	-2.5904223919	6.010769	6.010466	-24.772629	0.2	3
i1.29	286.32968	2.6684744358	6.010466	6.010304	-26.373529	0.2	3
i1.30	181.93147	-2.5980644226	6.010047	6.010047	-15.972892	0.25	3
i1.30	184.60838	-2.6730875969	6.010047	6.010331	-15.881032	0.25	3
i1.30	187.2853	-2.6465620995	6.010331	6.010538	-15.777019	0.25	3
i1.30	189.9622	-2.6758384705	6.010538	6.010911	-15.673513	0.25	3
i1.30	192.63911	-2.6511297226	6.010911	6.010941	-15.56264	0.25	3
i1.30	195.31602	-2.6652433872	6.010941	6.011145	-15.470763	0.25	3
i1.30	197.99295	-2.5972909927	6.011145	6.011416	-15.372062	0.25	3
i1.30	200.66986	-2.6476011276	6.011416	6.011419	-15.263163	0.25	3
i1.30	203.34677	-2.6404252052	6.011419	6.012341	-15.171142	0.25	3
i1.30	206.02368	-2.6163730621	6.012341	6.011630	-15.065645	0.25	3
i1.30	208.70059	-2.5839731693	6.011630	6.011682	-14.972552	0.25	3
i1.30	211.3775	-2.5813467503	6.011682	6.012404	-14.873037	0.25	3
i1.30	214.05441	-2.5867199898	6.012404	6.012399	-14.771244	0.25	3
i1.30	216.73132	-2.6313915253	6.012399	6.013233	-14.678932	0.25	3
i1.30	219.40823	-2.6649851799	6.013233	6.013351	-14.573162	0.25	3
i1.30	222.08513	-2.6623644829	6.013351	6.013153	-14.477394	0.25	3
i1.30	224.76204	-2.6710312366	6.013153	6.013734	-14.353636	0.25	3
i1.30	227.43896	-2.6152410507	6.013734	6.013720	-14.271136	0.25	3
i1.30	230.11586	-2.6731524467	6.013720	6.014975	-14.176414	0.25	3
i1.30	232.79277	-2.5932526588	6.014975	6.014395	-14.065793	0.25	3
i1.30	235.46968	-2.6126446724	6.014395	6.014620	-13.973545	0.25	3
i1.30	238.14659	-2.6640415192	6.014620	6.014642	-14.087009	0.25	3
i1.30	240.8235	-2.6056704521	6.014642	6.015173	-14.174997	0.25	3
i1.30	243.50041	-2.6212565899	6.015173	6.014896	-14.282722	0.25	3
i1.30	246.17732	-2.6487014294	6.014896	6.014007	-14.385868	0.25	3
i1.30	248.85423	-2.6587014198	6.014007	6.013529	-14.47935	0.25	3
i1.30	251.53113	-2.6288218498	6.013529	6.013299	-14.584283	0.25	3
i1.30	254.20805	-2.5823209286	6.013299	6.013849	-14.685804	0.25	3
i1.30	256.88495	-2.6435334682	6.013849	6.013580	-14.774391	0.25	3
i1.30	259.5619	-2.6465461254	6.013580	6.012109	-14.881191	0.25	3
i1.30	262.23877	-2.6367783546	6.012109	6.011678	-14.968158	0.25	3
i1.30	264.9157	-2.6535849571	6.011678	6.012279	-15.078142	0.25	3
i1.30	267.59262	-2.6103301048	6.012279	6.011691	-15.193388	0.25	3
i1.30	270.26953	-2.5804591179	6.011691	6.011367	-16.787504	0.25	3
i1.30	272.94644	-2.6575944424	6.011367	6.011366	-18.387924	0.25	3
i1.30	275.62335	-2.6300392151	6.011366	6.011554	-19.989674	0.25	3
i1.30	278.30023	-2.675224781	6.011554	6.011125	-21.580429	0.25	3
i1.30	280.97717	-2.6190721989	6.011125	6.010803	-23.176047	0.25	3
i1.30	283.65405	-2.6237397194	6.010803	6.010321	-24.772314	0.25	3
i1.30	286.331	2.6565995216	6.010321	6.010332	-26.374066	0.25	3
i1.31	181.85715	-2.6699521542	6.010050	6.010050	-15.978136	0.3	3
i1.31	184.53592	-2.6687200069	6.010050	6.010432	-15.878979	0.3	3
i1.31	187.21468	-2.5719118118	6.010432	6.010586	-15.773567	0.3	3
i1.31	189.89346	-2.6032657623	6.010586	6.010836	-15.681277	0.3	3
i1.31	192.57222	-2.6190214157	6.010836	6.011420	-15.57915	0.3	3
i1.31	195.25099	-2.6596252918	6.011420	6.011145	-15.482326	0.3	3
i1.31	197.92976	-2.671916008	6.011145	6.011354	-15.390247	0.3	3
i1.31	200.60852	-2.6667654514	6.011354	6.012032	-15.272187	0.3	3
i1.31	203.2873	-2.6593375206	6.012032	6.011617	-15.174437	0.3	3
i1.31	205.96606	-2.6065580845	6.011617	6.011728	-15.078106	0.3	3
i1.31	208.64484	-2.6674613953	6.011728	6.012385	-14.978084	0.3	3
i1.31	211.3236	-2.6155359745	6.012385	6.012867	-14.88026	0.3	3
i1.31	214.00238	-2.657150507	6.012867	6.012929	-14.773578	0.3	3
i1.31	216.68114	-2.6028146744	6.012929	6.014268	-14.678269	0.3	3
i1.31	219.35991	-2.6345086098	6.014268	6.013323	-14.577415	0.3	3
i1.31	222.03867	-2.5842964649	6.013323	6.013497	-14.482106	0.3	3
i1.31	224.71744	-2.6345143318	6.013497	6.015330	-14.369424	0.3	3
i1.31	227.39621	-2.6332736015	6.015330	6.013238	-14.271487	0.3	3
i1.31	230.07498	-2.5955848694	6.013238	6.015638	-14.172988	0.3	3
i1.31	232.75375	-2.5998749733	6.015638	6.014930	-14.076845	0.3	3
i1.31	235.43251	-2.5876507759	6.014930	6.017131	-13.972487	0.3	3
i1.31	238.1113	-2.6558778286	6.017131	6.016217	-14.076877	0.3	3
i1.31	240.79005	-2.6214711666	6.016217	6.013933	-14.172768	0.3	3
i1.31	243.46883	-2.6758518219	6.013933	6.011906	-14.272268	0.3	3
i1.31	246.14758	-2.6173624992	6.011906	6.013674	-14.377472	0.3	3
i1.31	248.82635	-2.6173481941	6.013674	6.013569	-14.477853	0.3	3
i1.31	251.50513	-2.6763830185	6.013569	6.012403	-14.580961	0.3	3
i1.31	254.1839	-2.661008358	6.012403	6.012568	-14.679979	0.3	3
i1.31	256.86267	-2.6429588795	6.012568	6.013570	-14.765793	0.3	3
i1.31	259.54144	-2.6490843296	6.013570	6.012530	-14.882758	0.3	3
i1.31	262.2202	-2.6230685711	6.012530	6.013005	-14.979244	0.3	3
i1.31	264.899	-2.6744301319	6.013005	6.011949	-15.078038	0.3	3
i1.31	267.57773	-2.623893261	6.011949	6.011404	-15.174946	0.3	3
i1.31	270.2565	-2.5846977234	6.011404	6.012101	-16.778556	0.3	3
i1.31	272.93527	-2.6333305836	6.012101	6.011482	-18.382788	0.3	3
i1.31	275.61404	-2.6080286503	6.011482	6.011368	-19.977521	0.3	3
i1.31	278.29282	-2.6206476688	6.011368	6.011228	-21.577452	0.3	3
i1.31	280.9716	-2.6374726295	6.011228	6.010471	-23.180442	0.3	3
i1.31	283.65033	-2.6015703678	6.010471	6.010603	-24.78353	0.3	3
i1.31	286.32913	2.6092460155	6.010603	6.010240	-26.37871	0.3	3
i1.20	345.84985	-1.7475291491	6.010070	6.010070	-15.990902	-0.25	3
i1.20	347.66196	-1.7496278286	6.010070	6.010397	-15.874544	-0.25	3
i1.20	349.4741	-1.808760047	6.010397	6.010500	-15.771595	-0.25	3
i1.20	351.2862	-1.7538883686	6.010500	6.010950	-15.667402	-0.25	3
i1.20	353.0983	-1.797888279	6.010950	6.011295	-15.586235	-0.25	3
i1.20	354.91043	-1.7919154167	6.011295	6.011480	-15.477242	-0.25	3
i1.20	356.72253	-1.7472747564	6.011480	6.011404	-15.373719	-0.25	3
i1.20	358.53467	-1.7462515831	6.011404	6.011580	-15.270683	-0.25	3
i1.20	360.34677	-1.8116871119	6.011580	6.012050	-15.167954	-0.25	3
i1.20	362.1589	-1.8002351522	6.012050	6.012501	-15.073091	-0.25	3
i1.20	363.971	-1.7952517271	6.012501	6.012755	-14.973033	-0.25	3
i1.20	365.78314	-1.7704868317	6.012755	6.011887	-14.869686	-0.25	3
i1.20	367.59525	-1.7428990602	6.011887	6.012970	-14.77353	-0.25	3
i1.20	369.40738	-1.7649829388	6.012970	6.013357	-14.672464	-0.25	3
i1.20	371.21948	-1.7909303904	6.013357	6.012613	-14.569708	-0.25	3
i1.20	373.0316	-1.7477378845	6.012613	6.013799	-14.473725	-0.25	3
i1.20	374.84372	-1.7687345743	6.013799	6.013327	-14.366428	-0.25	3
i1.20	376.65582	-1.7896163464	6.013327	6.012939	-14.264987	-0.25	3
i1.20	378.46796	-1.7889275551	6.012939	6.014161	-14.179564	-0.25	3
i1.20	380.28006	-1.7820843458	6.014161	6.015930	-14.078249	-0.25	3
i1.20	382.0922	-1.7622674704	6.015930	6.015803	-13.977649	-0.25	3
i1.20	383.9043	-1.7702262402	6.015803	6.014055	-14.076853	-0.25	3
i1.20	385.71643	-1.7701566219	6.014055	6.013038	-14.178978	-0.25	3
i1.20	387.52853	-1.8031163216	6.013038	6.014078	-14.272037	-0.25	3
i1.20	389.34067	-1.8086584806	6.014078	6.012657	-14.376144	-0.25	3
i1.20	391.15277	-1.7703671455	6.012657	6.013585	-14.468003	-0.25	3
i1.20	392.96487	-1.8100354671	6.013585	6.013629	-14.580838	-0.25	3
i1.20	394.777	-1.7656002045	6.013629	6.012431	-14.673985	-0.25	3
i1.20	396.5891	-1.8097081184	6.012431	6.012485	-14.784885	-0.25	3
i1.20	398.40125	-1.8006180525	6.012485	6.012488	-14.880839	-0.25	3
i1.20	400.21335	-1.7471317053	6.012488	6.013197	-14.972416	-0.25	3
i1.20	402.02548	-1.7877168655	6.013197	6.012396	-15.079374	-0.25	3
i1.20	403.8376	-1.7563986778	6.012396	6.012165	-15.175518	-0.25	3
i1.20	405.64972	-1.7400460243	6.012165	6.011650	-15.287246	-0.25	3
i1.20	407.46182	-1.7953675985	6.011650	6.011549	-15.37334	-0.25	3
i1.20	409.27393	-1.8052794933	6.011549	6.011483	-15.476155	-0.25	3
i1.20	411.08606	-1.8004000187	6.011483	6.011165	-15.569645	-0.25	3
i1.20	412.89816	-1.7877572775	6.011165	6.010971	-15.671986	-0.25	3
i1.20	414.7103	-1.7789987326	6.010971	6.010496	-15.768018	-0.25	3
i1.20	416.5224	1.7998626232	6.010496	6.010367	-15.876595	-0.25	3
i1.21	345.90454	-1.7944513559	6.010053	6.010053	-15.964899	-0.2	3
i1.21	347.7153	-1.7741602659	6.010053	6.010286	-15.86908	-0.2	3
i1.21	349.52603	-1.7863197327	6.010286	6.010514	-15.77145	-0.2	3
i1.21	351.3368	-1.7785662413	6.010514	6.010640	-15.676259	-0.2	3
i1.21	353.14752	-1.8103773594	6.010640	6.011030	-15.573455	-0.2	3
i1.21	354.95828	-1.7434645891	6.011030	6.011568	-15.475932	-0.2	3
i1.21	356.76904	-1.7531164885	6.011568	6.011552	-15.377654	-0.2	3
i1.21	358.57977	-1.7489349842	6.011552	6.012030	-15.274848	-0.2	3
i1.21	360.39053	-1.7831557989	6.012030	6.012430	-15.171626	-0.2	3
i1.21	362.2013	-1.7489953041	6.012430	6.012749	-15.063053	-0.2	3
i1.21	364.01202	-1.8008776903	6.012749	6.012491	-14.972538	-0.2	3
i1.21	365.82278	-1.7709941864	6.012491	6.012172	-14.866525	-0.2	3
i1.21	367.63354	-1.7543106079	6.012172	6.012465	-14.773186	-0.2	3
i1.21	369.44427	-1.77447927	6.012465	6.012465	-14.677141	-0.2	3
i1.21	371.25504	-1.7536506653	6.012465	6.012716	-14.561324	-0.2	3
i1.21	373.0658	-1.7868425846	6.012716	6.014277	-14.473952	-0.2	3
i1.21	374.87653	-1.7761696577	6.014277	6.013321	-14.371319	-0.2	3
i1.21	376.6873	-1.7717404366	6.013321	6.013861	-14.276783	-0.2	3
i1.21	378.49805	-1.7728248835	6.013861	6.013224	-14.167674	-0.2	3
i1.21	380.30878	-1.8003180027	6.013224	6.014163	-14.08004	-0.2	3
i1.21	382.11954	-1.7841303349	6.014163	6.016120	-13.974854	-0.2	3
i1.21	383.9303	-1.8099155426	6.016120	6.013588	-14.082475	-0.2	3
i1.21	385.74103	-1.7518033981	6.013588	6.014894	-14.183871	-0.2	3
i1.21	387.5518	-1.7798519135	6.014894	6.012644	-14.273319	-0.2	3
i1.21	389.36252	-1.8092230558	6.012644	6.014045	-14.376596	-0.2	3
i1.21	391.17328	-1.7645864487	6.014045	6.014977	-14.473584	-0.2	3
i1.21	392.98404	-1.7483353615	6.014977	6.013762	-14.579603	-0.2	3
i1.21	394.79477	-1.8021709919	6.013762	6.012953	-14.683866	-0.2	3
i1.21	396.60553	-1.7616883516	6.012953	6.013894	-14.775655	-0.2	3
i1.21	398.4163	-1.7562333345	6.013894	6.012566	-14.876382	-0.2	3
i1.21	400.22702	-1.8007315397	6.012566	6.013087	-14.969781	-0.2	3
i1.21	402.03778	-1.7453225851	6.013087	6.012523	-15.068908	-0.2	3
i1.21	403.84854	-1.7947597504	6.012523	6.012432	-15.174757	-0.2	3
i1.21	405.65927	-1.8053199053	6.012432	6.011303	-15.268928	-0.2	3
i1.21	407.47003	-1.7409113646	6.011303	6.011763	-15.374676	-0.2	3
i1.21	409.2808	-1.7454153299	6.011763	6.011413	-15.470408	-0.2	3
i1.21	411.09152	-1.7746062279	6.011413	6.010835	-15.582255	-0.2	3
i1.21	412.90228	-1.7920563221	6.010835	6.010641	-15.679215	-0.2	3
i1.21	414.713	-1.7610291243	6.010641	6.010461	-15.78161	-0.2	3
i1.21	416.52377	1.7862914801	6.010461	6.010372	-15.871384	-0.2	3
i1.22	345.8564	-1.7549139261	6.010043	6.010043	-15.978033	-0.15	3
i1.22	347.66837	-1.750985384	6.010043	6.010275	-15.869854	-0.15	3
i1.22	349.48032	-1.7593797445	6.010275	6.010485	-15.77232	-0.15	3
i1.22	351.29227	-1.7449630499	6.010485	6.010755	-15.679668	-0.15	3
i1.22	353.10422	-1.7578769922	6.010755	6.010815	-15.571526	-0.15	3
i1.22	354.9162	-1.7796846628	6.010815	6.011520	-15.469799	-0.15	3
i1.22	356.72815	-1.7403715849	6.011520	6.011116	-15.385186	-0.15	3
i1.22	358.5401	-1.7998820543	6.011116	6.011718	-15.274896	-0.15	3
i1.22	360.35205	-1.7995827198	6.011718	6.012515	-15.171239	-0.15	3
i1.22	362.164	-1.740722537	6.012515	6.012048	-15.068409	-0.15	3
i1.22	363.97595	-1.7719970942	6.012048	6.012373	-14.981039	-0.15	3
i1.22	365.7879	-1.8073773384	6.012373	6.013196	-14.875629	-0.15	3
i1.22	367.59985	-1.7899280787	6.013196	6.012663	-14.778558	-0.15	3
i1.22	369.4118	-1.7678147554	6.012663	6.013190	-14.677335	-0.15	3
i1.22	371.22375	-1.7858790159	6.013190	6.013181	-14.577133	-0.15	3
i1.22	373.0357	-1.7990909815	6.013181	6.013851	-14.475795	-0.15	3
i1.22	374.84766	-1.7456780672	6.013851	6.013414	-14.376325	-0.15	3
i1.22	376.6596	-1.7741923332	6.013414	6.013945	-14.277448	-0.15	3
i1.22	378.47156	-1.7604885101	6.013945	6.013183	-14.174636	-0.15	3
i1.22	380.2835	-1.7641297579	6.013183	6.014216	-14.071897	-0.15	3
i1.22	382.09546	-1.7999476194	6.014216	6.014202	-13.979497	-0.15	3
i1.22	383.9074	-1.767381072	6.014202	6.013606	-14.078573	-0.15	3
i1.22	385.7194	-1.7908588648	6.013606	6.014547	-14.178845	-0.15	3
i1.22	387.53134	-1.7468607426	6.014547	6.015407	-14.273689	-0.15	3
i1.22	389.3433	-1.7732005119	6.015407	6.013558	-14.371707	-0.15	3
i1.22	391.15524	-1.7470543385	6.013558	6.013646	-14.473175	-0.15	3
i1.22	392.9672	-1.7683062553	6.013646	6.012767	-14.583502	-0.15	3
i1.22	394.77914	-1.7723470926	6.012767	6.013881	-14.671167	-0.15	3
i1.22	396.5911	-1.7883216143	6.013881	6.013214	-14.781762	-0.15	3
i1.22	398.40305	-1.7504075766	6.013214	6.012434	-14.867863	-0.15	3
i1.22	400.215	-1.758450985	6.012434	6.011949	-14.978471	-0.15	3
i1.22	402.02695	-1.7840554714	6.011949	6.012728	-15.070049	-0.15	3
i1.22	403.8389	-1.8047436476	6.012728	6.012245	-15.173997	-0.15	3
i1.22	405.65085	-1.7994604111	6.012245	6.011727	-15.271011	-0.15	3
i1.22	407.4628	-1.7987141609	6.011727	6.011831	-15.377988	-0.15	3
i1.22	409.27475	-1.8010540009	6.011831	6.011751	-15.47962	-0.15	3
i1.22	411.08673	-1.8044011593	6.011751	6.010884	-15.577823	-0.15	3
i1.22	412.89868	-1.7617679834	6.010884	6.010631	-15.679139	-0.15	3
i1.22	414.71063	-1.7808940411	6.010631	6.010630	-15.78354	-0.15	3
i1.22	416.52258	1.7428474426	6.010630	6.010356	-15.871214	-0.15	3
i1.23	345.88004	-1.753067255	6.010027	6.010027	-15.979433	-0.1	3
i1.23	347.6914	-1.7477422953	6.010027	6.010277	-15.874329	-0.1	3
i1.23	349.50278	-1.7973992825	6.010277	6.010645	-15.773945	-0.1	3
i1.23	351.31412	-1.7800675631	6.010645	6.010793	-15.665655	-0.1	3
i1.23	353.1255	-1.7713904381	6.010793	6.011081	-15.571986	-0.1	3
i1.23	354.93686	-1.7427079678	6.011081	6.011316	-15.459699	-0.1	3
i1.23	356.7482	-1.7937515974	6.011316	6.011657	-15.365267	-0.1	3
i1.23	358.55957	-1.805010438	6.011657	6.012010	-15.282374	-0.1	3
i1.23	360.37094	-1.7586985826	6.012010	6.012754	-15.174631	-0.1	3
i1.23	362.1823	-1.7572458982	6.012754	6.012465	-15.067352	-0.1	3
i1.23	363.99365	-1.7696954012	6.012465	6.012843	-14.96939	-0.1	3
i1.23	365.80502	-1.7453426123	6.012843	6.012715	-14.863136	-0.1	3
i1.23	367.6164	-1.8041255474	6.012715	6.012704	-14.772513	-0.1	3
i1.23	369.42773	-1.7652541399	6.012704	6.013531	-14.663379	-0.1	3
i1.23	371.2391	-1.7571179867	6.013531	6.013058	-14.575349	-0.1	3
i1.23	373.05048	-1.8000528812	6.013058	6.013201	-14.471286	-0.1	3
i1.23	374.86185	-1.7420568466	6.013201	6.012060	-14.364888	-0.1	3
i1.23	376.6732	-1.780967474	6.012060	6.014304	-14.273703	-0.1	3
i1.23	378.48456	-1.7461093664	6.014304	6.014951	-14.17658	-0.1	3
i1.23	380.29593	-1.74236238	6.014951	6.014214	-14.074839	-0.1	3
i1.23	382.1073	-1.8065023422	6.014214	6.017109	-13.977295	-0.1	3
i1.23	383.91864	-1.7661504745	6.017109	6.014507	-14.077154	-0.1	3
i1.23	385.73	-1.7885580063	6.014507	6.015011	-14.190407	-0.1	3
i1.23	387.54138	-1.8080196381	6.015011	6.015911	-14.278327	-0.1	3
i1.23	389.35272	-1.7444574833	6.015911	6.013500	-14.386038	-0.1	3
i1.23	391.1641	-1.7962735891	6.013500	6.014732	-14.470803	-0.1	3
i1.23	392.97546	-1.7869712114	6.014732	6.013590	-14.576004	-0.1	3
i1.23	394.7868	-1.7388817072	6.013590	6.013255	-14.678715	-0.1	3
i1.23	396.59818	-1.7418797016	6.013255	6.012547	-14.770342	-0.1	3
i1.23	398.40955	-1.7921622992	6.012547	6.012788	-14.865431	-0.1	3
i1.23	400.22092	-1.7695578337	6.012788	6.013177	-14.976898	-0.1	3
i1.23	402.03226	-1.7804828882	6.013177	6.012140	-15.064381	-0.1	3
i1.23	403.84363	-1.8015332222	6.012140	6.011779	-15.181516	-0.1	3
i1.23	405.655	-1.7485899925	6.011779	6.011045	-15.276682	-0.1	3
i1.23	407.46634	-1.7759411335	6.011045	6.011522	-15.37679	-0.1	3
i1.23	409.2777	-1.7669135332	6.011522	6.011925	-15.479031	-0.1	3
i1.23	411.08908	-1.8024158478	6.011925	6.011273	-15.57515	-0.1	3
i1.23	412.90045	-1.7876883745	6.011273	6.010356	-15.674973	-0.1	3
i1.23	414.7118	-1.7896251678	6.010356	6.010498	-15.778357	-0.1	3
i1.23	416.52316	1.7664484978	6.010498	6.010331	-15.871396	-0.1	3
i1.24	345.86923	-1.7606084347	6.010041	6.010041	-15.962447	-0.05	3
i1.24	347.68088	-1.7877328396	6.010041	6.010413	-15.871471	-0.05	3
i1.24	349.4925	-1.7649513483	6.010413	6.010467	-15.770719	-0.05	3
i1.24	351.30414	-1.7624906301	6.010467	6.010852	-15.676529	-0.05	3
i1.24	353.11578	-1.7661198378	6.010852	6.010782	-15.578904	-0.05	3
i1.24	354.9274	-1.8026996851	6.010782	6.011213	-15.476448	-0.05	3
i1.24	356.73904	-1.806465745	6.011213	6.011022	-15.38003	-0.05	3
i1.24	358.55066	-1.7523709536	6.011022	6.011756	-15.276923	-0.05	3
i1.24	360.3623	-1.7577522993	6.011756	6.012510	-15.17571	-0.05	3
i1.24	362.17392	-1.7928345203	6.012510	6.012063	-15.074039	-0.05	3
i1.24	363.98557	-1.7912217379	6.012063	6.012293	-14.980292	-0.05	3
i1.24	365.7972	-1.7962354422	6.012293	6.012889	-14.877655	-0.05	3
i1.24	367.60883	-1.7401297092	6.012889	6.013073	-14.767387	-0.05	3
i1.24	369.42047	-1.7696485519	6.013073	6.013900	-14.6722	-0.05	3
i1.24	371.2321	-1.7577106953	6.013900	6.012400	-14.566677	-0.05	3
i1.24	373.04373	-1.758136034	6.012400	6.013881	-14.470605	-0.05	3
i1.24	374.85535	-1.7583979368	6.013881	6.014049	-14.379788	-0.05	3
i1.24	376.667	-1.7886940241	6.014049	6.013389	-14.269845	-0.05	3
i1.24	378.47864	-1.7972923517	6.013389	6.014149	-14.17623	-0.05	3
i1.24	380.29025	-1.7631402016	6.014149	6.014837	-14.075735	-0.05	3
i1.24	382.1019	-1.7626862526	6.014837	6.014218	-13.987639	-0.05	3
i1.24	383.9135	-1.7813346386	6.014218	6.016440	-14.072778	-0.05	3
i1.24	385.72516	-1.8033739328	6.016440	6.012747	-14.173923	-0.05	3
i1.24	387.53677	-1.7720973492	6.012747	6.013279	-14.27867	-0.05	3
i1.24	389.34842	-1.793435216	6.013279	6.013066	-14.371465	-0.05	3
i1.24	391.16003	-1.7809358835	6.013066	6.013832	-14.481761	-0.05	3
i1.24	392.97168	-1.8043166399	6.013832	6.013906	-14.581309	-0.05	3
i1.24	394.78333	-1.7836188078	6.013906	6.012897	-14.675319	-0.05	3
i1.24	396.59494	-1.7432500124	6.012897	6.013370	-14.775478	-0.05	3
i1.24	398.4066	-1.7768090963	6.013370	6.012538	-14.863772	-0.05	3
i1.24	400.2182	-1.790743351	6.012538	6.012942	-14.979402	-0.05	3
i1.24	402.02985	-1.7609174252	6.012942	6.012395	-15.075359	-0.05	3
i1.24	403.84146	-1.7979438305	6.012395	6.012578	-15.180042	-0.05	3
i1.24	405.6531	-1.7659193277	6.012578	6.012511	-15.27066	-0.05	3
i1.24	407.46472	-1.7847372293	6.012511	6.011597	-15.377771	-0.05	3
i1.24	409.27637	-1.8073154688	6.011597	6.011764	-15.468871	-0.05	3
i1.24	411.088	-1.7553573847	6.011764	6.011049	-15.576352	-0.05	3
i1.24	412.89963	-1.7498533726	6.011049	6.010824	-15.680911	-0.05	3
i1.24	414.71127	-1.7604211569	6.010824	6.010667	-15.783655	-0.05	3
i1.24	416.5229	1.7649536133	6.010667	6.010333	-15.879146	-0.05	3
i1.25	345.84436	-1.7894117832	6.010063	6.010063	-15.976424	0.0	3
i1.25	347.65662	-1.7424640656	6.010063	6.010299	-15.877714	0.0	3
i1.25	349.46887	-1.7435200214	6.010299	6.010485	-15.769625	0.0	3
i1.25	351.28113	-1.740121603	6.010485	6.010788	-15.667145	0.0	3
i1.25	353.09338	-1.7431964874	6.010788	6.011108	-15.573228	0.0	3
i1.25	354.90564	-1.7506850958	6.011108	6.011009	-15.470039	0.0	3
i1.25	356.71786	-1.7624545097	6.011009	6.011173	-15.375535	0.0	3
i1.25	358.53015	-1.7981398106	6.011173	6.011873	-15.277457	0.0	3
i1.25	360.34238	-1.7708284855	6.011873	6.011276	-15.182141	0.0	3
i1.25	362.15463	-1.7904314995	6.011276	6.012718	-15.077843	0.0	3
i1.25	363.96692	-1.7492830753	6.012718	6.012707	-14.974925	0.0	3
i1.25	365.77914	-1.7781779766	6.012707	6.012955	-14.880071	0.0	3
i1.25	367.5914	-1.7714989185	6.012955	6.013624	-14.775433	0.0	3
i1.25	369.40366	-1.780328989	6.013624	6.014096	-14.673786	0.0	3
i1.25	371.2159	-1.8008811474	6.014096	6.014195	-14.57017	0.0	3
i1.25	373.02817	-1.7488617897	6.014195	6.013025	-14.470617	0.0	3
i1.25	374.84042	-1.7994959354	6.013025	6.014657	-14.380019	0.0	3
i1.25	376.65268	-1.8066761494	6.014657	6.013339	-14.27835	0.0	3
i1.25	378.46494	-1.7938587666	6.013339	6.015120	-14.174448	0.0	3
i1.25	380.2772	-1.7881470919	6.015120	6.014030	-14.0753	0.0	3
i1.25	382.08945	-1.782102108	6.014030	6.016119	-13.975813	0.0	3
i1.25	383.9017	-1.7441262007	6.016119	6.014451	-14.079601	0.0	3
i1.25	385.71396	-1.8062369823	6.014451	6.015618	-14.171237	0.0	3
i1.25	387.5262	-1.7890356779	6.015618	6.015216	-14.271926	0.0	3
i1.25	389.33847	-1.7608097792	6.015216	6.015599	-14.371696	0.0	3
i1.25	391.15073	-1.7562644482	6.015599	6.013228	-14.475889	0.0	3
i1.25	392.96298	-1.7586250305	6.013228	6.013215	-14.567656	0.0	3
i1.25	394.7752	-1.7973638773	6.013215	6.014021	-14.668657	0.0	3
i1.25	396.58746	-1.7624549866	6.014021	6.012490	-14.778189	0.0	3
i1.25	398.39972	-1.7497354746	6.012490	6.011958	-14.874753	0.0	3
i1.25	400.21198	-1.749360919	6.011958	6.013400	-14.979777	0.0	3
i1.25	402.02423	-1.7539259195	6.013400	6.012300	-15.072074	0.0	3
i1.25	403.8365	-1.7843247652	6.012300	6.011620	-15.17465	0.0	3
i1.25	405.64874	-1.7994560003	6.011620	6.011857	-15.271145	0.0	3
i1.25	407.461	-1.7474591732	6.011857	6.011816	-15.387819	0.0	3
i1.25	409.27325	-1.761230588	6.011816	6.011241	-15.477528	0.0	3
i1.25	411.0855	-1.7405664921	6.011241	6.011029	-15.573694	0.0	3
i1.25	412.89777	-1.746432662	6.011029	6.010615	-15.669629	0.0	3
i1.25	414.71002	-1.7687774897	6.010615	6.010648	-15.783336	0.0	3
i1.25	416.52228	1.7821320295	6.010648	6.010264	-15.869073	0.0	3
i1.26	345.88913	-1.7843258381	6.010034	6.010034	-15.96975	0.05	3
i1.26	347.7003	-1.7719665766	6.010034	6.010305	-15.86819	0.05	3
i1.26	349.5114	-1.7638038397	6.010305	6.010392	-15.776701	0.05	3
i1.26	351.32254	-1.8077681065	6.010392	6.010605	-15.667065	0.05	3
i1.26	353.1337	-1.8056151867	6.010605	6.010964	-15.572573	0.05	3
i1.26	354.94482	-1.774864912	6.010964	6.011349	-15.469863	0.05	3
i1.26	356.75595	-1.7563569546	6.011349	6.011254	-15.372657	0.05	3
i1.26	358.56708	-1.7468686104	6.011254	6.011597	-15.274618	0.05	3
i1.26	360.37823	-1.7868535519	6.011597	6.011887	-15.18409	0.05	3
i1.26	362.18936	-1.7969762087	6.011887	6.012535	-15.063903	0.05	3
i1.26	364.0005	-1.7452534437	6.012535	6.012234	-14.966568	0.05	3
i1.26	365.8116	-1.777605176	6.012234	6.013049	-14.871388	0.05	3
i1.26	367.62277	-1.7995175123	6.013049	6.011843	-14.779467	0.05	3
i1.26	369.4339	-1.7897486687	6.011843	6.013123	-14.66911	0.05	3
i1.26	371.24503	-1.7876298428	6.013123	6.013560	-14.577436	0.05	3
i1.26	373.05615	-1.7989338636	6.013560	6.014102	-14.470757	0.05	3
i1.26	374.8673	-1.7802219391	6.014102	6.013733	-14.37127	0.05	3
i1.26	376.67844	-1.7574344873	6.013733	6.013837	-14.277609	0.05	3
i1.26	378.48956	-1.7945249081	6.013837	6.013527	-14.174232	0.05	3
i1.26	380.3007	-1.7389601469	6.013527	6.015356	-14.071048	0.05	3
i1.26	382.11185	-1.7667387724	6.015356	6.015619	-13.975423	0.05	3
i1.26	383.92297	-1.7895374298	6.015619	6.015270	-14.081868	0.05	3
i1.26	385.7341	-1.7505229712	6.015270	6.014539	-14.178773	0.05	3
i1.26	387.54523	-1.8062850237	6.014539	6.013514	-14.278305	0.05	3
i1.26	389.35638	-1.7759463787	6.013514	6.015457	-14.380081	0.05	3
i1.26	391.1675	-1.803385973	6.015457	6.013566	-14.472958	0.05	3
i1.26	392.97864	-1.773597002	6.013566	6.014342	-14.573708	0.05	3
i1.26	394.78976	-1.8022048473	6.014342	6.013431	-14.68297	0.05	3
i1.26	396.60092	-1.7413297892	6.013431	6.013111	-14.785079	0.05	3
i1.26	398.41205	-1.7940075397	6.013111	6.013122	-14.880536	0.05	3
i1.26	400.22318	-1.7655004263	6.013122	6.012392	-14.984038	0.05	3
i1.26	402.0343	-1.76783216	6.012392	6.013119	-15.067447	0.05	3
i1.26	403.84546	-1.7434998751	6.013119	6.012059	-15.171252	0.05	3
i1.26	405.6566	-1.778653264	6.012059	6.011316	-15.272837	0.05	3
i1.26	407.4677	-1.7856086493	6.011316	6.011657	-15.379595	0.05	3
i1.26	409.27887	-1.8017014265	6.011657	6.011611	-15.476946	0.05	3
i1.26	411.09	-1.7832633257	6.011611	6.011108	-15.5728	0.05	3
i1.26	412.90112	-1.7481554747	6.011108	6.010856	-15.681289	0.05	3
i1.26	414.71225	-1.7825796604	6.010856	6.010558	-15.771142	0.05	3
i1.26	416.52338	1.7834018469	6.010558	6.010329	-15.871064	0.05	3
i1.27	345.8913	-1.800891161	6.010040	6.010040	-15.975805	0.1	3
i1.27	347.7024	-1.7914803028	6.010040	6.010366	-15.872833	0.1	3
i1.27	349.51346	-1.7590897083	6.010366	6.010640	-15.772305	0.1	3
i1.27	351.32455	-1.744939208	6.010640	6.010684	-15.667502	0.1	3
i1.27	353.13562	-1.7718719244	6.010684	6.011170	-15.574632	0.1	3
i1.27	354.94672	-1.7643034458	6.011170	6.011262	-15.462303	0.1	3
i1.27	356.75778	-1.7998335361	6.011262	6.011643	-15.373202	0.1	3
i1.27	358.56888	-1.7398697138	6.011643	6.011556	-15.261994	0.1	3
i1.27	360.37994	-1.8018796444	6.011556	6.011288	-15.176188	0.1	3
i1.27	362.19104	-1.7866814137	6.011288	6.012901	-15.063284	0.1	3
i1.27	364.0021	-1.7712908983	6.012901	6.013059	-14.973069	0.1	3
i1.27	365.8132	-1.7474689484	6.013059	6.011782	-14.873455	0.1	3
i1.27	367.62427	-1.7672691345	6.011782	6.013137	-14.779915	0.1	3
i1.27	369.43533	-1.8009390831	6.013137	6.013444	-14.670951	0.1	3
i1.27	371.24643	-1.8018121719	6.013444	6.015078	-14.576851	0.1	3
i1.27	373.0575	-1.7738027573	6.015078	6.014691	-14.472584	0.1	3
i1.27	374.8686	-1.7448512316	6.014691	6.013447	-14.376898	0.1	3
i1.27	376.67966	-1.8043783903	6.013447	6.013514	-14.26921	0.1	3
i1.27	378.49075	-1.7949354649	6.013514	6.014423	-14.165858	0.1	3
i1.27	380.30182	-1.7999008894	6.014423	6.014194	-14.068156	0.1	3
i1.27	382.1129	-1.8061233759	6.014194	6.015551	-13.98685	0.1	3
i1.27	383.92398	-1.7498989105	6.015551	6.016556	-14.084496	0.1	3
i1.27	385.73508	-1.7771631479	6.016556	6.013545	-14.174895	0.1	3
i1.27	387.54614	-1.774400115	6.013545	6.014254	-14.274306	0.1	3
i1.27	389.35724	-1.7536821365	6.014254	6.012715	-14.372235	0.1	3
i1.27	391.16833	-1.793196559	6.012715	6.014751	-14.475428	0.1	3
i1.27	392.9794	-1.7794475555	6.014751	6.013407	-14.575736	0.1	3
i1.27	394.79047	-1.7541732788	6.013407	6.012428	-14.679039	0.1	3
i1.27	396.60156	-1.7806572914	6.012428	6.012398	-14.77587	0.1	3
i1.27	398.41266	-1.7658865452	6.012398	6.014193	-14.881264	0.1	3
i1.27	400.22372	-1.7548455	6.014193	6.012377	-14.968114	0.1	3
i1.27	402.0348	-1.7933044434	6.012377	6.012429	-15.074641	0.1	3
i1.27	403.8459	-1.797426343	6.012429	6.012098	-15.183366	0.1	3
i1.27	405.65695	-1.8085041046	6.012098	6.011824	-15.273225	0.1	3
i1.27	407.46805	-1.7696510553	6.011824	6.011854	-15.373252	0.1	3
i1.27	409.2791	-1.7963842154	6.011854	6.011156	-15.475102	0.1	3
i1.27	411.0902	-1.7430493832	6.011156	6.011049	-15.582605	0.1	3
i1.27	412.90128	-1.790804863	6.011049	6.010953	-15.671054	0.1	3
i1.27	414.71237	-1.8035105467	6.010953	6.010443	-15.773512	0.1	3
i1.27	416.52344	1.8029618263	6.010443	6.010194	-15.882199	0.1	3
i1.28	345.86786	-1.8037375212	6.010051	6.010051	-15.979916	0.15	3
i1.28	347.67953	-1.7951231003	6.010051	6.010349	-15.875227	0.15	3
i1.28	349.49118	-1.7610182762	6.010349	6.010689	-15.780718	0.15	3
i1.28	351.30286	-1.7750586271	6.010689	6.010936	-15.674345	0.15	3
i1.28	353.11453	-1.7433797121	6.010936	6.011078	-15.568122	0.15	3
i1.28	354.9262	-1.7741552591	6.011078	6.011265	-15.465323	0.15	3
i1.28	356.73785	-1.8057789803	6.011265	6.011922	-15.373478	0.15	3
i1.28	358.54953	-1.7732025385	6.011922	6.011421	-15.272758	0.15	3
i1.28	360.3612	-1.7847340107	6.011421	6.011968	-15.179066	0.15	3
i1.28	362.17285	-1.8061636686	6.011968	6.012117	-15.074488	0.15	3
i1.28	363.98453	-1.7747782469	6.012117	6.012747	-14.964038	0.15	3
i1.28	365.7962	-1.762245059	6.012747	6.012225	-14.872509	0.15	3
i1.28	367.60785	-1.7444627285	6.012225	6.013979	-14.772323	0.15	3
i1.28	369.41953	-1.7707822323	6.013979	6.014581	-14.680303	0.15	3
i1.28	371.2312	-1.8069894314	6.014581	6.012690	-14.566541	0.15	3
i1.28	373.04285	-1.8020277023	6.012690	6.013529	-14.481609	0.15	3
i1.28	374.85452	-1.8059773445	6.013529	6.014801	-14.37329	0.15	3
i1.28	376.6662	-1.7923129797	6.014801	6.013873	-14.271686	0.15	3
i1.28	378.47784	-1.7629888058	6.013873	6.012369	-14.181811	0.15	3
i1.28	380.28952	-1.7539736032	6.012369	6.013988	-14.071404	0.15	3
i1.28	382.1012	-1.7628750801	6.013988	6.013264	-13.984535	0.15	3
i1.28	383.91287	-1.8101553917	6.013264	6.015416	-14.076738	0.15	3
i1.28	385.72452	-1.7484577894	6.015416	6.015201	-14.183521	0.15	3
i1.28	387.5362	-1.7653032541	6.015201	6.015509	-14.270302	0.15	3
i1.28	389.34787	-1.7517045736	6.015509	6.014673	-14.373214	0.15	3
i1.28	391.15955	-1.7808425426	6.014673	6.012763	-14.470072	0.15	3
i1.28	392.9712	-1.8021652699	6.012763	6.013931	-14.568702	0.15	3
i1.28	394.78287	-1.7399446964	6.013931	6.012566	-14.66807	0.15	3
i1.28	396.59454	-1.748321414	6.012566	6.012576	-14.78497	0.15	3
i1.28	398.4062	-1.7409781218	6.012576	6.012516	-14.87438	0.15	3
i1.28	400.21786	-1.8091509342	6.012516	6.012558	-14.985098	0.15	3
i1.28	402.02954	-1.7433518171	6.012558	6.012849	-15.077397	0.15	3
i1.28	403.8412	-1.7562668324	6.012849	6.012078	-15.175545	0.15	3
i1.28	405.65286	-1.751026392	6.012078	6.011470	-15.278969	0.15	3
i1.28	407.46454	-1.7974541187	6.011470	6.011488	-15.375034	0.15	3
i1.28	409.27618	-1.7822549343	6.011488	6.011402	-15.482674	0.15	3
i1.28	411.08786	-1.7636247873	6.011402	6.011160	-15.570933	0.15	3
i1.28	412.89954	-1.7488878965	6.011160	6.010816	-15.674755	0.15	3
i1.28	414.71118	-1.7995958328	6.010816	6.010550	-15.778612	0.15	3
i1.28	416.52286	1.746396184	6.010550	6.010352	-15.882106	0.15	3
i1.29	345.85806	-1.7418214083	6.010046	6.010046	-15.977122	0.2	3
i1.29	347.66998	-1.8003548384	6.010046	6.010245	-15.875271	0.2	3
i1.29	349.48187	-1.7949451208	6.010245	6.010719	-15.767115	0.2	3
i1.29	351.2938	-1.7411806583	6.010719	6.010767	-15.676068	0.2	3
i1.29	353.1057	-1.7511746883	6.010767	6.010837	-15.577089	0.2	3
i1.29	354.9176	-1.7918370962	6.010837	6.011638	-15.477936	0.2	3
i1.29	356.72952	-1.793484807	6.011638	6.011437	-15.376283	0.2	3
i1.29	358.54144	-1.7575778961	6.011437	6.011663	-15.265203	0.2	3
i1.29	360.35336	-1.7788341045	6.011663	6.011907	-15.175979	0.2	3
i1.29	362.16525	-1.7427015305	6.011907	6.011984	-15.069221	0.2	3
i1.29	363.97717	-1.7745682001	6.011984	6.013150	-14.970195	0.2	3
i1.29	365.7891	-1.7677813768	6.013150	6.012115	-14.864495	0.2	3
i1.29	367.601	-1.7604570389	6.012115	6.012050	-14.771977	0.2	3
i1.29	369.4129	-1.7685648203	6.012050	6.014282	-14.673324	0.2	3
i1.29	371.22482	-1.802344799	6.014282	6.013254	-14.578303	0.2	3
i1.29	373.03674	-1.8057125807	6.013254	6.013751	-14.474669	0.2	3
i1.29	374.84863	-1.7729219198	6.013751	6.013042	-14.378371	0.2	3
i1.29	376.66055	-1.7727553844	6.013042	6.015162	-14.268671	0.2	3
i1.29	378.47247	-1.7707685232	6.015162	6.015402	-14.168014	0.2	3
i1.29	380.28436	-1.7882817984	6.015402	6.012971	-14.079013	0.2	3
i1.29	382.09628	-1.7848603725	6.012971	6.013880	-13.973636	0.2	3
i1.29	383.9082	-1.7619166374	6.013880	6.014526	-14.071602	0.2	3
i1.29	385.72012	-1.7498013973	6.014526	6.014365	-14.179843	0.2	3
i1.29	387.532	-1.7410662174	6.014365	6.014029	-14.282713	0.2	3
i1.29	389.34393	-1.7498179674	6.014029	6.014955	-14.376405	0.2	3
i1.29	391.15585	-1.7538125515	6.014955	6.013937	-14.482007	0.2	3
i1.29	392.96777	-1.7606540918	6.013937	6.013094	-14.576317	0.2	3
i1.29	394.77966	-1.7681908607	6.013094	6.012582	-14.676992	0.2	3
i1.29	396.59158	-1.8016524315	6.012582	6.013814	-14.775128	0.2	3
i1.29	398.4035	-1.7593148947	6.013814	6.012678	-14.881071	0.2	3
i1.29	400.2154	-1.7560662031	6.012678	6.011861	-14.983223	0.2	3
i1.29	402.0273	-1.7952262163	6.011861	6.012265	-15.074857	0.2	3
i1.29	403.83923	-1.7656800747	6.012265	6.011944	-15.173007	0.2	3
i1.29	405.65115	-1.7852238417	6.011944	6.011825	-15.270596	0.2	3
i1.29	407.46307	-1.7987742424	6.011825	6.012092	-15.376954	0.2	3
i1.29	409.27496	-1.7465339899	6.012092	6.010922	-15.476579	0.2	3
i1.29	411.08688	-1.7863994837	6.010922	6.011167	-15.579573	0.2	3
i1.29	412.8988	-1.7744761705	6.011167	6.010823	-15.679518	0.2	3
i1.29	414.7107	-1.7730696201	6.010823	6.010495	-15.774681	0.2	3
i1.29	416.5226	1.7450591326	6.010495	6.010309	-15.872361	0.2	3
i1.30	345.8395	-1.7530349493	6.010036	6.010036	-15.98175	0.25	3
i1.30	347.6519	-1.7644014359	6.010036	6.010375	-15.877254	0.25	3
i1.30	349.46426	-1.7802571058	6.010375	6.010433	-15.779485	0.25	3
i1.30	351.27664	-1.7848669291	6.010433	6.010983	-15.679255	0.25	3
i1.30	353.08902	-1.7609370947	6.010983	6.010945	-15.571294	0.25	3
i1.30	354.9014	-1.7578725815	6.010945	6.011428	-15.464573	0.25	3
i1.30	356.71378	-1.7746808529	6.011428	6.011904	-15.386501	0.25	3
i1.30	358.52615	-1.7969417572	6.011904	6.011632	-15.277356	0.25	3
i1.30	360.33853	-1.7594256401	6.011632	6.012495	-15.182467	0.25	3
i1.30	362.15088	-1.7594007254	6.012495	6.012542	-15.076841	0.25	3
i1.30	363.96326	-1.7864195108	6.012542	6.012293	-14.977223	0.25	3
i1.30	365.77563	-1.8081966639	6.012293	6.013207	-14.880763	0.25	3
i1.30	367.588	-1.7836326361	6.013207	6.012992	-14.77225	0.25	3
i1.30	369.4004	-1.7907875776	6.012992	6.014116	-14.672297	0.25	3
i1.30	371.21277	-1.7909104824	6.014116	6.012747	-14.573559	0.25	3
i1.30	373.02515	-1.8069367409	6.012747	6.013236	-14.4755	0.25	3
i1.30	374.83752	-1.7534089088	6.013236	6.014451	-14.362134	0.25	3
i1.30	376.6499	-1.7865371704	6.014451	6.013709	-14.276136	0.25	3
i1.30	378.46228	-1.7599250078	6.013709	6.013717	-14.169659	0.25	3
i1.30	380.27466	-1.7981038094	6.013717	6.015540	-14.075396	0.25	3
i1.30	382.08704	-1.7536355257	6.015540	6.014836	-13.973899	0.25	3
i1.30	383.89938	-1.7777564526	6.014836	6.016282	-14.07289	0.25	3
i1.30	385.71176	-1.7429400682	6.016282	6.013948	-14.175052	0.25	3
i1.30	387.52414	-1.7937148809	6.013948	6.014085	-14.266342	0.25	3
i1.30	389.33652	-1.8062745333	6.014085	6.013251	-14.377296	0.25	3
i1.30	391.1489	-1.8066756725	6.013251	6.013462	-14.476785	0.25	3
i1.30	392.96127	-1.7418541908	6.013462	6.014252	-14.567775	0.25	3
i1.30	394.77365	-1.7840819359	6.014252	6.012854	-14.670455	0.25	3
i1.30	396.58603	-1.7533516884	6.012854	6.014011	-14.778311	0.25	3
i1.30	398.3984	-1.7475361824	6.014011	6.013229	-14.873158	0.25	3
i1.30	400.2108	-1.7467186451	6.013229	6.012631	-14.981349	0.25	3
i1.30	402.02313	-1.7553533316	6.012631	6.012571	-15.074517	0.25	3
i1.30	403.8355	-1.7742766142	6.012571	6.011668	-15.174184	0.25	3
i1.30	405.6479	-1.7725371122	6.011668	6.012044	-15.27293	0.25	3
i1.30	407.46027	-1.7772853374	6.012044	6.011202	-15.373204	0.25	3
i1.30	409.27264	-1.7644759417	6.011202	6.010989	-15.465575	0.25	3
i1.30	411.08502	-1.787800312	6.010989	6.011027	-15.570846	0.25	3
i1.30	412.8974	-1.7715380192	6.011027	6.010698	-15.67358	0.25	3
i1.30	414.70978	-1.7937926054	6.010698	6.010669	-15.778595	0.25	3
i1.30	416.52216	1.7540802956	6.010669	6.010312	-15.872166	0.25	3
i1.31	345.842	-1.8120788336	6.010035	6.010035	-15.970286	0.3	3
i1.31	347.65433	-1.8040126562	6.010035	6.010266	-15.869678	0.3	3
i1.31	349.46664	-1.8064590693	6.010266	6.010389	-15.770081	0.3	3
i1.31	351.27893	-1.7664829493	6.010389	6.010766	-15.684927	0.3	3
i1.31	353.09125	-1.7987855673	6.010766	6.011011	-15.579189	0.3	3
i1.31	354.90356	-1.7653013468	6.011011	6.011258	-15.476664	0.3	3
i1.31	356.71588	-1.8085304499	6.011258	6.012291	-15.374629	0.3	3
i1.31	358.5282	-1.7489660978	6.012291	6.012048	-15.268272	0.3	3
i1.31	360.3405	-1.7675757408	6.012048	6.012830	-15.174439	0.3	3
i1.31	362.15283	-1.7896511555	6.012830	6.012456	-15.075666	0.3	3
i1.31	363.96515	-1.7692027092	6.012456	6.012664	-14.969261	0.3	3
i1.31	365.77744	-1.7650107145	6.012664	6.012167	-14.869938	0.3	3
i1.31	367.58975	-1.8055958748	6.012167	6.013710	-14.767079	0.3	3
i1.31	369.40207	-1.7802919149	6.013710	6.013011	-14.674954	0.3	3
i1.31	371.2144	-1.7918994427	6.013011	6.012988	-14.56792	0.3	3
i1.31	373.0267	-1.7918769121	6.012988	6.013593	-14.461164	0.3	3
i1.31	374.83902	-1.7556093931	6.013593	6.014285	-14.371425	0.3	3
i1.31	376.65134	-1.799700141	6.014285	6.014608	-14.273633	0.3	3
i1.31	378.46365	-1.7598682642	6.014608	6.015154	-14.177529	0.3	3
i1.31	380.27594	-1.7984037399	6.015154	6.016367	-14.074569	0.3	3
i1.31	382.08826	-1.7485620975	6.016367	6.015509	-13.978551	0.3	3
i1.31	383.90057	-1.8035966158	6.015509	6.014568	-14.074092	0.3	3
i1.31	385.7129	-1.7743731737	6.014568	6.014971	-14.178537	0.3	3
i1.31	387.5252	-1.773963213	6.014971	6.013356	-14.273357	0.3	3
i1.31	389.33752	-1.7757092714	6.013356	6.014156	-14.381558	0.3	3
i1.31	391.14984	-1.7541048527	6.014156	6.013952	-14.480184	0.3	3
i1.31	392.96216	-1.7450416088	6.013952	6.013177	-14.573773	0.3	3
i1.31	394.77444	-1.7484846115	6.013177	6.013694	-14.670417	0.3	3
i1.31	396.58676	-1.7517604828	6.013694	6.013174	-14.778813	0.3	3
i1.31	398.39908	-1.7945270538	6.013174	6.013468	-14.868264	0.3	3
i1.31	400.2114	-1.7658879757	6.013468	6.012797	-14.975193	0.3	3
i1.31	402.0237	-1.8071234226	6.012797	6.012386	-15.071005	0.3	3
i1.31	403.83603	-1.8041895628	6.012386	6.011889	-15.173013	0.3	3
i1.31	405.64835	-1.7948452234	6.011889	6.011646	-15.2701	0.3	3
i1.31	407.46063	-1.7793213129	6.011646	6.011258	-15.376041	0.3	3
i1.31	409.27295	-1.7921127081	6.011258	6.011058	-15.468987	0.3	3
i1.31	411.08527	-1.8021668196	6.011058	6.010800	-15.575243	0.3	3
i1.31	412.89758	-1.7752513885	6.010800	6.010793	-15.676404	0.3	3
i1.31	414.7099	-1.7876822948	6.010793	6.010649	-15.771282	0.3	3
i1.31	416.52222	1.8110713959	6.010649	6.010367	-15.877745	0.3	3
i11	0	423.4999389648	
i12	0	423.4999389648	
i13	0	423.4999389648	
i14	0	423.4999389648	
e

</CsScore>

</CsoundSynthesizer>
