/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.easymock.ConstructorArgs;
import org.easymock.internal.BridgeMethodResolver;
import org.easymock.internal.ClassInstantiatorFactory;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.MethodSerializationWrapper;
import org.easymock.internal.MockInvocationHandler;

public class ClassProxyFactory
implements IProxyFactory {
    private static final NamingPolicy ALLOWS_MOCKING_CLASSES_IN_SIGNED_PACKAGES = new DefaultNamingPolicy(){

        public String getClassName(String string, String string2, Object object, Predicate predicate) {
            return "codegen." + super.getClassName(string, string2, object, predicate);
        }
    };

    public static boolean isCallerMockInvocationHandlerInvoke(Throwable throwable) throws Throwable {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        return stackTraceElementArray.length > 2 && stackTraceElementArray[2].getClassName().equals(MockInvocationHandler.class.getName()) && stackTraceElementArray[2].getMethodName().equals("invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T createProxy(Class<T> clazz, InvocationHandler invocationHandler, Method[] methodArray, ConstructorArgs constructorArgs) {
        Class clazz2;
        Enhancer enhancer = this.createEnhancer(clazz);
        MockMethodInterceptor mockMethodInterceptor = new MockMethodInterceptor(invocationHandler);
        if (methodArray != null) {
            mockMethodInterceptor.setMockedMethods(methodArray);
        }
        enhancer.setCallbackType(mockMethodInterceptor.getClass());
        try {
            clazz2 = enhancer.createClass();
        }
        catch (CodeGenerationException codeGenerationException) {
            enhancer.setClassLoader(this.getClass().getClassLoader());
            clazz2 = enhancer.createClass();
        }
        try {
            Factory factory;
            Enhancer.registerCallbacks((Class)clazz2, (Callback[])new Callback[]{mockMethodInterceptor});
            if (constructorArgs != null) {
                Object t;
                Constructor constructor;
                try {
                    constructor = clazz2.getDeclaredConstructor(constructorArgs.getConstructor().getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException("Fail to find constructor for param types", noSuchMethodException);
                }
                try {
                    constructor.setAccessible(true);
                    t = constructor.newInstance(constructorArgs.getInitArgs());
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor", illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException("Failed to instantiate mock calling constructor: Exception in constructor", invocationTargetException.getTargetException());
                }
                Object t2 = t;
                return t2;
            }
            try {
                factory = (Factory)ClassInstantiatorFactory.getInstantiator().newInstance(clazz2);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("Fail to instantiate mock for " + clazz + " on " + ClassInstantiatorFactory.getJVM() + " JVM");
            }
            factory.getCallback(0);
            Factory factory2 = factory;
            return (T)factory2;
        }
        finally {
            Enhancer.registerCallbacks((Class)clazz2, null);
        }
    }

    private Enhancer createEnhancer(Class<?> clazz) {
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class clazz, List list) {
                CollectionUtils.filter((Collection)list, (Predicate)new VisibilityPredicate(clazz, true));
            }
        };
        enhancer.setSuperclass(clazz);
        if (clazz.getSigners() != null) {
            enhancer.setNamingPolicy(ALLOWS_MOCKING_CLASSES_IN_SIGNED_PACKAGES);
        }
        return enhancer;
    }

    @Override
    public InvocationHandler getInvocationHandler(Object object) {
        Factory factory = (Factory)object;
        return ((MockMethodInterceptor)factory.getCallback(0)).handler;
    }

    public static class MockMethodInterceptor
    implements MethodInterceptor,
    Serializable {
        private static final long serialVersionUID = -9054190871232972342L;
        private final InvocationHandler handler;
        private transient Set<Method> mockedMethods;

        public MockMethodInterceptor(InvocationHandler invocationHandler) {
            this.handler = invocationHandler;
        }

        public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
            if (Modifier.isAbstract(method.getModifiers())) {
                return this.handler.invoke(object, method, objectArray);
            }
            if (object instanceof Throwable && method.getName().equals("fillInStackTrace") && ClassProxyFactory.isCallerMockInvocationHandlerInvoke(new Throwable())) {
                return object;
            }
            if (method.isBridge()) {
                method = BridgeMethodResolver.findBridgedMethod(method);
            }
            if (this.mockedMethods != null && !this.mockedMethods.contains(method)) {
                return methodProxy.invokeSuper(object, objectArray);
            }
            return this.handler.invoke(object, method, objectArray);
        }

        public void setMockedMethods(Method ... methodArray) {
            this.mockedMethods = new HashSet<Method>(Arrays.asList(methodArray));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Set set = (Set)objectInputStream.readObject();
            if (set == null) {
                return;
            }
            this.mockedMethods = new HashSet<Method>(set.size());
            for (MethodSerializationWrapper methodSerializationWrapper : set) {
                try {
                    this.mockedMethods.add(methodSerializationWrapper.getMethod());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IOException(noSuchMethodException.toString());
                }
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.mockedMethods == null) {
                objectOutputStream.writeObject(null);
                return;
            }
            HashSet<MethodSerializationWrapper> hashSet = new HashSet<MethodSerializationWrapper>(this.mockedMethods.size());
            for (Method method : this.mockedMethods) {
                hashSet.add(new MethodSerializationWrapper(method));
            }
            objectOutputStream.writeObject(hashSet);
        }
    }
}

