/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.easymock.ConstructorArgs;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.easymock.IMockBuilder;
import org.easymock.IMocksControl;
import org.easymock.MockType;
import org.easymock.internal.ReflectionUtils;

public class MockBuilder<T>
implements IMockBuilder<T> {
    private final Class<T> toMock;
    private Set<Method> mockedMethods;
    private Constructor<T> constructor;
    private ConstructorArgs constructorArgs;
    private final EasyMockSupport support;

    public MockBuilder(Class<T> clazz) {
        this(clazz, null);
    }

    public MockBuilder(Class<T> clazz, EasyMockSupport easyMockSupport) {
        this.toMock = clazz;
        this.support = easyMockSupport;
    }

    @Override
    public IMockBuilder<T> addMockedMethod(Method method) {
        if (Modifier.isFinal(method.getModifiers())) {
            throw new IllegalArgumentException("Final methods can't be mocked");
        }
        if (this.mockedMethods == null) {
            this.mockedMethods = new HashSet<Method>();
        }
        this.mockedMethods.add(method);
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethod(String string) {
        Method method = ReflectionUtils.findMethod(this.toMock, string);
        if (method == null) {
            throw new IllegalArgumentException("Method not found (or private): " + string);
        }
        this.addMockedMethod(method);
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethod(String string, Class<?> ... classArray) {
        Method method = ReflectionUtils.findMethod(this.toMock, string, classArray);
        if (method == null) {
            throw new IllegalArgumentException("Method not found (or private): " + string);
        }
        this.addMockedMethod(method);
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethods(String ... stringArray) {
        for (String string : stringArray) {
            this.addMockedMethod(string);
        }
        return this;
    }

    @Override
    public IMockBuilder<T> addMockedMethods(Method ... methodArray) {
        for (Method method : methodArray) {
            this.addMockedMethod(method);
        }
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor(Constructor<?> constructor) {
        this.checkConstructorNotInitialized();
        this.constructor = constructor;
        return this;
    }

    public IMockBuilder<T> withConstructor(ConstructorArgs constructorArgs) {
        this.checkConstructorNotInitialized();
        this.constructor = constructorArgs.getConstructor();
        this.constructorArgs = constructorArgs;
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor() {
        this.checkConstructorNotInitialized();
        try {
            this.constructor = ReflectionUtils.getConstructor(this.toMock, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No empty constructor can be found", noSuchMethodException);
        }
        this.constructorArgs = new ConstructorArgs(this.constructor, new Object[0]);
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor(Object ... objectArray) {
        this.checkConstructorNotInitialized();
        try {
            this.constructor = ReflectionUtils.getConstructor(this.toMock, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No constructor matching arguments can be found", noSuchMethodException);
        }
        this.constructorArgs = new ConstructorArgs(this.constructor, objectArray);
        return this;
    }

    @Override
    public IMockBuilder<T> withConstructor(Class<?> ... classArray) {
        this.checkConstructorNotInitialized();
        try {
            this.constructor = this.toMock.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("No constructor matching arguments can be found", noSuchMethodException);
        }
        return this;
    }

    @Override
    public IMockBuilder<T> withArgs(Object ... objectArray) {
        if (this.constructor == null) {
            throw new IllegalStateException("Trying to define constructor arguments without first setting their type.");
        }
        if (this.constructorArgs != null) {
            throw new IllegalStateException("Trying to define the constructor arguments more than once.");
        }
        this.constructorArgs = new ConstructorArgs(this.constructor, objectArray);
        return this;
    }

    @Override
    public T createMock(MockType mockType) {
        IMocksControl iMocksControl = this.support == null ? EasyMock.createControl(mockType) : this.support.createControl(mockType);
        return this.createMock(null, iMocksControl);
    }

    @Override
    public T createMock(String string, MockType mockType) {
        IMocksControl iMocksControl = this.support == null ? EasyMock.createControl(mockType) : this.support.createControl(mockType);
        return this.createMock(string, iMocksControl);
    }

    @Override
    public T createMock(IMocksControl iMocksControl) {
        return this.createMock(null, iMocksControl);
    }

    @Override
    public T createMock() {
        return this.createMock((String)null);
    }

    @Override
    public T createNiceMock() {
        return this.createNiceMock(null);
    }

    @Override
    public T createStrictMock() {
        return this.createStrictMock(null);
    }

    @Override
    public T createMock(String string, IMocksControl iMocksControl) {
        Method[] methodArray;
        Method[] methodArray2 = methodArray = this.mockedMethods == null ? new Method[]{} : this.mockedMethods.toArray(new Method[this.mockedMethods.size()]);
        if (this.constructor == null) {
            return iMocksControl.createMock(string, this.toMock, null, methodArray);
        }
        if (this.constructorArgs == null) {
            throw new IllegalStateException("Picked a constructor but didn't pass arguments to it");
        }
        return iMocksControl.createMock(string, this.toMock, this.constructorArgs, methodArray);
    }

    @Override
    public T createMock(String string) {
        IMocksControl iMocksControl = this.support == null ? EasyMock.createControl() : this.support.createControl();
        return this.createMock(string, iMocksControl);
    }

    @Override
    public T createNiceMock(String string) {
        IMocksControl iMocksControl = this.support == null ? EasyMock.createNiceControl() : this.support.createNiceControl();
        return this.createMock(string, iMocksControl);
    }

    @Override
    public T createStrictMock(String string) {
        IMocksControl iMocksControl = this.support == null ? EasyMock.createStrictControl() : this.support.createStrictControl();
        return this.createMock(string, iMocksControl);
    }

    private void checkConstructorNotInitialized() {
        if (this.constructor != null) {
            throw new IllegalStateException("Trying to define the constructor call more than once.");
        }
    }
}

