/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.EasyMockProperties;
import org.easymock.internal.ErrorMessage;
import org.easymock.internal.ExpectedInvocation;
import org.easymock.internal.ExpectedInvocationAndResult;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.Invocation;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.Result;
import org.easymock.internal.UnorderedBehavior;

public class MocksBehavior
implements IMocksBehavior,
Serializable {
    private static final long serialVersionUID = 3265727009370529027L;
    private final List<UnorderedBehavior> behaviorLists = new ArrayList<UnorderedBehavior>();
    private final List<ExpectedInvocationAndResult> stubResults = new ArrayList<ExpectedInvocationAndResult>();
    private final boolean nice;
    private boolean checkOrder;
    private boolean isThreadSafe;
    private boolean shouldBeUsedInOneThread;
    private int position = 0;
    private volatile transient Thread lastThread;

    public MocksBehavior(boolean bl) {
        this.nice = bl;
        this.isThreadSafe = Boolean.valueOf(EasyMockProperties.getInstance().getProperty("easymock.notThreadSafeByDefault")) == false;
        this.shouldBeUsedInOneThread = Boolean.valueOf(EasyMockProperties.getInstance().getProperty("easymock.enableThreadSafetyCheckByDefault"));
    }

    @Override
    public final void addStub(ExpectedInvocation expectedInvocation, Result result) {
        this.stubResults.add(new ExpectedInvocationAndResult(expectedInvocation, result));
    }

    @Override
    public void addExpected(ExpectedInvocation expectedInvocation, Result result, Range range) {
        this.addBehaviorListIfNecessary(expectedInvocation);
        this.lastBehaviorList().addExpected(expectedInvocation, result, range);
    }

    private Result getStubResult(Invocation invocation) {
        for (ExpectedInvocationAndResult expectedInvocationAndResult : this.stubResults) {
            if (!expectedInvocationAndResult.getExpectedInvocation().matches(invocation)) continue;
            return expectedInvocationAndResult.getResult();
        }
        return null;
    }

    private void addBehaviorListIfNecessary(ExpectedInvocation expectedInvocation) {
        if (this.behaviorLists.isEmpty() || !this.lastBehaviorList().allowsExpectedInvocation(expectedInvocation, this.checkOrder)) {
            this.behaviorLists.add(new UnorderedBehavior(this.checkOrder));
        }
    }

    private UnorderedBehavior lastBehaviorList() {
        return this.behaviorLists.get(this.behaviorLists.size() - 1);
    }

    @Override
    public final Result addActual(Invocation invocation) {
        Result result;
        int n = this.position;
        while (this.position < this.behaviorLists.size()) {
            result = this.behaviorLists.get(this.position).addActual(invocation);
            if (result != null) {
                return result;
            }
            if (!this.behaviorLists.get(this.position).verify()) break;
            ++this.position;
        }
        if ((result = this.getStubResult(invocation)) == null && this.nice) {
            result = Result.createReturnResult(RecordState.emptyReturnValueFor(invocation.getMethod().getReturnType()));
        }
        int n2 = this.position;
        this.position = n;
        if (result != null) {
            invocation.validateCaptures();
            invocation.clearCaptures();
            return result;
        }
        if (n2 == this.behaviorLists.size()) {
            --n2;
        }
        StringBuilder stringBuilder = new StringBuilder(70 * (n2 - n + 1));
        stringBuilder.append("\n  Unexpected method call ").append(invocation.toString());
        ArrayList<ErrorMessage> arrayList = new ArrayList<ErrorMessage>();
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            List<ErrorMessage> object = this.behaviorLists.get(i).getMessages(invocation);
            arrayList.addAll(object);
            for (ErrorMessage errorMessage : object) {
                if (!errorMessage.isMatching()) continue;
                ++n3;
            }
        }
        if (n3 > 1) {
            stringBuilder.append(". Possible matches are marked with (+1):");
        } else {
            stringBuilder.append(":");
        }
        for (ErrorMessage errorMessage : arrayList) {
            errorMessage.appendTo(stringBuilder, n3);
        }
        throw new AssertionErrorWrapper(new AssertionError(stringBuilder));
    }

    @Override
    public void verify() {
        boolean bl = true;
        for (UnorderedBehavior object : this.behaviorLists.subList(this.position, this.behaviorLists.size())) {
            if (object.verify()) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(70 * (this.behaviorLists.size() - this.position + 1));
        stringBuilder.append("\n  Expectation failure on verify:");
        for (UnorderedBehavior unorderedBehavior : this.behaviorLists.subList(this.position, this.behaviorLists.size())) {
            for (ErrorMessage errorMessage : unorderedBehavior.getMessages(null)) {
                errorMessage.appendTo(stringBuilder, 0);
            }
        }
        throw new AssertionErrorWrapper(new AssertionError((Object)stringBuilder.toString()));
    }

    @Override
    public void checkOrder(boolean bl) {
        this.checkOrder = bl;
    }

    @Override
    public void makeThreadSafe(boolean bl) {
        this.isThreadSafe = bl;
    }

    @Override
    public void shouldBeUsedInOneThread(boolean bl) {
        this.shouldBeUsedInOneThread = bl;
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    @Override
    public void checkThreadSafety() {
        if (!this.shouldBeUsedInOneThread) {
            return;
        }
        if (this.lastThread == null) {
            this.lastThread = Thread.currentThread();
        } else if (this.lastThread != Thread.currentThread()) {
            throw new AssertionErrorWrapper(new AssertionError((Object)("\n Mock isn't supposed to be called from multiple threads. Last: " + this.lastThread + " Current: " + Thread.currentThread())));
        }
    }
}

