/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.CharStringHandler;
import org.apache.fontbox.encoding.StandardEncoding;
import org.apache.fontbox.type1.Type1CharStringReader;

public class Type1CharString {
    private static final Log LOG = LogFactory.getLog(Type1CharString.class);
    private Type1CharStringReader font;
    private final String fontName;
    private final String glyphName;
    private GeneralPath path = null;
    private int width = 0;
    private Point2D.Float leftSideBearing = null;
    private Point2D.Float current = null;
    private boolean isFlex = false;
    private final List<Point2D.Float> flexPoints = new ArrayList<Point2D.Float>();
    protected List<Object> type1Sequence;
    protected int commandCount;

    public Type1CharString(Type1CharStringReader type1CharStringReader, String string, String string2, List<Object> list) {
        this(type1CharStringReader, string, string2);
        this.type1Sequence = list;
    }

    protected Type1CharString(Type1CharStringReader type1CharStringReader, String string, String string2) {
        this.font = type1CharStringReader;
        this.fontName = string;
        this.glyphName = string2;
        this.current = new Point2D.Float(0.0f, 0.0f);
    }

    public String getName() {
        return this.glyphName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle2D getBounds() {
        Log log = LOG;
        synchronized (log) {
            if (this.path == null) {
                this.render();
            }
        }
        return this.path.getBounds2D();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Log log = LOG;
        synchronized (log) {
            if (this.path == null) {
                this.render();
            }
        }
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneralPath getPath() {
        Log log = LOG;
        synchronized (log) {
            if (this.path == null) {
                this.render();
            }
        }
        return this.path;
    }

    public List<Object> getType1Sequence() {
        return this.type1Sequence;
    }

    private void render() {
        this.path = new GeneralPath();
        this.leftSideBearing = new Point2D.Float(0.0f, 0.0f);
        this.width = 0;
        CharStringHandler charStringHandler = new CharStringHandler(){

            @Override
            public List<Number> handleCommand(List<Number> list, CharStringCommand charStringCommand) {
                return Type1CharString.this.handleCommand(list, charStringCommand);
            }
        };
        charStringHandler.handleSequence(this.type1Sequence);
    }

    private List<Number> handleCommand(List<Number> list, CharStringCommand charStringCommand) {
        ++this.commandCount;
        String string = CharStringCommand.TYPE1_VOCABULARY.get(charStringCommand.getKey());
        if ("rmoveto".equals(string)) {
            if (list.size() >= 2) {
                if (this.isFlex) {
                    this.flexPoints.add(new Point2D.Float(list.get(0).floatValue(), list.get(1).floatValue()));
                } else {
                    this.rmoveTo(list.get(0), list.get(1));
                }
            }
        } else if ("vmoveto".equals(string)) {
            if (list.size() >= 1) {
                if (this.isFlex) {
                    this.flexPoints.add(new Point2D.Float(0.0f, list.get(0).floatValue()));
                } else {
                    this.rmoveTo(0, list.get(0));
                }
            }
        } else if ("hmoveto".equals(string)) {
            if (list.size() >= 1) {
                if (this.isFlex) {
                    this.flexPoints.add(new Point2D.Float(list.get(0).floatValue(), 0.0f));
                } else {
                    this.rmoveTo(list.get(0), 0);
                }
            }
        } else if ("rlineto".equals(string)) {
            if (list.size() >= 2) {
                this.rlineTo(list.get(0), list.get(1));
            }
        } else if ("hlineto".equals(string)) {
            if (list.size() >= 1) {
                this.rlineTo(list.get(0), 0);
            }
        } else if ("vlineto".equals(string)) {
            if (list.size() >= 1) {
                this.rlineTo(0, list.get(0));
            }
        } else if ("rrcurveto".equals(string)) {
            if (list.size() >= 6) {
                this.rrcurveTo(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4), list.get(5));
            }
        } else if ("closepath".equals(string)) {
            this.closepath();
        } else if ("sbw".equals(string)) {
            if (list.size() >= 3) {
                this.leftSideBearing = new Point2D.Float(list.get(0).floatValue(), list.get(1).floatValue());
                this.width = list.get(2).intValue();
                this.current.setLocation(this.leftSideBearing);
            }
        } else if ("hsbw".equals(string)) {
            if (list.size() >= 2) {
                this.leftSideBearing = new Point2D.Float(list.get(0).floatValue(), 0.0f);
                this.width = list.get(1).intValue();
                this.current.setLocation(this.leftSideBearing);
            }
        } else if ("vhcurveto".equals(string)) {
            if (list.size() >= 4) {
                this.rrcurveTo(0, list.get(0), list.get(1), list.get(2), list.get(3), 0);
            }
        } else if ("hvcurveto".equals(string)) {
            if (list.size() >= 4) {
                this.rrcurveTo(list.get(0), 0, list.get(1), list.get(2), 0, list.get(3));
            }
        } else if ("seac".equals(string)) {
            if (list.size() >= 5) {
                this.seac(list.get(0), list.get(1), list.get(2), list.get(3), list.get(4));
            }
        } else if ("setcurrentpoint".equals(string)) {
            if (list.size() >= 2) {
                this.setcurrentpoint(list.get(0), list.get(1));
            }
        } else if ("callothersubr".equals(string)) {
            if (list.size() >= 1) {
                this.callothersubr(list.get(0).intValue());
            }
        } else {
            if ("div".equals(string)) {
                float f = list.get(list.size() - 1).floatValue();
                float f2 = list.get(list.size() - 2).floatValue();
                float f3 = f2 / f;
                ArrayList<Number> arrayList = new ArrayList<Number>(list);
                arrayList.remove(arrayList.size() - 1);
                arrayList.remove(arrayList.size() - 1);
                arrayList.add(Float.valueOf(f3));
                return arrayList;
            }
            if (!("hstem".equals(string) || "vstem".equals(string) || "hstem3".equals(string) || "vstem3".equals(string) || "dotsection".equals(string) || "endchar".equals(string))) {
                if ("return".equals(string)) {
                    LOG.warn((Object)("Unexpected charstring command: " + charStringCommand.getKey() + " in glyph " + this.glyphName + " of font " + this.fontName));
                } else {
                    if (string != null) {
                        throw new IllegalArgumentException("Unhandled command: " + string);
                    }
                    LOG.warn((Object)("Unknown charstring command: " + charStringCommand.getKey() + " in glyph " + this.glyphName + " of font " + this.fontName));
                }
            }
        }
        return null;
    }

    private void setcurrentpoint(Number number, Number number2) {
        this.current.setLocation(number.floatValue(), number2.floatValue());
    }

    private void callothersubr(int n) {
        if (n == 0) {
            this.isFlex = false;
            if (this.flexPoints.size() < 7) {
                LOG.warn((Object)("flex without moveTo in font " + this.fontName + ", glyph " + this.glyphName + ", command " + this.commandCount));
                return;
            }
            Point2D.Float float_ = this.flexPoints.get(0);
            float_.setLocation(this.current.getX() + float_.getX(), this.current.getY() + float_.getY());
            Point2D.Float float_2 = this.flexPoints.get(1);
            float_2.setLocation(float_.getX() + float_2.getX(), float_.getY() + float_2.getY());
            float_2.setLocation(float_2.getX() - this.current.getX(), float_2.getY() - this.current.getY());
            this.rrcurveTo(this.flexPoints.get(1).getX(), this.flexPoints.get(1).getY(), this.flexPoints.get(2).getX(), this.flexPoints.get(2).getY(), this.flexPoints.get(3).getX(), this.flexPoints.get(3).getY());
            this.rrcurveTo(this.flexPoints.get(4).getX(), this.flexPoints.get(4).getY(), this.flexPoints.get(5).getX(), this.flexPoints.get(5).getY(), this.flexPoints.get(6).getX(), this.flexPoints.get(6).getY());
            this.flexPoints.clear();
        } else if (n == 1) {
            this.isFlex = true;
        } else {
            throw new IllegalArgumentException("Unexpected other subroutine: " + n);
        }
    }

    private void rmoveTo(Number number, Number number2) {
        float f = (float)this.current.getX() + number.floatValue();
        float f2 = (float)this.current.getY() + number2.floatValue();
        this.path.moveTo(f, f2);
        this.current.setLocation(f, f2);
    }

    private void rlineTo(Number number, Number number2) {
        float f = (float)this.current.getX() + number.floatValue();
        float f2 = (float)this.current.getY() + number2.floatValue();
        if (this.path.getCurrentPoint() == null) {
            LOG.warn((Object)("rlineTo without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
            this.path.moveTo(f, f2);
        } else {
            this.path.lineTo(f, f2);
        }
        this.current.setLocation(f, f2);
    }

    private void rrcurveTo(Number number, Number number2, Number number3, Number number4, Number number5, Number number6) {
        float f = (float)this.current.getX() + number.floatValue();
        float f2 = (float)this.current.getY() + number2.floatValue();
        float f3 = f + number3.floatValue();
        float f4 = f2 + number4.floatValue();
        float f5 = f3 + number5.floatValue();
        float f6 = f4 + number6.floatValue();
        if (this.path.getCurrentPoint() == null) {
            LOG.warn((Object)("rrcurveTo without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
            this.path.moveTo(f5, f6);
        } else {
            this.path.curveTo(f, f2, f3, f4, f5, f6);
        }
        this.current.setLocation(f5, f6);
    }

    private void closepath() {
        if (this.path.getCurrentPoint() == null) {
            LOG.warn((Object)("closepath without initial moveTo in font " + this.fontName + ", glyph " + this.glyphName));
        } else {
            this.path.closePath();
        }
        this.path.moveTo(this.current.getX(), this.current.getY());
    }

    private void seac(Number number, Number number2, Number number3, Number number4, Number number5) {
        Object object;
        String string = StandardEncoding.INSTANCE.getName(number4.intValue());
        if (string != null) {
            try {
                object = this.font.getType1CharString(string);
                this.path.append(((Type1CharString)object).getPath().getPathIterator(null), false);
            }
            catch (IOException iOException) {
                LOG.warn((Object)("invalid seac character in glyph " + this.glyphName + " of font " + this.fontName));
            }
        }
        if ((object = StandardEncoding.INSTANCE.getName(number5.intValue())) != null) {
            try {
                Type1CharString type1CharString = this.font.getType1CharString((String)object);
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.leftSideBearing.getX() + (double)number2.floatValue(), this.leftSideBearing.getY() + (double)number3.floatValue());
                this.path.append(type1CharString.getPath().getPathIterator(affineTransform), false);
            }
            catch (IOException iOException) {
                LOG.warn((Object)("invalid seac character in glyph " + this.glyphName + " of font " + this.fontName));
            }
        }
    }

    public String toString() {
        return this.type1Sequence.toString().replace("|", "\n").replace(",", " ");
    }
}

