/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.StreamCompressor;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.Zip64RequiredException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.utils.IOUtils;

public class ZipArchiveOutputStream
extends ArchiveOutputStream {
    static final int BUFFER_SIZE = 512;
    private static final int LFH_SIG_OFFSET = 0;
    private static final int LFH_VERSION_NEEDED_OFFSET = 4;
    private static final int LFH_GPB_OFFSET = 6;
    private static final int LFH_METHOD_OFFSET = 8;
    private static final int LFH_TIME_OFFSET = 10;
    private static final int LFH_CRC_OFFSET = 14;
    private static final int LFH_COMPRESSED_SIZE_OFFSET = 18;
    private static final int LFH_ORIGINAL_SIZE_OFFSET = 22;
    private static final int LFH_FILENAME_LENGTH_OFFSET = 26;
    private static final int LFH_EXTRA_LENGTH_OFFSET = 28;
    private static final int LFH_FILENAME_OFFSET = 30;
    private static final int CFH_SIG_OFFSET = 0;
    private static final int CFH_VERSION_MADE_BY_OFFSET = 4;
    private static final int CFH_VERSION_NEEDED_OFFSET = 6;
    private static final int CFH_GPB_OFFSET = 8;
    private static final int CFH_METHOD_OFFSET = 10;
    private static final int CFH_TIME_OFFSET = 12;
    private static final int CFH_CRC_OFFSET = 16;
    private static final int CFH_COMPRESSED_SIZE_OFFSET = 20;
    private static final int CFH_ORIGINAL_SIZE_OFFSET = 24;
    private static final int CFH_FILENAME_LENGTH_OFFSET = 28;
    private static final int CFH_EXTRA_LENGTH_OFFSET = 30;
    private static final int CFH_COMMENT_LENGTH_OFFSET = 32;
    private static final int CFH_DISK_NUMBER_OFFSET = 34;
    private static final int CFH_INTERNAL_ATTRIBUTES_OFFSET = 36;
    private static final int CFH_EXTERNAL_ATTRIBUTES_OFFSET = 38;
    private static final int CFH_LFH_OFFSET = 42;
    private static final int CFH_FILENAME_OFFSET = 46;
    protected boolean finished = false;
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    static final String DEFAULT_ENCODING = "UTF8";
    @Deprecated
    public static final int EFS_FLAG = 2048;
    private static final byte[] EMPTY = new byte[0];
    private CurrentEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private final List<ZipArchiveEntry> entries = new LinkedList<ZipArchiveEntry>();
    private final StreamCompressor streamCompressor;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private static final byte[] ONE = ZipLong.getBytes(1L);
    private final Map<ZipArchiveEntry, Long> offsets = new HashMap<ZipArchiveEntry, Long>();
    private String encoding = "UTF8";
    private ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding("UTF8");
    protected final Deflater def;
    private final SeekableByteChannel channel;
    private final OutputStream out;
    private boolean useUTF8Flag = true;
    private boolean fallbackToUTF8 = false;
    private UnicodeExtraFieldPolicy createUnicodeExtraFields = UnicodeExtraFieldPolicy.NEVER;
    private boolean hasUsedZip64 = false;
    private Zip64Mode zip64Mode = Zip64Mode.AsNeeded;
    private final byte[] copyBuffer = new byte[32768];
    private final Calendar calendarInstance = Calendar.getInstance();
    static final byte[] LFH_SIG = ZipLong.LFH_SIG.getBytes();
    static final byte[] DD_SIG = ZipLong.DD_SIG.getBytes();
    static final byte[] CFH_SIG = ZipLong.CFH_SIG.getBytes();
    static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    static final byte[] ZIP64_EOCD_SIG = ZipLong.getBytes(101075792L);
    static final byte[] ZIP64_EOCD_LOC_SIG = ZipLong.getBytes(117853008L);

    public ZipArchiveOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.channel = null;
        this.def = new Deflater(this.level, true);
        this.streamCompressor = StreamCompressor.create(outputStream, this.def);
    }

    public ZipArchiveOutputStream(File file) throws IOException {
        this.def = new Deflater(this.level, true);
        FileOutputStream fileOutputStream = null;
        SeekableByteChannel seekableByteChannel = null;
        StreamCompressor streamCompressor = null;
        try {
            seekableByteChannel = Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);
            streamCompressor = StreamCompressor.create(seekableByteChannel, this.def);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(seekableByteChannel);
            seekableByteChannel = null;
            fileOutputStream = new FileOutputStream(file);
            streamCompressor = StreamCompressor.create(fileOutputStream, this.def);
        }
        this.out = fileOutputStream;
        this.channel = seekableByteChannel;
        this.streamCompressor = streamCompressor;
    }

    public ZipArchiveOutputStream(SeekableByteChannel seekableByteChannel) throws IOException {
        this.channel = seekableByteChannel;
        this.def = new Deflater(this.level, true);
        this.streamCompressor = StreamCompressor.create(seekableByteChannel, this.def);
        this.out = null;
    }

    public boolean isSeekable() {
        return this.channel != null;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        if (this.useUTF8Flag && !ZipEncodingHelper.isUTF8(string)) {
            this.useUTF8Flag = false;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseLanguageEncodingFlag(boolean bl) {
        this.useUTF8Flag = bl && ZipEncodingHelper.isUTF8(this.encoding);
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraFieldPolicy unicodeExtraFieldPolicy) {
        this.createUnicodeExtraFields = unicodeExtraFieldPolicy;
    }

    public void setFallbackToUTF8(boolean bl) {
        this.fallbackToUTF8 = bl;
    }

    public void setUseZip64(Zip64Mode zip64Mode) {
        this.zip64Mode = zip64Mode;
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.cdOffset = this.streamCompressor.getTotalBytesWritten();
        this.writeCentralDirectoryInChunks();
        this.cdLength = this.streamCompressor.getTotalBytesWritten() - this.cdOffset;
        this.writeZip64CentralDirectory();
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.clear();
        this.streamCompressor.close();
        this.finished = true;
    }

    private void writeCentralDirectoryInChunks() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(70000);
        int n = 0;
        for (ZipArchiveEntry zipArchiveEntry : this.entries) {
            byteArrayOutputStream.write(this.createCentralFileHeader(zipArchiveEntry));
            if (++n <= 1000) continue;
            this.writeCounted(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.reset();
            n = 0;
        }
        this.writeCounted(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void closeArchiveEntry() throws IOException {
        this.preClose();
        this.flushDeflater();
        long l = this.streamCompressor.getTotalBytesWritten() - this.entry.dataStart;
        long l2 = this.streamCompressor.getCrc32();
        this.entry.bytesRead = this.streamCompressor.getBytesRead();
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        boolean bl = this.handleSizesAndCrc(l, l2, zip64Mode);
        this.closeEntry(bl, false);
        this.streamCompressor.reset();
    }

    private void closeCopiedEntry(boolean bl) throws IOException {
        this.preClose();
        this.entry.bytesRead = this.entry.entry.getSize();
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        boolean bl2 = this.checkIfNeedsZip64(zip64Mode);
        this.closeEntry(bl2, bl);
    }

    private void closeEntry(boolean bl, boolean bl2) throws IOException {
        if (!bl2 && this.channel != null) {
            this.rewriteSizesAndCrc(bl);
        }
        this.writeDataDescriptor(this.entry.entry);
        this.entry = null;
    }

    private void preClose() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry == null) {
            throw new IOException("No current entry to close");
        }
        if (!this.entry.hasWritten) {
            this.write(EMPTY, 0, 0);
        }
    }

    public void addRawArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStream inputStream) throws IOException {
        ZipArchiveEntry zipArchiveEntry2 = new ZipArchiveEntry(zipArchiveEntry);
        if (this.hasZip64Extra(zipArchiveEntry2)) {
            zipArchiveEntry2.removeExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        }
        boolean bl = zipArchiveEntry2.getCrc() != -1L && zipArchiveEntry2.getSize() != -1L && zipArchiveEntry2.getCompressedSize() != -1L;
        this.putArchiveEntry(zipArchiveEntry2, bl);
        this.copyFromZipInputStream(inputStream);
        this.closeCopiedEntry(bl);
    }

    private void flushDeflater() throws IOException {
        if (this.entry.entry.getMethod() == 8) {
            this.streamCompressor.flushDeflater();
        }
    }

    private boolean handleSizesAndCrc(long l, long l2, Zip64Mode zip64Mode) throws ZipException {
        if (this.entry.entry.getMethod() == 8) {
            this.entry.entry.setSize(this.entry.bytesRead);
            this.entry.entry.setCompressedSize(l);
            this.entry.entry.setCrc(l2);
        } else if (this.channel == null) {
            if (this.entry.entry.getCrc() != l2) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.entry.getName() + ": " + Long.toHexString(this.entry.entry.getCrc()) + " instead of " + Long.toHexString(l2));
            }
            if (this.entry.entry.getSize() != l) {
                throw new ZipException("bad size for entry " + this.entry.entry.getName() + ": " + this.entry.entry.getSize() + " instead of " + l);
            }
        } else {
            this.entry.entry.setSize(l);
            this.entry.entry.setCompressedSize(l);
            this.entry.entry.setCrc(l2);
        }
        return this.checkIfNeedsZip64(zip64Mode);
    }

    private boolean checkIfNeedsZip64(Zip64Mode zip64Mode) throws ZipException {
        boolean bl = this.isZip64Required(this.entry.entry, zip64Mode);
        if (bl && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(this.entry.entry));
        }
        return bl;
    }

    private boolean isZip64Required(ZipArchiveEntry zipArchiveEntry, Zip64Mode zip64Mode) {
        return zip64Mode == Zip64Mode.Always || this.isTooLageForZip32(zipArchiveEntry);
    }

    private boolean isTooLageForZip32(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getSize() >= 0xFFFFFFFFL || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL;
    }

    private void rewriteSizesAndCrc(boolean bl) throws IOException {
        long l = this.channel.position();
        this.channel.position(this.entry.localDataStart);
        this.writeOut(ZipLong.getBytes(this.entry.entry.getCrc()));
        if (!this.hasZip64Extra(this.entry.entry) || !bl) {
            this.writeOut(ZipLong.getBytes(this.entry.entry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(this.entry.entry.getSize()));
        } else {
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
        }
        if (this.hasZip64Extra(this.entry.entry)) {
            ByteBuffer byteBuffer = this.getName(this.entry.entry);
            int n = byteBuffer.limit() - byteBuffer.position();
            this.channel.position(this.entry.localDataStart + 12L + 4L + (long)n + 4L);
            this.writeOut(ZipEightByteInteger.getBytes(this.entry.entry.getSize()));
            this.writeOut(ZipEightByteInteger.getBytes(this.entry.entry.getCompressedSize()));
            if (!bl) {
                this.channel.position(this.entry.localDataStart - 10L);
                this.writeOut(ZipShort.getBytes(10));
                this.entry.entry.removeExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
                this.entry.entry.setExtra();
                if (this.entry.causedUseOfZip64) {
                    this.hasUsedZip64 = false;
                }
            }
        }
        this.channel.position(l);
    }

    @Override
    public void putArchiveEntry(ArchiveEntry archiveEntry) throws IOException {
        this.putArchiveEntry(archiveEntry, false);
    }

    private void putArchiveEntry(ArchiveEntry archiveEntry, boolean bl) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry != null) {
            this.closeArchiveEntry();
        }
        this.entry = new CurrentEntry((ZipArchiveEntry)archiveEntry);
        this.entries.add(this.entry.entry);
        this.setDefaults(this.entry.entry);
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        this.validateSizeInformation(zip64Mode);
        if (this.shouldAddZip64Extra(this.entry.entry, zip64Mode)) {
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(this.entry.entry);
            ZipEightByteInteger zipEightByteInteger = ZipEightByteInteger.ZERO;
            ZipEightByteInteger zipEightByteInteger2 = ZipEightByteInteger.ZERO;
            if (bl) {
                zipEightByteInteger = new ZipEightByteInteger(this.entry.entry.getSize());
                zipEightByteInteger2 = new ZipEightByteInteger(this.entry.entry.getCompressedSize());
            } else if (this.entry.entry.getMethod() == 0 && this.entry.entry.getSize() != -1L) {
                zipEightByteInteger2 = zipEightByteInteger = new ZipEightByteInteger(this.entry.entry.getSize());
            }
            zip64ExtendedInformationExtraField.setSize(zipEightByteInteger);
            zip64ExtendedInformationExtraField.setCompressedSize(zipEightByteInteger2);
            this.entry.entry.setExtra();
        }
        if (this.entry.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader((ZipArchiveEntry)archiveEntry, bl);
    }

    private void setDefaults(ZipArchiveEntry zipArchiveEntry) {
        if (zipArchiveEntry.getMethod() == -1) {
            zipArchiveEntry.setMethod(this.method);
        }
        if (zipArchiveEntry.getTime() == -1L) {
            zipArchiveEntry.setTime(System.currentTimeMillis());
        }
    }

    private void validateSizeInformation(Zip64Mode zip64Mode) throws ZipException {
        if (this.entry.entry.getMethod() == 0 && this.channel == null) {
            if (this.entry.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.entry.setCompressedSize(this.entry.entry.getSize());
        }
        if ((this.entry.entry.getSize() >= 0xFFFFFFFFL || this.entry.entry.getCompressedSize() >= 0xFFFFFFFFL) && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(this.entry.entry));
        }
    }

    private boolean shouldAddZip64Extra(ZipArchiveEntry zipArchiveEntry, Zip64Mode zip64Mode) {
        return zip64Mode == Zip64Mode.Always || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() == -1L && this.channel != null && zip64Mode != Zip64Mode.Never;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setLevel(int n) {
        if (n < -1 || n > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n);
        }
        this.hasCompressionLevelChanged = this.level != n;
        this.level = n;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    @Override
    public boolean canWriteEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            return zipArchiveEntry.getMethod() != ZipMethod.IMPLODING.getCode() && zipArchiveEntry.getMethod() != ZipMethod.UNSHRINKING.getCode() && ZipUtil.canHandleEntryData(zipArchiveEntry);
        }
        return false;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException("No current entry");
        }
        ZipUtil.checkRequestedFeatures(this.entry.entry);
        long l = this.streamCompressor.write(byArray, n, n2, this.entry.entry.getMethod());
        this.count(l);
    }

    private void writeCounted(byte[] byArray) throws IOException {
        this.streamCompressor.writeCounted(byArray);
    }

    private void copyFromZipInputStream(InputStream inputStream) throws IOException {
        int n;
        if (this.entry == null) {
            throw new IllegalStateException("No current entry");
        }
        ZipUtil.checkRequestedFeatures(this.entry.entry);
        this.entry.hasWritten = true;
        while ((n = inputStream.read(this.copyBuffer)) >= 0) {
            this.streamCompressor.writeCounted(this.copyBuffer, 0, n);
            this.count(n);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        this.destroy();
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        this.streamCompressor.deflate();
    }

    protected void writeLocalFileHeader(ZipArchiveEntry zipArchiveEntry) throws IOException {
        this.writeLocalFileHeader(zipArchiveEntry, false);
    }

    private void writeLocalFileHeader(ZipArchiveEntry zipArchiveEntry, boolean bl) throws IOException {
        boolean bl2 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        ByteBuffer byteBuffer = this.getName(zipArchiveEntry);
        if (this.createUnicodeExtraFields != UnicodeExtraFieldPolicy.NEVER) {
            this.addUnicodeExtraFields(zipArchiveEntry, bl2, byteBuffer);
        }
        byte[] byArray = this.createLocalFileHeader(zipArchiveEntry, byteBuffer, bl2, bl);
        long l = this.streamCompressor.getTotalBytesWritten();
        this.offsets.put(zipArchiveEntry, l);
        this.entry.localDataStart = l + 14L;
        this.writeCounted(byArray);
        this.entry.dataStart = this.streamCompressor.getTotalBytesWritten();
    }

    private byte[] createLocalFileHeader(ZipArchiveEntry zipArchiveEntry, ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        byte[] byArray = zipArchiveEntry.getLocalFileDataExtra();
        int n = byteBuffer.limit() - byteBuffer.position();
        int n2 = 30 + n + byArray.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(LFH_SIG, 0, byArray2, 0, 4);
        int n3 = zipArchiveEntry.getMethod();
        if (bl2 && !this.isZip64Required(this.entry.entry, this.zip64Mode)) {
            ZipShort.putShort(10, byArray2, 4);
        } else {
            ZipShort.putShort(this.versionNeededToExtract(n3, this.hasZip64Extra(zipArchiveEntry)), byArray2, 4);
        }
        GeneralPurposeBit generalPurposeBit = this.getGeneralPurposeBits(n3, !bl && this.fallbackToUTF8);
        generalPurposeBit.encode(byArray2, 6);
        ZipShort.putShort(n3, byArray2, 8);
        ZipUtil.toDosTime(this.calendarInstance, zipArchiveEntry.getTime(), byArray2, 10);
        if (bl2) {
            ZipLong.putLong(zipArchiveEntry.getCrc(), byArray2, 14);
        } else if (n3 == 8 || this.channel != null) {
            System.arraycopy(LZERO, 0, byArray2, 14, 4);
        } else {
            ZipLong.putLong(zipArchiveEntry.getCrc(), byArray2, 14);
        }
        if (this.hasZip64Extra(this.entry.entry)) {
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 18);
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 22);
        } else if (bl2) {
            ZipLong.putLong(zipArchiveEntry.getCompressedSize(), byArray2, 18);
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 22);
        } else if (n3 == 8 || this.channel != null) {
            System.arraycopy(LZERO, 0, byArray2, 18, 4);
            System.arraycopy(LZERO, 0, byArray2, 22, 4);
        } else {
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 18);
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 22);
        }
        ZipShort.putShort(n, byArray2, 26);
        ZipShort.putShort(byArray.length, byArray2, 28);
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray2, 30, n);
        System.arraycopy(byArray, 0, byArray2, 30 + n, byArray.length);
        return byArray2;
    }

    private void addUnicodeExtraFields(ZipArchiveEntry zipArchiveEntry, boolean bl, ByteBuffer byteBuffer) throws IOException {
        String string;
        if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !bl) {
            zipArchiveEntry.addExtraField(new UnicodePathExtraField(zipArchiveEntry.getName(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.position()));
        }
        if ((string = zipArchiveEntry.getComment()) != null && !"".equals(string)) {
            boolean bl2 = this.zipEncoding.canEncode(string);
            if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !bl2) {
                ByteBuffer byteBuffer2 = this.getEntryEncoding(zipArchiveEntry).encode(string);
                zipArchiveEntry.addExtraField(new UnicodeCommentExtraField(string, byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit() - byteBuffer2.position()));
            }
        }
    }

    protected void writeDataDescriptor(ZipArchiveEntry zipArchiveEntry) throws IOException {
        if (zipArchiveEntry.getMethod() != 8 || this.channel != null) {
            return;
        }
        this.writeCounted(DD_SIG);
        this.writeCounted(ZipLong.getBytes(zipArchiveEntry.getCrc()));
        if (!this.hasZip64Extra(zipArchiveEntry)) {
            this.writeCounted(ZipLong.getBytes(zipArchiveEntry.getCompressedSize()));
            this.writeCounted(ZipLong.getBytes(zipArchiveEntry.getSize()));
        } else {
            this.writeCounted(ZipEightByteInteger.getBytes(zipArchiveEntry.getCompressedSize()));
            this.writeCounted(ZipEightByteInteger.getBytes(zipArchiveEntry.getSize()));
        }
    }

    protected void writeCentralFileHeader(ZipArchiveEntry zipArchiveEntry) throws IOException {
        byte[] byArray = this.createCentralFileHeader(zipArchiveEntry);
        this.writeCounted(byArray);
    }

    private byte[] createCentralFileHeader(ZipArchiveEntry zipArchiveEntry) throws IOException {
        boolean bl;
        long l = this.offsets.get(zipArchiveEntry);
        boolean bl2 = bl = this.hasZip64Extra(zipArchiveEntry) || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || l >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always;
        if (bl && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        this.handleZip64Extra(zipArchiveEntry, l, bl);
        return this.createCentralFileHeader(zipArchiveEntry, this.getName(zipArchiveEntry), l, bl);
    }

    private byte[] createCentralFileHeader(ZipArchiveEntry zipArchiveEntry, ByteBuffer byteBuffer, long l, boolean bl) throws IOException {
        byte[] byArray = zipArchiveEntry.getCentralDirectoryExtra();
        String string = zipArchiveEntry.getComment();
        if (string == null) {
            string = "";
        }
        ByteBuffer byteBuffer2 = this.getEntryEncoding(zipArchiveEntry).encode(string);
        int n = byteBuffer.limit() - byteBuffer.position();
        int n2 = byteBuffer2.limit() - byteBuffer2.position();
        int n3 = 46 + n + byArray.length + n2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(CFH_SIG, 0, byArray2, 0, 4);
        ZipShort.putShort(zipArchiveEntry.getPlatform() << 8 | (!this.hasUsedZip64 ? 20 : 45), byArray2, 4);
        int n4 = zipArchiveEntry.getMethod();
        boolean bl2 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        ZipShort.putShort(this.versionNeededToExtract(n4, bl), byArray2, 6);
        this.getGeneralPurposeBits(n4, !bl2 && this.fallbackToUTF8).encode(byArray2, 8);
        ZipShort.putShort(n4, byArray2, 10);
        ZipUtil.toDosTime(this.calendarInstance, zipArchiveEntry.getTime(), byArray2, 12);
        ZipLong.putLong(zipArchiveEntry.getCrc(), byArray2, 16);
        if (zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 20);
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 24);
        } else {
            ZipLong.putLong(zipArchiveEntry.getCompressedSize(), byArray2, 20);
            ZipLong.putLong(zipArchiveEntry.getSize(), byArray2, 24);
        }
        ZipShort.putShort(n, byArray2, 28);
        ZipShort.putShort(byArray.length, byArray2, 30);
        ZipShort.putShort(n2, byArray2, 32);
        System.arraycopy(ZERO, 0, byArray2, 34, 2);
        ZipShort.putShort(zipArchiveEntry.getInternalAttributes(), byArray2, 36);
        ZipLong.putLong(zipArchiveEntry.getExternalAttributes(), byArray2, 38);
        if (l >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
            ZipLong.putLong(0xFFFFFFFFL, byArray2, 42);
        } else {
            ZipLong.putLong(Math.min(l, 0xFFFFFFFFL), byArray2, 42);
        }
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray2, 46, n);
        int n5 = 46 + n;
        System.arraycopy(byArray, 0, byArray2, n5, byArray.length);
        int n6 = n5 + byArray.length;
        System.arraycopy(byteBuffer2.array(), byteBuffer2.arrayOffset(), byArray2, n6, n2);
        return byArray2;
    }

    private void handleZip64Extra(ZipArchiveEntry zipArchiveEntry, long l, boolean bl) {
        if (bl) {
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(zipArchiveEntry);
            if (zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipArchiveEntry.getCompressedSize()));
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipArchiveEntry.getSize()));
            } else {
                zip64ExtendedInformationExtraField.setCompressedSize(null);
                zip64ExtendedInformationExtraField.setSize(null);
            }
            if (l >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
                zip64ExtendedInformationExtraField.setRelativeHeaderOffset(new ZipEightByteInteger(l));
            }
            zipArchiveEntry.setExtra();
        }
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeCounted(EOCD_SIG);
        this.writeCounted(ZERO);
        this.writeCounted(ZERO);
        int n = this.entries.size();
        if (n > 65535 && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive contains more than 65535 entries.");
        }
        if (this.cdOffset > 0xFFFFFFFFL && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        byte[] byArray = ZipShort.getBytes(Math.min(n, 65535));
        this.writeCounted(byArray);
        this.writeCounted(byArray);
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdLength, 0xFFFFFFFFL)));
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdOffset, 0xFFFFFFFFL)));
        ByteBuffer byteBuffer = this.zipEncoding.encode(this.comment);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        this.writeCounted(ZipShort.getBytes(n2));
        this.streamCompressor.writeCounted(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
    }

    protected void writeZip64CentralDirectory() throws IOException {
        if (this.zip64Mode == Zip64Mode.Never) {
            return;
        }
        if (!(this.hasUsedZip64 || this.cdOffset < 0xFFFFFFFFL && this.cdLength < 0xFFFFFFFFL && this.entries.size() < 65535)) {
            this.hasUsedZip64 = true;
        }
        if (!this.hasUsedZip64) {
            return;
        }
        long l = this.streamCompressor.getTotalBytesWritten();
        this.writeOut(ZIP64_EOCD_SIG);
        this.writeOut(ZipEightByteInteger.getBytes(44L));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(LZERO);
        this.writeOut(LZERO);
        byte[] byArray = ZipEightByteInteger.getBytes(this.entries.size());
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(ZipEightByteInteger.getBytes(this.cdLength));
        this.writeOut(ZipEightByteInteger.getBytes(this.cdOffset));
        this.writeOut(ZIP64_EOCD_LOC_SIG);
        this.writeOut(LZERO);
        this.writeOut(ZipEightByteInteger.getBytes(l));
        this.writeOut(ONE);
    }

    protected final void writeOut(byte[] byArray) throws IOException {
        this.streamCompressor.writeOut(byArray, 0, byArray.length);
    }

    protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
        this.streamCompressor.writeOut(byArray, n, n2);
    }

    private GeneralPurposeBit getGeneralPurposeBits(int n, boolean bl) {
        GeneralPurposeBit generalPurposeBit = new GeneralPurposeBit();
        generalPurposeBit.useUTF8ForNames(this.useUTF8Flag || bl);
        if (this.isDeflatedToOutputStream(n)) {
            generalPurposeBit.useDataDescriptor(true);
        }
        return generalPurposeBit;
    }

    private int versionNeededToExtract(int n, boolean bl) {
        if (bl) {
            return 45;
        }
        return this.isDeflatedToOutputStream(n) ? 20 : 10;
    }

    private boolean isDeflatedToOutputStream(int n) {
        return n == 8 && this.channel == null;
    }

    @Override
    public ArchiveEntry createArchiveEntry(File file, String string) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new ZipArchiveEntry(file, string);
    }

    private Zip64ExtendedInformationExtraField getZip64Extra(ZipArchiveEntry zipArchiveEntry) {
        if (this.entry != null) {
            this.entry.causedUseOfZip64 = !this.hasUsedZip64;
        }
        this.hasUsedZip64 = true;
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField == null) {
            zip64ExtendedInformationExtraField = new Zip64ExtendedInformationExtraField();
        }
        zipArchiveEntry.addAsFirstExtraField(zip64ExtendedInformationExtraField);
        return zip64ExtendedInformationExtraField;
    }

    private boolean hasZip64Extra(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID) != null;
    }

    private Zip64Mode getEffectiveZip64Mode(ZipArchiveEntry zipArchiveEntry) {
        if (this.zip64Mode != Zip64Mode.AsNeeded || this.channel != null || zipArchiveEntry.getMethod() != 8 || zipArchiveEntry.getSize() != -1L) {
            return this.zip64Mode;
        }
        return Zip64Mode.Never;
    }

    private ZipEncoding getEntryEncoding(ZipArchiveEntry zipArchiveEntry) {
        boolean bl = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        return !bl && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
    }

    private ByteBuffer getName(ZipArchiveEntry zipArchiveEntry) throws IOException {
        return this.getEntryEncoding(zipArchiveEntry).encode(zipArchiveEntry.getName());
    }

    void destroy() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    private static final class CurrentEntry {
        private final ZipArchiveEntry entry;
        private long localDataStart = 0L;
        private long dataStart = 0L;
        private long bytesRead = 0L;
        private boolean causedUseOfZip64 = false;
        private boolean hasWritten;

        private CurrentEntry(ZipArchiveEntry zipArchiveEntry) {
            this.entry = zipArchiveEntry;
        }
    }

    public static final class UnicodeExtraFieldPolicy {
        public static final UnicodeExtraFieldPolicy ALWAYS = new UnicodeExtraFieldPolicy("always");
        public static final UnicodeExtraFieldPolicy NEVER = new UnicodeExtraFieldPolicy("never");
        public static final UnicodeExtraFieldPolicy NOT_ENCODEABLE = new UnicodeExtraFieldPolicy("not encodeable");
        private final String name;

        private UnicodeExtraFieldPolicy(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

