/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class BitInputStream
implements Closeable {
    private static final int MAXIMUM_CACHE_SIZE = 63;
    private static final long[] MASKS = new long[64];
    private final InputStream in;
    private final ByteOrder byteOrder;
    private long bitsCached = 0L;
    private int bitsCachedSize = 0;

    public BitInputStream(InputStream inputStream, ByteOrder byteOrder) {
        this.in = inputStream;
        this.byteOrder = byteOrder;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void clearBitCache() {
        this.bitsCached = 0L;
        this.bitsCachedSize = 0;
    }

    public long readBits(int n) throws IOException {
        long l;
        if (n < 0 || n > 63) {
            throw new IllegalArgumentException("count must not be negative or greater than 63");
        }
        while (this.bitsCachedSize < n && this.bitsCachedSize < 57) {
            long l2 = this.in.read();
            if (l2 < 0L) {
                return l2;
            }
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.bitsCached |= l2 << this.bitsCachedSize;
            } else {
                this.bitsCached <<= 8;
                this.bitsCached |= l2;
            }
            this.bitsCachedSize += 8;
        }
        int n2 = 0;
        long l3 = 0L;
        if (this.bitsCachedSize < n) {
            int n3 = n - this.bitsCachedSize;
            n2 = 8 - n3;
            long l4 = this.in.read();
            if (l4 < 0L) {
                return l4;
            }
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                long l5 = l4 & MASKS[n3];
                this.bitsCached |= l5 << this.bitsCachedSize;
                l3 = l4 >>> n3 & MASKS[n2];
            } else {
                this.bitsCached <<= n3;
                long l6 = l4 >>> n2 & MASKS[n3];
                this.bitsCached |= l6;
                l3 = l4 & MASKS[n2];
            }
            this.bitsCachedSize = n;
        }
        if (n2 == 0) {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                l = this.bitsCached & MASKS[n];
                this.bitsCached >>>= n;
            } else {
                l = this.bitsCached >> this.bitsCachedSize - n & MASKS[n];
            }
            this.bitsCachedSize -= n;
        } else {
            l = this.bitsCached & MASKS[n];
            this.bitsCached = l3;
            this.bitsCachedSize = n2;
        }
        return l;
    }

    static {
        for (int i = 1; i <= 63; ++i) {
            BitInputStream.MASKS[i] = (MASKS[i - 1] << 1) + 1L;
        }
    }
}

