/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.registry;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.osgi.registry.ProviderBundleTrackerCustomizer;
import org.apache.geronimo.osgi.registry.ProviderRegistryImpl;
import org.apache.geronimo.osgi.registry.api.ProviderRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    protected BundleTracker bt;
    protected ServiceTracker lst;
    protected ProviderRegistryImpl registry;
    protected ServiceRegistration registryRegistration;
    protected BundleContext context;
    List<LogService> logServices = new ArrayList<LogService>();

    public synchronized void start(BundleContext bundleContext) throws Exception {
        this.context = bundleContext;
        this.lst = new LogServiceTracker(bundleContext, LogService.class.getName(), null);
        this.lst.open();
        this.registry = new ProviderRegistryImpl(this);
        this.registryRegistration = bundleContext.registerService(ProviderRegistry.class.getName(), (Object)this.registry, null);
        this.bt = new BundleTracker(bundleContext, 32, (BundleTrackerCustomizer)new ProviderBundleTrackerCustomizer(this, bundleContext.getBundle(), this.registry));
        this.bt.open();
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        this.bt.close();
        this.lst.close();
        this.registryRegistration.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(int n, String string) {
        List<LogService> list = this.logServices;
        synchronized (list) {
            for (LogService logService : this.logServices) {
                logService.log(n, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(int n, String string, Throwable throwable) {
        List<LogService> list = this.logServices;
        synchronized (list) {
            for (LogService logService : this.logServices) {
                logService.log(n, string, throwable);
            }
        }
    }

    private final class LogServiceTracker
    extends ServiceTracker {
        private LogServiceTracker(BundleContext bundleContext, String string, ServiceTrackerCustomizer serviceTrackerCustomizer) {
            super(bundleContext, string, serviceTrackerCustomizer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference serviceReference) {
            Object object = super.addingService(serviceReference);
            if (object instanceof LogService) {
                List<LogService> list = Activator.this.logServices;
                synchronized (list) {
                    Activator.this.logServices.add((LogService)object);
                }
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference serviceReference, Object object) {
            List<LogService> list = Activator.this.logServices;
            synchronized (list) {
                Activator.this.logServices.remove(object);
            }
            super.removedService(serviceReference, object);
        }
    }
}

