/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.CollectionFuture;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.FutureFallback;
import com.google.common.util.concurrent.FuturesGetChecked;
import com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Platform;
import com.google.common.util.concurrent.SerializingExecutor;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Beta
@GwtCompatible(emulated=true)
public final class Futures
extends GwtFuturesCatchingSpecialization {
    private static final AsyncFunction<ListenableFuture<Object>, Object> DEREFERENCER = new AsyncFunction<ListenableFuture<Object>, Object>(){

        @Override
        public ListenableFuture<Object> apply(ListenableFuture<Object> listenableFuture) {
            return listenableFuture;
        }
    };

    private Futures() {
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(ListenableFuture<V> listenableFuture, Function<? super Exception, X> function) {
        return new MappingCheckedFuture<V, X>(Preconditions.checkNotNull(listenableFuture), function);
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V v) {
        if (v == null) {
            ImmediateSuccessfulFuture<Object> immediateSuccessfulFuture = ImmediateSuccessfulFuture.NULL;
            return immediateSuccessfulFuture;
        }
        return new ImmediateSuccessfulFuture<V>(v);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V v) {
        return new ImmediateSuccessfulCheckedFuture(v);
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFailedFuture(throwable);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        return new ImmediateCancelledFuture();
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(X x) {
        Preconditions.checkNotNull(x);
        return new ImmediateFailedCheckedFuture(x);
    }

    @Deprecated
    @CheckReturnValue
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> listenableFuture, FutureFallback<? extends V> futureFallback) {
        return Futures.withFallback(listenableFuture, futureFallback, MoreExecutors.directExecutor());
    }

    @Deprecated
    @CheckReturnValue
    public static <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> listenableFuture, FutureFallback<? extends V> futureFallback, Executor executor) {
        return Futures.catchingAsync(listenableFuture, Throwable.class, Futures.asAsyncFunction(futureFallback), executor);
    }

    @CheckReturnValue
    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function) {
        CatchingFuture<? extends V, ? super X> catchingFuture = new CatchingFuture<V, X>(listenableFuture, clazz, function);
        listenableFuture.addListener(catchingFuture, MoreExecutors.directExecutor());
        return catchingFuture;
    }

    @CheckReturnValue
    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        CatchingFuture<? extends V, ? super X> catchingFuture = new CatchingFuture<V, X>(listenableFuture, clazz, function);
        listenableFuture.addListener(catchingFuture, Futures.rejectionPropagatingExecutor(executor, catchingFuture));
        return catchingFuture;
    }

    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction) {
        AsyncCatchingFuture<? extends V, ? super X> asyncCatchingFuture = new AsyncCatchingFuture<V, X>(listenableFuture, clazz, asyncFunction);
        listenableFuture.addListener(asyncCatchingFuture, MoreExecutors.directExecutor());
        return asyncCatchingFuture;
    }

    @GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        AsyncCatchingFuture<? extends V, ? super X> asyncCatchingFuture = new AsyncCatchingFuture<V, X>(listenableFuture, clazz, asyncFunction);
        listenableFuture.addListener(asyncCatchingFuture, Futures.rejectionPropagatingExecutor(executor, asyncCatchingFuture));
        return asyncCatchingFuture;
    }

    @Deprecated
    static <V> AsyncFunction<Throwable, V> asAsyncFunction(final FutureFallback<V> futureFallback) {
        Preconditions.checkNotNull(futureFallback);
        return new AsyncFunction<Throwable, V>(){

            @Override
            public ListenableFuture<V> apply(Throwable throwable) throws Exception {
                return Preconditions.checkNotNull(futureFallback.create(throwable), "FutureFallback.create returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            }
        };
    }

    @CheckReturnValue
    @GwtIncompatible(value="java.util.concurrent.ScheduledExecutorService")
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> listenableFuture, long l, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        TimeoutFuture<V> timeoutFuture = new TimeoutFuture<V>(listenableFuture);
        TimeoutFuture.Fire<V> fire = new TimeoutFuture.Fire<V>(timeoutFuture);
        timeoutFuture.timer = scheduledExecutorService.schedule(fire, l, timeUnit);
        listenableFuture.addListener(fire, MoreExecutors.directExecutor());
        return timeoutFuture;
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction) {
        return Futures.transformAsync(listenableFuture, asyncFunction);
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        return Futures.transformAsync(listenableFuture, asyncFunction, executor);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction) {
        AsyncChainingFuture<? super I, ? extends O> asyncChainingFuture = new AsyncChainingFuture<I, O>(listenableFuture, asyncFunction);
        listenableFuture.addListener(asyncChainingFuture, MoreExecutors.directExecutor());
        return asyncChainingFuture;
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        Preconditions.checkNotNull(executor);
        AsyncChainingFuture<? super I, ? extends O> asyncChainingFuture = new AsyncChainingFuture<I, O>(listenableFuture, asyncFunction);
        listenableFuture.addListener(asyncChainingFuture, Futures.rejectionPropagatingExecutor(executor, asyncChainingFuture));
        return asyncChainingFuture;
    }

    private static Executor rejectionPropagatingExecutor(final Executor executor, final AbstractFuture<?> abstractFuture) {
        Preconditions.checkNotNull(executor);
        if (executor == MoreExecutors.directExecutor()) {
            return executor;
        }
        return new Executor(){
            volatile boolean thrownFromDelegate = true;

            @Override
            public void execute(final Runnable runnable) {
                block2: {
                    try {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                thrownFromDelegate = false;
                                runnable.run();
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        if (!this.thrownFromDelegate) break block2;
                        abstractFuture.setException(rejectedExecutionException);
                    }
                }
            }
        };
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(function);
        ChainingFuture<? super I, ? extends O> chainingFuture = new ChainingFuture<I, O>(listenableFuture, function);
        listenableFuture.addListener(chainingFuture, MoreExecutors.directExecutor());
        return chainingFuture;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        ChainingFuture<? super I, ? extends O> chainingFuture = new ChainingFuture<I, O>(listenableFuture, function);
        listenableFuture.addListener(chainingFuture, Futures.rejectionPropagatingExecutor(executor, chainingFuture));
        return chainingFuture;
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <I, O> Future<O> lazyTransform(final Future<I> future, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(future.get());
            }

            @Override
            public O get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(future.get(l, timeUnit));
            }

            private O applyTransformation(I i) throws ExecutionException {
                try {
                    return function.apply(i);
                }
                catch (Throwable throwable) {
                    throw new ExecutionException(throwable);
                }
            }
        };
    }

    @CheckReturnValue
    public static <V> ListenableFuture<V> dereference(ListenableFuture<? extends ListenableFuture<? extends V>> listenableFuture) {
        return Futures.transformAsync(listenableFuture, DEREFERENCER);
    }

    @SafeVarargs
    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), true);
    }

    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new ListFuture(ImmutableList.copyOf(iterable), true);
    }

    @CheckReturnValue
    @GwtIncompatible(value="TODO")
    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> listenableFuture) {
        return new NonCancellationPropagatingFuture<V>(listenableFuture);
    }

    @SafeVarargs
    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), false);
    }

    @CheckReturnValue
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new ListFuture(ImmutableList.copyOf(iterable), false);
    }

    @CheckReturnValue
    @Beta
    @GwtIncompatible(value="TODO")
    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> iterable) {
        final ConcurrentLinkedQueue concurrentLinkedQueue = Queues.newConcurrentLinkedQueue();
        ImmutableList.Builder builder = ImmutableList.builder();
        SerializingExecutor serializingExecutor = new SerializingExecutor(MoreExecutors.directExecutor());
        for (final ListenableFuture<T> listenableFuture : iterable) {
            SettableFuture settableFuture = SettableFuture.create();
            concurrentLinkedQueue.add(settableFuture);
            listenableFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    ((SettableFuture)concurrentLinkedQueue.remove()).setFuture(listenableFuture);
                }
            }, serializingExecutor);
            builder.add(settableFuture);
        }
        return builder.build();
    }

    public static <V> void addCallback(ListenableFuture<V> listenableFuture, FutureCallback<? super V> futureCallback) {
        Futures.addCallback(listenableFuture, futureCallback, MoreExecutors.directExecutor());
    }

    public static <V> void addCallback(final ListenableFuture<V> listenableFuture, final FutureCallback<? super V> futureCallback, Executor executor) {
        Preconditions.checkNotNull(futureCallback);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object v;
                try {
                    v = Uninterruptibles.getUninterruptibly(listenableFuture);
                }
                catch (ExecutionException executionException) {
                    futureCallback.onFailure(executionException.getCause());
                    return;
                }
                catch (RuntimeException runtimeException) {
                    futureCallback.onFailure(runtimeException);
                    return;
                }
                catch (Error error) {
                    futureCallback.onFailure(error);
                    return;
                }
                futureCallback.onSuccess(v);
            }
        };
        listenableFuture.addListener(runnable, executor);
    }

    @Deprecated
    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V get(Future<V> future, Class<X> clazz) throws X {
        return Futures.getChecked(future, clazz);
    }

    @Deprecated
    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V get(Future<V> future, long l, TimeUnit timeUnit, Class<X> clazz) throws X {
        return Futures.getChecked(future, clazz, l, timeUnit);
    }

    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz) throws X {
        return FuturesGetChecked.getChecked(future, clazz);
    }

    @GwtIncompatible(value="reflection")
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz, long l, TimeUnit timeUnit) throws X {
        return FuturesGetChecked.getChecked(future, clazz, l, timeUnit);
    }

    @GwtIncompatible(value="TODO")
    public static <V> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException executionException) {
            Futures.wrapAndThrowUnchecked(executionException.getCause());
            throw new AssertionError();
        }
    }

    @GwtIncompatible(value="TODO")
    private static void wrapAndThrowUnchecked(Throwable throwable) {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        throw new UncheckedExecutionException(throwable);
    }

    @GwtIncompatible(value="TODO")
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<? super Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> listenableFuture, Function<? super Exception, X> function) {
            super(listenableFuture);
            this.mapper = Preconditions.checkNotNull(function);
        }

        @Override
        protected X mapException(Exception exception) {
            return (X)((Exception)this.mapper.apply(exception));
        }
    }

    private static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
            this.init(new ListFutureRunningState(immutableCollection, bl));
        }

        private final class ListFutureRunningState
        extends CollectionFuture.CollectionFutureRunningState {
            ListFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
                super(immutableCollection, bl);
            }

            public List<V> combine(List<Optional<V>> list) {
                ArrayList<Object> arrayList = Lists.newArrayList();
                for (Optional optional : list) {
                    arrayList.add(optional != null ? (Object)optional.orNull() : null);
                }
                return Collections.unmodifiableList(arrayList);
            }
        }
    }

    @GwtIncompatible(value="TODO")
    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        NonCancellationPropagatingFuture(final ListenableFuture<V> listenableFuture) {
            listenableFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    NonCancellationPropagatingFuture.this.setFuture(listenableFuture);
                }
            }, MoreExecutors.directExecutor());
        }
    }

    private static final class ChainingFuture<I, O>
    extends AbstractChainingFuture<I, O, Function<? super I, ? extends O>> {
        ChainingFuture(ListenableFuture<? extends I> listenableFuture, Function<? super I, ? extends O> function) {
            super(listenableFuture, function);
        }

        @Override
        void doTransform(Function<? super I, ? extends O> function, I i) {
            this.set(function.apply(i));
        }
    }

    private static final class AsyncChainingFuture<I, O>
    extends AbstractChainingFuture<I, O, AsyncFunction<? super I, ? extends O>> {
        AsyncChainingFuture(ListenableFuture<? extends I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction) {
            super(listenableFuture, asyncFunction);
        }

        @Override
        void doTransform(AsyncFunction<? super I, ? extends O> asyncFunction, I i) throws Exception {
            ListenableFuture<? extends O> listenableFuture = asyncFunction.apply(i);
            Preconditions.checkNotNull(listenableFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            this.setFuture(listenableFuture);
        }
    }

    private static abstract class AbstractChainingFuture<I, O, F>
    extends AbstractFuture.TrustedFuture<O>
    implements Runnable {
        @Nullable
        ListenableFuture<? extends I> inputFuture;
        @Nullable
        F function;

        AbstractChainingFuture(ListenableFuture<? extends I> listenableFuture, F f) {
            this.inputFuture = Preconditions.checkNotNull(listenableFuture);
            this.function = Preconditions.checkNotNull(f);
        }

        @Override
        public final void run() {
            try {
                I i;
                ListenableFuture<? extends I> listenableFuture = this.inputFuture;
                F f = this.function;
                if (this.isCancelled() | listenableFuture == null | f == null) {
                    return;
                }
                this.inputFuture = null;
                this.function = null;
                try {
                    i = Uninterruptibles.getUninterruptibly(listenableFuture);
                }
                catch (CancellationException cancellationException) {
                    this.cancel(false);
                    return;
                }
                catch (ExecutionException executionException) {
                    this.setException(executionException.getCause());
                    return;
                }
                this.doTransform(f, i);
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                this.setException(undeclaredThrowableException.getCause());
            }
            catch (Throwable throwable) {
                this.setException(throwable);
            }
        }

        abstract void doTransform(F var1, I var2) throws Exception;

        @Override
        final void done() {
            this.maybePropagateCancellation(this.inputFuture);
            this.inputFuture = null;
            this.function = null;
        }
    }

    private static final class TimeoutFuture<V>
    extends AbstractFuture.TrustedFuture<V> {
        @Nullable
        ListenableFuture<V> delegateRef;
        @Nullable
        Future<?> timer;

        TimeoutFuture(ListenableFuture<V> listenableFuture) {
            this.delegateRef = Preconditions.checkNotNull(listenableFuture);
        }

        @Override
        void done() {
            this.maybePropagateCancellation(this.delegateRef);
            Future<?> future = this.timer;
            if (future != null) {
                future.cancel(false);
            }
            this.delegateRef = null;
            this.timer = null;
        }

        private static final class Fire<V>
        implements Runnable {
            @Nullable
            TimeoutFuture<V> timeoutFutureRef;

            Fire(TimeoutFuture<V> timeoutFuture) {
                this.timeoutFutureRef = timeoutFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TimeoutFuture timeoutFuture = this.timeoutFutureRef;
                if (timeoutFuture == null) {
                    return;
                }
                ListenableFuture listenableFuture = timeoutFuture.delegateRef;
                if (listenableFuture == null) {
                    return;
                }
                this.timeoutFutureRef = null;
                if (listenableFuture.isDone()) {
                    timeoutFuture.setFuture(listenableFuture);
                } else {
                    try {
                        timeoutFuture.setException(new TimeoutException("Future timed out: " + listenableFuture));
                    }
                    finally {
                        listenableFuture.cancel(true);
                    }
                }
            }
        }
    }

    static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>> {
        CatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function) {
            super(listenableFuture, clazz, function);
        }

        @Override
        void doFallback(Function<? super X, ? extends V> function, X x) throws Exception {
            V v = function.apply(x);
            this.set(v);
        }
    }

    static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction) {
            super(listenableFuture, clazz, asyncFunction);
        }

        @Override
        void doFallback(AsyncFunction<? super X, ? extends V> asyncFunction, X x) throws Exception {
            ListenableFuture<? extends V> listenableFuture = asyncFunction.apply(x);
            Preconditions.checkNotNull(listenableFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            this.setFuture(listenableFuture);
        }
    }

    private static abstract class AbstractCatchingFuture<V, X extends Throwable, F>
    extends AbstractFuture.TrustedFuture<V>
    implements Runnable {
        @Nullable
        ListenableFuture<? extends V> inputFuture;
        @Nullable
        Class<X> exceptionType;
        @Nullable
        F fallback;

        AbstractCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, F f) {
            this.inputFuture = Preconditions.checkNotNull(listenableFuture);
            this.exceptionType = Preconditions.checkNotNull(clazz);
            this.fallback = Preconditions.checkNotNull(f);
        }

        @Override
        public final void run() {
            Throwable throwable;
            F f;
            Class<X> clazz;
            ListenableFuture<? extends V> listenableFuture = this.inputFuture;
            if (listenableFuture == null | (clazz = this.exceptionType) == null | (f = this.fallback) == null | this.isCancelled()) {
                return;
            }
            this.inputFuture = null;
            this.exceptionType = null;
            this.fallback = null;
            try {
                this.set(Uninterruptibles.getUninterruptibly(listenableFuture));
                return;
            }
            catch (ExecutionException executionException) {
                throwable = executionException.getCause();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            try {
                if (Platform.isInstanceOfThrowableClass(throwable, clazz)) {
                    Throwable throwable3 = throwable;
                    this.doFallback(f, throwable3);
                } else {
                    this.setException(throwable);
                }
            }
            catch (Throwable throwable4) {
                this.setException(throwable4);
            }
        }

        abstract void doFallback(F var1, X var2) throws Exception;

        @Override
        final void done() {
            this.maybePropagateCancellation(this.inputFuture);
            this.inputFuture = null;
            this.exceptionType = null;
            this.fallback = null;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateFailedCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        private final X thrown;

        ImmediateFailedCheckedFuture(X x) {
            this.thrown = x;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException((Throwable)this.thrown);
        }

        @Override
        public V checkedGet() throws X {
            throw this.thrown;
        }

        @Override
        public V checkedGet(long l, TimeUnit timeUnit) throws X {
            Preconditions.checkNotNull(timeUnit);
            throw this.thrown;
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateCancelledFuture<V>
    extends ImmediateFuture<V> {
        private final CancellationException thrown = new CancellationException("Immediate cancelled future.");

        ImmediateCancelledFuture() {
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public V get() {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", this.thrown);
        }
    }

    private static class ImmediateFailedFuture<V>
    extends ImmediateFuture<V> {
        private final Throwable thrown;

        ImmediateFailedFuture(Throwable throwable) {
            this.thrown = throwable;
        }

        @Override
        public V get() throws ExecutionException {
            throw new ExecutionException(this.thrown);
        }
    }

    @GwtIncompatible(value="TODO")
    private static class ImmediateSuccessfulCheckedFuture<V, X extends Exception>
    extends ImmediateFuture<V>
    implements CheckedFuture<V, X> {
        @Nullable
        private final V value;

        ImmediateSuccessfulCheckedFuture(@Nullable V v) {
            this.value = v;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public V checkedGet() {
            return this.value;
        }

        @Override
        public V checkedGet(long l, TimeUnit timeUnit) {
            Preconditions.checkNotNull(timeUnit);
            return this.value;
        }
    }

    private static class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        static final ImmediateSuccessfulFuture<Object> NULL = new ImmediateSuccessfulFuture<Object>(null);
        @Nullable
        private final V value;

        ImmediateSuccessfulFuture(@Nullable V v) {
            this.value = v;
        }

        @Override
        public V get() {
            return this.value;
        }
    }

    private static abstract class ImmediateFuture<V>
    implements ListenableFuture<V> {
        private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

        private ImmediateFuture() {
        }

        @Override
        public void addListener(Runnable runnable, Executor executor) {
            Preconditions.checkNotNull(runnable, "Runnable was null.");
            Preconditions.checkNotNull(executor, "Executor was null.");
            try {
                executor.execute(runnable);
            }
            catch (RuntimeException runtimeException) {
                log.log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, runtimeException);
            }
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public abstract V get() throws ExecutionException;

        @Override
        public V get(long l, TimeUnit timeUnit) throws ExecutionException {
            Preconditions.checkNotNull(timeUnit);
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

